/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.ArrayList;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;

public abstract class PointerTarget
implements Serializable {
    static final long serialVersionUID = 3230195199146939027L;
    private transient PointerTarget[] _pointerTargets;

    protected PointerTarget() {
    }

    public abstract POS getPOS();

    public abstract Pointer[] getPointers();

    public abstract String toString();

    public boolean equals(Object object) {
        return object instanceof PointerTarget && ((PointerTarget)object).getPOS().equals(this.getPOS());
    }

    public Pointer[] getPointers(PointerType pointerType) {
        ArrayList<Pointer> arrayList = new ArrayList<Pointer>();
        Pointer[] pointerArray = this.getPointers();
        int n = 0;
        while (n < pointerArray.length) {
            if (pointerArray[n].getType().equals(pointerType)) {
                arrayList.add(pointerArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Pointer[arrayList.size()]);
    }

    public PointerTarget[] getTargets() throws JWNLException {
        if (this._pointerTargets == null) {
            this._pointerTargets = this.collectTargets(this.getPointers());
        }
        return this._pointerTargets;
    }

    public PointerTarget[] getTargets(PointerType pointerType) throws JWNLException {
        return this.collectTargets(this.getPointers(pointerType));
    }

    private PointerTarget[] collectTargets(Pointer[] pointerArray) throws JWNLException {
        PointerTarget[] pointerTargetArray = new PointerTarget[pointerArray.length];
        int n = 0;
        while (n < pointerArray.length) {
            pointerTargetArray[n] = pointerArray[n].getTarget();
            ++n;
        }
        return pointerTargetArray;
    }
}

