/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.pipe.PipeOutputAccumulator;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.FeatureSequence;
import edu.umass.cs.mallet.base.types.FeatureVector;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.Sequence;
import edu.umass.cs.mallet.base.types.Token;
import edu.umass.cs.mallet.base.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class TokenSequence
implements PipeOutputAccumulator,
Sequence,
Serializable {
    ArrayList tokens;
    PropertyList properties = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TokenSequence(Collection tokens) {
        this.tokens = new ArrayList(tokens);
    }

    public TokenSequence() {
        this.tokens = new ArrayList();
    }

    public TokenSequence(int capacity) {
        this.tokens = new ArrayList(capacity);
    }

    public TokenSequence(Token[] tokens) {
        this(tokens.length);
        int i = 0;
        while (i < tokens.length) {
            this.add(tokens[i]);
            ++i;
        }
    }

    public TokenSequence(Object[] tokens) {
        this(tokens.length);
        int i = 0;
        while (i < tokens.length) {
            this.add(new Token(tokens[i].toString()));
            ++i;
        }
    }

    public int size() {
        return this.tokens.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TokenSequence " + super.toString() + "\n");
        int i = 0;
        while (i < this.tokens.size()) {
            String tt = this.getToken(i).toString();
            sb.append("Token#" + i + ":");
            sb.append(tt);
            if (!tt.endsWith("\n")) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public Token getToken(int i) {
        return (Token)this.tokens.get(i);
    }

    public Object get(int i) {
        return this.tokens.get(i);
    }

    public void add(Object o) {
        if (o instanceof Token) {
            this.add((Token)o);
        } else if (o instanceof TokenSequence) {
            this.add((TokenSequence)o);
        } else {
            this.add(new Token(o.toString()));
        }
    }

    public void add(Token t) {
        this.tokens.add(t);
    }

    public Object remove(int index) {
        return this.tokens.remove(index);
    }

    public Object removeLastToken() {
        if (this.tokens.size() > 0) {
            return this.tokens.remove(this.tokens.size() - 1);
        }
        return null;
    }

    public void addAll(TokenSequence ts) {
        int i = 0;
        while (i < ts.size()) {
            this.add(ts.getToken(i));
            ++i;
        }
    }

    public void addAll(Token[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            this.add(tokens[i]);
            ++i;
        }
    }

    public void addAll(Object[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i] instanceof Token) {
                this.add((Token)tokens[i]);
            } else {
                this.add(new Token(tokens[i].toString()));
            }
            ++i;
        }
    }

    public Iterator iterator() {
        return this.tokens.iterator();
    }

    public void pipeOutputAccumulate(Instance carrier, Pipe iteratedPipe) {
        Object data = carrier.getData();
        if (!(data instanceof Token)) {
            throw new IllegalArgumentException("TokenSequence can only accumulator Token's");
        }
        this.add((Token)data);
    }

    public PipeOutputAccumulator clonePipeOutputAccumulator() {
        TokenSequence ret = new TokenSequence(this.tokens);
        ret.properties = this.properties;
        return ret;
    }

    public FeatureSequence toFeatureSequence(Alphabet dict) {
        FeatureSequence fs = new FeatureSequence(dict, this.tokens.size());
        int i = 0;
        while (i < this.tokens.size()) {
            fs.add(dict.lookupIndex(((Token)this.tokens.get(i)).getText()));
            ++i;
        }
        return fs;
    }

    public FeatureVector toFeatureVector(Alphabet dict) {
        return new FeatureVector(this.toFeatureSequence(dict));
    }

    public void setNumericProperty(String key, double value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public void setProperty(String key, Object value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public double getNumericProperty(String key) {
        return this.properties.lookupNumber(key);
    }

    public Object getProperty(String key) {
        return this.properties.lookupObject(key);
    }

    public boolean hasProperty(String key) {
        return this.properties.hasProperty(key);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        in.defaultReadObject();
    }
}

