/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.Sequence;
import java.util.ArrayList;

public class ArraySequence
implements Sequence {
    Object[] data;

    public ArraySequence(ArrayList a) {
        this.data = new Object[a.size()];
        int i = 0;
        while (i < a.size()) {
            this.data[i] = a.get(i);
            ++i;
        }
    }

    public ArraySequence(Object[] a, boolean copy) {
        if (copy) {
            this.data = new Object[a.length];
            System.arraycopy(a, 0, this.data, 0, a.length);
        } else {
            this.data = a;
        }
    }

    public ArraySequence(Object[] a) {
        this(a, true);
    }

    protected ArraySequence(Sequence s, boolean copy) {
        if (s instanceof ArraySequence) {
            if (copy) {
                this.data = new Object[s.size()];
                System.arraycopy(((ArraySequence)s).data, 0, this.data, 0, this.data.length);
            } else {
                this.data = ((ArraySequence)s).data;
            }
        } else {
            this.data = new Object[s.size()];
            int i = 0;
            while (i < s.size()) {
                this.data[i] = s.get(i);
                ++i;
            }
        }
    }

    public Object get(int index) {
        return this.data[index];
    }

    public int size() {
        return this.data.length;
    }

    public String toString() {
        String toret = "";
        int i = 0;
        while (i < this.data.length) {
            toret = String.valueOf(toret) + " " + this.data[i];
            ++i;
        }
        return toret;
    }
}

