/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.maximize;

import edu.umass.cs.mallet.base.maximize.BackTrackLineSearch;
import edu.umass.cs.mallet.base.maximize.LineMaximizer;
import edu.umass.cs.mallet.base.maximize.Maximizable;
import edu.umass.cs.mallet.base.maximize.Maximizer;
import edu.umass.cs.mallet.base.maximize.OptimizerEvaluator;
import edu.umass.cs.mallet.base.types.MatrixOps;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.util.LinkedList;
import java.util.logging.Logger;

public class LimitedMemoryBFGS
implements Maximizer.ByGradient {
    final int maxIterations = 1000;
    private double tolerance = 1.0E-4;
    final double gradientTolerance = 0.001;
    final double eps = 1.0E-5;
    final int m = 4;
    private static Logger logger = MalletLogger.getLogger("edu.umass.cs.mallet.base.ml.maximize.LimitedMemoryBFGS");
    LineMaximizer.ByGradient lineMaximizer = new BackTrackLineSearch();
    double[] g;
    double[] oldg;
    double[] direction;
    double[] parameters;
    double[] oldParameters;
    LinkedList s = new LinkedList();
    LinkedList y = new LinkedList();
    LinkedList rho = new LinkedList();
    double[] alpha;
    static double step = 1.0;
    int iterations;
    private OptimizerEvaluator eval = null;

    public void setTolerance(double newtol) {
        this.tolerance = newtol;
    }

    public void setEvaluator(OptimizerEvaluator eval) {
        this.eval = eval;
    }

    public boolean maximize(Maximizable.ByGradient maxable) {
        return this.maximize(maxable, Integer.MAX_VALUE);
    }

    public boolean maximize(Maximizable.ByGradient maxable, int numIterations) {
        double initialValue = maxable.getValue();
        logger.fine("Entering L-BFGS.maximize(). Initial Value=" + initialValue);
        if (this.g == null) {
            logger.fine("First time through L-BFGS");
            this.iterations = 0;
            this.s = new LinkedList();
            this.y = new LinkedList();
            this.rho = new LinkedList();
            this.alpha = new double[4];
            int i = 0;
            while (i < 4) {
                this.alpha[i] = 0.0;
                ++i;
            }
            this.parameters = new double[maxable.getNumParameters()];
            this.oldParameters = new double[maxable.getNumParameters()];
            this.g = new double[maxable.getNumParameters()];
            this.oldg = new double[maxable.getNumParameters()];
            this.direction = new double[maxable.getNumParameters()];
            maxable.getParameters(this.parameters);
            System.arraycopy(this.parameters, 0, this.oldParameters, 0, this.parameters.length);
            maxable.getValueGradient(this.g);
            System.arraycopy(this.g, 0, this.oldg, 0, this.g.length);
            System.arraycopy(this.g, 0, this.direction, 0, this.g.length);
            if (MatrixOps.absNormalize(this.direction) == 0.0) {
                logger.info("L-BFGS initial gradient is zero; saying converged");
                this.g = null;
                return true;
            }
            logger.fine("direction.2norm: " + MatrixOps.twoNorm(this.direction));
            MatrixOps.timesEquals(this.direction, MatrixOps.twoNorm(this.direction));
            logger.fine("before initial jump: \ndirection.2norm: " + MatrixOps.twoNorm(this.direction) + " \ngradient.2norm: " + MatrixOps.twoNorm(this.g) + "\nparameters.2norm: " + MatrixOps.twoNorm(this.parameters));
            step = this.lineMaximizer.maximize(maxable, this.direction, step);
            if (step == 0.0) {
                this.g = null;
                throw new IllegalArgumentException("could not step in current direction");
            }
            maxable.getParameters(this.parameters);
            maxable.getValueGradient(this.g);
            logger.fine("after initial jump: \ndirection.2norm: " + MatrixOps.twoNorm(this.direction) + " \ngradient.2norm: " + MatrixOps.twoNorm(this.g));
        }
        int iterationCount = 0;
        while (iterationCount < numIterations) {
            double value = maxable.getValue();
            logger.fine("L-BFGS iteration=" + iterationCount + ", value=" + value + " g.twoNorm: " + MatrixOps.twoNorm(this.g) + " oldg.twoNorm: " + MatrixOps.twoNorm(this.oldg));
            double sy = 0.0;
            double yy = 0.0;
            int i = 0;
            while (i < this.oldParameters.length) {
                this.oldParameters[i] = Double.isInfinite(this.parameters[i]) && Double.isInfinite(this.oldParameters[i]) && this.parameters[i] * this.oldParameters[i] > 0.0 ? 0.0 : this.parameters[i] - this.oldParameters[i];
                this.oldg[i] = Double.isInfinite(this.g[i]) && Double.isInfinite(this.oldg[i]) && this.g[i] * this.oldg[i] > 0.0 ? 0.0 : this.g[i] - this.oldg[i];
                sy += this.oldParameters[i] * this.oldg[i];
                yy += this.oldg[i] * this.oldg[i];
                this.direction[i] = this.g[i];
                ++i;
            }
            if (sy > 0.0) {
                throw new IllegalStateException("sy = " + sy + " > 0");
            }
            double gamma = sy / yy;
            if (gamma > 0.0) {
                throw new IllegalStateException("gamma = " + gamma + " > 0");
            }
            this.push(this.rho, 1.0 / sy);
            this.push(this.s, this.oldParameters);
            this.push(this.y, this.oldg);
            assert (this.s.size() == this.y.size()) : "s.size: " + this.s.size() + " y.size: " + this.y.size();
            int i2 = this.s.size() - 1;
            while (i2 >= 0) {
                this.alpha[i2] = (Double)this.rho.get(i2) * MatrixOps.dotProduct((double[])this.s.get(i2), this.direction);
                MatrixOps.plusEquals(this.direction, (double[])this.y.get(i2), -1.0 * this.alpha[i2]);
                --i2;
            }
            MatrixOps.timesEquals(this.direction, gamma);
            i2 = 0;
            while (i2 < this.y.size()) {
                double beta = (Double)this.rho.get(i2) * MatrixOps.dotProduct((double[])this.y.get(i2), this.direction);
                MatrixOps.plusEquals(this.direction, (double[])this.s.get(i2), this.alpha[i2] - beta);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.oldg.length) {
                this.oldParameters[i2] = this.parameters[i2];
                this.oldg[i2] = this.g[i2];
                int n = i2++;
                this.direction[n] = this.direction[n] * -1.0;
            }
            logger.fine("before linesearch: direction.gradient.dotprod: " + MatrixOps.dotProduct(this.direction, this.g) + "\ndirection.2norm: " + MatrixOps.twoNorm(this.direction) + "\nparameters.2norm: " + MatrixOps.twoNorm(this.parameters));
            step = this.lineMaximizer.maximize(maxable, this.direction, step);
            if (step == 0.0) {
                this.g = null;
                throw new IllegalArgumentException("could not step in current direction");
            }
            maxable.getParameters(this.parameters);
            maxable.getValueGradient(this.g);
            logger.fine("after linesearch: direction.2norm: " + MatrixOps.twoNorm(this.direction));
            double newValue = maxable.getValue();
            if (2.0 * Math.abs(newValue - value) <= this.tolerance * (Math.abs(newValue) + Math.abs(value) + 1.0E-5)) {
                logger.info("Exiting L-BFGS on termination #1:\nvalue difference below tolerance (oldValue: " + value + " newValue: " + newValue);
                return true;
            }
            double gg = MatrixOps.twoNorm(this.g);
            if (gg < 0.001) {
                logger.fine("Exiting L-BFGS on termination #2: \ngradient=" + gg + " < " + 0.001);
                return true;
            }
            if (gg == 0.0) {
                logger.fine("Exiting L-BFGS on termination #3: \ngradient==0.0");
                return true;
            }
            logger.fine("Gradient = " + gg);
            ++this.iterations;
            if (this.iterations > 1000) {
                System.err.println("Too many iterations in L-BFGS.java. Continuing with current parameters.");
                return true;
            }
            if (this.eval != null && !this.eval.evaluate(maxable, iterationCount)) {
                logger.fine("Exiting L-BFGS on termination #4: evaluator returned false.");
                return false;
            }
            ++iterationCount;
        }
        return false;
    }

    public void reset() {
        this.g = null;
    }

    private void push(LinkedList l, double[] toadd) {
        assert (l.size() <= 4);
        if (l.size() == 4) {
            double[] last = (double[])l.get(0);
            System.arraycopy(toadd, 0, last, 0, toadd.length);
            double[] ptr = last;
            int i = 0;
            while (i < l.size() - 1) {
                l.set(i, (double[])l.get(i + 1));
                ++i;
            }
            l.set(3, ptr);
        } else {
            double[] newArray = new double[toadd.length];
            System.arraycopy(toadd, 0, newArray, 0, toadd.length);
            l.addLast(newArray);
        }
    }

    private void push(LinkedList l, double toadd) {
        assert (l.size() <= 4);
        if (l.size() == 4) {
            l.removeFirst();
            l.addLast(new Double(toadd));
        } else {
            l.addLast(new Double(toadd));
        }
    }
}

