/*
 * Decompiled with CFR 0.152.
 */
package Jet.Zoner;

import AceJet.Ace;
import Jet.Control;
import Jet.JetTest;
import Jet.Tipster.Annotation;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSplitter;
import Jet.Zoner.SpecialZoner;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class TaggedSentenceWriter {
    static String dataDir;
    static String outputDir;
    static String[] types;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 4) {
            System.out.println("TaggedSentenceWriter must have 4 arguments:");
            System.out.println("  propertyFile  filelist  dataDirectory  outputDirectory");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        dataDir = stringArray[2];
        outputDir = stringArray[3];
        JetTest.initializeFromConfig(string);
        String string3 = JetTest.getConfig("WriteSGML.type");
        types = string3 == null ? new String[]{"ENAMEX"} : (string3.equals("all") ? null : string3.split("\\s*,\\s*"));
        TaggedSentenceWriter.processFileList(string2);
    }

    private static void processFileList(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string2);
            String string3 = dataDir + string2;
            ExternalDocument externalDocument = new ExternalDocument("sgml", string3);
            externalDocument.setAllTags(true);
            externalDocument.open();
            Control.processDocument(externalDocument, null, false, n);
            for (String string4 : types) {
                externalDocument.shrink(string4);
            }
            String object = outputDir + string2 + ".nesent";
            PrintWriter printWriter = new PrintWriter(new FileWriter(object));
            TaggedSentenceWriter.writeSents(externalDocument, string2, printWriter);
            printWriter.close();
        }
    }

    private static void writeSents(ExternalDocument externalDocument, String string, PrintWriter printWriter) {
        Span span;
        Vector<Annotation> vector;
        Vector<Annotation> vector2 = externalDocument.annotationsOfType("sentence");
        if (vector2 == null || vector2.size() == 0) {
            externalDocument.annotateWithTag("TEXT");
            SpecialZoner.findSpecialZones(externalDocument);
            vector = externalDocument.annotationsOfType("TEXT");
            if (vector == null) {
                System.out.println("No <TEXT> in " + string + ", skipped.");
                return;
            }
            for (Annotation annotation : vector) {
                span = annotation.span();
                Ace.monocase = Ace.allLowerCase(externalDocument);
                SentenceSplitter.split(externalDocument, span);
            }
        }
        if ((vector = externalDocument.annotationsOfType("sentence")) == null) {
            return;
        }
        for (Annotation annotation : vector) {
            span = annotation.span();
            String string2 = externalDocument.writeSGML(types, span.start(), span.end()).toString().trim().replace('\n', ' ');
            printWriter.println(span.start() + " " + string2);
        }
    }
}

