/*
 * Decompiled with CFR 0.152.
 */
package Jet.Util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class IOUtils {
    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String string) throws IOException {
        String string2;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            inputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(inputStream);
            inputStreamReader = new InputStreamReader(inputStream, string);
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = ((Reader)inputStreamReader).read()) != -1) {
                stringBuilder.append((char)n);
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStreamReader);
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStreamReader);
        IOUtils.closeQuietly(inputStream);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String string, CharSequence charSequence) throws IOException {
        OutputStream outputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStream = new FileOutputStream(file);
            outputStream = new BufferedOutputStream(outputStream);
            outputStreamWriter = new OutputStreamWriter(outputStream, string);
            ((Writer)outputStreamWriter).append(charSequence);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStreamWriter);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(outputStreamWriter);
        IOUtils.closeQuietly(outputStream);
    }

    public static BufferedWriter getBufferedWriter(File file, Charset charset) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static BufferedWriter getBufferedWriter(File file, String string) throws FileNotFoundException {
        Charset charset = Charset.forName(string);
        return IOUtils.getBufferedWriter(file, charset);
    }

    public static BufferedReader getBufferedReader(File file, Charset charset) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedReader getBufferedReader(File file, String string) throws FileNotFoundException {
        Charset charset = Charset.forName(string);
        return IOUtils.getBufferedReader(file, charset);
    }
}

