/*
 * Decompiled with CFR 0.152.
 */
package Jet.Util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public final class Cdb {
    private ByteBuffer map;
    private int loop;
    private int khash;
    private int kpos;
    private int hpos;
    private int hslots;

    public Cdb(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = randomAccessFile.getChannel();
        this.map = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length());
        this.map.order(ByteOrder.LITTLE_ENDIAN);
        fileChannel.close();
    }

    public Cdb(String string) throws IOException {
        this(new File(string));
    }

    public void close() {
        this.map = null;
    }

    public void findstart() {
        this.loop = 0;
    }

    public byte[] findNext(byte[] byArray, int n, int n2) {
        int n3;
        if (this.loop == 0) {
            n3 = Cdb.hash(byArray, n, n2);
            this.map.position(n3 << 3 & 0x7FF);
            this.hpos = this.map.getInt();
            this.hslots = this.map.getInt();
            if (this.hslots == 0) {
                return null;
            }
            this.khash = n3;
            n3 >>>= 8;
            n3 %= this.hslots;
            this.kpos = this.hpos + (n3 <<= 3);
        }
        while (this.loop < this.hslots) {
            this.map.position(this.kpos);
            n3 = this.map.getInt();
            int n4 = this.map.getInt();
            if (n4 == 0) {
                return null;
            }
            ++this.loop;
            this.kpos += 8;
            if (this.kpos == this.hpos + (this.hslots << 3)) {
                this.kpos = this.hpos;
            }
            if (n3 != this.khash) continue;
            this.map.position(n4);
            n3 = this.map.getInt();
            if (n3 != n2) continue;
            int n5 = this.map.getInt();
            byte[] byArray2 = new byte[n2];
            this.map.get(byArray2, 0, n2);
            if (!Cdb.match(byArray, n, n2, byArray2)) continue;
            byte[] byArray3 = new byte[n5];
            this.map.get(byArray3, 0, n5);
            return byArray3;
        }
        return null;
    }

    public byte[] findNext(byte[] byArray) {
        return this.findNext(byArray, 0, byArray.length);
    }

    public byte[] find(byte[] byArray, int n, int n2) {
        this.findstart();
        return this.findNext(byArray, n, n2);
    }

    public byte[] find(byte[] byArray) {
        return this.find(byArray, 0, byArray.length);
    }

    static int hash(byte[] byArray, int n, int n2) {
        long l = 5381L;
        for (int i = 0; i < n2; ++i) {
            l = l + (l << 5) & 0xFFFFFFFFL & 0xFFFFFFFFL;
            l ^= (long)(byArray[n + i] + 256 & 0xFF);
        }
        return (int)(l & 0xFFFFFFFFL);
    }

    private static boolean match(byte[] byArray, int n, int n2, byte[] byArray2) {
        if (byArray2.length < n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

