/*
 * Decompiled with CFR 0.152.
 */
package Jet.Time;

import Jet.Time.DayOfWeekPattern;
import Jet.Time.MonthPattern;
import Jet.Time.NumberPattern;
import Jet.Time.PatternItem;
import Jet.Time.RegexPattern;
import Jet.Time.ScriptRule;
import Jet.Time.SimpleTimeRule;
import Jet.Time.StringPattern;
import Jet.Time.TimePattern;
import Jet.Time.TimeRule;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import Jet.Util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ho.yaml.Yaml;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeAnnotator {
    private List<TimeRule> mainRules;
    private List<TimeRule> transformRules;
    private Map config;
    private int early_month = 4;
    private int late_month = 9;
    private int min_year = 1000;
    private int max_year = 9999;

    public TimeAnnotator() {
    }

    public TimeAnnotator(String string) throws IOException {
        this(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeAnnotator(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.load(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public void annotate(Document document, Span span, DateTime dateTime) {
        this.applyRules(document, span, dateTime, this.mainRules);
        if (this.transformRules != null) {
            this.applyRules(document, span, dateTime, this.transformRules);
        }
    }

    private void applyRules(Document document, Span span, DateTime dateTime, List<TimeRule> list) {
        Vector<Annotation> vector = document.annotationsOfType("token", span);
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            Span span2 = null;
            for (TimeRule timeRule : list) {
                ArrayList<Object> arrayList;
                span2 = timeRule.matches(document, vector, n, dateTime, arrayList = new ArrayList<Object>());
                if (span2 == null) continue;
                try {
                    timeRule.apply(document, arrayList, span2, dateTime);
                    break;
                }
                catch (IllegalFieldValueException illegalFieldValueException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("TimeAnnotator.applyRules:  " + illegalArgumentException);
                }
            }
            if (span2 != null) {
                n = this.nextOffset(vector, n, span2);
                continue;
            }
            ++n;
        }
    }

    public void load(InputStream inputStream) throws IOException {
        this.mainRules = null;
        Map map = (Map)Yaml.load(inputStream);
        List list = (List)map.get("rules");
        this.config = (Map)map.get("config");
        if (this.config == null) {
            this.config = new HashMap();
        }
        this.mainRules = new ArrayList<TimeRule>(list.size());
        boolean bl = true;
        if (this.config.containsKey("sortByPatternLength")) {
            bl = (Boolean)this.config.get("sortByPatternLength");
        }
        if (this.config.containsKey("min_year")) {
            this.min_year = (Integer)this.config.get("min_year");
        }
        if (this.config.containsKey("max_year")) {
            this.max_year = (Integer)this.config.get("max_year");
        }
        if (this.config.containsKey("early_month")) {
            this.early_month = (Integer)this.config.get("early_month");
        }
        if (this.config.containsKey("late_month")) {
            this.late_month = (Integer)this.config.get("late_month");
        }
        this.mainRules = this.loadRules(list, bl);
        if (map.containsKey("transformRules")) {
            this.transformRules = this.loadRules((List)map.get("transformRules"), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.load(fileInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
    }

    public Map getConfig() {
        return this.config;
    }

    private List<TimeRule> loadRules(List list, boolean bl) {
        ArrayList<TimeRule> arrayList = new ArrayList<TimeRule>();
        for (Object e : list) {
            arrayList.addAll(this.loadRule((Map)e));
        }
        if (bl) {
            Comparator<TimeRule> comparator = new Comparator<TimeRule>(){

                @Override
                public int compare(TimeRule timeRule, TimeRule timeRule2) {
                    return timeRule2.getPatternItems().length - timeRule.getPatternItems().length;
                }
            };
            Collections.sort(arrayList, comparator);
        }
        return arrayList;
    }

    public List<TimeRule> loadRule(Map map) {
        ArrayList<TimeRule> arrayList = new ArrayList<TimeRule>();
        String string = (String)map.get("type");
        Map map2 = (Map)map.get("params");
        if (string.equals("simple")) {
            for (PatternItem[] patternItemArray : this.getPatterns(this.getPatternStrings(map))) {
                SimpleTimeRule simpleTimeRule = new SimpleTimeRule();
                simpleTimeRule.setTimeAnnotator(this);
                simpleTimeRule.setPatternItems(patternItemArray);
                simpleTimeRule.setParameters(map2);
                arrayList.add(simpleTimeRule);
            }
        } else if (string.equals("script")) {
            for (PatternItem[] patternItemArray : this.getPatterns(this.getPatternStrings(map))) {
                ScriptRule scriptRule = new ScriptRule();
                scriptRule.setTimeAnnotator(this);
                ((TimeRule)scriptRule).setParameters(map2);
                scriptRule.setPatternItems(patternItemArray);
                arrayList.add(scriptRule);
            }
        } else {
            new RuntimeException(string + " is not supported.");
        }
        return arrayList;
    }

    public List<PatternItem[]> getPatterns(List<String[]> list) {
        ArrayList<PatternItem[]> arrayList = new ArrayList<PatternItem[]>();
        Pattern pattern = Pattern.compile("\\(regex:(.*)\\)");
        for (String[] stringArray : list) {
            PatternItem[] patternItemArray = new PatternItem[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("(number)")) {
                    patternItemArray[i] = new NumberPattern();
                    continue;
                }
                if (stringArray[i].equals("(ordinal)")) {
                    patternItemArray[i] = new NumberPattern(NumberPattern.Ordinal.MUST);
                    continue;
                }
                if (stringArray[i].equals("(year)")) {
                    patternItemArray[i] = new NumberPattern(this.min_year, this.max_year);
                    continue;
                }
                if (stringArray[i].equals("(month)")) {
                    patternItemArray[i] = new MonthPattern();
                    continue;
                }
                if (stringArray[i].equals("(day)")) {
                    patternItemArray[i] = new NumberPattern(1, 31);
                    continue;
                }
                if (stringArray[i].equals("(dow)")) {
                    patternItemArray[i] = new DayOfWeekPattern();
                    continue;
                }
                if (stringArray[i].equals("(time)")) {
                    patternItemArray[i] = new TimePattern(false);
                    continue;
                }
                if (stringArray[i].equals("(duration)")) {
                    patternItemArray[i] = new TimePattern(true);
                    continue;
                }
                Matcher matcher = pattern.matcher(stringArray[i]);
                if (matcher.matches()) {
                    Pattern pattern2 = Pattern.compile(matcher.group(1));
                    patternItemArray[i] = new RegexPattern(pattern2);
                    continue;
                }
                patternItemArray[i] = new StringPattern(stringArray[i]);
            }
            arrayList.add(patternItemArray);
        }
        return arrayList;
    }

    public List<String[]> getPatternStrings(Map map) {
        ArrayList<String> arrayList;
        if (map.containsKey("patterns")) {
            arrayList = (ArrayList<String>)map.get("patterns");
        } else if (map.containsKey("pattern")) {
            arrayList = new ArrayList<String>(1);
            arrayList.add((String)map.get("pattern"));
        } else {
            throw new RuntimeException();
        }
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>(arrayList.size());
        for (String string : arrayList) {
            arrayList2.add(string.split("\\s+"));
        }
        return arrayList2;
    }

    private int nextOffset(List<Annotation> list, int n, Span span) {
        int n2;
        for (n2 = n; n2 < list.size() && list.get(n2).start() < span.end(); ++n2) {
        }
        return n2;
    }

    public DateTime normalizeMonth(DateTime dateTime, int n) {
        int n2 = dateTime.getMonthOfYear();
        int n3 = dateTime.getYear();
        DateTime dateTime2 = dateTime.withField(DateTimeFieldType.monthOfYear(), n);
        if (n2 < this.early_month && n > this.late_month) {
            dateTime2 = dateTime2.withField(DateTimeFieldType.year(), n3 - 1);
        } else if (n2 > this.late_month && n < this.early_month) {
            dateTime2 = dateTime2.withField(DateTimeFieldType.year(), n3 + 1);
        }
        return dateTime2;
    }
}

