/*
 * Decompiled with CFR 0.152.
 */
package Jet.Scorer;

import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.util.HashMap;
import java.util.Vector;

public class SGMLScorer {
    public Document doc1;
    public Document doc2;
    public Vector mismatch1 = new Vector();
    public Vector mismatch2 = new Vector();
    public int numOfTagsInDoc1 = 0;
    public int numOfTagsInDoc2 = 0;
    public int numOfMatchingTags = 0;
    public int numOfMatchingAttrs = 0;
    public int totalTagsInDoc1 = 0;
    public int totalTagsInDoc2 = 0;
    public int totalMatchingTags = 0;
    public int totalMatchingAttrs = 0;
    String lastTypeMatched = "";
    boolean ignorePeriods = false;

    public SGMLScorer(Document document, Document document2) {
        this.doc1 = document;
        this.doc2 = document2;
    }

    public void match(String string) {
        this.match(string, string);
    }

    public void match(String string, String string2) {
        this.match(string, string2, null);
    }

    public void match(String string, String string2, Span span) {
        Object object;
        this.numOfTagsInDoc1 = 0;
        this.numOfTagsInDoc2 = 0;
        this.numOfMatchingTags = 0;
        this.numOfMatchingAttrs = 0;
        this.lastTypeMatched = string2;
        Annotation annotation = null;
        Annotation annotation2 = null;
        Vector<Annotation> vector = this.doc1.annotationsOfType(string, span);
        HashMap hashMap = this.annotationMap(this.doc2.annotationsOfType(string2, span), this.doc2);
        HashMap hashMap2 = this.annotationMap(this.doc1.annotationsOfType(string, span), this.doc1);
        HashMap hashMap3 = this.annotationMap(this.doc2.annotationsOfType(string2, span), this.doc2);
        int n = 0;
        if (vector != null) {
            this.numOfTagsInDoc1 = n = vector.size();
        }
        int n2 = 0;
        if (hashMap != null) {
            this.numOfTagsInDoc2 = n2 = hashMap.size();
        }
        if (vector != null && hashMap != null) {
            for (int i = 0; i < n; ++i) {
                annotation = vector.get(i);
                Object object2 = this.annotationKey(annotation, this.doc1);
                annotation2 = (Annotation)hashMap.get(object2);
                if (annotation2 == null) continue;
                ++this.numOfMatchingTags;
                object = annotation.get("TYPE");
                Object object3 = annotation2.get("TYPE");
                Object object4 = annotation.get("CAT");
                Object object5 = annotation2.get("CAT");
                if ((object == null ? object3 == null : object.equals(object3)) && (object4 == null ? object5 == null : object4.equals(object5))) {
                    ++this.numOfMatchingAttrs;
                    hashMap2.remove(object2);
                    hashMap3.remove(object2);
                }
                hashMap.remove(object2);
                --n2;
            }
        }
        if (hashMap2 != null) {
            this.mismatch1.addAll(hashMap2.values());
        }
        if (hashMap3 != null) {
            for (Object object2 : hashMap3.values()) {
                object = ((Annotation)object2).get("STATUS");
                if (object != null && object.equals("OPT")) {
                    --this.numOfTagsInDoc2;
                    continue;
                }
                this.mismatch2.add(object2);
            }
        }
        this.totalTagsInDoc1 += this.numOfTagsInDoc1;
        this.totalTagsInDoc2 += this.numOfTagsInDoc2;
        this.totalMatchingTags += this.numOfMatchingTags;
        this.totalMatchingAttrs += this.numOfMatchingAttrs;
    }

    public String report() {
        return "For " + this.lastTypeMatched + ", " + "# of matching tags = " + this.numOfMatchingTags + "    # of tags in response = " + this.numOfTagsInDoc1 + "    # of tags in key = " + this.numOfTagsInDoc2 + "    # with matching attributes = " + this.numOfMatchingAttrs;
    }

    private HashMap annotationMap(Vector vector, Document document) {
        if (vector == null) {
            return null;
        }
        HashMap<Long, Annotation> hashMap = new HashMap<Long, Annotation>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Long l = this.annotationKey(annotation, document);
            if (hashMap.containsKey(l)) {
                System.out.println("Duplicate annotation " + annotation);
            }
            hashMap.put(l, annotation);
        }
        return hashMap;
    }

    private Long annotationKey(Annotation annotation, Document document) {
        int n;
        long l = annotation.span().start();
        long l2 = annotation.span().end();
        if (this.ignorePeriods && (n = annotation.span().endNoWS(document)) > 1 && document.charAt(n - 1) == '.') {
            l2 = n - 1;
        }
        return new Long(l * 1000000000L + l2);
    }
}

