/*
 * Decompiled with CFR 0.152.
 */
package Jet.Chunk;

import AceJet.Ace;
import AceJet.Datum;
import Jet.Chunk.NameConstraints;
import Jet.Chunk.TokenClassifier;
import Jet.MaxEntModel;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxEntNE
extends TokenClassifier {
    MaxEntModel model;
    String[] state;
    Map<String, String> cache = new HashMap<String, String>();
    public static int pass = 0;
    Map<String, String> wordType = new HashMap<String, String>();
    Map<String, String> wordTypeEvens = new HashMap<String, String>();
    Map<String, String> wordTypeOdds = new HashMap<String, String>();
    static int trainingDocCount = 0;
    boolean useOnoma = true;
    public static double otherOffset = 0.0;
    String[] onomaType;
    static Map<String, String> word2cluster = new HashMap<String, String>();
    static boolean useWordClusters = false;

    public MaxEntNE() {
        this.model = new MaxEntModel();
        this.model.setIterations(80);
    }

    public void resetForTraining(String string) {
        this.model.initializeForTraining(string);
        trainingDocCount = 0;
    }

    @Override
    public void newDocument() {
        this.cache.clear();
        ++trainingDocCount;
    }

    @Override
    public void train(Document document, Annotation[] annotationArray, String[] stringArray) {
        int n = annotationArray.length;
        String[] stringArray2 = new String[n];
        if (this.useOnoma) {
            this.onomaType = new String[n];
        }
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = document.text(annotationArray[i]).trim();
            if (!this.useOnoma) continue;
            this.onomaType[i] = this.onomaFeature(document, annotationArray[i]);
        }
        String string = "other";
        for (int i = 0; i < n; ++i) {
            if (pass == 1) {
                this.recordWord(stringArray2[i], stringArray[i]);
                continue;
            }
            Datum datum = this.NEfeatures(i, stringArray2, annotationArray, string, document);
            datum.setOutcome(stringArray[i]);
            this.model.addEvent(datum);
            string = stringArray[i];
            this.addToCache(stringArray2[i], stringArray[i]);
        }
    }

    private void recordWord(String string, String string2) {
        String string3 = string.toLowerCase();
        if (string2.charAt(1) == '-') {
            string2 = string2.substring(2);
        }
        char c = string2.charAt(0);
        if (string2.equals("other")) {
            c = 'x';
        }
        this.recordWord(string3, c, this.wordType);
        if (trainingDocCount % 2 == 1) {
            this.recordWord(string3, c, this.wordTypeOdds);
        } else {
            this.recordWord(string3, c, this.wordTypeEvens);
        }
        if (!Ace.monocase && c == 'p' && Character.isLowerCase(string.charAt(0))) {
            System.out.println("Lower case person token " + string3);
        }
    }

    private void recordWord(String string, char c, Map<String, String> map) {
        String string2 = map.get(string);
        if (string2 == null) {
            map.put(string, "" + c);
        } else if (string2.indexOf(c) < 0) {
            string2 = string2 + c;
            map.put(string, string2);
        }
    }

    private Datum NEfeatures(int n, String[] stringArray, Annotation[] annotationArray, String string, Document document) {
        Datum datum = new Datum();
        String string2 = n > 0 ? stringArray[n - 1].toLowerCase() : "^";
        String string3 = n > 1 ? stringArray[n - 2].toLowerCase() : "^";
        String string4 = stringArray[n].toLowerCase();
        String string5 = n >= stringArray.length - 1 ? "$" : stringArray[n + 1].toLowerCase();
        String string6 = n >= stringArray.length - 2 ? "$" : stringArray[n + 2].toLowerCase();
        datum.addFV("p", string2 + ":" + string);
        datum.addFV("c", string4 + ":" + string);
        datum.addFV("n", string5 + ":" + string);
        datum.addFV("n2", string6 + ":" + string);
        String string7 = MaxEntNE.wordFeature(stringArray[n], annotationArray[n].get("case") == "forcedCap");
        String string8 = "^";
        String string9 = "$";
        if (n > 0) {
            string8 = MaxEntNE.wordFeature(stringArray[n - 1], annotationArray[n - 1].get("case") == "forcedCap");
        }
        if (n < stringArray.length - 1) {
            string9 = MaxEntNE.wordFeature(stringArray[n + 1], annotationArray[n + 1].get("case") == "forcedCap");
        }
        datum.addFV("pcnf", string8 + string7 + string9);
        datum.addFV(Ace.monocase ? "cfmono" : "cf", MaxEntNE.wordFeature(stringArray[n], annotationArray[n].get("case") == "forcedCap") + ":" + string);
        datum.addFV("pt", string);
        String string10 = this.cache.get(stringArray[n]);
        if (string10 == null) {
            string10 = "";
        }
        datum.addFV("ca", string10 + ":" + string);
        datum.addFV("pc", string2 + ":" + stringArray[n] + string);
        datum.addFV("p2", string3 + ":" + string2 + string);
        if (n > 0) {
            datum.addFV(Ace.monocase ? "pfmono" : "pf", MaxEntNE.wordFeature(stringArray[n - 1], annotationArray[n - 1].get("case") == "forcedCap") + ":" + string);
        } else {
            datum.addFV("pf", "^:" + string);
        }
        if (n < stringArray.length - 1) {
            datum.addFV(Ace.monocase ? "nfmono" : "nf", MaxEntNE.wordFeature(stringArray[n + 1], annotationArray[n + 1].get("case") == "forcedCap") + ":" + string);
        } else {
            datum.addFV("nf", "$:" + string);
        }
        datum.addFV("tt", this.typeFeature(stringArray[n]) + ":" + string);
        datum.addFV("w", stringArray[n] + ":" + string);
        if (this.useOnoma) {
            if (this.onomaType[n] != null) {
                datum.addFV("onoma", this.onomaType[n]);
            }
            if (Character.isUpperCase(stringArray[n].charAt(0)) && n < stringArray.length - 2) {
                int n2;
                for (n2 = n + 1; Character.isUpperCase(stringArray[n2].charAt(0)) && n2 < stringArray.length - 2; ++n2) {
                }
                String string11 = this.onomaType[n2 + 1];
                if (stringArray[n2].equals(",") && (string11 == "country" || string11 == "usstate")) {
                    datum.addF("cityContext");
                } else if (stringArray[n2].equals("-") && stringArray[n2 + 1].equals("based")) {
                    datum.addF("-basedContext");
                }
            }
        }
        if (useWordClusters) {
            string2 = n > 0 ? stringArray[n - 1] : "^";
            string4 = stringArray[n];
            string5 = n >= stringArray.length - 1 ? "$" : stringArray[n + 1];
            datum.addFV("p1px4", MaxEntNE.getWordClusterPrefix(string2, 4));
            datum.addFV("p1px6", MaxEntNE.getWordClusterPrefix(string2, 6));
            datum.addFV("p1px10", MaxEntNE.getWordClusterPrefix(string2, 10));
            datum.addFV("p1px20", MaxEntNE.getWordClusterPrefix(string2, 20));
            datum.addFV("cpx4", MaxEntNE.getWordClusterPrefix(string4, 4));
            datum.addFV("cpx6", MaxEntNE.getWordClusterPrefix(string4, 6));
            datum.addFV("cpx10", MaxEntNE.getWordClusterPrefix(string4, 10));
            datum.addFV("cpx20", MaxEntNE.getWordClusterPrefix(string4, 20));
            datum.addFV("npx4", MaxEntNE.getWordClusterPrefix(string5, 4));
            datum.addFV("npx6", MaxEntNE.getWordClusterPrefix(string5, 6));
            datum.addFV("npx10", MaxEntNE.getWordClusterPrefix(string5, 10));
            datum.addFV("npx20", MaxEntNE.getWordClusterPrefix(string5, 20));
        }
        return datum;
    }

    private String typeFeature(String string) {
        String string2;
        Map<String, String> map = trainingDocCount < 0 ? this.wordType : (trainingDocCount % 2 == 0 ? this.wordTypeOdds : this.wordTypeEvens);
        if (map.get(string2 = string.toLowerCase()) == null) {
            return "OOV";
        }
        return map.get(string2);
    }

    private String onomaFeature(Document document, Annotation annotation) {
        int n = annotation.start();
        Vector<Annotation> vector = document.annotationsAt(n, "onoma");
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Annotation annotation2 = vector.get(0);
        return (String)annotation2.get("type");
    }

    private void addToCache(String string, String string2) {
        if (string2.equals("other")) {
            return;
        }
        if (string2.charAt(1) == '-') {
            string2 = string2.substring(2);
        }
        char c = string2.charAt(0);
        String string3 = this.cache.get(string);
        if (string3 == null) {
            string3 = "" + c;
            this.cache.put(string, string3);
        } else if (string3.indexOf(c) < 0) {
            string3 = string3 + c;
            this.cache.put(string, string3);
        }
    }

    @Override
    public void createModel() {
        this.model.buildModel();
    }

    @Override
    public void store(String string) {
        try {
            this.store(new BufferedWriter(new FileWriter(string)));
        }
        catch (IOException iOException) {
            System.err.println("Error in MaxEntNE.store: " + iOException);
            System.exit(1);
        }
    }

    public void store(BufferedWriter bufferedWriter) {
        try {
            for (String string : this.wordType.keySet()) {
                bufferedWriter.write(string + " " + this.wordType.get(string));
                bufferedWriter.newLine();
            }
            bufferedWriter.write("endWordType");
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.err.println("Error in MaxEntNE.store: " + iOException);
            System.exit(1);
        }
        this.model.saveModel(bufferedWriter);
    }

    @Override
    public void load(String string) {
        try {
            this.load(new BufferedReader(new FileReader(string)));
        }
        catch (IOException iOException) {
            System.err.println("Error in MaxEntNE.load: " + iOException);
            System.exit(1);
        }
    }

    public void load(BufferedReader bufferedReader) {
        try {
            String string;
            while (!(string = bufferedReader.readLine()).equals("endWordType")) {
                String[] stringArray = string.split("\\s+");
                if (stringArray.length != 2) {
                    System.err.println("MaxEntNE.load:  invalid line " + string);
                    continue;
                }
                this.wordType.put(stringArray[0], stringArray[1]);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error in MaxEntNE.load: " + iOException);
            System.exit(1);
        }
        this.model.loadModel(bufferedReader);
    }

    public String[] simpleDecoder(Document document, Annotation[] annotationArray) {
        int n = annotationArray.length;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = document.text(annotationArray[i]).trim();
        }
        String string = "other";
        for (int i = 0; i < n; ++i) {
            Datum datum = this.NEfeatures(i, stringArray, annotationArray, string, document);
            stringArray2[i] = this.model.bestOutcome(datum);
            this.addToCache(stringArray[i], stringArray2[i]);
            string = stringArray2[i];
        }
        return stringArray2;
    }

    @Override
    public String[] viterbi(Document document, Annotation[] annotationArray) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        trainingDocCount = -1;
        int n5 = annotationArray.length;
        if (n5 == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n5];
        if (this.useOnoma) {
            this.onomaType = new String[n5];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            stringArray[n4] = document.text(annotationArray[n4]).trim();
            if (!this.useOnoma) continue;
            this.onomaType[n4] = this.onomaFeature(document, annotationArray[n4]);
        }
        n4 = this.model.getNumOutcomes();
        this.state = new String[n4];
        for (int i = 0; i < n4; ++i) {
            this.state[i] = this.model.getOutcome(i);
        }
        double[][] dArray = new double[n5][n4];
        int[][] nArray = new int[n5][n4];
        NameConstraints nameConstraints = new NameConstraints(document, annotationArray, this.state);
        int[] nArray2 = new int[n5];
        double d = -1000000.0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.state[n3].charAt(0) == 'I' || !nameConstraints.allowedState(0, n3)) {
                dArray[0][n3] = d;
                continue;
            }
            Datum datum = this.NEfeatures(0, stringArray, annotationArray, "other", document);
            object = this.model.getOutcomeProbabilities(datum);
            double d2 = Math.log(object[n3]);
            if (this.state[n3].equals("other")) {
                d2 += otherOffset;
            }
            dArray[0][n3] = d2;
        }
        for (n3 = 1; n3 < n5; ++n3) {
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                dArray[n3][n6] = d;
                nArray[n3][n6] = -1;
            }
            for (n6 = 0; n6 < n4; ++n6) {
                object = this.NEfeatures(n3, stringArray, annotationArray, this.state[n6], document);
                double[] dArray2 = this.model.getOutcomeProbabilities((Datum)object);
                for (n2 = 0; n2 < n4; ++n2) {
                    double d3 = Math.log(dArray2[n2]);
                    if (this.state[n2].equals("other")) {
                        d3 += otherOffset;
                    }
                    if (!this.allowedTransition(n6, n2) || !nameConstraints.allowedState(n3, n2) || !(dArray[n3 - 1][n6] + d3 > dArray[n3][n2])) continue;
                    dArray[n3][n2] = dArray[n3 - 1][n6] + d3;
                    nArray[n3][n2] = n6;
                }
            }
        }
        double d4 = d;
        int n7 = -1;
        for (n = 0; n < n4; ++n) {
            if (!(dArray[n5 - 1][n] > d4)) continue;
            d4 = dArray[n5 - 1][n];
            n7 = n;
        }
        if (n7 < 0) {
            System.err.println("No valid path.");
            return null;
        }
        nArray2[n5 - 1] = n7;
        for (n = n5 - 2; n >= 0; --n) {
            n2 = nArray[n + 1][nArray2[n + 1]];
            if (n2 < 0) {
                System.err.println("No valid path.");
                return null;
            }
            nArray2[n] = n2;
        }
        String[] stringArray2 = new String[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            stringArray2[n2] = this.state[nArray2[n2]];
            this.addToCache(stringArray[n2], stringArray2[n2]);
        }
        return stringArray2;
    }

    private boolean allowedTransition(int n, int n2) {
        String string = this.state[n];
        String string2 = this.state[n2];
        if (string2.substring(0, 2).equals("I-")) {
            return string.substring(1).equals(string2.substring(1));
        }
        return true;
    }

    static String wordFeature(String string, boolean bl) {
        int n = string.length();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) {
                bl2 = false;
            }
            if (!Character.isUpperCase(c)) {
                bl3 = false;
            }
            if (!Character.isLowerCase(c)) {
                bl5 = false;
            }
            if (!Character.isLetter(c) && c != '-') {
                bl6 = false;
            }
            if (!Character.isLetter(c) && c != '.') {
                bl7 = false;
            }
            if ((i != 0 || Character.isUpperCase(c)) && (i <= 0 || Character.isLowerCase(c))) continue;
            bl4 = false;
        }
        if (bl2) {
            if (n == 2) {
                return "twoDigitNum";
            }
            if (n == 4) {
                return "fourDigitNum";
            }
            return "otherNum";
        }
        if (bl3) {
            return "allCaps";
        }
        if (bl) {
            return "forcedCap";
        }
        if (bl4) {
            return "initCap";
        }
        if (bl5) {
            return "lowerCase";
        }
        if (bl7) {
            return "abbrev";
        }
        if (bl6) {
            return "hyphenated";
        }
        return "other";
    }

    public static void loadWordClusters(String string) throws IOException {
        String string2;
        System.out.println("Loading word clusters from " + string);
        File file = new File(string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            if (stringArray.length < 2) continue;
            word2cluster.put(stringArray[1], stringArray[0]);
        }
        useWordClusters = true;
    }

    private static String getWordClusterPrefix(String string, int n) {
        String string2 = new String();
        if (word2cluster.containsKey(string)) {
            string2 = word2cluster.get(string);
            if (string2.length() >= n) {
                string2 = string2.substring(0, n);
            }
        } else {
            string2 = "nil";
        }
        return string2;
    }
}

