/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.AceRelation;
import AceJet.AceRelationMention;
import Jet.Tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RelationScorer {
    static int correctEntityMentions = 0;
    static int missingEntityMentions = 0;
    static int spuriousEntityMentions = 0;
    static int correctRelationMentions = 0;
    static int missingRelationMentions = 0;
    static int spuriousRelationMentions = 0;
    static int relationMentionTypeErrors = 0;
    static Map<String, String> entityAlignment = new HashMap<String, String>();
    static Set<String> symmetricTypes = new HashSet<String>();

    public static void main(String[] stringArray) throws IOException {
        String string;
        if (stringArray.length < 7 || stringArray.length > 8) {
            System.err.println("RelationScorer requires 7 or 8 arguments:");
            System.err.println("    docList sourceDir sourceExt responseDir responseExt keyDir keyExt [year]");
            System.exit(1);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        String string6 = stringArray[4];
        String string7 = stringArray[5];
        String string8 = stringArray[6];
        if (stringArray.length == 8) {
            Ace.setAceYear(stringArray[7]);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println("\nScoring document " + ++n + ": " + string);
            String string9 = string3 + "/" + string + "." + string4;
            String string10 = string5 + "/" + string + "." + string6;
            String string11 = string7 + "/" + string + "." + string8;
            RelationScorer.scoreDocument(string9, string10, string11);
        }
        RelationScorer.reportScores();
    }

    static void scoreDocument(String string, String string2, String string3) {
        Object object;
        ExternalDocument externalDocument = new ExternalDocument("sgml", string);
        externalDocument.setAllTags(true);
        externalDocument.open();
        AceDocument aceDocument = new AceDocument(string, string2);
        AceDocument aceDocument2 = new AceDocument(string, string3);
        HashSet hashSet = new HashSet();
        for (AceEntity object22 : aceDocument2.entities) {
            hashSet.addAll(object22.mentions);
        }
        HashMap hashMap = new HashMap();
        for (AceEntityMention aceEntityMention : hashSet) {
            int n = aceEntityMention.head.end();
            if (externalDocument.charAt(n) == '.') {
                --n;
            }
            hashMap.put(n, aceEntityMention);
        }
        for (AceEntity aceEntity : aceDocument.entities) {
            for (Object object2 : aceEntity.mentions) {
                int n = ((AceEntityMention)object2).head.end();
                if (externalDocument.charAt(n) == '.') {
                    --n;
                }
                if ((object = (AceEntityMention)hashMap.get(n)) == null) {
                    System.out.println("Spurious mention " + ((AceEntityMention)object2).text);
                    ++spuriousEntityMentions;
                    continue;
                }
                if (!hashSet.contains(object)) {
                    System.out.println("Spurious mention (duplicate head) " + ((AceEntityMention)object2).text);
                    ++spuriousEntityMentions;
                    continue;
                }
                entityAlignment.put(((AceEntityMention)object2).id, ((AceEntityMention)object).id);
                hashSet.remove(object);
                ++correctEntityMentions;
            }
        }
        for (AceEntityMention aceEntityMention : hashSet) {
            System.out.println("Missing mention " + aceEntityMention.text + " [head = " + aceEntityMention.headText + "]");
            ++missingEntityMentions;
        }
        HashSet hashSet2 = new HashSet();
        for (AceRelation aceRelation : aceDocument2.relations) {
            hashSet2.addAll(aceRelation.mentions);
        }
        for (AceRelation aceRelation : aceDocument.relations) {
            block7: for (AceRelationMention aceRelationMention : aceRelation.mentions) {
                object = aceRelationMention.relation.type;
                String string4 = aceRelationMention.relation.subtype;
                String string5 = aceRelationMention.arg1.id;
                String string6 = entityAlignment.get(string5);
                String string7 = aceRelationMention.arg2.id;
                String string8 = entityAlignment.get(string7);
                for (AceRelationMention aceRelationMention2 : hashSet2) {
                    String string9 = aceRelationMention2.arg1.id;
                    String string10 = aceRelationMention2.arg2.id;
                    String string11 = aceRelationMention2.relation.type;
                    String string12 = aceRelationMention2.relation.subtype;
                    boolean bl = symmetricTypes.contains(string11 + ":" + string12);
                    if ((!string9.equals(string6) || !string10.equals(string8)) && (!bl || !string9.equals(string8) || !string10.equals(string6))) continue;
                    if (((String)object).equals(string11)) {
                        ++correctRelationMentions;
                    } else {
                        ++relationMentionTypeErrors;
                    }
                    hashSet2.remove(aceRelationMention2);
                    continue block7;
                }
                ++spuriousRelationMentions;
                System.out.println("Spurious relation (" + (String)object + ":" + string4 + "): " + aceRelationMention.text);
            }
        }
        for (AceRelationMention aceRelationMention : hashSet2) {
            Object object2;
            object2 = aceRelationMention.relation.type;
            String string13 = aceRelationMention.relation.subtype;
            System.out.println("Missing relation (" + (String)object2 + ":" + string13 + "): " + aceRelationMention.text);
            ++missingRelationMentions;
        }
    }

    static void reportScores() {
        System.out.println();
        System.out.println("Correct entity mentions:    " + correctEntityMentions);
        System.out.println("Missing entity mentions:    " + missingEntityMentions);
        System.out.println("Spurious entity mentions:   " + spuriousEntityMentions);
        System.out.println();
        System.out.println("Correct relation mentions:  " + correctRelationMentions);
        System.out.println("Relation mention type errs: " + relationMentionTypeErrors);
        System.out.println("Missing relation mentions:  " + missingRelationMentions);
        System.out.println("Spurious relation mentions: " + spuriousRelationMentions);
        int n = correctRelationMentions + relationMentionTypeErrors + spuriousRelationMentions;
        int n2 = correctRelationMentions + relationMentionTypeErrors + missingRelationMentions;
        float f = (float)correctRelationMentions / (float)n;
        float f2 = (float)correctRelationMentions / (float)n2;
        float f3 = 2.0f * f * f2 / (f + f2);
        System.out.println();
        System.out.printf("Precision = %4.1f\n", Float.valueOf(100.0f * f));
        System.out.printf("Recall =    %4.1f\n", Float.valueOf(100.0f * f2));
        System.out.printf("F =         %4.1f\n", Float.valueOf(100.0f * f3));
    }

    static {
        symmetricTypes.add("PHYS:Near");
        symmetricTypes.add("PER-SOC:Business");
        symmetricTypes.add("PER-SOC:Family");
        symmetricTypes.add("PER-SOC:Other");
        symmetricTypes.add("PER-SOC:Lasting-Personal");
        symmetricTypes.add("EMP-ORG:Partner");
        symmetricTypes.add("EMP-ORG:Other");
        symmetricTypes.add("OTHER-AFF:Other");
    }
}

