/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEventArgumentValue;
import AceJet.AceMention;
import Jet.Lex.Tokenizer;
import Jet.Tipster.Span;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEntityMention
extends AceMention {
    public String type;
    public Span head;
    Span jetHead;
    String headText;
    String role;
    AceEntity entity;

    public AceEntityMention(String string, String string2, Span span, Span span2, String string3) {
        this.id = string;
        this.type = string2;
        this.extent = AceEntityMention.convertSpan(span, string3);
        this.jetExtent = span;
        this.head = AceEntityMention.convertSpan(span2, string3);
        this.jetHead = span2;
        this.entity = null;
        this.text = string3.substring(this.extent.start(), this.extent.end() + 1);
        this.headText = string3.substring(this.head.start(), this.head.end() + 1);
    }

    public AceEntityMention(Element element, String string) {
        this.id = element.getAttribute("ID");
        this.type = element.getAttribute("TYPE");
        this.role = element.getAttribute("ROLE");
        if (this.role == null) {
            this.role = "";
        }
        NodeList nodeList = element.getElementsByTagName("head");
        Element element2 = (Element)nodeList.item(0);
        this.head = AceEntityMention.decodeCharseq(element2);
        this.jetHead = AceEntityMention.aceSpanToJetSpan(this.head, string);
        this.headText = string.substring(this.head.start(), this.head.end() + 1);
        NodeList nodeList2 = element.getElementsByTagName("extent");
        Element element3 = (Element)nodeList2.item(0);
        if (element3 == null) {
            this.extent = this.head;
            this.jetExtent = this.jetHead;
            this.text = this.headText;
        } else {
            this.extent = AceEntityMention.decodeCharseq(element3);
            this.jetExtent = AceEntityMention.aceSpanToJetSpan(this.extent, string);
            this.text = string.substring(this.extent.start(), this.extent.end() + 1);
        }
    }

    public static Span convertSpan(Span span, String string) {
        int n;
        int n2 = span.start();
        for (n = span.end() - 1; n > n2 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        return new Span(n2, n);
    }

    static Span aceSpanToJetSpan(Span span, String string) {
        if (span == null) {
            return null;
        }
        int n = span.start();
        int n2 = span.end();
        int n3 = Tokenizer.skipWS(string, n2 + 1, string.length());
        Span span2 = new Span(n, n3);
        return span2;
    }

    public AceEventArgumentValue getParent() {
        return this.entity;
    }

    public String getType() {
        return this.entity.type;
    }

    public Span getJetHead() {
        return this.jetHead;
    }

    public String getHeadText() {
        return this.headText;
    }

    void write(PrintWriter printWriter) {
        String string = AceDocument.ace2004 ? this.type.substring(0, 3) : this.type;
        printWriter.print("    <entity_mention TYPE=\"" + string + "\" ID=\"" + this.id + "\"");
        if (this.role != null && !this.role.equals("")) {
            printWriter.print(" ROLE=\"" + this.role + "\"");
        }
        printWriter.println(">");
        printWriter.println("      <extent>");
        AceEntityMention.writeCharseq(printWriter, this.extent, this.text);
        printWriter.println("      </extent>");
        printWriter.println("      <head>");
        AceEntityMention.writeCharseq(printWriter, this.head, this.headText);
        printWriter.println("      </head>");
        printWriter.println("    </entity_mention>");
    }

    static Span decodeCharseq(Element element) {
        String string;
        String string2;
        if (AceDocument.ace2004) {
            NodeList nodeList = element.getElementsByTagName("charseq");
            Element element2 = (Element)nodeList.item(0);
            string2 = element2.getAttribute("START");
            string = element2.getAttribute("END");
        } else {
            string2 = AceDocument.getElementText(element, "start");
            string = AceDocument.getElementText(element, "end");
        }
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string);
        Span span = new Span(n, n2);
        return span;
    }

    static void writeCharseq(PrintWriter printWriter, Span span, String string) {
        if (AceDocument.ace2004) {
            printWriter.print("        <charseq START=\"" + span.start() + "\"" + " END=\"" + span.end() + "\">");
            printWriter.print(AceEntityMention.addXmlEscapes(string));
            printWriter.println("</charseq>");
        } else {
            printWriter.println("        <charseq>");
            printWriter.println("          <start>" + span.start() + "</start>");
            printWriter.println("          <!-- string = \"" + string + "\" -->");
            printWriter.println("          <end>" + span.end() + "</end>");
            printWriter.println("        </charseq>");
        }
    }

    static String addXmlEscapes(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&apos;");
        return string;
    }

    public boolean equals(Object object) {
        return object instanceof AceEntityMention && ((AceEntityMention)object).head.equals(this.head);
    }
}

