/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import org.pnuts.lang.ConstraintsTransformer;
import pnuts.compiler.ByteBuffer;
import pnuts.compiler.ClassFile;
import pnuts.compiler.ClassFileHandler;
import pnuts.compiler.CodeLoader;
import pnuts.compiler.CodeLoader0;
import pnuts.compiler.CompileContext;
import pnuts.compiler.Compiled;
import pnuts.compiler.CompiledScript;
import pnuts.compiler.ControlEnv;
import pnuts.compiler.Frame;
import pnuts.compiler.FrameInfo;
import pnuts.compiler.Label;
import pnuts.compiler.MultiClassLoader;
import pnuts.compiler.Preprocessor;
import pnuts.compiler.Reference;
import pnuts.compiler.TranslateContext;
import pnuts.lang.Context;
import pnuts.lang.Function;
import pnuts.lang.Generator;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsInterpreter;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.Visitor;

public class Compiler
extends Runtime
implements Visitor {
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = false;
    private static final Integer ONE = new Integer(1);
    private static final String SUPER = "super".intern();
    private static final String THIS = "this".intern();
    private static PnutsInterpreter interpreter = new PnutsInterpreter();
    private static Preprocessor preproc = new Preprocessor();
    private static boolean optimize = Compiler.getBoolean("pnuts.compiler.optimize");
    static boolean hasBootClassLoader = false;
    static boolean hasJava2Security;
    static CodeLoaderFactory codeLoaderFactory;
    static CodeLoaderFactory privilegedCodeLoaderFactory;
    private static boolean proxyConf;
    private long s;
    boolean _includeLineNo = !optimize;
    boolean _includeColumnNo = !optimize;
    boolean traceMode = Compiler.getBoolean("pnuts.compiler.traceMode");
    boolean includeMainMethod = false;
    private long classCount = 0L;
    boolean automatic;
    String className;
    String runtimeClassName;
    boolean useDynamicProxy = proxyConf;
    String sourceFile;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$pnuts$lang$Pnuts;

    private static boolean getBoolean(final String key) {
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String sval = Runtime.getProperty(key);
                if (sval != null && sval.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return b;
    }

    public Compiler() {
        this(null);
    }

    public Compiler(String className) {
        this(className, true);
    }

    public Compiler(String className, boolean automatic) {
        this(className, automatic, proxyConf);
    }

    public Compiler(String className, boolean automatic, boolean useDynamicProxy) {
        this.className = className == null ? "_pnuts_" : className;
        this.automatic = automatic;
        this.useDynamicProxy(useDynamicProxy);
    }

    public void includeLineNo(boolean flag) {
        this._includeLineNo = flag;
    }

    public void includeColumnNo(boolean flag) {
        this._includeColumnNo = flag;
    }

    public void includeMainMethod(boolean flag) {
        this.includeMainMethod = flag;
    }

    public void setTraceMode(boolean mode) {
        this.traceMode = mode;
    }

    public void useDynamicProxy(boolean flag) {
        this.useDynamicProxy = flag;
        this.runtimeClassName = flag ? "pnuts.compiler.DynamicRuntime" : "pnuts.lang.Runtime";
    }

    void addLineInfo(CompileContext cc, int ctx, SimpleNode node) {
        if (this._includeLineNo || this.traceMode) {
            int line = node.beginLine;
            int column = node.beginColumn;
            ClassFile cf = cc.cf;
            if (this._includeColumnNo && (cc.line != line || cc.column != column) || this.traceMode) {
                cf.loadLocal(ctx);
                cf.pushInteger(line);
                cf.pushInteger(column);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
                cc.column = column;
                cf.addLineNumber(line);
            } else if (cc.line != line) {
                cf.loadLocal(ctx);
                cf.pushInteger(line);
                cf.pushInteger(-1);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
                cc.line = line;
                cf.addLineNumber(line);
            }
        }
    }

    protected Object execute(CompileContext cc, Context context, boolean catchJump) {
        try {
            CodeLoader loader = Compiler.createCodeLoader(context.getClassLoader(), true);
            Class cls = cc.loadClasses(loader);
            Runtime rt = (Runtime)cls.newInstance();
            return rt.run(context);
        }
        catch (IOException io) {
            throw new PnutsException(io, context);
        }
        catch (InstantiationException ie) {
            throw new PnutsException(ie, context);
        }
        catch (IllegalAccessException iae) {
            throw new PnutsException(iae, context);
        }
    }

    void preprocess(SimpleNode node) {
        node.accept(preproc, new TranslateContext());
    }

    public Object startSet(SimpleNode node, Context context) {
        if (!this._includeLineNo && context.isVerbose()) {
            this._includeLineNo = true;
        }
        this.preprocess(node);
        return this.start(node, context);
    }

    public Object start(SimpleNode node, Context context) {
        try {
            this.preprocess(node);
            return this._start(node, context, true);
        }
        catch (ClassFormatError cfe) {
            if (this.automatic) {
                return node.accept(interpreter, context);
            }
            throw cfe;
        }
    }

    Object _start(SimpleNode node, Context context, boolean catchJump) {
        String s;
        int idx;
        CompileContext cc;
        Object src = null;
        if (this.automatic) {
            cc = new CompileContext();
            src = Runtime.getScriptSource(context);
        } else {
            cc = (CompileContext)context;
            src = cc.scriptSource;
        }
        if (src instanceof URL && (idx = (s = ((URL)src).toString()).lastIndexOf(47)) > 0) {
            this.sourceFile = s.substring(idx + 1);
        }
        cc.constClassName = this.className;
        ClassFile cf = cc.cf = new ClassFile(this.className, this.runtimeClassName, this.sourceFile, 1);
        cf.addInterface("pnuts.compiler.Compiled");
        cf.openMethod("<init>", "()V", (short)1);
        cf.add((byte)42);
        cf.add((byte)-73, this.runtimeClassName, "<init>", "()", "V");
        cf.add((byte)-79);
        cf.closeMethod();
        if (this.includeMainMethod) {
            cf.openMethod("main", "([Ljava/lang/String;)V", (short)9);
            cf.add((byte)-69, this.className);
            cf.add((byte)89);
            cf.add((byte)-73, this.className, "<init>", "()", "V");
            Label catchStart = cf.getLabel(true);
            cf.add((byte)-69, "pnuts.lang.Context");
            cf.add((byte)89);
            cf.add((byte)-73, "pnuts.lang.Context", "<init>", "()", "V");
            cf.add((byte)-71, "pnuts.lang.Executable", "run", "(Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            cf.add((byte)87);
            cf.add((byte)-79);
            Label catchEnd = cf.getLabel(true);
            Label catchTarget = cf.getLabel(true);
            cf.reserveStack(1);
            cf.add((byte)-74, "pnuts.lang.Jump", "getValue", "()", "Ljava/lang/Object;");
            cf.add((byte)87);
            cf.add((byte)-79);
            cf.addExceptionHandler(catchStart, catchEnd, catchTarget, "pnuts.lang.Jump");
            cf.closeMethod();
        }
        cf.openMethod("exec", "(Lpnuts/lang/Context;)Ljava/lang/Object;", (short)4);
        int ctx = 1;
        cc.setContextIndex(ctx);
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            int m = n - 1;
            for (int i = 0; i < m; ++i) {
                this.accept(node, i, cc);
                cf.add((byte)87);
            }
            this.accept(node, m, cc);
        } else {
            cf.add((byte)1);
        }
        cf.add((byte)-80);
        cf.closeMethod();
        cf.openMethod("<clinit>", "()V", (short)8);
        cf.addField("NO_PARAM", "[Ljava/lang/Object;", (short)8);
        cf.add((byte)3);
        cf.add((byte)-67, "java.lang.Object");
        cf.add((byte)-77, this.className, "NO_PARAM", "[Ljava/lang/Object;");
        Enumeration e = cc.constants.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            String k = (String)cc.constants.get(obj);
            if (obj instanceof Integer) {
                int value = (Integer)obj;
                cf.addField(k, "Ljava/lang/Integer;", (short)8);
                cf.add((byte)-69, "java.lang.Integer");
                cf.add((byte)89);
                cf.pushInteger(value);
                cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Integer;");
                continue;
            }
            if (obj instanceof Byte) {
                byte value = (Byte)obj;
                cf.addField(k, "Ljava/lang/Byte;", (short)8);
                cf.add((byte)-69, "java.lang.Byte");
                cf.add((byte)89);
                cf.pushInteger(value);
                cf.add((byte)-73, "java.lang.Byte", "<init>", "(B)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Byte;");
                continue;
            }
            if (obj instanceof Character) {
                char value = ((Character)obj).charValue();
                cf.addField(k, "Ljava/lang/Character;", (short)8);
                cf.add((byte)-69, "java.lang.Character");
                cf.add((byte)89);
                cf.pushInteger(value);
                cf.add((byte)-73, "java.lang.Character", "<init>", "(C)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Character;");
                continue;
            }
            if (obj instanceof Long) {
                long value = (Long)obj;
                cf.addField(k, "Ljava/lang/Long;", (short)8);
                cf.add((byte)-69, "java.lang.Long");
                cf.add((byte)89);
                cf.pushLong(value);
                cf.add((byte)-73, "java.lang.Long", "<init>", "(J)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Long;");
                continue;
            }
            if (obj instanceof Float) {
                float value = ((Float)obj).floatValue();
                cf.addField(k, "Ljava/lang/Float;", (short)8);
                cf.add((byte)-69, "java.lang.Float");
                cf.add((byte)89);
                cf.pushFloat(value);
                cf.add((byte)-73, "java.lang.Float", "<init>", "(F)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Float;");
                continue;
            }
            if (obj instanceof Double) {
                double value = (Double)obj;
                cf.addField(k, "Ljava/lang/Double;", (short)8);
                cf.add((byte)-69, "java.lang.Double");
                cf.add((byte)89);
                cf.pushDouble(value);
                cf.add((byte)-73, "java.lang.Double", "<init>", "(D)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Double;");
                continue;
            }
            if (obj instanceof BigDecimal) {
                cf.addField(k, "Ljava/math/BigDecimal;", (short)8);
                cf.add((byte)-69, "java.math.BigDecimal");
                cf.add((byte)89);
                cf.pushString(obj.toString());
                cf.add((byte)-73, "java.math.BigDecimal", "<init>", "(Ljava/lang/String;)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/math/BigDecimal;");
                continue;
            }
            if (!(obj instanceof BigInteger)) continue;
            cf.addField(k, "Ljava/math/BigInteger;", (short)8);
            cf.add((byte)-69, "java.math.BigInteger");
            cf.add((byte)89);
            cf.pushString(obj.toString());
            cf.add((byte)-73, "java.math.BigInteger", "<init>", "(Ljava/lang/String;)", "V");
            cf.add((byte)-77, this.className, k, "Ljava/math/BigInteger;");
        }
        cf.add((byte)-79);
        cf.closeMethod();
        if (this.automatic) {
            return this.execute(cc, context, catchJump);
        }
        return null;
    }

    public Object expressionList(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            int m = n - 1;
            for (int i = 0; i < m; ++i) {
                this.accept(node, i, context);
                cf.add((byte)87);
            }
            this.accept(node, m, context);
        } else {
            cf.add((byte)1);
        }
        return null;
    }

    public Object integerNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        String str = node.str;
        Object[] p = (Object[])node.info;
        Number n = (Number)p[0];
        String assoc = (String)cc.constants.get(n);
        if (assoc == null) {
            assoc = Compiler.gensym(context);
            cc.constants.put(n, assoc);
        }
        if (n instanceof Integer) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Integer;");
        } else if (n instanceof Long) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Long;");
        } else if (n instanceof Byte) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Byte;");
        } else if (n instanceof BigInteger) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigInteger;");
        } else if (n instanceof BigDecimal) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigDecimal;");
        } else {
            throw new InternalError("compiler error");
        }
        if (p[1] != null) {
            this.addLineInfo(cc, cc.getContextIndex(), node);
            int offset = ((int[])p[1])[0];
            cf.add((byte)-64, "java.lang.Number");
            cf.pushString(str.substring(0, offset));
            cf.add((byte)18, cf.addConstant(str.substring(offset)));
            cf.loadLocal(cc.getContextIndex());
            cf.add((byte)-72, "pnuts.lang.Runtime", "quantity", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object floatingNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        String str = node.str;
        Object[] p = (Object[])node.info;
        Number n = (Number)p[0];
        String assoc = (String)cc.constants.get(n);
        if (assoc == null) {
            assoc = Compiler.gensym(context);
            cc.constants.put(n, assoc);
        }
        if (n instanceof Float) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Float;");
        } else if (n instanceof Double) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Double;");
        } else if (n instanceof BigDecimal) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigDecimal;");
        } else {
            throw new InternalError("compiler error");
        }
        if (p[1] != null) {
            this.addLineInfo(cc, cc.getContextIndex(), node);
            int offset = ((int[])p[1])[0];
            cf.add((byte)-64, "java.lang.Number");
            cf.add((byte)18, cf.addConstant(str.substring(0, offset)));
            cf.add((byte)18, cf.addConstant(str.substring(offset)));
            cf.loadLocal(cc.getContextIndex());
            cf.add((byte)-72, "pnuts.lang.Runtime", "quantity", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object stringNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        cf.pushString(node.str);
        return null;
    }

    public Object characterNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        Character ch = (Character)node.info;
        String assoc = (String)cc.constants.get(ch);
        if (assoc == null) {
            assoc = Compiler.gensym(context);
            cc.constants.put(ch, assoc);
        }
        cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Character;");
        return null;
    }

    public Object classNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            cf.add((byte)-78, "pnuts.lang.PnutsFunction", "CLASS", "Lpnuts/lang/PnutsFunction;");
            return null;
        }
        SimpleNode c = node.jjtGetChild(0);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(c.jjtGetChild((int)0).str);
        n = c.jjtGetNumChildren();
        for (int i = 1; i < n; ++i) {
            SimpleNode ch = c.jjtGetChild(i);
            sbuf.append('.');
            sbuf.append(ch.str);
        }
        String name = sbuf.toString();
        cf.add((byte)18, cf.addConstant(name));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Pnuts", "loadClass", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Class;");
        return null;
    }

    public Object newNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        SimpleNode n0 = node.jjtGetChild(0);
        int n = node.jjtGetNumChildren();
        if (n == 3 && node.jjtGetChild((int)2).id == 12) {
            cf.add((byte)-69, "pnuts.lang.Package");
            cf.add((byte)89);
            cf.add((byte)1);
            cf.add((byte)1);
            cf.add((byte)-73, "pnuts.lang.Package", "<init>", "(Ljava/lang/String;Lpnuts/lang/Package;)", "V");
            int pkg = cf.getLocal();
            cf.storeLocal(pkg);
            int f = cf.getLocal();
            int mode = Compiler.findThisAndSuper(node, 0);
            SimpleNode classDef = node.jjtGetChild(2);
            SignatureInfo[] siginfo = new SignatureInfo[classDef.jjtGetNumChildren()];
            for (int i = 0; i < classDef.jjtGetNumChildren(); ++i) {
                SimpleNode block;
                SimpleNode param;
                String symbol;
                SimpleNode methodDef = classDef.jjtGetChild(i);
                SimpleNode n1 = methodDef.jjtGetChild(0);
                SimpleNode returnTypeNode = null;
                siginfo[i] = new SignatureInfo();
                siginfo[i].methodName = symbol = methodDef.str;
                if (n1.id == 16) {
                    returnTypeNode = n1;
                    param = methodDef.jjtGetChild(1);
                    block = methodDef.jjtGetChild(2);
                } else {
                    param = methodDef.jjtGetChild(0);
                    block = methodDef.jjtGetChild(1);
                }
                SimpleNode newParam = new SimpleNode(99);
                int j = 0;
                if ((mode & 1) == 1) {
                    SimpleNode p0 = new SimpleNode(100);
                    p0.str = "this";
                    newParam.jjtAddChild(p0, j);
                    ++j;
                }
                if ((mode & 2) == 2) {
                    SimpleNode p1 = new SimpleNode(100);
                    p1.str = "super";
                    newParam.jjtAddChild(p1, j);
                    ++j;
                }
                int nargs = param.jjtGetNumChildren();
                SimpleNode[] paramTypeNode = new SimpleNode[nargs];
                for (int k = 0; k < nargs; ++k) {
                    SimpleNode c = param.jjtGetChild(k);
                    SimpleNode cp = param.jjtGetChild(k);
                    if (c.jjtGetNumChildren() > 1) {
                        cp = c.jjtGetChild(1);
                        paramTypeNode[k] = c.jjtGetChild(0);
                    } else {
                        cp = c.jjtGetChild(0);
                    }
                    newParam.jjtAddChild(cp, k + j);
                }
                siginfo[i].paramTypeNode = paramTypeNode;
                siginfo[i].returnTypeNode = returnTypeNode;
                SimpleNode fnode = new SimpleNode(98);
                fnode.setAttribute("isMethod", Boolean.TRUE);
                fnode.info = methodDef.info;
                fnode.setAttribute("frameInfo", methodDef.getAttribute("frameInfo"));
                fnode.str = symbol;
                fnode.jjtAddChild(newParam, 0);
                fnode.jjtAddChild(block, 1);
                fnode.jjtSetParent(methodDef.jjtGetParent());
                fnode.accept(this, cc);
                cf.storeLocal(f);
                cf.loadLocal(pkg);
                cf.add((byte)18, cf.addConstant(fnode.str));
                cf.loadLocal(f);
                cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;)", "V");
            }
            this.resolveClassName(n0, cc, ctx);
            int type = cf.getLocal();
            cf.storeLocal(type);
            cf.pushInteger(siginfo.length);
            cf.add((byte)-67, "org.pnuts.lang.Signature");
            for (int i = 0; i < siginfo.length; ++i) {
                cf.add((byte)89);
                cf.pushInteger(i);
                cf.add((byte)-69, "org.pnuts.lang.Signature");
                cf.add((byte)89);
                SignatureInfo s = siginfo[i];
                SimpleNode rtnode = s.returnTypeNode;
                SimpleNode[] pnodes = s.paramTypeNode;
                cf.add((byte)18, cf.addConstant(s.methodName));
                if (rtnode != null) {
                    this.resolveClassName(rtnode, cc, ctx);
                } else {
                    cf.add((byte)1);
                }
                if (pnodes != null) {
                    int len = pnodes.length;
                    cf.pushInteger(len);
                    cf.add((byte)-67, "java.lang.Class");
                    for (int j = 0; j < len; ++j) {
                        cf.add((byte)89);
                        cf.pushInteger(j);
                        if (pnodes[j] != null) {
                            this.resolveClassName(pnodes[j], cc, ctx);
                        } else {
                            cf.add((byte)1);
                        }
                        cf.add((byte)83);
                    }
                } else {
                    cf.add((byte)1);
                }
                cf.add((byte)1);
                cf.add((byte)-73, "org.pnuts.lang.Signature", "<init>", "(Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Class;[Ljava/lang/Class;)", "V");
                cf.add((byte)83);
            }
            int sig = cf.getLocal();
            cf.storeLocal(sig);
            int subclass = cf.getLocal();
            this.generateSubclass(cf, type, pkg, sig, ctx, mode);
            cf.storeLocal(subclass);
            cf.loadLocal(ctx);
            cf.loadLocal(subclass);
            this._listElements(node.jjtGetChild(1), context);
            cf.add((byte)-64, "[Ljava/lang/Object;");
            cf.add((byte)1);
            cf.add((byte)-72, "pnuts.lang.Runtime", "callConstructor", "(Lpnuts/lang/Context;Ljava/lang/Class;[Ljava/lang/Object;[Ljava/lang/Class;)", "Ljava/lang/Object;");
            cf.freeLocal(pkg);
            cf.freeLocal(type);
            cf.freeLocal(f);
        } else if (n0.id == 15) {
            Object[] idx = Compiler.parseIndex(n0);
            Object[] dim = (Object[])idx[1];
            SimpleNode nameNode = (SimpleNode)idx[0];
            if (node.getAttribute("hasTryStatement") != null) {
                int i;
                int[] vars = new int[dim.length];
                for (i = 0; i < dim.length; ++i) {
                    int var = cf.getLocal();
                    ((SimpleNode)dim[i]).accept(this, context);
                    cf.storeLocal(var);
                    vars[i] = var;
                }
                this.resolveClassName(nameNode, cc, ctx);
                cf.pushInteger(dim.length);
                cf.add((byte)-68, 10);
                for (i = 0; i < dim.length; ++i) {
                    cf.add((byte)89);
                    cf.pushInteger(i);
                    cf.loadLocal(vars[i]);
                    cf.add((byte)-64, "java.lang.Number");
                    cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
                    cf.add((byte)79);
                }
                for (i = 0; i < dim.length; ++i) {
                    cf.freeLocal(vars[i]);
                }
            } else {
                this.resolveClassName(nameNode, cc, ctx);
                cf.pushInteger(dim.length);
                cf.add((byte)-68, 10);
                for (int i = 0; i < dim.length; ++i) {
                    cf.add((byte)89);
                    cf.pushInteger(i);
                    ((SimpleNode)dim[i]).accept(this, context);
                    cf.add((byte)-64, "java.lang.Number");
                    cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
                    cf.add((byte)79);
                }
            }
            cf.add((byte)-72, "java.lang.reflect.Array", "newInstance", "(Ljava/lang/Class;[I)", "Ljava/lang/Object;");
        } else if (n0.id == 14) {
            this.arrayType(n0, context);
        } else if (n0.id == 11) {
            cf.loadLocal(ctx);
            this.accept(n0, 0, context);
            cf.add((byte)-64, "java.lang.Class");
            this._listElements(n0.jjtGetChild(1), context);
            cf.add((byte)4);
            cf.add((byte)-72, "pnuts.lang.Runtime", "cast", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/Object;Z)", "Ljava/lang/Object;");
        } else {
            if (node.getAttribute("hasTryStatement") != null) {
                int arg = cf.getLocal();
                this._listElements(node.jjtGetChild(1), context);
                cf.storeLocal(arg);
                cf.loadLocal(ctx);
                SimpleNode nameNode = node.jjtGetChild(0);
                this.resolveClassName(nameNode, cc, ctx);
                cf.loadLocal(arg);
                cf.freeLocal(arg);
            } else {
                cf.loadLocal(ctx);
                SimpleNode nameNode = node.jjtGetChild(0);
                this.resolveClassName(nameNode, cc, ctx);
                this._listElements(node.jjtGetChild(1), context);
            }
            cf.add((byte)-64, "[Ljava/lang/Object;");
            cf.add((byte)1);
            cf.add((byte)-72, "pnuts.lang.Runtime", "callConstructor", "(Lpnuts/lang/Context;Ljava/lang/Class;[Ljava/lang/Object;[Ljava/lang/Class;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object classDef(SimpleNode node, Context context) {
        return null;
    }

    public Object methodDef(SimpleNode node, Context context) {
        return null;
    }

    static int findThisAndSuper(SimpleNode node, int mode) {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            if (c.id == 5) {
                if (c.str == SUPER) {
                    mode |= 2;
                    continue;
                }
                if (c.str != THIS) continue;
                mode |= 1;
                continue;
            }
            mode |= Compiler.findThisAndSuper(c, mode);
        }
        return mode;
    }

    void generateSubclass(ClassFile cf, int type, int pkg, int siginfo, int ctx, int mode) {
        int sbuf = cf.getLocal();
        cf.add((byte)-69, "java.lang.StringBuffer");
        cf.add((byte)89);
        cf.add((byte)-73, "java.lang.StringBuffer", "<init>", "()", "V");
        cf.storeLocal(sbuf);
        cf.loadLocal(sbuf);
        cf.loadLocal(type);
        cf.add((byte)-74, "java.lang.Class", "getName", "()", "Ljava/lang/String;");
        cf.pushInteger(46);
        cf.pushInteger(95);
        cf.add((byte)-74, "java.lang.String", "replace", "(CC)", "Ljava/lang/String;");
        cf.add((byte)-74, "java.lang.StringBuffer", "append", "(Ljava/lang/String;)", "Ljava/lang/StringBuffer;");
        cf.storeLocal(sbuf);
        cf.loadLocal(sbuf);
        cf.add((byte)18, cf.addConstant("__adapter"));
        cf.add((byte)-74, "java.lang.StringBuffer", "append", "(Ljava/lang/String;)", "Ljava/lang/StringBuffer;");
        cf.storeLocal(sbuf);
        cf.loadLocal(type);
        cf.add((byte)-74, "java.lang.Class", "isInterface", "()", "Z");
        int itf = cf.getLocal();
        int superclass = cf.getLocal();
        Label not_itf = cf.getLabel();
        cf.add((byte)-103, not_itf);
        cf.add((byte)4);
        cf.add((byte)-67, "java.lang.Class");
        cf.add((byte)89);
        cf.add((byte)3);
        cf.loadLocal(type);
        cf.add((byte)83);
        cf.storeLocal(itf);
        cf.add((byte)18, cf.addConstant("java.lang.Object"));
        cf.add((byte)-72, "java.lang.Class", "forName", "(Ljava/lang/String;)", "Ljava/lang/Class;");
        cf.storeLocal(superclass);
        Label last = cf.getLabel();
        cf.add((byte)-89, last);
        not_itf.fix();
        cf.add((byte)1);
        cf.storeLocal(itf);
        cf.loadLocal(type);
        cf.storeLocal(superclass);
        last.fix();
        cf.loadLocal(sbuf);
        cf.add((byte)-74, "java.lang.StringBuffer", "toString", "()", "Ljava/lang/String;");
        cf.loadLocal(superclass);
        cf.loadLocal(itf);
        cf.loadLocal(siginfo);
        cf.loadLocal(pkg);
        cf.loadLocal(ctx);
        cf.pushInteger(mode);
        cf.add((byte)-72, "org.pnuts.lang.SubtypeGenerator", "generateSubclass", "(Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Class;[Lorg/pnuts/lang/Signature;Lpnuts/lang/Package;Lpnuts/lang/Context;I)", "Ljava/lang/Class;");
        cf.freeLocal(sbuf);
        cf.freeLocal(superclass);
        cf.freeLocal(itf);
    }

    public Object importNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        String t2 = node.str;
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            if ("*".equals(t2)) {
                cf.loadLocal(ctx);
                cf.add((byte)18, cf.addConstant("*"));
                cf.add((byte)-72, "pnuts.lang.Runtime", "addImport", "(Lpnuts/lang/Context;Ljava/lang/String;)", "V");
                cf.add((byte)1);
            } else if ("(".equals(t2)) {
                cf.add((byte)-78, "pnuts.lang.PnutsFunction", "IMPORT", "Lpnuts/lang/PnutsFunction;");
                cf.add((byte)-78, this.className, "NO_PARAM", "[Ljava/lang/Object;");
                cf.loadLocal(ctx);
                cf.add((byte)-74, "pnuts.lang.PnutsFunction", "call", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            } else {
                cf.add((byte)-78, "pnuts.lang.PnutsFunction", "IMPORT", "Lpnuts/lang/PnutsFunction;");
            }
            return null;
        }
        if (n == 1 && node.jjtGetChild((int)0).id != 17) {
            int arg = cf.getLocal();
            this.accept(node, 0, context);
            cf.storeLocal(arg);
            cf.add((byte)-78, "pnuts.lang.PnutsFunction", "IMPORT", "Lpnuts/lang/PnutsFunction;");
            cf.add((byte)4);
            cf.add((byte)-67, "java.lang.Object");
            cf.add((byte)89);
            cf.add((byte)3);
            cf.loadLocal(arg);
            cf.freeLocal(arg);
            cf.add((byte)83);
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.PnutsFunction", "call", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(node.jjtGetChild((int)0).str);
        for (int i = 1; i < n; ++i) {
            sbuf.append('.');
            sbuf.append(node.jjtGetChild((int)i).str);
        }
        cf.loadLocal(ctx);
        if (node.info != null) {
            cf.add((byte)18, cf.addConstant(sbuf.toString()));
            cf.add(t2 == null ? (byte)3 : 4);
            cf.add((byte)-72, "pnuts.lang.Runtime", "addStaticMembers", "(Lpnuts/lang/Context;Ljava/lang/String;Z)", "V");
        } else {
            if (t2 != null) {
                sbuf.append(".*");
            }
            cf.add((byte)18, cf.addConstant(sbuf.toString()));
            cf.add((byte)-72, "pnuts.lang.Runtime", "addImport", "(Lpnuts/lang/Context;Ljava/lang/String;)", "V");
        }
        cf.add((byte)1);
        return null;
    }

    void booleanCheck(int id, ClassFile cf, Context context) {
        if (id != 28 && id != 29 && id != 54 && id != 52 && id != 55 && id != 53 && id != 49 && id != 50 && id != 51 && id != 46 && id != 48 && id != 67) {
            int index = cf.getLocal();
            cf.add((byte)89);
            cf.storeLocal(index);
            cf.add((byte)-63, "java.lang.Boolean");
            Label l_next = cf.getLabel();
            cf.add((byte)-102, l_next);
            Label l_next_2 = cf.getLabel();
            cf.loadLocal(index);
            cf.add((byte)-72, "pnuts.lang.Runtime", "toBoolean", "(Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            cf.add((byte)-89, l_next_2);
            l_next.fix();
            cf.loadLocal(index);
            l_next_2.fix();
            cf.freeLocal(index);
        }
    }

    public Object logAndNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.addLineInfo(cc, cc.getContextIndex(), node);
        this.accept(node, 0, context);
        this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
        cf.add((byte)-64, "java.lang.Boolean");
        int tgt1 = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt1);
        cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
        Label l_else = cf.getLabel();
        cf.add((byte)-103, l_else);
        this.accept(node, 1, context);
        this.booleanCheck(node.jjtGetChild((int)1).id, cf, context);
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        l_else.fix();
        cf.stackTop = (short)(cf.stackTop - 1);
        cf.loadLocal(tgt1);
        next.fix();
        cf.freeLocal(tgt1);
        return null;
    }

    public Object logOrNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.addLineInfo(cc, cc.getContextIndex(), node);
        this.accept(node, 0, context);
        this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
        cf.add((byte)-64, "java.lang.Boolean");
        int tgt1 = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt1);
        cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
        Label l_else = cf.getLabel();
        cf.add((byte)-102, l_else);
        this.accept(node, 1, context);
        this.booleanCheck(node.jjtGetChild((int)1).id, cf, context);
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        l_else.fix();
        cf.stackTop = (short)(cf.stackTop - 1);
        cf.loadLocal(tgt1);
        next.fix();
        cf.freeLocal(tgt1);
        return null;
    }

    public Object logNotNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.addLineInfo(cc, cc.getContextIndex(), node);
        this.accept(node, 0, context);
        this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
        cf.add((byte)-64, "java.lang.Boolean");
        cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
        Label t = cf.getLabel();
        Label next = cf.getLabel();
        cf.add((byte)-103, t);
        cf.add((byte)-78, "java.lang.Boolean", "FALSE", "Ljava/lang/Boolean;");
        cf.add((byte)-89, next);
        t.fix();
        cf.stackTop = (short)(cf.stackTop - 1);
        cf.add((byte)-78, "java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
        next.fix();
        return null;
    }

    static boolean canConstantFold(SimpleNode node) {
        return Compiler.isConstant(node.jjtGetChild(0)) && Compiler.isConstant(node.jjtGetChild(1));
    }

    static boolean isConstant(SimpleNode node) {
        switch (node.id) {
            case 24: {
                Object[] p = (Object[])node.info;
                return p[1] == null;
            }
            case 25: {
                Object[] p = (Object[])node.info;
                return p[1] == null;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    Object binary(String operator, SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        SimpleNode n0 = node.jjtGetChild(0);
        SimpleNode n1 = node.jjtGetChild(1);
        if (node.getAttribute("hasTryStatement") != null) {
            int arg0 = cf.getLocal();
            int arg1 = cf.getLocal();
            n0.accept(this, context);
            cf.storeLocal(arg0);
            n1.accept(this, context);
            cf.storeLocal(arg1);
            cf.loadLocal(arg0);
            cf.loadLocal(arg1);
            cf.freeLocal(arg0);
            cf.freeLocal(arg1);
        } else {
            n0.accept(this, context);
            n1.accept(this, context);
        }
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", operator, "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        return null;
    }

    public Object shiftLeftNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.shiftLeftNode(node, context), context);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("shiftLeft", node, context);
    }

    public Object shiftRightNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.shiftRightNode(node, context), context);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("shiftRight", node, context);
    }

    public Object shiftArithmeticNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.shiftArithmeticNode(node, context), context);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("shiftArithmetic", node, context);
    }

    static void addConstant(Object n, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        if (n instanceof String) {
            cf.add((byte)18, cf.addConstant((String)n));
            return;
        }
        String assoc = (String)cc.constants.get(n);
        if (assoc == null) {
            assoc = Compiler.gensym(cc);
            cc.constants.put(n, assoc);
        }
        if (n instanceof Integer) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Integer;");
        } else if (n instanceof Long) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Long;");
        } else if (n instanceof Byte) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Byte;");
        } else if (n instanceof BigInteger) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigInteger;");
        } else if (n instanceof BigDecimal) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigDecimal;");
        } else if (n instanceof Float) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Float;");
        } else if (n instanceof Double) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Double;");
        } else {
            throw new InternalError("compiler error");
        }
    }

    public Object addNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.addNode(node, context), context);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("add", node, context);
    }

    public Object subtractNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.subtractNode(node, context), context);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("subtract", node, context);
    }

    public Object multNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.multNode(node, context), context);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("multiply", node, context);
    }

    public Object divideNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.divideNode(node, context), context);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("divide", node, context);
    }

    public Object modNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.modNode(node, context), context);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("mod", node, context);
    }

    public Object xorNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Object xor = interpreter.xorNode(node, context);
                if (xor instanceof Number) {
                    Compiler.addConstant(xor, context);
                    return null;
                }
                if (xor instanceof Boolean) {
                    CompileContext cc = (CompileContext)context;
                    ClassFile cf = cc.cf;
                    if (((Boolean)xor).booleanValue()) {
                        cf.add((byte)3);
                    } else {
                        cf.add((byte)4);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("xor", node, context);
    }

    public Object orNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Object or = interpreter.orNode(node, context);
                if (or instanceof Number) {
                    Compiler.addConstant(or, context);
                    return null;
                }
                if (or instanceof Boolean) {
                    CompileContext cc = (CompileContext)context;
                    ClassFile cf = cc.cf;
                    if (((Boolean)or).booleanValue()) {
                        cf.add((byte)3);
                    } else {
                        cf.add((byte)4);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("or", node, context);
    }

    public Object andNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Object and = interpreter.andNode(node, context);
                if (and instanceof Number) {
                    Compiler.addConstant(and, context);
                    return null;
                }
                if (and instanceof Boolean && ((Boolean)and).booleanValue()) {
                    CompileContext cc = (CompileContext)context;
                    ClassFile cf = cc.cf;
                    if (((Boolean)and).booleanValue()) {
                        cf.add((byte)3);
                    } else {
                        cf.add((byte)4);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.binary("and", node, context);
    }

    Object unary(String operator, SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        int ctx = cc.getContextIndex();
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", operator, "(Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        return null;
    }

    public Object negativeNode(SimpleNode node, Context context) {
        return this.unary("negate", node, context);
    }

    public Object notNode(SimpleNode node, Context context) {
        return this.unary("not", node, context);
    }

    Object bool(String operator, SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        if (node.getAttribute("hasTryStatement") != null) {
            int arg0 = cf.getLocal();
            int arg1 = cf.getLocal();
            this.accept(node, 0, cc);
            cf.storeLocal(arg0);
            this.accept(node, 1, cc);
            cf.storeLocal(arg1);
            cf.loadLocal(arg0);
            cf.loadLocal(arg1);
            cf.freeLocal(arg0);
            cf.freeLocal(arg1);
        } else {
            this.accept(node, 0, cc);
            this.accept(node, 1, cc);
        }
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", operator, "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Z");
        if (Compiler.isConditionalNode(node)) {
            node.setAttribute("inlinedBoolean", Boolean.TRUE);
        } else {
            Label deny = cf.getLabel();
            cf.add((byte)-103, deny);
            cf.add((byte)-78, "java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
            Label next = cf.getLabel();
            cf.add((byte)-89, next);
            deny.fix();
            cf.stackTop = (short)(cf.stackTop - 1);
            cf.add((byte)-78, "java.lang.Boolean", "FALSE", "Ljava/lang/Boolean;");
            next.fix();
        }
        return null;
    }

    public Object ltNode(SimpleNode node, Context context) {
        return this.bool("lt", node, context);
    }

    public Object leNode(SimpleNode node, Context context) {
        return this.bool("le", node, context);
    }

    public Object gtNode(SimpleNode node, Context context) {
        return this.bool("gt", node, context);
    }

    public Object geNode(SimpleNode node, Context context) {
        return this.bool("ge", node, context);
    }

    public Object equalNode(SimpleNode node, Context context) {
        return this.bool("eq", node, context);
    }

    public Object notEqNode(SimpleNode node, Context context) {
        return this.bool("ne", node, context);
    }

    public Object ifStatement(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        SimpleNode condNode = node.jjtGetChild(0);
        condNode.accept(this, context);
        Label l_else = cf.getLabel();
        Label next = cf.getLabel();
        cc.openBranchEnv();
        if (condNode.getAttribute("inlinedBoolean") != null) {
            cf.add((byte)-103, l_else);
            this.accept(node, 1, context);
            cf.add((byte)-89, next);
            l_else.fix();
            cf.stackTop = (short)(cf.stackTop - 1);
        } else {
            this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
            cf.add((byte)-64, "java.lang.Boolean");
            cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
            cf.add((byte)-103, l_else);
            this.accept(node, 1, context);
            cf.add((byte)-89, next);
            l_else.fix();
            cf.stackTop = (short)(cf.stackTop - 1);
        }
        int n = node.jjtGetNumChildren();
        boolean j = false;
        for (int i = 2; i < n; ++i) {
            SimpleNode _node = node.jjtGetChild(i);
            if (_node.id == 79) {
                cc.addBranch();
                SimpleNode _condNode = _node.jjtGetChild(0);
                _condNode.accept(this, context);
                Label next_else = cf.getLabel();
                if (_condNode.getAttribute("inlinedBoolean") != null) {
                    cf.add((byte)-103, next_else);
                    this.accept(_node, 1, context);
                    cf.add((byte)-89, next);
                    next_else.fix();
                    cf.stackTop = (short)(cf.stackTop - 1);
                    continue;
                }
                this.booleanCheck(_node.jjtGetChild((int)0).id, cf, context);
                cf.add((byte)-64, "java.lang.Boolean");
                cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
                cf.add((byte)-103, next_else);
                this.accept(_node, 1, context);
                cf.add((byte)-89, next);
                next_else.fix();
                cf.stackTop = (short)(cf.stackTop - 1);
                continue;
            }
            if (_node.id != 80) continue;
            cc.addBranch();
            this.accept(_node, 0, context);
            if (i == n - 1) {
                next.fix();
                cc.closeBranchEnv();
                return null;
            }
            cf.add((byte)-89, next);
        }
        cf.add((byte)1);
        cc.closeBranchEnv();
        next.fix();
        return null;
    }

    static boolean isLeafFrame(SimpleNode node) {
        FrameInfo info = (FrameInfo)node.getAttribute("frameInfo");
        if (!info.leafCheckDone) {
            Compiler.scanLeafFrames(node);
        }
        return info.isLeaf;
    }

    private static boolean isFrame(SimpleNode node) {
        int id = node.id;
        if (id == 98 || id == 13 || id == 94) {
            return true;
        }
        if (id == 89) {
            SimpleNode c = node.jjtGetChild(0);
            if (c.id == 90) {
                return c.jjtGetNumChildren() == 1;
            }
        }
        return false;
    }

    static boolean scanLeafFrames(SimpleNode node) {
        boolean c2;
        FrameInfo info;
        boolean c = true;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode child = node.jjtGetChild(i);
            if (Compiler.scanLeafFrames(child)) continue;
            if (Compiler.isFrame(node)) {
                info = (FrameInfo)node.getAttribute("frameInfo");
                if (info == null) {
                    info = new FrameInfo();
                    node.setAttribute("frameInfo", info);
                }
                info.isLeaf = false;
                info.leafCheckDone = true;
            }
            c = false;
        }
        boolean c1 = !Compiler.isFrame(node);
        boolean bl = c2 = c && c1;
        if (node.id == 98 || node.id == 13) {
            info = (FrameInfo)node.getAttribute("frameInfo");
            if (info == null) {
                info = new FrameInfo();
                node.setAttribute("frameInfo", info);
            }
            info.isLeaf = c;
            info.leafCheckDone = true;
        }
        return c2;
    }

    /*
     * Unable to fully structure code
     */
    public Object functionStatement(SimpleNode node, Context context) {
        info = (FrameInfo)node.getAttribute("frameInfo");
        if (info == null) {
            info = new FrameInfo();
            node.setAttribute("frameInfo", info);
        }
        if (!info.preprocessed) {
            this.preprocess(node);
        }
        cc = (CompileContext)context;
        ctx = cc.getContextIndex();
        cf = cc.cf;
        this.addLineInfo(cc, ctx, node);
        block = node.jjtGetChild(1);
        param = node.jjtGetChild(0);
        nargs = param.jjtGetNumChildren();
        locals = new String[nargs];
        n0 = null;
        if (nargs != 1) ** GOTO lbl-1000
        n0 = param.jjtGetChild(0);
        if (n0.id == 15) {
            nargs = -1;
            locals[0] = n0.jjtGetChild((int)0).str;
        } else lbl-1000:
        // 3 sources

        {
            for (j = 0; j < nargs; ++j) {
                locals[j] = param.jjtGetChild((int)j).str;
            }
        }
        isGenerator = Runtime.isGenerator(block);
        cls = this.className + "$" + (this.classCount++ & 0x7FFFFFFFFFFFFFFFL);
        cf = new ClassFile(cls, "pnuts.lang.Function", this.sourceFile, 1);
        cf.addInterface("pnuts.compiler.Compiled");
        cc.classFiles.addElement(cf);
        cf.parent = cc.cf;
        cf.openMethod("register", "(Lpnuts/lang/PnutsFunction;Z)Lpnuts/lang/PnutsFunction;", (short)1);
        cf.add((byte)42);
        cf.add((byte)43);
        cf.add((byte)28);
        cf.add((byte)-73, "pnuts.lang.Function", "register", "(Lpnuts/lang/PnutsFunction;Z)", "Lpnuts/lang/PnutsFunction;");
        cf.add((byte)-80);
        cf.closeMethod();
        if (Compiler.optimize) {
            cf.openMethod("unparse", "(Lpnuts/lang/Context;)Ljava/lang/String;", (short)4);
            cf.pushString(Runtime.unparse(node, context));
            cf.add((byte)-80);
            cf.closeMethod();
        } else {
            cf.openMethod("getNode", "()Lpnuts/lang/SimpleNode;", (short)4);
            cf.pushString(Runtime.saveNode(node));
            cf.add((byte)-72, "pnuts.lang.Runtime", "loadNode", "(Ljava/lang/String;)", "Lpnuts/lang/SimpleNode;");
            cf.add((byte)-80);
            cf.closeMethod();
        }
        fname = node.str;
        cc._openFrame(fname, locals, Compiler.isLeafFrame(node));
        cf.openMethod("exec", "([Ljava/lang/Object;Lpnuts/lang/Context;)Ljava/lang/Object;", (short)4);
        cc2 = (CompileContext)cc.clone();
        cc2.line = -1;
        cc2.cf = cf;
        cc2.setContextIndex(2);
        cc2.returnLabel = cf.getLabel();
        code = cf.codeBuffer;
        cf.codeBuffer = blockCode = new ByteBuffer();
        if (fname != null) {
            f = cf.getLocal();
            cc2._declare_frame(fname, f);
            cf.add((byte)42);
            cf.add((byte)-76, "pnuts.lang.Function", "function", "Lpnuts/lang/PnutsFunction;");
            cf.storeLocal(f);
        }
        expt = cf.getLocal();
        cc2._declare(Runtime.EXCEPTOIN_FIELD_SYMBOL, expt, -1);
        cc3 = null;
        cf2 = null;
        if (isGenerator) {
            cls2 = this.className + "$" + (this.classCount++ & 0x7FFFFFFFFFFFFFFFL);
            cf2 = new ClassFile(cls2, "pnuts.lang.PnutsFunction", this.sourceFile, 1);
            cc.classFiles.addElement(cf2);
            cf2.parent = cf;
            closureSymbol = "yield".intern();
            gnode = Generator.convertYield(block, closureSymbol);
            cc3 = (CompileContext)cc2.clone();
            cc3.cf = cf2;
            cc3._openFrame(fname, locals, false);
            cf2.openMethod("exec", "([Ljava/lang/Object;Lpnuts/lang/Context;)Ljava/lang/Object;", (short)4);
            cf2.loadLocal(0);
            cf2.add((byte)-76, cls2, "$context$", "Lpnuts/lang/Context;");
            cf2.storeLocal(2);
            cc3.setContextIndex(2);
            cc3.returnLabel = cf2.getLabel();
            code2 = cf2.codeBuffer;
            cf2.codeBuffer = blockCode2 = new ByteBuffer();
            cc3.openScope(new String[0]);
            args = cf2.getLocal();
            cf2.loadLocal(0);
            cf2.add((byte)-76, cls2, "args", "[Ljava/lang/Object;");
            cf2.storeLocal(args);
            for (i = 0; i < locals.length; ++i) {
                cc3._declare(locals[i], args, i);
            }
            closure = cf2.getLocal();
            cc3._declare(closureSymbol, closure, -1);
            cf2.add((byte)43);
            cf2.add((byte)3);
            cf2.add((byte)50);
            cf2.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf2.storeLocal(closure);
            gnode.accept(this, cc3);
            cc3.returnLabel.fix();
            cf2.codeBuffer = code2;
            infos = cc3.env.bottom.info;
            count = cc3.env.bottom.count;
            for (i = 0; i < infos.length; ++i) {
                if (infos[i] == null) continue;
                idx = infos[i].index;
                sym = infos[i].symbol;
                map = infos[i].map;
                if (idx < 0) {
                    cf2.add((byte)1);
                    cf2.storeLocal(map);
                    continue;
                }
                if (idx != 0) continue;
                cf2.add((byte)4);
                cf2.add((byte)-67, "java.lang.Object");
                cf2.add((byte)89);
                cf2.add((byte)3);
                cf2.add((byte)1);
                cf2.add((byte)83);
                cf2.storeLocal(map);
            }
            cf2.shift(code2.size());
            blockCode2.prepend(code2);
            cf2.codeBuffer = blockCode2;
            cf2.add((byte)-80);
            cc3.closeScope();
            cf2.closeMethod();
            exports = (Vector)cc3.env.parent.exports.get(cc3.env);
            cc3._closeFrame();
            arg = new StringBuffer("([Ljava/lang/Object;");
            n_names = 0;
            if (exports != null) {
                n_names = exports.size();
            }
            names = new String[n_names];
            j = 0;
            if (n_names > 0) {
                e = exports.elements();
                while (e.hasMoreElements()) {
                    names[j++] = ((Reference)e.nextElement()).symbol;
                    arg.append("[Ljava/lang/Object;");
                }
            }
            arg.append("Lpnuts/lang/Context;");
            arg.append(')');
            cf2.openMethod("<init>", arg + "V", (short)1);
            cf2.add((byte)42);
            cf2.add((byte)-73, "pnuts.lang.PnutsFunction", "<init>", "()", "V");
            cf2.addField("args", "[Ljava/lang/Object;", (short)2);
            cf2.add((byte)42);
            cf2.add((byte)43);
            cf2.add((byte)-75, cls2, "args", "[Ljava/lang/Object;");
            for (i = 0; i < n_names; ++i) {
                cf2.addField(names[i], "[Ljava/lang/Object;", (short)0);
                cf2.add((byte)42);
                cf2.loadLocal(2 + i);
                cf2.add((byte)-75, cf2.getClassName(), names[i], "[Ljava/lang/Object;");
            }
            cf2.addField("$context$", "Lpnuts/lang/Context;", (short)0);
            cf2.add((byte)42);
            cf2.loadLocal(2 + n_names);
            cf2.add((byte)3);
            cf2.add((byte)3);
            cf2.add((byte)-74, "pnuts.lang.Context", "clone", "(ZZ)", "Ljava/lang/Object;");
            cf2.add((byte)-64, "pnuts.lang.Context");
            cf2.add((byte)-75, cf2.getClassName(), "$context$", "Lpnuts/lang/Context;");
            cf2.add((byte)-79);
            cf2.closeMethod();
            cf.add((byte)-69, "pnuts.lang.Generator");
            cf.add((byte)89);
            cf.add((byte)-69, cls2);
            cf.add((byte)89);
            cf.loadLocal(1);
            if (exports != null) {
                size = exports.size();
                for (i = 0; i < size; ++i) {
                    ref = (Reference)exports.elementAt(i);
                    if (ref.index < 0) {
                        cf.add((byte)42);
                        cf.add((byte)-76, cf.getClassName(), ref.symbol, "[Ljava/lang/Object;");
                        continue;
                    }
                    if (ref.offset < 0) {
                        cf.add((byte)4);
                        cf.add((byte)-67, "java.lang.Object");
                        cf.add((byte)89);
                        cf.add((byte)3);
                        cf.loadLocal(ref.index);
                        cf.add((byte)83);
                        continue;
                    }
                    cf.loadLocal(ref.index);
                    cf.add((byte)-64, "[Ljava/lang/Object;");
                }
            }
            cf.loadLocal(2);
            cf.add((byte)-73, cls2, "<init>", arg.toString(), "V");
            cf.add((byte)-73, "pnuts.lang.Generator", "<init>", "(Lpnuts/lang/PnutsFunction;)", "V");
        } else {
            if (info.freeVars != null) {
                loc = cf.getLocal();
                it = info.freeVars.iterator();
                while (it.hasNext()) {
                    var = (String)it.next();
                    cc2.declare(var);
                    ref = cc2.getReference(var);
                    cf.loadLocal(cc2.getContextIndex());
                    cf.add((byte)18, cf.addConstant(var));
                    cf.add((byte)-74, "pnuts.lang.Context", "getId", "(Ljava/lang/String;)", "Ljava/lang/Object;");
                    cf.storeLocal(loc);
                    ref.set(cf, loc);
                }
                cf.freeLocal(loc);
            }
            block.accept(this, cc2);
        }
        cc2.returnLabel.fix();
        cf.codeBuffer = code;
        infos = cc.env.bottom.info;
        count = cc.env.bottom.count;
        for (i = 0; i < cc.env.bottom.count; ++i) {
            idx = infos[i].index;
            sym = infos[i].symbol;
            map = infos[i].map;
            if (idx < 0) {
                cf.add((byte)1);
                cf.storeLocal(map);
                continue;
            }
            if (idx != 0) continue;
            cf.add((byte)4);
            cf.add((byte)-67, "java.lang.Object");
            cf.add((byte)89);
            cf.add((byte)3);
            cf.add((byte)1);
            cf.add((byte)83);
            cf.storeLocal(map);
        }
        eref = cc2.getReference(Runtime.EXCEPTOIN_FIELD_SYMBOL);
        cf.add((byte)1);
        cf.storeLocal(eref.index);
        cf.shift(code.size());
        catchStart = cf.getLabel(true);
        blockCode.prepend(code);
        cf.codeBuffer = blockCode;
        finallyIsSet = cc2.env.finallySet;
        jsrTag = cf.getLabel();
        finallyEnd = cf.getLabel();
        if (finallyIsSet) {
            value = cf.getLocal();
            cf.storeLocal(value);
            cf.add((byte)-88, jsrTag);
            cf.loadLocal(value);
            cf.freeLocal(value);
        }
        cf.add((byte)-80);
        catchEnd = cf.getLabel(true);
        catchTarget = cf.getLabel(true);
        finallyTarget = cf.getLabel();
        cf.reserveStack(1);
        caught = cf.getLocal();
        cf.storeLocal(caught);
        cf.loadLocal(cc2.getContextIndex());
        cf.loadLocal(caught);
        cf.freeLocal(caught);
        if (!isGenerator) {
            cf.loadLocal(eref.index);
            cf.add((byte)-64, "pnuts.lang.Runtime$TypeMap");
            cf.add((byte)-72, "pnuts.lang.Runtime", "checkException", "(Lpnuts/lang/Context;Ljava/lang/Throwable;Lpnuts/lang/Runtime$TypeMap;)", "V");
        }
        if (finallyIsSet) {
            finallyEnd.fix();
            cf.add((byte)-88, jsrTag);
        }
        cf.add((byte)1);
        cf.add((byte)-80);
        if (finallyIsSet) {
            throwable = cf.getLocal();
            returnAddr = cf.getLocal();
            finallyTarget.fix();
            cf.reserveStack(1);
            cf.storeLocal(throwable);
            cf.add((byte)-88, jsrTag);
            cf.loadLocal(throwable);
            cf.freeLocal(throwable);
            cf.add((byte)-65);
            jsrTag.fix();
            cf.reserveStack(1);
            cf.storeLocal(returnAddr);
            ref = cc.getReference("!finally");
            cf.loadLocal(ref.index);
            cf.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf.add((byte)-78, this.className, "NO_PARAM", "[Ljava/lang/Object;");
            cf.loadLocal(cc2.getContextIndex());
            cf.add((byte)-74, "pnuts.lang.PnutsFunction", "call", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            cf.add((byte)87);
            cf.add((byte)-87, returnAddr);
            cf.freeLocal(returnAddr);
        }
        cf.addExceptionHandler(catchStart, catchEnd, catchTarget, "java.lang.Throwable");
        if (finallyIsSet) {
            cf.addExceptionHandler(catchStart, finallyEnd, finallyTarget, null);
        }
        arg = new StringBuffer("(Ljava/lang/String;[Ljava/lang/String;ILpnuts/lang/SimpleNode;Lpnuts/lang/Package;Lpnuts/lang/Context;");
        n_names = 0;
        if (cc.env.imports != null) {
            n_names = cc.env.imports.size();
        }
        names = new String[n_names];
        j = 0;
        if (n_names > 0) {
            e = cc.env.imports.elements();
            while (e.hasMoreElements()) {
                sym = (String)e.nextElement();
                names[j++] = sym;
                arg.append("[Ljava/lang/Object;");
            }
        }
        cf.closeMethod();
        cc._closeFrame();
        arg.append(")");
        cf.openMethod("<init>", arg + "V", (short)0);
        cf.add((byte)42);
        cf.add((byte)43);
        cf.add((byte)44);
        cf.add((byte)29);
        cf.add((byte)25, 4);
        cf.add((byte)25, 5);
        cf.add((byte)25, 6);
        cf.add((byte)-73, "pnuts.lang.Function", "<init>", "(Ljava/lang/String;[Ljava/lang/String;ILpnuts/lang/SimpleNode;Lpnuts/lang/Package;Lpnuts/lang/Context;)", "V");
        for (i = 0; i < n_names; ++i) {
            cf.addField(names[i], "[Ljava/lang/Object;", (short)0);
            cf.add((byte)42);
            cf.add((byte)25, 7 + i);
            cf.add((byte)-75, cf.getClassName(), names[i], "[Ljava/lang/Object;");
        }
        cf.add((byte)-79);
        cf.closeMethod();
        cf = cc.cf;
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Context", "getCurrentPackage", "()", "Lpnuts/lang/Package;");
        pkg = cf.getLocal();
        cf.storeLocal(pkg);
        cf.add((byte)-69, cls);
        cf.add((byte)89);
        fnameIndex = 0;
        if (fname != null) {
            fnameIndex = cf.addConstant(fname);
            cf.add((byte)18, fnameIndex);
        } else {
            cf.add((byte)1);
        }
        cf.pushInteger(locals.length);
        cf.add((byte)-67, "java.lang.String");
        for (i = 0; i < locals.length; ++i) {
            cf.add((byte)89);
            cf.pushInteger(i);
            cf.add((byte)18, cf.addConstant(locals[i]));
            cf.add((byte)83);
        }
        cf.pushInteger(nargs);
        cf.add((byte)1);
        cf.loadLocal(pkg);
        cf.loadLocal(ctx);
        exports = isGenerator != false ? (Vector)cc.env.exports.get(cc3.env) : (Vector)cc.env.exports.get(cc2.env);
        if (exports != null) {
            size = exports.size();
            for (i = 0; i < size; ++i) {
                ref = (Reference)exports.elementAt(i);
                if (ref.index < 0) {
                    cf.add((byte)42);
                    cf.add((byte)-76, cf.getClassName(), ref.symbol, "[Ljava/lang/Object;");
                    continue;
                }
                if (ref.offset < 0) {
                    cf.add((byte)4);
                    cf.add((byte)-67, "java.lang.Object");
                    cf.add((byte)89);
                    cf.add((byte)3);
                    cf.loadLocal(ref.index);
                    cf.add((byte)83);
                    continue;
                }
                cf.loadLocal(ref.index);
                cf.add((byte)-64, "[Ljava/lang/Object;");
            }
        }
        cf.add((byte)-73, cls, "<init>", arg.toString(), "V");
        func = cf.getLocal();
        cf.storeLocal(func);
        pfunc = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(pfunc);
        ref = null;
        ref2 = null;
        if (fname == null || node.getAttribute("isMethod") != null) ** GOTO lbl443
        ref = cc.env.findReference(fname);
        ref2 = cc.findReference(fname);
        if (ref != null && ref.frame != cc.env) {
            Compiler.getRef(ref, cc);
            cf.storeLocal(pfunc);
            cf.loadLocal(pfunc);
            cf.add((byte)-63, "pnuts.lang.PnutsFunction");
            instance = cf.getLabel();
            cf.add((byte)-102, instance);
            cf.add((byte)1);
            cf.storeLocal(pfunc);
            instance.fix();
            cf.loadLocal(func);
            cf.loadLocal(pfunc);
            cf.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf.add((byte)3);
            cf.add((byte)-74, cls, "register", "(Lpnuts/lang/PnutsFunction;Z)", "Lpnuts/lang/PnutsFunction;");
            cf.storeLocal(pfunc);
        } else if (ref2 != null) {
            Compiler.getRef(ref2, cc);
            cf.storeLocal(pfunc);
            cf.loadLocal(pfunc);
            cf.add((byte)-63, "pnuts.lang.PnutsFunction");
            instance = cf.getLabel();
            cf.add((byte)-102, instance);
            cf.add((byte)1);
            cf.storeLocal(pfunc);
            instance.fix();
            cf.loadLocal(func);
            cf.loadLocal(pfunc);
            cf.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf.add((byte)4);
            cf.add((byte)-74, cls, "register", "(Lpnuts/lang/PnutsFunction;Z)", "Lpnuts/lang/PnutsFunction;");
            cf.storeLocal(pfunc);
        } else {
            if (cc.env.parent != null) {
                cf.loadLocal(func);
                cf.add((byte)18, fnameIndex);
                cf.loadLocal(pkg);
                cf.add((byte)-72, "pnuts.lang.Runtime", "defineUnboundFunction", "(Lpnuts/lang/Function;Ljava/lang/String;Lpnuts/lang/Package;)", "Lpnuts/lang/PnutsFunction;");
                cf.storeLocal(pfunc);
                cc.declare(fname);
                ref = cc.getReference(fname);
                ref.set(cf, pfunc);
                cf.loadLocal(pfunc);
                return null;
            }
            cf.loadLocal(func);
            cf.add((byte)18, fnameIndex);
            cf.loadLocal(pkg);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "defineTopLevelFunction", "(Lpnuts/lang/Function;Ljava/lang/String;Lpnuts/lang/Package;Lpnuts/lang/Context;)", "Lpnuts/lang/PnutsFunction;");
            return null;
lbl443:
            // 1 sources

            cf.loadLocal(func);
            cf.add((byte)1);
            cf.add((byte)3);
            cf.add((byte)-74, cls, "register", "(Lpnuts/lang/PnutsFunction;Z)", "Lpnuts/lang/PnutsFunction;");
            return null;
        }
        if (cc.env.parent != null) {
            if (ref == null) {
                cc.declare(fname);
                ref = cc.getReference(fname);
            } else {
                cc.redefine(fname);
            }
            ref.set(cf, pfunc);
            cf.loadLocal(pfunc);
        } else {
            cf.loadLocal(pkg);
            cf.add((byte)18, fnameIndex);
            cf.loadLocal(pfunc);
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
            cf.loadLocal(pfunc);
        }
        cf.freeLocal(func);
        cf.freeLocal(pfunc);
        cf.freeLocal(pkg);
        return null;
    }

    public Object applicationNode(SimpleNode node, Context context) {
        Frame frame;
        String sym;
        Reference ref;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        SimpleNode n0 = node.jjtGetChild(0);
        if (n0.id == 5 && (ref = cc.getReference(sym = n0.str)) != null && (frame = ref.frame) != null) {
            SimpleNode n1 = node.jjtGetChild(1);
            int nargs = n1.jjtGetNumChildren();
            if (frame.fname == sym && frame.locals.length == nargs) {
                cf.add((byte)42);
                this._listElements(node.jjtGetChild(1), context);
                cf.loadLocal(ctx);
                cf.add((byte)-74, "pnuts.lang.Function", "exec", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                return null;
            }
        }
        if (node.getAttribute("hasTryStatement") != null) {
            int tgt = cf.getLocal();
            int arg = cf.getLocal();
            this.accept(node, 0, context);
            cf.storeLocal(tgt);
            this._listElements(node.jjtGetChild(1), context);
            cf.storeLocal(arg);
            cf.loadLocal(ctx);
            cf.loadLocal(tgt);
            cf.loadLocal(arg);
            cf.freeLocal(tgt);
            cf.freeLocal(arg);
        } else {
            cf.loadLocal(ctx);
            this.accept(node, 0, context);
            this._listElements(node.jjtGetChild(1), context);
        }
        SimpleNode argNode = node.jjtGetChild(1);
        int nargs = argNode.jjtGetNumChildren();
        boolean types_created = false;
        for (int i = 0; i < nargs; ++i) {
            SimpleNode n = argNode.jjtGetChild(i);
            if (n.id != 69) continue;
            if (!types_created) {
                cf.pushInteger(nargs);
                cf.add((byte)-67, "java.lang.Class");
                types_created = true;
            }
            cf.add((byte)89);
            cf.pushInteger(i);
            this.resolveType(n.jjtGetChild(0), cc, ctx);
            cf.add((byte)83);
        }
        if (!types_created) {
            cf.add((byte)1);
        }
        if (this._includeLineNo) {
            cf.pushInteger(node.beginLine);
            if (this._includeColumnNo) {
                cf.pushInteger(node.beginColumn);
            } else {
                cf.pushInteger(-1);
            }
            cf.add((byte)-72, "pnuts.lang.Runtime", "call", "(Lpnuts/lang/Context;Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Class;II)", "Ljava/lang/Object;");
        } else {
            cf.add((byte)-72, "pnuts.lang.Runtime", "call", "(Lpnuts/lang/Context;Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Class;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object tryStatement(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int throwable = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(throwable);
        int value = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(value);
        Label next = cf.getLabel();
        Label finalTag = cf.getLabel();
        Label jsrTag = cf.getLabel();
        int n = node.jjtGetNumChildren();
        SimpleNode lastNode = node.jjtGetChild(n - 1);
        SimpleNode finallyBlock = null;
        if (lastNode.id == 87) {
            finallyBlock = lastNode;
            cc.pushFinallyBlock(jsrTag);
        }
        boolean hasCatchBlock = false;
        if (n > 1 && node.jjtGetChild((int)1).id == 83) {
            hasCatchBlock = true;
        }
        Label catchStart = cf.getLabel(true);
        this.accept(node, 0, context);
        cf.storeLocal(value);
        Label catchEnd = cf.getLabel(true);
        if (finallyBlock != null) {
            cf.add((byte)-88, jsrTag);
        }
        cf.add((byte)-89, next);
        Label escape = cf.getLabel(true);
        cf.reserveStack(1);
        cf.storeLocal(throwable);
        cf.loadLocal(throwable);
        cf.add((byte)-65);
        Label catchTarget = null;
        if (hasCatchBlock) {
            catchTarget = cf.getLabel(true);
            cf.reserveStack(1);
            cf.storeLocal(throwable);
            cf.loadLocal(throwable);
            cf.add((byte)-63, "pnuts.lang.PnutsException");
            Label l1 = cf.getLabel();
            cf.add((byte)-103, l1);
            cf.loadLocal(throwable);
            cf.add((byte)-64, "pnuts.lang.PnutsException");
            cf.add((byte)-74, "pnuts.lang.PnutsException", "getThrowable", "()", "Ljava/lang/Throwable;");
            cf.storeLocal(throwable);
            l1.fix();
            int cls = cf.getLocal();
            for (int i = 1; i < n; ++i) {
                SimpleNode c = node.jjtGetChild(i);
                if (c.id != 83) continue;
                String var = c.str;
                StringBuffer sbuf = new StringBuffer();
                SimpleNode classNode = c.jjtGetChild(0);
                sbuf.append(classNode.jjtGetChild((int)0).str);
                for (int j = 1; j < classNode.jjtGetNumChildren(); ++j) {
                    sbuf.append('.');
                    sbuf.append(classNode.jjtGetChild((int)j).str);
                }
                cf.loadLocal(cc.getContextIndex());
                cf.add((byte)18, cf.addConstant(sbuf.toString()));
                cf.add((byte)-74, "pnuts.lang.Context", "resolveClass", "(Ljava/lang/String;)", "Ljava/lang/Class;");
                cf.storeLocal(cls);
                cf.loadLocal(cls);
                Label nextCatch = cf.getLabel();
                cf.add((byte)-58, nextCatch);
                cf.loadLocal(cls);
                cf.loadLocal(throwable);
                cf.add((byte)-74, "java.lang.Class", "isInstance", "(Ljava/lang/Object;)", "Z");
                cf.add((byte)-103, nextCatch);
                cc.openScope(new String[0]);
                cc._declare(var, throwable, -1);
                this.accept(c, 1, context);
                cc.closeScope();
                cf.storeLocal(value);
                if (finallyBlock != null) {
                    cf.add((byte)-88, jsrTag);
                }
                cf.add((byte)-89, next);
                nextCatch.fix();
            }
            cf.loadLocal(throwable);
            cf.add((byte)-65);
        }
        if (finallyBlock != null) {
            finalTag = cf.getLabel(true);
            cf.reserveStack(1);
            cf.storeLocal(throwable);
            cf.add((byte)-88, jsrTag);
            cf.loadLocal(throwable);
            cf.add((byte)-65);
            jsrTag.fix();
            int retAddr = cf.getLocal();
            cf.reserveStack(1);
            cf.storeLocal(retAddr);
            cc.popFinallyBlock();
            this.accept(finallyBlock, 0, context);
            cf.add((byte)87);
            cf.add((byte)-87, retAddr);
        }
        cf.addExceptionHandler(catchStart, catchEnd, escape, "pnuts.lang.Escape");
        if (hasCatchBlock) {
            cf.addExceptionHandler(catchStart, catchEnd, catchTarget, "java.lang.Throwable");
        }
        if (finallyBlock != null) {
            cf.addExceptionHandler(catchStart, finalTag, finalTag, null);
        }
        next.fix();
        cf.loadLocal(value);
        return null;
    }

    public Object catchBlock(SimpleNode node, Context context) {
        return null;
    }

    public Object blockNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            int m = n - 1;
            for (int i = 0; i < m; ++i) {
                this.accept(node, i, context);
                cf.add((byte)87);
            }
            this.accept(node, m, context);
        } else {
            cf.add((byte)1);
        }
        return null;
    }

    public Object trueNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        if (Compiler.isConditionalNode(node)) {
            node.setAttribute("inlinedBoolean", Boolean.TRUE);
            cf.add((byte)4);
        } else {
            cf.add((byte)-78, "java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
        }
        return null;
    }

    public Object falseNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        if (Compiler.isConditionalNode(node)) {
            node.setAttribute("inlinedBoolean", Boolean.TRUE);
            cf.add((byte)3);
        } else {
            cc.cf.add((byte)-78, "java.lang.Boolean", "FALSE", "Ljava/lang/Boolean;");
        }
        return null;
    }

    public Object nullNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        cc.cf.add((byte)1);
        return null;
    }

    public Object idNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        String symbol = node.str;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        Reference ref = cc.getReference(symbol);
        if (ref != null) {
            Compiler.getRef(ref, cc);
        } else {
            cf.loadLocal(ctx);
            cf.add((byte)18, cf.addConstant(symbol));
            cf.add((byte)-74, "pnuts.lang.Context", "getId", "(Ljava/lang/String;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object global(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        cf.add((byte)18, cf.addConstant(""));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int gbl = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(gbl);
        Label else_ = cf.getLabel();
        cf.add((byte)-58, else_);
        cf.loadLocal(gbl);
        short symbol = cf.addConstant(node.str);
        cf.add((byte)18, symbol);
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "lookup", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/NamedValue;");
        int val = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(val);
        cf.add((byte)-58, else_);
        cf.loadLocal(val);
        cf.add((byte)-71, "pnuts.lang.Value", "get", "()", "Ljava/lang/Object;");
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        else_.fix();
        this.errorSymbol(cf, "not.defined", symbol, cc);
        next.fix();
        cf.freeLocal(gbl);
        return null;
    }

    public Object listElements(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this._listElements(node, context);
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", "makeArray", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        return null;
    }

    public Object _listElements(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            cf.add((byte)-78, cc.constClassName, "NO_PARAM", "[Ljava/lang/Object;");
        } else {
            boolean hasTryStatement;
            boolean bl = hasTryStatement = node.getAttribute("hasTryStatement") != null;
            if (hasTryStatement) {
                int i;
                int[] vars = new int[n];
                for (i = 0; i < n; ++i) {
                    int var = cf.getLocal();
                    this.accept(node, i, context);
                    cf.storeLocal(var);
                    vars[i] = var;
                }
                cf.pushInteger(n);
                cf.add((byte)-67, "java.lang.Object");
                for (i = 0; i < n; ++i) {
                    cf.add((byte)89);
                    cf.pushInteger(i);
                    cf.loadLocal(vars[i]);
                    cf.add((byte)83);
                }
                for (i = 0; i < n; ++i) {
                    cf.freeLocal(vars[i]);
                }
            } else {
                cf.pushInteger(n);
                cf.add((byte)-67, "java.lang.Object");
                for (int i = 0; i < n; ++i) {
                    cf.add((byte)89);
                    cf.pushInteger(i);
                    this.accept(node, i, context);
                    cf.add((byte)83);
                }
            }
        }
        return null;
    }

    public Object mapNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int n = node.jjtGetNumChildren();
        cf.pushInteger(n);
        cf.loadLocal(cc.getContextIndex());
        cf.add((byte)-72, "pnuts.lang.Runtime", "createMap", "(ILpnuts/lang/Context;)", "Ljava/util/Map;");
        int map = cf.getLocal();
        cf.storeLocal(map);
        for (int i = 0; i < n; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            cf.loadLocal(map);
            this.accept(c, 0, context);
            this.accept(c, 1, context);
            cf.add((byte)-71, "java.util.Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Object;");
            cf.add((byte)87);
        }
        cf.loadLocal(map);
        return null;
    }

    public Object castExpression(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        int tgt = cf.getLocal();
        this.accept(node, 1, context);
        cf.storeLocal(tgt);
        cf.loadLocal(ctx);
        this.resolveType(node.jjtGetChild(0), cc, ctx);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)4);
        cf.add((byte)-72, "pnuts.lang.Runtime", "cast", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/Object;Z)", "Ljava/lang/Object;");
        return null;
    }

    public Object memberNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        Label else_end = cf.getLabel();
        if ("length".equals(node.str)) {
            cf.loadLocal(tgt);
            cf.add((byte)-72, "pnuts.lang.Runtime", "isArray", "(Ljava/lang/Object;)", "Z");
            Label else_ = cf.getLabel();
            cf.add((byte)-103, else_);
            cf.add((byte)-69, "java.lang.Integer");
            cf.add((byte)89);
            cf.loadLocal(tgt);
            cf.add((byte)-72, "java.lang.reflect.Array", "getLength", "(Ljava/lang/Object;)", "I");
            cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
            cf.add((byte)-89, else_end);
            else_.fix();
            cf.stackTop = (short)(cf.stackTop - 1);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.add((byte)18, cf.addConstant(node.str));
        cf.add((byte)-72, "pnuts.lang.Runtime", "getField", "(Lpnuts/lang/Context;Ljava/lang/Object;Ljava/lang/String;)", "Ljava/lang/Object;");
        else_end.fix();
        cf.freeLocal(tgt);
        return null;
    }

    public Object methodNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        SimpleNode argNode = node.jjtGetChild(1);
        int nargs = argNode.jjtGetNumChildren();
        int arg = cf.getLocal();
        this._listElements(argNode, context);
        cf.storeLocal(arg);
        boolean types_created = false;
        for (int i = 0; i < nargs; ++i) {
            SimpleNode n = argNode.jjtGetChild(i);
            if (n.id != 69) continue;
            if (!types_created) {
                cf.pushInteger(nargs);
                cf.add((byte)-67, "java.lang.Class");
                types_created = true;
            }
            cf.add((byte)89);
            cf.pushInteger(i);
            this.resolveType(n.jjtGetChild(0), cc, ctx);
            cf.add((byte)83);
        }
        int types = cf.getLocal();
        if (types_created) {
            cf.storeLocal(types);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.add((byte)-74, "java.lang.Object", "getClass", "()", "Ljava/lang/Class;");
        cf.add((byte)18, cf.addConstant(node.str));
        cf.loadLocal(arg);
        cf.freeLocal(arg);
        if (types_created) {
            cf.loadLocal(types);
        } else {
            cf.add((byte)1);
        }
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)-72, "pnuts.lang.Runtime", "callMethod", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;Ljava/lang/Object;)", "Ljava/lang/Object;");
        return null;
    }

    public Object className(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        int ctx = cc.getContextIndex();
        this.resolveClassName(node, cc, ctx);
        return null;
    }

    public Object arrayType(SimpleNode node, Context context) {
        SimpleNode n;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int count = 0;
        for (n = node; n != null && n.id == 14; n = n.jjtGetChild(0)) {
            ++count;
        }
        if (n != null && n.id == 15) {
            Label clserr = cf.getLabel();
            Label numerr = cf.getLabel();
            Object[] idx = Compiler.parseIndex(n);
            SimpleNode idx0 = (SimpleNode)idx[0];
            idx0.accept(this, context);
            cf.add((byte)89);
            cf.add((byte)-63, "java.lang.Class");
            cf.add((byte)-103, clserr);
            cf.add((byte)-64, "java.lang.Class");
            cf.pushInteger(count);
            cf.add((byte)-72, "pnuts.lang.Runtime", "arrayType", "(Ljava/lang/Class;I)", "Ljava/lang/Class;");
            Object[] dim = (Object[])idx[1];
            cf.pushInteger(dim.length);
            cf.add((byte)-68, 10);
            int dlen = dim.length;
            for (int i = 0; i < dlen; ++i) {
                cf.add((byte)89);
                cf.pushInteger(i);
                ((SimpleNode)dim[i]).accept(this, context);
                cf.add((byte)-64, "java.lang.Number");
                cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
                cf.add((byte)79);
            }
            cf.add((byte)-72, "java.lang.reflect.Array", "newInstance", "(Ljava/lang/Class;[I)", "Ljava/lang/Object;");
            Label next = cf.getLabel();
            cf.add((byte)-89, next);
            numerr.fix();
            this.error(cf, "number.expected", cc);
            cf.add((byte)-89, next);
            clserr.fix();
            this.error(cf, "classOrArray.expected", cc);
            next.fix();
            return null;
        }
        if (node.jjtGetParent().id != 10) {
            n.accept(this, context);
            int type = cf.getLocal();
            cf.add((byte)89);
            cf.storeLocal(type);
            cf.add((byte)-63, "java.lang.Class");
            Label err = cf.getLabel();
            cf.add((byte)-103, err);
            cf.loadLocal(type);
            cf.freeLocal(type);
            cf.add((byte)-64, "java.lang.Class");
            cf.pushInteger(count);
            cf.add((byte)-72, "pnuts.lang.Runtime", "arrayType", "(Ljava/lang/Class;I)", "Ljava/lang/Class;");
            Label next = cf.getLabel();
            cf.add((byte)-89, next);
            err.fix();
            this.error(cf, "classOrArray.expected", new int[]{type}, cc);
            next.fix();
        } else {
            cf.add((byte)-69, "java.lang.IllegalArgumentException");
            cf.add((byte)89);
            cf.add((byte)-73, "java.lang.IllegalArgumentException", "<init>", "()", "V");
            cf.add((byte)-65);
        }
        return null;
    }

    static Object[] parseIndex(SimpleNode node) {
        SimpleNode c0 = node.jjtGetChild(0);
        SimpleNode c1 = node.jjtGetChild(1);
        if (c0.id != 15) {
            return new Object[]{c0, new Object[]{c1}};
        }
        Object[] r = Compiler.parseIndex(c0);
        Object[] d = (Object[])r[1];
        Object[] a = new Object[d.length + 1];
        System.arraycopy(d, 0, a, 0, d.length);
        a[d.length] = c1;
        return new Object[]{r[0], a};
    }

    static void convertIndexNode(SimpleNode node) {
        SimpleNode n0 = node.jjtGetChild(0);
        SimpleNode n1 = node.jjtGetChild(1);
        if (ConstraintsTransformer.isPredicate(n1)) {
            SimpleNode n = ConstraintsTransformer.buildFunc(n1);
            node.jjtAddChild(n, 1);
            n.jjtSetParent(node);
        }
        if (n0.id == 15) {
            Compiler.convertIndexNode(n0);
        }
    }

    public Object indexNode(SimpleNode node, Context context) {
        FrameInfo info = (FrameInfo)node.getAttribute("frameInfo");
        if (info == null) {
            info = new FrameInfo();
            node.setAttribute("frameInfo", info);
        }
        if (!info.preprocessed) {
            info.preprocessed = true;
            Compiler.convertIndexNode(node);
        }
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        Object[] idx = Compiler.parseIndex(node);
        SimpleNode c = (SimpleNode)idx[0];
        c.accept(this, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        Object[] dim = (Object[])idx[1];
        Label else_end = cf.getLabel();
        int ctx = cc.getContextIndex();
        if (c.id == 9 || c.id == 5) {
            cf.loadLocal(tgt);
            cf.add((byte)-63, "java.lang.Class");
            Label else_ = cf.getLabel();
            cf.add((byte)-103, else_);
            if (node.getAttribute("hasTryStatement") != null) {
                int i;
                int[] vars = new int[dim.length];
                for (i = 0; i < dim.length; ++i) {
                    int var = cf.getLocal();
                    ((SimpleNode)dim[i]).accept(this, context);
                    cf.storeLocal(var);
                    vars[i] = var;
                }
                cf.loadLocal(tgt);
                cf.add((byte)-64, "java.lang.Class");
                cf.pushInteger(dim.length);
                cf.add((byte)-68, 10);
                for (i = 0; i < dim.length; ++i) {
                    cf.add((byte)89);
                    cf.pushInteger(i);
                    cf.loadLocal(vars[i]);
                    cf.add((byte)-64, "java.lang.Number");
                    cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
                    cf.add((byte)79);
                }
                for (i = 0; i < dim.length; ++i) {
                    cf.freeLocal(vars[i]);
                }
            } else {
                cf.loadLocal(tgt);
                cf.add((byte)-64, "java.lang.Class");
                cf.pushInteger(dim.length);
                cf.add((byte)-68, 10);
                for (int i = 0; i < dim.length; ++i) {
                    cf.add((byte)89);
                    cf.pushInteger(i);
                    ((SimpleNode)dim[i]).accept(this, context);
                    cf.add((byte)-64, "java.lang.Number");
                    cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
                    cf.add((byte)79);
                }
            }
            cf.add((byte)-72, "java.lang.reflect.Array", "newInstance", "(Ljava/lang/Class;[I)", "Ljava/lang/Object;");
            cf.add((byte)-89, else_end);
            else_.fix();
            cf.stackTop = (short)(cf.stackTop - 1);
        }
        for (int i = 0; i < dim.length; ++i) {
            ((SimpleNode)dim[i]).accept(this, context);
            int _idx = cf.getLocal();
            cf.storeLocal(_idx);
            cf.loadLocal(tgt);
            cf.loadLocal(_idx);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "getElement", "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            cf.storeLocal(tgt);
        }
        cf.loadLocal(tgt);
        else_end.fix();
        cf.freeLocal(tgt);
        return null;
    }

    public Object instanceofExpression(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        Label next = cf.getLabel();
        Label l_false = cf.getLabel();
        this.resolveType(node.jjtGetChild(1), cc, ctx);
        this.accept(node, 0, context);
        cf.add((byte)-74, "java.lang.Class", "isInstance", "(Ljava/lang/Object;)", "Z");
        cf.add((byte)-103, l_false);
        cf.add((byte)-78, "java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
        cf.add((byte)-89, next);
        l_false.fix();
        cf.add((byte)-78, "java.lang.Boolean", "FALSE", "Ljava/lang/Boolean;");
        next.fix();
        return null;
    }

    public Object assignment(SimpleNode node, Context context) {
        return this.assign(node, context, 31);
    }

    public Object assignmentTA(SimpleNode node, Context context) {
        return this.assign(node, context, 32);
    }

    public Object assignmentMA(SimpleNode node, Context context) {
        return this.assign(node, context, 33);
    }

    public Object assignmentDA(SimpleNode node, Context context) {
        return this.assign(node, context, 34);
    }

    public Object assignmentPA(SimpleNode node, Context context) {
        return this.assign(node, context, 35);
    }

    public Object assignmentSA(SimpleNode node, Context context) {
        return this.assign(node, context, 36);
    }

    public Object assignmentLA(SimpleNode node, Context context) {
        return this.assign(node, context, 37);
    }

    public Object assignmentRA(SimpleNode node, Context context) {
        return this.assign(node, context, 38);
    }

    public Object assignmentRAA(SimpleNode node, Context context) {
        return this.assign(node, context, 39);
    }

    public Object assignmentAA(SimpleNode node, Context context) {
        return this.assign(node, context, 40);
    }

    public Object assignmentEA(SimpleNode node, Context context) {
        return this.assign(node, context, 41);
    }

    public Object assignmentOA(SimpleNode node, Context context) {
        return this.assign(node, context, 42);
    }

    public Object preIncrNode(SimpleNode node, Context context) {
        SimpleNode node0 = node.jjtGetChild(0);
        node0.accept(this, context);
        this._assign(node0, context, 32803, false, true);
        return null;
    }

    public Object preDecrNode(SimpleNode node, Context context) {
        SimpleNode node0 = node.jjtGetChild(0);
        node0.accept(this, context);
        this._assign(node0, context, 32804, false, true);
        return null;
    }

    public Object postIncrNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        int ret = cf.getLocal();
        cf.storeLocal(ret);
        cf.loadLocal(ret);
        this._assign(node.jjtGetChild(0), cc, 32803, false, false);
        cf.loadLocal(ret);
        cf.freeLocal(ret);
        return null;
    }

    public Object postDecrNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        int ret = cf.getLocal();
        cf.storeLocal(ret);
        cf.loadLocal(ret);
        this._assign(node.jjtGetChild(0), context, 32804, false, false);
        cf.loadLocal(ret);
        cf.freeLocal(ret);
        return null;
    }

    public Object staticMethodNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        SimpleNode argNode = node.jjtGetChild(1);
        int nargs = argNode.jjtGetNumChildren();
        this._listElements(argNode, context);
        int args = cf.getLocal();
        cf.storeLocal(args);
        SimpleNode c1 = node.jjtGetChild(0);
        String pkgName = Compiler.getPackageName(c1);
        cf.add((byte)18, cf.addConstant(pkgName));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int pkg = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(pkg);
        Label l_null = cf.getLabel();
        cf.add((byte)-58, l_null);
        cf.loadLocal(pkg);
        cf.add((byte)18, cf.addConstant(node.str));
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "get", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        int got = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(got);
        cf.add((byte)-63, "pnuts.lang.PnutsFunction");
        Label l_else = cf.getLabel();
        cf.add((byte)-103, l_else);
        cf.loadLocal(ctx);
        cf.loadLocal(got);
        cf.add((byte)-64, "pnuts.lang.PnutsFunction");
        cf.loadLocal(args);
        cf.add((byte)-72, "pnuts.lang.Runtime", "callFunction", "(Lpnuts/lang/Context;Lpnuts/lang/PnutsFunction;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        l_else.fix();
        cf.stackTop = (short)(cf.stackTop - 1);
        cf.loadLocal(got);
        cf.add((byte)-63, "java.lang.Class");
        cf.add((byte)-103, l_null);
        boolean types_created = false;
        for (int i = 0; i < nargs; ++i) {
            SimpleNode n = argNode.jjtGetChild(i);
            if (n.id != 69) continue;
            if (!types_created) {
                cf.pushInteger(nargs);
                cf.add((byte)-67, "java.lang.Class");
                types_created = true;
            }
            cf.add((byte)89);
            cf.pushInteger(i);
            this.resolveType(n.jjtGetChild(0), cc, ctx);
            cf.add((byte)83);
        }
        int types = cf.getLocal();
        if (types_created) {
            cf.storeLocal(types);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(got);
        cf.add((byte)-64, "java.lang.Class");
        cf.loadLocal(args);
        if (types_created) {
            cf.loadLocal(types);
        } else {
            cf.add((byte)1);
        }
        cf.add((byte)-72, "pnuts.lang.Runtime", "newInstance", "(Lpnuts/lang/Context;Ljava/lang/Class;[Ljava/lang/Object;[Ljava/lang/Class;)", "Ljava/lang/Object;");
        cf.add((byte)-89, next);
        l_null.fix();
        cf.stackTop = (short)(cf.stackTop - 1);
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt);
        cf.add((byte)-63, "java.lang.Class");
        Label ok = cf.getLabel();
        cf.add((byte)-102, ok);
        cf.add((byte)-69, "pnuts.lang.PnutsException");
        cf.add((byte)89);
        cf.add((byte)18, cf.addConstant("illegal.staticCall"));
        cf.add((byte)6);
        cf.add((byte)-67, "java.lang.Object");
        cf.add((byte)89);
        cf.add((byte)3);
        cf.add((byte)18, cf.addConstant(pkgName));
        cf.add((byte)83);
        cf.add((byte)89);
        cf.add((byte)4);
        cf.add((byte)18, cf.addConstant(node.str));
        cf.add((byte)83);
        cf.add((byte)89);
        cf.add((byte)5);
        cf.add((byte)-69, "java.lang.Integer");
        cf.add((byte)89);
        cf.pushInteger(nargs);
        cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
        cf.add((byte)83);
        cf.loadLocal(ctx);
        cf.add((byte)-73, "pnuts.lang.PnutsException", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        cf.add((byte)-65);
        ok.fix();
        types_created = false;
        for (int i = 0; i < nargs; ++i) {
            SimpleNode n = argNode.jjtGetChild(i);
            if (n.id != 69) continue;
            if (!types_created) {
                cf.pushInteger(nargs);
                cf.add((byte)-67, "java.lang.Class");
                types_created = true;
            }
            cf.add((byte)89);
            cf.pushInteger(i);
            this.resolveType(n.jjtGetChild(0), cc, ctx);
            cf.add((byte)83);
        }
        types = cf.getLocal();
        if (types_created) {
            cf.storeLocal(types);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.add((byte)-64, "java.lang.Class");
        cf.add((byte)18, cf.addConstant(node.str));
        cf.loadLocal(args);
        if (types_created) {
            cf.loadLocal(types);
        } else {
            cf.add((byte)1);
        }
        cf.freeLocal(types);
        cf.add((byte)1);
        cf.add((byte)-72, "pnuts.lang.Runtime", "callMethod", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;Ljava/lang/Object;)", "Ljava/lang/Object;");
        next.fix();
        return null;
    }

    public Object staticMemberNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        SimpleNode c1 = node.jjtGetChild(0);
        Label next = cf.getLabel();
        String pkgName = Compiler.getPackageName(c1);
        cf.add((byte)18, cf.addConstant(pkgName));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int pkg = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(pkg);
        Label l_null = cf.getLabel();
        cf.add((byte)-58, l_null);
        cf.loadLocal(pkg);
        cf.freeLocal(pkg);
        cf.add((byte)18, cf.addConstant(node.str));
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "lookup", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/NamedValue;");
        int val = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(val);
        Label undef = cf.getLabel();
        cf.add((byte)-58, undef);
        cf.loadLocal(val);
        cf.freeLocal(val);
        cf.add((byte)-71, "pnuts.lang.Value", "get", "()", "Ljava/lang/Object;");
        cf.add((byte)-89, next);
        undef.fix();
        this.errorSymbol(cf, "not.defined", cf.addConstant(node.str), cc);
        l_null.fix();
        c1.accept(this, context);
        int tgt = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt);
        cf.add((byte)-63, "java.lang.Class");
        Label err = cf.getLabel();
        cf.add((byte)-103, err);
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)-64, "java.lang.Class");
        cf.add((byte)18, cf.addConstant(node.str));
        cf.add((byte)-72, "pnuts.lang.Runtime", "getStaticField", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;)", "Ljava/lang/Object;");
        cf.add((byte)-89, next);
        err.fix();
        this.error(cf, "packageOrClass.expected", new int[]{tgt}, cc);
        next.fix();
        return null;
    }

    public Object rangeNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        this.accept(node, 1, context);
        int idx1 = cf.getLocal();
        cf.storeLocal(idx1);
        int idx2 = cf.getLocal();
        if (node.jjtGetNumChildren() >= 3) {
            this.accept(node, 2, context);
        } else {
            cf.add((byte)1);
        }
        cf.storeLocal(idx2);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.loadLocal(idx1);
        cf.freeLocal(idx1);
        cf.loadLocal(idx2);
        cf.freeLocal(idx2);
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", "getRange", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        return null;
    }

    public Object forStatement(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        SimpleNode initNode = null;
        SimpleNode condNode = null;
        SimpleNode updateNode = null;
        SimpleNode blockNode = null;
        int j = 0;
        SimpleNode n = node.jjtGetChild(j);
        if (n.id == 90) {
            int nc = n.jjtGetNumChildren();
            blockNode = node.jjtGetChild(1);
            if (nc == 1) {
                this.doForeach(n.str, n.jjtGetChild(0), blockNode, cc, cf);
            } else if (nc == 2) {
                this.doForeachRange(n.str, n.jjtGetChild(0), n.jjtGetChild(1), blockNode, cc, cf);
            }
            return null;
        }
        if (n.id == 91) {
            initNode = n;
            ++j;
        }
        n = node.jjtGetChild(j);
        if (n.id != 92 && n.id != 77) {
            condNode = n;
            ++j;
        }
        n = node.jjtGetChild(j);
        if (n.id == 92) {
            updateNode = n;
            ++j;
        }
        blockNode = node.jjtGetChild(j);
        int last = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(last);
        if (initNode != null) {
            int i;
            int num = initNode.jjtGetNumChildren();
            String[] env = new String[num];
            for (i = 0; i < env.length; ++i) {
                SimpleNode sn = initNode.jjtGetChild(i);
                env[i] = sn.str;
            }
            cc.openScope(env);
            for (i = 0; i < env.length; ++i) {
                Reference ref = cc.getReference(env[i]);
                SimpleNode sn = initNode.jjtGetChild(i);
                this.accept(sn, 0, context);
                if (ref.offset < 0) {
                    cf.storeLocal(ref.index);
                    continue;
                }
                int tgt = cf.getLocal();
                cf.storeLocal(tgt);
                cf.add((byte)1);
                cf.storeLocal(ref.index);
                ref.set(cf, tgt);
            }
        } else {
            cc.openScope(new String[0]);
        }
        Label start = cf.getLabel(true);
        Label cont = cf.getLabel();
        Label next = cf.getLabel();
        Label brk = cf.getLabel();
        ControlEnv ctrl = cc.openControlEnv(node.id);
        ctrl.continueLabel = cont;
        ctrl.breakLabel = brk;
        if (condNode != null) {
            condNode.accept(this, context);
            if (condNode.getAttribute("inlinedBoolean") != null) {
                cf.add((byte)-103, next);
            } else {
                this.booleanCheck(condNode.id, cf, context);
                cf.add((byte)-64, "java.lang.Boolean");
                cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
                cf.add((byte)-103, next);
            }
        }
        blockNode.accept(this, context);
        cont.fix();
        cf.storeLocal(last);
        if (updateNode != null) {
            int num = updateNode.jjtGetNumChildren();
            for (int i = 0; i < num; ++i) {
                this.accept(updateNode, i, context);
                cf.add((byte)87);
            }
        }
        cf.add((byte)-89, start);
        next.fix();
        cf.loadLocal(last);
        cf.freeLocal(last);
        cc.closeScope();
        brk.fix();
        cc.closeControlEnv();
        return null;
    }

    public Object breakNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        cc.leaveControlEnv();
        if (node.jjtGetNumChildren() > 0) {
            this.accept(node, 0, context);
        } else {
            cf.add((byte)1);
        }
        Label brk = cc.getBreakLabel();
        if (brk != null) {
            cf.add((byte)-89, brk);
        } else if (cc.inGeneratorBlock) {
            int value = cf.getLocal();
            cf.storeLocal(value);
            cf.add((byte)-69, "pnuts.lang.Generator$Break");
            cf.add((byte)89);
            cf.loadLocal(value);
            cf.freeLocal(value);
            cf.add((byte)-73, "pnuts.lang.Generator$Break", "<init>", "(Ljava/lang/Object;)", "V");
            cf.add((byte)-65);
        }
        return null;
    }

    public Object continueNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        cc.leaveControlEnv();
        Label cnt = cc.getContinueLabel();
        cf.add((byte)1);
        if (cnt != null) {
            cf.add((byte)-89, cnt);
        } else if (cc.inGeneratorBlock) {
            cf.add((byte)-80);
        }
        return null;
    }

    public Object returnNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        cc.leaveFrame();
        if (node.jjtGetNumChildren() > 0) {
            this.accept(node, 0, context);
        } else {
            cf.add((byte)1);
        }
        if (cc.env.parent != null) {
            if (cc.inGeneratorBlock) {
                int value = cf.getLocal();
                cf.storeLocal(value);
                cf.add((byte)-69, "pnuts.lang.Jump");
                cf.add((byte)89);
                cf.loadLocal(value);
                cf.add((byte)-73, "pnuts.lang.Jump", "<init>", "(Ljava/lang/Object;)", "V");
                cf.add((byte)-65);
            } else {
                cf.add((byte)-89, cc.returnLabel);
            }
        } else {
            cf.add((byte)-72, "pnuts.lang.Runtime", "jump", "(Ljava/lang/Object;)", "V");
            cf.add((byte)1);
        }
        return null;
    }

    public Object yieldNode(SimpleNode node, Context context) {
        throw new PnutsException("yield must be used in a generator function", context);
    }

    public Object catchNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (node.jjtGetNumChildren() == 0) {
            cf.add((byte)-78, "pnuts.lang.PnutsFunction", "CATCH", "Lpnuts/lang/PnutsFunction;");
            return null;
        }
        int cls = cf.getLocal();
        int func = cf.getLocal();
        this.accept(node, 0, context);
        cf.add((byte)-64, "java.lang.Class");
        cf.storeLocal(cls);
        this.accept(node, 1, context);
        cf.add((byte)-64, "pnuts.lang.PnutsFunction");
        cf.storeLocal(func);
        Reference eref = cc.getReference(Runtime.EXCEPTOIN_FIELD_SYMBOL);
        if (cc.env.parent != null && eref != null) {
            int tmap = cf.getLocal();
            cf.add((byte)-69, "pnuts.lang.Runtime$TypeMap");
            cf.add((byte)89);
            cf.loadLocal(cls);
            cf.loadLocal(func);
            Compiler.getRef(eref, cc);
            cf.add((byte)-64, "pnuts.lang.Runtime$TypeMap");
            cf.add((byte)-73, "pnuts.lang.Runtime$TypeMap", "<init>", "(Ljava/lang/Class;Ljava/lang/Object;Lpnuts/lang/Runtime$TypeMap;)", "V");
            cf.storeLocal(tmap);
            eref.set(cf, tmap);
            cf.add((byte)1);
        } else {
            cf.loadLocal(cls);
            cf.loadLocal(func);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "catchException", "(Ljava/lang/Class;Lpnuts/lang/PnutsFunction;Lpnuts/lang/Context;)", "V");
            cf.add((byte)1);
        }
        cf.freeLocal(cls);
        cf.freeLocal(func);
        return null;
    }

    public Object throwNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            cf.add((byte)-78, "pnuts.lang.PnutsFunction", "THROW", "Lpnuts/lang/PnutsFunction;");
        } else {
            this.accept(node, 0, context);
            int arg = cf.getLocal();
            cf.storeLocal(arg);
            cf.loadLocal(arg);
            cf.add((byte)-63, "java.lang.Throwable");
            Label throwable = cf.getLabel();
            cf.add((byte)-102, throwable);
            Label next = cf.getLabel();
            cf.add((byte)-69, "pnuts.lang.PnutsException");
            cf.add((byte)89);
            cf.loadLocal(arg);
            cf.add((byte)-72, "java.lang.String", "valueOf", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            cf.loadLocal(cc.getContextIndex());
            cf.add((byte)-73, "pnuts.lang.PnutsException", "<init>", "(Ljava/lang/String;Lpnuts/lang/Context;)", "V");
            cf.add((byte)-89, next);
            throwable.fix();
            cf.loadLocal(arg);
            cf.add((byte)-64, "java.lang.Throwable");
            cf.freeLocal(arg);
            next.fix();
            cf.add((byte)-65);
        }
        return null;
    }

    public Object finallyNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            cf.add((byte)1);
        } else if (n == 1) {
            Frame env = cc.env;
            if (env.parent != null) {
                env.finallySet = true;
                int fin = cf.getLocal();
                cc.declare("!finally", fin, -1);
                this.accept(node, 0, context);
                cf.storeLocal(fin);
                cf.loadLocal(fin);
            } else {
                cf.loadLocal(ctx);
                int val = cf.getLocal();
                this.accept(node, 0, context);
                cf.storeLocal(val);
                cf.loadLocal(val);
                cf.add((byte)-64, "pnuts.lang.PnutsFunction");
                cf.add((byte)-72, "pnuts.lang.Runtime", "setExitHook", "(Lpnuts/lang/Context;Lpnuts/lang/PnutsFunction;)", "V");
                cf.loadLocal(val);
            }
        } else if (n == 2) {
            int value = cf.getLocal();
            int retAddr = cf.getLocal();
            Label catchStart = cf.getLabel(true);
            Label jsrTag = cf.getLabel();
            this.accept(node, 0, context);
            cf.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf.add((byte)-78, cc.constClassName, "NO_PARAM", "[Ljava/lang/Object;");
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.PnutsFunction", "call", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            cf.storeLocal(value);
            Label catchEnd = cf.getLabel(true);
            cf.add((byte)-88, jsrTag);
            cf.loadLocal(value);
            cf.add((byte)-80);
            Label finallyTag = cf.getLabel(true);
            cf.reserveStack(1);
            cf.add((byte)-65);
            jsrTag.fix();
            cf.reserveStack(1);
            cf.storeLocal(retAddr);
            this.accept(node, 1, context);
            cf.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf.add((byte)-78, cc.constClassName, "NO_PARAM", "[Ljava/lang/Object;");
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.PnutsFunction", "call", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            cf.add((byte)87);
            cf.add((byte)-87, retAddr);
            cf.addExceptionHandler(catchStart, catchEnd, finallyTag, null);
        }
        return null;
    }

    private Object conditionLoop(SimpleNode node, Context context, boolean isDoWhile) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        cf.add((byte)1);
        int last = cf.getLocal();
        cf.storeLocal(last);
        Label start = cf.getLabel(true);
        Label next = cf.getLabel();
        Label brk = cf.getLabel();
        Label cont = cf.getLabel();
        ControlEnv env = isDoWhile ? cc.openControlEnv(88) : cc.openControlEnv(81);
        env.breakLabel = brk;
        env.continueLabel = cont;
        if (isDoWhile) {
            if (this.traceMode) {
                this.addLineInfo(cc, ctx, node);
            }
            this.accept(node, 0, context);
            cont.fix();
            cf.storeLocal(last);
        }
        SimpleNode condNode = node.jjtGetChild(isDoWhile ? 1 : 0);
        condNode.accept(this, context);
        if (condNode.getAttribute("inlinedBoolean") != null) {
            cf.add((byte)-103, next);
        } else {
            this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
            cf.add((byte)-64, "java.lang.Boolean");
            cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
            cf.add((byte)-103, next);
        }
        if (!isDoWhile) {
            if (this.traceMode) {
                this.addLineInfo(cc, ctx, node);
            }
            this.accept(node, 1, context);
            cont.fix();
            cf.storeLocal(last);
        }
        cf.add((byte)-89, start);
        next.fix();
        cc.closeControlEnv();
        cf.loadLocal(last);
        cf.freeLocal(last);
        brk.fix();
        return null;
    }

    public Object doStatement(SimpleNode node, Context context) {
        return this.conditionLoop(node, context, true);
    }

    public Object whileStatement(SimpleNode node, Context context) {
        return this.conditionLoop(node, context, false);
    }

    private void doGenerator(String var, int tgt, SimpleNode blockNode, CompileContext cc, ClassFile cf) {
        String cls = this.className + "$" + (this.classCount++ & Long.MAX_VALUE);
        ClassFile cf2 = new ClassFile(cls, "pnuts.lang.PnutsFunction", this.sourceFile, 1);
        cf2.addInterface("pnuts.compiler.Compiled");
        cc.classFiles.addElement(cf2);
        CompileContext cc2 = (CompileContext)cc.clone();
        cc2.returnLabel = cf2.getLabel();
        cc2.cf = cf2;
        cc2._openFrame(null, new String[]{var}, false);
        cf2.openMethod("exec", "([Ljava/lang/Object;Lpnuts/lang/Context;)Ljava/lang/Object;", (short)4);
        cc2.setContextIndex(2);
        cc2.inGeneratorBlock = true;
        cf2.loadLocal(0);
        cf2.add((byte)-76, cls, "$context$", "Lpnuts/lang/Context;");
        cf2.storeLocal(2);
        cc2._declare(var, 1, 0);
        blockNode.accept(this, cc2);
        cc2.returnLabel.fix();
        cf2.add((byte)-80);
        cc2.inGeneratorBlock = false;
        cf2.closeMethod();
        StringBuffer arg = new StringBuffer("(");
        int n_names = 0;
        if (cc2.env.imports != null) {
            n_names = cc2.env.imports.size();
        }
        String[] names = new String[n_names];
        int j = 0;
        if (n_names > 0) {
            Enumeration e = cc2.env.imports.elements();
            while (e.hasMoreElements()) {
                String sym = (String)e.nextElement();
                names[j++] = sym;
                arg.append("[Ljava/lang/Object;");
            }
        }
        arg.append("Lpnuts/lang/Context;");
        arg.append(")");
        cf2.openMethod("<init>", arg + "V", (short)1);
        cf2.add((byte)42);
        cf2.add((byte)-73, "pnuts.lang.PnutsFunction", "<init>", "()", "V");
        for (int i = 0; i < n_names; ++i) {
            cf2.addField(names[i], "[Ljava/lang/Object;", (short)0);
            cf2.add((byte)42);
            cf2.add((byte)25, 1 + i);
            cf2.add((byte)-75, cf2.getClassName(), names[i], "[Ljava/lang/Object;");
        }
        cf2.addField("$context$", "Lpnuts/lang/Context;", (short)0);
        cf2.add((byte)42);
        cf2.add((byte)25, 1 + n_names);
        cf2.add((byte)-75, cf2.getClassName(), "$context$", "Lpnuts/lang/Context;");
        cf2.add((byte)-79);
        cf2.closeMethod();
        cf.loadLocal(tgt);
        cf.add((byte)-64, "pnuts.lang.Generator");
        cf.add((byte)-69, cls);
        cf.add((byte)89);
        Vector exports = (Vector)cc.env.exports.get(cc2.env);
        cc2._closeFrame();
        if (exports != null) {
            int size = exports.size();
            for (int i = 0; i < size; ++i) {
                Reference ref = (Reference)exports.elementAt(i);
                if (ref.index < 0) {
                    cf.add((byte)42);
                    cf.add((byte)-76, cf.getClassName(), ref.symbol, "[Ljava/lang/Object;");
                    continue;
                }
                if (ref.offset < 0) {
                    cf.add((byte)4);
                    cf.add((byte)-67, "java.lang.Object");
                    cf.add((byte)89);
                    cf.add((byte)3);
                    cf.loadLocal(ref.index);
                    cf.add((byte)83);
                    continue;
                }
                cf.loadLocal(ref.index);
                Label l1 = cf.getLabel();
                cf.add((byte)-57, l1);
                cf.add((byte)4);
                cf.add((byte)-67, "java.lang.Object");
                cf.storeLocal(ref.index);
                l1.fix();
                cf.loadLocal(ref.index);
                cf.add((byte)-64, "[Ljava/lang/Object;");
            }
        }
        cf.loadLocal(cc.getContextIndex());
        cf.add((byte)-73, cls, "<init>", arg.toString(), "V");
        cf.loadLocal(cc.getContextIndex());
        cf.add((byte)-72, "pnuts.lang.Runtime", "applyGenerator", "(Lpnuts/lang/Generator;Lpnuts/lang/PnutsFunction;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
    }

    private void doForeach(String var, SimpleNode collectionNode, SimpleNode blockNode, CompileContext cc, ClassFile cf) {
        Label cont;
        cc.openScope(new String[]{var});
        Reference count = cc.getReference(var);
        cf.add((byte)4);
        cf.add((byte)-67, "java.lang.Object");
        cf.storeLocal(count.index);
        Label next = cf.getLabel();
        Label brk = cf.getLabel();
        ControlEnv env = cc.openControlEnv(89);
        env.breakLabel = brk;
        int last = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(last);
        collectionNode.accept(this, cc);
        int tgt = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt);
        Label nonnull = cf.getLabel();
        cf.add((byte)-57, nonnull);
        cf.add((byte)-89, next);
        nonnull.fix();
        cf.loadLocal(tgt);
        cf.add((byte)-63, "pnuts.lang.Generator");
        Label fn = cf.getLabel();
        cf.add((byte)-102, fn);
        cf.loadLocal(tgt);
        cf.loadLocal(cc.getContextIndex());
        cf.add((byte)-72, "pnuts.lang.Runtime", "toEnumeration", "(Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/util/Enumeration;");
        int tmp1 = cf.getLocal();
        cf.storeLocal(tmp1);
        cf.loadLocal(tmp1);
        Label err = cf.getLabel();
        cf.add((byte)-58, err);
        Label loop2 = cf.getLabel();
        cf.add((byte)-89, loop2);
        Label body = cf.getLabel(true);
        cf.loadLocal(tmp1);
        cf.add((byte)-64, "java.util.Enumeration");
        cf.add((byte)-71, "java.util.Enumeration", "nextElement", "()", "Ljava/lang/Object;");
        int tmp2 = cf.getLocal();
        cf.storeLocal(tmp2);
        count.set(cf, tmp2);
        env.continueLabel = cont = cf.getLabel();
        blockNode.accept(this, cc);
        cont.fix();
        cf.storeLocal(last);
        loop2.fix();
        cf.loadLocal(tmp1);
        cf.add((byte)-64, "java.util.Enumeration");
        cf.add((byte)-71, "java.util.Enumeration", "hasMoreElements", "()", "Z");
        cf.add((byte)-103, next);
        cf.add((byte)-89, body);
        fn.fix();
        this.doGenerator(var, tgt, blockNode, cc, cf);
        cf.storeLocal(last);
        cf.add((byte)-89, next);
        err.fix();
        this.error(cf, "illegal.type.foreach", new int[]{tgt}, cc);
        next.fix();
        cf.loadLocal(last);
        cf.freeLocal(last);
        cf.freeLocal(tmp1);
        cf.freeLocal(tmp2);
        cf.freeLocal(tgt);
        cc.closeControlEnv();
        cc.closeScope();
        brk.fix();
    }

    private void doForeachRange(String var, SimpleNode startNode, SimpleNode endNode, SimpleNode blockNode, CompileContext cc, ClassFile cf) {
        Label cont2;
        Label cont;
        cc.openScope(new String[]{var});
        Reference count = cc.getReference(var);
        cf.add((byte)4);
        cf.add((byte)-67, "java.lang.Object");
        cf.storeLocal(count.index);
        Label next = cf.getLabel();
        Label brk = cf.getLabel();
        ControlEnv env = cc.openControlEnv(89);
        env.breakLabel = brk;
        int last = cf.getLocal();
        int tmp = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(last);
        int start = cf.getLocal();
        startNode.accept(this, cc);
        cf.add((byte)-64, "java.lang.Number");
        cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
        cf.istoreLocal(start);
        int end = cf.getLocal();
        endNode.accept(this, cc);
        cf.add((byte)-64, "java.lang.Number");
        cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
        cf.istoreLocal(end);
        cf.iloadLocal(start);
        cf.iloadLocal(end);
        Label loop2 = cf.getLabel();
        cf.add((byte)-93, loop2);
        Label loop1 = cf.getLabel(true);
        cf.iloadLocal(start);
        cf.iloadLocal(end);
        cf.add((byte)-93, next);
        cf.add((byte)-69, "java.lang.Integer");
        cf.add((byte)89);
        cf.iloadLocal(start);
        cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
        cf.storeLocal(tmp);
        count.set(cf, tmp);
        env.continueLabel = cont = cf.getLabel();
        blockNode.accept(this, cc);
        cont.fix();
        cf.storeLocal(last);
        cf.add((byte)-124, start, 1);
        cf.add((byte)-89, loop1);
        loop2.fix();
        cf.iloadLocal(start);
        cf.iloadLocal(end);
        cf.add((byte)-95, next);
        cf.add((byte)-69, "java.lang.Integer");
        cf.add((byte)89);
        cf.iloadLocal(start);
        cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
        cf.storeLocal(tmp);
        count.set(cf, tmp);
        env.continueLabel = cont2 = cf.getLabel();
        blockNode.accept(this, cc);
        cont2.fix();
        cf.storeLocal(last);
        cf.add((byte)-124, start, -1);
        cf.add((byte)-89, loop2);
        next.fix();
        cf.loadLocal(last);
        cf.freeLocal(last);
        cf.freeLocal(tmp);
        cf.freeLocal(start);
        cf.freeLocal(end);
        cc.closeControlEnv();
        cc.closeScope();
        brk.fix();
    }

    public Object foreachStatement(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        this.doForeach(node.str, node.jjtGetChild(0), node.jjtGetChild(1), cc, cf);
        return null;
    }

    public Object switchStatement(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.addLineInfo(cc, ctx, node);
        int n = node.jjtGetNumChildren();
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        cc.openScope(new String[0]);
        int match = cf.getLocal();
        cf.add((byte)3);
        cf.istoreLocal(match);
        int last = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(last);
        Label next = cf.getLabel();
        ControlEnv env = cc.openControlEnv(95);
        env.breakLabel = next;
        for (int i = 1; i < n; ++i) {
            SimpleNode _node = node.jjtGetChild(i);
            if (_node.jjtGetNumChildren() == 1) {
                cf.iloadLocal(match);
                Label hit = cf.getLabel();
                cf.add((byte)-102, hit);
                ++i;
                this.accept(_node, 0, context);
                cf.loadLocal(tgt);
                cf.add((byte)-72, "pnuts.lang.Runtime", "eq", "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                Label cont = cf.getLabel();
                cf.add((byte)-103, cont);
                cf.add((byte)4);
                cf.istoreLocal(match);
                hit.fix();
                this.accept(node, i, context);
                cf.storeLocal(last);
                cont.fix();
                continue;
            }
            cf.add((byte)4);
            cf.istoreLocal(match);
            this.accept(node, ++i, context);
            cf.storeLocal(last);
        }
        cf.freeLocal(tgt);
        cf.freeLocal(match);
        cf.loadLocal(last);
        next.fix();
        cc.closeControlEnv();
        cc.closeScope();
        return null;
    }

    public Object switchBlock(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            int m = n - 1;
            for (int i = 0; i < m; ++i) {
                this.accept(node, i, context);
                cf.add((byte)87);
            }
            this.accept(node, m, context);
        } else {
            cf.add((byte)1);
        }
        return null;
    }

    public Object ternary(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        SimpleNode condNode = node.jjtGetChild(0);
        condNode.accept(this, context);
        Label l_else = cf.getLabel();
        Label next = cf.getLabel();
        if (condNode.getAttribute("inlinedBoolean") != null) {
            cf.add((byte)-103, l_else);
            this.accept(node, 1, context);
            cf.add((byte)-89, next);
            l_else.fix();
            cf.stackTop = (short)(cf.stackTop - 1);
        } else {
            this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
            cf.add((byte)-64, "java.lang.Boolean");
            cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
            cf.add((byte)-103, l_else);
            this.accept(node, 1, context);
            cf.add((byte)-89, next);
            l_else.fix();
            cf.stackTop = (short)(cf.stackTop - 1);
        }
        this.accept(node, 2, context);
        next.fix();
        return null;
    }

    static String getPackageName(SimpleNode node) {
        if (node.jjtGetNumChildren() > 0) {
            SimpleNode c1 = node.jjtGetChild(0);
            return Compiler.getPackageName(c1) + "::" + node.str;
        }
        return node.str;
    }

    static String gensym(Context context) {
        return ((CompileContext)context).sym.gen();
    }

    protected Object accept(SimpleNode node, int idx, Context context) {
        return node.jjtGetChild(idx).accept(this, context);
    }

    private Object assign(SimpleNode node, Context context, int id) {
        this.accept(node, 1, context);
        this._assign(node.jjtGetChild(0), context, id, false, true);
        return null;
    }

    private Object _assign(SimpleNode lhs, Context context, int id, boolean mutable, boolean nopop) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        int rhs = cf.getLocal();
        if ((id & 0x8000) == 0) {
            cf.storeLocal(rhs);
        }
        if (lhs.id == 5) {
            this.assignId(cf, id, ctx, rhs, lhs, cc, mutable, nopop);
        } else if (lhs.id == 4) {
            this.assignGlobal(cf, id, ctx, rhs, lhs, cc, nopop);
        } else if (lhs.id == 15) {
            this.assignIndex(cf, id, ctx, rhs, lhs, cc, nopop);
        } else if (lhs.id == 21) {
            this.assignStaticMember(cf, id, ctx, rhs, lhs, cc, nopop);
        } else if (lhs.id == 20) {
            this.assignMember(cf, id, ctx, rhs, lhs, cc, nopop);
        } else if (lhs.id == 23 && id == 31) {
            this.assignRange(cf, id, ctx, rhs, lhs, cc);
        } else {
            throw new PnutsException("illegal.assign", new Object[0], context);
        }
        cf.freeLocal(rhs);
        return null;
    }

    boolean inControl(SimpleNode node, CompileContext cc) {
        while (node != null) {
            if (node.id == 98 || node.id == 13) {
                return false;
            }
            if (cc.inGeneratorBlock && (node.id == 94 || node.id == 89 && node.jjtGetChild((int)0).id == 90)) {
                return false;
            }
            if (node.id == 95 || node.id == 94 || node.id == 89 || node.id == 81 || node.id == 88 || node.id == 78) {
                return true;
            }
            node = node.jjtGetParent();
        }
        return false;
    }

    static boolean isConditionalNode(SimpleNode node) {
        int id = node.jjtGetParent().id;
        return id == 78 || id == 79 || id == 89 || id == 81 || id == 88;
    }

    void assignId(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean mutable, boolean nopop) {
        Reference ref = cc.findReference(lhs.str);
        Frame env = cc.env;
        if (cc.inGeneratorBlock && ref == null && cc.env != null && cc.env.parent != null) {
            int ret = -1;
            if (id != 31) {
                if ((id & 0x8000) == 0) {
                    cf.loadLocal(ctx);
                    cf.add((byte)18, cf.addConstant(lhs.str));
                    cf.add((byte)-74, "pnuts.lang.Context", "getId", "(Ljava/lang/String;)", "Ljava/lang/Object;");
                    ret = cf.getLocal();
                    cf.storeLocal(ret);
                    cf.loadLocal(ret);
                    cf.loadLocal(rhs);
                }
                this.compute(cf, id, ctx);
                cf.storeLocal(rhs);
            }
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.Context", "getCurrentPackage", "()", "Lpnuts/lang/Package;");
            cf.add((byte)18, cf.addConstant(lhs.str));
            cf.loadLocal(rhs);
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
            if (nopop) {
                cf.loadLocal(rhs);
            }
            return;
        }
        if (cc.env.parent != null && !mutable) {
            boolean idx = false;
            if (ref == null) {
                cc.declare(lhs.str);
                ref = cc.getReference(lhs.str);
            } else if (id == 31) {
                cc.redefine(lhs.str);
            }
            if (id != 31) {
                if ((id & 0x8000) == 0) {
                    Compiler.getRef(ref, cc);
                    cf.loadLocal(rhs);
                }
                this.compute(cf, id, ctx);
                cf.storeLocal(rhs);
            }
            ref.set(cf, rhs);
            if (!this.inControl(lhs, cc)) {
                cc.setReference(lhs.str);
            }
            if (nopop) {
                cf.loadLocal(rhs);
            }
        } else if (ref != null) {
            if (id != 31) {
                if ((id & 0x8000) == 0) {
                    Compiler.getRef(ref, cc);
                    cf.loadLocal(rhs);
                }
                this.compute(cf, id, ctx);
                cf.storeLocal(rhs);
            }
            ref.set(cf, rhs);
            if (nopop) {
                cf.loadLocal(rhs);
            }
        } else {
            int ret = -1;
            if (id != 31) {
                if ((id & 0x8000) == 0) {
                    cf.loadLocal(ctx);
                    cf.add((byte)18, cf.addConstant(lhs.str));
                    cf.add((byte)-74, "pnuts.lang.Context", "getId", "(Ljava/lang/String;)", "Ljava/lang/Object;");
                    ret = cf.getLocal();
                    cf.storeLocal(ret);
                    cf.loadLocal(ret);
                    cf.loadLocal(rhs);
                }
                this.compute(cf, id, ctx);
                cf.storeLocal(rhs);
            }
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.Context", "getCurrentPackage", "()", "Lpnuts/lang/Package;");
            cf.add((byte)18, cf.addConstant(lhs.str));
            cf.loadLocal(rhs);
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
            if (nopop) {
                cf.loadLocal(rhs);
            }
        }
    }

    void assignMember(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean nopop) {
        this.accept(lhs, 0, cc);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        if (id != 31) {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(ctx);
                cf.loadLocal(tgt);
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.add((byte)-72, "pnuts.lang.Runtime", "getField", "(Lpnuts/lang/Context;Ljava/lang/Object;Ljava/lang/String;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)18, cf.addConstant(lhs.str));
        cf.loadLocal(rhs);
        cf.add((byte)-72, "pnuts.lang.Runtime", "putField", "(Lpnuts/lang/Context;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)", "V");
        if (nopop) {
            cf.loadLocal(rhs);
        }
    }

    void assignIndex(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean nopop) {
        SimpleNode idxNode = lhs.jjtGetChild(1);
        if (ConstraintsTransformer.isPredicate(idxNode)) {
            SimpleNode n = ConstraintsTransformer.buildFunc(idxNode);
            lhs.jjtAddChild(n, 1);
            n.jjtSetParent(lhs);
        }
        this.accept(lhs, 0, cc);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        this.accept(lhs, 1, cc);
        int idx = cf.getLocal();
        cf.storeLocal(idx);
        Label next = cf.getLabel();
        cf.loadLocal(tgt);
        cf.add((byte)-63, "java.lang.String");
        Label l2 = cf.getLabel();
        cf.add((byte)-103, l2);
        if (id != 31) {
            this.error(cf, "illegal.assign", cc);
        } else {
            cf.loadLocal(tgt);
            cf.loadLocal(idx);
            cf.add((byte)89);
            cf.loadLocal(rhs);
            cf.add((byte)-63, "java.lang.Character");
            Label ok = cf.getLabel();
            cf.add((byte)-102, ok);
            this.error(cf, "illegal.assign", cc);
            ok.fix();
            cf.loadLocal(rhs);
            cf.loadLocal(cc.getContextIndex());
            cf.add((byte)-72, "pnuts.lang.Runtime", "setRange", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            SimpleNode ch = lhs.jjtGetChild(0);
            if (!(ch.id != 5 && ch.id != 4 && ch.id != 15 && ch.id != 20 && ch.id != 21 || ch.str == null || cc.env.parent != null && cc.getReference(ch.str) == null)) {
                this._assign(ch, cc, id, true, true);
            }
            cf.add((byte)-89, next);
        }
        l2.fix();
        if (id == 31) {
            cf.loadLocal(tgt);
            cf.loadLocal(idx);
            cf.loadLocal(rhs);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "setElement", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
            if (nopop) {
                cf.loadLocal(rhs);
            }
        } else {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(tgt);
                cf.loadLocal(idx);
                cf.loadLocal(ctx);
                cf.add((byte)-72, "pnuts.lang.Runtime", "getElement", "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
            cf.loadLocal(tgt);
            cf.loadLocal(idx);
            cf.loadLocal(rhs);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "setElement", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
            if (nopop) {
                cf.loadLocal(rhs);
            }
        }
        cf.freeLocal(tgt);
        cf.freeLocal(idx);
        next.fix();
    }

    void assignRange(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc) {
        this.accept(lhs, 0, cc);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        this.accept(lhs, 1, cc);
        int idx1 = cf.getLocal();
        cf.storeLocal(idx1);
        int idx2 = cf.getLocal();
        if (lhs.jjtGetNumChildren() >= 3) {
            this.accept(lhs, 2, cc);
        } else {
            cf.add((byte)1);
        }
        cf.storeLocal(idx2);
        cf.loadLocal(tgt);
        cf.loadLocal(idx1);
        cf.freeLocal(idx1);
        cf.loadLocal(idx2);
        cf.freeLocal(idx2);
        cf.loadLocal(rhs);
        cf.loadLocal(cc.getContextIndex());
        cf.add((byte)-72, "pnuts.lang.Runtime", "setRange", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        SimpleNode ch = lhs.jjtGetChild(0);
        if (ch.id == 5 || ch.id == 4 || ch.id == 15 || ch.id == 20 || ch.id == 21) {
            int assigned = cf.getLocal();
            cf.storeLocal(assigned);
            cf.loadLocal(tgt);
            cf.freeLocal(tgt);
            cf.add((byte)-63, "java.lang.String");
            Label no = cf.getLabel();
            cf.add((byte)-103, no);
            cf.loadLocal(assigned);
            this._assign(ch, cc, id, true, true);
            cf.add((byte)87);
            no.fix();
            cf.loadLocal(assigned);
            cf.freeLocal(assigned);
        }
    }

    void assignStaticMember(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean nopop) {
        SimpleNode c1 = lhs.jjtGetChild(0);
        String pkgName = Compiler.getPackageName(c1);
        cf.add((byte)18, cf.addConstant(pkgName));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        cf.loadLocal(tgt);
        Label l_null = cf.getLabel();
        cf.add((byte)-58, l_null);
        if (id != 31) {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(tgt);
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.loadLocal(ctx);
                cf.add((byte)-74, "pnuts.lang.Package", "get", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
        }
        cf.loadLocal(tgt);
        cf.add((byte)18, cf.addConstant(lhs.str));
        cf.loadLocal(rhs);
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        if (nopop) {
            cf.loadLocal(rhs);
        }
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        l_null.fix();
        if (nopop) {
            cf.stackTop = (short)(cf.stackTop - 1);
        }
        c1.accept(this, cc);
        cf.add((byte)89);
        cf.storeLocal(tgt);
        cf.add((byte)-63, "java.lang.Class");
        Label err = cf.getLabel();
        cf.add((byte)-103, err);
        if (id != 31) {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(ctx);
                cf.loadLocal(tgt);
                cf.add((byte)-64, "java.lang.Class");
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.add((byte)-72, "pnuts.lang.Runtime", "getStaticField", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)-64, "java.lang.Class");
        cf.add((byte)18, cf.addConstant(lhs.str));
        cf.loadLocal(rhs);
        cf.add((byte)-72, "pnuts.lang.Runtime", "putStaticField", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Object;)", "V");
        if (nopop) {
            cf.loadLocal(rhs);
        }
        cf.add((byte)-89, next);
        err.fix();
        this.error(cf, "package.notFound", cc);
        next.fix();
    }

    void assignGlobal(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean nopop) {
        cf.add((byte)18, cf.addConstant(""));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int gbl = cf.getLocal();
        cf.storeLocal(gbl);
        if (id != 31) {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(gbl);
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.loadLocal(ctx);
                cf.add((byte)-74, "pnuts.lang.Package", "get", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
                cf.freeLocal(gbl);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
        }
        cf.loadLocal(gbl);
        cf.add((byte)18, cf.addConstant(lhs.str));
        cf.loadLocal(rhs);
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        if (nopop) {
            cf.loadLocal(rhs);
        }
    }

    void error(ClassFile cf, String keyword, CompileContext cc) {
        this.error(cf, keyword, null, cc);
    }

    void errorSymbol(ClassFile cf, String keyword, int stringConstant, CompileContext cc) {
        cf.add((byte)-69, "pnuts.lang.PnutsException");
        cf.add((byte)89);
        cf.add((byte)18, cf.addConstant(keyword));
        cf.pushInteger(1);
        cf.add((byte)-67, "java.lang.Object");
        cf.add((byte)89);
        cf.pushInteger(0);
        cf.add((byte)18, stringConstant);
        cf.add((byte)83);
        int ctx = cc.getContextIndex();
        cf.loadLocal(ctx);
        cf.add((byte)-73, "pnuts.lang.PnutsException", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        cf.add((byte)-65);
    }

    void error(ClassFile cf, String keyword, int[] locals, CompileContext cc) {
        cf.add((byte)-69, "pnuts.lang.PnutsException");
        cf.add((byte)89);
        cf.add((byte)18, cf.addConstant(keyword));
        if (locals == null) {
            cf.add((byte)-78, cc.constClassName, "NO_PARAM", "[Ljava/lang/Object;");
        } else {
            cf.pushInteger(locals.length);
            cf.add((byte)-67, "java.lang.Object");
            for (int i = 0; i < locals.length; ++i) {
                cf.add((byte)89);
                cf.pushInteger(i);
                cf.loadLocal(locals[i]);
                cf.add((byte)83);
            }
        }
        int ctx = cc.getContextIndex();
        cf.loadLocal(ctx);
        cf.add((byte)-73, "pnuts.lang.PnutsException", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        cf.add((byte)-65);
    }

    void compute(ClassFile cf, int id, int ctx) {
        String method;
        cf.loadLocal(ctx);
        switch (id) {
            case 32: {
                method = "multiply";
                break;
            }
            case 33: {
                method = "mod";
                break;
            }
            case 34: {
                method = "divide";
                break;
            }
            case 35: {
                method = "add";
                break;
            }
            case 32803: {
                cf.add((byte)-72, "pnuts.lang.Runtime", "add1", "(Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                return;
            }
            case 36: {
                method = "subtract";
                break;
            }
            case 32804: {
                cf.add((byte)-72, "pnuts.lang.Runtime", "subtract1", "(Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                return;
            }
            case 37: {
                method = "shiftLeft";
                break;
            }
            case 38: {
                method = "shiftRight";
                break;
            }
            case 39: {
                method = "shiftArithmetic";
                break;
            }
            case 40: {
                method = "and";
                break;
            }
            case 41: {
                method = "xor";
                break;
            }
            case 42: {
                method = "or";
                break;
            }
            default: {
                throw new RuntimeException("never happen");
            }
        }
        cf.add((byte)-72, "pnuts.lang.Runtime", method, "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
    }

    static CodeLoader createCodeLoader(ClassLoader loader, boolean privileged) {
        if (hasJava2Security && privileged) {
            return privilegedCodeLoaderFactory.create(loader);
        }
        return codeLoaderFactory.create(loader);
    }

    public static CodeLoader createCodeLoader(ClassLoader loader) {
        return Compiler.createCodeLoader(loader, false);
    }

    public Object compile(Pnuts pnuts, ClassFileHandler handler) {
        CompileContext cc = new CompileContext();
        return this.compile(pnuts, handler, cc);
    }

    Object compile(Pnuts pnuts, ClassFileHandler handler, CompileContext cc) {
        this.automatic = false;
        cc.scriptSource = pnuts.getScriptSource();
        pnuts.accept(this, cc);
        Object compileResult = handler.handle(cc.getClassFile());
        Enumeration e = cc.getClassFiles();
        while (e.hasMoreElements()) {
            ClassFile cf = (ClassFile)e.nextElement();
            handler.handle(cf);
        }
        return compileResult;
    }

    public Pnuts compile(Pnuts pnuts, final Context context) {
        Throwable caught = null;
        try {
            final CodeLoader loader = Compiler.createCodeLoader(context.getClassLoader(), true);
            final CompileContext cc = new CompileContext();
            ClassFileHandler loadHandler = new ClassFileHandler(){

                public Object handle(ClassFile cf) {
                    try {
                        return cc.load(cf, loader);
                    }
                    catch (IOException e) {
                        throw new PnutsException(e, context);
                    }
                }
            };
            Class cls = (Class)this.compile(pnuts, loadHandler, cc);
            cc.resolve(loader);
            Runtime rt = (Runtime)cls.newInstance();
            return new CompiledScript(rt, pnuts);
        }
        catch (Throwable t) {
            caught = t;
            Runtime.checkException(context, caught);
            throw new PnutsException(caught, context);
        }
    }

    public Pnuts compile(String expression) {
        Context context = new Context();
        try {
            return this.compile(Pnuts.parse(expression), context);
        }
        catch (ParseException e) {
            Runtime.checkException(context, e);
            throw new PnutsException(e, context);
        }
    }

    public Pnuts compile(String expression, Context context) {
        try {
            return this.compile(Pnuts.parse(expression), context);
        }
        catch (ParseException e) {
            Runtime.checkException(context, e);
            throw new PnutsException(e, context);
        }
    }

    public Object compile(PnutsFunction pf, ClassFileHandler handler) {
        CompileContext cc = new CompileContext();
        Object ret = null;
        StringBuffer buf = new StringBuffer();
        Enumeration e = Runtime.getFunctions(pf);
        while (e.hasMoreElements()) {
            Function f = (Function)e.nextElement();
            if (f == null) continue;
            int nargs = f.getNumberOfParameter();
            String[] im = f.getImportEnv();
            buf.append("import(null);");
            for (int i = 0; i < im.length; ++i) {
                buf.append("import " + im[i] + ";");
            }
            buf.append(pf.unparse(nargs));
            buf.append('\n');
        }
        try {
            String expr = buf.toString();
            return this.compile(Pnuts.parse(expr), handler, cc);
        }
        catch (ParseException pe) {
            throw new PnutsException(pe, (Context)cc);
        }
    }

    public PnutsFunction compile(PnutsFunction pf) {
        return this.compile(pf, new Context());
    }

    public PnutsFunction compile(PnutsFunction pf, Context context) {
        StringBuffer buf = new StringBuffer();
        Enumeration e = Runtime.getFunctions(pf);
        while (e.hasMoreElements()) {
            Function f = (Function)e.nextElement();
            if (f == null) continue;
            int nargs = f.getNumberOfParameter();
            String[] im = f.getImportEnv();
            buf.append("import(null);");
            for (int i = 0; i < im.length; ++i) {
                buf.append("import " + im[i] + ";");
            }
            buf.append(pf.unparse(nargs));
            buf.append('\n');
        }
        Context c = (Context)context.clone();
        return (PnutsFunction)this.compile(buf.toString(), context).run(c);
    }

    public static boolean isCompiled(Object obj) {
        if (obj instanceof Compiled) {
            return true;
        }
        if (obj instanceof PnutsFunction) {
            Enumeration e = Runtime.getFunctions((PnutsFunction)obj);
            while (e.hasMoreElements()) {
                Function f = (Function)e.nextElement();
                if (f instanceof Compiled) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void resolveClassName(SimpleNode nameNode, CompileContext cc, int ctx) {
        ClassFile cf = cc.cf;
        int n = nameNode.jjtGetNumChildren();
        if (n == 1) {
            String sym = nameNode.jjtGetChild((int)0).str;
            if (sym == Runtime.INT_SYMBOL) {
                cf.add((byte)-78, "java.lang.Integer", "TYPE", "Ljava/lang/Class;");
                return;
            }
            if (sym == Runtime.SHORT_SYMBOL) {
                cf.add((byte)-78, "java.lang.Short", "TYPE", "Ljava/lang/Class;");
                return;
            }
            if (sym == Runtime.CHAR_SYMBOL) {
                cf.add((byte)-78, "java.lang.Character", "TYPE", "Ljava/lang/Class;");
                return;
            }
            if (sym == Runtime.BYTE_SYMBOL) {
                cf.add((byte)-78, "java.lang.Byte", "TYPE", "Ljava/lang/Class;");
                return;
            }
            if (sym == Runtime.LONG_SYMBOL) {
                cf.add((byte)-78, "java.lang.Long", "TYPE", "Ljava/lang/Class;");
                return;
            }
            if (sym == Runtime.FLOAT_SYMBOL) {
                cf.add((byte)-78, "java.lang.Float", "TYPE", "Ljava/lang/Class;");
                return;
            }
            if (sym == Runtime.DOUBLE_SYMBOL) {
                cf.add((byte)-78, "java.lang.Double", "TYPE", "Ljava/lang/Class;");
                return;
            }
            if (sym == Runtime.BOOLEAN_SYMBOL) {
                cf.add((byte)-78, "java.lang.Boolean", "TYPE", "Ljava/lang/Class;");
                return;
            }
            if (sym == Runtime.VOID_SYMBOL) {
                cf.add((byte)-78, "java.lang.Void", "TYPE", "Ljava/lang/Class;");
                return;
            }
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(nameNode.jjtGetChild((int)0).str);
        for (int i = 1; i < n; ++i) {
            sbuf.append('.');
            sbuf.append(nameNode.jjtGetChild((int)i).str);
        }
        cf.loadLocal(ctx);
        int index = cf.getLocal();
        cf.add((byte)18, cf.addConstant(sbuf.toString()));
        cf.storeLocal(index);
        cf.loadLocal(index);
        cf.add((byte)-74, "pnuts.lang.Context", "resolveClass", "(Ljava/lang/String;)", "Ljava/lang/Class;");
        int value = cf.getLocal();
        cf.storeLocal(value);
        cf.loadLocal(value);
        Label nonnull = cf.getLabel();
        cf.add((byte)-57, nonnull);
        this.error(cf, "class.notFound", new int[]{index}, cc);
        nonnull.fix();
        cf.loadLocal(value);
        cf.freeLocal(value);
        cf.freeLocal(index);
    }

    void resolveType(SimpleNode typeNode, CompileContext cc, int ctx) {
        ClassFile cf = cc.cf;
        Object type = null;
        if (typeNode.id == 14) {
            SimpleNode n;
            int count = 0;
            for (n = typeNode; n != null && n.id == 14; n = n.jjtGetChild(0)) {
                ++count;
            }
            if (n != null && n.id != 16) {
                throw new RuntimeException();
            }
            this.resolveClassName(n, cc, ctx);
            cf.pushInteger(count);
            cf.add((byte)-72, "pnuts.lang.Runtime", "arrayType", "(Ljava/lang/Class;I)", "Ljava/lang/Class;");
        } else if (typeNode.id == 16) {
            this.resolveClassName(typeNode, cc, ctx);
        } else {
            this.error(cf, "class.expected", cc);
        }
    }

    static void getRef(Reference ref, CompileContext cc) {
        ref.get(cc.cf, cc.env.parent != null, cc.getContextIndex());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class cls = class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Compiler.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader;
            cls.getDeclaredConstructor(cls);
            hasBootClassLoader = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        hasJava2Security = false;
        try {
            (class$java$lang$Class == null ? (class$java$lang$Class = Compiler.class$("java.lang.Class")) : class$java$lang$Class).getMethod("getProtectionDomain", new Class[0]);
            hasJava2Security = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        codeLoaderFactory = hasBootClassLoader && hasJava2Security ? new Java2CodeLoaderFactory() : new CodeLoaderFactory();
        if (hasJava2Security) {
            privilegedCodeLoaderFactory = new PrivilegedCodeLoaderFactory();
        }
        proxyConf = Compiler.getBoolean("pnuts.compiler.useDynamicProxy");
    }

    static class PrivilegedCodeLoaderFactory
    extends CodeLoaderFactory {
        PrivilegedCodeLoaderFactory() {
        }

        public CodeLoader create(final ClassLoader parent) {
            return (CodeLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ClassLoader cl = (class$pnuts$lang$Pnuts == null ? (class$pnuts$lang$Pnuts = Compiler.class$("pnuts.lang.Pnuts")) : class$pnuts$lang$Pnuts).getClassLoader();
                    if (cl != null) {
                        if (parent != null && cl != parent) {
                            return new CodeLoader(new MultiClassLoader(parent, cl));
                        }
                        return new CodeLoader(cl);
                    }
                    return new CodeLoader(parent);
                }
            });
        }
    }

    static class Java2CodeLoaderFactory
    extends CodeLoaderFactory {
        Java2CodeLoaderFactory() {
        }

        public CodeLoader create(ClassLoader parent) {
            ClassLoader cl = (class$pnuts$lang$Pnuts == null ? (class$pnuts$lang$Pnuts = Compiler.class$("pnuts.lang.Pnuts")) : class$pnuts$lang$Pnuts).getClassLoader();
            if (cl != null) {
                if (parent != null && cl != parent) {
                    return new CodeLoader(new MultiClassLoader(parent, cl));
                }
                return new CodeLoader(cl);
            }
            return new CodeLoader(parent);
        }
    }

    static class CodeLoaderFactory {
        CodeLoaderFactory() {
        }

        public CodeLoader create(ClassLoader parent) {
            return new CodeLoader0(parent);
        }
    }

    static class SignatureInfo {
        String methodName;
        SimpleNode returnTypeNode;
        SimpleNode[] paramTypeNode;

        SignatureInfo() {
        }
    }
}

