%{
/*****************************************************************************/
/*!
 * \file PL.y
 * 
 * Author: Mehul Trivedi
 * 
 * Created: Aug 08 01:45:43 GMT 2004
 *
 * <hr>
 * Copyright (C) 2004 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/
/* PL.y
   Mehul Trivedi, 8/14/04

   This file contains the bison code for the parser that reads in CVC
   commands in lisp language.
*/

#include "vc.h"
#include "parser_exception.h"
#include "parser_temp.h"

// Exported shared data
namespace CVCL {
  extern ParserTemp* parserTemp;
}
// Define shortcuts for various things
#define TMP CVCL::parserTemp
#define EXPR CVCL::parserTemp->expr
#define VC (CVCL::parserTemp->vc)
#define RAT(args) CVCL::newRational args

// Suppress the bogus warning suppression in bison (it generates
// compile error)
#undef __GNUC_MINOR__

/* stuff that lives in Lisp.lex */
extern int Lisplex(void);

int Lisperror(char *s)
{
  std::ostringstream ss;
  ss << CVCL::parserTemp->fileName << ":" << CVCL::parserTemp->lineNum
     << ": " << s;
  return CVCL::parserTemp->error(ss.str());
}

#define YYLTYPE_IS_TRIVIAL 1
#define YYMAXDEPTH 10485760

%}

%union {
  std::string *str;
  CVCL::Expr *node;
  std::vector<CVCL::Expr> *vec;
  int kind;
};


%start cmd

/* strings are for better error messages.  
   "_TOK" is so macros don't conflict with kind names */

%token  BINARY_TOK              "0b"
%token  HEX_TOK                 "0x"  
%token  DONE_TOK

%type <vec> Exprs 
%type <node> Identifier StringLiteral Numeral Binary Hex
%type <node> Expr

%token <str> ID_TOK STRINGLIT_TOK NUMERAL_TOK

/*%token DONE*/

%%

cmd             :	Expr
			{
			 EXPR = *$1;
			 delete $1;
			 YYACCEPT;
			}
		;

Expr            :       Identifier 		{ }
		|	StringLiteral 		{ }
		|	Numeral 		{ }
		|	Binary			{ }
		|	Hex			{ }
		|	'(' Exprs ')'		
			{
		  	$$ = new CVCL::Expr(VC->listExpr(*$2));
		  	delete $2;
                        }
		|	DONE_TOK
			{ 
			 TMP->done = true;
			 EXPR = CVCL::Expr();
			 YYACCEPT;
			}
		;

Identifier      :       ID_TOK
                        {
			  $$ = new CVCL::Expr(VC->idExpr(*$1));
			  delete $1;
			}
                ;
		
StringLiteral   :       STRINGLIT_TOK
                        {
			  $$ = new CVCL::Expr(VC->stringExpr(*$1));
			  delete $1;
			}
                ;
Numeral         :       NUMERAL_TOK
                        {
  			  $$ = new CVCL::Expr(VC->ratExpr((*$1)));
  			  delete $1;
			}
                ;

Binary          :       BINARY_TOK NUMERAL_TOK
                        {
			  $$ = new CVCL::Expr(VC->stringExpr(*$2));
			  delete $2;
                        }
                ;

Hex             :       HEX_TOK NUMERAL_TOK
                        {
			  $$ = new CVCL::Expr(VC->ratExpr(*$2, 16));
			  delete $2;
                        }
                ;


Exprs		:	{
			$$ = new std::vector<CVCL::Expr>;
			}
		|	Exprs Expr
			{
			$1->push_back(*$2);
			delete $2;
			}
		;
		
%%
