/*****************************************************************************/
/*!
 *\file theory_datatype.h
 *
 * Author: Clark Barrett
 *
 * Created: Wed Dec  1 22:24:32 2004
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__include__theory_datatype_lazy_h_
#define _cvcl__include__theory_datatype_lazy_h_

#include "theory.h"
#include "smartcdo.h"
#include "cdmap.h"
#include "theory_datatype.h"

namespace CVCL {

/*****************************************************************************/
/*!
 *\class TheoryDatatypeLazy
 *\ingroup Theories
 *\brief This theory handles datatypes.
 *
 * Author: Clark Barrett
 *
 * Created: Wed Dec  1 22:27:12 2004
 */
/*****************************************************************************/
class TheoryDatatypeLazy :public TheoryDatatype {

  typedef enum {
    MERGE1 = 0,
    MERGE2,
    ENQUEUE
  } ProcessKinds;

  CDList<Theorem> d_processQueue;
  CDList<ProcessKinds> d_processQueueKind;
  CDO<unsigned> d_processIndex;
  CDO<bool> d_typeComplete;

private:
  void instantiate(const Expr& e, const bigunsigned& u);
  void initializeLabels(const Expr& e, const Type& t);
  void mergeLabels(const Theorem& thm, const Expr& e1, const Expr& e2);
  void mergeLabels(const Theorem& thm, const Expr& e,
                   unsigned position, bool positive);

public:
  TheoryDatatypeLazy(TheoryCore* theoryCore);
  ~TheoryDatatypeLazy() {}

  // Theory interface
  void checkSat(bool fullEffort);
  void setup(const Expr& e);
  void update(const Theorem& e, const Expr& d);

};

}

#endif
