/*****************************************************************************/
/*!
 * \file memory_manager.h
 * 
 * Author: Sergey Berezin
 * 
 * Created: Tue Apr 19 14:30:36 2005
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 * Class MemoryManagerMalloc: default implementation of MemoryManager
 * using malloc().
 * 
 * Typical use of this class is to create 
 * MemoryManager* mm = new MemoryManager(sizeof(YourClass)); 
 * where YourClass has operators new and delete redefined:
 * void* YourClass::operator new(size_t, MemoryManager* mm)
 * { return mm->newData(); }
 * void YourClass::delete(void*) { } // do not deallocate memory here
 * Then, create objects with obj = new(mm) YourClass(), and destroy them with
 * delete obj; mm->deleteData(obj);
 */
/*****************************************************************************/

#ifndef _CVC_lite__memory_manager_malloc_h
#define _CVC_lite__memory_manager_malloc_h

#include "memory_manager.h"

namespace CVCL {

class MemoryManagerMalloc: public MemoryManager {
 public:
  // Constructor
  MemoryManagerMalloc() { }
  // Destructor
  ~MemoryManagerMalloc() { }

  void* newData(size_t size) {
    return malloc(size);
  }

  void deleteData(void* d) {
    free(d);
  }
}; // end of class MemoryManager

}

#endif
