/*****************************************************************************/
/*!
 * \file expr.h
 * \brief Definition of the API to expression package.  See class Expr for details.
 * 
 * Author: Clark Barrett
 * 
 * Created: Tue Nov 26 00:27:40 2002
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 * Define std::hash<Expr> and std::hash<std::string> for hash_map and
 * hash_set over Expr class.
 */
/*****************************************************************************/

#ifndef _CVC_lite__expr_h_
#include "expr.h"
#endif

#ifndef _cvcl__include__expr_hash_h_
#define _cvcl__include__expr_hash_h_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE___GNU_CXX__EXT_HASH_MAP
namespace __gnu_cxx
#else
namespace std
#endif
{

template<> struct hash<CVCL::Expr>
{
  size_t operator()(const CVCL::Expr& e) const { return e.hash(); }
};

template<> class hash<std::string> {
 private:  
  hash<const char*> h;
 public:
  size_t operator()(const std::string& s) const {
    return h(s.c_str());
  }
};

}

#ifdef HAVE___GNU_CXX__EXT_HASH_MAP
namespace std {
  using namespace __gnu_cxx;
};
#endif


#endif
