/*****************************************************************************/
/*!
 *\file cvclutil.h
 *\brief basic helper utilities
 *
 * Author: Clark Barrett
 *
 * Created: Thu Dec  1 16:35:52 2005
 */
/*****************************************************************************/

#ifndef _CVC_lite__debug_h
#include "debug.h"
#endif

#ifndef _CVC_lite__cvclutil_h
#define _CVC_lite__cvclutil_h

namespace CVCL {

inline std::string int2string(int n) {
  std::ostringstream ss;
  ss << n;
  return ss.str();
}

template<class T>
T abs(T t) { return t < 0 ? -t : t; }

template<class T>
T max(T a, T b) { return a > b ? a : b; }

struct ltstr{
  bool operator()(const std::string& s1, const std::string& s2) const{
    return s1.compare(s2) < 0;
  }
};

template<class T>
class StrPairLess {
public:
  bool operator()(const std::pair<std::string,T>& p1,
		  const std::pair<std::string,T>& p2) const {
    return p1.first < p2.first;
  }
};

template<class T>
std::pair<std::string,T> strPair(const std::string& f, const T& t) {
  return std::pair<std::string,T>(f, t);
}

typedef std::pair<std::string,std::string> StrPair;

//! Sort two vectors based on the first vector
template<class T>
void sort2(std::vector<std::string>& keys, std::vector<T>& vals) {
  DebugAssert(keys.size()==vals.size(), "sort2()");
  // Create std::vector of pairs
  std::vector<std::pair<std::string,T> > pairs;
  for(size_t i=0, iend=keys.size(); i<iend; ++i)
    pairs.push_back(strPair(keys[i], vals[i]));
  // Sort pairs
  StrPairLess<T> comp;
  sort(pairs.begin(), pairs.end(), comp);
  DebugAssert(pairs.size() == keys.size(), "sort2()");
  // Split the pairs back into the original vectors
  for(size_t i=0, iend=pairs.size(); i<iend; ++i) {
    keys[i] = pairs[i].first;
    vals[i] = pairs[i].second;
  }
}

}

#endif
