/*****************************************************************************/
/*!
 * \file cdo.h
 * 
 * Author: Clark Barrett
 * 
 * Created: Wed Feb 12 17:27:43 2003
 *
 * <hr>
 * Copyright (C) 2003 by the Board of Trustees of Leland Stanford
 * Junior University and by New York University. 
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * LICENSE file provided with this distribution.  In particular:
 *
 * - The above copyright notice and this permission notice must appear
 * in all copies of the software and related documentation.
 *
 * - THE SOFTWARE IS PROVIDED "AS-IS", WITHOUT ANY WARRANTIES,
 * EXPRESSED OR IMPLIED.  USE IT AT YOUR OWN RISK.
 * 
 * <hr>
 * 
 */
/*****************************************************************************/

#ifndef _cvcl__include__cdo_h_
#define _cvcl__include__cdo_h_

#include "context.h"

namespace CVCL {

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Class: CDO (Context Dependent Object)				     //
// Author: Clark Barrett                                                     //
// Created: Wed Feb 12 17:28:25 2003					     //
// Description: Generic templated class for an object which must be saved    //
//              and restored as contexts are pushed and popped.  Requires    //
//              that operator= be defined for the data class.                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
template <class T>
class CDO :public ContextObj {
  T d_data;

  virtual ContextObj* makeCopy(void) { return new CDO<T>(*this); }
  virtual void restoreData(ContextObj* data) {
    d_data = ((CDO<T>*)data)->d_data;
  }
  virtual void setNull(void) { d_data = T(); }

  // Disable copy constructor and operator=
  // If you need these, use smartcdo instead
  CDO(const CDO<T>& cdo): ContextObj(cdo), d_data(cdo.d_data) { }
  CDO<T>& operator=(const CDO<T>& cdo) {}

public:
  CDO(Context* context) : ContextObj(context)
    { IF_DEBUG(setName("CDO")); }
  CDO(Context* context, const T& data, int scope = -1)
    : ContextObj(context) {
    IF_DEBUG(setName("CDO"));     
    set(data, scope);
  }
  ~CDO() {
    TRACE("context verbose", "~CDO[", this, "]");
  }
  void set(const T& data, int scope=-1) { makeCurrent(scope); d_data = data; }
  const T& get() const { return d_data; }
  operator T() { return get(); }
  CDO<T>& operator=(const T& data) { set(data); return *this; }
  
};

}

#endif
