(benchmark simplify_benchmark
:source { Simplify Theorem Prover Benchmark Suite }
:logic AUFLIA
:status unsat
:difficulty { 5 }
:category { industrial }
:extrafuns ((true_term Int))
:extrafuns ((false_term Int))
:assumption (= true_term 1)
:assumption (= false_term 0)
:extrafuns ((S_select Int Int Int))
:extrafuns ((S_store Int Int Int Int))
:assumption (forall (?m Int) (?i Int) (?x Int) (= (S_select (S_store ?m ?i ?x) ?i) ?x))
:assumption (forall (?m Int) (?i Int) (?j Int) (?x Int) (implies (not (= ?i ?j)) (= (S_select (S_store ?m ?i ?x) ?j) (S_select ?m ?j))))
:extrafuns ((PO_LT Int Int Int))
:assumption (forall (?t Int) (= (PO_LT ?t ?t) true_term))
:extrafuns ((T_java_lang_Object Int))
:assumption (= (PO_LT T_java_lang_Object T_java_lang_Object) true_term)
:assumption (forall (?t0 Int) (?t1 Int) (?t2 Int) (implies (and (= (PO_LT ?t0 ?t1) true_term) (= (PO_LT ?t1 ?t2) true_term)) (= (PO_LT ?t0 ?t2) true_term)))
:assumption (forall (?t0 Int) (?t1 Int) (implies (and (= (PO_LT ?t0 ?t1) true_term) (= (PO_LT ?t1 ?t0) true_term)) (= ?t0 ?t1)))
:extrafuns ((T_boolean Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_boolean) true_term) (= ?t T_boolean)))
:extrafuns ((T_char Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_char) true_term) (= ?t T_char)))
:extrafuns ((T_byte Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_byte) true_term) (= ?t T_byte)))
:extrafuns ((T_short Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_short) true_term) (= ?t T_short)))
:extrafuns ((T_int Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_int) true_term) (= ?t T_int)))
:extrafuns ((T_long Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_long) true_term) (= ?t T_long)))
:extrafuns ((T_float Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_float) true_term) (= ?t T_float)))
:extrafuns ((T_double Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_double) true_term) (= ?t T_double)))
:assumption (forall (?t Int) (implies (= (PO_LT T_boolean ?t) true_term) (= ?t T_boolean)))
:assumption (forall (?t Int) (implies (= (PO_LT T_char ?t) true_term) (= ?t T_char)))
:assumption (forall (?t Int) (implies (= (PO_LT T_byte ?t) true_term) (= ?t T_byte)))
:assumption (forall (?t Int) (implies (= (PO_LT T_short ?t) true_term) (= ?t T_short)))
:assumption (forall (?t Int) (implies (= (PO_LT T_int ?t) true_term) (= ?t T_int)))
:assumption (forall (?t Int) (implies (= (PO_LT T_long ?t) true_term) (= ?t T_long)))
:assumption (forall (?t Int) (implies (= (PO_LT T_float ?t) true_term) (= ?t T_float)))
:assumption (forall (?t Int) (implies (= (PO_LT T_double ?t) true_term) (= ?t T_double)))
:extrafuns ((asChild Int Int Int))
:extrafuns ((classDown Int Int Int))
:assumption (forall (?t0 Int) (?t1 Int) (?t2 Int) (implies (= (PO_LT ?t0 (asChild ?t1 ?t2)) true_term) (= (classDown ?t2 ?t0) (asChild ?t1 ?t2))))
:extrafuns ((T_java_lang_Cloneable Int))
:assumption (= (PO_LT T_java_lang_Cloneable T_java_lang_Object) true_term)
:extrafuns ((array Int Int))
:assumption (forall (?t Int) (= (PO_LT (array ?t) T_java_lang_Cloneable) true_term))
:extrafuns ((elemtype Int Int))
:assumption (forall (?t Int) (= (elemtype (array ?t)) ?t))
:assumption (forall (?t0 Int) (?t1 Int) (iff (= (PO_LT ?t0 (array ?t1)) true_term) (and (= ?t0 (array (elemtype ?t0))) (= (PO_LT (elemtype ?t0) ?t1) true_term))))
:extrafuns ((is Int Int Int))
:extrafuns ((cast Int Int Int))
:assumption (forall (?x Int) (?t Int) (= (is (cast ?x ?t) ?t) true_term))
:assumption (forall (?x Int) (?t Int) (implies (= (is ?x ?t) true_term) (= (cast ?x ?t) ?x)))
:assumption true
:assumption (forall (?x Int) (iff (= (is ?x T_char) true_term) (and (<= 0 ?x) (<= ?x 65535))))
:assumption (forall (?x Int) (iff (= (is ?x T_byte) true_term) (and (<= (~ 128) ?x) (<= ?x 127))))
:assumption (forall (?x Int) (iff (= (is ?x T_short) true_term) (and (<= (~ 32768) ?x) (<= ?x 32767))))
:extrafuns ((intFirst Int))
:extrafuns ((intLast Int))
:assumption (forall (?x Int) (iff (= (is ?x T_int) true_term) (and (<= intFirst ?x) (<= ?x intLast))))
:extrafuns ((longFirst Int))
:extrafuns ((longLast Int))
:assumption (forall (?x Int) (iff (= (is ?x T_long) true_term) (and (<= longFirst ?x) (<= ?x longLast))))
:assumption (< longFirst intFirst)
:assumption (< intFirst (~ 1000000))
:assumption (< 1000000 intLast)
:assumption (< intLast longLast)
:extrafuns ((null Int))
:extrafuns ((typeof Int Int))
:assumption (forall (?x Int) (?t Int) (implies (= (PO_LT ?t T_java_lang_Object) true_term) (iff (= (is ?x ?t) true_term) (or (= ?x null) (= (PO_LT (typeof ?x) ?t) true_term)))))
:extrafuns ((asField Int Int Int))
:assumption (forall (?f Int) (?t Int) (?x Int) (= (is (S_select (asField ?f ?t) ?x) ?t) true_term))
:extrafuns ((asElems Int Int))
:assumption (forall (?e Int) (?a Int) (?i Int) (= (is (S_select (S_select (asElems ?e) ?a) ?i) (elemtype (typeof ?a))) true_term))
:extrafuns ((vAllocTime Int Int))
:extrafuns ((isAllocated Int Int Int))
:assumption (forall (?x Int) (?a0 Int) (iff (= (isAllocated ?x ?a0) true_term) (< (vAllocTime ?x) ?a0)))
:extrafuns ((fClosedTime Int Int))
:assumption (forall (?x Int) (?f Int) (?a0 Int) (implies (and (< (fClosedTime ?f) ?a0) (= (isAllocated ?x ?a0) true_term)) (= (isAllocated (S_select ?f ?x) ?a0) true_term)))
:extrafuns ((eClosedTime Int Int))
:assumption (forall (?a Int) (?e Int) (?i Int) (?a0 Int) (implies (and (< (eClosedTime ?e) ?a0) (= (isAllocated ?a ?a0) true_term)) (= (isAllocated (S_select (S_select ?e ?a) ?i) ?a0) true_term)))
:extrafuns ((asLockSet Int Int))
:extrafuns ((max Int Int))
:assumption (forall (?S Int) (= (S_select (asLockSet ?S) (max (asLockSet ?S))) true_term))
:assumption (forall (?S Int) (= (S_select (asLockSet ?S) null) true_term))
:extrafuns ((lockLE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (lockLE ?x ?y) true_term) (<= ?x ?y)))
:extrafuns ((lockLT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (lockLT ?x ?y) true_term) (< ?x ?y)))
:assumption (forall (?S Int) (?mu Int) (implies (= (S_select (asLockSet ?S) ?mu) true_term) (= (lockLE ?mu (max (asLockSet ?S))) true_term)))
:assumption (forall (?x Int) (implies (= (PO_LT (typeof ?x) T_java_lang_Object) true_term) (= (lockLE null ?x) true_term)))
:extrafuns ((arrayLength Int Int))
:assumption (forall (?a Int) (and (<= 0 (arrayLength ?a)) (= (is (arrayLength ?a) T_int) true_term)))
:extrafuns ((arrayFresh Int Int Int Int Int Int Int Int))
:extrafuns ((arrayShapeMore Int Int Int))
:extrafuns ((arrayParent Int Int))
:extrafuns ((arrayPosition Int Int))
:assumption (forall (?a Int) (?a0 Int) (?b0 Int) (?e Int) (?n Int) (?s Int) (?T Int) (?v Int) (iff (= (arrayFresh ?a ?a0 ?b0 ?e (arrayShapeMore ?n ?s) ?T ?v) true_term) (and (<= ?a0 (vAllocTime ?a)) (= (isAllocated ?a ?b0) true_term) (not (= ?a null)) (= (typeof ?a) ?T) (= (arrayLength ?a) ?n) (forall (?i Int) (and (= (arrayFresh (S_select (S_select ?e ?a) ?i) ?a0 ?b0 ?e ?s (elemtype ?T) ?v) true_term) (= (arrayParent (S_select (S_select ?e ?a) ?i)) ?a) (= (arrayPosition (S_select (S_select ?e ?a) ?i)) ?i))))))
:extrafuns ((arrayShapeOne Int Int))
:assumption (forall (?a Int) (?a0 Int) (?b0 Int) (?e Int) (?n Int) (?T Int) (?v Int) (iff (= (arrayFresh ?a ?a0 ?b0 ?e (arrayShapeOne ?n) ?T ?v) true_term) (and (<= ?a0 (vAllocTime ?a)) (= (isAllocated ?a ?b0) true_term) (not (= ?a null)) (= (typeof ?a) ?T) (= (arrayLength ?a) ?n) (forall (?i Int) (and (= (S_select (S_select ?e ?a) ?i) ?v))))))
:extrafuns ((arrayType Int))
:assumption (= arrayType (asChild arrayType T_java_lang_Object))
:assumption (forall (?t Int) (= (PO_LT (array ?t) arrayType) true_term))
:extrafuns ((isNewArray Int Int))
:assumption (forall (?s Int) (implies (= true_term (isNewArray ?s)) (= (PO_LT (typeof ?s) arrayType) true_term)))
:extrafuns ((boolAnd Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolAnd ?a ?b) true_term) (and (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolEq Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolEq ?a ?b) true_term) (iff (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolImplies Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolImplies ?a ?b) true_term) (implies (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolNE Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolNE ?a ?b) true_term) (not (iff (= ?a true_term) (= ?b true_term)))))
:extrafuns ((boolNot Int Int))
:assumption (forall (?a Int) (iff (= (boolNot ?a) true_term) (not (= ?a true_term))))
:extrafuns ((boolOr Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolOr ?a ?b) true_term) (or (= ?a true_term) (= ?b true_term))))
:extrafuns ((integralEQ Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralEQ ?x ?y) true_term) (= ?x ?y)))
:extrafuns ((stringCat Int Int Int))
:extrafuns ((T_java_lang_String Int))
:assumption (forall (?x Int) (?y Int) (and (not (= (stringCat ?x ?y) null)) (= (PO_LT (typeof (stringCat ?x ?y)) T_java_lang_String) true_term)))
:extrafuns ((integralGE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralGE ?x ?y) true_term) (>= ?x ?y)))
:extrafuns ((integralGT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralGT ?x ?y) true_term) (> ?x ?y)))
:extrafuns ((integralLE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralLE ?x ?y) true_term) (<= ?x ?y)))
:extrafuns ((integralLT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralLT ?x ?y) true_term) (< ?x ?y)))
:extrafuns ((integralNE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralNE ?x ?y) true_term) (not (= ?x ?y))))
:extrafuns ((refEQ Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (refEQ ?x ?y) true_term) (= ?x ?y)))
:extrafuns ((refNE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (refNE ?x ?y) true_term) (not (= ?x ?y))))
:extrafuns ((nonnullelements Int Int Int))
:assumption (forall (?x Int) (?e Int) (iff (= (nonnullelements ?x ?e) true_term) (and (not (= ?x null)) (forall (?i Int) (implies (and (<= 0 ?i) (< ?i (arrayLength ?x))) (not (= (S_select (S_select ?e ?x) ?i) null)))))))
:extrafuns ((classLiteral Int Int))
:extrafuns ((T_java_lang_Class Int))
:extrafuns ((alloc Int))
:assumption (forall (?t Int) (and (not (= (classLiteral ?t) null)) (= (is (classLiteral ?t) T_java_lang_Class) true_term) (= (isAllocated (classLiteral ?t) alloc) true_term)))
:extrafuns ((integralAnd Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (or (<= 0 ?x) (<= 0 ?y)) (<= 0 (integralAnd ?x ?y))))
:assumption (forall (?x Int) (?y Int) (implies (<= 0 ?x) (<= (integralAnd ?x ?y) ?x)))
:assumption (forall (?x Int) (?y Int) (implies (<= 0 ?y) (<= (integralAnd ?x ?y) ?y)))
:extrafuns ((integralOr Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (and (<= 0 ?x) (<= 0 ?y)) (and (<= ?x (integralOr ?x ?y)) (<= ?y (integralOr ?x ?y)))))
:extrafuns ((integralXor Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (and (<= 0 ?x) (<= 0 ?y)) (<= 0 (integralXor ?x ?y))))
:extrafuns ((intShiftL Int Int Int))
:assumption (forall (?n Int) (implies (and (<= 0 ?n) (< ?n 31)) (<= 1 (intShiftL 1 ?n))))
:extrafuns ((longShiftL Int Int Int))
:assumption (forall (?n Int) (implies (and (<= 0 ?n) (< ?n 63)) (<= 1 (longShiftL 1 ?n))))
:assumption true
:extrafuns ((T_java_io_IOException Int))
:extrafuns ((T_java_lang_Exception Int))
:extrafuns ((T_javafe_util_BufferedCorrelatedReader Int))
:extrafuns ((T_javafe_util_CorrelatedReader Int))
:extrafuns ((T_java_lang_Character Int))
:extrafuns ((T_java_io_Serializable Int))
:extrafuns ((T_java_lang_Comparable Int))
:extrafuns ((T_java_lang_Number Int))
:extrafuns ((T_java_lang_IllegalArgumentException Int))
:extrafuns ((T_java_lang_RuntimeException Int))
:extrafuns ((T_javafe_util_SubCorrelatedReader Int))
:extrafuns ((T_java_lang_NumberFormatException Int))
:extrafuns ((T_java_lang_Throwable Int))
:extrafuns ((T_javafe_util_Assert Int))
:extrafuns ((T_javafe_genericfile_GenericFile Int))
:extrafuns ((T_java_lang_Integer Int))
:extrafuns ((T_javafe_util_Location Int))
:extrafuns ((DIST_ZERO_1 Int))
:extrafuns ((T__TYPE Int))
:extrafuns ((NULL_23_60_26 Int))
:extrafuns ((STARTFREELOC_4_18_38 Int))
:assumption (and (= (PO_LT T_java_io_IOException T_java_lang_Exception) true_term) (= T_java_io_IOException (asChild T_java_io_IOException T_java_lang_Exception)) (= (PO_LT T_javafe_util_BufferedCorrelatedReader T_javafe_util_CorrelatedReader) true_term) (= T_javafe_util_BufferedCorrelatedReader (asChild T_javafe_util_BufferedCorrelatedReader T_javafe_util_CorrelatedReader)) (= (PO_LT T_java_lang_Character T_java_lang_Object) true_term) (= T_java_lang_Character (asChild T_java_lang_Character T_java_lang_Object)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Character) true_term) (= ?t T_java_lang_Character))) (= (PO_LT T_java_lang_Character T_java_io_Serializable) true_term) (= (PO_LT T_java_lang_Character T_java_lang_Comparable) true_term) (= (PO_LT T_java_lang_Number T_java_lang_Object) true_term) (= T_java_lang_Number (asChild T_java_lang_Number T_java_lang_Object)) (= (PO_LT T_java_lang_Number T_java_io_Serializable) true_term) (= (PO_LT T_javafe_util_CorrelatedReader T_java_lang_Object) true_term) (= T_javafe_util_CorrelatedReader (asChild T_javafe_util_CorrelatedReader T_java_lang_Object)) (= (PO_LT T_java_lang_String T_java_lang_Object) true_term) (= T_java_lang_String (asChild T_java_lang_String T_java_lang_Object)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_String) true_term) (= ?t T_java_lang_String))) (= (PO_LT T_java_lang_String T_java_io_Serializable) true_term) (= (PO_LT T_java_lang_String T_java_lang_Comparable) true_term) (= (PO_LT T_java_lang_IllegalArgumentException T_java_lang_RuntimeException) true_term) (= T_java_lang_IllegalArgumentException (asChild T_java_lang_IllegalArgumentException T_java_lang_RuntimeException)) (= (PO_LT T_javafe_util_SubCorrelatedReader T_javafe_util_BufferedCorrelatedReader) true_term) (= T_javafe_util_SubCorrelatedReader (asChild T_javafe_util_SubCorrelatedReader T_javafe_util_BufferedCorrelatedReader)) (= (PO_LT T_java_lang_RuntimeException T_java_lang_Exception) true_term) (= T_java_lang_RuntimeException (asChild T_java_lang_RuntimeException T_java_lang_Exception)) (= (PO_LT T_java_lang_NumberFormatException T_java_lang_IllegalArgumentException) true_term) (= T_java_lang_NumberFormatException (asChild T_java_lang_NumberFormatException T_java_lang_IllegalArgumentException)) (= (PO_LT T_java_io_Serializable T_java_lang_Object) true_term) (= (PO_LT T_java_lang_Exception T_java_lang_Throwable) true_term) (= T_java_lang_Exception (asChild T_java_lang_Exception T_java_lang_Throwable)) (= (PO_LT T_javafe_util_Assert T_java_lang_Object) true_term) (= T_javafe_util_Assert (asChild T_javafe_util_Assert T_java_lang_Object)) (= (PO_LT T_javafe_genericfile_GenericFile T_java_lang_Object) true_term) (= (PO_LT T_java_lang_Integer T_java_lang_Number) true_term) (= T_java_lang_Integer (asChild T_java_lang_Integer T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Integer) true_term) (= ?t T_java_lang_Integer))) (= (PO_LT T_java_lang_Integer T_java_lang_Comparable) true_term) (= (PO_LT T_java_lang_Throwable T_java_lang_Object) true_term) (= T_java_lang_Throwable (asChild T_java_lang_Throwable T_java_lang_Object)) (= (PO_LT T_java_lang_Throwable T_java_io_Serializable) true_term) (= (PO_LT T_javafe_util_Location T_java_lang_Object) true_term) (= T_javafe_util_Location (asChild T_javafe_util_Location T_java_lang_Object)) (= (PO_LT T_java_lang_Comparable T_java_lang_Object) true_term) (and (= arrayType (+ DIST_ZERO_1 0)) (= T_boolean (+ DIST_ZERO_1 1)) (= T_char (+ DIST_ZERO_1 2)) (= T_byte (+ DIST_ZERO_1 3)) (= T_short (+ DIST_ZERO_1 4)) (= T_int (+ DIST_ZERO_1 5)) (= T_long (+ DIST_ZERO_1 6)) (= T_float (+ DIST_ZERO_1 7)) (= T_double (+ DIST_ZERO_1 8)) (= T__TYPE (+ DIST_ZERO_1 9)) (= T_java_io_IOException (+ DIST_ZERO_1 10)) (= T_javafe_util_BufferedCorrelatedReader (+ DIST_ZERO_1 11)) (= T_java_lang_Character (+ DIST_ZERO_1 12)) (= T_java_lang_Number (+ DIST_ZERO_1 13)) (= T_javafe_util_CorrelatedReader (+ DIST_ZERO_1 14)) (= T_java_lang_String (+ DIST_ZERO_1 15)) (= T_java_lang_IllegalArgumentException (+ DIST_ZERO_1 16)) (= T_javafe_util_SubCorrelatedReader (+ DIST_ZERO_1 17)) (= T_java_lang_RuntimeException (+ DIST_ZERO_1 18)) (= T_java_lang_NumberFormatException (+ DIST_ZERO_1 19)) (= T_java_io_Serializable (+ DIST_ZERO_1 20)) (= T_java_lang_Exception (+ DIST_ZERO_1 21)) (= T_javafe_util_Assert (+ DIST_ZERO_1 22)) (= T_javafe_genericfile_GenericFile (+ DIST_ZERO_1 23)) (= T_java_lang_Integer (+ DIST_ZERO_1 24)) (= T_java_lang_Object (+ DIST_ZERO_1 25)) (= T_java_lang_Throwable (+ DIST_ZERO_1 26)) (= T_javafe_util_Location (+ DIST_ZERO_1 27)) (= T_java_lang_Comparable (+ DIST_ZERO_1 28))) (= true_term (is NULL_23_60_26 T_int)) (= NULL_23_60_26 0) (= true_term (is STARTFREELOC_4_18_38 T_int)) (= STARTFREELOC_4_18_38 1000000))
:extrafuns ((L_92_1 Int))
:extrafuns ((ecReturn Int))
:extrafuns ((ecThrow Int))
:extrafuns ((C_92_1 Int))
:extrafuns ((L_88_1 Int))
:extrafuns ((maxLoc_pre_4_33_16 Int))
:extrafuns ((maxLoc_4_33_16 Int))
:extrafuns ((endBufNdx_pre_4_60_16 Int))
:extrafuns ((endBufNdx_4_60_16 Int))
:extrafuns ((oddSlashLoc_pre_4_91_16 Int))
:extrafuns ((oddSlashLoc_4_91_16 Int))
:extrafuns ((markNdx_pre_4_213_16 Int))
:extrafuns ((markNdx_4_213_16 Int))
:extrafuns ((buf_pre_4_42_36 Int))
:extrafuns ((buf_4_42_36 Int))
:extrafuns ((beforeBufLoc_pre_4_52_16 Int))
:extrafuns ((beforeBufLoc_4_52_16 Int))
:extrafuns ((NULL_pre_23_60_26 Int))
:extrafuns ((STARTFREELOC_pre_4_18_38 Int))
:extrafuns ((minLoc_pre_4_32_16 Int))
:extrafuns ((minLoc_4_32_16 Int))
:extrafuns ((curNdx_pre_4_69_16 Int))
:extrafuns ((curNdx_4_69_16 Int))
:extrafuns ((lastCharNdx_pre_4_82_16 Int))
:extrafuns ((lastCharNdx_4_82_16 Int))
:extrafuns ((file_pre_26_38 Int))
:extrafuns ((file_26_38 Int))
:extrafuns ((marked_pre_5_92_41 Int))
:extrafuns ((marked_5_92_41 Int))
:extrafuns ((elems_pre Int))
:extrafuns ((elems Int))
:extrafuns ((LS Int))
:extrafuns ((alloc_pre Int))
:extrafuns ((this Int))
:extrafuns ((EC_66_13_66_13 Int))
:extrafuns ((RES Int))
:extrafuns ((RES_66_13_66_13 Int))
:extrafuns ((EC Int))
:extrafuns ((XRES Int))
:extrafuns ((XRES_66_13_66_13 Int))
:extrafuns ((RES_1_ Int))
:extrafuns ((EC_1_ Int))
:extrafuns ((XRES_1_ Int))
:extrafuns ((RES_71_11_71_11 Int))
:extrafuns ((EC_71_11_71_11 Int))
:extrafuns ((XRES_71_11_71_11 Int))
:extrafuns ((RES_2_ Int))
:extrafuns ((EC_2_ Int))
:extrafuns ((XRES_2_ Int))
:extrafuns ((lastCharNdx_80_4 Int))
:extrafuns ((tmp0_buf_82_12 Int))
:extrafuns ((tmp1_old_curNdx_82_16 Int))
:extrafuns ((curNdx_82_16 Int))
:extrafuns ((c_82_4 Int))
:extrafuns ((tmp3_84_19 Int))
:extrafuns ((RES_84_36_84_36 Int))
:extrafuns ((EC_84_36_84_36 Int))
:extrafuns ((tmp2_cand_84_8 Int))
:extrafuns ((RES_3_ Int))
:extrafuns ((EC_3_ Int))
:extrafuns ((tmp2_cand_84_16 Int))
:extrafuns ((XRES_3_ Int))
:extrafuns ((XRES_84_36_84_36 Int))
:extrafuns ((RES_86_10_86_10 Int))
:extrafuns ((EC_86_10_86_10 Int))
:extrafuns ((XRES_86_10_86_10 Int))
:extrafuns ((EC_loopold Int))
:extrafuns ((curNdx_loopold_4_69_16 Int))
:extrafuns ((RES_88_1_0_88_8_88_8 Int))
:extrafuns ((EC_88_1_0_88_8_88_8 Int))
:extrafuns ((XRES_88_1_0_88_8_88_8 Int))
:extrafuns ((tmp4_old_curNdx_88_1_0_89_3 Int))
:extrafuns ((curNdx_88_1_0_89_3 Int))
:extrafuns ((EC_88_8 Int))
:extrafuns ((RES_4_ Int))
:extrafuns ((EC_4_ Int))
:extrafuns ((curNdx_4_69_16_1_ Int))
:extrafuns ((XRES_4_ Int))
:extrafuns ((RES_88_1_1_88_8_88_8 Int))
:extrafuns ((EC_88_1_1_88_8_88_8 Int))
:extrafuns ((XRES_88_1_1_88_8_88_8 Int))
:extrafuns ((EC_88_8_1_ Int))
:extrafuns ((RES_5_ Int))
:extrafuns ((EC_5_ Int))
:extrafuns ((curNdx_4_69_16_2_ Int))
:extrafuns ((XRES_5_ Int))
:extrafuns ((tmp5_new_char___91_12 Int))
:extrafuns ((alloc_1_ Int))
:extrafuns ((owner_6_35_28 Int))
:extrafuns ((elems_loopold Int))
:extrafuns ((i_loopold_92_10 Int))
:extrafuns ((EC_loopold_1_ Int))
:extrafuns ((alloc_loopold Int))
:extrafuns ((XRES_loopold Int))
:extrafuns ((RES_92_1_0_93_16_93_16 Int))
:extrafuns ((EC_92_1_0_93_16_93_16 Int))
:extrafuns ((XRES_92_1_0_93_16_93_16 Int))
:extrafuns ((elems_92_1_0 Int))
:extrafuns ((tmp8_92_1_0_94_24 Int))
:extrafuns ((RES_92_1_0_94_17_94_17 Int))
:extrafuns ((EC_92_1_0_94_17_94_17 Int))
:extrafuns ((after_95_11_92_1_0_95_11 Int))
:extrafuns ((RES_92_1_0_95_11_95_11 Int))
:extrafuns ((EC_92_1_0_95_11_95_11 Int))
:extrafuns ((RES_6_ Int))
:extrafuns ((EC_6_ Int))
:extrafuns ((alloc_2_ Int))
:extrafuns ((XRES_6_ Int))
:extrafuns ((RES_93_3 Int))
:extrafuns ((EC_93_3 Int))
:extrafuns ((alloc_93_3 Int))
:extrafuns ((XRES_93_3 Int))
:extrafuns ((RES_7_ Int))
:extrafuns ((EC_7_ Int))
:extrafuns ((alloc_3_ Int))
:extrafuns ((XRES_7_ Int))
:extrafuns ((RES_93_3_1_ Int))
:extrafuns ((EC_93_3_1_ Int))
:extrafuns ((alloc_93_3_1_ Int))
:extrafuns ((XRES_93_3_1_ Int))
:extrafuns ((XRES_92_1_0_94_17_94_17 Int))
:extrafuns ((i_92_1_0_92_20 Int))
:extrafuns ((RES_8_ Int))
:extrafuns ((EC_8_ Int))
:extrafuns ((alloc_4_ Int))
:extrafuns ((XRES_8_ Int))
:extrafuns ((RES_9_ Int))
:extrafuns ((EC_9_ Int))
:extrafuns ((lastCharNdx_4_82_16_1_ Int))
:extrafuns ((lastCharNdx_74_1 Int))
:extrafuns ((RES_10_ Int))
:extrafuns ((EC_10_ Int))
:extrafuns ((curNdx_4_69_16_3_ Int))
:extrafuns ((alloc_5_ Int))
:extrafuns ((lastCharNdx_4_82_16_2_ Int))
:extrafuns ((XRES_9_ Int))
:extrafuns ((EC_11_ Int))
:extrafuns ((curNdx_4_69_16_4_ Int))
:extrafuns ((alloc_6_ Int))
:extrafuns ((XRES_10_ Int))
:extrafuns ((RES_11_ Int))
:extrafuns ((EC_12_ Int))
:extrafuns ((curNdx_4_69_16_5_ Int))
:extrafuns ((alloc_7_ Int))
:extrafuns ((XRES_11_ Int))
:extrafuns ((after_98_23_98_23 Int))
:extrafuns ((RES_98_23_98_23 Int))
:extrafuns ((EC_98_23_98_23 Int))
:extrafuns ((RES_98_13_98_13 Int))
:extrafuns ((EC_98_13_98_13 Int))
:extrafuns ((XRES_98_13_98_13 Int))
:extrafuns ((EC_13_ Int))
:extrafuns ((curNdx_4_69_16_6_ Int))
:extrafuns ((c_82_8 Int))
:extrafuns ((alloc_8_ Int))
:extrafuns ((XRES_12_ Int))
:extrafuns ((RES_101_15_101_15 Int))
:extrafuns ((EC_101_15_101_15 Int))
:extrafuns ((oddSlashLoc_101_1 Int))
:extrafuns ((XRES_101_15_101_15 Int))
:extrafuns ((EC_14_ Int))
:extrafuns ((curNdx_4_69_16_7_ Int))
:extrafuns ((c_82_8_1_ Int))
:extrafuns ((alloc_9_ Int))
:extrafuns ((XRES_13_ Int))
:formula (not (implies (and (distinct L_92_1 ecReturn ecThrow C_92_1 L_88_1)) (implies (and (= maxLoc_pre_4_33_16 maxLoc_4_33_16) (= maxLoc_4_33_16 (asField maxLoc_4_33_16 T_int)) (= endBufNdx_pre_4_60_16 endBufNdx_4_60_16) (= endBufNdx_4_60_16 (asField endBufNdx_4_60_16 T_int)) (= oddSlashLoc_pre_4_91_16 oddSlashLoc_4_91_16) (= oddSlashLoc_4_91_16 (asField oddSlashLoc_4_91_16 T_int)) (= markNdx_pre_4_213_16 markNdx_4_213_16) (= markNdx_4_213_16 (asField markNdx_4_213_16 T_int)) (= buf_pre_4_42_36 buf_4_42_36) (= buf_4_42_36 (asField buf_4_42_36 (array T_byte))) (< (fClosedTime buf_4_42_36) alloc) (= beforeBufLoc_pre_4_52_16 beforeBufLoc_4_52_16) (= beforeBufLoc_4_52_16 (asField beforeBufLoc_4_52_16 T_int)) (= NULL_pre_23_60_26 NULL_23_60_26) (= true_term (is NULL_23_60_26 T_int)) (= STARTFREELOC_pre_4_18_38 STARTFREELOC_4_18_38) (= true_term (is STARTFREELOC_4_18_38 T_int)) (= minLoc_pre_4_32_16 minLoc_4_32_16) (= minLoc_4_32_16 (asField minLoc_4_32_16 T_int)) (= curNdx_pre_4_69_16 curNdx_4_69_16) (= curNdx_4_69_16 (asField curNdx_4_69_16 T_int)) (= lastCharNdx_pre_4_82_16 lastCharNdx_4_82_16) (= lastCharNdx_4_82_16 (asField lastCharNdx_4_82_16 T_int)) (= file_pre_26_38 file_26_38) (= file_26_38 (asField file_26_38 T_javafe_genericfile_GenericFile)) (< (fClosedTime file_26_38) alloc) (forall (?s Int) (implies (not (= ?s null)) (not (= (S_select file_26_38 ?s) null)))) (= marked_pre_5_92_41 marked_5_92_41) (= marked_5_92_41 (asField marked_5_92_41 T_boolean)) (= elems_pre elems) (= elems (asElems elems)) (< (eClosedTime elems) alloc) (= LS (asLockSet LS)) (= alloc_pre alloc)) (not (and (= true_term (is this T_javafe_util_SubCorrelatedReader)) (= true_term (isAllocated this alloc)) (not (= this null)) (forall (?brokenObj Int) (implies (and (= true_term (is ?brokenObj T_javafe_util_BufferedCorrelatedReader)) (not (= ?brokenObj null)) (= true_term (S_select marked_5_92_41 ?brokenObj))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj)) (<= (S_select markNdx_4_213_16 ?brokenObj) (S_select curNdx_4_69_16 ?brokenObj))))) (forall (?brokenObj_1_ Int) (implies (and (= true_term (is ?brokenObj_1_ T_javafe_util_BufferedCorrelatedReader)) (not (= ?brokenObj_1_ null))) (<= (S_select lastCharNdx_4_82_16 ?brokenObj_1_) (S_select curNdx_4_69_16 ?brokenObj_1_)))) (forall (?brokenObj_2_ Int) (implies (and (= true_term (is ?brokenObj_2_ T_javafe_util_BufferedCorrelatedReader)) (not (= ?brokenObj_2_ null))) (<= 0 (S_select lastCharNdx_4_82_16 ?brokenObj_2_)))) (forall (?brokenObj_3_ Int) (implies (and (= true_term (is ?brokenObj_3_ T_javafe_util_BufferedCorrelatedReader)) (not (= ?brokenObj_3_ null))) (<= (S_select curNdx_4_69_16 ?brokenObj_3_) (S_select endBufNdx_4_60_16 ?brokenObj_3_)))) (forall (?brokenObj_4_ Int) (implies (and (= true_term (is ?brokenObj_4_ T_javafe_util_BufferedCorrelatedReader)) (not (= ?brokenObj_4_ null)) (not (= (S_select buf_4_42_36 ?brokenObj_4_) null))) (<= (S_select endBufNdx_4_60_16 ?brokenObj_4_) (arrayLength (S_select buf_4_42_36 ?brokenObj_4_))))) (forall (?brokenObj_5_ Int) (implies (and (= true_term (is ?brokenObj_5_ T_javafe_util_BufferedCorrelatedReader)) (not (= ?brokenObj_5_ null))) (<= 0 (S_select curNdx_4_69_16 ?brokenObj_5_)))) (or (and (or (and (= (S_select buf_4_42_36 this) null) (= true_term true_term) (= EC_66_13_66_13 ecReturn) (not (= EC_66_13_66_13 ecReturn)) (= RES RES_66_13_66_13) (= EC EC_66_13_66_13) (= XRES XRES_66_13_66_13)) (and (not (= (S_select buf_4_42_36 this) null)) (= true_term true_term) (= RES RES_1_) (= EC EC_1_) (= XRES XRES_1_))) (or (and (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (= true_term true_term) (or (not (not (= (S_select buf_4_42_36 this) null))) (and (not (= (S_select buf_4_42_36 this) null)) (or (not (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this))) (and (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (or (not (forall (?brokenObj_6_ Int) (implies (and (= ?brokenObj_6_ this) (= true_term (S_select marked_5_92_41 ?brokenObj_6_))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj_6_)) (<= (S_select markNdx_4_213_16 ?brokenObj_6_) (S_select curNdx_4_69_16 ?brokenObj_6_)))))) (not (<= (S_select lastCharNdx_4_82_16 this) (S_select curNdx_4_69_16 this))) (and (<= (S_select lastCharNdx_4_82_16 this) (S_select curNdx_4_69_16 this)) (or (not (<= 0 (S_select lastCharNdx_4_82_16 this))) (and (<= 0 (S_select lastCharNdx_4_82_16 this)) (or (not (<= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this))) (and (<= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (not (<= 0 (S_select curNdx_4_69_16 this)))))))))))))) (and (or (and (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (= true_term true_term) (not (= (S_select buf_4_42_36 this) null)) (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (<= (S_select lastCharNdx_4_82_16 this) (S_select curNdx_4_69_16 this)) (<= 0 (S_select lastCharNdx_4_82_16 this)) (<= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16 this)) (= true_term (is RES_71_11_71_11 T_boolean)) (implies (= EC_71_11_71_11 ecThrow) (and (not (= XRES_71_11_71_11 null)) (= (PO_LT (typeof XRES_71_11_71_11) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_71_11_71_11 alloc)))) (or (= EC_71_11_71_11 ecReturn) (and (= EC_71_11_71_11 ecThrow) (= (PO_LT (typeof XRES_71_11_71_11) T_java_io_IOException) true_term))) (implies (and (= EC_71_11_71_11 ecReturn) (= true_term RES_71_11_71_11)) (< (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_71_11_71_11 ecReturn) (= true_term RES_71_11_71_11) (= true_term true_term) (= RES_2_ RES_71_11_71_11) (= EC_2_ EC_71_11_71_11) (= XRES_2_ XRES_71_11_71_11)) (and (not (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= RES_2_ RES) (= EC_2_ EC) (= XRES_2_ XRES))) (= lastCharNdx_80_4 (S_store lastCharNdx_4_82_16 this (S_select curNdx_4_69_16 this))) (= tmp0_buf_82_12 (S_select buf_4_42_36 this)) (= tmp1_old_curNdx_82_16 (S_select curNdx_4_69_16 this)) (= curNdx_82_16 (S_store curNdx_4_69_16 this (+ tmp1_old_curNdx_82_16 1))) (or (not (not (= tmp0_buf_82_12 null))) (and (not (= tmp0_buf_82_12 null)) (or (not (<= 0 tmp1_old_curNdx_82_16)) (and (<= 0 tmp1_old_curNdx_82_16) (or (not (< tmp1_old_curNdx_82_16 (arrayLength tmp0_buf_82_12))) (and (< tmp1_old_curNdx_82_16 (arrayLength tmp0_buf_82_12)) (= c_82_4 (S_select (S_select elems tmp0_buf_82_12) tmp1_old_curNdx_82_16)) (or (and (= c_82_4 92) (= tmp3_84_19 (+ (S_select oddSlashLoc_4_91_16 this) 1)) (or (not (forall (?brokenObj_7_ Int) (implies (and (= ?brokenObj_7_ this) (= true_term (S_select marked_5_92_41 ?brokenObj_7_))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj_7_)) (<= (S_select markNdx_4_213_16 ?brokenObj_7_) (S_select curNdx_82_16 ?brokenObj_7_)))))) (not (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this))) (and (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (or (not (<= 0 (S_select lastCharNdx_80_4 this))) (and (<= 0 (S_select lastCharNdx_80_4 this)) (or (not (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (and (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (not (<= 0 (S_select curNdx_82_16 this)))))))))) (and (or (and (= c_82_4 92) (= tmp3_84_19 (+ (S_select oddSlashLoc_4_91_16 this) 1)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_84_36_84_36 T_int)) (= EC_84_36_84_36 ecReturn) (implies (= EC_84_36_84_36 ecReturn) (not (= RES_84_36_84_36 NULL_23_60_26))) (= tmp2_cand_84_8 (integralNE tmp3_84_19 RES_84_36_84_36)) (= RES_3_ RES_84_36_84_36) (= EC_3_ EC_84_36_84_36) (= tmp2_cand_84_16 tmp2_cand_84_8) (= XRES_3_ XRES_84_36_84_36)) (and (not (= c_82_4 92)) (= true_term true_term) (= RES_3_ RES_2_) (= EC_3_ EC_2_) (= tmp2_cand_84_16 false_term) (= XRES_3_ XRES_2_))) (= true_term tmp2_cand_84_16) (= true_term true_term) (or (not (not (= (S_select buf_4_42_36 this) null))) (and (not (= (S_select buf_4_42_36 this) null)) (or (not (forall (?brokenObj_8_ Int) (implies (and (= ?brokenObj_8_ this) (= true_term (S_select marked_5_92_41 ?brokenObj_8_))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj_8_)) (<= (S_select markNdx_4_213_16 ?brokenObj_8_) (S_select curNdx_82_16 ?brokenObj_8_)))))) (not (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this))) (and (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (or (not (<= 0 (S_select lastCharNdx_80_4 this))) (and (<= 0 (S_select lastCharNdx_80_4 this)) (or (not (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (and (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (not (<= 0 (S_select curNdx_82_16 this)))))))))) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_86_10_86_10 T_int)) (implies (= EC_86_10_86_10 ecThrow) (and (not (= XRES_86_10_86_10 null)) (= (PO_LT (typeof XRES_86_10_86_10) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_86_10_86_10 alloc)))) (or (= EC_86_10_86_10 ecReturn) (and (= EC_86_10_86_10 ecThrow) (= (PO_LT (typeof XRES_86_10_86_10) T_java_io_IOException) true_term))) (implies (and (= EC_86_10_86_10 ecReturn) (<= 0 RES_86_10_86_10)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_86_10_86_10 ecReturn) (or (and (= RES_86_10_86_10 117) (= true_term true_term) (or (and (= EC_86_10_86_10 EC_loopold) (= curNdx_82_16 curNdx_loopold_4_69_16) (or (and (= true_term true_term) (or (not (not (= (S_select buf_4_42_36 this) null))) (and (not (= (S_select buf_4_42_36 this) null)) (or (not (forall (?brokenObj_9_ Int) (implies (and (= ?brokenObj_9_ this) (= true_term (S_select marked_5_92_41 ?brokenObj_9_))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj_9_)) (<= (S_select markNdx_4_213_16 ?brokenObj_9_) (S_select curNdx_82_16 ?brokenObj_9_)))))) (not (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this))) (and (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (or (not (<= 0 (S_select lastCharNdx_80_4 this))) (and (<= 0 (S_select lastCharNdx_80_4 this)) (or (not (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (and (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (not (<= 0 (S_select curNdx_82_16 this)))))))))))) (and (= true_term true_term) (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (= RES_88_1_0_88_8_88_8 117) (= tmp4_old_curNdx_88_1_0_89_3 (S_select curNdx_82_16 this)) (= curNdx_88_1_0_89_3 (S_store curNdx_82_16 this (+ tmp4_old_curNdx_88_1_0_89_3 1))) (= true_term true_term) (or (not (not (= (S_select buf_4_42_36 this) null))) (and (not (= (S_select buf_4_42_36 this) null)) (or (not (forall (?brokenObj_9_ Int) (implies (and (= ?brokenObj_9_ this) (= true_term (S_select marked_5_92_41 ?brokenObj_9_))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj_9_)) (<= (S_select markNdx_4_213_16 ?brokenObj_9_) (S_select curNdx_88_1_0_89_3 ?brokenObj_9_)))))) (not (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this))) (and (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (or (not (<= 0 (S_select lastCharNdx_80_4 this))) (and (<= 0 (S_select lastCharNdx_80_4 this)) (or (not (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (and (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (not (<= 0 (S_select curNdx_88_1_0_89_3 this)))))))))))))) (and (= EC_86_10_86_10 EC_loopold) (= curNdx_82_16 curNdx_loopold_4_69_16) (or (and (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_88_1_0_88_8_88_8 ecThrow) (= EC_88_8 EC_88_1_0_88_8_88_8)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (not (= RES_88_1_0_88_8_88_8 117)) (= EC_88_8 L_88_1))) (= RES_4_ RES_88_1_0_88_8_88_8) (= EC_4_ EC_88_8) (= curNdx_4_69_16_1_ curNdx_82_16) (= XRES_4_ XRES_88_1_0_88_8_88_8)) (and (= true_term true_term) (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (= RES_88_1_0_88_8_88_8 117) (= tmp4_old_curNdx_88_1_0_89_3 (S_select curNdx_82_16 this)) (= curNdx_88_1_0_89_3 (S_store curNdx_82_16 this (+ tmp4_old_curNdx_88_1_0_89_3 1))) (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_88_1_0_89_3 this)) (= true_term (is RES_88_1_1_88_8_88_8 T_int)) (implies (= EC_88_1_1_88_8_88_8 ecThrow) (and (not (= XRES_88_1_1_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_1_88_8_88_8 alloc)))) (or (= EC_88_1_1_88_8_88_8 ecReturn) (and (= EC_88_1_1_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_1_88_8_88_8 ecReturn) (<= 0 RES_88_1_1_88_8_88_8)) (< (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_88_1_1_88_8_88_8 ecThrow) (= EC_88_8_1_ EC_88_1_1_88_8_88_8)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_88_1_0_89_3 this)) (= true_term (is RES_88_1_1_88_8_88_8 T_int)) (implies (= EC_88_1_1_88_8_88_8 ecThrow) (and (not (= XRES_88_1_1_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_1_88_8_88_8 alloc)))) (or (= EC_88_1_1_88_8_88_8 ecReturn) (and (= EC_88_1_1_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_1_88_8_88_8 ecReturn) (<= 0 RES_88_1_1_88_8_88_8)) (< (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_1_88_8_88_8 ecReturn) (not (= RES_88_1_1_88_8_88_8 117)) (= EC_88_8_1_ L_88_1))) (= RES_4_ RES_88_1_1_88_8_88_8) (= EC_4_ EC_88_8_1_) (= curNdx_4_69_16_1_ curNdx_88_1_0_89_3) (= XRES_4_ XRES_88_1_1_88_8_88_8))) (= EC_4_ L_88_1) (= RES_5_ RES_4_) (= EC_5_ EC_4_) (= curNdx_4_69_16_2_ curNdx_4_69_16_1_) (= XRES_5_ XRES_4_) (or (not (<= 0 4)) (and (<= 0 4) (= true_term (arrayFresh tmp5_new_char___91_12 alloc alloc_1_ elems (arrayShapeOne 4) (array T_char) 0)) (forall (?o Int) (implies (and (not (= true_term (isAllocated ?o alloc))) (= true_term (isAllocated ?o alloc_1_))) (= true_term (isNewArray ?o)))) (forall (?o_1_ Int) (implies (and (not (= true_term (isAllocated ?o_1_ alloc))) (= true_term (isAllocated ?o_1_ alloc_1_))) (= (S_select owner_6_35_28 tmp5_new_char___91_12) null))) (or (and (= elems elems_loopold) (= 0 i_loopold_92_10) (= EC_5_ EC_loopold_1_) (= alloc_1_ alloc_loopold) (= XRES_5_ XRES_loopold) (= true_term true_term) (< 0 4) (or (not (not (= (S_select buf_4_42_36 this) null))) (and (not (= (S_select buf_4_42_36 this) null)) (or (not (forall (?brokenObj_10_ Int) (implies (and (= ?brokenObj_10_ this) (= true_term (S_select marked_5_92_41 ?brokenObj_10_))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj_10_)) (<= (S_select markNdx_4_213_16 ?brokenObj_10_) (S_select curNdx_4_69_16_2_ ?brokenObj_10_)))))) (not (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this))) (and (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (or (not (<= 0 (S_select lastCharNdx_80_4 this))) (and (<= 0 (S_select lastCharNdx_80_4 this)) (or (not (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this))) (and (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (not (<= 0 (S_select curNdx_4_69_16_2_ this)))))))))) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (or (not (not (= tmp5_new_char___91_12 null))) (and (not (= tmp5_new_char___91_12 null)) (or (not (<= 0 0)) (and (<= 0 0) (or (not (< 0 (arrayLength tmp5_new_char___91_12))) (and (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (or (not (not (= tmp5_new_char___91_12 null))) (and (not (= tmp5_new_char___91_12 null)) (or (not (<= 0 0)) (and (<= 0 0) (or (not (< 0 (arrayLength tmp5_new_char___91_12))) (and (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (not (= RES_92_1_0_95_11_95_11 null)))))))))))))))))) (and (= elems elems_loopold) (= 0 i_loopold_92_10) (= EC_5_ EC_loopold_1_) (= alloc_1_ alloc_loopold) (= XRES_5_ XRES_loopold) (or (and (= true_term true_term) (or (and (not (< 0 4)) (= RES_6_ RES_5_) (= EC_6_ L_92_1) (= alloc_2_ alloc_1_) (= XRES_6_ XRES_5_)) (and (< 0 4) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= true_term true_term) (= EC_92_1_0_93_16_93_16 ecThrow) (= RES_93_3 RES_92_1_0_93_16_93_16) (= EC_93_3 EC_92_1_0_93_16_93_16) (= alloc_93_3 alloc_1_) (= XRES_93_3 XRES_92_1_0_93_16_93_16)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (= RES_92_1_0_95_11_95_11 null)) (= true_term true_term) (= RES_93_3 RES_92_1_0_95_11_95_11) (= EC_93_3 ecThrow) (= alloc_93_3 after_95_11_92_1_0_95_11) (= XRES_93_3 RES_92_1_0_95_11_95_11))) (not (= EC_93_3 C_92_1)) (= RES_6_ RES_93_3) (= EC_6_ EC_93_3) (= alloc_2_ alloc_93_3) (= XRES_6_ XRES_93_3))) (= RES_7_ RES_6_) (= EC_7_ EC_6_) (= alloc_3_ alloc_2_) (= XRES_7_ XRES_6_)) (and (= true_term true_term) (< 0 4) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (not (= RES_92_1_0_94_17_94_17 (- 0 1))) (= true_term true_term) (= RES_93_3_1_ RES_92_1_0_94_17_94_17) (= EC_93_3_1_ EC_92_1_0_94_17_94_17) (= alloc_93_3_1_ alloc_1_) (= XRES_93_3_1_ XRES_92_1_0_94_17_94_17)) (and (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= true_term true_term) (= EC_92_1_0_93_16_93_16 ecThrow) (= RES_93_3 RES_92_1_0_93_16_93_16) (= EC_93_3 EC_92_1_0_93_16_93_16) (= alloc_93_3 alloc_1_) (= XRES_93_3 XRES_92_1_0_93_16_93_16)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (= RES_92_1_0_95_11_95_11 null)) (= true_term true_term) (= RES_93_3 RES_92_1_0_95_11_95_11) (= EC_93_3 ecThrow) (= alloc_93_3 after_95_11_92_1_0_95_11) (= XRES_93_3 RES_92_1_0_95_11_95_11))) (= EC_93_3 C_92_1) (= RES_93_3_1_ RES_93_3) (= EC_93_3_1_ EC_93_3) (= alloc_93_3_1_ alloc_93_3) (= XRES_93_3_1_ XRES_93_3))) (= i_92_1_0_92_20 (+ 0 1)) (= true_term true_term) (not (< i_92_1_0_92_20 4)) (= RES_7_ RES_93_3_1_) (= EC_7_ L_92_1) (= alloc_3_ alloc_93_3_1_) (= XRES_7_ XRES_93_3_1_))) (= EC_7_ L_92_1) (= RES_8_ RES_7_) (= EC_8_ EC_7_) (= alloc_4_ alloc_3_) (= XRES_8_ XRES_7_) (not (not (= tmp5_new_char___91_12 null)))))))))) (and (not (= RES_86_10_86_10 117)) (= true_term true_term) (or (not (forall (?brokenObj_11_ Int) (implies (and (= ?brokenObj_11_ this) (= true_term (S_select marked_5_92_41 ?brokenObj_11_))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj_11_)) (<= (S_select markNdx_4_213_16 ?brokenObj_11_) (S_select curNdx_82_16 ?brokenObj_11_)))))) (not (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this))) (and (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (or (not (<= 0 (S_select lastCharNdx_80_4 this))) (and (<= 0 (S_select lastCharNdx_80_4 this)) (or (not (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (and (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (not (<= 0 (S_select curNdx_82_16 this)))))))))))))))))))))))) (and (or (and (= (S_select buf_4_42_36 this) null) (= true_term true_term) (= EC_66_13_66_13 ecReturn) (not (= EC_66_13_66_13 ecReturn)) (= RES RES_66_13_66_13) (= EC EC_66_13_66_13) (= XRES XRES_66_13_66_13)) (and (not (= (S_select buf_4_42_36 this) null)) (= true_term true_term) (= RES RES_1_) (= EC EC_1_) (= XRES XRES_1_))) (or (and (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (<= (S_select lastCharNdx_4_82_16 this) (S_select curNdx_4_69_16 this)) (<= 0 (S_select lastCharNdx_4_82_16 this)) (<= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16 this)) (= true_term (is RES_71_11_71_11 T_boolean)) (implies (= EC_71_11_71_11 ecThrow) (and (not (= XRES_71_11_71_11 null)) (= (PO_LT (typeof XRES_71_11_71_11) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_71_11_71_11 alloc)))) (or (= EC_71_11_71_11 ecReturn) (and (= EC_71_11_71_11 ecThrow) (= (PO_LT (typeof XRES_71_11_71_11) T_java_io_IOException) true_term))) (implies (and (= EC_71_11_71_11 ecReturn) (= true_term RES_71_11_71_11)) (< (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_71_11_71_11 ecThrow) (= RES_9_ RES_71_11_71_11) (= EC_9_ EC_71_11_71_11) (= lastCharNdx_4_82_16_1_ lastCharNdx_4_82_16)) (and (not (= (S_select buf_4_42_36 this) null)) (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (<= (S_select lastCharNdx_4_82_16 this) (S_select curNdx_4_69_16 this)) (<= 0 (S_select lastCharNdx_4_82_16 this)) (<= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16 this)) (= true_term (is RES_71_11_71_11 T_boolean)) (implies (= EC_71_11_71_11 ecThrow) (and (not (= XRES_71_11_71_11 null)) (= (PO_LT (typeof XRES_71_11_71_11) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_71_11_71_11 alloc)))) (or (= EC_71_11_71_11 ecReturn) (and (= EC_71_11_71_11 ecThrow) (= (PO_LT (typeof XRES_71_11_71_11) T_java_io_IOException) true_term))) (implies (and (= EC_71_11_71_11 ecReturn) (= true_term RES_71_11_71_11)) (< (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_71_11_71_11 ecReturn) (not (= true_term RES_71_11_71_11)) (= true_term true_term) (= lastCharNdx_74_1 (S_store lastCharNdx_4_82_16 this (S_select curNdx_4_69_16 this))) (= RES_10_ (- 0 1)) (= true_term true_term) (= RES_9_ RES_10_) (= EC_9_ ecReturn) (= lastCharNdx_4_82_16_1_ lastCharNdx_74_1))) (= EC_10_ EC_9_) (= curNdx_4_69_16_3_ curNdx_4_69_16) (= alloc_5_ alloc) (= lastCharNdx_4_82_16_2_ lastCharNdx_4_82_16_1_) (= XRES_9_ XRES_71_11_71_11)) (and (or (and (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (= true_term true_term) (not (= (S_select buf_4_42_36 this) null)) (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (<= (S_select lastCharNdx_4_82_16 this) (S_select curNdx_4_69_16 this)) (<= 0 (S_select lastCharNdx_4_82_16 this)) (<= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16 this)) (= true_term (is RES_71_11_71_11 T_boolean)) (implies (= EC_71_11_71_11 ecThrow) (and (not (= XRES_71_11_71_11 null)) (= (PO_LT (typeof XRES_71_11_71_11) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_71_11_71_11 alloc)))) (or (= EC_71_11_71_11 ecReturn) (and (= EC_71_11_71_11 ecThrow) (= (PO_LT (typeof XRES_71_11_71_11) T_java_io_IOException) true_term))) (implies (and (= EC_71_11_71_11 ecReturn) (= true_term RES_71_11_71_11)) (< (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_71_11_71_11 ecReturn) (= true_term RES_71_11_71_11) (= true_term true_term) (= RES_2_ RES_71_11_71_11) (= EC_2_ EC_71_11_71_11) (= XRES_2_ XRES_71_11_71_11)) (and (not (= (S_select curNdx_4_69_16 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= RES_2_ RES) (= EC_2_ EC) (= XRES_2_ XRES))) (= lastCharNdx_80_4 (S_store lastCharNdx_4_82_16 this (S_select curNdx_4_69_16 this))) (= tmp0_buf_82_12 (S_select buf_4_42_36 this)) (= tmp1_old_curNdx_82_16 (S_select curNdx_4_69_16 this)) (= curNdx_82_16 (S_store curNdx_4_69_16 this (+ tmp1_old_curNdx_82_16 1))) (not (= tmp0_buf_82_12 null)) (<= 0 tmp1_old_curNdx_82_16) (< tmp1_old_curNdx_82_16 (arrayLength tmp0_buf_82_12)) (= c_82_4 (S_select (S_select elems tmp0_buf_82_12) tmp1_old_curNdx_82_16)) (or (and (= c_82_4 92) (= tmp3_84_19 (+ (S_select oddSlashLoc_4_91_16 this) 1)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_84_36_84_36 T_int)) (= EC_84_36_84_36 ecReturn) (implies (= EC_84_36_84_36 ecReturn) (not (= RES_84_36_84_36 NULL_23_60_26))) (= tmp2_cand_84_8 (integralNE tmp3_84_19 RES_84_36_84_36)) (= RES_3_ RES_84_36_84_36) (= EC_3_ EC_84_36_84_36) (= tmp2_cand_84_16 tmp2_cand_84_8) (= XRES_3_ XRES_84_36_84_36)) (and (not (= c_82_4 92)) (= true_term true_term) (= RES_3_ RES_2_) (= EC_3_ EC_2_) (= tmp2_cand_84_16 false_term) (= XRES_3_ XRES_2_))) (or (and (= true_term tmp2_cand_84_16) (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_86_10_86_10 T_int)) (implies (= EC_86_10_86_10 ecThrow) (and (not (= XRES_86_10_86_10 null)) (= (PO_LT (typeof XRES_86_10_86_10) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_86_10_86_10 alloc)))) (or (= EC_86_10_86_10 ecReturn) (and (= EC_86_10_86_10 ecThrow) (= (PO_LT (typeof XRES_86_10_86_10) T_java_io_IOException) true_term))) (implies (and (= EC_86_10_86_10 ecReturn) (<= 0 RES_86_10_86_10)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_86_10_86_10 ecThrow) (= EC_11_ EC_86_10_86_10) (= curNdx_4_69_16_4_ curNdx_82_16) (= alloc_6_ alloc) (= XRES_10_ XRES_86_10_86_10)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_86_10_86_10 T_int)) (implies (= EC_86_10_86_10 ecThrow) (and (not (= XRES_86_10_86_10 null)) (= (PO_LT (typeof XRES_86_10_86_10) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_86_10_86_10 alloc)))) (or (= EC_86_10_86_10 ecReturn) (and (= EC_86_10_86_10 ecThrow) (= (PO_LT (typeof XRES_86_10_86_10) T_java_io_IOException) true_term))) (implies (and (= EC_86_10_86_10 ecReturn) (<= 0 RES_86_10_86_10)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_86_10_86_10 ecReturn) (= RES_86_10_86_10 117) (= true_term true_term) (or (and (= EC_86_10_86_10 EC_loopold) (= curNdx_82_16 curNdx_loopold_4_69_16) (or (and (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_88_1_0_88_8_88_8 ecThrow) (= EC_88_8 EC_88_1_0_88_8_88_8)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (not (= RES_88_1_0_88_8_88_8 117)) (= EC_88_8 L_88_1))) (= RES_4_ RES_88_1_0_88_8_88_8) (= EC_4_ EC_88_8) (= curNdx_4_69_16_1_ curNdx_82_16) (= XRES_4_ XRES_88_1_0_88_8_88_8)) (and (= true_term true_term) (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (= RES_88_1_0_88_8_88_8 117) (= tmp4_old_curNdx_88_1_0_89_3 (S_select curNdx_82_16 this)) (= curNdx_88_1_0_89_3 (S_store curNdx_82_16 this (+ tmp4_old_curNdx_88_1_0_89_3 1))) (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_88_1_0_89_3 this)) (= true_term (is RES_88_1_1_88_8_88_8 T_int)) (implies (= EC_88_1_1_88_8_88_8 ecThrow) (and (not (= XRES_88_1_1_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_1_88_8_88_8 alloc)))) (or (= EC_88_1_1_88_8_88_8 ecReturn) (and (= EC_88_1_1_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_1_88_8_88_8 ecReturn) (<= 0 RES_88_1_1_88_8_88_8)) (< (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_88_1_1_88_8_88_8 ecThrow) (= EC_88_8_1_ EC_88_1_1_88_8_88_8)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_88_1_0_89_3 this)) (= true_term (is RES_88_1_1_88_8_88_8 T_int)) (implies (= EC_88_1_1_88_8_88_8 ecThrow) (and (not (= XRES_88_1_1_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_1_88_8_88_8 alloc)))) (or (= EC_88_1_1_88_8_88_8 ecReturn) (and (= EC_88_1_1_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_1_88_8_88_8 ecReturn) (<= 0 RES_88_1_1_88_8_88_8)) (< (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_1_88_8_88_8 ecReturn) (not (= RES_88_1_1_88_8_88_8 117)) (= EC_88_8_1_ L_88_1))) (= RES_4_ RES_88_1_1_88_8_88_8) (= EC_4_ EC_88_8_1_) (= curNdx_4_69_16_1_ curNdx_88_1_0_89_3) (= XRES_4_ XRES_88_1_1_88_8_88_8))) (not (= EC_4_ L_88_1)) (= RES_11_ RES_4_) (= EC_12_ EC_4_) (= curNdx_4_69_16_5_ curNdx_4_69_16_1_) (= alloc_7_ alloc) (= XRES_11_ XRES_4_)) (and (= EC_86_10_86_10 EC_loopold) (= curNdx_82_16 curNdx_loopold_4_69_16) (or (and (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_88_1_0_88_8_88_8 ecThrow) (= EC_88_8 EC_88_1_0_88_8_88_8)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (not (= RES_88_1_0_88_8_88_8 117)) (= EC_88_8 L_88_1))) (= RES_4_ RES_88_1_0_88_8_88_8) (= EC_4_ EC_88_8) (= curNdx_4_69_16_1_ curNdx_82_16) (= XRES_4_ XRES_88_1_0_88_8_88_8)) (and (= true_term true_term) (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (= RES_88_1_0_88_8_88_8 117) (= tmp4_old_curNdx_88_1_0_89_3 (S_select curNdx_82_16 this)) (= curNdx_88_1_0_89_3 (S_store curNdx_82_16 this (+ tmp4_old_curNdx_88_1_0_89_3 1))) (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_88_1_0_89_3 this)) (= true_term (is RES_88_1_1_88_8_88_8 T_int)) (implies (= EC_88_1_1_88_8_88_8 ecThrow) (and (not (= XRES_88_1_1_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_1_88_8_88_8 alloc)))) (or (= EC_88_1_1_88_8_88_8 ecReturn) (and (= EC_88_1_1_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_1_88_8_88_8 ecReturn) (<= 0 RES_88_1_1_88_8_88_8)) (< (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_88_1_1_88_8_88_8 ecThrow) (= EC_88_8_1_ EC_88_1_1_88_8_88_8)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_88_1_0_89_3 this)) (= true_term (is RES_88_1_1_88_8_88_8 T_int)) (implies (= EC_88_1_1_88_8_88_8 ecThrow) (and (not (= XRES_88_1_1_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_1_88_8_88_8 alloc)))) (or (= EC_88_1_1_88_8_88_8 ecReturn) (and (= EC_88_1_1_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_1_88_8_88_8 ecReturn) (<= 0 RES_88_1_1_88_8_88_8)) (< (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_1_88_8_88_8 ecReturn) (not (= RES_88_1_1_88_8_88_8 117)) (= EC_88_8_1_ L_88_1))) (= RES_4_ RES_88_1_1_88_8_88_8) (= EC_4_ EC_88_8_1_) (= curNdx_4_69_16_1_ curNdx_88_1_0_89_3) (= XRES_4_ XRES_88_1_1_88_8_88_8))) (= EC_4_ L_88_1) (= RES_5_ RES_4_) (= EC_5_ EC_4_) (= curNdx_4_69_16_2_ curNdx_4_69_16_1_) (= XRES_5_ XRES_4_) (<= 0 4) (= true_term (arrayFresh tmp5_new_char___91_12 alloc alloc_1_ elems (arrayShapeOne 4) (array T_char) 0)) (forall (?o Int) (implies (and (not (= true_term (isAllocated ?o alloc))) (= true_term (isAllocated ?o alloc_1_))) (= true_term (isNewArray ?o)))) (forall (?o_1_ Int) (implies (and (not (= true_term (isAllocated ?o_1_ alloc))) (= true_term (isAllocated ?o_1_ alloc_1_))) (= (S_select owner_6_35_28 tmp5_new_char___91_12) null))) (or (and (= elems elems_loopold) (= 0 i_loopold_92_10) (= EC_5_ EC_loopold_1_) (= alloc_1_ alloc_loopold) (= XRES_5_ XRES_loopold) (or (and (= true_term true_term) (or (and (not (< 0 4)) (= RES_6_ RES_5_) (= EC_6_ L_92_1) (= alloc_2_ alloc_1_) (= XRES_6_ XRES_5_)) (and (< 0 4) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= true_term true_term) (= EC_92_1_0_93_16_93_16 ecThrow) (= RES_93_3 RES_92_1_0_93_16_93_16) (= EC_93_3 EC_92_1_0_93_16_93_16) (= alloc_93_3 alloc_1_) (= XRES_93_3 XRES_92_1_0_93_16_93_16)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (= RES_92_1_0_95_11_95_11 null)) (= true_term true_term) (= RES_93_3 RES_92_1_0_95_11_95_11) (= EC_93_3 ecThrow) (= alloc_93_3 after_95_11_92_1_0_95_11) (= XRES_93_3 RES_92_1_0_95_11_95_11))) (not (= EC_93_3 C_92_1)) (= RES_6_ RES_93_3) (= EC_6_ EC_93_3) (= alloc_2_ alloc_93_3) (= XRES_6_ XRES_93_3))) (= RES_7_ RES_6_) (= EC_7_ EC_6_) (= alloc_3_ alloc_2_) (= XRES_7_ XRES_6_)) (and (= true_term true_term) (< 0 4) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (not (= RES_92_1_0_94_17_94_17 (- 0 1))) (= true_term true_term) (= RES_93_3_1_ RES_92_1_0_94_17_94_17) (= EC_93_3_1_ EC_92_1_0_94_17_94_17) (= alloc_93_3_1_ alloc_1_) (= XRES_93_3_1_ XRES_92_1_0_94_17_94_17)) (and (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= true_term true_term) (= EC_92_1_0_93_16_93_16 ecThrow) (= RES_93_3 RES_92_1_0_93_16_93_16) (= EC_93_3 EC_92_1_0_93_16_93_16) (= alloc_93_3 alloc_1_) (= XRES_93_3 XRES_92_1_0_93_16_93_16)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (= RES_92_1_0_95_11_95_11 null)) (= true_term true_term) (= RES_93_3 RES_92_1_0_95_11_95_11) (= EC_93_3 ecThrow) (= alloc_93_3 after_95_11_92_1_0_95_11) (= XRES_93_3 RES_92_1_0_95_11_95_11))) (= EC_93_3 C_92_1) (= RES_93_3_1_ RES_93_3) (= EC_93_3_1_ EC_93_3) (= alloc_93_3_1_ alloc_93_3) (= XRES_93_3_1_ XRES_93_3))) (= i_92_1_0_92_20 (+ 0 1)) (= true_term true_term) (not (< i_92_1_0_92_20 4)) (= RES_7_ RES_93_3_1_) (= EC_7_ L_92_1) (= alloc_3_ alloc_93_3_1_) (= XRES_7_ XRES_93_3_1_))) (not (= EC_7_ L_92_1)) (= RES_11_ RES_7_) (= EC_12_ EC_7_) (= curNdx_4_69_16_5_ curNdx_4_69_16_2_) (= alloc_7_ alloc_3_) (= XRES_11_ XRES_7_)) (and (= elems elems_loopold) (= 0 i_loopold_92_10) (= EC_5_ EC_loopold_1_) (= alloc_1_ alloc_loopold) (= XRES_5_ XRES_loopold) (or (and (= true_term true_term) (or (and (not (< 0 4)) (= RES_6_ RES_5_) (= EC_6_ L_92_1) (= alloc_2_ alloc_1_) (= XRES_6_ XRES_5_)) (and (< 0 4) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= true_term true_term) (= EC_92_1_0_93_16_93_16 ecThrow) (= RES_93_3 RES_92_1_0_93_16_93_16) (= EC_93_3 EC_92_1_0_93_16_93_16) (= alloc_93_3 alloc_1_) (= XRES_93_3 XRES_92_1_0_93_16_93_16)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (= RES_92_1_0_95_11_95_11 null)) (= true_term true_term) (= RES_93_3 RES_92_1_0_95_11_95_11) (= EC_93_3 ecThrow) (= alloc_93_3 after_95_11_92_1_0_95_11) (= XRES_93_3 RES_92_1_0_95_11_95_11))) (not (= EC_93_3 C_92_1)) (= RES_6_ RES_93_3) (= EC_6_ EC_93_3) (= alloc_2_ alloc_93_3) (= XRES_6_ XRES_93_3))) (= RES_7_ RES_6_) (= EC_7_ EC_6_) (= alloc_3_ alloc_2_) (= XRES_7_ XRES_6_)) (and (= true_term true_term) (< 0 4) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (not (= RES_92_1_0_94_17_94_17 (- 0 1))) (= true_term true_term) (= RES_93_3_1_ RES_92_1_0_94_17_94_17) (= EC_93_3_1_ EC_92_1_0_94_17_94_17) (= alloc_93_3_1_ alloc_1_) (= XRES_93_3_1_ XRES_92_1_0_94_17_94_17)) (and (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= true_term true_term) (= EC_92_1_0_93_16_93_16 ecThrow) (= RES_93_3 RES_92_1_0_93_16_93_16) (= EC_93_3 EC_92_1_0_93_16_93_16) (= alloc_93_3 alloc_1_) (= XRES_93_3 XRES_92_1_0_93_16_93_16)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (= RES_92_1_0_95_11_95_11 null)) (= true_term true_term) (= RES_93_3 RES_92_1_0_95_11_95_11) (= EC_93_3 ecThrow) (= alloc_93_3 after_95_11_92_1_0_95_11) (= XRES_93_3 RES_92_1_0_95_11_95_11))) (= EC_93_3 C_92_1) (= RES_93_3_1_ RES_93_3) (= EC_93_3_1_ EC_93_3) (= alloc_93_3_1_ alloc_93_3) (= XRES_93_3_1_ XRES_93_3))) (= i_92_1_0_92_20 (+ 0 1)) (= true_term true_term) (not (< i_92_1_0_92_20 4)) (= RES_7_ RES_93_3_1_) (= EC_7_ L_92_1) (= alloc_3_ alloc_93_3_1_) (= XRES_7_ XRES_93_3_1_))) (= EC_7_ L_92_1) (= RES_8_ RES_7_) (= EC_8_ EC_7_) (= alloc_4_ alloc_3_) (= XRES_8_ XRES_7_) (not (= tmp5_new_char___91_12 null)) (< alloc_4_ after_98_23_98_23) (not (= RES_98_23_98_23 null)) (not (= true_term (isAllocated RES_98_23_98_23 alloc_4_))) (= true_term (is RES_98_23_98_23 T_java_lang_String)) (= true_term (isAllocated RES_98_23_98_23 after_98_23_98_23)) (= EC_98_23_98_23 ecReturn) (= (S_select owner_6_35_28 RES_98_23_98_23) null) (= (typeof RES_98_23_98_23) T_java_lang_String) (= true_term (is RES_98_13_98_13 T_int)) (implies (= EC_98_13_98_13 ecThrow) (and (not (= XRES_98_13_98_13 null)) (= (PO_LT (typeof XRES_98_13_98_13) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_98_13_98_13 after_98_23_98_23)))) (or (= EC_98_13_98_13 ecReturn) (and (= EC_98_13_98_13 ecThrow) (= (PO_LT (typeof XRES_98_13_98_13) T_java_lang_NumberFormatException) true_term))) (= true_term true_term) (= EC_98_13_98_13 ecThrow) (= RES_11_ RES_98_13_98_13) (= EC_12_ EC_98_13_98_13) (= curNdx_4_69_16_5_ curNdx_4_69_16_2_) (= alloc_7_ after_98_23_98_23) (= XRES_11_ XRES_98_13_98_13))))) (= EC_11_ EC_12_) (= curNdx_4_69_16_4_ curNdx_4_69_16_5_) (= alloc_6_ alloc_7_) (= XRES_10_ XRES_11_))) (= EC_10_ EC_11_) (= curNdx_4_69_16_3_ curNdx_4_69_16_4_) (= alloc_5_ alloc_6_) (= lastCharNdx_4_82_16_2_ lastCharNdx_80_4) (= XRES_9_ XRES_10_)) (and (or (and (= true_term tmp2_cand_84_16) (= true_term true_term) (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_86_10_86_10 T_int)) (implies (= EC_86_10_86_10 ecThrow) (and (not (= XRES_86_10_86_10 null)) (= (PO_LT (typeof XRES_86_10_86_10) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_86_10_86_10 alloc)))) (or (= EC_86_10_86_10 ecReturn) (and (= EC_86_10_86_10 ecThrow) (= (PO_LT (typeof XRES_86_10_86_10) T_java_io_IOException) true_term))) (implies (and (= EC_86_10_86_10 ecReturn) (<= 0 RES_86_10_86_10)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_86_10_86_10 ecReturn) (or (and (= RES_86_10_86_10 117) (= true_term true_term) (= EC_86_10_86_10 EC_loopold) (= curNdx_82_16 curNdx_loopold_4_69_16) (or (and (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_88_1_0_88_8_88_8 ecThrow) (= EC_88_8 EC_88_1_0_88_8_88_8)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (not (= RES_88_1_0_88_8_88_8 117)) (= EC_88_8 L_88_1))) (= RES_4_ RES_88_1_0_88_8_88_8) (= EC_4_ EC_88_8) (= curNdx_4_69_16_1_ curNdx_82_16) (= XRES_4_ XRES_88_1_0_88_8_88_8)) (and (= true_term true_term) (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_88_1_0_88_8_88_8 T_int)) (implies (= EC_88_1_0_88_8_88_8 ecThrow) (and (not (= XRES_88_1_0_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_0_88_8_88_8 alloc)))) (or (= EC_88_1_0_88_8_88_8 ecReturn) (and (= EC_88_1_0_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_0_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_0_88_8_88_8 ecReturn) (<= 0 RES_88_1_0_88_8_88_8)) (< (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_0_88_8_88_8 ecReturn) (= RES_88_1_0_88_8_88_8 117) (= tmp4_old_curNdx_88_1_0_89_3 (S_select curNdx_82_16 this)) (= curNdx_88_1_0_89_3 (S_store curNdx_82_16 this (+ tmp4_old_curNdx_88_1_0_89_3 1))) (= true_term true_term) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_88_1_0_89_3 this)) (= true_term (is RES_88_1_1_88_8_88_8 T_int)) (implies (= EC_88_1_1_88_8_88_8 ecThrow) (and (not (= XRES_88_1_1_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_1_88_8_88_8 alloc)))) (or (= EC_88_1_1_88_8_88_8 ecReturn) (and (= EC_88_1_1_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_1_88_8_88_8 ecReturn) (<= 0 RES_88_1_1_88_8_88_8)) (< (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (= true_term true_term) (= EC_88_1_1_88_8_88_8 ecThrow) (= EC_88_8_1_ EC_88_1_1_88_8_88_8)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_88_1_0_89_3 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_88_1_0_89_3 this)) (= true_term (is RES_88_1_1_88_8_88_8 T_int)) (implies (= EC_88_1_1_88_8_88_8 ecThrow) (and (not (= XRES_88_1_1_88_8_88_8 null)) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_88_1_1_88_8_88_8 alloc)))) (or (= EC_88_1_1_88_8_88_8 ecReturn) (and (= EC_88_1_1_88_8_88_8 ecThrow) (= (PO_LT (typeof XRES_88_1_1_88_8_88_8) T_java_io_IOException) true_term))) (implies (and (= EC_88_1_1_88_8_88_8 ecReturn) (<= 0 RES_88_1_1_88_8_88_8)) (< (S_select curNdx_88_1_0_89_3 this) (S_select endBufNdx_4_60_16 this))) (= EC_88_1_1_88_8_88_8 ecReturn) (not (= RES_88_1_1_88_8_88_8 117)) (= EC_88_8_1_ L_88_1))) (= RES_4_ RES_88_1_1_88_8_88_8) (= EC_4_ EC_88_8_1_) (= curNdx_4_69_16_1_ curNdx_88_1_0_89_3) (= XRES_4_ XRES_88_1_1_88_8_88_8))) (= EC_4_ L_88_1) (= RES_5_ RES_4_) (= EC_5_ EC_4_) (= curNdx_4_69_16_2_ curNdx_4_69_16_1_) (= XRES_5_ XRES_4_) (<= 0 4) (= true_term (arrayFresh tmp5_new_char___91_12 alloc alloc_1_ elems (arrayShapeOne 4) (array T_char) 0)) (forall (?o Int) (implies (and (not (= true_term (isAllocated ?o alloc))) (= true_term (isAllocated ?o alloc_1_))) (= true_term (isNewArray ?o)))) (forall (?o_1_ Int) (implies (and (not (= true_term (isAllocated ?o_1_ alloc))) (= true_term (isAllocated ?o_1_ alloc_1_))) (= (S_select owner_6_35_28 tmp5_new_char___91_12) null))) (= elems elems_loopold) (= 0 i_loopold_92_10) (= EC_5_ EC_loopold_1_) (= alloc_1_ alloc_loopold) (= XRES_5_ XRES_loopold) (or (and (= true_term true_term) (or (and (not (< 0 4)) (= RES_6_ RES_5_) (= EC_6_ L_92_1) (= alloc_2_ alloc_1_) (= XRES_6_ XRES_5_)) (and (< 0 4) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= true_term true_term) (= EC_92_1_0_93_16_93_16 ecThrow) (= RES_93_3 RES_92_1_0_93_16_93_16) (= EC_93_3 EC_92_1_0_93_16_93_16) (= alloc_93_3 alloc_1_) (= XRES_93_3 XRES_92_1_0_93_16_93_16)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (= RES_92_1_0_95_11_95_11 null)) (= true_term true_term) (= RES_93_3 RES_92_1_0_95_11_95_11) (= EC_93_3 ecThrow) (= alloc_93_3 after_95_11_92_1_0_95_11) (= XRES_93_3 RES_92_1_0_95_11_95_11))) (not (= EC_93_3 C_92_1)) (= RES_6_ RES_93_3) (= EC_6_ EC_93_3) (= alloc_2_ alloc_93_3) (= XRES_6_ XRES_93_3))) (= RES_7_ RES_6_) (= EC_7_ EC_6_) (= alloc_3_ alloc_2_) (= XRES_7_ XRES_6_)) (and (= true_term true_term) (< 0 4) (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (not (= RES_92_1_0_94_17_94_17 (- 0 1))) (= true_term true_term) (= RES_93_3_1_ RES_92_1_0_94_17_94_17) (= EC_93_3_1_ EC_92_1_0_94_17_94_17) (= alloc_93_3_1_ alloc_1_) (= XRES_93_3_1_ XRES_92_1_0_94_17_94_17)) (and (or (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= true_term true_term) (= EC_92_1_0_93_16_93_16 ecThrow) (= RES_93_3 RES_92_1_0_93_16_93_16) (= EC_93_3 EC_92_1_0_93_16_93_16) (= alloc_93_3 alloc_1_) (= XRES_93_3 XRES_92_1_0_93_16_93_16)) (and (not (= (S_select buf_4_42_36 this) null)) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_4_69_16_2_ this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_4_69_16_2_ this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_4_69_16_2_ this)) (= true_term (is RES_92_1_0_93_16_93_16 T_int)) (implies (= EC_92_1_0_93_16_93_16 ecThrow) (and (not (= XRES_92_1_0_93_16_93_16 null)) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_92_1_0_93_16_93_16 alloc_1_)))) (or (= EC_92_1_0_93_16_93_16 ecReturn) (and (= EC_92_1_0_93_16_93_16 ecThrow) (= (PO_LT (typeof XRES_92_1_0_93_16_93_16) T_java_io_IOException) true_term))) (= EC_92_1_0_93_16_93_16 ecReturn) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= elems_92_1_0 (S_store elems tmp5_new_char___91_12 (S_store (S_select elems tmp5_new_char___91_12) 0 (cast RES_92_1_0_93_16_93_16 T_char)))) (not (= tmp5_new_char___91_12 null)) (<= 0 0) (< 0 (arrayLength tmp5_new_char___91_12)) (= tmp8_92_1_0_94_24 (S_select (S_select elems_92_1_0 tmp5_new_char___91_12) 0)) (= true_term (is RES_92_1_0_94_17_94_17 T_int)) (= EC_92_1_0_94_17_94_17 ecReturn) (= RES_92_1_0_94_17_94_17 (- 0 1)) (= true_term true_term) (< alloc_1_ after_95_11_92_1_0_95_11) (not (= RES_92_1_0_95_11_95_11 null)) (not (= true_term (isAllocated RES_92_1_0_95_11_95_11 alloc_1_))) (= true_term (is RES_92_1_0_95_11_95_11 T_java_io_IOException)) (= true_term (isAllocated RES_92_1_0_95_11_95_11 after_95_11_92_1_0_95_11)) (= EC_92_1_0_95_11_95_11 ecReturn) (= (S_select owner_6_35_28 RES_92_1_0_95_11_95_11) null) (= (typeof RES_92_1_0_95_11_95_11) T_java_io_IOException) (not (= RES_92_1_0_95_11_95_11 null)) (= true_term true_term) (= RES_93_3 RES_92_1_0_95_11_95_11) (= EC_93_3 ecThrow) (= alloc_93_3 after_95_11_92_1_0_95_11) (= XRES_93_3 RES_92_1_0_95_11_95_11))) (= EC_93_3 C_92_1) (= RES_93_3_1_ RES_93_3) (= EC_93_3_1_ EC_93_3) (= alloc_93_3_1_ alloc_93_3) (= XRES_93_3_1_ XRES_93_3))) (= i_92_1_0_92_20 (+ 0 1)) (= true_term true_term) (not (< i_92_1_0_92_20 4)) (= RES_7_ RES_93_3_1_) (= EC_7_ L_92_1) (= alloc_3_ alloc_93_3_1_) (= XRES_7_ XRES_93_3_1_))) (= EC_7_ L_92_1) (= RES_8_ RES_7_) (= EC_8_ EC_7_) (= alloc_4_ alloc_3_) (= XRES_8_ XRES_7_) (not (= tmp5_new_char___91_12 null)) (< alloc_4_ after_98_23_98_23) (not (= RES_98_23_98_23 null)) (not (= true_term (isAllocated RES_98_23_98_23 alloc_4_))) (= true_term (is RES_98_23_98_23 T_java_lang_String)) (= true_term (isAllocated RES_98_23_98_23 after_98_23_98_23)) (= EC_98_23_98_23 ecReturn) (= (S_select owner_6_35_28 RES_98_23_98_23) null) (= (typeof RES_98_23_98_23) T_java_lang_String) (= true_term (is RES_98_13_98_13 T_int)) (implies (= EC_98_13_98_13 ecThrow) (and (not (= XRES_98_13_98_13 null)) (= (PO_LT (typeof XRES_98_13_98_13) T_java_lang_Throwable) true_term) (= true_term (isAllocated XRES_98_13_98_13 after_98_23_98_23)))) (or (= EC_98_13_98_13 ecReturn) (and (= EC_98_13_98_13 ecThrow) (= (PO_LT (typeof XRES_98_13_98_13) T_java_lang_NumberFormatException) true_term))) (= EC_98_13_98_13 ecReturn) (= EC_13_ EC_98_13_98_13) (= curNdx_4_69_16_6_ curNdx_4_69_16_2_) (= c_82_8 RES_98_13_98_13) (= alloc_8_ after_98_23_98_23) (= XRES_12_ XRES_98_13_98_13)) (and (not (= RES_86_10_86_10 117)) (= true_term true_term) (<= (S_select lastCharNdx_80_4 this) (S_select curNdx_82_16 this)) (<= 0 (S_select lastCharNdx_80_4 this)) (<= (S_select curNdx_82_16 this) (S_select endBufNdx_4_60_16 this)) (<= 0 (S_select curNdx_82_16 this)) (= true_term (is RES_101_15_101_15 T_int)) (= EC_101_15_101_15 ecReturn) (implies (= EC_101_15_101_15 ecReturn) (not (= RES_101_15_101_15 NULL_23_60_26))) (= oddSlashLoc_101_1 (S_store oddSlashLoc_4_91_16 this RES_101_15_101_15)) (= EC_13_ EC_101_15_101_15) (= curNdx_4_69_16_6_ curNdx_82_16) (= c_82_8 c_82_4) (= alloc_8_ alloc) (= XRES_12_ XRES_101_15_101_15))) (= EC_14_ EC_13_) (= curNdx_4_69_16_7_ curNdx_4_69_16_6_) (= c_82_8_1_ c_82_8) (= alloc_9_ alloc_8_) (= XRES_13_ XRES_12_)) (and (not (= true_term tmp2_cand_84_16)) (= true_term true_term) (= EC_14_ EC_3_) (= curNdx_4_69_16_7_ curNdx_82_16) (= c_82_8_1_ c_82_4) (= alloc_9_ alloc) (= XRES_13_ XRES_3_))) (= true_term true_term) (= EC_10_ ecReturn) (= curNdx_4_69_16_3_ curNdx_4_69_16_7_) (= alloc_5_ alloc_9_) (= lastCharNdx_4_82_16_2_ lastCharNdx_80_4) (= XRES_9_ XRES_13_))))) (or (not (or (= EC_10_ ecReturn) (and (= EC_10_ ecThrow) (= (PO_LT (typeof XRES_9_) T_java_io_IOException) true_term)))) (not (forall (?brokenObj Int) (implies (and (= true_term (is ?brokenObj T_javafe_util_BufferedCorrelatedReader)) (= true_term (isAllocated ?brokenObj alloc_5_)) (not (= ?brokenObj null)) (= true_term (S_select marked_5_92_41 ?brokenObj))) (and (<= 0 (S_select markNdx_4_213_16 ?brokenObj)) (<= (S_select markNdx_4_213_16 ?brokenObj) (S_select curNdx_4_69_16_3_ ?brokenObj)))))) (not (forall (?brokenObj_1_ Int) (implies (and (= true_term (is ?brokenObj_1_ T_javafe_util_BufferedCorrelatedReader)) (= true_term (isAllocated ?brokenObj_1_ alloc_5_)) (not (= ?brokenObj_1_ null))) (<= (S_select lastCharNdx_4_82_16_2_ ?brokenObj_1_) (S_select curNdx_4_69_16_3_ ?brokenObj_1_))))) (not (forall (?brokenObj_2_ Int) (implies (and (= true_term (is ?brokenObj_2_ T_javafe_util_BufferedCorrelatedReader)) (= true_term (isAllocated ?brokenObj_2_ alloc_5_)) (not (= ?brokenObj_2_ null))) (<= 0 (S_select lastCharNdx_4_82_16_2_ ?brokenObj_2_))))) (not (forall (?brokenObj_3_ Int) (implies (and (= true_term (is ?brokenObj_3_ T_javafe_util_BufferedCorrelatedReader)) (= true_term (isAllocated ?brokenObj_3_ alloc_5_)) (not (= ?brokenObj_3_ null))) (<= (S_select curNdx_4_69_16_3_ ?brokenObj_3_) (S_select endBufNdx_4_60_16 ?brokenObj_3_))))) (not (forall (?brokenObj_5_ Int) (implies (and (= true_term (is ?brokenObj_5_ T_javafe_util_BufferedCorrelatedReader)) (= true_term (isAllocated ?brokenObj_5_ alloc_5_)) (not (= ?brokenObj_5_ null))) (<= 0 (S_select curNdx_4_69_16_3_ ?brokenObj_5_))))))))))))))
