(benchmark simplify_benchmark
:source { Simplify Theorem Prover Benchmark Suite }
:logic AUFLIA
  :status unsat
:difficulty { 5 }
:category { industrial }
:extrafuns ((true_term Int))
:extrafuns ((false_term Int))
:assumption (= true_term 1)
:assumption (= false_term 0)
:extrafuns ((S_select Int Int Int))
:extrafuns ((S_store Int Int Int Int))
:assumption (forall (?m Int) (?i Int) (?x Int) (= (S_select (S_store ?m ?i ?x) ?i) ?x))
:assumption (forall (?m Int) (?i Int) (?j Int) (?x Int) (implies (not (= ?i ?j)) (= (S_select (S_store ?m ?i ?x) ?j) (S_select ?m ?j))))
:extrafuns ((PO_LT Int Int Int))
:assumption (forall (?t Int) (= (PO_LT ?t ?t) true_term))
:extrafuns ((T_java_lang_Object Int))
:assumption (= (PO_LT T_java_lang_Object T_java_lang_Object) true_term)
:assumption (forall (?t0 Int) (?t1 Int) (?t2 Int) (implies (and (= (PO_LT ?t0 ?t1) true_term) (= (PO_LT ?t1 ?t2) true_term)) (= (PO_LT ?t0 ?t2) true_term)))
:assumption (forall (?t0 Int) (?t1 Int) (implies (and (= (PO_LT ?t0 ?t1) true_term) (= (PO_LT ?t1 ?t0) true_term)) (= ?t0 ?t1)))
:extrafuns ((T_boolean Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_boolean) true_term) (= ?t T_boolean)))
:extrafuns ((T_char Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_char) true_term) (= ?t T_char)))
:extrafuns ((T_byte Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_byte) true_term) (= ?t T_byte)))
:extrafuns ((T_short Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_short) true_term) (= ?t T_short)))
:extrafuns ((T_int Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_int) true_term) (= ?t T_int)))
:extrafuns ((T_long Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_long) true_term) (= ?t T_long)))
:extrafuns ((T_float Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_float) true_term) (= ?t T_float)))
:extrafuns ((T_double Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_double) true_term) (= ?t T_double)))
:assumption (forall (?t Int) (implies (= (PO_LT T_boolean ?t) true_term) (= ?t T_boolean)))
:assumption (forall (?t Int) (implies (= (PO_LT T_char ?t) true_term) (= ?t T_char)))
:assumption (forall (?t Int) (implies (= (PO_LT T_byte ?t) true_term) (= ?t T_byte)))
:assumption (forall (?t Int) (implies (= (PO_LT T_short ?t) true_term) (= ?t T_short)))
:assumption (forall (?t Int) (implies (= (PO_LT T_int ?t) true_term) (= ?t T_int)))
:assumption (forall (?t Int) (implies (= (PO_LT T_long ?t) true_term) (= ?t T_long)))
:assumption (forall (?t Int) (implies (= (PO_LT T_float ?t) true_term) (= ?t T_float)))
:assumption (forall (?t Int) (implies (= (PO_LT T_double ?t) true_term) (= ?t T_double)))
:extrafuns ((asChild Int Int Int))
:extrafuns ((classDown Int Int Int))
:assumption (forall (?t0 Int) (?t1 Int) (?t2 Int) (implies (= (PO_LT ?t0 (asChild ?t1 ?t2)) true_term) (= (classDown ?t2 ?t0) (asChild ?t1 ?t2))))
:extrafuns ((T_java_lang_Cloneable Int))
:assumption (= (PO_LT T_java_lang_Cloneable T_java_lang_Object) true_term)
:extrafuns ((array Int Int))
:assumption (forall (?t Int) (= (PO_LT (array ?t) T_java_lang_Cloneable) true_term))
:extrafuns ((elemtype Int Int))
:assumption (forall (?t Int) (= (elemtype (array ?t)) ?t))
:assumption (forall (?t0 Int) (?t1 Int) (iff (= (PO_LT ?t0 (array ?t1)) true_term) (and (= ?t0 (array (elemtype ?t0))) (= (PO_LT (elemtype ?t0) ?t1) true_term))))
:extrafuns ((is Int Int Int))
:extrafuns ((cast Int Int Int))
:assumption (forall (?x Int) (?t Int) (= (is (cast ?x ?t) ?t) true_term))
:assumption (forall (?x Int) (?t Int) (implies (= (is ?x ?t) true_term) (= (cast ?x ?t) ?x)))
:assumption true
:assumption (forall (?x Int) (iff (= (is ?x T_char) true_term) (and (<= 0 ?x) (<= ?x 65535))))
:assumption (forall (?x Int) (iff (= (is ?x T_byte) true_term) (and (<= (~ 128) ?x) (<= ?x 127))))
:assumption (forall (?x Int) (iff (= (is ?x T_short) true_term) (and (<= (~ 32768) ?x) (<= ?x 32767))))
:extrafuns ((intFirst Int))
:extrafuns ((intLast Int))
:assumption (forall (?x Int) (iff (= (is ?x T_int) true_term) (and (<= intFirst ?x) (<= ?x intLast))))
:extrafuns ((longFirst Int))
:extrafuns ((longLast Int))
:assumption (forall (?x Int) (iff (= (is ?x T_long) true_term) (and (<= longFirst ?x) (<= ?x longLast))))
:assumption (< longFirst intFirst)
:assumption (< intFirst (~ 1000000))
:assumption (< 1000000 intLast)
:assumption (< intLast longLast)
:extrafuns ((null Int))
:extrafuns ((typeof Int Int))
:assumption (forall (?x Int) (?t Int) (implies (= (PO_LT ?t T_java_lang_Object) true_term) (iff (= (is ?x ?t) true_term) (or (= ?x null) (= (PO_LT (typeof ?x) ?t) true_term)))))
:extrafuns ((asField Int Int Int))
:assumption (forall (?f Int) (?t Int) (?x Int) (= (is (S_select (asField ?f ?t) ?x) ?t) true_term))
:extrafuns ((asElems Int Int))
:assumption (forall (?e Int) (?a Int) (?i Int) (= (is (S_select (S_select (asElems ?e) ?a) ?i) (elemtype (typeof ?a))) true_term))
:extrafuns ((vAllocTime Int Int))
:extrafuns ((isAllocated Int Int Int))
:assumption (forall (?x Int) (?a0 Int) (iff (= (isAllocated ?x ?a0) true_term) (< (vAllocTime ?x) ?a0)))
:extrafuns ((fClosedTime Int Int))
:assumption (forall (?x Int) (?f Int) (?a0 Int) (implies (and (< (fClosedTime ?f) ?a0) (= (isAllocated ?x ?a0) true_term)) (= (isAllocated (S_select ?f ?x) ?a0) true_term)))
:extrafuns ((eClosedTime Int Int))
:assumption (forall (?a Int) (?e Int) (?i Int) (?a0 Int) (implies (and (< (eClosedTime ?e) ?a0) (= (isAllocated ?a ?a0) true_term)) (= (isAllocated (S_select (S_select ?e ?a) ?i) ?a0) true_term)))
:extrafuns ((asLockSet Int Int))
:extrafuns ((max Int Int))
:assumption (forall (?S Int) (= (S_select (asLockSet ?S) (max (asLockSet ?S))) true_term))
:assumption (forall (?S Int) (= (S_select (asLockSet ?S) null) true_term))
:extrafuns ((lockLE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (lockLE ?x ?y) true_term) (<= ?x ?y)))
:extrafuns ((lockLT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (lockLT ?x ?y) true_term) (< ?x ?y)))
:assumption (forall (?S Int) (?mu Int) (implies (= (S_select (asLockSet ?S) ?mu) true_term) (= (lockLE ?mu (max (asLockSet ?S))) true_term)))
:assumption (forall (?x Int) (implies (= (PO_LT (typeof ?x) T_java_lang_Object) true_term) (= (lockLE null ?x) true_term)))
:extrafuns ((arrayLength Int Int))
:assumption (forall (?a Int) (and (<= 0 (arrayLength ?a)) (= (is (arrayLength ?a) T_int) true_term)))
:extrafuns ((arrayFresh Int Int Int Int Int Int Int Int))
:extrafuns ((arrayShapeMore Int Int Int))
:extrafuns ((arrayParent Int Int))
:extrafuns ((arrayPosition Int Int))
:assumption (forall (?a Int) (?a0 Int) (?b0 Int) (?e Int) (?n Int) (?s Int) (?T Int) (?v Int) (iff (= (arrayFresh ?a ?a0 ?b0 ?e (arrayShapeMore ?n ?s) ?T ?v) true_term) (and (<= ?a0 (vAllocTime ?a)) (= (isAllocated ?a ?b0) true_term) (not (= ?a null)) (= (typeof ?a) ?T) (= (arrayLength ?a) ?n) (forall (?i Int) (and (= (arrayFresh (S_select (S_select ?e ?a) ?i) ?a0 ?b0 ?e ?s (elemtype ?T) ?v) true_term) (= (arrayParent (S_select (S_select ?e ?a) ?i)) ?a) (= (arrayPosition (S_select (S_select ?e ?a) ?i)) ?i))))))
:extrafuns ((arrayShapeOne Int Int))
:assumption (forall (?a Int) (?a0 Int) (?b0 Int) (?e Int) (?n Int) (?T Int) (?v Int) (iff (= (arrayFresh ?a ?a0 ?b0 ?e (arrayShapeOne ?n) ?T ?v) true_term) (and (<= ?a0 (vAllocTime ?a)) (= (isAllocated ?a ?b0) true_term) (not (= ?a null)) (= (typeof ?a) ?T) (= (arrayLength ?a) ?n) (forall (?i Int) (and (= (S_select (S_select ?e ?a) ?i) ?v))))))
:extrafuns ((arrayType Int))
:assumption (= arrayType (asChild arrayType T_java_lang_Object))
:assumption (forall (?t Int) (= (PO_LT (array ?t) arrayType) true_term))
:extrafuns ((isNewArray Int Int))
:assumption (forall (?s Int) (implies (= true_term (isNewArray ?s)) (= (PO_LT (typeof ?s) arrayType) true_term)))
:extrafuns ((boolAnd Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolAnd ?a ?b) true_term) (and (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolEq Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolEq ?a ?b) true_term) (iff (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolImplies Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolImplies ?a ?b) true_term) (implies (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolNE Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolNE ?a ?b) true_term) (not (iff (= ?a true_term) (= ?b true_term)))))
:extrafuns ((boolNot Int Int))
:assumption (forall (?a Int) (iff (= (boolNot ?a) true_term) (not (= ?a true_term))))
:extrafuns ((boolOr Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolOr ?a ?b) true_term) (or (= ?a true_term) (= ?b true_term))))
:extrafuns ((integralEQ Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralEQ ?x ?y) true_term) (= ?x ?y)))
:extrafuns ((stringCat Int Int Int))
:extrafuns ((T_java_lang_String Int))
:assumption (forall (?x Int) (?y Int) (and (not (= (stringCat ?x ?y) null)) (= (PO_LT (typeof (stringCat ?x ?y)) T_java_lang_String) true_term)))
:extrafuns ((integralGE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralGE ?x ?y) true_term) (>= ?x ?y)))
:extrafuns ((integralGT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralGT ?x ?y) true_term) (> ?x ?y)))
:extrafuns ((integralLE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralLE ?x ?y) true_term) (<= ?x ?y)))
:extrafuns ((integralLT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralLT ?x ?y) true_term) (< ?x ?y)))
:extrafuns ((integralNE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralNE ?x ?y) true_term) (not (= ?x ?y))))
:extrafuns ((refEQ Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (refEQ ?x ?y) true_term) (= ?x ?y)))
:extrafuns ((refNE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (refNE ?x ?y) true_term) (not (= ?x ?y))))
:extrafuns ((nonnullelements Int Int Int))
:assumption (forall (?x Int) (?e Int) (iff (= (nonnullelements ?x ?e) true_term) (and (not (= ?x null)) (forall (?i Int) (implies (and (<= 0 ?i) (< ?i (arrayLength ?x))) (not (= (S_select (S_select ?e ?x) ?i) null)))))))
:extrafuns ((classLiteral Int Int))
:extrafuns ((T_java_lang_Class Int))
:extrafuns ((alloc Int))
:assumption (forall (?t Int) (and (not (= (classLiteral ?t) null)) (= (is (classLiteral ?t) T_java_lang_Class) true_term) (= (isAllocated (classLiteral ?t) alloc) true_term)))
:extrafuns ((integralAnd Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (or (<= 0 ?x) (<= 0 ?y)) (<= 0 (integralAnd ?x ?y))))
:assumption (forall (?x Int) (?y Int) (implies (<= 0 ?x) (<= (integralAnd ?x ?y) ?x)))
:assumption (forall (?x Int) (?y Int) (implies (<= 0 ?y) (<= (integralAnd ?x ?y) ?y)))
:extrafuns ((integralOr Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (and (<= 0 ?x) (<= 0 ?y)) (and (<= ?x (integralOr ?x ?y)) (<= ?y (integralOr ?x ?y)))))
:extrafuns ((integralXor Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (and (<= 0 ?x) (<= 0 ?y)) (<= 0 (integralXor ?x ?y))))
:extrafuns ((intShiftL Int Int Int))
:assumption (forall (?n Int) (implies (and (<= 0 ?n) (< ?n 31)) (<= 1 (intShiftL 1 ?n))))
:extrafuns ((longShiftL Int Int Int))
:assumption (forall (?n Int) (implies (and (<= 0 ?n) (< ?n 63)) (<= 1 (longShiftL 1 ?n))))
:assumption true
:extrafuns ((T_javafe_ast_ConstructorDecl Int))
:extrafuns ((T_javafe_ast_RoutineDecl Int))
:extrafuns ((T_javafe_ast_StmtPragma Int))
:extrafuns ((T_javafe_ast_Stmt Int))
:extrafuns ((T_javafe_parser_ParseType Int))
:extrafuns ((T_javafe_parser_ParseUtil Int))
:extrafuns ((T_javafe_ast_TagConstants Int))
:extrafuns ((T_javafe_ast_OperatorTags Int))
:extrafuns ((T_javafe_parser_PunctuationPrefixTree Int))
:extrafuns ((T_javafe_ast_ModifierPragmaVec Int))
:extrafuns ((T_java_util_EscjavaKeyValue Int))
:extrafuns ((T_javafe_ast_TypeDeclElem Int))
:extrafuns ((T_javafe_parser_TagConstants Int))
:extrafuns ((T_java_util_Dictionary Int))
:extrafuns ((T_java_lang_Integer Int))
:extrafuns ((T_java_lang_Number Int))
:extrafuns ((T_java_lang_Comparable Int))
:extrafuns ((T_java_util_Map Int))
:extrafuns ((T_javafe_ast_TypeDeclElemPragma Int))
:extrafuns ((T_javafe_ast_ASTNode Int))
:extrafuns ((T_javafe_ast_GeneratedTags Int))
:extrafuns ((T_javafe_ast_VarInit Int))
:extrafuns ((T_javafe_ast_ImportDecl Int))
:extrafuns ((T_java_io_Serializable Int))
:extrafuns ((T_javafe_ast_Type Int))
:extrafuns ((T_javafe_ast_FieldDecl Int))
:extrafuns ((T_javafe_ast_GenericVarDecl Int))
:extrafuns ((T_javafe_ast_TypeModifierPragma Int))
:extrafuns ((T_javafe_ast_StmtVec Int))
:extrafuns ((T_javafe_ast_MethodDecl Int))
:extrafuns ((T_java_util_Hashtable Int))
:extrafuns ((T_javafe_ast_ImportDeclVec Int))
:extrafuns ((T_javafe_ast_CompilationUnit Int))
:extrafuns ((T_javafe_util_StackVector Int))
:extrafuns ((T_java_lang_Float Int))
:extrafuns ((T_javafe_parser_ParseStmt Int))
:extrafuns ((T_javafe_parser_ParseExpr Int))
:extrafuns ((T_javafe_util_Location Int))
:extrafuns ((T_javafe_ast_LexicalPragma Int))
:extrafuns ((T_javafe_parser_Parse Int))
:extrafuns ((T_javafe_ast_CatchClause Int))
:extrafuns ((T_javafe_ast_TypeNameVec Int))
:extrafuns ((T_javafe_ast_TypeDeclElemVec Int))
:extrafuns ((T_javafe_ast_TypeDeclVec Int))
:extrafuns ((T_javafe_ast_LexicalPragmaVec Int))
:extrafuns ((T_javafe_ast_Identifier Int))
:extrafuns ((T_javafe_ast_ModifierPragma Int))
:extrafuns ((T_java_lang_Long Int))
:extrafuns ((T_javafe_ast_SingleTypeImportDecl Int))
:extrafuns ((T_javafe_ast_TypeModifierPragmaVec Int))
:extrafuns ((T_javafe_ast_OnDemandImportDecl Int))
:extrafuns ((T_javafe_ast_GenericBlockStmt Int))
:extrafuns ((T_javafe_ast_Expr Int))
:extrafuns ((T_javafe_ast_InterfaceDecl Int))
:extrafuns ((T_javafe_ast_TypeDecl Int))
:extrafuns ((T_javafe_parser_Token Int))
:extrafuns ((T_java_lang_Double Int))
:extrafuns ((T_javafe_parser_PragmaParser Int))
:extrafuns ((T_javafe_ast_FormalParaDeclVec Int))
:extrafuns ((T_javafe_ast_TypeName Int))
:extrafuns ((T_javafe_ast_BlockStmt Int))
:extrafuns ((T_javafe_ast_Modifiers Int))
:extrafuns ((T_javafe_ast_InitBlock Int))
:extrafuns ((T_javafe_ast_ClassDecl Int))
:extrafuns ((T_javafe_ast_Name Int))
:extrafuns ((T_javafe_util_CorrelatedReader Int))
:extrafuns ((T_javafe_ast_FormalParaDecl Int))
:extrafuns ((T_javafe_parser_Lex Int))
:extrafuns ((DIST_ZERO_1 Int))
:extrafuns ((T__TYPE Int))
:extrafuns ((FLOATLIT_15_42_26 Int))
:extrafuns ((seqCatchClause_4_76_46 Int))
:extrafuns ((LPAREN_14_37_26 Int))
:extrafuns ((seqIdentifier_6_33_46 Int))
:extrafuns ((IMPLEMENTS_14_74_26 Int))
:extrafuns ((TYPEMODIFIERPRAGMA_14_28_26 Int))
:extrafuns ((keywordStrings_14_181_30 Int))
:extrafuns ((EOF_14_17_26 Int))
:extrafuns ((CHARLIT_15_41_26 Int))
:extrafuns ((RBRACE_14_36_26 Int))
:extrafuns ((punctuationStrings_14_134_22 Int))
:extrafuns ((seqVarInit_5_1153_46 Int))
:extrafuns ((seqFormalParaDecl_64_46 Int))
:extrafuns ((TYPEDECLELEMPRAGMA_14_27_26 Int))
:extrafuns ((seqStmt_4_70_46 Int))
:extrafuns ((IDENT_15_25_26 Int))
:extrafuns ((LONGLIT_15_40_26 Int))
:extrafuns ((LBRACE_14_35_26 Int))
:extrafuns ((EXTENDS_14_66_26 Int))
:extrafuns ((STMTPRAGMA_14_26_26 Int))
:extrafuns ((seqExpr_5_1145_46 Int))
:extrafuns ((CLASS_14_59_26 Int))
:extrafuns ((seqTypeName_56_46 Int))
:extrafuns ((ASSIGN_16_40_26 Int))
:extrafuns ((INTLIT_15_39_26 Int))
:extrafuns ((SEMICOLON_14_34_26 Int))
:extrafuns ((INTERFACE_14_78_26 Int))
:extrafuns ((MODIFIERPRAGMA_14_25_26 Int))
:extrafuns ((FIRST_KEYWORD_14_51_26 Int))
:extrafuns ((ACC_PUBLIC_45_19_26 Int))
:extrafuns ((STAR_16_37_26 Int))
:extrafuns ((BOOLEANLIT_15_38_26 Int))
:extrafuns ((NONE_45_18_26 Int))
:extrafuns ((seqModifierPragma_7_74_32 Int))
:extrafuns ((THROWS_14_96_26 Int))
:extrafuns ((LEXICALPRAGMA_14_24_26 Int))
:extrafuns ((seqTypeDecl_80_46 Int))
:extrafuns ((LAST_KEYWORD_14_103_26 Int))
:extrafuns ((otherCodes_14_202_27 Int))
:extrafuns ((otherStrings_14_193_30 Int))
:extrafuns ((STRINGLIT_15_44_26 Int))
:extrafuns ((noTokens_14_212_27 Int))
:extrafuns ((PACKAGE_14_83_26 Int))
:extrafuns ((COMMA_14_33_26 Int))
:extrafuns ((punctuationCodes_14_164_19 Int))
:extrafuns ((DOUBLELIT_15_43_26 Int))
:extrafuns ((NULL_46_60_26 Int))
:extrafuns ((RPAREN_14_38_26 Int))
:extrafuns ((NULL_14_82_26 Int))
:extrafuns ((IMPORT_14_75_26 Int))
:extrafuns ((seqTypeDeclElem_5_1161_46 Int))
:extrafuns ((seqImportDecl_72_46 Int))
:extrafuns ((FIELD_14_45_26 Int))
:assumption (and (= (PO_LT T_javafe_ast_ConstructorDecl T_javafe_ast_RoutineDecl) true_term) (= T_javafe_ast_ConstructorDecl (asChild T_javafe_ast_ConstructorDecl T_javafe_ast_RoutineDecl)) (= (PO_LT T_javafe_ast_StmtPragma T_javafe_ast_Stmt) true_term) (= T_javafe_ast_StmtPragma (asChild T_javafe_ast_StmtPragma T_javafe_ast_Stmt)) (= (PO_LT T_javafe_parser_ParseType T_javafe_parser_ParseUtil) true_term) (= T_javafe_parser_ParseType (asChild T_javafe_parser_ParseType T_javafe_parser_ParseUtil)) (= (PO_LT T_javafe_ast_TagConstants T_javafe_ast_OperatorTags) true_term) (= T_javafe_ast_TagConstants (asChild T_javafe_ast_TagConstants T_javafe_ast_OperatorTags)) (= (PO_LT T_javafe_parser_PunctuationPrefixTree T_java_lang_Object) true_term) (= T_javafe_parser_PunctuationPrefixTree (asChild T_javafe_parser_PunctuationPrefixTree T_java_lang_Object)) (= (PO_LT T_javafe_ast_ModifierPragmaVec T_java_lang_Object) true_term) (= T_javafe_ast_ModifierPragmaVec (asChild T_javafe_ast_ModifierPragmaVec T_java_lang_Object)) (= (PO_LT T_java_util_EscjavaKeyValue T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_TypeDeclElem T_java_lang_Object) true_term) (= (PO_LT T_javafe_parser_TagConstants T_javafe_ast_TagConstants) true_term) (= T_javafe_parser_TagConstants (asChild T_javafe_parser_TagConstants T_javafe_ast_TagConstants)) (= (PO_LT T_java_util_Dictionary T_java_lang_Object) true_term) (= T_java_util_Dictionary (asChild T_java_util_Dictionary T_java_lang_Object)) (= (PO_LT T_java_util_Dictionary T_java_util_EscjavaKeyValue) true_term) (= (PO_LT T_java_lang_Integer T_java_lang_Number) true_term) (= T_java_lang_Integer (asChild T_java_lang_Integer T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Integer) true_term) (= ?t T_java_lang_Integer))) (= (PO_LT T_java_lang_Integer T_java_lang_Comparable) true_term) (= (PO_LT T_java_util_Map T_java_lang_Object) true_term) (= (PO_LT T_java_util_Map T_java_util_EscjavaKeyValue) true_term) (= (PO_LT T_javafe_ast_TypeDeclElemPragma T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_TypeDeclElemPragma (asChild T_javafe_ast_TypeDeclElemPragma T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_TypeDeclElemPragma T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_GeneratedTags T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_VarInit T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_VarInit (asChild T_javafe_ast_VarInit T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_ImportDecl T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_ImportDecl (asChild T_javafe_ast_ImportDecl T_javafe_ast_ASTNode)) (= (PO_LT T_java_io_Serializable T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_Type T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_Type (asChild T_javafe_ast_Type T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_FieldDecl T_javafe_ast_GenericVarDecl) true_term) (= T_javafe_ast_FieldDecl (asChild T_javafe_ast_FieldDecl T_javafe_ast_GenericVarDecl)) (= (PO_LT T_javafe_ast_FieldDecl T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_TypeModifierPragma T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_TypeModifierPragma (asChild T_javafe_ast_TypeModifierPragma T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_StmtVec T_java_lang_Object) true_term) (= T_javafe_ast_StmtVec (asChild T_javafe_ast_StmtVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_MethodDecl T_javafe_ast_RoutineDecl) true_term) (= T_javafe_ast_MethodDecl (asChild T_javafe_ast_MethodDecl T_javafe_ast_RoutineDecl)) (= (PO_LT T_java_util_Hashtable T_java_util_Dictionary) true_term) (= T_java_util_Hashtable (asChild T_java_util_Hashtable T_java_util_Dictionary)) (= (PO_LT T_java_util_Hashtable T_java_util_Map) true_term) (= (PO_LT T_java_util_Hashtable T_java_lang_Cloneable) true_term) (= (PO_LT T_java_util_Hashtable T_java_io_Serializable) true_term) (= (PO_LT T_javafe_parser_ParseUtil T_java_lang_Object) true_term) (= T_javafe_parser_ParseUtil (asChild T_javafe_parser_ParseUtil T_java_lang_Object)) (= (PO_LT T_java_lang_String T_java_lang_Object) true_term) (= T_java_lang_String (asChild T_java_lang_String T_java_lang_Object)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_String) true_term) (= ?t T_java_lang_String))) (= (PO_LT T_java_lang_String T_java_io_Serializable) true_term) (= (PO_LT T_java_lang_String T_java_lang_Comparable) true_term) (= (PO_LT T_javafe_ast_ImportDeclVec T_java_lang_Object) true_term) (= T_javafe_ast_ImportDeclVec (asChild T_javafe_ast_ImportDeclVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_CompilationUnit T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_CompilationUnit (asChild T_javafe_ast_CompilationUnit T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_util_StackVector T_java_lang_Object) true_term) (= T_javafe_util_StackVector (asChild T_javafe_util_StackVector T_java_lang_Object)) (forall (?t Int) (iff (= (PO_LT ?t T_javafe_util_StackVector) true_term) (= ?t T_javafe_util_StackVector))) (= (PO_LT T_java_lang_Float T_java_lang_Number) true_term) (= T_java_lang_Float (asChild T_java_lang_Float T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Float) true_term) (= ?t T_java_lang_Float))) (= (PO_LT T_java_lang_Float T_java_lang_Comparable) true_term) (= (PO_LT T_javafe_parser_ParseStmt T_javafe_parser_ParseExpr) true_term) (= T_javafe_parser_ParseStmt (asChild T_javafe_parser_ParseStmt T_javafe_parser_ParseExpr)) (= (PO_LT T_javafe_util_Location T_java_lang_Object) true_term) (= T_javafe_util_Location (asChild T_javafe_util_Location T_java_lang_Object)) (= (PO_LT T_javafe_ast_LexicalPragma T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_LexicalPragma (asChild T_javafe_ast_LexicalPragma T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_parser_Parse T_javafe_parser_ParseStmt) true_term) (= T_javafe_parser_Parse (asChild T_javafe_parser_Parse T_javafe_parser_ParseStmt)) (= (PO_LT T_javafe_ast_CatchClause T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_CatchClause (asChild T_javafe_ast_CatchClause T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_TypeNameVec T_java_lang_Object) true_term) (= T_javafe_ast_TypeNameVec (asChild T_javafe_ast_TypeNameVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_TypeDeclElemVec T_java_lang_Object) true_term) (= T_javafe_ast_TypeDeclElemVec (asChild T_javafe_ast_TypeDeclElemVec T_java_lang_Object)) (= (PO_LT T_java_lang_Cloneable T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_GenericVarDecl T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_GenericVarDecl (asChild T_javafe_ast_GenericVarDecl T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_TypeDeclVec T_java_lang_Object) true_term) (= T_javafe_ast_TypeDeclVec (asChild T_javafe_ast_TypeDeclVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_LexicalPragmaVec T_java_lang_Object) true_term) (= T_javafe_ast_LexicalPragmaVec (asChild T_javafe_ast_LexicalPragmaVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_Identifier T_java_lang_Object) true_term) (= T_javafe_ast_Identifier (asChild T_javafe_ast_Identifier T_java_lang_Object)) (forall (?t Int) (iff (= (PO_LT ?t T_javafe_ast_Identifier) true_term) (= ?t T_javafe_ast_Identifier))) (= (PO_LT T_javafe_ast_ModifierPragma T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_ModifierPragma (asChild T_javafe_ast_ModifierPragma T_javafe_ast_ASTNode)) (= (PO_LT T_java_lang_Long T_java_lang_Number) true_term) (= T_java_lang_Long (asChild T_java_lang_Long T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Long) true_term) (= ?t T_java_lang_Long))) (= (PO_LT T_java_lang_Long T_java_lang_Comparable) true_term) (= (PO_LT T_javafe_ast_SingleTypeImportDecl T_javafe_ast_ImportDecl) true_term) (= T_javafe_ast_SingleTypeImportDecl (asChild T_javafe_ast_SingleTypeImportDecl T_javafe_ast_ImportDecl)) (= (PO_LT T_javafe_ast_TypeModifierPragmaVec T_java_lang_Object) true_term) (= T_javafe_ast_TypeModifierPragmaVec (asChild T_javafe_ast_TypeModifierPragmaVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_OnDemandImportDecl T_javafe_ast_ImportDecl) true_term) (= T_javafe_ast_OnDemandImportDecl (asChild T_javafe_ast_OnDemandImportDecl T_javafe_ast_ImportDecl)) (= (PO_LT T_javafe_ast_GenericBlockStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_GenericBlockStmt (asChild T_javafe_ast_GenericBlockStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_Stmt T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_Stmt (asChild T_javafe_ast_Stmt T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_Expr T_javafe_ast_VarInit) true_term) (= T_javafe_ast_Expr (asChild T_javafe_ast_Expr T_javafe_ast_VarInit)) (= (PO_LT T_javafe_ast_InterfaceDecl T_javafe_ast_TypeDecl) true_term) (= T_javafe_ast_InterfaceDecl (asChild T_javafe_ast_InterfaceDecl T_javafe_ast_TypeDecl)) (= (PO_LT T_java_lang_Number T_java_lang_Object) true_term) (= T_java_lang_Number (asChild T_java_lang_Number T_java_lang_Object)) (= (PO_LT T_java_lang_Number T_java_io_Serializable) true_term) (= (PO_LT T_javafe_parser_Token T_java_lang_Object) true_term) (= T_javafe_parser_Token (asChild T_javafe_parser_Token T_java_lang_Object)) (= (PO_LT T_javafe_parser_ParseExpr T_javafe_parser_ParseType) true_term) (= T_javafe_parser_ParseExpr (asChild T_javafe_parser_ParseExpr T_javafe_parser_ParseType)) (= (PO_LT T_java_lang_Double T_java_lang_Number) true_term) (= T_java_lang_Double (asChild T_java_lang_Double T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Double) true_term) (= ?t T_java_lang_Double))) (= (PO_LT T_java_lang_Double T_java_lang_Comparable) true_term) (= (PO_LT T_java_lang_Comparable T_java_lang_Object) true_term) (= (PO_LT T_javafe_parser_PragmaParser T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_FormalParaDeclVec T_java_lang_Object) true_term) (= T_javafe_ast_FormalParaDeclVec (asChild T_javafe_ast_FormalParaDeclVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_TypeName T_javafe_ast_Type) true_term) (= T_javafe_ast_TypeName (asChild T_javafe_ast_TypeName T_javafe_ast_Type)) (= (PO_LT T_javafe_ast_BlockStmt T_javafe_ast_GenericBlockStmt) true_term) (= T_javafe_ast_BlockStmt (asChild T_javafe_ast_BlockStmt T_javafe_ast_GenericBlockStmt)) (= (PO_LT T_javafe_ast_Modifiers T_java_lang_Object) true_term) (= T_javafe_ast_Modifiers (asChild T_javafe_ast_Modifiers T_java_lang_Object)) (= (PO_LT T_javafe_ast_OperatorTags T_java_lang_Object) true_term) (= T_javafe_ast_OperatorTags (asChild T_javafe_ast_OperatorTags T_java_lang_Object)) (= (PO_LT T_javafe_ast_OperatorTags T_javafe_ast_GeneratedTags) true_term) (= (PO_LT T_javafe_ast_InitBlock T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_InitBlock (asChild T_javafe_ast_InitBlock T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_InitBlock T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_RoutineDecl T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_RoutineDecl (asChild T_javafe_ast_RoutineDecl T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_RoutineDecl T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_ClassDecl T_javafe_ast_TypeDecl) true_term) (= T_javafe_ast_ClassDecl (asChild T_javafe_ast_ClassDecl T_javafe_ast_TypeDecl)) (= (PO_LT T_javafe_ast_Name T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_Name (asChild T_javafe_ast_Name T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_util_CorrelatedReader T_java_lang_Object) true_term) (= T_javafe_util_CorrelatedReader (asChild T_javafe_util_CorrelatedReader T_java_lang_Object)) (= (PO_LT T_javafe_ast_TypeDecl T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_TypeDecl (asChild T_javafe_ast_TypeDecl T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_TypeDecl T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_ASTNode T_java_lang_Object) true_term) (= T_javafe_ast_ASTNode (asChild T_javafe_ast_ASTNode T_java_lang_Object)) (= (PO_LT T_javafe_ast_ASTNode T_java_lang_Cloneable) true_term) (= (PO_LT T_javafe_ast_FormalParaDecl T_javafe_ast_GenericVarDecl) true_term) (= T_javafe_ast_FormalParaDecl (asChild T_javafe_ast_FormalParaDecl T_javafe_ast_GenericVarDecl)) (= (PO_LT T_javafe_parser_Lex T_javafe_parser_Token) true_term) (= T_javafe_parser_Lex (asChild T_javafe_parser_Lex T_javafe_parser_Token)) (and (= arrayType (+ DIST_ZERO_1 0)) (= T_boolean (+ DIST_ZERO_1 1)) (= T_char (+ DIST_ZERO_1 2)) (= T_byte (+ DIST_ZERO_1 3)) (= T_short (+ DIST_ZERO_1 4)) (= T_int (+ DIST_ZERO_1 5)) (= T_long (+ DIST_ZERO_1 6)) (= T_float (+ DIST_ZERO_1 7)) (= T_double (+ DIST_ZERO_1 8)) (= T__TYPE (+ DIST_ZERO_1 9)) (= T_javafe_ast_ConstructorDecl (+ DIST_ZERO_1 10)) (= T_javafe_ast_StmtPragma (+ DIST_ZERO_1 11)) (= T_javafe_parser_ParseType (+ DIST_ZERO_1 12)) (= T_javafe_ast_TagConstants (+ DIST_ZERO_1 13)) (= T_javafe_parser_PunctuationPrefixTree (+ DIST_ZERO_1 14)) (= T_javafe_ast_ModifierPragmaVec (+ DIST_ZERO_1 15)) (= T_java_util_EscjavaKeyValue (+ DIST_ZERO_1 16)) (= T_javafe_ast_TypeDeclElem (+ DIST_ZERO_1 17)) (= T_javafe_parser_TagConstants (+ DIST_ZERO_1 18)) (= T_java_util_Dictionary (+ DIST_ZERO_1 19)) (= T_java_lang_Integer (+ DIST_ZERO_1 20)) (= T_java_util_Map (+ DIST_ZERO_1 21)) (= T_javafe_ast_TypeDeclElemPragma (+ DIST_ZERO_1 22)) (= T_javafe_ast_GeneratedTags (+ DIST_ZERO_1 23)) (= T_javafe_ast_VarInit (+ DIST_ZERO_1 24)) (= T_javafe_ast_ImportDecl (+ DIST_ZERO_1 25)) (= T_java_io_Serializable (+ DIST_ZERO_1 26)) (= T_javafe_ast_Type (+ DIST_ZERO_1 27)) (= T_javafe_ast_FieldDecl (+ DIST_ZERO_1 28)) (= T_javafe_ast_TypeModifierPragma (+ DIST_ZERO_1 29)) (= T_javafe_ast_StmtVec (+ DIST_ZERO_1 30)) (= T_javafe_ast_MethodDecl (+ DIST_ZERO_1 31)) (= T_java_util_Hashtable (+ DIST_ZERO_1 32)) (= T_javafe_parser_ParseUtil (+ DIST_ZERO_1 33)) (= T_java_lang_String (+ DIST_ZERO_1 34)) (= T_javafe_ast_ImportDeclVec (+ DIST_ZERO_1 35)) (= T_javafe_ast_CompilationUnit (+ DIST_ZERO_1 36)) (= T_javafe_util_StackVector (+ DIST_ZERO_1 37)) (= T_java_lang_Float (+ DIST_ZERO_1 38)) (= T_javafe_parser_ParseStmt (+ DIST_ZERO_1 39)) (= T_javafe_util_Location (+ DIST_ZERO_1 40)) (= T_javafe_ast_LexicalPragma (+ DIST_ZERO_1 41)) (= T_javafe_parser_Parse (+ DIST_ZERO_1 42)) (= T_javafe_ast_CatchClause (+ DIST_ZERO_1 43)) (= T_javafe_ast_TypeNameVec (+ DIST_ZERO_1 44)) (= T_javafe_ast_TypeDeclElemVec (+ DIST_ZERO_1 45)) (= T_java_lang_Cloneable (+ DIST_ZERO_1 46)) (= T_javafe_ast_GenericVarDecl (+ DIST_ZERO_1 47)) (= T_javafe_ast_TypeDeclVec (+ DIST_ZERO_1 48)) (= T_javafe_ast_LexicalPragmaVec (+ DIST_ZERO_1 49)) (= T_javafe_ast_Identifier (+ DIST_ZERO_1 50)) (= T_javafe_ast_ModifierPragma (+ DIST_ZERO_1 51)) (= T_java_lang_Long (+ DIST_ZERO_1 52)) (= T_javafe_ast_SingleTypeImportDecl (+ DIST_ZERO_1 53)) (= T_javafe_ast_TypeModifierPragmaVec (+ DIST_ZERO_1 54)) (= T_javafe_ast_OnDemandImportDecl (+ DIST_ZERO_1 55)) (= T_javafe_ast_GenericBlockStmt (+ DIST_ZERO_1 56)) (= T_javafe_ast_Stmt (+ DIST_ZERO_1 57)) (= T_javafe_ast_Expr (+ DIST_ZERO_1 58)) (= T_javafe_ast_InterfaceDecl (+ DIST_ZERO_1 59)) (= T_java_lang_Number (+ DIST_ZERO_1 60)) (= T_javafe_parser_Token (+ DIST_ZERO_1 61)) (= T_javafe_parser_ParseExpr (+ DIST_ZERO_1 62)) (= T_java_lang_Double (+ DIST_ZERO_1 63)) (= T_java_lang_Comparable (+ DIST_ZERO_1 64)) (= T_javafe_parser_PragmaParser (+ DIST_ZERO_1 65)) (= T_javafe_ast_FormalParaDeclVec (+ DIST_ZERO_1 66)) (= T_javafe_ast_TypeName (+ DIST_ZERO_1 67)) (= T_javafe_ast_BlockStmt (+ DIST_ZERO_1 68)) (= T_java_lang_Object (+ DIST_ZERO_1 69)) (= T_javafe_ast_Modifiers (+ DIST_ZERO_1 70)) (= T_javafe_ast_OperatorTags (+ DIST_ZERO_1 71)) (= T_javafe_ast_InitBlock (+ DIST_ZERO_1 72)) (= T_javafe_ast_RoutineDecl (+ DIST_ZERO_1 73)) (= T_javafe_ast_ClassDecl (+ DIST_ZERO_1 74)) (= T_javafe_ast_Name (+ DIST_ZERO_1 75)) (= T_javafe_util_CorrelatedReader (+ DIST_ZERO_1 76)) (= T_javafe_ast_TypeDecl (+ DIST_ZERO_1 77)) (= T_javafe_ast_ASTNode (+ DIST_ZERO_1 78)) (= T_javafe_ast_FormalParaDecl (+ DIST_ZERO_1 79)) (= T_javafe_parser_Lex (+ DIST_ZERO_1 80))) (= true_term (is FLOATLIT_15_42_26 T_int)) (= FLOATLIT_15_42_26 108) (forall (?s Int) (implies (not (= ?s null)) (= true_term (is (S_select seqCatchClause_4_76_46 ?s) T_javafe_util_StackVector)))) (forall (?s Int) (implies (not (= ?s null)) (not (= (S_select seqCatchClause_4_76_46 ?s) null)))) (forall (?s Int) (implies (not (= ?s null)) (= (typeof (S_select seqCatchClause_4_76_46 ?s)) T_javafe_util_StackVector))) (= true_term (is LPAREN_14_37_26 T_int)) (= LPAREN_14_37_26 124) (forall (?s_1_ Int) (implies (not (= ?s_1_ null)) (= true_term (is (S_select seqIdentifier_6_33_46 ?s_1_) T_javafe_util_StackVector)))) (forall (?s_1_ Int) (implies (not (= ?s_1_ null)) (not (= (S_select seqIdentifier_6_33_46 ?s_1_) null)))) (forall (?s_1_ Int) (implies (not (= ?s_1_ null)) (= (typeof (S_select seqIdentifier_6_33_46 ?s_1_)) T_javafe_util_StackVector))) (= true_term (is IMPLEMENTS_14_74_26 T_int)) (= IMPLEMENTS_14_74_26 155) (= true_term (is TYPEMODIFIERPRAGMA_14_28_26 T_int)) (= TYPEMODIFIERPRAGMA_14_28_26 118) (= true_term (is keywordStrings_14_181_30 (array T_java_lang_String))) (not (= keywordStrings_14_181_30 null)) (= (typeof keywordStrings_14_181_30) (array T_java_lang_String)) (= (arrayLength keywordStrings_14_181_30) 51) (= true_term (is EOF_14_17_26 T_int)) (= EOF_14_17_26 111) (= true_term (is CHARLIT_15_41_26 T_int)) (= CHARLIT_15_41_26 107) (= true_term (is RBRACE_14_36_26 T_int)) (= RBRACE_14_36_26 123) (= true_term (is punctuationStrings_14_134_22 (array T_java_lang_String))) (not (= punctuationStrings_14_134_22 null)) (= (typeof punctuationStrings_14_134_22) (array T_java_lang_String)) (= (arrayLength punctuationStrings_14_134_22) 48) (forall (?s_2_ Int) (implies (not (= ?s_2_ null)) (= true_term (is (S_select seqVarInit_5_1153_46 ?s_2_) T_javafe_util_StackVector)))) (forall (?s_2_ Int) (implies (not (= ?s_2_ null)) (not (= (S_select seqVarInit_5_1153_46 ?s_2_) null)))) (forall (?s_2_ Int) (implies (not (= ?s_2_ null)) (= (typeof (S_select seqVarInit_5_1153_46 ?s_2_)) T_javafe_util_StackVector))) (forall (?s_3_ Int) (implies (not (= ?s_3_ null)) (= true_term (is (S_select seqFormalParaDecl_64_46 ?s_3_) T_javafe_util_StackVector)))) (forall (?s_3_ Int) (implies (not (= ?s_3_ null)) (not (= (S_select seqFormalParaDecl_64_46 ?s_3_) null)))) (forall (?s_3_ Int) (implies (not (= ?s_3_ null)) (= (typeof (S_select seqFormalParaDecl_64_46 ?s_3_)) T_javafe_util_StackVector))) (= true_term (is TYPEDECLELEMPRAGMA_14_27_26 T_int)) (= TYPEDECLELEMPRAGMA_14_27_26 117) (forall (?s_4_ Int) (implies (not (= ?s_4_ null)) (= true_term (is (S_select seqStmt_4_70_46 ?s_4_) T_javafe_util_StackVector)))) (forall (?s_4_ Int) (implies (not (= ?s_4_ null)) (not (= (S_select seqStmt_4_70_46 ?s_4_) null)))) (forall (?s_4_ Int) (implies (not (= ?s_4_ null)) (= (typeof (S_select seqStmt_4_70_46 ?s_4_)) T_javafe_util_StackVector))) (= true_term (is IDENT_15_25_26 T_int)) (= IDENT_15_25_26 93) (= true_term (is LONGLIT_15_40_26 T_int)) (= LONGLIT_15_40_26 106) (= true_term (is LBRACE_14_35_26 T_int)) (= LBRACE_14_35_26 122) (= true_term (is EXTENDS_14_66_26 T_int)) (= EXTENDS_14_66_26 147) (= true_term (is STMTPRAGMA_14_26_26 T_int)) (= STMTPRAGMA_14_26_26 116) (forall (?s_5_ Int) (implies (not (= ?s_5_ null)) (= true_term (is (S_select seqExpr_5_1145_46 ?s_5_) T_javafe_util_StackVector)))) (forall (?s_5_ Int) (implies (not (= ?s_5_ null)) (not (= (S_select seqExpr_5_1145_46 ?s_5_) null)))) (forall (?s_5_ Int) (implies (not (= ?s_5_ null)) (= (typeof (S_select seqExpr_5_1145_46 ?s_5_)) T_javafe_util_StackVector))) (= true_term (is CLASS_14_59_26 T_int)) (= CLASS_14_59_26 140) (forall (?s_6_ Int) (implies (not (= ?s_6_ null)) (= true_term (is (S_select seqTypeName_56_46 ?s_6_) T_javafe_util_StackVector)))) (forall (?s_6_ Int) (implies (not (= ?s_6_ null)) (not (= (S_select seqTypeName_56_46 ?s_6_) null)))) (forall (?s_6_ Int) (implies (not (= ?s_6_ null)) (= (typeof (S_select seqTypeName_56_46 ?s_6_)) T_javafe_util_StackVector))) (= true_term (is ASSIGN_16_40_26 T_int)) (= ASSIGN_16_40_26 73) (= true_term (is INTLIT_15_39_26 T_int)) (= INTLIT_15_39_26 105) (= true_term (is SEMICOLON_14_34_26 T_int)) (= SEMICOLON_14_34_26 121) (= true_term (is INTERFACE_14_78_26 T_int)) (= INTERFACE_14_78_26 159) (= true_term (is MODIFIERPRAGMA_14_25_26 T_int)) (= MODIFIERPRAGMA_14_25_26 115) (= true_term (is FIRST_KEYWORD_14_51_26 T_int)) (= FIRST_KEYWORD_14_51_26 133) (= true_term (is ACC_PUBLIC_45_19_26 T_int)) (= ACC_PUBLIC_45_19_26 1) (= true_term (is STAR_16_37_26 T_int)) (= STAR_16_37_26 72) (= true_term (is BOOLEANLIT_15_38_26 T_int)) (= BOOLEANLIT_15_38_26 104) (= true_term (is NONE_45_18_26 T_int)) (= NONE_45_18_26 0) (forall (?s_7_ Int) (implies (not (= ?s_7_ null)) (= true_term (is (S_select seqModifierPragma_7_74_32 ?s_7_) T_javafe_util_StackVector)))) (forall (?s_7_ Int) (implies (not (= ?s_7_ null)) (not (= (S_select seqModifierPragma_7_74_32 ?s_7_) null)))) (forall (?s_7_ Int) (implies (not (= ?s_7_ null)) (= (typeof (S_select seqModifierPragma_7_74_32 ?s_7_)) T_javafe_util_StackVector))) (= true_term (is THROWS_14_96_26 T_int)) (= THROWS_14_96_26 177) (= true_term (is LEXICALPRAGMA_14_24_26 T_int)) (= LEXICALPRAGMA_14_24_26 114) (forall (?s_8_ Int) (implies (not (= ?s_8_ null)) (= true_term (is (S_select seqTypeDecl_80_46 ?s_8_) T_javafe_util_StackVector)))) (forall (?s_8_ Int) (implies (not (= ?s_8_ null)) (not (= (S_select seqTypeDecl_80_46 ?s_8_) null)))) (forall (?s_8_ Int) (implies (not (= ?s_8_ null)) (= (typeof (S_select seqTypeDecl_80_46 ?s_8_)) T_javafe_util_StackVector))) (= true_term (is LAST_KEYWORD_14_103_26 T_int)) (= LAST_KEYWORD_14_103_26 183) (= true_term (is otherCodes_14_202_27 (array T_int))) (not (= otherCodes_14_202_27 null)) (= (typeof otherCodes_14_202_27) (array T_int)) (= (arrayLength otherCodes_14_202_27) 15) (= true_term (is otherStrings_14_193_30 (array T_java_lang_String))) (not (= otherStrings_14_193_30 null)) (= (typeof otherStrings_14_193_30) (array T_java_lang_String)) (= (arrayLength otherStrings_14_193_30) 15) (= true_term (is STRINGLIT_15_44_26 T_int)) (= STRINGLIT_15_44_26 110) (= true_term (is noTokens_14_212_27 T_int)) (= true_term (is PACKAGE_14_83_26 T_int)) (= PACKAGE_14_83_26 164) (= true_term (is COMMA_14_33_26 T_int)) (= COMMA_14_33_26 120) (= true_term (is punctuationCodes_14_164_19 (array T_int))) (not (= punctuationCodes_14_164_19 null)) (= (typeof punctuationCodes_14_164_19) (array T_int)) (= (arrayLength punctuationCodes_14_164_19) 48) (= true_term (is DOUBLELIT_15_43_26 T_int)) (= DOUBLELIT_15_43_26 109) (= true_term (is NULL_46_60_26 T_int)) (= NULL_46_60_26 0) (= true_term (is RPAREN_14_38_26 T_int)) (= RPAREN_14_38_26 125) (= true_term (is NULL_14_82_26 T_int)) (= NULL_14_82_26 163) (= true_term (is IMPORT_14_75_26 T_int)) (= IMPORT_14_75_26 156) (forall (?s_9_ Int) (implies (not (= ?s_9_ null)) (= true_term (is (S_select seqTypeDeclElem_5_1161_46 ?s_9_) T_javafe_util_StackVector)))) (forall (?s_9_ Int) (implies (not (= ?s_9_ null)) (not (= (S_select seqTypeDeclElem_5_1161_46 ?s_9_) null)))) (forall (?s_9_ Int) (implies (not (= ?s_9_ null)) (= (typeof (S_select seqTypeDeclElem_5_1161_46 ?s_9_)) T_javafe_util_StackVector))) (forall (?s_10_ Int) (implies (not (= ?s_10_ null)) (= true_term (is (S_select seqImportDecl_72_46 ?s_10_) T_javafe_util_StackVector)))) (forall (?s_10_ Int) (implies (not (= ?s_10_ null)) (not (= (S_select seqImportDecl_72_46 ?s_10_) null)))) (forall (?s_10_ Int) (implies (not (= ?s_10_ null)) (= (typeof (S_select seqImportDecl_72_46 ?s_10_)) T_javafe_util_StackVector))) (= true_term (is FIELD_14_45_26 T_int)) (= FIELD_14_45_26 130))
:extrafuns ((L_199_6 Int))
:extrafuns ((ecReturn Int))
:extrafuns ((L_212_1 Int))
:extrafuns ((count_pre_116_67_33 Int))
:extrafuns ((count_116_67_33 Int))
:extrafuns ((FLOATLIT_pre_15_42_26 Int))
:extrafuns ((auxVal_pre_12_127_18 Int))
:extrafuns ((auxVal_12_127_18 Int))
:extrafuns ((tokenType_pre_50_90_8 Int))
:extrafuns ((tokenType_50_90_8 Int))
:extrafuns ((seqCatchClause_pre_4_76_46 Int))
:extrafuns ((LPAREN_pre_14_37_26 Int))
:extrafuns ((count_pre_48_67_33 Int))
:extrafuns ((count_48_67_33 Int))
:extrafuns ((nameDotLocs_pre_6_65_28 Int))
:extrafuns ((nameDotLocs_6_65_28 Int))
:extrafuns ((seqIdentifier_pre_6_33_46 Int))
:extrafuns ((loc_pre_23_18_13 Int))
:extrafuns ((loc_23_18_13 Int))
:extrafuns ((locOpenBrace_pre_27_51_13 Int))
:extrafuns ((locOpenBrace_27_51_13 Int))
:extrafuns ((IMPLEMENTS_pre_14_74_26 Int))
:extrafuns ((returnType_pre_53_18_28 Int))
:extrafuns ((returnType_53_18_28 Int))
:extrafuns ((TYPEMODIFIERPRAGMA_pre_14_28_26 Int))
:extrafuns ((keywordStrings_pre_14_181_30 Int))
:extrafuns ((EOF_pre_14_17_26 Int))
:extrafuns ((count_pre_98_67_33 Int))
:extrafuns ((count_98_67_33 Int))
:extrafuns ((CHARLIT_pre_15_41_26 Int))
:extrafuns ((elements_pre_9_72_21 Int))
:extrafuns ((elements_9_72_21 Int))
:extrafuns ((count_pre_39_67_33 Int))
:extrafuns ((count_39_67_33 Int))
:extrafuns ((RBRACE_pre_14_36_26 Int))
:extrafuns ((punctuationStrings_pre_14_134_22 Int))
:extrafuns ((seqVarInit_pre_5_1153_46 Int))
:extrafuns ((seqFormalParaDecl_pre_64_46 Int))
:extrafuns ((endingLoc_pre_12_72_15 Int))
:extrafuns ((endingLoc_12_72_15 Int))
:extrafuns ((locId_pre_55_38_13 Int))
:extrafuns ((locId_55_38_13 Int))
:extrafuns ((elements_pre_29_61_37 Int))
:extrafuns ((elements_29_61_37 Int))
:extrafuns ((locId_pre_47_43_13 Int))
:extrafuns ((locId_47_43_13 Int))
:extrafuns ((TYPEDECLELEMPRAGMA_pre_14_27_26 Int))
:extrafuns ((seqStmt_pre_4_70_46 Int))
:extrafuns ((nameIdLocs_pre_6_62_28 Int))
:extrafuns ((nameIdLocs_6_62_28 Int))
:extrafuns ((parseStreamLexer_pre_104_14 Int))
:extrafuns ((parseStreamLexer_104_14 Int))
:extrafuns ((locOpenBrace_pre_41_22_13 Int))
:extrafuns ((locOpenBrace_41_22_13 Int))
:extrafuns ((IDENT_pre_15_25_26 Int))
:extrafuns ((LONGLIT_pre_15_40_26 Int))
:extrafuns ((currentStackBottom_pre_9_87_33 Int))
:extrafuns ((currentStackBottom_9_87_33 Int))
:extrafuns ((LBRACE_pre_14_35_26 Int))
:extrafuns ((elements_pre_35_61_41 Int))
:extrafuns ((elements_35_61_41 Int))
:extrafuns ((EXTENDS_pre_14_66_26 Int))
:extrafuns ((owner_pre_8_35_28 Int))
:extrafuns ((owner_8_35_28 Int))
:extrafuns ((loc_pre_13_30_13 Int))
:extrafuns ((loc_13_30_13 Int))
:extrafuns ((elems_pre_27_41_39 Int))
:extrafuns ((elems_27_41_39 Int))
:extrafuns ((STMTPRAGMA_pre_14_26_26 Int))
:extrafuns ((seqExpr_pre_5_1145_46 Int))
:extrafuns ((CLASS_pre_14_59_26 Int))
:extrafuns ((seqTypeName_pre_56_46 Int))
:extrafuns ((pmodifiers_pre_27_30_27 Int))
:extrafuns ((pmodifiers_27_30_27 Int))
:extrafuns ((locType_pre_53_21_13 Int))
:extrafuns ((locType_53_21_13 Int))
:extrafuns ((ASSIGN_pre_16_40_26 Int))
:extrafuns ((INTLIT_pre_15_39_26 Int))
:extrafuns ((elements_pre_44_61_43 Int))
:extrafuns ((elements_44_61_43 Int))
:extrafuns ((SEMICOLON_pre_14_34_26 Int))
:extrafuns ((INTERFACE_pre_14_78_26 Int))
:extrafuns ((locId_pre_27_48_13 Int))
:extrafuns ((locId_27_48_13 Int))
:extrafuns ((identifierVal_pre_12_80_22 Int))
:extrafuns ((identifierVal_12_80_22 Int))
:extrafuns ((modifiers_pre_27_28_13 Int))
:extrafuns ((modifiers_27_28_13 Int))
:extrafuns ((modifierPragmas_pre_7_134_29 Int))
:extrafuns ((modifierPragmas_7_134_29 Int))
:extrafuns ((MODIFIERPRAGMA_pre_14_25_26 Int))
:extrafuns ((FIRST_KEYWORD_pre_14_51_26 Int))
:extrafuns ((count_pre_29_67_33 Int))
:extrafuns ((count_29_67_33 Int))
:extrafuns ((elementCount_pre_9_79_33 Int))
:extrafuns ((elementCount_9_79_33 Int))
:extrafuns ((elements_pre_26_61_39 Int))
:extrafuns ((elements_26_61_39 Int))
:extrafuns ((elements_pre_43_61_37 Int))
:extrafuns ((elements_43_61_37 Int))
:extrafuns ((ACC_PUBLIC_pre_45_19_26 Int))
:extrafuns ((syntax_pre_31_28_29 Int))
:extrafuns ((syntax_31_28_29 Int))
:extrafuns ((locCloseBrace_pre_27_54_13 Int))
:extrafuns ((locCloseBrace_27_54_13 Int))
:extrafuns ((locOpenBrace_pre_47_36_13 Int))
:extrafuns ((locOpenBrace_47_36_13 Int))
:extrafuns ((specOnly_pre_27_26_17 Int))
:extrafuns ((specOnly_27_26_17 Int))
:extrafuns ((implicit_pre_47_23_17 Int))
:extrafuns ((implicit_47_23_17 Int))
:extrafuns ((STAR_pre_16_37_26 Int))
:extrafuns ((BOOLEANLIT_pre_15_38_26 Int))
:extrafuns ((m_in_pre_11_212_46 Int))
:extrafuns ((m_in_11_212_46 Int))
:extrafuns ((count_pre_35_67_33 Int))
:extrafuns ((count_35_67_33 Int))
:extrafuns ((vectorCount_pre_9_97_33 Int))
:extrafuns ((vectorCount_9_97_33 Int))
:extrafuns ((body_pre_47_34_19 Int))
:extrafuns ((body_47_34_19 Int))
:extrafuns ((type_pre_55_35_28 Int))
:extrafuns ((type_55_35_28 Int))
:extrafuns ((ttype_pre_12_52_15 Int))
:extrafuns ((ttype_12_52_15 Int))
:extrafuns ((NONE_pre_45_18_26 Int))
:extrafuns ((seqModifierPragma_pre_7_74_32 Int))
:extrafuns ((THROWS_pre_14_96_26 Int))
:extrafuns ((loc_pre_47_40_13 Int))
:extrafuns ((loc_47_40_13 Int))
:extrafuns ((LEXICALPRAGMA_pre_14_24_26 Int))
:extrafuns ((seqTypeDecl_pre_80_46 Int))
:extrafuns ((LAST_KEYWORD_pre_14_103_26 Int))
:extrafuns ((elements_pre_116_61_47 Int))
:extrafuns ((elements_116_61_47 Int))
:extrafuns ((otherCodes_pre_14_202_27 Int))
:extrafuns ((otherStrings_pre_14_193_30 Int))
:extrafuns ((STRINGLIT_pre_15_44_26 Int))
:extrafuns ((elements_pre_48_61_43 Int))
:extrafuns ((elements_48_61_43 Int))
:extrafuns ((noTokens_pre_14_212_27 Int))
:extrafuns ((startingLoc_pre_12_65_15 Int))
:extrafuns ((startingLoc_12_65_15 Int))
:extrafuns ((PACKAGE_pre_14_83_26 Int))
:extrafuns ((count_pre_44_67_33 Int))
:extrafuns ((count_44_67_33 Int))
:extrafuns ((COMMA_pre_14_33_26 Int))
:extrafuns ((elements_pre_98_61_42 Int))
:extrafuns ((elements_98_61_42 Int))
:extrafuns ((count_pre_26_67_33 Int))
:extrafuns ((count_26_67_33 Int))
:extrafuns ((locCloseBrace_pre_41_25_13 Int))
:extrafuns ((locCloseBrace_41_25_13 Int))
:extrafuns ((count_pre_43_67_33 Int))
:extrafuns ((count_43_67_33 Int))
:extrafuns ((punctuationCodes_pre_14_164_19 Int))
:extrafuns ((DOUBLELIT_pre_15_43_26 Int))
:extrafuns ((elements_pre_39_61_33 Int))
:extrafuns ((elements_39_61_33 Int))
:extrafuns ((NULL_pre_46_60_26 Int))
:extrafuns ((RPAREN_pre_14_38_26 Int))
:extrafuns ((loc_pre_84_22_13 Int))
:extrafuns ((loc_84_22_13 Int))
:extrafuns ((NULL_pre_14_82_26 Int))
:extrafuns ((IMPORT_pre_14_75_26 Int))
:extrafuns ((loc_pre_27_45_13 Int))
:extrafuns ((loc_27_45_13 Int))
:extrafuns ((code_pre_11_1294_15 Int))
:extrafuns ((code_11_1294_15 Int))
:extrafuns ((seqTypeDeclElem_pre_5_1161_46 Int))
:extrafuns ((elementType_pre_9_43_27 Int))
:extrafuns ((elementType_9_43_27 Int))
:extrafuns ((seqImportDecl_pre_72_46 Int))
:extrafuns ((FIELD_pre_14_45_26 Int))
:extrafuns ((elems_pre Int))
:extrafuns ((elems Int))
:extrafuns ((LS Int))
:extrafuns ((alloc_pre Int))
:extrafuns ((this Int))
:extrafuns ((l_195_36 Int))
:extrafuns ((specOnly_195_47 Int))
:extrafuns ((this_198_22_198_22 Int))
:extrafuns ((vectorCount_198_22_9_282_17 Int))
:extrafuns ((after_198_22_198_22_9_282_17 Int))
:extrafuns ((currentStackBottom_198_22_9_282_30 Int))
:extrafuns ((after_198_22_198_22_9_282_30 Int))
:extrafuns ((EC_198_22_198_22 Int))
:extrafuns ((identifierVal_loopold_12_80_22 Int))
:extrafuns ((ttype_loopold_12_52_15 Int))
:extrafuns ((EC_loopold Int))
:extrafuns ((auxVal_loopold_12_127_18 Int))
:extrafuns ((elementCount_loopold_9_79_33 Int))
:extrafuns ((pragma_199_6_0_200_1 Int))
:extrafuns ((tmp0_seqTypeDeclElem_199_6_0_201_1 Int))
:extrafuns ((elementCount_199_6_0_201_17_9_195_17 Int))
:extrafuns ((after_201_17_199_6_0_201_17_9_195_17 Int))
:extrafuns ((EC_199_6_0_201_17_201_17 Int))
:extrafuns ((ttype_199_6_0_202_3_11_372_15 Int))
:extrafuns ((after_202_3_199_6_0_202_3_11_372_15 Int))
:extrafuns ((auxVal_199_6_0_202_3_11_372_22 Int))
:extrafuns ((after_202_3_199_6_0_202_3_11_372_22 Int))
:extrafuns ((identifierVal_199_6_0_202_3_11_372_30 Int))
:extrafuns ((after_202_3_199_6_0_202_3_11_372_30 Int))
:extrafuns ((RES_199_6_0_202_3_202_3 Int))
:extrafuns ((EC_199_6_0_202_3_202_3 Int))
:extrafuns ((identifierVal_12_80_22_1_ Int))
:extrafuns ((ttype_12_52_15_1_ Int))
:extrafuns ((auxVal_12_127_18_1_ Int))
:extrafuns ((elementCount_9_79_33_1_ Int))
:extrafuns ((RES Int))
:extrafuns ((RES_198_22_198_22 Int))
:extrafuns ((identifierVal_12_80_22_2_ Int))
:extrafuns ((ttype_12_52_15_2_ Int))
:extrafuns ((EC Int))
:extrafuns ((auxVal_12_127_18_2_ Int))
:extrafuns ((elementCount_9_79_33_2_ Int))
:extrafuns ((RES_1_ Int))
:extrafuns ((s_204_31_204_31_35_145_79 Int))
:extrafuns ((vectorCount_204_31_35_137_19 Int))
:extrafuns ((after_204_31_204_31_35_137_17 Int))
:extrafuns ((elementCount_204_31_35_139_19 Int))
:extrafuns ((after_204_31_204_31_35_139_17 Int))
:extrafuns ((currentStackBottom_204_31_35_139_35 Int))
:extrafuns ((after_204_31_204_31_35_139_33 Int))
:extrafuns ((RES_204_31_204_31 Int))
:extrafuns ((EC_204_31_204_31 Int))
:extrafuns ((identifierVal_12_80_22_3_ Int))
:extrafuns ((ttype_12_52_15_3_ Int))
:extrafuns ((EC_1_ Int))
:extrafuns ((auxVal_12_127_18_3_ Int))
:extrafuns ((extras_196_20 Int))
:extrafuns ((RES_2_ Int))
:extrafuns ((EC_2_ Int))
:extrafuns ((RES_3_ Int))
:extrafuns ((loc_206_4 Int))
:extrafuns ((modifierPragmas_207_20_7_151_15 Int))
:extrafuns ((after_207_20_207_20_7_151_15 Int))
:extrafuns ((RES_207_20_207_20 Int))
:extrafuns ((EC_207_20_207_20 Int))
:extrafuns ((modifierPragmas_208_4 Int))
:extrafuns ((ttype_210_1_4_87_17 Int))
:extrafuns ((after_210_1_210_1_4_87_17 Int))
:extrafuns ((RES_210_1_210_1 Int))
:extrafuns ((EC_210_1_210_1 Int))
:extrafuns ((EC_loopold_1_ Int))
:extrafuns ((i_loopold_212_10 Int))
:extrafuns ((RES_212_1_0_212_28_212_28 Int))
:extrafuns ((EC_212_1_0_212_28_212_28 Int))
:extrafuns ((RES_212_1_0_213_10_213_10 Int))
:extrafuns ((EC_212_1_0_213_10_213_10 Int))
:extrafuns ((EC_212_1_0_213_23_213_23 Int))
:extrafuns ((i_212_1_0_212_36 Int))
:extrafuns ((RES_4_ Int))
:extrafuns ((RES_212_1_1_212_28_212_28 Int))
:extrafuns ((EC_212_1_1_212_28_212_28 Int))
:extrafuns ((EC_3_ Int))
:extrafuns ((RES_5_ Int))
:extrafuns ((vec_215_8_215_8_35_308_43 Int))
:extrafuns ((count_215_8_35_306_15 Int))
:extrafuns ((after_215_8_215_8_35_306_15 Int))
:extrafuns ((EC_215_8_215_8 Int))
:extrafuns ((EC_196_4 Int))
:extrafuns ((RES_196_4 Int))
:extrafuns ((elems_216_8 Int))
:extrafuns ((EC_4_ Int))
:extrafuns ((RES_6_ Int))
:extrafuns ((RES_215_8_215_8 Int))
:formula (not (implies (and (distinct L_199_6 ecReturn L_212_1)) (implies (and (= count_pre_116_67_33 count_116_67_33) (= count_116_67_33 (asField count_116_67_33 T_int)) (= FLOATLIT_pre_15_42_26 FLOATLIT_15_42_26) (= true_term (is FLOATLIT_15_42_26 T_int)) (= auxVal_pre_12_127_18 auxVal_12_127_18) (= auxVal_12_127_18 (asField auxVal_12_127_18 T_java_lang_Object)) (< (fClosedTime auxVal_12_127_18) alloc) (= tokenType_pre_50_90_8 tokenType_50_90_8) (= tokenType_50_90_8 (asField tokenType_50_90_8 T_int)) (= seqCatchClause_pre_4_76_46 seqCatchClause_4_76_46) (= seqCatchClause_4_76_46 (asField seqCatchClause_4_76_46 T_javafe_util_StackVector)) (< (fClosedTime seqCatchClause_4_76_46) alloc) (forall (?s Int) (implies (not (= ?s null)) (not (= (S_select seqCatchClause_4_76_46 ?s) null)))) (= LPAREN_pre_14_37_26 LPAREN_14_37_26) (= true_term (is LPAREN_14_37_26 T_int)) (= count_pre_48_67_33 count_48_67_33) (= count_48_67_33 (asField count_48_67_33 T_int)) (= nameDotLocs_pre_6_65_28 nameDotLocs_6_65_28) (= nameDotLocs_6_65_28 (asField nameDotLocs_6_65_28 (array T_int))) (< (fClosedTime nameDotLocs_6_65_28) alloc) (forall (?s_1_ Int) (implies (not (= ?s_1_ null)) (not (= (S_select nameDotLocs_6_65_28 ?s_1_) null)))) (= seqIdentifier_pre_6_33_46 seqIdentifier_6_33_46) (= seqIdentifier_6_33_46 (asField seqIdentifier_6_33_46 T_javafe_util_StackVector)) (< (fClosedTime seqIdentifier_6_33_46) alloc) (forall (?s_2_ Int) (implies (not (= ?s_2_ null)) (not (= (S_select seqIdentifier_6_33_46 ?s_2_) null)))) (= loc_pre_23_18_13 loc_23_18_13) (= loc_23_18_13 (asField loc_23_18_13 T_int)) (= locOpenBrace_pre_27_51_13 locOpenBrace_27_51_13) (= locOpenBrace_27_51_13 (asField locOpenBrace_27_51_13 T_int)) (= IMPLEMENTS_pre_14_74_26 IMPLEMENTS_14_74_26) (= true_term (is IMPLEMENTS_14_74_26 T_int)) (= returnType_pre_53_18_28 returnType_53_18_28) (= returnType_53_18_28 (asField returnType_53_18_28 T_javafe_ast_Type)) (< (fClosedTime returnType_53_18_28) alloc) (forall (?s_3_ Int) (implies (not (= ?s_3_ null)) (not (= (S_select returnType_53_18_28 ?s_3_) null)))) (= TYPEMODIFIERPRAGMA_pre_14_28_26 TYPEMODIFIERPRAGMA_14_28_26) (= true_term (is TYPEMODIFIERPRAGMA_14_28_26 T_int)) (= keywordStrings_pre_14_181_30 keywordStrings_14_181_30) (= true_term (is keywordStrings_14_181_30 (array T_java_lang_String))) (= true_term (isAllocated keywordStrings_14_181_30 alloc)) (= EOF_pre_14_17_26 EOF_14_17_26) (= true_term (is EOF_14_17_26 T_int)) (= count_pre_98_67_33 count_98_67_33) (= count_98_67_33 (asField count_98_67_33 T_int)) (= CHARLIT_pre_15_41_26 CHARLIT_15_41_26) (= true_term (is CHARLIT_15_41_26 T_int)) (= elements_pre_9_72_21 elements_9_72_21) (= elements_9_72_21 (asField elements_9_72_21 (array T_java_lang_Object))) (< (fClosedTime elements_9_72_21) alloc) (= count_pre_39_67_33 count_39_67_33) (= count_39_67_33 (asField count_39_67_33 T_int)) (= RBRACE_pre_14_36_26 RBRACE_14_36_26) (= true_term (is RBRACE_14_36_26 T_int)) (= punctuationStrings_pre_14_134_22 punctuationStrings_14_134_22) (= true_term (is punctuationStrings_14_134_22 (array T_java_lang_String))) (= true_term (isAllocated punctuationStrings_14_134_22 alloc)) (= seqVarInit_pre_5_1153_46 seqVarInit_5_1153_46) (= seqVarInit_5_1153_46 (asField seqVarInit_5_1153_46 T_javafe_util_StackVector)) (< (fClosedTime seqVarInit_5_1153_46) alloc) (forall (?s_4_ Int) (implies (not (= ?s_4_ null)) (not (= (S_select seqVarInit_5_1153_46 ?s_4_) null)))) (= seqFormalParaDecl_pre_64_46 seqFormalParaDecl_64_46) (= seqFormalParaDecl_64_46 (asField seqFormalParaDecl_64_46 T_javafe_util_StackVector)) (< (fClosedTime seqFormalParaDecl_64_46) alloc) (forall (?s_5_ Int) (implies (not (= ?s_5_ null)) (not (= (S_select seqFormalParaDecl_64_46 ?s_5_) null)))) (= endingLoc_pre_12_72_15 endingLoc_12_72_15) (= endingLoc_12_72_15 (asField endingLoc_12_72_15 T_int)) (= locId_pre_55_38_13 locId_55_38_13) (= locId_55_38_13 (asField locId_55_38_13 T_int)) (= elements_pre_29_61_37 elements_29_61_37) (= elements_29_61_37 (asField elements_29_61_37 (array T_javafe_ast_TypeDecl))) (< (fClosedTime elements_29_61_37) alloc) (forall (?s_6_ Int) (implies (not (= ?s_6_ null)) (not (= (S_select elements_29_61_37 ?s_6_) null)))) (= locId_pre_47_43_13 locId_47_43_13) (= locId_47_43_13 (asField locId_47_43_13 T_int)) (= TYPEDECLELEMPRAGMA_pre_14_27_26 TYPEDECLELEMPRAGMA_14_27_26) (= true_term (is TYPEDECLELEMPRAGMA_14_27_26 T_int)) (= seqStmt_pre_4_70_46 seqStmt_4_70_46) (= seqStmt_4_70_46 (asField seqStmt_4_70_46 T_javafe_util_StackVector)) (< (fClosedTime seqStmt_4_70_46) alloc) (forall (?s_7_ Int) (implies (not (= ?s_7_ null)) (not (= (S_select seqStmt_4_70_46 ?s_7_) null)))) (= nameIdLocs_pre_6_62_28 nameIdLocs_6_62_28) (= nameIdLocs_6_62_28 (asField nameIdLocs_6_62_28 (array T_int))) (< (fClosedTime nameIdLocs_6_62_28) alloc) (forall (?s_8_ Int) (implies (not (= ?s_8_ null)) (not (= (S_select nameIdLocs_6_62_28 ?s_8_) null)))) (= parseStreamLexer_pre_104_14 parseStreamLexer_104_14) (= parseStreamLexer_104_14 (asField parseStreamLexer_104_14 T_javafe_parser_Lex)) (< (fClosedTime parseStreamLexer_104_14) alloc) (= locOpenBrace_pre_41_22_13 locOpenBrace_41_22_13) (= locOpenBrace_41_22_13 (asField locOpenBrace_41_22_13 T_int)) (= IDENT_pre_15_25_26 IDENT_15_25_26) (= true_term (is IDENT_15_25_26 T_int)) (= LONGLIT_pre_15_40_26 LONGLIT_15_40_26) (= true_term (is LONGLIT_15_40_26 T_int)) (= currentStackBottom_pre_9_87_33 currentStackBottom_9_87_33) (= currentStackBottom_9_87_33 (asField currentStackBottom_9_87_33 T_int)) (= LBRACE_pre_14_35_26 LBRACE_14_35_26) (= true_term (is LBRACE_14_35_26 T_int)) (= elements_pre_35_61_41 elements_35_61_41) (= elements_35_61_41 (asField elements_35_61_41 (array T_javafe_ast_TypeDeclElem))) (< (fClosedTime elements_35_61_41) alloc) (forall (?s_9_ Int) (implies (not (= ?s_9_ null)) (not (= (S_select elements_35_61_41 ?s_9_) null)))) (= EXTENDS_pre_14_66_26 EXTENDS_14_66_26) (= true_term (is EXTENDS_14_66_26 T_int)) (= owner_pre_8_35_28 owner_8_35_28) (= owner_8_35_28 (asField owner_8_35_28 T_java_lang_Object)) (< (fClosedTime owner_8_35_28) alloc) (= loc_pre_13_30_13 loc_13_30_13) (= loc_13_30_13 (asField loc_13_30_13 T_int)) (= elems_pre_27_41_39 elems_27_41_39) (= elems_27_41_39 (asField elems_27_41_39 T_javafe_ast_TypeDeclElemVec)) (< (fClosedTime elems_27_41_39) alloc) (forall (?s_10_ Int) (implies (not (= ?s_10_ null)) (not (= (S_select elems_27_41_39 ?s_10_) null)))) (= STMTPRAGMA_pre_14_26_26 STMTPRAGMA_14_26_26) (= true_term (is STMTPRAGMA_14_26_26 T_int)) (= seqExpr_pre_5_1145_46 seqExpr_5_1145_46) (= seqExpr_5_1145_46 (asField seqExpr_5_1145_46 T_javafe_util_StackVector)) (< (fClosedTime seqExpr_5_1145_46) alloc) (forall (?s_11_ Int) (implies (not (= ?s_11_ null)) (not (= (S_select seqExpr_5_1145_46 ?s_11_) null)))) (= CLASS_pre_14_59_26 CLASS_14_59_26) (= true_term (is CLASS_14_59_26 T_int)) (= seqTypeName_pre_56_46 seqTypeName_56_46) (= seqTypeName_56_46 (asField seqTypeName_56_46 T_javafe_util_StackVector)) (< (fClosedTime seqTypeName_56_46) alloc) (forall (?s_12_ Int) (implies (not (= ?s_12_ null)) (not (= (S_select seqTypeName_56_46 ?s_12_) null)))) (= pmodifiers_pre_27_30_27 pmodifiers_27_30_27) (= pmodifiers_27_30_27 (asField pmodifiers_27_30_27 T_javafe_ast_ModifierPragmaVec)) (< (fClosedTime pmodifiers_27_30_27) alloc) (= locType_pre_53_21_13 locType_53_21_13) (= locType_53_21_13 (asField locType_53_21_13 T_int)) (= ASSIGN_pre_16_40_26 ASSIGN_16_40_26) (= true_term (is ASSIGN_16_40_26 T_int)) (= INTLIT_pre_15_39_26 INTLIT_15_39_26) (= true_term (is INTLIT_15_39_26 T_int)) (= elements_pre_44_61_43 elements_44_61_43) (= elements_44_61_43 (asField elements_44_61_43 (array T_javafe_ast_FormalParaDecl))) (< (fClosedTime elements_44_61_43) alloc) (forall (?s_13_ Int) (implies (not (= ?s_13_ null)) (not (= (S_select elements_44_61_43 ?s_13_) null)))) (= SEMICOLON_pre_14_34_26 SEMICOLON_14_34_26) (= true_term (is SEMICOLON_14_34_26 T_int)) (= INTERFACE_pre_14_78_26 INTERFACE_14_78_26) (= true_term (is INTERFACE_14_78_26 T_int)) (= locId_pre_27_48_13 locId_27_48_13) (= locId_27_48_13 (asField locId_27_48_13 T_int)) (= identifierVal_pre_12_80_22 identifierVal_12_80_22) (= identifierVal_12_80_22 (asField identifierVal_12_80_22 T_javafe_ast_Identifier)) (< (fClosedTime identifierVal_12_80_22) alloc) (= modifiers_pre_27_28_13 modifiers_27_28_13) (= modifiers_27_28_13 (asField modifiers_27_28_13 T_int)) (= modifierPragmas_pre_7_134_29 modifierPragmas_7_134_29) (= modifierPragmas_7_134_29 (asField modifierPragmas_7_134_29 T_javafe_ast_ModifierPragmaVec)) (< (fClosedTime modifierPragmas_7_134_29) alloc) (= MODIFIERPRAGMA_pre_14_25_26 MODIFIERPRAGMA_14_25_26) (= true_term (is MODIFIERPRAGMA_14_25_26 T_int)) (= FIRST_KEYWORD_pre_14_51_26 FIRST_KEYWORD_14_51_26) (= true_term (is FIRST_KEYWORD_14_51_26 T_int)) (= count_pre_29_67_33 count_29_67_33) (= count_29_67_33 (asField count_29_67_33 T_int)) (= elementCount_pre_9_79_33 elementCount_9_79_33) (= elementCount_9_79_33 (asField elementCount_9_79_33 T_int)) (= elements_pre_26_61_39 elements_26_61_39) (= elements_26_61_39 (asField elements_26_61_39 (array T_javafe_ast_ImportDecl))) (< (fClosedTime elements_26_61_39) alloc) (forall (?s_14_ Int) (implies (not (= ?s_14_ null)) (not (= (S_select elements_26_61_39 ?s_14_) null)))) (= elements_pre_43_61_37 elements_43_61_37) (= elements_43_61_37 (asField elements_43_61_37 (array T_javafe_ast_TypeName))) (< (fClosedTime elements_43_61_37) alloc) (forall (?s_15_ Int) (implies (not (= ?s_15_ null)) (not (= (S_select elements_43_61_37 ?s_15_) null)))) (= ACC_PUBLIC_pre_45_19_26 ACC_PUBLIC_45_19_26) (= true_term (is ACC_PUBLIC_45_19_26 T_int)) (= syntax_pre_31_28_29 syntax_31_28_29) (= syntax_31_28_29 (asField syntax_31_28_29 T_boolean)) (= locCloseBrace_pre_27_54_13 locCloseBrace_27_54_13) (= locCloseBrace_27_54_13 (asField locCloseBrace_27_54_13 T_int)) (= locOpenBrace_pre_47_36_13 locOpenBrace_47_36_13) (= locOpenBrace_47_36_13 (asField locOpenBrace_47_36_13 T_int)) (= specOnly_pre_27_26_17 specOnly_27_26_17) (= specOnly_27_26_17 (asField specOnly_27_26_17 T_boolean)) (= implicit_pre_47_23_17 implicit_47_23_17) (= implicit_47_23_17 (asField implicit_47_23_17 T_boolean)) (= STAR_pre_16_37_26 STAR_16_37_26) (= true_term (is STAR_16_37_26 T_int)) (= BOOLEANLIT_pre_15_38_26 BOOLEANLIT_15_38_26) (= true_term (is BOOLEANLIT_15_38_26 T_int)) (= m_in_pre_11_212_46 m_in_11_212_46) (= m_in_11_212_46 (asField m_in_11_212_46 T_javafe_util_CorrelatedReader)) (< (fClosedTime m_in_11_212_46) alloc) (= count_pre_35_67_33 count_35_67_33) (= count_35_67_33 (asField count_35_67_33 T_int)) (= vectorCount_pre_9_97_33 vectorCount_9_97_33) (= vectorCount_9_97_33 (asField vectorCount_9_97_33 T_int)) (= body_pre_47_34_19 body_47_34_19) (= body_47_34_19 (asField body_47_34_19 T_javafe_ast_BlockStmt)) (< (fClosedTime body_47_34_19) alloc) (= type_pre_55_35_28 type_55_35_28) (= type_55_35_28 (asField type_55_35_28 T_javafe_ast_Type)) (< (fClosedTime type_55_35_28) alloc) (forall (?s_16_ Int) (implies (not (= ?s_16_ null)) (not (= (S_select type_55_35_28 ?s_16_) null)))) (= ttype_pre_12_52_15 ttype_12_52_15) (= ttype_12_52_15 (asField ttype_12_52_15 T_int)) (= NONE_pre_45_18_26 NONE_45_18_26) (= true_term (is NONE_45_18_26 T_int)) (= seqModifierPragma_pre_7_74_32 seqModifierPragma_7_74_32) (= seqModifierPragma_7_74_32 (asField seqModifierPragma_7_74_32 T_javafe_util_StackVector)) (< (fClosedTime seqModifierPragma_7_74_32) alloc) (= THROWS_pre_14_96_26 THROWS_14_96_26) (= true_term (is THROWS_14_96_26 T_int)) (= loc_pre_47_40_13 loc_47_40_13) (= loc_47_40_13 (asField loc_47_40_13 T_int)) (= LEXICALPRAGMA_pre_14_24_26 LEXICALPRAGMA_14_24_26) (= true_term (is LEXICALPRAGMA_14_24_26 T_int)) (= seqTypeDecl_pre_80_46 seqTypeDecl_80_46) (= seqTypeDecl_80_46 (asField seqTypeDecl_80_46 T_javafe_util_StackVector)) (< (fClosedTime seqTypeDecl_80_46) alloc) (forall (?s_17_ Int) (implies (not (= ?s_17_ null)) (not (= (S_select seqTypeDecl_80_46 ?s_17_) null)))) (= LAST_KEYWORD_pre_14_103_26 LAST_KEYWORD_14_103_26) (= true_term (is LAST_KEYWORD_14_103_26 T_int)) (= elements_pre_116_61_47 elements_116_61_47) (= elements_116_61_47 (asField elements_116_61_47 (array T_javafe_ast_TypeModifierPragma))) (< (fClosedTime elements_116_61_47) alloc) (forall (?s_18_ Int) (implies (not (= ?s_18_ null)) (not (= (S_select elements_116_61_47 ?s_18_) null)))) (= otherCodes_pre_14_202_27 otherCodes_14_202_27) (= true_term (is otherCodes_14_202_27 (array T_int))) (= true_term (isAllocated otherCodes_14_202_27 alloc)) (= otherStrings_pre_14_193_30 otherStrings_14_193_30) (= true_term (is otherStrings_14_193_30 (array T_java_lang_String))) (= true_term (isAllocated otherStrings_14_193_30 alloc)) (= STRINGLIT_pre_15_44_26 STRINGLIT_15_44_26) (= true_term (is STRINGLIT_15_44_26 T_int)) (= elements_pre_48_61_43 elements_48_61_43) (= elements_48_61_43 (asField elements_48_61_43 (array T_javafe_ast_ModifierPragma))) (< (fClosedTime elements_48_61_43) alloc) (forall (?s_19_ Int) (implies (not (= ?s_19_ null)) (not (= (S_select elements_48_61_43 ?s_19_) null)))) (= noTokens_pre_14_212_27 noTokens_14_212_27) (= true_term (is noTokens_14_212_27 T_int)) (= startingLoc_pre_12_65_15 startingLoc_12_65_15) (= startingLoc_12_65_15 (asField startingLoc_12_65_15 T_int)) (= PACKAGE_pre_14_83_26 PACKAGE_14_83_26) (= true_term (is PACKAGE_14_83_26 T_int)) (= count_pre_44_67_33 count_44_67_33) (= count_44_67_33 (asField count_44_67_33 T_int)) (= COMMA_pre_14_33_26 COMMA_14_33_26) (= true_term (is COMMA_14_33_26 T_int)) (= elements_pre_98_61_42 elements_98_61_42) (= elements_98_61_42 (asField elements_98_61_42 (array T_javafe_ast_LexicalPragma))) (< (fClosedTime elements_98_61_42) alloc) (forall (?s_20_ Int) (implies (not (= ?s_20_ null)) (not (= (S_select elements_98_61_42 ?s_20_) null)))) (= count_pre_26_67_33 count_26_67_33) (= count_26_67_33 (asField count_26_67_33 T_int)) (= locCloseBrace_pre_41_25_13 locCloseBrace_41_25_13) (= locCloseBrace_41_25_13 (asField locCloseBrace_41_25_13 T_int)) (= count_pre_43_67_33 count_43_67_33) (= count_43_67_33 (asField count_43_67_33 T_int)) (= punctuationCodes_pre_14_164_19 punctuationCodes_14_164_19) (= true_term (is punctuationCodes_14_164_19 (array T_int))) (= true_term (isAllocated punctuationCodes_14_164_19 alloc)) (= DOUBLELIT_pre_15_43_26 DOUBLELIT_15_43_26) (= true_term (is DOUBLELIT_15_43_26 T_int)) (= elements_pre_39_61_33 elements_39_61_33) (= elements_39_61_33 (asField elements_39_61_33 (array T_javafe_ast_Stmt))) (< (fClosedTime elements_39_61_33) alloc) (forall (?s_21_ Int) (implies (not (= ?s_21_ null)) (not (= (S_select elements_39_61_33 ?s_21_) null)))) (= NULL_pre_46_60_26 NULL_46_60_26) (= true_term (is NULL_46_60_26 T_int)) (= RPAREN_pre_14_38_26 RPAREN_14_38_26) (= true_term (is RPAREN_14_38_26 T_int)) (= loc_pre_84_22_13 loc_84_22_13) (= loc_84_22_13 (asField loc_84_22_13 T_int)) (= NULL_pre_14_82_26 NULL_14_82_26) (= true_term (is NULL_14_82_26 T_int)) (= IMPORT_pre_14_75_26 IMPORT_14_75_26) (= true_term (is IMPORT_14_75_26 T_int)) (= loc_pre_27_45_13 loc_27_45_13) (= loc_27_45_13 (asField loc_27_45_13 T_int)) (= code_pre_11_1294_15 code_11_1294_15) (= code_11_1294_15 (asField code_11_1294_15 T_int)) (= seqTypeDeclElem_pre_5_1161_46 seqTypeDeclElem_5_1161_46) (= seqTypeDeclElem_5_1161_46 (asField seqTypeDeclElem_5_1161_46 T_javafe_util_StackVector)) (< (fClosedTime seqTypeDeclElem_5_1161_46) alloc) (forall (?s_22_ Int) (implies (not (= ?s_22_ null)) (not (= (S_select seqTypeDeclElem_5_1161_46 ?s_22_) null)))) (= elementType_pre_9_43_27 elementType_9_43_27) (= elementType_9_43_27 (asField elementType_9_43_27 T__TYPE)) (= seqImportDecl_pre_72_46 seqImportDecl_72_46) (= seqImportDecl_72_46 (asField seqImportDecl_72_46 T_javafe_util_StackVector)) (< (fClosedTime seqImportDecl_72_46) alloc) (forall (?s_23_ Int) (implies (not (= ?s_23_ null)) (not (= (S_select seqImportDecl_72_46 ?s_23_) null)))) (= FIELD_pre_14_45_26 FIELD_14_45_26) (= true_term (is FIELD_14_45_26 T_int)) (= elems_pre elems) (= elems (asElems elems)) (< (eClosedTime elems) alloc) (= LS (asLockSet LS)) (= alloc_pre alloc)) (not (and (= true_term (is this T_javafe_parser_Parse)) (= true_term (isAllocated this alloc)) (not (= this null)) (= true_term (is l_195_36 T_javafe_parser_Lex)) (= true_term (isAllocated l_195_36 alloc)) (= true_term (is specOnly_195_47 T_boolean)) (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)) (forall (?brokenObj Int) (implies (and (= true_term (is ?brokenObj T_javafe_ast_ImportDecl)) (not (= ?brokenObj null))) (not (= (S_select loc_23_18_13 ?brokenObj) NULL_46_60_26)))) (forall (?brokenObj_1_ Int) (implies (and (= true_term (is ?brokenObj_1_ T_javafe_parser_Token)) (not (= ?brokenObj_1_ null))) (not (= (S_select endingLoc_12_72_15 ?brokenObj_1_) NULL_46_60_26)))) (forall (?brokenObj_2_ Int) (implies (and (= true_term (is ?brokenObj_2_ T_javafe_parser_Parse)) (not (= ?brokenObj_2_ null))) (= (S_select elementType_9_43_27 (S_select seqImportDecl_72_46 ?brokenObj_2_)) T_javafe_ast_ImportDecl))) (forall (?brokenObj_3_ Int) (implies (and (= true_term (is ?brokenObj_3_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_3_ null))) (forall (?i_35_62_31 Int) (implies (and (<= 0 ?i_35_62_31) (< ?i_35_62_31 (S_select count_35_67_33 ?brokenObj_3_))) (not (= (S_select (S_select elems (S_select elements_35_61_41 ?brokenObj_3_)) ?i_35_62_31) null)))))) (= true_term (nonnullelements punctuationStrings_14_134_22 elems)) (forall (?brokenObj_4_ Int) (implies (and (= true_term (is ?brokenObj_4_ T_javafe_parser_ParseType)) (not (= ?brokenObj_4_ null))) (= (S_select owner_8_35_28 (S_select nameIdLocs_6_62_28 ?brokenObj_4_)) ?brokenObj_4_))) (forall (?brokenObj_5_ Int) (implies (and (= true_term (is ?brokenObj_5_ T_javafe_ast_ModifierPragmaVec)) (not (= ?brokenObj_5_ null))) (= (S_select owner_8_35_28 (S_select elements_48_61_43 ?brokenObj_5_)) ?brokenObj_5_))) (forall (?brokenObj_6_ Int) (implies (and (= true_term (is ?brokenObj_6_ T_javafe_util_StackVector)) (not (= ?brokenObj_6_ null))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33 ?brokenObj_6_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_6_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_6_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_6_)) true_term)))))) (forall (?i_14_147_29 Int) (implies (and (<= 0 ?i_14_147_29) (<= ?i_14_147_29 (arrayLength punctuationCodes_14_164_19))) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_147_29) NULL_14_82_26)))) (forall (?brokenObj_7_ Int) (implies (and (= true_term (is ?brokenObj_7_ T_javafe_parser_ParseExpr)) (not (= ?brokenObj_7_ null))) (= (S_select owner_8_35_28 (S_select seqVarInit_5_1153_46 ?brokenObj_7_)) ?brokenObj_7_))) (forall (?brokenObj_8_ Int) (implies (and (= true_term (is ?brokenObj_8_ T_javafe_ast_TypeDecl)) (not (= ?brokenObj_8_ null))) (not (= (S_select loc_27_45_13 ?brokenObj_8_) NULL_46_60_26)))) (forall (?brokenObj_9_ Int) (implies (and (= true_term (is ?brokenObj_9_ T_javafe_parser_PunctuationPrefixTree)) (not (= ?brokenObj_9_ null))) (and (not (= (S_select code_11_1294_15 ?brokenObj_9_) IDENT_15_25_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) BOOLEANLIT_15_38_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) INTLIT_15_39_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) LONGLIT_15_40_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) FLOATLIT_15_42_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) DOUBLELIT_15_43_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) STRINGLIT_15_44_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) CHARLIT_15_41_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) LEXICALPRAGMA_14_24_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) MODIFIERPRAGMA_14_25_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) STMTPRAGMA_14_26_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) TYPEDECLELEMPRAGMA_14_27_26)) (not (= (S_select code_11_1294_15 ?brokenObj_9_) TYPEMODIFIERPRAGMA_14_28_26))))) (forall (?brokenObj_10_ Int) (implies (and (= true_term (is ?brokenObj_10_ T_javafe_parser_ParseUtil)) (not (= ?brokenObj_10_ null))) (= (S_select owner_8_35_28 (S_select seqModifierPragma_7_74_32 ?brokenObj_10_)) ?brokenObj_10_))) (forall (?brokenObj_11_ Int) (implies (and (= true_term (is ?brokenObj_11_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_11_ null))) (= (typeof (S_select elements_35_61_41 ?brokenObj_11_)) (array T_javafe_ast_TypeDeclElem)))) (forall (?brokenObj_12_ Int) (implies (and (= true_term (is ?brokenObj_12_ T_javafe_parser_ParseStmt)) (not (= ?brokenObj_12_ null))) (= (S_select elementType_9_43_27 (S_select seqStmt_4_70_46 ?brokenObj_12_)) T_javafe_ast_Stmt))) (forall (?brokenObj_13_ Int) (implies (and (= true_term (is ?brokenObj_13_ T_javafe_ast_TypeDecl)) (not (= ?brokenObj_13_ null))) (not (= (S_select locId_27_48_13 ?brokenObj_13_) NULL_46_60_26)))) (forall (?brokenObj_14_ Int) (implies (and (= true_term (is ?brokenObj_14_ T_javafe_parser_Token)) (not (= ?brokenObj_14_ null))) (not (= (S_select startingLoc_12_65_15 ?brokenObj_14_) NULL_46_60_26)))) (forall (?brokenObj_15_ Int) (implies (and (= true_term (is ?brokenObj_15_ T_javafe_ast_ModifierPragmaVec)) (not (= ?brokenObj_15_ null))) (<= (S_select count_48_67_33 ?brokenObj_15_) (arrayLength (S_select elements_48_61_43 ?brokenObj_15_))))) (forall (?brokenObj_16_ Int) (implies (and (= true_term (is ?brokenObj_16_ T_javafe_util_StackVector)) (not (= ?brokenObj_16_ null))) (= (S_select owner_8_35_28 (S_select elements_9_72_21 ?brokenObj_16_)) ?brokenObj_16_))) (forall (?brokenObj_17_ Int) (implies (and (= true_term (is ?brokenObj_17_ T_javafe_parser_Parse)) (not (= ?brokenObj_17_ null))) (= (S_select elementType_9_43_27 (S_select seqTypeName_56_46 ?brokenObj_17_)) T_javafe_ast_TypeName))) (forall (?brokenObj_18_ Int) (implies (and (= true_term (is ?brokenObj_18_ T_javafe_util_StackVector)) (not (= ?brokenObj_18_ null))) (>= (S_select vectorCount_9_97_33 ?brokenObj_18_) 1))) (= noTokens_14_212_27 (+ (+ (arrayLength keywordStrings_14_181_30) (arrayLength punctuationStrings_14_134_22)) (arrayLength otherStrings_14_193_30))) (forall (?brokenObj_19_ Int) (implies (and (= true_term (is ?brokenObj_19_ T_javafe_ast_TypeDecl)) (not (= ?brokenObj_19_ null))) (not (= (S_select locOpenBrace_27_51_13 ?brokenObj_19_) NULL_46_60_26)))) (forall (?brokenObj_20_ Int) (implies (and (= true_term (is ?brokenObj_20_ T_javafe_parser_Parse)) (not (= ?brokenObj_20_ null))) (= (S_select owner_8_35_28 (S_select seqImportDecl_72_46 ?brokenObj_20_)) ?brokenObj_20_))) (forall (?brokenObj_21_ Int) (implies (and (= true_term (is ?brokenObj_21_ T_javafe_parser_ParseExpr)) (not (= ?brokenObj_21_ null))) (= (S_select elementType_9_43_27 (S_select seqTypeDeclElem_5_1161_46 ?brokenObj_21_)) T_javafe_ast_TypeDeclElem))) (forall (?brokenObj_22_ Int) (implies (and (= true_term (is ?brokenObj_22_ T_javafe_ast_TypeDecl)) (not (= ?brokenObj_22_ null))) (not (= (S_select locCloseBrace_27_54_13 ?brokenObj_22_) NULL_46_60_26)))) (forall (?brokenObj_23_ Int) (implies (and (= true_term (is ?brokenObj_23_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_23_ null))) (<= 0 (S_select count_35_67_33 ?brokenObj_23_)))) (forall (?brokenObj_24_ Int) (implies (and (= true_term (is ?brokenObj_24_ T_javafe_parser_ParseStmt)) (not (= ?brokenObj_24_ null))) (= (S_select owner_8_35_28 (S_select seqStmt_4_70_46 ?brokenObj_24_)) ?brokenObj_24_))) (forall (?brokenObj_25_ Int) (implies (and (= true_term (is ?brokenObj_25_ T_javafe_parser_ParseType)) (not (= ?brokenObj_25_ null))) (= (arrayLength (S_select nameDotLocs_6_65_28 ?brokenObj_25_)) (arrayLength (S_select nameIdLocs_6_62_28 ?brokenObj_25_))))) (forall (?brokenObj_26_ Int) (implies (and (= true_term (is ?brokenObj_26_ T_javafe_parser_Parse)) (not (= ?brokenObj_26_ null))) (= (S_select owner_8_35_28 (S_select seqTypeName_56_46 ?brokenObj_26_)) ?brokenObj_26_))) (forall (?brokenObj_27_ Int) (implies (and (= true_term (is ?brokenObj_27_ T_javafe_parser_Parse)) (not (= ?brokenObj_27_ null))) (= (S_select elementType_9_43_27 (S_select seqTypeDecl_80_46 ?brokenObj_27_)) T_javafe_ast_TypeDecl))) (forall (?brokenObj_28_ Int) (implies (and (= true_term (is ?brokenObj_28_ T_javafe_parser_Parse)) (not (= ?brokenObj_28_ null))) (= (S_select elementType_9_43_27 (S_select seqFormalParaDecl_64_46 ?brokenObj_28_)) T_javafe_ast_FormalParaDecl))) (forall (?brokenObj_29_ Int) (implies (and (= true_term (is ?brokenObj_29_ T_javafe_parser_ParseType)) (not (= ?brokenObj_29_ null))) (= (S_select elementType_9_43_27 (S_select seqIdentifier_6_33_46 ?brokenObj_29_)) T_javafe_ast_Identifier))) (forall (?brokenObj_30_ Int) (implies (and (= true_term (is ?brokenObj_30_ T_javafe_parser_Token)) (not (= ?brokenObj_30_ null))) (and (not (= (S_select ttype_12_52_15 ?brokenObj_30_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_30_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_30_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_30_) null))))))) (forall (?brokenObj_31_ Int) (implies (and (= true_term (is ?brokenObj_31_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_31_ null))) (= (S_select owner_8_35_28 (S_select elements_35_61_41 ?brokenObj_31_)) ?brokenObj_31_))) (forall (?brokenObj_32_ Int) (implies (and (= true_term (is ?brokenObj_32_ T_javafe_ast_GenericVarDecl)) (not (= ?brokenObj_32_ null))) (not (= (S_select locId_55_38_13 ?brokenObj_32_) NULL_46_60_26)))) (forall (?brokenObj_33_ Int) (implies (and (= true_term (is ?brokenObj_33_ T_javafe_util_StackVector)) (not (= ?brokenObj_33_ null))) (not (= (S_select elements_9_72_21 ?brokenObj_33_) null)))) (= (arrayLength keywordStrings_14_181_30) (- (+ 1 LAST_KEYWORD_14_103_26) FIRST_KEYWORD_14_51_26)) (forall (?brokenObj_34_ Int) (implies (and (= true_term (is ?brokenObj_34_ T_javafe_ast_Identifier)) (not (= ?brokenObj_34_ null))) (and (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) BOOLEANLIT_15_38_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) INTLIT_15_39_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) LONGLIT_15_40_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) FLOATLIT_15_42_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) DOUBLELIT_15_43_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) STRINGLIT_15_44_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) CHARLIT_15_41_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) LEXICALPRAGMA_14_24_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) MODIFIERPRAGMA_14_25_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) STMTPRAGMA_14_26_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) TYPEDECLELEMPRAGMA_14_27_26)) (not (= (S_select tokenType_50_90_8 ?brokenObj_34_) TYPEMODIFIERPRAGMA_14_28_26))))) (forall (?brokenObj_35_ Int) (implies (and (= true_term (is ?brokenObj_35_ T_javafe_parser_Token)) (not (= ?brokenObj_35_ null)) (= (S_select ttype_12_52_15 ?brokenObj_35_) IDENT_15_25_26)) (not (= (S_select identifierVal_12_80_22 ?brokenObj_35_) null)))) (= (arrayLength otherCodes_14_202_27) (arrayLength otherStrings_14_193_30)) (forall (?brokenObj_36_ Int) (implies (and (= true_term (is ?brokenObj_36_ T_javafe_ast_ModifierPragmaVec)) (not (= ?brokenObj_36_ null))) (forall (?i_48_62_31 Int) (implies (and (<= 0 ?i_48_62_31) (< ?i_48_62_31 (S_select count_48_67_33 ?brokenObj_36_))) (not (= (S_select (S_select elems (S_select elements_48_61_43 ?brokenObj_36_)) ?i_48_62_31) null)))))) (forall (?brokenObj_37_ Int) (implies (and (= true_term (is ?brokenObj_37_ T_javafe_util_StackVector)) (not (= ?brokenObj_37_ null))) (or (= (S_select currentStackBottom_9_87_33 ?brokenObj_37_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_37_)) (- (S_select currentStackBottom_9_87_33 ?brokenObj_37_) 1)) null)))) (forall (?brokenObj_38_ Int) (implies (and (= true_term (is ?brokenObj_38_ T_javafe_parser_ParseExpr)) (not (= ?brokenObj_38_ null))) (= (S_select owner_8_35_28 (S_select seqTypeDeclElem_5_1161_46 ?brokenObj_38_)) ?brokenObj_38_))) (= true_term (nonnullelements otherStrings_14_193_30 elems)) (forall (?brokenObj_39_ Int) (implies (and (= true_term (is ?brokenObj_39_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_39_ null))) (<= (S_select count_35_67_33 ?brokenObj_39_) (arrayLength (S_select elements_35_61_41 ?brokenObj_39_))))) (forall (?brokenObj_40_ Int) (implies (and (= true_term (is ?brokenObj_40_ T_javafe_util_StackVector)) (not (= ?brokenObj_40_ null))) (and (<= 0 (S_select currentStackBottom_9_87_33 ?brokenObj_40_)) (<= (S_select currentStackBottom_9_87_33 ?brokenObj_40_) (S_select elementCount_9_79_33 ?brokenObj_40_))))) (forall (?brokenObj_41_ Int) (implies (and (= true_term (is ?brokenObj_41_ T_javafe_parser_ParseStmt)) (not (= ?brokenObj_41_ null))) (= (S_select elementType_9_43_27 (S_select seqCatchClause_4_76_46 ?brokenObj_41_)) T_javafe_ast_CatchClause))) (forall (?i_14_149_29 Int) (implies (and (<= 0 ?i_14_149_29) (<= ?i_14_149_29 (arrayLength punctuationCodes_14_164_19))) (and (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) IDENT_15_25_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) BOOLEANLIT_15_38_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) INTLIT_15_39_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) LONGLIT_15_40_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) FLOATLIT_15_42_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) DOUBLELIT_15_43_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) STRINGLIT_15_44_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) CHARLIT_15_41_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) LEXICALPRAGMA_14_24_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) MODIFIERPRAGMA_14_25_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) STMTPRAGMA_14_26_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) TYPEDECLELEMPRAGMA_14_27_26)) (not (= (S_select (S_select elems punctuationCodes_14_164_19) ?i_14_149_29) TYPEMODIFIERPRAGMA_14_28_26))))) (forall (?brokenObj_42_ Int) (implies (and (= true_term (is ?brokenObj_42_ T_javafe_parser_ParseType)) (not (= ?brokenObj_42_ null))) (= (S_select owner_8_35_28 (S_select seqIdentifier_6_33_46 ?brokenObj_42_)) ?brokenObj_42_))) (= (arrayLength punctuationCodes_14_164_19) (arrayLength punctuationStrings_14_134_22)) (forall (?brokenObj_43_ Int) (implies (and (= true_term (is ?brokenObj_43_ T_javafe_parser_ParseType)) (not (= ?brokenObj_43_ null))) (= (S_select owner_8_35_28 (S_select nameDotLocs_6_65_28 ?brokenObj_43_)) ?brokenObj_43_))) (forall (?brokenObj_44_ Int) (implies (and (= true_term (is ?brokenObj_44_ T_javafe_parser_Parse)) (not (= ?brokenObj_44_ null))) (= (S_select owner_8_35_28 (S_select seqTypeDecl_80_46 ?brokenObj_44_)) ?brokenObj_44_))) (forall (?brokenObj_45_ Int) (implies (and (= true_term (is ?brokenObj_45_ T_javafe_ast_ModifierPragmaVec)) (not (= ?brokenObj_45_ null))) (= (typeof (S_select elements_48_61_43 ?brokenObj_45_)) (array T_javafe_ast_ModifierPragma)))) (forall (?brokenObj_46_ Int) (implies (and (= true_term (is ?brokenObj_46_ T_javafe_parser_Parse)) (not (= ?brokenObj_46_ null))) (= (S_select owner_8_35_28 (S_select seqFormalParaDecl_64_46 ?brokenObj_46_)) ?brokenObj_46_))) (forall (?brokenObj_47_ Int) (implies (and (= true_term (is ?brokenObj_47_ T_javafe_util_StackVector)) (not (= ?brokenObj_47_ null))) (> (arrayLength (S_select elements_9_72_21 ?brokenObj_47_)) 0))) (forall (?brokenObj_48_ Int) (implies (and (= true_term (is ?brokenObj_48_ T_javafe_parser_ParseExpr)) (not (= ?brokenObj_48_ null))) (= (S_select elementType_9_43_27 (S_select seqVarInit_5_1153_46 ?brokenObj_48_)) T_javafe_ast_VarInit))) (forall (?brokenObj_49_ Int) (implies (and (= true_term (is ?brokenObj_49_ T_javafe_parser_ParseExpr)) (not (= ?brokenObj_49_ null))) (= (S_select elementType_9_43_27 (S_select seqExpr_5_1145_46 ?brokenObj_49_)) T_javafe_ast_Expr))) (forall (?brokenObj_50_ Int) (implies (and (= true_term (is ?brokenObj_50_ T_javafe_util_StackVector)) (not (= ?brokenObj_50_ null))) (and (<= 0 (S_select elementCount_9_79_33 ?brokenObj_50_)) (<= (S_select elementCount_9_79_33 ?brokenObj_50_) (arrayLength (S_select elements_9_72_21 ?brokenObj_50_)))))) (forall (?brokenObj_51_ Int) (implies (and (= true_term (is ?brokenObj_51_ T_javafe_parser_ParseType)) (not (= ?brokenObj_51_ null))) (>= (arrayLength (S_select nameIdLocs_6_62_28 ?brokenObj_51_)) 10))) (= true_term (nonnullelements keywordStrings_14_181_30 elems)) (forall (?brokenObj_52_ Int) (implies (and (= true_term (is ?brokenObj_52_ T_javafe_util_StackVector)) (not (= ?brokenObj_52_ null))) (= (typeof (S_select elements_9_72_21 ?brokenObj_52_)) (array T_java_lang_Object)))) (= true_term (is (S_select owner_8_35_28 punctuationCodes_14_164_19) T_javafe_parser_TagConstants)) (not (= (S_select owner_8_35_28 punctuationCodes_14_164_19) null)) (forall (?brokenObj_53_ Int) (implies (and (= true_term (is ?brokenObj_53_ T_javafe_ast_CatchClause)) (not (= ?brokenObj_53_ null))) (not (= (S_select loc_84_22_13 ?brokenObj_53_) NULL_46_60_26)))) (forall (?brokenObj_54_ Int) (implies (and (= true_term (is ?brokenObj_54_ T_javafe_ast_ModifierPragmaVec)) (not (= ?brokenObj_54_ null))) (<= 0 (S_select count_48_67_33 ?brokenObj_54_)))) (forall (?brokenObj_55_ Int) (implies (and (= true_term (is ?brokenObj_55_ T_javafe_parser_ParseStmt)) (not (= ?brokenObj_55_ null))) (= (S_select owner_8_35_28 (S_select seqCatchClause_4_76_46 ?brokenObj_55_)) ?brokenObj_55_))) (forall (?brokenObj_56_ Int) (implies (and (= true_term (is ?brokenObj_56_ T_javafe_parser_ParseExpr)) (not (= ?brokenObj_56_ null))) (= (S_select owner_8_35_28 (S_select seqExpr_5_1145_46 ?brokenObj_56_)) ?brokenObj_56_))) (forall (?brokenObj_57_ Int) (implies (and (= true_term (is ?brokenObj_57_ T_javafe_parser_ParseUtil)) (not (= ?brokenObj_57_ null))) (= (S_select elementType_9_43_27 (S_select seqModifierPragma_7_74_32 ?brokenObj_57_)) T_javafe_ast_ModifierPragma))) (or (not (not (= l_195_36 null))) (and (not (= l_195_36 null)) (or (and (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (= true_term true_term) (= this_198_22_198_22 (S_select seqTypeDeclElem_5_1161_46 this)) (= vectorCount_198_22_9_282_17 (S_store vectorCount_9_97_33 this_198_22_198_22 after_198_22_198_22_9_282_17)) (= currentStackBottom_198_22_9_282_30 (S_store currentStackBottom_9_87_33 this_198_22_198_22 after_198_22_198_22_9_282_30)) (= vectorCount_198_22_9_282_17 (asField vectorCount_198_22_9_282_17 T_int)) (= currentStackBottom_198_22_9_282_30 (asField currentStackBottom_198_22_9_282_30 T_int)) (= EC_198_22_198_22 ecReturn) (implies (= EC_198_22_198_22 ecReturn) (= (S_select vectorCount_198_22_9_282_17 this_198_22_198_22) (+ (S_select vectorCount_9_97_33 this_198_22_198_22) 1))) (implies (= EC_198_22_198_22 ecReturn) (= (S_select currentStackBottom_198_22_9_282_30 this_198_22_198_22) (S_select elementCount_9_79_33 this_198_22_198_22))) (forall (?brokenObj_58_ Int) (implies (and (= true_term (is ?brokenObj_58_ T_javafe_util_StackVector)) (not (= ?brokenObj_58_ null)) (>= (S_select vectorCount_9_97_33 ?brokenObj_58_) 1)) (>= (S_select vectorCount_198_22_9_282_17 ?brokenObj_58_) 1))) (forall (?brokenObj_59_ Int) (implies (and (= true_term (is ?brokenObj_59_ T_javafe_util_StackVector)) (not (= ?brokenObj_59_ null)) (or (= (S_select currentStackBottom_9_87_33 ?brokenObj_59_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_59_)) (- (S_select currentStackBottom_9_87_33 ?brokenObj_59_) 1)) null))) (or (= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_59_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_59_)) (- (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_59_) 1)) null)))) (forall (?brokenObj_60_ Int) (implies (and (= true_term (is ?brokenObj_60_ T_javafe_util_StackVector)) (not (= ?brokenObj_60_ null)) (<= 0 (S_select currentStackBottom_9_87_33 ?brokenObj_60_)) (<= (S_select currentStackBottom_9_87_33 ?brokenObj_60_) (S_select elementCount_9_79_33 ?brokenObj_60_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_60_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_60_) (S_select elementCount_9_79_33 ?brokenObj_60_))))) (or (and (= identifierVal_12_80_22 identifierVal_loopold_12_80_22) (= ttype_12_52_15 ttype_loopold_12_52_15) (= EC_198_22_198_22 EC_loopold) (= auxVal_12_127_18 auxVal_loopold_12_127_18) (= elementCount_9_79_33 elementCount_loopold_9_79_33) (or (and (= true_term true_term) (or (not (not (= l_195_36 null))) (and (not (= l_195_36 null)) (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (or (not (not (= l_195_36 null))) (and (not (= l_195_36 null)) (or (not (= true_term (is (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma))) (and (= true_term (is (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= pragma_199_6_0_200_1 (cast (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= tmp0_seqTypeDeclElem_199_6_0_201_1 (S_select seqTypeDeclElem_5_1161_46 this)) (or (not (not (= pragma_199_6_0_200_1 null))) (and (not (= pragma_199_6_0_200_1 null)) (not (= (PO_LT (typeof pragma_199_6_0_200_1) (S_select elementType_9_43_27 tmp0_seqTypeDeclElem_199_6_0_201_1)) true_term))) (and (not (= pragma_199_6_0_200_1 null)) (= (PO_LT (typeof pragma_199_6_0_200_1) (S_select elementType_9_43_27 tmp0_seqTypeDeclElem_199_6_0_201_1)) true_term) (= elementCount_199_6_0_201_17_9_195_17 (S_store elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1 after_201_17_199_6_0_201_17_9_195_17)) (= elementCount_199_6_0_201_17_9_195_17 (asField elementCount_199_6_0_201_17_9_195_17 T_int)) (= EC_199_6_0_201_17_201_17 ecReturn) (implies (= EC_199_6_0_201_17_201_17 ecReturn) (= (- (S_select elementCount_199_6_0_201_17_9_195_17 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) (+ (- (S_select elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) 1))) (forall (?brokenObj_61_ Int) (implies (and (= true_term (is ?brokenObj_61_ T_javafe_util_StackVector)) (not (= ?brokenObj_61_ null)) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term))))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term)))))) (forall (?brokenObj_62_ Int) (implies (and (= true_term (is ?brokenObj_62_ T_javafe_util_StackVector)) (not (= ?brokenObj_62_ null)) (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_9_79_33 ?brokenObj_62_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_62_))))) (forall (?brokenObj_63_ Int) (implies (and (= true_term (is ?brokenObj_63_ T_javafe_util_StackVector)) (not (= ?brokenObj_63_ null)) (<= 0 (S_select elementCount_9_79_33 ?brokenObj_63_)) (<= (S_select elementCount_9_79_33 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))) (and (<= 0 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_)) (<= (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))))) (or (not (not (= l_195_36 null))) (and (not (= l_195_36 null)) (not (not (= (S_select m_in_11_212_46 l_195_36) null)))))))))))))) (and (= true_term true_term) (not (= l_195_36 null)) (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (not (= l_195_36 null)) (= true_term (is (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= pragma_199_6_0_200_1 (cast (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= tmp0_seqTypeDeclElem_199_6_0_201_1 (S_select seqTypeDeclElem_5_1161_46 this)) (not (= pragma_199_6_0_200_1 null)) (= (PO_LT (typeof pragma_199_6_0_200_1) (S_select elementType_9_43_27 tmp0_seqTypeDeclElem_199_6_0_201_1)) true_term) (= elementCount_199_6_0_201_17_9_195_17 (S_store elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1 after_201_17_199_6_0_201_17_9_195_17)) (= elementCount_199_6_0_201_17_9_195_17 (asField elementCount_199_6_0_201_17_9_195_17 T_int)) (= EC_199_6_0_201_17_201_17 ecReturn) (implies (= EC_199_6_0_201_17_201_17 ecReturn) (= (- (S_select elementCount_199_6_0_201_17_9_195_17 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) (+ (- (S_select elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) 1))) (forall (?brokenObj_61_ Int) (implies (and (= true_term (is ?brokenObj_61_ T_javafe_util_StackVector)) (not (= ?brokenObj_61_ null)) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term))))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term)))))) (forall (?brokenObj_62_ Int) (implies (and (= true_term (is ?brokenObj_62_ T_javafe_util_StackVector)) (not (= ?brokenObj_62_ null)) (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_9_79_33 ?brokenObj_62_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_62_))))) (forall (?brokenObj_63_ Int) (implies (and (= true_term (is ?brokenObj_63_ T_javafe_util_StackVector)) (not (= ?brokenObj_63_ null)) (<= 0 (S_select elementCount_9_79_33 ?brokenObj_63_)) (<= (S_select elementCount_9_79_33 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))) (and (<= 0 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_)) (<= (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))))) (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)) (= ttype_199_6_0_202_3_11_372_15 (S_store ttype_12_52_15 l_195_36 after_202_3_199_6_0_202_3_11_372_15)) (= auxVal_199_6_0_202_3_11_372_22 (S_store auxVal_12_127_18 l_195_36 after_202_3_199_6_0_202_3_11_372_22)) (= identifierVal_199_6_0_202_3_11_372_30 (S_store identifierVal_12_80_22 l_195_36 after_202_3_199_6_0_202_3_11_372_30)) (= identifierVal_199_6_0_202_3_11_372_30 (asField identifierVal_199_6_0_202_3_11_372_30 T_javafe_ast_Identifier)) (< (fClosedTime identifierVal_199_6_0_202_3_11_372_30) alloc) (= ttype_199_6_0_202_3_11_372_15 (asField ttype_199_6_0_202_3_11_372_15 T_int)) (= auxVal_199_6_0_202_3_11_372_22 (asField auxVal_199_6_0_202_3_11_372_22 T_java_lang_Object)) (< (fClosedTime auxVal_199_6_0_202_3_11_372_22) alloc) (= true_term (is RES_199_6_0_202_3_202_3 T_int)) (= EC_199_6_0_202_3_202_3 ecReturn) (forall (?brokenObj_64_ Int) (implies (and (= true_term (is ?brokenObj_64_ T_javafe_parser_Token)) (not (= ?brokenObj_64_ null)) (not (= (S_select ttype_12_52_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null))))) (and (not (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null))))))) (forall (?brokenObj_65_ Int) (implies (and (= true_term (is ?brokenObj_65_ T_javafe_parser_Token)) (not (= ?brokenObj_65_ null)) (implies (= (S_select ttype_12_52_15 ?brokenObj_65_) IDENT_15_25_26) (not (= (S_select identifierVal_12_80_22 ?brokenObj_65_) null))) (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_65_) IDENT_15_25_26)) (not (= (S_select identifierVal_199_6_0_202_3_11_372_30 ?brokenObj_65_) null)))) (= true_term true_term) (not (not (= l_195_36 null)))))) (and (= identifierVal_12_80_22 identifierVal_loopold_12_80_22) (= ttype_12_52_15 ttype_loopold_12_52_15) (= EC_198_22_198_22 EC_loopold) (= auxVal_12_127_18 auxVal_loopold_12_127_18) (= elementCount_9_79_33 elementCount_loopold_9_79_33) (or (and (= true_term true_term) (not (= l_195_36 null)) (not (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= identifierVal_12_80_22_1_ identifierVal_12_80_22) (= ttype_12_52_15_1_ ttype_12_52_15) (= auxVal_12_127_18_1_ auxVal_12_127_18) (= elementCount_9_79_33_1_ elementCount_9_79_33) (= RES RES_198_22_198_22)) (and (= true_term true_term) (not (= l_195_36 null)) (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (not (= l_195_36 null)) (= true_term (is (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= pragma_199_6_0_200_1 (cast (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= tmp0_seqTypeDeclElem_199_6_0_201_1 (S_select seqTypeDeclElem_5_1161_46 this)) (not (= pragma_199_6_0_200_1 null)) (= (PO_LT (typeof pragma_199_6_0_200_1) (S_select elementType_9_43_27 tmp0_seqTypeDeclElem_199_6_0_201_1)) true_term) (= elementCount_199_6_0_201_17_9_195_17 (S_store elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1 after_201_17_199_6_0_201_17_9_195_17)) (= elementCount_199_6_0_201_17_9_195_17 (asField elementCount_199_6_0_201_17_9_195_17 T_int)) (= EC_199_6_0_201_17_201_17 ecReturn) (implies (= EC_199_6_0_201_17_201_17 ecReturn) (= (- (S_select elementCount_199_6_0_201_17_9_195_17 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) (+ (- (S_select elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) 1))) (forall (?brokenObj_61_ Int) (implies (and (= true_term (is ?brokenObj_61_ T_javafe_util_StackVector)) (not (= ?brokenObj_61_ null)) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term))))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term)))))) (forall (?brokenObj_62_ Int) (implies (and (= true_term (is ?brokenObj_62_ T_javafe_util_StackVector)) (not (= ?brokenObj_62_ null)) (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_9_79_33 ?brokenObj_62_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_62_))))) (forall (?brokenObj_63_ Int) (implies (and (= true_term (is ?brokenObj_63_ T_javafe_util_StackVector)) (not (= ?brokenObj_63_ null)) (<= 0 (S_select elementCount_9_79_33 ?brokenObj_63_)) (<= (S_select elementCount_9_79_33 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))) (and (<= 0 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_)) (<= (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))))) (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)) (= ttype_199_6_0_202_3_11_372_15 (S_store ttype_12_52_15 l_195_36 after_202_3_199_6_0_202_3_11_372_15)) (= auxVal_199_6_0_202_3_11_372_22 (S_store auxVal_12_127_18 l_195_36 after_202_3_199_6_0_202_3_11_372_22)) (= identifierVal_199_6_0_202_3_11_372_30 (S_store identifierVal_12_80_22 l_195_36 after_202_3_199_6_0_202_3_11_372_30)) (= identifierVal_199_6_0_202_3_11_372_30 (asField identifierVal_199_6_0_202_3_11_372_30 T_javafe_ast_Identifier)) (< (fClosedTime identifierVal_199_6_0_202_3_11_372_30) alloc) (= ttype_199_6_0_202_3_11_372_15 (asField ttype_199_6_0_202_3_11_372_15 T_int)) (= auxVal_199_6_0_202_3_11_372_22 (asField auxVal_199_6_0_202_3_11_372_22 T_java_lang_Object)) (< (fClosedTime auxVal_199_6_0_202_3_11_372_22) alloc) (= true_term (is RES_199_6_0_202_3_202_3 T_int)) (= EC_199_6_0_202_3_202_3 ecReturn) (forall (?brokenObj_64_ Int) (implies (and (= true_term (is ?brokenObj_64_ T_javafe_parser_Token)) (not (= ?brokenObj_64_ null)) (not (= (S_select ttype_12_52_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null))))) (and (not (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null))))))) (forall (?brokenObj_65_ Int) (implies (and (= true_term (is ?brokenObj_65_ T_javafe_parser_Token)) (not (= ?brokenObj_65_ null)) (implies (= (S_select ttype_12_52_15 ?brokenObj_65_) IDENT_15_25_26) (not (= (S_select identifierVal_12_80_22 ?brokenObj_65_) null))) (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_65_) IDENT_15_25_26)) (not (= (S_select identifierVal_199_6_0_202_3_11_372_30 ?brokenObj_65_) null)))) (= true_term true_term) (not (= l_195_36 null)) (not (= (S_select ttype_199_6_0_202_3_11_372_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= identifierVal_12_80_22_1_ identifierVal_199_6_0_202_3_11_372_30) (= ttype_12_52_15_1_ ttype_199_6_0_202_3_11_372_15) (= auxVal_12_127_18_1_ auxVal_199_6_0_202_3_11_372_22) (= elementCount_9_79_33_1_ elementCount_199_6_0_201_17_9_195_17) (= RES RES_199_6_0_202_3_202_3))) (= L_199_6 L_199_6) (= identifierVal_12_80_22_2_ identifierVal_12_80_22_1_) (= ttype_12_52_15_2_ ttype_12_52_15_1_) (= EC L_199_6) (= auxVal_12_127_18_2_ auxVal_12_127_18_1_) (= elementCount_9_79_33_2_ elementCount_9_79_33_1_) (= RES_1_ RES) (= s_204_31_204_31_35_145_79 (S_select seqTypeDeclElem_5_1161_46 this)) (or (not (> (S_select vectorCount_198_22_9_282_17 s_204_31_204_31_35_145_79) 1)) (and (> (S_select vectorCount_198_22_9_282_17 s_204_31_204_31_35_145_79) 1) (not (= (PO_LT (S_select elementType_9_43_27 s_204_31_204_31_35_145_79) T_javafe_ast_TypeDeclElem) true_term))))))) (and (or (and (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (= true_term true_term) (= this_198_22_198_22 (S_select seqTypeDeclElem_5_1161_46 this)) (= vectorCount_198_22_9_282_17 (S_store vectorCount_9_97_33 this_198_22_198_22 after_198_22_198_22_9_282_17)) (= currentStackBottom_198_22_9_282_30 (S_store currentStackBottom_9_87_33 this_198_22_198_22 after_198_22_198_22_9_282_30)) (= vectorCount_198_22_9_282_17 (asField vectorCount_198_22_9_282_17 T_int)) (= currentStackBottom_198_22_9_282_30 (asField currentStackBottom_198_22_9_282_30 T_int)) (= EC_198_22_198_22 ecReturn) (implies (= EC_198_22_198_22 ecReturn) (= (S_select vectorCount_198_22_9_282_17 this_198_22_198_22) (+ (S_select vectorCount_9_97_33 this_198_22_198_22) 1))) (implies (= EC_198_22_198_22 ecReturn) (= (S_select currentStackBottom_198_22_9_282_30 this_198_22_198_22) (S_select elementCount_9_79_33 this_198_22_198_22))) (forall (?brokenObj_58_ Int) (implies (and (= true_term (is ?brokenObj_58_ T_javafe_util_StackVector)) (not (= ?brokenObj_58_ null)) (>= (S_select vectorCount_9_97_33 ?brokenObj_58_) 1)) (>= (S_select vectorCount_198_22_9_282_17 ?brokenObj_58_) 1))) (forall (?brokenObj_59_ Int) (implies (and (= true_term (is ?brokenObj_59_ T_javafe_util_StackVector)) (not (= ?brokenObj_59_ null)) (or (= (S_select currentStackBottom_9_87_33 ?brokenObj_59_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_59_)) (- (S_select currentStackBottom_9_87_33 ?brokenObj_59_) 1)) null))) (or (= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_59_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_59_)) (- (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_59_) 1)) null)))) (forall (?brokenObj_60_ Int) (implies (and (= true_term (is ?brokenObj_60_ T_javafe_util_StackVector)) (not (= ?brokenObj_60_ null)) (<= 0 (S_select currentStackBottom_9_87_33 ?brokenObj_60_)) (<= (S_select currentStackBottom_9_87_33 ?brokenObj_60_) (S_select elementCount_9_79_33 ?brokenObj_60_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_60_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_60_) (S_select elementCount_9_79_33 ?brokenObj_60_))))) (= identifierVal_12_80_22 identifierVal_loopold_12_80_22) (= ttype_12_52_15 ttype_loopold_12_52_15) (= EC_198_22_198_22 EC_loopold) (= auxVal_12_127_18 auxVal_loopold_12_127_18) (= elementCount_9_79_33 elementCount_loopold_9_79_33) (or (and (= true_term true_term) (not (= l_195_36 null)) (not (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= identifierVal_12_80_22_1_ identifierVal_12_80_22) (= ttype_12_52_15_1_ ttype_12_52_15) (= auxVal_12_127_18_1_ auxVal_12_127_18) (= elementCount_9_79_33_1_ elementCount_9_79_33) (= RES RES_198_22_198_22)) (and (= true_term true_term) (not (= l_195_36 null)) (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (not (= l_195_36 null)) (= true_term (is (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= pragma_199_6_0_200_1 (cast (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= tmp0_seqTypeDeclElem_199_6_0_201_1 (S_select seqTypeDeclElem_5_1161_46 this)) (not (= pragma_199_6_0_200_1 null)) (= (PO_LT (typeof pragma_199_6_0_200_1) (S_select elementType_9_43_27 tmp0_seqTypeDeclElem_199_6_0_201_1)) true_term) (= elementCount_199_6_0_201_17_9_195_17 (S_store elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1 after_201_17_199_6_0_201_17_9_195_17)) (= elementCount_199_6_0_201_17_9_195_17 (asField elementCount_199_6_0_201_17_9_195_17 T_int)) (= EC_199_6_0_201_17_201_17 ecReturn) (implies (= EC_199_6_0_201_17_201_17 ecReturn) (= (- (S_select elementCount_199_6_0_201_17_9_195_17 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) (+ (- (S_select elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) 1))) (forall (?brokenObj_61_ Int) (implies (and (= true_term (is ?brokenObj_61_ T_javafe_util_StackVector)) (not (= ?brokenObj_61_ null)) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term))))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term)))))) (forall (?brokenObj_62_ Int) (implies (and (= true_term (is ?brokenObj_62_ T_javafe_util_StackVector)) (not (= ?brokenObj_62_ null)) (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_9_79_33 ?brokenObj_62_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_62_))))) (forall (?brokenObj_63_ Int) (implies (and (= true_term (is ?brokenObj_63_ T_javafe_util_StackVector)) (not (= ?brokenObj_63_ null)) (<= 0 (S_select elementCount_9_79_33 ?brokenObj_63_)) (<= (S_select elementCount_9_79_33 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))) (and (<= 0 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_)) (<= (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))))) (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)) (= ttype_199_6_0_202_3_11_372_15 (S_store ttype_12_52_15 l_195_36 after_202_3_199_6_0_202_3_11_372_15)) (= auxVal_199_6_0_202_3_11_372_22 (S_store auxVal_12_127_18 l_195_36 after_202_3_199_6_0_202_3_11_372_22)) (= identifierVal_199_6_0_202_3_11_372_30 (S_store identifierVal_12_80_22 l_195_36 after_202_3_199_6_0_202_3_11_372_30)) (= identifierVal_199_6_0_202_3_11_372_30 (asField identifierVal_199_6_0_202_3_11_372_30 T_javafe_ast_Identifier)) (< (fClosedTime identifierVal_199_6_0_202_3_11_372_30) alloc) (= ttype_199_6_0_202_3_11_372_15 (asField ttype_199_6_0_202_3_11_372_15 T_int)) (= auxVal_199_6_0_202_3_11_372_22 (asField auxVal_199_6_0_202_3_11_372_22 T_java_lang_Object)) (< (fClosedTime auxVal_199_6_0_202_3_11_372_22) alloc) (= true_term (is RES_199_6_0_202_3_202_3 T_int)) (= EC_199_6_0_202_3_202_3 ecReturn) (forall (?brokenObj_64_ Int) (implies (and (= true_term (is ?brokenObj_64_ T_javafe_parser_Token)) (not (= ?brokenObj_64_ null)) (not (= (S_select ttype_12_52_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null))))) (and (not (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null))))))) (forall (?brokenObj_65_ Int) (implies (and (= true_term (is ?brokenObj_65_ T_javafe_parser_Token)) (not (= ?brokenObj_65_ null)) (implies (= (S_select ttype_12_52_15 ?brokenObj_65_) IDENT_15_25_26) (not (= (S_select identifierVal_12_80_22 ?brokenObj_65_) null))) (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_65_) IDENT_15_25_26)) (not (= (S_select identifierVal_199_6_0_202_3_11_372_30 ?brokenObj_65_) null)))) (= true_term true_term) (not (= l_195_36 null)) (not (= (S_select ttype_199_6_0_202_3_11_372_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= identifierVal_12_80_22_1_ identifierVal_199_6_0_202_3_11_372_30) (= ttype_12_52_15_1_ ttype_199_6_0_202_3_11_372_15) (= auxVal_12_127_18_1_ auxVal_199_6_0_202_3_11_372_22) (= elementCount_9_79_33_1_ elementCount_199_6_0_201_17_9_195_17) (= RES RES_199_6_0_202_3_202_3))) (= L_199_6 L_199_6) (= identifierVal_12_80_22_2_ identifierVal_12_80_22_1_) (= ttype_12_52_15_2_ ttype_12_52_15_1_) (= EC L_199_6) (= auxVal_12_127_18_2_ auxVal_12_127_18_1_) (= elementCount_9_79_33_2_ elementCount_9_79_33_1_) (= RES_1_ RES) (= s_204_31_204_31_35_145_79 (S_select seqTypeDeclElem_5_1161_46 this)) (> (S_select vectorCount_198_22_9_282_17 s_204_31_204_31_35_145_79) 1) (= (PO_LT (S_select elementType_9_43_27 s_204_31_204_31_35_145_79) T_javafe_ast_TypeDeclElem) true_term) (= vectorCount_204_31_35_137_19 (S_store vectorCount_198_22_9_282_17 s_204_31_204_31_35_145_79 after_204_31_204_31_35_137_17)) (= elementCount_204_31_35_139_19 (S_store elementCount_9_79_33_2_ s_204_31_204_31_35_145_79 after_204_31_204_31_35_139_17)) (= currentStackBottom_204_31_35_139_35 (S_store currentStackBottom_198_22_9_282_30 s_204_31_204_31_35_145_79 after_204_31_204_31_35_139_33)) (= vectorCount_204_31_35_137_19 (asField vectorCount_204_31_35_137_19 T_int)) (= currentStackBottom_204_31_35_139_35 (asField currentStackBottom_204_31_35_139_35 T_int)) (= elementCount_204_31_35_139_19 (asField elementCount_204_31_35_139_19 T_int)) (= true_term (is RES_204_31_204_31 T_javafe_ast_TypeDeclElemVec)) (= true_term (isAllocated RES_204_31_204_31 alloc)) (= EC_204_31_204_31 ecReturn) (implies (= EC_204_31_204_31 ecReturn) (= (S_select vectorCount_204_31_35_137_19 s_204_31_204_31_35_145_79) (- (S_select vectorCount_198_22_9_282_17 s_204_31_204_31_35_145_79) 1))) (implies (= EC_204_31_204_31 ecReturn) (not (= RES_204_31_204_31 null))) (implies (= EC_204_31_204_31 ecReturn) (= (S_select count_35_67_33 RES_204_31_204_31) (- (S_select elementCount_9_79_33_2_ s_204_31_204_31_35_145_79) (S_select currentStackBottom_198_22_9_282_30 s_204_31_204_31_35_145_79)))) (forall (?brokenObj_66_ Int) (implies (and (= true_term (is ?brokenObj_66_ T_javafe_util_StackVector)) (not (= ?brokenObj_66_ null)) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33_2_ ?brokenObj_66_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_66_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_66_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_66_)) true_term))))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_204_31_35_139_19 ?brokenObj_66_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_66_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_66_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_66_)) true_term)))))) (forall (?brokenObj_67_ Int) (implies (and (= true_term (is ?brokenObj_67_ T_javafe_util_StackVector)) (not (= ?brokenObj_67_ null)) (>= (S_select vectorCount_198_22_9_282_17 ?brokenObj_67_) 1)) (>= (S_select vectorCount_204_31_35_137_19 ?brokenObj_67_) 1))) (forall (?brokenObj_68_ Int) (implies (and (= true_term (is ?brokenObj_68_ T_javafe_util_StackVector)) (not (= ?brokenObj_68_ null)) (or (= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_68_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_68_)) (- (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_68_) 1)) null))) (or (= (S_select currentStackBottom_204_31_35_139_35 ?brokenObj_68_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_68_)) (- (S_select currentStackBottom_204_31_35_139_35 ?brokenObj_68_) 1)) null)))) (forall (?brokenObj_69_ Int) (implies (and (= true_term (is ?brokenObj_69_ T_javafe_util_StackVector)) (not (= ?brokenObj_69_ null)) (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_69_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_69_) (S_select elementCount_9_79_33_2_ ?brokenObj_69_))) (and (<= 0 (S_select currentStackBottom_204_31_35_139_35 ?brokenObj_69_)) (<= (S_select currentStackBottom_204_31_35_139_35 ?brokenObj_69_) (S_select elementCount_204_31_35_139_19 ?brokenObj_69_))))) (forall (?brokenObj_70_ Int) (implies (and (= true_term (is ?brokenObj_70_ T_javafe_util_StackVector)) (not (= ?brokenObj_70_ null)) (<= 0 (S_select elementCount_9_79_33_2_ ?brokenObj_70_)) (<= (S_select elementCount_9_79_33_2_ ?brokenObj_70_) (arrayLength (S_select elements_9_72_21 ?brokenObj_70_)))) (and (<= 0 (S_select elementCount_204_31_35_139_19 ?brokenObj_70_)) (<= (S_select elementCount_204_31_35_139_19 ?brokenObj_70_) (arrayLength (S_select elements_9_72_21 ?brokenObj_70_)))))) (= identifierVal_12_80_22_3_ identifierVal_12_80_22_2_) (= ttype_12_52_15_3_ ttype_12_52_15_2_) (= EC_1_ EC_204_31_204_31) (= auxVal_12_127_18_3_ auxVal_12_127_18_2_) (= extras_196_20 RES_204_31_204_31) (= RES_2_ RES_204_31_204_31)) (and (not (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= true_term true_term) (= identifierVal_12_80_22_3_ identifierVal_12_80_22) (= ttype_12_52_15_3_ ttype_12_52_15) (= EC_1_ EC_2_) (= auxVal_12_127_18_3_ auxVal_12_127_18) (= extras_196_20 null) (= RES_2_ RES_3_))) (or (not (not (= l_195_36 null))) (and (not (= l_195_36 null)) (= loc_206_4 (S_select startingLoc_12_65_15 l_195_36)) (or (not (not (= l_195_36 null))) (and (not (= l_195_36 null)) (not (not (= (S_select m_in_11_212_46 l_195_36) null)))) (and (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)) (= modifierPragmas_207_20_7_151_15 (S_store modifierPragmas_7_134_29 this after_207_20_207_20_7_151_15)) (= modifierPragmas_207_20_7_151_15 (asField modifierPragmas_207_20_7_151_15 T_javafe_ast_ModifierPragmaVec)) (< (fClosedTime modifierPragmas_207_20_7_151_15) alloc) (= true_term (is RES_207_20_207_20 T_int)) (= EC_207_20_207_20 ecReturn) (= modifierPragmas_208_4 (S_select modifierPragmas_207_20_7_151_15 this)) (or (not (and (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)))) (not (not (= loc_206_4 NULL_46_60_26))) (and (not (= loc_206_4 NULL_46_60_26)) (= ttype_210_1_4_87_17 (S_store ttype_12_52_15_3_ l_195_36 after_210_1_210_1_4_87_17)) (= ttype_210_1_4_87_17 (asField ttype_210_1_4_87_17 T_int)) (= true_term (is RES_210_1_210_1 T_javafe_ast_TypeDecl)) (= true_term (isAllocated RES_210_1_210_1 alloc)) (= EC_210_1_210_1 ecReturn) (implies (= EC_210_1_210_1 ecReturn) (not (= RES_210_1_210_1 null))) (implies (and (= EC_210_1_210_1 ecReturn) (= (S_select ttype_12_52_15_3_ l_195_36) CLASS_14_59_26)) (and (= true_term (is RES_210_1_210_1 T_javafe_ast_ClassDecl)) (not (= RES_210_1_210_1 null)))) (forall (?brokenObj_71_ Int) (implies (and (= true_term (is ?brokenObj_71_ T_javafe_parser_Token)) (not (= ?brokenObj_71_ null)) (not (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null))))) (and (not (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null))))))) (forall (?brokenObj_72_ Int) (implies (and (= true_term (is ?brokenObj_72_ T_javafe_parser_Token)) (not (= ?brokenObj_72_ null)) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_72_) IDENT_15_25_26) (not (= (S_select identifierVal_12_80_22_3_ ?brokenObj_72_) null))) (= (S_select ttype_210_1_4_87_17 ?brokenObj_72_) IDENT_15_25_26)) (not (= (S_select identifierVal_12_80_22_3_ ?brokenObj_72_) null)))) (not (= extras_196_20 null)) (= true_term true_term) (or (and (= EC_210_1_210_1 EC_loopold_1_) (= 0 i_loopold_212_10) (or (and (= true_term true_term) (or (not (not (= extras_196_20 null))) (and (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_212_28_212_28 T_int)) (= EC_212_1_0_212_28_212_28 ecReturn) (implies (= EC_212_1_0_212_28_212_28 ecReturn) (= RES_212_1_0_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (< 0 RES_212_1_0_212_28_212_28) (or (not (not (= extras_196_20 null))) (and (not (= extras_196_20 null)) (or (not (and (<= 0 0) (< 0 (S_select count_35_67_33 extras_196_20)))) (and (= true_term (is RES_212_1_0_213_10_213_10 T_javafe_ast_TypeDeclElem)) (= true_term (isAllocated RES_212_1_0_213_10_213_10 alloc)) (= EC_212_1_0_213_10_213_10 ecReturn) (implies (= EC_212_1_0_213_10_213_10 ecReturn) (not (= RES_212_1_0_213_10_213_10 null))) (or (not (not (= RES_212_1_0_213_10_213_10 null))) (and (not (= RES_212_1_0_213_10_213_10 null)) (not (not (= RES_210_1_210_1 null)))))))))))) (and (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_212_28_212_28 T_int)) (= EC_212_1_0_212_28_212_28 ecReturn) (implies (= EC_212_1_0_212_28_212_28 ecReturn) (= RES_212_1_0_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (< 0 RES_212_1_0_212_28_212_28) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_213_10_213_10 T_javafe_ast_TypeDeclElem)) (= true_term (isAllocated RES_212_1_0_213_10_213_10 alloc)) (= EC_212_1_0_213_10_213_10 ecReturn) (implies (= EC_212_1_0_213_10_213_10 ecReturn) (not (= RES_212_1_0_213_10_213_10 null))) (not (= RES_212_1_0_213_10_213_10 null)) (not (= RES_210_1_210_1 null)) (= EC_212_1_0_213_23_213_23 ecReturn) (= i_212_1_0_212_36 (+ 0 1)) (= true_term true_term) (not (not (= extras_196_20 null)))))) (and (= EC_210_1_210_1 EC_loopold_1_) (= 0 i_loopold_212_10) (or (and (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_212_28_212_28 T_int)) (= EC_212_1_0_212_28_212_28 ecReturn) (implies (= EC_212_1_0_212_28_212_28 ecReturn) (= RES_212_1_0_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (not (< 0 RES_212_1_0_212_28_212_28)) (= RES_4_ RES_212_1_0_212_28_212_28)) (and (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_212_28_212_28 T_int)) (= EC_212_1_0_212_28_212_28 ecReturn) (implies (= EC_212_1_0_212_28_212_28 ecReturn) (= RES_212_1_0_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (< 0 RES_212_1_0_212_28_212_28) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_213_10_213_10 T_javafe_ast_TypeDeclElem)) (= true_term (isAllocated RES_212_1_0_213_10_213_10 alloc)) (= EC_212_1_0_213_10_213_10 ecReturn) (implies (= EC_212_1_0_213_10_213_10 ecReturn) (not (= RES_212_1_0_213_10_213_10 null))) (not (= RES_212_1_0_213_10_213_10 null)) (not (= RES_210_1_210_1 null)) (= EC_212_1_0_213_23_213_23 ecReturn) (= i_212_1_0_212_36 (+ 0 1)) (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_1_212_28_212_28 T_int)) (= EC_212_1_1_212_28_212_28 ecReturn) (implies (= EC_212_1_1_212_28_212_28 ecReturn) (= RES_212_1_1_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (not (< i_212_1_0_212_36 RES_212_1_1_212_28_212_28)) (= RES_4_ RES_212_1_1_212_28_212_28))) (= L_212_1 L_212_1) (= EC_3_ L_212_1) (= RES_5_ RES_4_) (or (not (not (= RES_210_1_210_1 null))) (and (not (= RES_210_1_210_1 null)) (or (not (not (= extras_196_20 null))) (and (not (= extras_196_20 null)) (or (and (= vec_215_8_215_8_35_308_43 (S_select elems_27_41_39 RES_210_1_210_1)) (not (not (= vec_215_8_215_8_35_308_43 null)))) (and (= vec_215_8_215_8_35_308_43 (S_select elems_27_41_39 RES_210_1_210_1)) (not (= vec_215_8_215_8_35_308_43 null)) (= count_215_8_35_306_15 (S_store count_35_67_33 extras_196_20 after_215_8_215_8_35_306_15)) (= count_215_8_35_306_15 (asField count_215_8_35_306_15 T_int)) (= EC_215_8_215_8 ecReturn) (implies (= EC_215_8_215_8 ecReturn) (= (S_select count_215_8_35_306_15 extras_196_20) (+ (S_select count_35_67_33 extras_196_20) (S_select count_215_8_35_306_15 vec_215_8_215_8_35_308_43)))) (forall (?brokenObj_73_ Int) (implies (and (= true_term (is ?brokenObj_73_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_73_ null)) (forall (?i_35_62_31 Int) (implies (and (<= 0 ?i_35_62_31) (< ?i_35_62_31 (S_select count_35_67_33 ?brokenObj_73_))) (not (= (S_select (S_select elems (S_select elements_35_61_41 ?brokenObj_73_)) ?i_35_62_31) null))))) (forall (?i_35_62_31 Int) (implies (and (<= 0 ?i_35_62_31) (< ?i_35_62_31 (S_select count_215_8_35_306_15 ?brokenObj_73_))) (not (= (S_select (S_select elems (S_select elements_35_61_41 ?brokenObj_73_)) ?i_35_62_31) null)))))) (forall (?brokenObj_74_ Int) (implies (and (= true_term (is ?brokenObj_74_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_74_ null)) (<= 0 (S_select count_35_67_33 ?brokenObj_74_))) (<= 0 (S_select count_215_8_35_306_15 ?brokenObj_74_)))) (forall (?brokenObj_75_ Int) (implies (and (= true_term (is ?brokenObj_75_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_75_ null)) (<= (S_select count_35_67_33 ?brokenObj_75_) (arrayLength (S_select elements_35_61_41 ?brokenObj_75_)))) (<= (S_select count_215_8_35_306_15 ?brokenObj_75_) (arrayLength (S_select elements_35_61_41 ?brokenObj_75_))))) (or (not (not (= RES_210_1_210_1 null))) (and (not (= RES_210_1_210_1 null)) (not (not (= extras_196_20 null)))))))))))))))))))))) (and (not (= l_195_36 null)) (or (and (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (= true_term true_term) (= this_198_22_198_22 (S_select seqTypeDeclElem_5_1161_46 this)) (= vectorCount_198_22_9_282_17 (S_store vectorCount_9_97_33 this_198_22_198_22 after_198_22_198_22_9_282_17)) (= currentStackBottom_198_22_9_282_30 (S_store currentStackBottom_9_87_33 this_198_22_198_22 after_198_22_198_22_9_282_30)) (= vectorCount_198_22_9_282_17 (asField vectorCount_198_22_9_282_17 T_int)) (= currentStackBottom_198_22_9_282_30 (asField currentStackBottom_198_22_9_282_30 T_int)) (= EC_198_22_198_22 ecReturn) (implies (= EC_198_22_198_22 ecReturn) (= (S_select vectorCount_198_22_9_282_17 this_198_22_198_22) (+ (S_select vectorCount_9_97_33 this_198_22_198_22) 1))) (implies (= EC_198_22_198_22 ecReturn) (= (S_select currentStackBottom_198_22_9_282_30 this_198_22_198_22) (S_select elementCount_9_79_33 this_198_22_198_22))) (forall (?brokenObj_58_ Int) (implies (and (= true_term (is ?brokenObj_58_ T_javafe_util_StackVector)) (not (= ?brokenObj_58_ null)) (>= (S_select vectorCount_9_97_33 ?brokenObj_58_) 1)) (>= (S_select vectorCount_198_22_9_282_17 ?brokenObj_58_) 1))) (forall (?brokenObj_59_ Int) (implies (and (= true_term (is ?brokenObj_59_ T_javafe_util_StackVector)) (not (= ?brokenObj_59_ null)) (or (= (S_select currentStackBottom_9_87_33 ?brokenObj_59_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_59_)) (- (S_select currentStackBottom_9_87_33 ?brokenObj_59_) 1)) null))) (or (= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_59_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_59_)) (- (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_59_) 1)) null)))) (forall (?brokenObj_60_ Int) (implies (and (= true_term (is ?brokenObj_60_ T_javafe_util_StackVector)) (not (= ?brokenObj_60_ null)) (<= 0 (S_select currentStackBottom_9_87_33 ?brokenObj_60_)) (<= (S_select currentStackBottom_9_87_33 ?brokenObj_60_) (S_select elementCount_9_79_33 ?brokenObj_60_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_60_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_60_) (S_select elementCount_9_79_33 ?brokenObj_60_))))) (= identifierVal_12_80_22 identifierVal_loopold_12_80_22) (= ttype_12_52_15 ttype_loopold_12_52_15) (= EC_198_22_198_22 EC_loopold) (= auxVal_12_127_18 auxVal_loopold_12_127_18) (= elementCount_9_79_33 elementCount_loopold_9_79_33) (or (and (= true_term true_term) (not (= l_195_36 null)) (not (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= identifierVal_12_80_22_1_ identifierVal_12_80_22) (= ttype_12_52_15_1_ ttype_12_52_15) (= auxVal_12_127_18_1_ auxVal_12_127_18) (= elementCount_9_79_33_1_ elementCount_9_79_33) (= RES RES_198_22_198_22)) (and (= true_term true_term) (not (= l_195_36 null)) (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (not (= l_195_36 null)) (= true_term (is (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= pragma_199_6_0_200_1 (cast (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= tmp0_seqTypeDeclElem_199_6_0_201_1 (S_select seqTypeDeclElem_5_1161_46 this)) (not (= pragma_199_6_0_200_1 null)) (= (PO_LT (typeof pragma_199_6_0_200_1) (S_select elementType_9_43_27 tmp0_seqTypeDeclElem_199_6_0_201_1)) true_term) (= elementCount_199_6_0_201_17_9_195_17 (S_store elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1 after_201_17_199_6_0_201_17_9_195_17)) (= elementCount_199_6_0_201_17_9_195_17 (asField elementCount_199_6_0_201_17_9_195_17 T_int)) (= EC_199_6_0_201_17_201_17 ecReturn) (implies (= EC_199_6_0_201_17_201_17 ecReturn) (= (- (S_select elementCount_199_6_0_201_17_9_195_17 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) (+ (- (S_select elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) 1))) (forall (?brokenObj_61_ Int) (implies (and (= true_term (is ?brokenObj_61_ T_javafe_util_StackVector)) (not (= ?brokenObj_61_ null)) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term))))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term)))))) (forall (?brokenObj_62_ Int) (implies (and (= true_term (is ?brokenObj_62_ T_javafe_util_StackVector)) (not (= ?brokenObj_62_ null)) (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_9_79_33 ?brokenObj_62_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_62_))))) (forall (?brokenObj_63_ Int) (implies (and (= true_term (is ?brokenObj_63_ T_javafe_util_StackVector)) (not (= ?brokenObj_63_ null)) (<= 0 (S_select elementCount_9_79_33 ?brokenObj_63_)) (<= (S_select elementCount_9_79_33 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))) (and (<= 0 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_)) (<= (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))))) (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)) (= ttype_199_6_0_202_3_11_372_15 (S_store ttype_12_52_15 l_195_36 after_202_3_199_6_0_202_3_11_372_15)) (= auxVal_199_6_0_202_3_11_372_22 (S_store auxVal_12_127_18 l_195_36 after_202_3_199_6_0_202_3_11_372_22)) (= identifierVal_199_6_0_202_3_11_372_30 (S_store identifierVal_12_80_22 l_195_36 after_202_3_199_6_0_202_3_11_372_30)) (= identifierVal_199_6_0_202_3_11_372_30 (asField identifierVal_199_6_0_202_3_11_372_30 T_javafe_ast_Identifier)) (< (fClosedTime identifierVal_199_6_0_202_3_11_372_30) alloc) (= ttype_199_6_0_202_3_11_372_15 (asField ttype_199_6_0_202_3_11_372_15 T_int)) (= auxVal_199_6_0_202_3_11_372_22 (asField auxVal_199_6_0_202_3_11_372_22 T_java_lang_Object)) (< (fClosedTime auxVal_199_6_0_202_3_11_372_22) alloc) (= true_term (is RES_199_6_0_202_3_202_3 T_int)) (= EC_199_6_0_202_3_202_3 ecReturn) (forall (?brokenObj_64_ Int) (implies (and (= true_term (is ?brokenObj_64_ T_javafe_parser_Token)) (not (= ?brokenObj_64_ null)) (not (= (S_select ttype_12_52_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null))))) (and (not (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null))))))) (forall (?brokenObj_65_ Int) (implies (and (= true_term (is ?brokenObj_65_ T_javafe_parser_Token)) (not (= ?brokenObj_65_ null)) (implies (= (S_select ttype_12_52_15 ?brokenObj_65_) IDENT_15_25_26) (not (= (S_select identifierVal_12_80_22 ?brokenObj_65_) null))) (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_65_) IDENT_15_25_26)) (not (= (S_select identifierVal_199_6_0_202_3_11_372_30 ?brokenObj_65_) null)))) (= true_term true_term) (not (= l_195_36 null)) (not (= (S_select ttype_199_6_0_202_3_11_372_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= identifierVal_12_80_22_1_ identifierVal_199_6_0_202_3_11_372_30) (= ttype_12_52_15_1_ ttype_199_6_0_202_3_11_372_15) (= auxVal_12_127_18_1_ auxVal_199_6_0_202_3_11_372_22) (= elementCount_9_79_33_1_ elementCount_199_6_0_201_17_9_195_17) (= RES RES_199_6_0_202_3_202_3))) (not (= L_199_6 L_199_6)) (= EC_196_4 L_199_6) (= RES_196_4 RES)) (and (or (and (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (= true_term true_term) (= this_198_22_198_22 (S_select seqTypeDeclElem_5_1161_46 this)) (= vectorCount_198_22_9_282_17 (S_store vectorCount_9_97_33 this_198_22_198_22 after_198_22_198_22_9_282_17)) (= currentStackBottom_198_22_9_282_30 (S_store currentStackBottom_9_87_33 this_198_22_198_22 after_198_22_198_22_9_282_30)) (= vectorCount_198_22_9_282_17 (asField vectorCount_198_22_9_282_17 T_int)) (= currentStackBottom_198_22_9_282_30 (asField currentStackBottom_198_22_9_282_30 T_int)) (= EC_198_22_198_22 ecReturn) (implies (= EC_198_22_198_22 ecReturn) (= (S_select vectorCount_198_22_9_282_17 this_198_22_198_22) (+ (S_select vectorCount_9_97_33 this_198_22_198_22) 1))) (implies (= EC_198_22_198_22 ecReturn) (= (S_select currentStackBottom_198_22_9_282_30 this_198_22_198_22) (S_select elementCount_9_79_33 this_198_22_198_22))) (forall (?brokenObj_58_ Int) (implies (and (= true_term (is ?brokenObj_58_ T_javafe_util_StackVector)) (not (= ?brokenObj_58_ null)) (>= (S_select vectorCount_9_97_33 ?brokenObj_58_) 1)) (>= (S_select vectorCount_198_22_9_282_17 ?brokenObj_58_) 1))) (forall (?brokenObj_59_ Int) (implies (and (= true_term (is ?brokenObj_59_ T_javafe_util_StackVector)) (not (= ?brokenObj_59_ null)) (or (= (S_select currentStackBottom_9_87_33 ?brokenObj_59_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_59_)) (- (S_select currentStackBottom_9_87_33 ?brokenObj_59_) 1)) null))) (or (= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_59_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_59_)) (- (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_59_) 1)) null)))) (forall (?brokenObj_60_ Int) (implies (and (= true_term (is ?brokenObj_60_ T_javafe_util_StackVector)) (not (= ?brokenObj_60_ null)) (<= 0 (S_select currentStackBottom_9_87_33 ?brokenObj_60_)) (<= (S_select currentStackBottom_9_87_33 ?brokenObj_60_) (S_select elementCount_9_79_33 ?brokenObj_60_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_60_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_60_) (S_select elementCount_9_79_33 ?brokenObj_60_))))) (= identifierVal_12_80_22 identifierVal_loopold_12_80_22) (= ttype_12_52_15 ttype_loopold_12_52_15) (= EC_198_22_198_22 EC_loopold) (= auxVal_12_127_18 auxVal_loopold_12_127_18) (= elementCount_9_79_33 elementCount_loopold_9_79_33) (or (and (= true_term true_term) (not (= l_195_36 null)) (not (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= identifierVal_12_80_22_1_ identifierVal_12_80_22) (= ttype_12_52_15_1_ ttype_12_52_15) (= auxVal_12_127_18_1_ auxVal_12_127_18) (= elementCount_9_79_33_1_ elementCount_9_79_33) (= RES RES_198_22_198_22)) (and (= true_term true_term) (not (= l_195_36 null)) (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26) (not (= l_195_36 null)) (= true_term (is (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= pragma_199_6_0_200_1 (cast (S_select auxVal_12_127_18 l_195_36) T_javafe_ast_TypeDeclElemPragma)) (= tmp0_seqTypeDeclElem_199_6_0_201_1 (S_select seqTypeDeclElem_5_1161_46 this)) (not (= pragma_199_6_0_200_1 null)) (= (PO_LT (typeof pragma_199_6_0_200_1) (S_select elementType_9_43_27 tmp0_seqTypeDeclElem_199_6_0_201_1)) true_term) (= elementCount_199_6_0_201_17_9_195_17 (S_store elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1 after_201_17_199_6_0_201_17_9_195_17)) (= elementCount_199_6_0_201_17_9_195_17 (asField elementCount_199_6_0_201_17_9_195_17 T_int)) (= EC_199_6_0_201_17_201_17 ecReturn) (implies (= EC_199_6_0_201_17_201_17 ecReturn) (= (- (S_select elementCount_199_6_0_201_17_9_195_17 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) (+ (- (S_select elementCount_9_79_33 tmp0_seqTypeDeclElem_199_6_0_201_1) (S_select currentStackBottom_198_22_9_282_30 tmp0_seqTypeDeclElem_199_6_0_201_1)) 1))) (forall (?brokenObj_61_ Int) (implies (and (= true_term (is ?brokenObj_61_ T_javafe_util_StackVector)) (not (= ?brokenObj_61_ null)) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term))))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_61_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_61_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_61_)) true_term)))))) (forall (?brokenObj_62_ Int) (implies (and (= true_term (is ?brokenObj_62_ T_javafe_util_StackVector)) (not (= ?brokenObj_62_ null)) (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_9_79_33 ?brokenObj_62_))) (and (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_62_) (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_62_))))) (forall (?brokenObj_63_ Int) (implies (and (= true_term (is ?brokenObj_63_ T_javafe_util_StackVector)) (not (= ?brokenObj_63_ null)) (<= 0 (S_select elementCount_9_79_33 ?brokenObj_63_)) (<= (S_select elementCount_9_79_33 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))) (and (<= 0 (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_)) (<= (S_select elementCount_199_6_0_201_17_9_195_17 ?brokenObj_63_) (arrayLength (S_select elements_9_72_21 ?brokenObj_63_)))))) (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)) (= ttype_199_6_0_202_3_11_372_15 (S_store ttype_12_52_15 l_195_36 after_202_3_199_6_0_202_3_11_372_15)) (= auxVal_199_6_0_202_3_11_372_22 (S_store auxVal_12_127_18 l_195_36 after_202_3_199_6_0_202_3_11_372_22)) (= identifierVal_199_6_0_202_3_11_372_30 (S_store identifierVal_12_80_22 l_195_36 after_202_3_199_6_0_202_3_11_372_30)) (= identifierVal_199_6_0_202_3_11_372_30 (asField identifierVal_199_6_0_202_3_11_372_30 T_javafe_ast_Identifier)) (< (fClosedTime identifierVal_199_6_0_202_3_11_372_30) alloc) (= ttype_199_6_0_202_3_11_372_15 (asField ttype_199_6_0_202_3_11_372_15 T_int)) (= auxVal_199_6_0_202_3_11_372_22 (asField auxVal_199_6_0_202_3_11_372_22 T_java_lang_Object)) (< (fClosedTime auxVal_199_6_0_202_3_11_372_22) alloc) (= true_term (is RES_199_6_0_202_3_202_3 T_int)) (= EC_199_6_0_202_3_202_3 ecReturn) (forall (?brokenObj_64_ Int) (implies (and (= true_term (is ?brokenObj_64_ T_javafe_parser_Token)) (not (= ?brokenObj_64_ null)) (not (= (S_select ttype_12_52_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null)))) (implies (= (S_select ttype_12_52_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18 ?brokenObj_64_) null))))) (and (not (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Long)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Float)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Double)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_String)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_java_lang_Integer)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null)))) (implies (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_64_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_199_6_0_202_3_11_372_22 ?brokenObj_64_) null))))))) (forall (?brokenObj_65_ Int) (implies (and (= true_term (is ?brokenObj_65_ T_javafe_parser_Token)) (not (= ?brokenObj_65_ null)) (implies (= (S_select ttype_12_52_15 ?brokenObj_65_) IDENT_15_25_26) (not (= (S_select identifierVal_12_80_22 ?brokenObj_65_) null))) (= (S_select ttype_199_6_0_202_3_11_372_15 ?brokenObj_65_) IDENT_15_25_26)) (not (= (S_select identifierVal_199_6_0_202_3_11_372_30 ?brokenObj_65_) null)))) (= true_term true_term) (not (= l_195_36 null)) (not (= (S_select ttype_199_6_0_202_3_11_372_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= identifierVal_12_80_22_1_ identifierVal_199_6_0_202_3_11_372_30) (= ttype_12_52_15_1_ ttype_199_6_0_202_3_11_372_15) (= auxVal_12_127_18_1_ auxVal_199_6_0_202_3_11_372_22) (= elementCount_9_79_33_1_ elementCount_199_6_0_201_17_9_195_17) (= RES RES_199_6_0_202_3_202_3))) (= L_199_6 L_199_6) (= identifierVal_12_80_22_2_ identifierVal_12_80_22_1_) (= ttype_12_52_15_2_ ttype_12_52_15_1_) (= EC L_199_6) (= auxVal_12_127_18_2_ auxVal_12_127_18_1_) (= elementCount_9_79_33_2_ elementCount_9_79_33_1_) (= RES_1_ RES) (= s_204_31_204_31_35_145_79 (S_select seqTypeDeclElem_5_1161_46 this)) (> (S_select vectorCount_198_22_9_282_17 s_204_31_204_31_35_145_79) 1) (= (PO_LT (S_select elementType_9_43_27 s_204_31_204_31_35_145_79) T_javafe_ast_TypeDeclElem) true_term) (= vectorCount_204_31_35_137_19 (S_store vectorCount_198_22_9_282_17 s_204_31_204_31_35_145_79 after_204_31_204_31_35_137_17)) (= elementCount_204_31_35_139_19 (S_store elementCount_9_79_33_2_ s_204_31_204_31_35_145_79 after_204_31_204_31_35_139_17)) (= currentStackBottom_204_31_35_139_35 (S_store currentStackBottom_198_22_9_282_30 s_204_31_204_31_35_145_79 after_204_31_204_31_35_139_33)) (= vectorCount_204_31_35_137_19 (asField vectorCount_204_31_35_137_19 T_int)) (= currentStackBottom_204_31_35_139_35 (asField currentStackBottom_204_31_35_139_35 T_int)) (= elementCount_204_31_35_139_19 (asField elementCount_204_31_35_139_19 T_int)) (= true_term (is RES_204_31_204_31 T_javafe_ast_TypeDeclElemVec)) (= true_term (isAllocated RES_204_31_204_31 alloc)) (= EC_204_31_204_31 ecReturn) (implies (= EC_204_31_204_31 ecReturn) (= (S_select vectorCount_204_31_35_137_19 s_204_31_204_31_35_145_79) (- (S_select vectorCount_198_22_9_282_17 s_204_31_204_31_35_145_79) 1))) (implies (= EC_204_31_204_31 ecReturn) (not (= RES_204_31_204_31 null))) (implies (= EC_204_31_204_31 ecReturn) (= (S_select count_35_67_33 RES_204_31_204_31) (- (S_select elementCount_9_79_33_2_ s_204_31_204_31_35_145_79) (S_select currentStackBottom_198_22_9_282_30 s_204_31_204_31_35_145_79)))) (forall (?brokenObj_66_ Int) (implies (and (= true_term (is ?brokenObj_66_ T_javafe_util_StackVector)) (not (= ?brokenObj_66_ null)) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_9_79_33_2_ ?brokenObj_66_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_66_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_66_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_66_)) true_term))))) (forall (?i_9_76_31 Int) (implies (and (<= 0 ?i_9_76_31) (< ?i_9_76_31 (S_select elementCount_204_31_35_139_19 ?brokenObj_66_))) (or (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_66_)) ?i_9_76_31) null) (= (PO_LT (typeof (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_66_)) ?i_9_76_31)) (S_select elementType_9_43_27 ?brokenObj_66_)) true_term)))))) (forall (?brokenObj_67_ Int) (implies (and (= true_term (is ?brokenObj_67_ T_javafe_util_StackVector)) (not (= ?brokenObj_67_ null)) (>= (S_select vectorCount_198_22_9_282_17 ?brokenObj_67_) 1)) (>= (S_select vectorCount_204_31_35_137_19 ?brokenObj_67_) 1))) (forall (?brokenObj_68_ Int) (implies (and (= true_term (is ?brokenObj_68_ T_javafe_util_StackVector)) (not (= ?brokenObj_68_ null)) (or (= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_68_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_68_)) (- (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_68_) 1)) null))) (or (= (S_select currentStackBottom_204_31_35_139_35 ?brokenObj_68_) 0) (= (S_select (S_select elems (S_select elements_9_72_21 ?brokenObj_68_)) (- (S_select currentStackBottom_204_31_35_139_35 ?brokenObj_68_) 1)) null)))) (forall (?brokenObj_69_ Int) (implies (and (= true_term (is ?brokenObj_69_ T_javafe_util_StackVector)) (not (= ?brokenObj_69_ null)) (<= 0 (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_69_)) (<= (S_select currentStackBottom_198_22_9_282_30 ?brokenObj_69_) (S_select elementCount_9_79_33_2_ ?brokenObj_69_))) (and (<= 0 (S_select currentStackBottom_204_31_35_139_35 ?brokenObj_69_)) (<= (S_select currentStackBottom_204_31_35_139_35 ?brokenObj_69_) (S_select elementCount_204_31_35_139_19 ?brokenObj_69_))))) (forall (?brokenObj_70_ Int) (implies (and (= true_term (is ?brokenObj_70_ T_javafe_util_StackVector)) (not (= ?brokenObj_70_ null)) (<= 0 (S_select elementCount_9_79_33_2_ ?brokenObj_70_)) (<= (S_select elementCount_9_79_33_2_ ?brokenObj_70_) (arrayLength (S_select elements_9_72_21 ?brokenObj_70_)))) (and (<= 0 (S_select elementCount_204_31_35_139_19 ?brokenObj_70_)) (<= (S_select elementCount_204_31_35_139_19 ?brokenObj_70_) (arrayLength (S_select elements_9_72_21 ?brokenObj_70_)))))) (= identifierVal_12_80_22_3_ identifierVal_12_80_22_2_) (= ttype_12_52_15_3_ ttype_12_52_15_2_) (= EC_1_ EC_204_31_204_31) (= auxVal_12_127_18_3_ auxVal_12_127_18_2_) (= extras_196_20 RES_204_31_204_31) (= RES_2_ RES_204_31_204_31)) (and (not (= (S_select ttype_12_52_15 l_195_36) TYPEDECLELEMPRAGMA_14_27_26)) (= true_term true_term) (= identifierVal_12_80_22_3_ identifierVal_12_80_22) (= ttype_12_52_15_3_ ttype_12_52_15) (= EC_1_ EC_2_) (= auxVal_12_127_18_3_ auxVal_12_127_18) (= extras_196_20 null) (= RES_2_ RES_3_))) (not (= l_195_36 null)) (= loc_206_4 (S_select startingLoc_12_65_15 l_195_36)) (not (= l_195_36 null)) (not (= (S_select m_in_11_212_46 l_195_36) null)) (= modifierPragmas_207_20_7_151_15 (S_store modifierPragmas_7_134_29 this after_207_20_207_20_7_151_15)) (= modifierPragmas_207_20_7_151_15 (asField modifierPragmas_207_20_7_151_15 T_javafe_ast_ModifierPragmaVec)) (< (fClosedTime modifierPragmas_207_20_7_151_15) alloc) (= true_term (is RES_207_20_207_20 T_int)) (= EC_207_20_207_20 ecReturn) (= modifierPragmas_208_4 (S_select modifierPragmas_207_20_7_151_15 this)) (not (= loc_206_4 NULL_46_60_26)) (= ttype_210_1_4_87_17 (S_store ttype_12_52_15_3_ l_195_36 after_210_1_210_1_4_87_17)) (= ttype_210_1_4_87_17 (asField ttype_210_1_4_87_17 T_int)) (= true_term (is RES_210_1_210_1 T_javafe_ast_TypeDecl)) (= true_term (isAllocated RES_210_1_210_1 alloc)) (= EC_210_1_210_1 ecReturn) (implies (= EC_210_1_210_1 ecReturn) (not (= RES_210_1_210_1 null))) (implies (and (= EC_210_1_210_1 ecReturn) (= (S_select ttype_12_52_15_3_ l_195_36) CLASS_14_59_26)) (and (= true_term (is RES_210_1_210_1 T_javafe_ast_ClassDecl)) (not (= RES_210_1_210_1 null)))) (forall (?brokenObj_71_ Int) (implies (and (= true_term (is ?brokenObj_71_ T_javafe_parser_Token)) (not (= ?brokenObj_71_ null)) (not (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_71_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null))))) (and (not (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) BOOLEANLIT_15_38_26)) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) INTLIT_15_39_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) LONGLIT_15_40_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Long)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) FLOATLIT_15_42_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Float)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) DOUBLELIT_15_43_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Double)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) STRINGLIT_15_44_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_String)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) CHARLIT_15_41_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_java_lang_Integer)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) LEXICALPRAGMA_14_24_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_LexicalPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) MODIFIERPRAGMA_14_25_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_ModifierPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) STMTPRAGMA_14_26_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_StmtPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) TYPEDECLELEMPRAGMA_14_27_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_TypeDeclElemPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null)))) (implies (= (S_select ttype_210_1_4_87_17 ?brokenObj_71_) TYPEMODIFIERPRAGMA_14_28_26) (and (= true_term (is (S_select auxVal_12_127_18_3_ ?brokenObj_71_) T_javafe_ast_TypeModifierPragma)) (not (= (S_select auxVal_12_127_18_3_ ?brokenObj_71_) null))))))) (forall (?brokenObj_72_ Int) (implies (and (= true_term (is ?brokenObj_72_ T_javafe_parser_Token)) (not (= ?brokenObj_72_ null)) (implies (= (S_select ttype_12_52_15_3_ ?brokenObj_72_) IDENT_15_25_26) (not (= (S_select identifierVal_12_80_22_3_ ?brokenObj_72_) null))) (= (S_select ttype_210_1_4_87_17 ?brokenObj_72_) IDENT_15_25_26)) (not (= (S_select identifierVal_12_80_22_3_ ?brokenObj_72_) null)))) (or (and (not (= extras_196_20 null)) (= true_term true_term) (= EC_210_1_210_1 EC_loopold_1_) (= 0 i_loopold_212_10) (or (and (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_212_28_212_28 T_int)) (= EC_212_1_0_212_28_212_28 ecReturn) (implies (= EC_212_1_0_212_28_212_28 ecReturn) (= RES_212_1_0_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (not (< 0 RES_212_1_0_212_28_212_28)) (= RES_4_ RES_212_1_0_212_28_212_28)) (and (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_212_28_212_28 T_int)) (= EC_212_1_0_212_28_212_28 ecReturn) (implies (= EC_212_1_0_212_28_212_28 ecReturn) (= RES_212_1_0_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (< 0 RES_212_1_0_212_28_212_28) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_213_10_213_10 T_javafe_ast_TypeDeclElem)) (= true_term (isAllocated RES_212_1_0_213_10_213_10 alloc)) (= EC_212_1_0_213_10_213_10 ecReturn) (implies (= EC_212_1_0_213_10_213_10 ecReturn) (not (= RES_212_1_0_213_10_213_10 null))) (not (= RES_212_1_0_213_10_213_10 null)) (not (= RES_210_1_210_1 null)) (= EC_212_1_0_213_23_213_23 ecReturn) (= i_212_1_0_212_36 (+ 0 1)) (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_1_212_28_212_28 T_int)) (= EC_212_1_1_212_28_212_28 ecReturn) (implies (= EC_212_1_1_212_28_212_28 ecReturn) (= RES_212_1_1_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (not (< i_212_1_0_212_36 RES_212_1_1_212_28_212_28)) (= RES_4_ RES_212_1_1_212_28_212_28))) (not (= L_212_1 L_212_1)) (= EC_196_4 L_212_1) (= RES_196_4 RES_4_)) (and (or (and (not (= extras_196_20 null)) (= true_term true_term) (= EC_210_1_210_1 EC_loopold_1_) (= 0 i_loopold_212_10) (or (and (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_212_28_212_28 T_int)) (= EC_212_1_0_212_28_212_28 ecReturn) (implies (= EC_212_1_0_212_28_212_28 ecReturn) (= RES_212_1_0_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (not (< 0 RES_212_1_0_212_28_212_28)) (= RES_4_ RES_212_1_0_212_28_212_28)) (and (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_212_28_212_28 T_int)) (= EC_212_1_0_212_28_212_28 ecReturn) (implies (= EC_212_1_0_212_28_212_28 ecReturn) (= RES_212_1_0_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (< 0 RES_212_1_0_212_28_212_28) (not (= extras_196_20 null)) (= true_term (is RES_212_1_0_213_10_213_10 T_javafe_ast_TypeDeclElem)) (= true_term (isAllocated RES_212_1_0_213_10_213_10 alloc)) (= EC_212_1_0_213_10_213_10 ecReturn) (implies (= EC_212_1_0_213_10_213_10 ecReturn) (not (= RES_212_1_0_213_10_213_10 null))) (not (= RES_212_1_0_213_10_213_10 null)) (not (= RES_210_1_210_1 null)) (= EC_212_1_0_213_23_213_23 ecReturn) (= i_212_1_0_212_36 (+ 0 1)) (= true_term true_term) (not (= extras_196_20 null)) (= true_term (is RES_212_1_1_212_28_212_28 T_int)) (= EC_212_1_1_212_28_212_28 ecReturn) (implies (= EC_212_1_1_212_28_212_28 ecReturn) (= RES_212_1_1_212_28_212_28 (S_select count_35_67_33 extras_196_20))) (not (< i_212_1_0_212_36 RES_212_1_1_212_28_212_28)) (= RES_4_ RES_212_1_1_212_28_212_28))) (= L_212_1 L_212_1) (= EC_3_ L_212_1) (= RES_5_ RES_4_) (not (= RES_210_1_210_1 null)) (not (= extras_196_20 null)) (= vec_215_8_215_8_35_308_43 (S_select elems_27_41_39 RES_210_1_210_1)) (not (= vec_215_8_215_8_35_308_43 null)) (= count_215_8_35_306_15 (S_store count_35_67_33 extras_196_20 after_215_8_215_8_35_306_15)) (= count_215_8_35_306_15 (asField count_215_8_35_306_15 T_int)) (= EC_215_8_215_8 ecReturn) (implies (= EC_215_8_215_8 ecReturn) (= (S_select count_215_8_35_306_15 extras_196_20) (+ (S_select count_35_67_33 extras_196_20) (S_select count_215_8_35_306_15 vec_215_8_215_8_35_308_43)))) (forall (?brokenObj_73_ Int) (implies (and (= true_term (is ?brokenObj_73_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_73_ null)) (forall (?i_35_62_31 Int) (implies (and (<= 0 ?i_35_62_31) (< ?i_35_62_31 (S_select count_35_67_33 ?brokenObj_73_))) (not (= (S_select (S_select elems (S_select elements_35_61_41 ?brokenObj_73_)) ?i_35_62_31) null))))) (forall (?i_35_62_31 Int) (implies (and (<= 0 ?i_35_62_31) (< ?i_35_62_31 (S_select count_215_8_35_306_15 ?brokenObj_73_))) (not (= (S_select (S_select elems (S_select elements_35_61_41 ?brokenObj_73_)) ?i_35_62_31) null)))))) (forall (?brokenObj_74_ Int) (implies (and (= true_term (is ?brokenObj_74_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_74_ null)) (<= 0 (S_select count_35_67_33 ?brokenObj_74_))) (<= 0 (S_select count_215_8_35_306_15 ?brokenObj_74_)))) (forall (?brokenObj_75_ Int) (implies (and (= true_term (is ?brokenObj_75_ T_javafe_ast_TypeDeclElemVec)) (not (= ?brokenObj_75_ null)) (<= (S_select count_35_67_33 ?brokenObj_75_) (arrayLength (S_select elements_35_61_41 ?brokenObj_75_)))) (<= (S_select count_215_8_35_306_15 ?brokenObj_75_) (arrayLength (S_select elements_35_61_41 ?brokenObj_75_))))) (not (= RES_210_1_210_1 null)) (not (= extras_196_20 null)) (= elems_216_8 (S_store elems_27_41_39 RES_210_1_210_1 extras_196_20)) (= EC_4_ EC_215_8_215_8) (= RES_6_ RES_215_8_215_8)) (and (not (not (= extras_196_20 null))) (= true_term true_term) (= EC_4_ EC_210_1_210_1) (= RES_6_ RES_210_1_210_1))) (= true_term true_term) (= EC_196_4 ecReturn) (= RES_196_4 RES_210_1_210_1))))) (or (not (= EC_196_4 ecReturn)) (and (= EC_196_4 ecReturn) (not (implies (= EC_196_4 ecReturn) (not (= RES_196_4 null))))))))))))))
