#!/bin/sh
export CVS_RSH=ssh

#from cvc3
builddir=/scratch/cvc
version=`date +%Y%m%d`
sourcedist=/home/barrett/public_html/cvc3-latest


#definitions for cvchol
cvcholversion=0.1
cvcholdir=/scratch/cvchol
cvcholname=cvchol
cvc3dir=$builddir/cvc3/cvc3-$version
#cvc3dir=/home/yeting/cvc3_zaphod
failure5=$cvcholdir/message-cvchol-failure
success5=$cvcholdir/message-cvchol-success
logcvchol1=/$cvcholdir/log1
logcvchol2=/$cvcholdir/log2
cvcholtar=cvchol-$cvcholversion.tar.gz
#cvcholdestdir=$sourcedist
cvcholdestdir=/home/yeting

# test CVCHOL
/bin/sh > $logcvchol1 2>&1 <<EOF
ulimit -t 600
cd $cvcholdir/
# Clear the old cvchol
rm -f message-*
rm -rf $cvcholname
# run test
cvs -d /misc/acsys/acsys/repository co $cvcholname && cd $cvcholname && make dist && cp $cvcholtar ../ && cd .. && rm -rf $cvcholname && tar -zxf $cvcholtar && cd $cvcholname && make "CVC_DIR=$cvc3dir"  && mv -f ./cvc_hol ../ && cd .. && ./cvc_hol < ./cmds >& $logcvchol2 &&  grep 'proof translation success' $logcvchol2 | awk 'END {if (NR == 37) exit 0 ;else exit 1}' 
if [ \$? -ne 0 ]; then
  cat $logcvchol1 > $failure5
  cat $logcvchol2 >> $failure5
  chmod g+rw $failure5
else
  cat $logcvchol1 > $success5
  cat $logcvchol2 >> $success5
  chmod g+rw $success5
# Publish the sources
  cp $cvcholtar $cvcholdestdir
  chmod g+rw $cvcholdestdir/$cvcholtar
fi
EOF
