(*****************************************************************************/
/*!
 * \file ml_interface.ml
 *
 * Interface file required by OCaml	 						
 * 
 * <hr>
 *
 * License to use, copy, modify, sell and/or distribute this software
 * and its documentation for any purpose is hereby granted without
 * royalty, subject to the terms and conditions defined in the \ref
 * README file provided with this distribution.
 * 
 * <hr>
 * 
 */
/*****************************************************************************)

type cvc_vc;;
type cvc_em;;
type cvc_expr;;
type cvc_type;;

external ml_reset_error_status : unit -> unit = 
    "ml_reset_error_status";;

external ml_get_error_sring : unit -> string = 
    "ml_vc_get_error_string";;


external ml_vc_destroyValidityChecker : cvc_vc -> unit  = 
    "ml_vc_destroyValidityChecker";;

external ml_vc_createValidityCheckerCVC : bool -> cvc_vc = 
    "ml_vc_createValidityCheckerCVC";;

external ml_vc_createValidityCheckerSMT : bool -> cvc_vc = 
    "ml_vc_createValidityCheckerSMT";;

external ml_vc_getProofOfFile: cvc_vc->string-> cvc_expr = 
    "ml_vc_getProofOfFile";;

external ml_vc_getProofAssumptions: cvc_vc-> cvc_expr = 
    "ml_vc_getProofAssumptions";;

external ml_vc_getProofQuery: cvc_vc-> cvc_expr = 
    "ml_vc_getProofQuery";;


external ml_vc_boolType : cvc_vc -> cvc_type =
    "ml_vc_boolType";;

external ml_vc_realType : cvc_vc -> cvc_type =
    "ml_vc_realType";;

external ml_vc_intType : cvc_vc -> cvc_type =
    "ml_vc_intType";;

external ml_vc_arrayType : cvc_vc -> cvc_type -> cvc_type -> cvc_type =
    "ml_vc_arrayType";;

external ml_vc_getEM : cvc_vc -> cvc_em = 
    "ml_vc_getEM";;

external ml_vc_getKindInt : cvc_vc -> string -> int = 
    "ml_vc_getKindInt";;

external ml_vc_getKindString : cvc_vc -> int -> string = 
    "ml_vc_getKindString";;


external ml_vc_varExpr : cvc_vc -> string -> cvc_type -> cvc_expr = 
    "ml_vc_varExpr";;

external ml_vc_lookupVar : cvc_vc -> string -> cvc_type =
    "ml_vc_lookupVar";;

external ml_vc_getType : cvc_vc -> cvc_expr -> cvc_type = 
    "ml_vc_getType";;

external ml_vc_getFun : cvc_vc -> cvc_expr -> cvc_expr = 
    "ml_vc_getFun";;

(*external ml_vc_getOp : cvc_vc -> cvc_expr -> cvc_expr = 
    "ml_vc_getOp";;
*)
external ml_vc_eqExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_eqExpr";;

external ml_vc_trueExpr : cvc_vc -> cvc_expr =
    "ml_vc_trueExpr";;

external ml_vc_falseExpr : cvc_vc -> cvc_expr =
    "ml_vc_falseExpr";;

external ml_vc_notExpr : cvc_vc -> cvc_expr -> cvc_expr =
    "ml_vc_notExpr";;

external ml_vc_andExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_andExpr";;

external ml_vc_orExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_orExpr";;

external ml_vc_impliesExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_impliesExpr";;

external ml_vc_iffExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_iffExpr";;

external ml_vc_iteExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_iteExpr";;

external ml_vc_ratExpr : cvc_vc -> int -> int -> cvc_expr =
    "ml_vc_ratExpr";;

external ml_vc_ratExprFromStr : cvc_vc -> string -> string -> int -> cvc_expr =
    "ml_vc_ratExprFromStr";;

external ml_vc_uminusExpr : cvc_vc -> cvc_expr -> cvc_expr =
    "ml_vc_uminusExpr";;

external ml_vc_plusExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_plusExpr";;

external ml_vc_minusExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_minusExpr";;

external ml_vc_multExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_multExpr";;

external ml_vc_powExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_powExpr";;

external ml_vc_divideExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_divideExpr";;

external ml_vc_ltExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_ltExpr";;

external ml_vc_leExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_leExpr";;

external ml_vc_gtExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_gtExpr";;

external ml_vc_geExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_geExpr";;

external ml_vc_assertFormula : cvc_vc -> cvc_expr -> unit =
    "ml_vc_assertFormula";;

external ml_vc_simplify : cvc_vc -> cvc_expr -> cvc_expr =
    "ml_vc_simplify";;

external ml_vc_query : cvc_vc -> cvc_expr -> int = 
    "ml_vc_query";;

external ml_vc_getProof : cvc_vc -> cvc_expr = 
    "ml_vc_getProof";;

external ml_expr_toString : cvc_expr -> string = 
    "ml_expr_toString";;                

external ml_type_toString : cvc_type -> string = 
    "ml_type_toString";;                

external ml_expr_arity : cvc_expr -> int = 
    "ml_expr_arity";;

external ml_expr_child : cvc_expr -> int -> cvc_expr = 
    "ml_expr_child";;

external ml_expr_getKind : cvc_expr -> int = 
    "ml_expr_getKind";;

external ml_expr_isClosure : cvc_expr -> bool = 
    "ml_expr_isClosure";;

external ml_expr_isQuantifier : cvc_expr -> bool = 
    "ml_expr_isQuantifier";;

external ml_expr_isLambda : cvc_expr -> bool = 
    "ml_expr_isLambda";;

external ml_expr_getNumVars : cvc_expr -> int = 
    "ml_expr_getNumVars";;

external ml_expr_getVar : cvc_expr -> int -> cvc_expr = 
    "ml_expr_getVar";;

external ml_expr_getBody : cvc_expr -> cvc_expr = 
    "ml_expr_getBody";;

external ml_expr_getExistential : cvc_expr -> cvc_expr = 
    "ml_expr_getExistential";;

external ml_type_toExpr : cvc_type -> cvc_expr = 
    "ml_type_toExpr";;

external ml_expr_isVar : cvc_expr -> bool = 
    "ml_expr_isVar";;

external ml_expr_getInt : cvc_expr -> int =
    "ml_expr_getInt";;

external ml_expr_compare : cvc_expr -> cvc_expr -> int =
    "ml_expr_compare";;

(* arrays *)
external ml_vc_readExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_readExpr";;

external ml_vc_writeExpr : cvc_vc -> cvc_expr -> cvc_expr -> cvc_expr -> cvc_expr =
    "ml_vc_writeExpr";;

(*external ml_getExprAttr : cvc_expr -> int -> cvc_expr  =
  "ml_getExprAttr";;
*)


