(benchmark simplify_benchmark
:source { Simplify Theorem Prover Benchmark Suite }
:logic AUFLIA
:status unsat
:difficulty { 5 }
:category { industrial }
:extrafuns ((true_term Int))
:extrafuns ((false_term Int))
:assumption (= true_term 1)
:assumption (= false_term 0)
:extrafuns ((S_select Int Int Int))
:extrafuns ((S_store Int Int Int Int))
:assumption (forall (?m Int) (?i Int) (?x Int) (= (S_select (S_store ?m ?i ?x) ?i) ?x))
:assumption (forall (?m Int) (?i Int) (?j Int) (?x Int) (implies (not (= ?i ?j)) (= (S_select (S_store ?m ?i ?x) ?j) (S_select ?m ?j))))
:extrafuns ((PO_LT Int Int Int))
:assumption (forall (?t Int) (= (PO_LT ?t ?t) true_term))
:extrafuns ((T_java_lang_Object Int))
:assumption (= (PO_LT T_java_lang_Object T_java_lang_Object) true_term)
:assumption (forall (?t0 Int) (?t1 Int) (?t2 Int) (implies (and (= (PO_LT ?t0 ?t1) true_term) (= (PO_LT ?t1 ?t2) true_term)) (= (PO_LT ?t0 ?t2) true_term)))
:assumption (forall (?t0 Int) (?t1 Int) (implies (and (= (PO_LT ?t0 ?t1) true_term) (= (PO_LT ?t1 ?t0) true_term)) (= ?t0 ?t1)))
:extrafuns ((T_boolean Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_boolean) true_term) (= ?t T_boolean)))
:extrafuns ((T_char Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_char) true_term) (= ?t T_char)))
:extrafuns ((T_byte Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_byte) true_term) (= ?t T_byte)))
:extrafuns ((T_short Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_short) true_term) (= ?t T_short)))
:extrafuns ((T_int Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_int) true_term) (= ?t T_int)))
:extrafuns ((T_long Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_long) true_term) (= ?t T_long)))
:extrafuns ((T_float Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_float) true_term) (= ?t T_float)))
:extrafuns ((T_double Int))
:assumption (forall (?t Int) (implies (= (PO_LT ?t T_double) true_term) (= ?t T_double)))
:assumption (forall (?t Int) (implies (= (PO_LT T_boolean ?t) true_term) (= ?t T_boolean)))
:assumption (forall (?t Int) (implies (= (PO_LT T_char ?t) true_term) (= ?t T_char)))
:assumption (forall (?t Int) (implies (= (PO_LT T_byte ?t) true_term) (= ?t T_byte)))
:assumption (forall (?t Int) (implies (= (PO_LT T_short ?t) true_term) (= ?t T_short)))
:assumption (forall (?t Int) (implies (= (PO_LT T_int ?t) true_term) (= ?t T_int)))
:assumption (forall (?t Int) (implies (= (PO_LT T_long ?t) true_term) (= ?t T_long)))
:assumption (forall (?t Int) (implies (= (PO_LT T_float ?t) true_term) (= ?t T_float)))
:assumption (forall (?t Int) (implies (= (PO_LT T_double ?t) true_term) (= ?t T_double)))
:extrafuns ((asChild Int Int Int))
:extrafuns ((classDown Int Int Int))
:assumption (forall (?t0 Int) (?t1 Int) (?t2 Int) (implies (= (PO_LT ?t0 (asChild ?t1 ?t2)) true_term) (= (classDown ?t2 ?t0) (asChild ?t1 ?t2))))
:extrafuns ((T_java_lang_Cloneable Int))
:assumption (= (PO_LT T_java_lang_Cloneable T_java_lang_Object) true_term)
:extrafuns ((array Int Int))
:assumption (forall (?t Int) (= (PO_LT (array ?t) T_java_lang_Cloneable) true_term))
:extrafuns ((elemtype Int Int))
:assumption (forall (?t Int) (= (elemtype (array ?t)) ?t))
:assumption (forall (?t0 Int) (?t1 Int) (iff (= (PO_LT ?t0 (array ?t1)) true_term) (and (= ?t0 (array (elemtype ?t0))) (= (PO_LT (elemtype ?t0) ?t1) true_term))))
:extrafuns ((is Int Int Int))
:extrafuns ((cast Int Int Int))
:assumption (forall (?x Int) (?t Int) (= (is (cast ?x ?t) ?t) true_term))
:assumption (forall (?x Int) (?t Int) (implies (= (is ?x ?t) true_term) (= (cast ?x ?t) ?x)))
:assumption true
:assumption (forall (?x Int) (iff (= (is ?x T_char) true_term) (and (<= 0 ?x) (<= ?x 65535))))
:assumption (forall (?x Int) (iff (= (is ?x T_byte) true_term) (and (<= (~ 128) ?x) (<= ?x 127))))
:assumption (forall (?x Int) (iff (= (is ?x T_short) true_term) (and (<= (~ 32768) ?x) (<= ?x 32767))))
:extrafuns ((intFirst Int))
:extrafuns ((intLast Int))
:assumption (forall (?x Int) (iff (= (is ?x T_int) true_term) (and (<= intFirst ?x) (<= ?x intLast))))
:extrafuns ((longFirst Int))
:extrafuns ((longLast Int))
:assumption (forall (?x Int) (iff (= (is ?x T_long) true_term) (and (<= longFirst ?x) (<= ?x longLast))))
:assumption (< longFirst intFirst)
:assumption (< intFirst (~ 1000000))
:assumption (< 1000000 intLast)
:assumption (< intLast longLast)
:extrafuns ((null Int))
:extrafuns ((typeof Int Int))
:assumption (forall (?x Int) (?t Int) (implies (= (PO_LT ?t T_java_lang_Object) true_term) (iff (= (is ?x ?t) true_term) (or (= ?x null) (= (PO_LT (typeof ?x) ?t) true_term)))))
:extrafuns ((asField Int Int Int))
:assumption (forall (?f Int) (?t Int) (?x Int) (= (is (S_select (asField ?f ?t) ?x) ?t) true_term))
:extrafuns ((asElems Int Int))
:assumption (forall (?e Int) (?a Int) (?i Int) (= (is (S_select (S_select (asElems ?e) ?a) ?i) (elemtype (typeof ?a))) true_term))
:extrafuns ((vAllocTime Int Int))
:extrafuns ((isAllocated Int Int Int))
:assumption (forall (?x Int) (?a0 Int) (iff (= (isAllocated ?x ?a0) true_term) (< (vAllocTime ?x) ?a0)))
:extrafuns ((fClosedTime Int Int))
:assumption (forall (?x Int) (?f Int) (?a0 Int) (implies (and (< (fClosedTime ?f) ?a0) (= (isAllocated ?x ?a0) true_term)) (= (isAllocated (S_select ?f ?x) ?a0) true_term)))
:extrafuns ((eClosedTime Int Int))
:assumption (forall (?a Int) (?e Int) (?i Int) (?a0 Int) (implies (and (< (eClosedTime ?e) ?a0) (= (isAllocated ?a ?a0) true_term)) (= (isAllocated (S_select (S_select ?e ?a) ?i) ?a0) true_term)))
:extrafuns ((asLockSet Int Int))
:extrafuns ((max Int Int))
:assumption (forall (?S Int) (= (S_select (asLockSet ?S) (max (asLockSet ?S))) true_term))
:assumption (forall (?S Int) (= (S_select (asLockSet ?S) null) true_term))
:extrafuns ((lockLE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (lockLE ?x ?y) true_term) (<= ?x ?y)))
:extrafuns ((lockLT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (lockLT ?x ?y) true_term) (< ?x ?y)))
:assumption (forall (?S Int) (?mu Int) (implies (= (S_select (asLockSet ?S) ?mu) true_term) (= (lockLE ?mu (max (asLockSet ?S))) true_term)))
:assumption (forall (?x Int) (implies (= (PO_LT (typeof ?x) T_java_lang_Object) true_term) (= (lockLE null ?x) true_term)))
:extrafuns ((arrayLength Int Int))
:assumption (forall (?a Int) (and (<= 0 (arrayLength ?a)) (= (is (arrayLength ?a) T_int) true_term)))
:extrafuns ((arrayFresh Int Int Int Int Int Int Int Int))
:extrafuns ((arrayShapeMore Int Int Int))
:extrafuns ((arrayParent Int Int))
:extrafuns ((arrayPosition Int Int))
:assumption (forall (?a Int) (?a0 Int) (?b0 Int) (?e Int) (?n Int) (?s Int) (?T Int) (?v Int) (iff (= (arrayFresh ?a ?a0 ?b0 ?e (arrayShapeMore ?n ?s) ?T ?v) true_term) (and (<= ?a0 (vAllocTime ?a)) (= (isAllocated ?a ?b0) true_term) (not (= ?a null)) (= (typeof ?a) ?T) (= (arrayLength ?a) ?n) (forall (?i Int) (and (= (arrayFresh (S_select (S_select ?e ?a) ?i) ?a0 ?b0 ?e ?s (elemtype ?T) ?v) true_term) (= (arrayParent (S_select (S_select ?e ?a) ?i)) ?a) (= (arrayPosition (S_select (S_select ?e ?a) ?i)) ?i))))))
:extrafuns ((arrayShapeOne Int Int))
:assumption (forall (?a Int) (?a0 Int) (?b0 Int) (?e Int) (?n Int) (?T Int) (?v Int) (iff (= (arrayFresh ?a ?a0 ?b0 ?e (arrayShapeOne ?n) ?T ?v) true_term) (and (<= ?a0 (vAllocTime ?a)) (= (isAllocated ?a ?b0) true_term) (not (= ?a null)) (= (typeof ?a) ?T) (= (arrayLength ?a) ?n) (forall (?i Int) (and (= (S_select (S_select ?e ?a) ?i) ?v))))))
:extrafuns ((arrayType Int))
:assumption (= arrayType (asChild arrayType T_java_lang_Object))
:assumption (forall (?t Int) (= (PO_LT (array ?t) arrayType) true_term))
:extrafuns ((isNewArray Int Int))
:assumption (forall (?s Int) (implies (= true_term (isNewArray ?s)) (= (PO_LT (typeof ?s) arrayType) true_term)))
:extrafuns ((boolAnd Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolAnd ?a ?b) true_term) (and (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolEq Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolEq ?a ?b) true_term) (iff (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolImplies Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolImplies ?a ?b) true_term) (implies (= ?a true_term) (= ?b true_term))))
:extrafuns ((boolNE Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolNE ?a ?b) true_term) (not (iff (= ?a true_term) (= ?b true_term)))))
:extrafuns ((boolNot Int Int))
:assumption (forall (?a Int) (iff (= (boolNot ?a) true_term) (not (= ?a true_term))))
:extrafuns ((boolOr Int Int Int))
:assumption (forall (?a Int) (?b Int) (iff (= (boolOr ?a ?b) true_term) (or (= ?a true_term) (= ?b true_term))))
:extrafuns ((integralEQ Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralEQ ?x ?y) true_term) (= ?x ?y)))
:extrafuns ((stringCat Int Int Int))
:extrafuns ((T_java_lang_String Int))
:assumption (forall (?x Int) (?y Int) (and (not (= (stringCat ?x ?y) null)) (= (PO_LT (typeof (stringCat ?x ?y)) T_java_lang_String) true_term)))
:extrafuns ((integralGE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralGE ?x ?y) true_term) (>= ?x ?y)))
:extrafuns ((integralGT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralGT ?x ?y) true_term) (> ?x ?y)))
:extrafuns ((integralLE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralLE ?x ?y) true_term) (<= ?x ?y)))
:extrafuns ((integralLT Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralLT ?x ?y) true_term) (< ?x ?y)))
:extrafuns ((integralNE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (integralNE ?x ?y) true_term) (not (= ?x ?y))))
:extrafuns ((refEQ Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (refEQ ?x ?y) true_term) (= ?x ?y)))
:extrafuns ((refNE Int Int Int))
:assumption (forall (?x Int) (?y Int) (iff (= (refNE ?x ?y) true_term) (not (= ?x ?y))))
:extrafuns ((nonnullelements Int Int Int))
:assumption (forall (?x Int) (?e Int) (iff (= (nonnullelements ?x ?e) true_term) (and (not (= ?x null)) (forall (?i Int) (implies (and (<= 0 ?i) (< ?i (arrayLength ?x))) (not (= (S_select (S_select ?e ?x) ?i) null)))))))
:extrafuns ((classLiteral Int Int))
:extrafuns ((T_java_lang_Class Int))
:extrafuns ((alloc Int))
:assumption (forall (?t Int) (and (not (= (classLiteral ?t) null)) (= (is (classLiteral ?t) T_java_lang_Class) true_term) (= (isAllocated (classLiteral ?t) alloc) true_term)))
:extrafuns ((integralAnd Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (or (<= 0 ?x) (<= 0 ?y)) (<= 0 (integralAnd ?x ?y))))
:assumption (forall (?x Int) (?y Int) (implies (<= 0 ?x) (<= (integralAnd ?x ?y) ?x)))
:assumption (forall (?x Int) (?y Int) (implies (<= 0 ?y) (<= (integralAnd ?x ?y) ?y)))
:extrafuns ((integralOr Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (and (<= 0 ?x) (<= 0 ?y)) (and (<= ?x (integralOr ?x ?y)) (<= ?y (integralOr ?x ?y)))))
:extrafuns ((integralXor Int Int Int))
:assumption (forall (?x Int) (?y Int) (implies (and (<= 0 ?x) (<= 0 ?y)) (<= 0 (integralXor ?x ?y))))
:extrafuns ((intShiftL Int Int Int))
:assumption (forall (?n Int) (implies (and (<= 0 ?n) (< ?n 31)) (<= 1 (intShiftL 1 ?n))))
:extrafuns ((longShiftL Int Int Int))
:assumption (forall (?n Int) (implies (and (<= 0 ?n) (< ?n 63)) (<= 1 (longShiftL 1 ?n))))
:assumption true
:extrafuns ((T_javafe_ast_TypeDeclElemVec Int))
:extrafuns ((T_javafe_ast_IfStmt Int))
:extrafuns ((T_javafe_ast_Stmt Int))
:extrafuns ((T_javafe_ast_PrimitiveType Int))
:extrafuns ((T_javafe_ast_Type Int))
:extrafuns ((T_javafe_ast_GeneratedTags Int))
:extrafuns ((T_javafe_tc_TagConstants Int))
:extrafuns ((T_javafe_parser_TagConstants Int))
:extrafuns ((T_javafe_tc_FlowInsensitiveChecks Int))
:extrafuns ((T_javafe_util_Assert Int))
:extrafuns ((T_javafe_ast_ExprVec Int))
:extrafuns ((T_javafe_ast_MethodInvocation Int))
:extrafuns ((T_javafe_ast_Expr Int))
:extrafuns ((T_javafe_tc_EnvForTypeSig Int))
:extrafuns ((T_javafe_tc_Env Int))
:extrafuns ((T_javafe_ast_SuperObjectDesignator Int))
:extrafuns ((T_javafe_ast_ObjectDesignator Int))
:extrafuns ((T_java_lang_Float Int))
:extrafuns ((T_java_lang_Number Int))
:extrafuns ((T_java_lang_Comparable Int))
:extrafuns ((T_java_lang_Integer Int))
:extrafuns ((T_javafe_tc_TypeSigVec Int))
:extrafuns ((T_javafe_ast_BranchStmt Int))
:extrafuns ((T_javafe_ast_ArrayRefExpr Int))
:extrafuns ((T_javafe_ast_SkipStmt Int))
:extrafuns ((T_javafe_ast_AmbiguousVariableAccess Int))
:extrafuns ((T_javafe_ast_ParenExpr Int))
:extrafuns ((T_javafe_ast_Identifier Int))
:extrafuns ((T_javafe_ast_CastExpr Int))
:extrafuns ((T_javafe_ast_OnDemandImportDecl Int))
:extrafuns ((T_javafe_ast_ImportDecl Int))
:extrafuns ((T_javafe_ast_ContinueStmt Int))
:extrafuns ((T_java_lang_Double Int))
:extrafuns ((T_javafe_tc_TypeSig Int))
:extrafuns ((T_javafe_ast_LocalVarDecl Int))
:extrafuns ((T_javafe_ast_GenericVarDecl Int))
:extrafuns ((T_javafe_ast_FieldDecl Int))
:extrafuns ((T_javafe_ast_TypeDeclElem Int))
:extrafuns ((T_javafe_ast_InstanceOfExpr Int))
:extrafuns ((T_javafe_ast_ClassDecl Int))
:extrafuns ((T_javafe_ast_TypeDecl Int))
:extrafuns ((T_javafe_ast_TypeObjectDesignator Int))
:extrafuns ((T_javafe_ast_BinaryExpr Int))
:extrafuns ((T_javafe_ast_SwitchStmt Int))
:extrafuns ((T_javafe_ast_GenericBlockStmt Int))
:extrafuns ((T_java_util_Map Int))
:extrafuns ((T_java_util_EscjavaKeyValue Int))
:extrafuns ((T_javafe_ast_DoStmt Int))
:extrafuns ((T_java_util_Dictionary Int))
:extrafuns ((T_javafe_ast_SwitchLabel Int))
:extrafuns ((T_java_lang_Long Int))
:extrafuns ((T_javafe_ast_VarDeclStmt Int))
:extrafuns ((T_javafe_tc_Types Int))
:extrafuns ((T_java_io_Serializable Int))
:extrafuns ((T_javafe_ast_VariableAccess Int))
:extrafuns ((T_javafe_ast_ASTNode Int))
:extrafuns ((T_javafe_ast_VarInit Int))
:extrafuns ((T_javafe_ast_InitBlock Int))
:extrafuns ((T_javafe_ast_UnaryExpr Int))
:extrafuns ((T_javafe_ast_ReturnStmt Int))
:extrafuns ((T_javafe_ast_BlockStmt Int))
:extrafuns ((T_javafe_ast_BreakStmt Int))
:extrafuns ((T_javafe_ast_TagConstants Int))
:extrafuns ((T_javafe_ast_OperatorTags Int))
:extrafuns ((T_javafe_util_Location Int))
:extrafuns ((T_javafe_ast_CondExpr Int))
:extrafuns ((T_javafe_ast_CatchClause Int))
:extrafuns ((T_javafe_ast_TypeNameVec Int))
:extrafuns ((T_javafe_ast_SingleTypeImportDecl Int))
:extrafuns ((T_javafe_ast_TryFinallyStmt Int))
:extrafuns ((T_javafe_ast_TryCatchStmt Int))
:extrafuns ((T_javafe_ast_VarInitVec Int))
:extrafuns ((T_javafe_ast_LiteralExpr Int))
:extrafuns ((T_java_lang_Boolean Int))
:extrafuns ((T_javafe_ast_InterfaceDecl Int))
:extrafuns ((T_javafe_tc_FieldDeclVec Int))
:extrafuns ((T_javafe_ast_ClassLiteral Int))
:extrafuns ((T_javafe_ast_ConstructorInvocation Int))
:extrafuns ((T_javafe_tc_MethodDeclVec Int))
:extrafuns ((T_javafe_ast_NewInstanceExpr Int))
:extrafuns ((T_javafe_ast_MethodDecl Int))
:extrafuns ((T_javafe_ast_RoutineDecl Int))
:extrafuns ((T_javafe_tc_CheckInvariants Int))
:extrafuns ((T_javafe_ast_ConstructorDecl Int))
:extrafuns ((T_javafe_ast_ThisExpr Int))
:extrafuns ((T_javafe_ast_CompoundName Int))
:extrafuns ((T_javafe_ast_Name Int))
:extrafuns ((T_javafe_ast_CatchClauseVec Int))
:extrafuns ((T_javafe_ast_IdentifierVec Int))
:extrafuns ((T_javafe_ast_LabelStmt Int))
:extrafuns ((T_javafe_ast_CompilationUnit Int))
:extrafuns ((T_javafe_ast_SimpleName Int))
:extrafuns ((T_javafe_ast_ArrayType Int))
:extrafuns ((T_javafe_ast_AmbiguousMethodInvocation Int))
:extrafuns ((T_javafe_ast_ForStmt Int))
:extrafuns ((T_javafe_ast_SynchronizeStmt Int))
:extrafuns ((T_javafe_ast_ASTDecoration Int))
:extrafuns ((T_java_util_Hashtable Int))
:extrafuns ((T_javafe_ast_TypeName Int))
:extrafuns ((T_javafe_ast_FormalParaDeclVec Int))
:extrafuns ((T_javafe_ast_ThrowStmt Int))
:extrafuns ((T_javafe_ast_WhileStmt Int))
:extrafuns ((T_javafe_ast_ExprObjectDesignator Int))
:extrafuns ((T_javafe_ast_NewArrayExpr Int))
:extrafuns ((T_javafe_ast_ClassDeclStmt Int))
:extrafuns ((T_javafe_ast_ArrayInit Int))
:extrafuns ((T_javafe_ast_FormalParaDecl Int))
:extrafuns ((T_javafe_ast_StmtVec Int))
:extrafuns ((T_javafe_ast_FieldAccess Int))
:extrafuns ((T_javafe_ast_EvalStmt Int))
:extrafuns ((DIST_ZERO_1 Int))
:extrafuns ((T__TYPE Int))
:extrafuns ((RSHIFT_23_31_26 Int))
:extrafuns ((FORSTMT_24_39_7 Int))
:extrafuns ((LONGTYPE_22_29_26 Int))
:extrafuns ((SIMPLENAME_24_66_7 Int))
:extrafuns ((PARSED_5_772_28 Int))
:extrafuns ((LSHIFT_23_30_26 Int))
:extrafuns ((IFSTMT_24_38_7 Int))
:extrafuns ((INTTYPE_22_28_26 Int))
:extrafuns ((ARRAYTYPE_24_65_7 Int))
:extrafuns ((POSTFIXDEC_23_63_26 Int))
:extrafuns ((LT_23_29_26 Int))
:extrafuns ((LABELSTMT_24_37_7 Int))
:extrafuns ((noTokens_21_212_27 Int))
:extrafuns ((BOOLEANTYPE_22_27_26 Int))
:extrafuns ((TYPENAME_24_64_7 Int))
:extrafuns ((POSTFIXINC_23_62_26 Int))
:extrafuns ((LE_23_28_26 Int))
:extrafuns ((CONTINUESTMT_24_36_7 Int))
:extrafuns ((punctuationCodes_21_164_19 Int))
:extrafuns ((IDENT_22_25_26 Int))
:extrafuns ((SUPEROBJECTDESIGNATOR_24_63_7 Int))
:extrafuns ((DEC_23_59_26 Int))
:extrafuns ((punctuationStrings_21_134_22 Int))
:extrafuns ((GT_23_27_26 Int))
:extrafuns ((BREAKSTMT_24_35_7 Int))
:extrafuns ((TYPEOBJECTDESIGNATOR_24_62_7 Int))
:extrafuns ((INC_23_58_26 Int))
:extrafuns ((keywordStrings_21_181_30 Int))
:extrafuns ((GE_23_26_26 Int))
:extrafuns ((THROWSTMT_24_34_7 Int))
:extrafuns ((EXPROBJECTDESIGNATOR_24_61_7 Int))
:extrafuns ((BITNOT_23_57_26 Int))
:extrafuns ((EQ_23_25_26 Int))
:extrafuns ((RETURNSTMT_24_33_7 Int))
:extrafuns ((CLASSLITERAL_24_60_7 Int))
:extrafuns ((NOT_23_56_26 Int))
:extrafuns ((NE_23_24_26 Int))
:extrafuns ((EVALSTMT_24_32_7 Int))
:extrafuns ((METHODINVOCATION_24_59_7 Int))
:extrafuns ((UNARYSUB_23_55_26 Int))
:extrafuns ((LAST_KEYWORD_21_103_26 Int))
:extrafuns ((BITAND_23_23_26 Int))
:extrafuns ((SYNCHRONIZESTMT_24_31_7 Int))
:extrafuns ((AMBIGUOUSMETHODINVOCATION_24_58_7 Int))
:extrafuns ((UNARYADD_23_54_26 Int))
:extrafuns ((otherCodes_21_202_27 Int))
:extrafuns ((NULL_21_82_26 Int))
:extrafuns ((BITXOR_23_22_26 Int))
:extrafuns ((DOSTMT_24_30_7 Int))
:extrafuns ((FIELDACCESS_24_57_7 Int))
:extrafuns ((ASGBITXOR_23_51_26 Int))
:extrafuns ((BITOR_23_21_26 Int))
:extrafuns ((WHILESTMT_24_29_7 Int))
:extrafuns ((NULL_97_60_26 Int))
:extrafuns ((VARIABLEACCESS_24_56_7 Int))
:extrafuns ((ASGBITOR_23_50_26 Int))
:extrafuns ((CLASSDECLSTMT_24_28_7 Int))
:extrafuns ((AMBIGUOUSVARIABLEACCESS_24_55_7 Int))
:extrafuns ((ASGBITAND_23_49_26 Int))
:extrafuns ((VARDECLSTMT_24_27_7 Int))
:extrafuns ((AND_23_20_26 Int))
:extrafuns ((PARENEXPR_24_54_7 Int))
:extrafuns ((ASGURSHIFT_23_48_26 Int))
:extrafuns ((NULLLIT_22_45_26 Int))
:extrafuns ((SWITCHSTMT_24_26_7 Int))
:extrafuns ((OR_23_19_26 Int))
:extrafuns ((CASTEXPR_24_53_7 Int))
:extrafuns ((ASGRSHIFT_23_47_26 Int))
:extrafuns ((STRINGLIT_22_44_26 Int))
:extrafuns ((BLOCKSTMT_24_25_7 Int))
:extrafuns ((INSTANCEOFEXPR_24_52_7 Int))
:extrafuns ((ASGLSHIFT_23_46_26 Int))
:extrafuns ((DOUBLELIT_22_43_26 Int))
:extrafuns ((FORMALPARADECL_24_24_7 Int))
:extrafuns ((CONDEXPR_24_51_7 Int))
:extrafuns ((ASGSUB_23_45_26 Int))
:extrafuns ((otherStrings_21_193_30 Int))
:extrafuns ((FLOATLIT_22_42_26 Int))
:extrafuns ((TYPEMODIFIERPRAGMA_21_28_26 Int))
:extrafuns ((FIELDDECL_24_23_7 Int))
:extrafuns ((ASGADD_23_44_26 Int))
:extrafuns ((NEWARRAYEXPR_24_50_7 Int))
:extrafuns ((CHARLIT_22_41_26 Int))
:extrafuns ((TYPEDECLELEMPRAGMA_21_27_26 Int))
:extrafuns ((LOCALVARDECL_24_22_7 Int))
:extrafuns ((ASGREM_23_43_26 Int))
:extrafuns ((NEWINSTANCEEXPR_24_49_7 Int))
:extrafuns ((LONGLIT_22_40_26 Int))
:extrafuns ((INITBLOCK_24_21_7 Int))
:extrafuns ((STMTPRAGMA_21_26_26 Int))
:extrafuns ((ASGDIV_23_42_26 Int))
:extrafuns ((ARRAYREFEXPR_24_48_7 Int))
:extrafuns ((INTLIT_22_39_26 Int))
:extrafuns ((METHODDECL_24_20_7 Int))
:extrafuns ((ASGMUL_23_41_26 Int))
:extrafuns ((THISEXPR_24_47_7 Int))
:extrafuns ((MODIFIERPRAGMA_21_25_26 Int))
:extrafuns ((BOOLEANLIT_22_38_26 Int))
:extrafuns ((CONSTRUCTORDECL_24_19_7 Int))
:extrafuns ((ASSIGN_23_40_26 Int))
:extrafuns ((ARRAYINIT_24_46_7 Int))
:extrafuns ((SHORTTYPE_22_36_26 Int))
:extrafuns ((TYPESIG_20_6_28 Int))
:extrafuns ((FIRST_KEYWORD_21_51_26 Int))
:extrafuns ((INTERFACEDECL_24_18_7 Int))
:extrafuns ((LEXICALPRAGMA_21_24_26 Int))
:extrafuns ((STAR_23_37_26 Int))
:extrafuns ((CATCHCLAUSE_24_45_7 Int))
:extrafuns ((BYTETYPE_22_35_26 Int))
:extrafuns ((CLASSDECL_24_17_7 Int))
:extrafuns ((MOD_23_36_26 Int))
:extrafuns ((CONSTRUCTORINVOCATION_24_44_7 Int))
:extrafuns ((NULLTYPE_22_34_26 Int))
:extrafuns ((ONDEMANDIMPORTDECL_24_16_7 Int))
:extrafuns ((DIV_23_35_26 Int))
:extrafuns ((TRYCATCHSTMT_24_43_7 Int))
:extrafuns ((VOIDTYPE_22_33_26 Int))
:extrafuns ((SINGLETYPEIMPORTDECL_24_15_7 Int))
:extrafuns ((SUB_23_34_26 Int))
:extrafuns ((TRYFINALLYSTMT_24_42_7 Int))
:extrafuns ((DOUBLETYPE_22_32_26 Int))
:extrafuns ((COMPILATIONUNIT_24_14_7 Int))
:extrafuns ((CHECKED_5_776_28 Int))
:extrafuns ((ADD_23_33_26 Int))
:extrafuns ((SWITCHLABEL_24_41_7 Int))
:extrafuns ((FLOATTYPE_22_31_26 Int))
:extrafuns ((PREPPED_5_775_28 Int))
:extrafuns ((URSHIFT_23_32_26 Int))
:extrafuns ((SKIPSTMT_24_40_7 Int))
:extrafuns ((LINKSRESOLVED_5_774_28 Int))
:extrafuns ((CHARTYPE_22_30_26 Int))
:extrafuns ((COMPOUNDNAME_24_67_7 Int))
:assumption (and (= (PO_LT T_javafe_ast_TypeDeclElemVec T_java_lang_Object) true_term) (= T_javafe_ast_TypeDeclElemVec (asChild T_javafe_ast_TypeDeclElemVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_IfStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_IfStmt (asChild T_javafe_ast_IfStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_PrimitiveType T_javafe_ast_Type) true_term) (= T_javafe_ast_PrimitiveType (asChild T_javafe_ast_PrimitiveType T_javafe_ast_Type)) (= (PO_LT T_javafe_ast_GeneratedTags T_java_lang_Object) true_term) (= (PO_LT T_javafe_tc_TagConstants T_javafe_parser_TagConstants) true_term) (= T_javafe_tc_TagConstants (asChild T_javafe_tc_TagConstants T_javafe_parser_TagConstants)) (= (PO_LT T_javafe_tc_FlowInsensitiveChecks T_java_lang_Object) true_term) (= T_javafe_tc_FlowInsensitiveChecks (asChild T_javafe_tc_FlowInsensitiveChecks T_java_lang_Object)) (= (PO_LT T_javafe_util_Assert T_java_lang_Object) true_term) (= T_javafe_util_Assert (asChild T_javafe_util_Assert T_java_lang_Object)) (= (PO_LT T_javafe_ast_ExprVec T_java_lang_Object) true_term) (= T_javafe_ast_ExprVec (asChild T_javafe_ast_ExprVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_MethodInvocation T_javafe_ast_Expr) true_term) (= T_javafe_ast_MethodInvocation (asChild T_javafe_ast_MethodInvocation T_javafe_ast_Expr)) (= (PO_LT T_javafe_tc_EnvForTypeSig T_javafe_tc_Env) true_term) (= T_javafe_tc_EnvForTypeSig (asChild T_javafe_tc_EnvForTypeSig T_javafe_tc_Env)) (= (PO_LT T_javafe_ast_SuperObjectDesignator T_javafe_ast_ObjectDesignator) true_term) (= T_javafe_ast_SuperObjectDesignator (asChild T_javafe_ast_SuperObjectDesignator T_javafe_ast_ObjectDesignator)) (= (PO_LT T_java_lang_Float T_java_lang_Number) true_term) (= T_java_lang_Float (asChild T_java_lang_Float T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Float) true_term) (= ?t T_java_lang_Float))) (= (PO_LT T_java_lang_Float T_java_lang_Comparable) true_term) (= (PO_LT T_java_lang_Integer T_java_lang_Number) true_term) (= T_java_lang_Integer (asChild T_java_lang_Integer T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Integer) true_term) (= ?t T_java_lang_Integer))) (= (PO_LT T_java_lang_Integer T_java_lang_Comparable) true_term) (= (PO_LT T_javafe_tc_TypeSigVec T_java_lang_Object) true_term) (= T_javafe_tc_TypeSigVec (asChild T_javafe_tc_TypeSigVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_BranchStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_BranchStmt (asChild T_javafe_ast_BranchStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_ArrayRefExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_ArrayRefExpr (asChild T_javafe_ast_ArrayRefExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_SkipStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_SkipStmt (asChild T_javafe_ast_SkipStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_AmbiguousVariableAccess T_javafe_ast_Expr) true_term) (= T_javafe_ast_AmbiguousVariableAccess (asChild T_javafe_ast_AmbiguousVariableAccess T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_ParenExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_ParenExpr (asChild T_javafe_ast_ParenExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_Identifier T_java_lang_Object) true_term) (= T_javafe_ast_Identifier (asChild T_javafe_ast_Identifier T_java_lang_Object)) (forall (?t Int) (iff (= (PO_LT ?t T_javafe_ast_Identifier) true_term) (= ?t T_javafe_ast_Identifier))) (= (PO_LT T_javafe_ast_CastExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_CastExpr (asChild T_javafe_ast_CastExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_OnDemandImportDecl T_javafe_ast_ImportDecl) true_term) (= T_javafe_ast_OnDemandImportDecl (asChild T_javafe_ast_OnDemandImportDecl T_javafe_ast_ImportDecl)) (= (PO_LT T_javafe_ast_ContinueStmt T_javafe_ast_BranchStmt) true_term) (= T_javafe_ast_ContinueStmt (asChild T_javafe_ast_ContinueStmt T_javafe_ast_BranchStmt)) (= (PO_LT T_java_lang_Double T_java_lang_Number) true_term) (= T_java_lang_Double (asChild T_java_lang_Double T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Double) true_term) (= ?t T_java_lang_Double))) (= (PO_LT T_java_lang_Double T_java_lang_Comparable) true_term) (= (PO_LT T_javafe_tc_TypeSig T_javafe_ast_Type) true_term) (= T_javafe_tc_TypeSig (asChild T_javafe_tc_TypeSig T_javafe_ast_Type)) (= (PO_LT T_javafe_ast_LocalVarDecl T_javafe_ast_GenericVarDecl) true_term) (= T_javafe_ast_LocalVarDecl (asChild T_javafe_ast_LocalVarDecl T_javafe_ast_GenericVarDecl)) (= (PO_LT T_javafe_ast_FieldDecl T_javafe_ast_GenericVarDecl) true_term) (= T_javafe_ast_FieldDecl (asChild T_javafe_ast_FieldDecl T_javafe_ast_GenericVarDecl)) (= (PO_LT T_javafe_ast_FieldDecl T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_InstanceOfExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_InstanceOfExpr (asChild T_javafe_ast_InstanceOfExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_ClassDecl T_javafe_ast_TypeDecl) true_term) (= T_javafe_ast_ClassDecl (asChild T_javafe_ast_ClassDecl T_javafe_ast_TypeDecl)) (= (PO_LT T_javafe_ast_TypeObjectDesignator T_javafe_ast_ObjectDesignator) true_term) (= T_javafe_ast_TypeObjectDesignator (asChild T_javafe_ast_TypeObjectDesignator T_javafe_ast_ObjectDesignator)) (= (PO_LT T_javafe_ast_BinaryExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_BinaryExpr (asChild T_javafe_ast_BinaryExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_SwitchStmt T_javafe_ast_GenericBlockStmt) true_term) (= T_javafe_ast_SwitchStmt (asChild T_javafe_ast_SwitchStmt T_javafe_ast_GenericBlockStmt)) (= (PO_LT T_java_util_Map T_java_lang_Object) true_term) (= (PO_LT T_java_util_Map T_java_util_EscjavaKeyValue) true_term) (= (PO_LT T_javafe_ast_DoStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_DoStmt (asChild T_javafe_ast_DoStmt T_javafe_ast_Stmt)) (= (PO_LT T_java_util_Dictionary T_java_lang_Object) true_term) (= T_java_util_Dictionary (asChild T_java_util_Dictionary T_java_lang_Object)) (= (PO_LT T_java_util_Dictionary T_java_util_EscjavaKeyValue) true_term) (= (PO_LT T_javafe_ast_SwitchLabel T_javafe_ast_Stmt) true_term) (= T_javafe_ast_SwitchLabel (asChild T_javafe_ast_SwitchLabel T_javafe_ast_Stmt)) (= (PO_LT T_java_lang_Long T_java_lang_Number) true_term) (= T_java_lang_Long (asChild T_java_lang_Long T_java_lang_Number)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Long) true_term) (= ?t T_java_lang_Long))) (= (PO_LT T_java_lang_Long T_java_lang_Comparable) true_term) (= (PO_LT T_javafe_ast_VarDeclStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_VarDeclStmt (asChild T_javafe_ast_VarDeclStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_tc_Types T_java_lang_Object) true_term) (= T_javafe_tc_Types (asChild T_javafe_tc_Types T_java_lang_Object)) (= (PO_LT T_java_lang_String T_java_lang_Object) true_term) (= T_java_lang_String (asChild T_java_lang_String T_java_lang_Object)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_String) true_term) (= ?t T_java_lang_String))) (= (PO_LT T_java_lang_String T_java_io_Serializable) true_term) (= (PO_LT T_java_lang_String T_java_lang_Comparable) true_term) (= (PO_LT T_javafe_ast_VariableAccess T_javafe_ast_Expr) true_term) (= T_javafe_ast_VariableAccess (asChild T_javafe_ast_VariableAccess T_javafe_ast_Expr)) (= (PO_LT T_java_lang_Cloneable T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_GenericVarDecl T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_GenericVarDecl (asChild T_javafe_ast_GenericVarDecl T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_Type T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_Type (asChild T_javafe_ast_Type T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_VarInit T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_VarInit (asChild T_javafe_ast_VarInit T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_InitBlock T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_InitBlock (asChild T_javafe_ast_InitBlock T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_InitBlock T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_UnaryExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_UnaryExpr (asChild T_javafe_ast_UnaryExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_ReturnStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_ReturnStmt (asChild T_javafe_ast_ReturnStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_BlockStmt T_javafe_ast_GenericBlockStmt) true_term) (= T_javafe_ast_BlockStmt (asChild T_javafe_ast_BlockStmt T_javafe_ast_GenericBlockStmt)) (= (PO_LT T_javafe_ast_BreakStmt T_javafe_ast_BranchStmt) true_term) (= T_javafe_ast_BreakStmt (asChild T_javafe_ast_BreakStmt T_javafe_ast_BranchStmt)) (= (PO_LT T_javafe_ast_TagConstants T_javafe_ast_OperatorTags) true_term) (= T_javafe_ast_TagConstants (asChild T_javafe_ast_TagConstants T_javafe_ast_OperatorTags)) (= (PO_LT T_javafe_util_Location T_java_lang_Object) true_term) (= T_javafe_util_Location (asChild T_javafe_util_Location T_java_lang_Object)) (= (PO_LT T_javafe_ast_CondExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_CondExpr (asChild T_javafe_ast_CondExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_CatchClause T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_CatchClause (asChild T_javafe_ast_CatchClause T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_TypeNameVec T_java_lang_Object) true_term) (= T_javafe_ast_TypeNameVec (asChild T_javafe_ast_TypeNameVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_SingleTypeImportDecl T_javafe_ast_ImportDecl) true_term) (= T_javafe_ast_SingleTypeImportDecl (asChild T_javafe_ast_SingleTypeImportDecl T_javafe_ast_ImportDecl)) (= (PO_LT T_javafe_parser_TagConstants T_javafe_ast_TagConstants) true_term) (= T_javafe_parser_TagConstants (asChild T_javafe_parser_TagConstants T_javafe_ast_TagConstants)) (= (PO_LT T_javafe_ast_Expr T_javafe_ast_VarInit) true_term) (= T_javafe_ast_Expr (asChild T_javafe_ast_Expr T_javafe_ast_VarInit)) (= (PO_LT T_javafe_ast_TryFinallyStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_TryFinallyStmt (asChild T_javafe_ast_TryFinallyStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_ObjectDesignator T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_ObjectDesignator (asChild T_javafe_ast_ObjectDesignator T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_TryCatchStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_TryCatchStmt (asChild T_javafe_ast_TryCatchStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_VarInitVec T_java_lang_Object) true_term) (= T_javafe_ast_VarInitVec (asChild T_javafe_ast_VarInitVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_LiteralExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_LiteralExpr (asChild T_javafe_ast_LiteralExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_tc_Env T_java_lang_Object) true_term) (= T_javafe_tc_Env (asChild T_javafe_tc_Env T_java_lang_Object)) (= (PO_LT T_java_lang_Boolean T_java_lang_Object) true_term) (= T_java_lang_Boolean (asChild T_java_lang_Boolean T_java_lang_Object)) (forall (?t Int) (iff (= (PO_LT ?t T_java_lang_Boolean) true_term) (= ?t T_java_lang_Boolean))) (= (PO_LT T_java_lang_Boolean T_java_io_Serializable) true_term) (= (PO_LT T_javafe_ast_InterfaceDecl T_javafe_ast_TypeDecl) true_term) (= T_javafe_ast_InterfaceDecl (asChild T_javafe_ast_InterfaceDecl T_javafe_ast_TypeDecl)) (= (PO_LT T_javafe_tc_FieldDeclVec T_java_lang_Object) true_term) (= T_javafe_tc_FieldDeclVec (asChild T_javafe_tc_FieldDeclVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_ClassLiteral T_javafe_ast_Expr) true_term) (= T_javafe_ast_ClassLiteral (asChild T_javafe_ast_ClassLiteral T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_ConstructorInvocation T_javafe_ast_Stmt) true_term) (= T_javafe_ast_ConstructorInvocation (asChild T_javafe_ast_ConstructorInvocation T_javafe_ast_Stmt)) (= (PO_LT T_javafe_tc_MethodDeclVec T_java_lang_Object) true_term) (= T_javafe_tc_MethodDeclVec (asChild T_javafe_tc_MethodDeclVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_NewInstanceExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_NewInstanceExpr (asChild T_javafe_ast_NewInstanceExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_MethodDecl T_javafe_ast_RoutineDecl) true_term) (= T_javafe_ast_MethodDecl (asChild T_javafe_ast_MethodDecl T_javafe_ast_RoutineDecl)) (= (PO_LT T_javafe_ast_OperatorTags T_java_lang_Object) true_term) (= T_javafe_ast_OperatorTags (asChild T_javafe_ast_OperatorTags T_java_lang_Object)) (= (PO_LT T_javafe_ast_OperatorTags T_javafe_ast_GeneratedTags) true_term) (= (PO_LT T_javafe_tc_CheckInvariants T_java_lang_Object) true_term) (= T_javafe_tc_CheckInvariants (asChild T_javafe_tc_CheckInvariants T_java_lang_Object)) (= (PO_LT T_javafe_ast_ConstructorDecl T_javafe_ast_RoutineDecl) true_term) (= T_javafe_ast_ConstructorDecl (asChild T_javafe_ast_ConstructorDecl T_javafe_ast_RoutineDecl)) (= (PO_LT T_javafe_ast_TypeDecl T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_TypeDecl (asChild T_javafe_ast_TypeDecl T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_TypeDecl T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_ThisExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_ThisExpr (asChild T_javafe_ast_ThisExpr T_javafe_ast_Expr)) (= (PO_LT T_java_io_Serializable T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_CompoundName T_javafe_ast_Name) true_term) (= T_javafe_ast_CompoundName (asChild T_javafe_ast_CompoundName T_javafe_ast_Name)) (= (PO_LT T_java_lang_Number T_java_lang_Object) true_term) (= T_java_lang_Number (asChild T_java_lang_Number T_java_lang_Object)) (= (PO_LT T_java_lang_Number T_java_io_Serializable) true_term) (= (PO_LT T_javafe_ast_GenericBlockStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_GenericBlockStmt (asChild T_javafe_ast_GenericBlockStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_CatchClauseVec T_java_lang_Object) true_term) (= T_javafe_ast_CatchClauseVec (asChild T_javafe_ast_CatchClauseVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_IdentifierVec T_java_lang_Object) true_term) (= T_javafe_ast_IdentifierVec (asChild T_javafe_ast_IdentifierVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_LabelStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_LabelStmt (asChild T_javafe_ast_LabelStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_CompilationUnit T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_CompilationUnit (asChild T_javafe_ast_CompilationUnit T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_SimpleName T_javafe_ast_Name) true_term) (= T_javafe_ast_SimpleName (asChild T_javafe_ast_SimpleName T_javafe_ast_Name)) (= (PO_LT T_javafe_ast_Name T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_Name (asChild T_javafe_ast_Name T_javafe_ast_ASTNode)) (= (PO_LT T_java_lang_Comparable T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_ArrayType T_javafe_ast_Type) true_term) (= T_javafe_ast_ArrayType (asChild T_javafe_ast_ArrayType T_javafe_ast_Type)) (= (PO_LT T_javafe_ast_TypeDeclElem T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_AmbiguousMethodInvocation T_javafe_ast_Expr) true_term) (= T_javafe_ast_AmbiguousMethodInvocation (asChild T_javafe_ast_AmbiguousMethodInvocation T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_ForStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_ForStmt (asChild T_javafe_ast_ForStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_ImportDecl T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_ImportDecl (asChild T_javafe_ast_ImportDecl T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_SynchronizeStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_SynchronizeStmt (asChild T_javafe_ast_SynchronizeStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_ASTDecoration T_java_lang_Object) true_term) (= T_javafe_ast_ASTDecoration (asChild T_javafe_ast_ASTDecoration T_java_lang_Object)) (= (PO_LT T_java_util_Hashtable T_java_util_Dictionary) true_term) (= T_java_util_Hashtable (asChild T_java_util_Hashtable T_java_util_Dictionary)) (= (PO_LT T_java_util_Hashtable T_java_util_Map) true_term) (= (PO_LT T_java_util_Hashtable T_java_lang_Cloneable) true_term) (= (PO_LT T_java_util_Hashtable T_java_io_Serializable) true_term) (= (PO_LT T_javafe_ast_RoutineDecl T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_RoutineDecl (asChild T_javafe_ast_RoutineDecl T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_RoutineDecl T_javafe_ast_TypeDeclElem) true_term) (= (PO_LT T_javafe_ast_TypeName T_javafe_ast_Type) true_term) (= T_javafe_ast_TypeName (asChild T_javafe_ast_TypeName T_javafe_ast_Type)) (= (PO_LT T_javafe_ast_FormalParaDeclVec T_java_lang_Object) true_term) (= T_javafe_ast_FormalParaDeclVec (asChild T_javafe_ast_FormalParaDeclVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_ThrowStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_ThrowStmt (asChild T_javafe_ast_ThrowStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_WhileStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_WhileStmt (asChild T_javafe_ast_WhileStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_ExprObjectDesignator T_javafe_ast_ObjectDesignator) true_term) (= T_javafe_ast_ExprObjectDesignator (asChild T_javafe_ast_ExprObjectDesignator T_javafe_ast_ObjectDesignator)) (= (PO_LT T_javafe_ast_ASTNode T_java_lang_Object) true_term) (= T_javafe_ast_ASTNode (asChild T_javafe_ast_ASTNode T_java_lang_Object)) (= (PO_LT T_javafe_ast_ASTNode T_java_lang_Cloneable) true_term) (= (PO_LT T_javafe_ast_NewArrayExpr T_javafe_ast_Expr) true_term) (= T_javafe_ast_NewArrayExpr (asChild T_javafe_ast_NewArrayExpr T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_ClassDeclStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_ClassDeclStmt (asChild T_javafe_ast_ClassDeclStmt T_javafe_ast_Stmt)) (= (PO_LT T_javafe_ast_Stmt T_javafe_ast_ASTNode) true_term) (= T_javafe_ast_Stmt (asChild T_javafe_ast_Stmt T_javafe_ast_ASTNode)) (= (PO_LT T_javafe_ast_ArrayInit T_javafe_ast_VarInit) true_term) (= T_javafe_ast_ArrayInit (asChild T_javafe_ast_ArrayInit T_javafe_ast_VarInit)) (= (PO_LT T_javafe_ast_FormalParaDecl T_javafe_ast_GenericVarDecl) true_term) (= T_javafe_ast_FormalParaDecl (asChild T_javafe_ast_FormalParaDecl T_javafe_ast_GenericVarDecl)) (= (PO_LT T_java_util_EscjavaKeyValue T_java_lang_Object) true_term) (= (PO_LT T_javafe_ast_StmtVec T_java_lang_Object) true_term) (= T_javafe_ast_StmtVec (asChild T_javafe_ast_StmtVec T_java_lang_Object)) (= (PO_LT T_javafe_ast_FieldAccess T_javafe_ast_Expr) true_term) (= T_javafe_ast_FieldAccess (asChild T_javafe_ast_FieldAccess T_javafe_ast_Expr)) (= (PO_LT T_javafe_ast_EvalStmt T_javafe_ast_Stmt) true_term) (= T_javafe_ast_EvalStmt (asChild T_javafe_ast_EvalStmt T_javafe_ast_Stmt)) (and (= arrayType (+ DIST_ZERO_1 0)) (= T_boolean (+ DIST_ZERO_1 1)) (= T_char (+ DIST_ZERO_1 2)) (= T_byte (+ DIST_ZERO_1 3)) (= T_short (+ DIST_ZERO_1 4)) (= T_int (+ DIST_ZERO_1 5)) (= T_long (+ DIST_ZERO_1 6)) (= T_float (+ DIST_ZERO_1 7)) (= T_double (+ DIST_ZERO_1 8)) (= T__TYPE (+ DIST_ZERO_1 9)) (= T_javafe_ast_TypeDeclElemVec (+ DIST_ZERO_1 10)) (= T_javafe_ast_IfStmt (+ DIST_ZERO_1 11)) (= T_javafe_ast_PrimitiveType (+ DIST_ZERO_1 12)) (= T_javafe_ast_GeneratedTags (+ DIST_ZERO_1 13)) (= T_javafe_tc_TagConstants (+ DIST_ZERO_1 14)) (= T_javafe_tc_FlowInsensitiveChecks (+ DIST_ZERO_1 15)) (= T_javafe_util_Assert (+ DIST_ZERO_1 16)) (= T_javafe_ast_ExprVec (+ DIST_ZERO_1 17)) (= T_javafe_ast_MethodInvocation (+ DIST_ZERO_1 18)) (= T_javafe_tc_EnvForTypeSig (+ DIST_ZERO_1 19)) (= T_javafe_ast_SuperObjectDesignator (+ DIST_ZERO_1 20)) (= T_java_lang_Float (+ DIST_ZERO_1 21)) (= T_java_lang_Integer (+ DIST_ZERO_1 22)) (= T_javafe_tc_TypeSigVec (+ DIST_ZERO_1 23)) (= T_javafe_ast_BranchStmt (+ DIST_ZERO_1 24)) (= T_javafe_ast_ArrayRefExpr (+ DIST_ZERO_1 25)) (= T_javafe_ast_SkipStmt (+ DIST_ZERO_1 26)) (= T_javafe_ast_AmbiguousVariableAccess (+ DIST_ZERO_1 27)) (= T_javafe_ast_ParenExpr (+ DIST_ZERO_1 28)) (= T_javafe_ast_Identifier (+ DIST_ZERO_1 29)) (= T_javafe_ast_CastExpr (+ DIST_ZERO_1 30)) (= T_javafe_ast_OnDemandImportDecl (+ DIST_ZERO_1 31)) (= T_javafe_ast_ContinueStmt (+ DIST_ZERO_1 32)) (= T_java_lang_Double (+ DIST_ZERO_1 33)) (= T_javafe_tc_TypeSig (+ DIST_ZERO_1 34)) (= T_javafe_ast_LocalVarDecl (+ DIST_ZERO_1 35)) (= T_javafe_ast_FieldDecl (+ DIST_ZERO_1 36)) (= T_javafe_ast_InstanceOfExpr (+ DIST_ZERO_1 37)) (= T_javafe_ast_ClassDecl (+ DIST_ZERO_1 38)) (= T_javafe_ast_TypeObjectDesignator (+ DIST_ZERO_1 39)) (= T_javafe_ast_BinaryExpr (+ DIST_ZERO_1 40)) (= T_javafe_ast_SwitchStmt (+ DIST_ZERO_1 41)) (= T_java_util_Map (+ DIST_ZERO_1 42)) (= T_javafe_ast_DoStmt (+ DIST_ZERO_1 43)) (= T_java_util_Dictionary (+ DIST_ZERO_1 44)) (= T_javafe_ast_SwitchLabel (+ DIST_ZERO_1 45)) (= T_java_lang_Long (+ DIST_ZERO_1 46)) (= T_javafe_ast_VarDeclStmt (+ DIST_ZERO_1 47)) (= T_javafe_tc_Types (+ DIST_ZERO_1 48)) (= T_java_lang_String (+ DIST_ZERO_1 49)) (= T_javafe_ast_VariableAccess (+ DIST_ZERO_1 50)) (= T_java_lang_Cloneable (+ DIST_ZERO_1 51)) (= T_javafe_ast_GenericVarDecl (+ DIST_ZERO_1 52)) (= T_javafe_ast_Type (+ DIST_ZERO_1 53)) (= T_javafe_ast_VarInit (+ DIST_ZERO_1 54)) (= T_javafe_ast_InitBlock (+ DIST_ZERO_1 55)) (= T_javafe_ast_UnaryExpr (+ DIST_ZERO_1 56)) (= T_javafe_ast_ReturnStmt (+ DIST_ZERO_1 57)) (= T_javafe_ast_BlockStmt (+ DIST_ZERO_1 58)) (= T_javafe_ast_BreakStmt (+ DIST_ZERO_1 59)) (= T_javafe_ast_TagConstants (+ DIST_ZERO_1 60)) (= T_javafe_util_Location (+ DIST_ZERO_1 61)) (= T_javafe_ast_CondExpr (+ DIST_ZERO_1 62)) (= T_javafe_ast_CatchClause (+ DIST_ZERO_1 63)) (= T_java_lang_Object (+ DIST_ZERO_1 64)) (= T_javafe_ast_TypeNameVec (+ DIST_ZERO_1 65)) (= T_javafe_ast_SingleTypeImportDecl (+ DIST_ZERO_1 66)) (= T_javafe_parser_TagConstants (+ DIST_ZERO_1 67)) (= T_javafe_ast_Expr (+ DIST_ZERO_1 68)) (= T_javafe_ast_TryFinallyStmt (+ DIST_ZERO_1 69)) (= T_javafe_ast_ObjectDesignator (+ DIST_ZERO_1 70)) (= T_javafe_ast_TryCatchStmt (+ DIST_ZERO_1 71)) (= T_javafe_ast_VarInitVec (+ DIST_ZERO_1 72)) (= T_javafe_ast_LiteralExpr (+ DIST_ZERO_1 73)) (= T_javafe_tc_Env (+ DIST_ZERO_1 74)) (= T_java_lang_Boolean (+ DIST_ZERO_1 75)) (= T_javafe_ast_InterfaceDecl (+ DIST_ZERO_1 76)) (= T_javafe_tc_FieldDeclVec (+ DIST_ZERO_1 77)) (= T_javafe_ast_ClassLiteral (+ DIST_ZERO_1 78)) (= T_javafe_ast_ConstructorInvocation (+ DIST_ZERO_1 79)) (= T_javafe_tc_MethodDeclVec (+ DIST_ZERO_1 80)) (= T_javafe_ast_NewInstanceExpr (+ DIST_ZERO_1 81)) (= T_javafe_ast_MethodDecl (+ DIST_ZERO_1 82)) (= T_javafe_ast_OperatorTags (+ DIST_ZERO_1 83)) (= T_javafe_tc_CheckInvariants (+ DIST_ZERO_1 84)) (= T_javafe_ast_ConstructorDecl (+ DIST_ZERO_1 85)) (= T_javafe_ast_TypeDecl (+ DIST_ZERO_1 86)) (= T_javafe_ast_ThisExpr (+ DIST_ZERO_1 87)) (= T_java_io_Serializable (+ DIST_ZERO_1 88)) (= T_javafe_ast_CompoundName (+ DIST_ZERO_1 89)) (= T_java_lang_Number (+ DIST_ZERO_1 90)) (= T_javafe_ast_GenericBlockStmt (+ DIST_ZERO_1 91)) (= T_javafe_ast_CatchClauseVec (+ DIST_ZERO_1 92)) (= T_javafe_ast_IdentifierVec (+ DIST_ZERO_1 93)) (= T_javafe_ast_LabelStmt (+ DIST_ZERO_1 94)) (= T_javafe_ast_CompilationUnit (+ DIST_ZERO_1 95)) (= T_javafe_ast_SimpleName (+ DIST_ZERO_1 96)) (= T_javafe_ast_Name (+ DIST_ZERO_1 97)) (= T_java_lang_Comparable (+ DIST_ZERO_1 98)) (= T_javafe_ast_ArrayType (+ DIST_ZERO_1 99)) (= T_javafe_ast_TypeDeclElem (+ DIST_ZERO_1 100)) (= T_javafe_ast_AmbiguousMethodInvocation (+ DIST_ZERO_1 101)) (= T_javafe_ast_ForStmt (+ DIST_ZERO_1 102)) (= T_javafe_ast_ImportDecl (+ DIST_ZERO_1 103)) (= T_javafe_ast_SynchronizeStmt (+ DIST_ZERO_1 104)) (= T_javafe_ast_ASTDecoration (+ DIST_ZERO_1 105)) (= T_java_util_Hashtable (+ DIST_ZERO_1 106)) (= T_javafe_ast_RoutineDecl (+ DIST_ZERO_1 107)) (= T_javafe_ast_TypeName (+ DIST_ZERO_1 108)) (= T_javafe_ast_FormalParaDeclVec (+ DIST_ZERO_1 109)) (= T_javafe_ast_ThrowStmt (+ DIST_ZERO_1 110)) (= T_javafe_ast_WhileStmt (+ DIST_ZERO_1 111)) (= T_javafe_ast_ExprObjectDesignator (+ DIST_ZERO_1 112)) (= T_javafe_ast_ASTNode (+ DIST_ZERO_1 113)) (= T_javafe_ast_NewArrayExpr (+ DIST_ZERO_1 114)) (= T_javafe_ast_ClassDeclStmt (+ DIST_ZERO_1 115)) (= T_javafe_ast_Stmt (+ DIST_ZERO_1 116)) (= T_javafe_ast_ArrayInit (+ DIST_ZERO_1 117)) (= T_javafe_ast_FormalParaDecl (+ DIST_ZERO_1 118)) (= T_java_util_EscjavaKeyValue (+ DIST_ZERO_1 119)) (= T_javafe_ast_StmtVec (+ DIST_ZERO_1 120)) (= T_javafe_ast_FieldAccess (+ DIST_ZERO_1 121)) (= T_javafe_ast_EvalStmt (+ DIST_ZERO_1 122))) (= true_term (is RSHIFT_23_31_26 T_int)) (= RSHIFT_23_31_26 66) (= true_term (is FORSTMT_24_39_7 T_int)) (= FORSTMT_24_39_7 25) (= true_term (is LONGTYPE_22_29_26 T_int)) (= LONGTYPE_22_29_26 96) (= true_term (is SIMPLENAME_24_66_7 T_int)) (= SIMPLENAME_24_66_7 52) (= true_term (is PARSED_5_772_28 T_int)) (= PARSED_5_772_28 2) (= true_term (is LSHIFT_23_30_26 T_int)) (= LSHIFT_23_30_26 65) (= true_term (is IFSTMT_24_38_7 T_int)) (= IFSTMT_24_38_7 24) (= true_term (is INTTYPE_22_28_26 T_int)) (= INTTYPE_22_28_26 95) (= true_term (is ARRAYTYPE_24_65_7 T_int)) (= ARRAYTYPE_24_65_7 51) (= true_term (is POSTFIXDEC_23_63_26 T_int)) (= POSTFIXDEC_23_63_26 92) (= true_term (is LT_23_29_26 T_int)) (= LT_23_29_26 64) (= true_term (is LABELSTMT_24_37_7 T_int)) (= LABELSTMT_24_37_7 23) (= true_term (is noTokens_21_212_27 T_int)) (= true_term (is BOOLEANTYPE_22_27_26 T_int)) (= BOOLEANTYPE_22_27_26 94) (= true_term (is TYPENAME_24_64_7 T_int)) (= TYPENAME_24_64_7 50) (= true_term (is POSTFIXINC_23_62_26 T_int)) (= POSTFIXINC_23_62_26 91) (= true_term (is LE_23_28_26 T_int)) (= LE_23_28_26 63) (= true_term (is CONTINUESTMT_24_36_7 T_int)) (= CONTINUESTMT_24_36_7 22) (= true_term (is punctuationCodes_21_164_19 (array T_int))) (not (= punctuationCodes_21_164_19 null)) (= (typeof punctuationCodes_21_164_19) (array T_int)) (= (arrayLength punctuationCodes_21_164_19) 48) (= true_term (is IDENT_22_25_26 T_int)) (= IDENT_22_25_26 93) (= true_term (is SUPEROBJECTDESIGNATOR_24_63_7 T_int)) (= SUPEROBJECTDESIGNATOR_24_63_7 49) (= true_term (is DEC_23_59_26 T_int)) (= DEC_23_59_26 90) (= true_term (is punctuationStrings_21_134_22 (array T_java_lang_String))) (not (= punctuationStrings_21_134_22 null)) (= (typeof punctuationStrings_21_134_22) (array T_java_lang_String)) (= (arrayLength punctuationStrings_21_134_22) 48) (= true_term (is GT_23_27_26 T_int)) (= GT_23_27_26 62) (= true_term (is BREAKSTMT_24_35_7 T_int)) (= BREAKSTMT_24_35_7 21) (= true_term (is TYPEOBJECTDESIGNATOR_24_62_7 T_int)) (= TYPEOBJECTDESIGNATOR_24_62_7 48) (= true_term (is INC_23_58_26 T_int)) (= INC_23_58_26 89) (= true_term (is keywordStrings_21_181_30 (array T_java_lang_String))) (not (= keywordStrings_21_181_30 null)) (= (typeof keywordStrings_21_181_30) (array T_java_lang_String)) (= (arrayLength keywordStrings_21_181_30) 51) (= true_term (is GE_23_26_26 T_int)) (= GE_23_26_26 61) (= true_term (is THROWSTMT_24_34_7 T_int)) (= THROWSTMT_24_34_7 20) (= true_term (is EXPROBJECTDESIGNATOR_24_61_7 T_int)) (= EXPROBJECTDESIGNATOR_24_61_7 47) (= true_term (is BITNOT_23_57_26 T_int)) (= BITNOT_23_57_26 88) (= true_term (is EQ_23_25_26 T_int)) (= EQ_23_25_26 60) (= true_term (is RETURNSTMT_24_33_7 T_int)) (= RETURNSTMT_24_33_7 19) (= true_term (is CLASSLITERAL_24_60_7 T_int)) (= CLASSLITERAL_24_60_7 46) (= true_term (is NOT_23_56_26 T_int)) (= NOT_23_56_26 87) (= true_term (is NE_23_24_26 T_int)) (= NE_23_24_26 59) (= true_term (is EVALSTMT_24_32_7 T_int)) (= EVALSTMT_24_32_7 18) (= true_term (is METHODINVOCATION_24_59_7 T_int)) (= METHODINVOCATION_24_59_7 45) (= true_term (is UNARYSUB_23_55_26 T_int)) (= UNARYSUB_23_55_26 86) (= true_term (is LAST_KEYWORD_21_103_26 T_int)) (= LAST_KEYWORD_21_103_26 183) (= true_term (is BITAND_23_23_26 T_int)) (= BITAND_23_23_26 58) (= true_term (is SYNCHRONIZESTMT_24_31_7 T_int)) (= SYNCHRONIZESTMT_24_31_7 17) (= true_term (is AMBIGUOUSMETHODINVOCATION_24_58_7 T_int)) (= AMBIGUOUSMETHODINVOCATION_24_58_7 44) (= true_term (is UNARYADD_23_54_26 T_int)) (= UNARYADD_23_54_26 85) (= true_term (is otherCodes_21_202_27 (array T_int))) (not (= otherCodes_21_202_27 null)) (= (typeof otherCodes_21_202_27) (array T_int)) (= (arrayLength otherCodes_21_202_27) 15) (= true_term (is NULL_21_82_26 T_int)) (= NULL_21_82_26 163) (= true_term (is BITXOR_23_22_26 T_int)) (= BITXOR_23_22_26 57) (= true_term (is DOSTMT_24_30_7 T_int)) (= DOSTMT_24_30_7 16) (= true_term (is FIELDACCESS_24_57_7 T_int)) (= FIELDACCESS_24_57_7 43) (= true_term (is ASGBITXOR_23_51_26 T_int)) (= ASGBITXOR_23_51_26 84) (= true_term (is BITOR_23_21_26 T_int)) (= BITOR_23_21_26 56) (= true_term (is WHILESTMT_24_29_7 T_int)) (= WHILESTMT_24_29_7 15) (= true_term (is NULL_97_60_26 T_int)) (= NULL_97_60_26 0) (= true_term (is VARIABLEACCESS_24_56_7 T_int)) (= VARIABLEACCESS_24_56_7 42) (= true_term (is ASGBITOR_23_50_26 T_int)) (= ASGBITOR_23_50_26 83) (= true_term (is CLASSDECLSTMT_24_28_7 T_int)) (= CLASSDECLSTMT_24_28_7 14) (= true_term (is AMBIGUOUSVARIABLEACCESS_24_55_7 T_int)) (= AMBIGUOUSVARIABLEACCESS_24_55_7 41) (= true_term (is ASGBITAND_23_49_26 T_int)) (= ASGBITAND_23_49_26 82) (= true_term (is VARDECLSTMT_24_27_7 T_int)) (= VARDECLSTMT_24_27_7 13) (= true_term (is AND_23_20_26 T_int)) (= AND_23_20_26 55) (= true_term (is PARENEXPR_24_54_7 T_int)) (= PARENEXPR_24_54_7 40) (= true_term (is ASGURSHIFT_23_48_26 T_int)) (= ASGURSHIFT_23_48_26 81) (= true_term (is NULLLIT_22_45_26 T_int)) (= NULLLIT_22_45_26 111) (= true_term (is SWITCHSTMT_24_26_7 T_int)) (= SWITCHSTMT_24_26_7 12) (= true_term (is OR_23_19_26 T_int)) (= OR_23_19_26 54) (= true_term (is CASTEXPR_24_53_7 T_int)) (= CASTEXPR_24_53_7 39) (= true_term (is ASGRSHIFT_23_47_26 T_int)) (= ASGRSHIFT_23_47_26 80) (= true_term (is STRINGLIT_22_44_26 T_int)) (= STRINGLIT_22_44_26 110) (= true_term (is BLOCKSTMT_24_25_7 T_int)) (= BLOCKSTMT_24_25_7 11) (= true_term (is INSTANCEOFEXPR_24_52_7 T_int)) (= INSTANCEOFEXPR_24_52_7 38) (= true_term (is ASGLSHIFT_23_46_26 T_int)) (= ASGLSHIFT_23_46_26 79) (= true_term (is DOUBLELIT_22_43_26 T_int)) (= DOUBLELIT_22_43_26 109) (= true_term (is FORMALPARADECL_24_24_7 T_int)) (= FORMALPARADECL_24_24_7 10) (= true_term (is CONDEXPR_24_51_7 T_int)) (= CONDEXPR_24_51_7 37) (= true_term (is ASGSUB_23_45_26 T_int)) (= ASGSUB_23_45_26 78) (= true_term (is otherStrings_21_193_30 (array T_java_lang_String))) (not (= otherStrings_21_193_30 null)) (= (typeof otherStrings_21_193_30) (array T_java_lang_String)) (= (arrayLength otherStrings_21_193_30) 15) (= true_term (is FLOATLIT_22_42_26 T_int)) (= FLOATLIT_22_42_26 108) (= true_term (is TYPEMODIFIERPRAGMA_21_28_26 T_int)) (= TYPEMODIFIERPRAGMA_21_28_26 118) (= true_term (is FIELDDECL_24_23_7 T_int)) (= FIELDDECL_24_23_7 9) (= true_term (is ASGADD_23_44_26 T_int)) (= ASGADD_23_44_26 77) (= true_term (is NEWARRAYEXPR_24_50_7 T_int)) (= NEWARRAYEXPR_24_50_7 36) (= true_term (is CHARLIT_22_41_26 T_int)) (= CHARLIT_22_41_26 107) (= true_term (is TYPEDECLELEMPRAGMA_21_27_26 T_int)) (= TYPEDECLELEMPRAGMA_21_27_26 117) (= true_term (is LOCALVARDECL_24_22_7 T_int)) (= LOCALVARDECL_24_22_7 8) (= true_term (is ASGREM_23_43_26 T_int)) (= ASGREM_23_43_26 76) (= true_term (is NEWINSTANCEEXPR_24_49_7 T_int)) (= NEWINSTANCEEXPR_24_49_7 35) (= true_term (is LONGLIT_22_40_26 T_int)) (= LONGLIT_22_40_26 106) (= true_term (is INITBLOCK_24_21_7 T_int)) (= INITBLOCK_24_21_7 7) (= true_term (is STMTPRAGMA_21_26_26 T_int)) (= STMTPRAGMA_21_26_26 116) (= true_term (is ASGDIV_23_42_26 T_int)) (= ASGDIV_23_42_26 75) (= true_term (is ARRAYREFEXPR_24_48_7 T_int)) (= ARRAYREFEXPR_24_48_7 34) (= true_term (is INTLIT_22_39_26 T_int)) (= INTLIT_22_39_26 105) (= true_term (is METHODDECL_24_20_7 T_int)) (= METHODDECL_24_20_7 6) (= true_term (is ASGMUL_23_41_26 T_int)) (= ASGMUL_23_41_26 74) (= true_term (is THISEXPR_24_47_7 T_int)) (= THISEXPR_24_47_7 33) (= true_term (is MODIFIERPRAGMA_21_25_26 T_int)) (= MODIFIERPRAGMA_21_25_26 115) (= true_term (is BOOLEANLIT_22_38_26 T_int)) (= BOOLEANLIT_22_38_26 104) (= true_term (is CONSTRUCTORDECL_24_19_7 T_int)) (= CONSTRUCTORDECL_24_19_7 5) (= true_term (is ASSIGN_23_40_26 T_int)) (= ASSIGN_23_40_26 73) (= true_term (is ARRAYINIT_24_46_7 T_int)) (= ARRAYINIT_24_46_7 32) (= true_term (is SHORTTYPE_22_36_26 T_int)) (= SHORTTYPE_22_36_26 103) (= true_term (is TYPESIG_20_6_28 T_int)) (= TYPESIG_20_6_28 184) (= true_term (is FIRST_KEYWORD_21_51_26 T_int)) (= FIRST_KEYWORD_21_51_26 133) (= true_term (is INTERFACEDECL_24_18_7 T_int)) (= INTERFACEDECL_24_18_7 4) (= true_term (is LEXICALPRAGMA_21_24_26 T_int)) (= LEXICALPRAGMA_21_24_26 114) (= true_term (is STAR_23_37_26 T_int)) (= STAR_23_37_26 72) (= true_term (is CATCHCLAUSE_24_45_7 T_int)) (= CATCHCLAUSE_24_45_7 31) (= true_term (is BYTETYPE_22_35_26 T_int)) (= BYTETYPE_22_35_26 102) (= true_term (is CLASSDECL_24_17_7 T_int)) (= CLASSDECL_24_17_7 3) (= true_term (is MOD_23_36_26 T_int)) (= MOD_23_36_26 71) (= true_term (is CONSTRUCTORINVOCATION_24_44_7 T_int)) (= CONSTRUCTORINVOCATION_24_44_7 30) (= true_term (is NULLTYPE_22_34_26 T_int)) (= NULLTYPE_22_34_26 101) (= true_term (is ONDEMANDIMPORTDECL_24_16_7 T_int)) (= ONDEMANDIMPORTDECL_24_16_7 2) (= true_term (is DIV_23_35_26 T_int)) (= DIV_23_35_26 70) (= true_term (is TRYCATCHSTMT_24_43_7 T_int)) (= TRYCATCHSTMT_24_43_7 29) (= true_term (is VOIDTYPE_22_33_26 T_int)) (= VOIDTYPE_22_33_26 100) (= true_term (is SINGLETYPEIMPORTDECL_24_15_7 T_int)) (= SINGLETYPEIMPORTDECL_24_15_7 1) (= true_term (is SUB_23_34_26 T_int)) (= SUB_23_34_26 69) (= true_term (is TRYFINALLYSTMT_24_42_7 T_int)) (= TRYFINALLYSTMT_24_42_7 28) (= true_term (is DOUBLETYPE_22_32_26 T_int)) (= DOUBLETYPE_22_32_26 99) (= true_term (is COMPILATIONUNIT_24_14_7 T_int)) (= COMPILATIONUNIT_24_14_7 0) (= true_term (is CHECKED_5_776_28 T_int)) (= CHECKED_5_776_28 6) (= true_term (is ADD_23_33_26 T_int)) (= ADD_23_33_26 68) (= true_term (is SWITCHLABEL_24_41_7 T_int)) (= SWITCHLABEL_24_41_7 27) (= true_term (is FLOATTYPE_22_31_26 T_int)) (= FLOATTYPE_22_31_26 98) (= true_term (is PREPPED_5_775_28 T_int)) (= PREPPED_5_775_28 5) (= true_term (is URSHIFT_23_32_26 T_int)) (= URSHIFT_23_32_26 67) (= true_term (is SKIPSTMT_24_40_7 T_int)) (= SKIPSTMT_24_40_7 26) (= true_term (is LINKSRESOLVED_5_774_28 T_int)) (= LINKSRESOLVED_5_774_28 4) (= true_term (is CHARTYPE_22_30_26 T_int)) (= CHARTYPE_22_30_26 97) (= true_term (is COMPOUNDNAME_24_67_7 T_int)) (= COMPOUNDNAME_24_67_7 53))
:extrafuns ((L_273_4 Int))
:extrafuns ((L_305_1 Int))
:extrafuns ((ecReturn Int))
:extrafuns ((L_321_1 Int))
:extrafuns ((L_424_1 Int))
:extrafuns ((L_277_1 Int))
:extrafuns ((L_415_1 Int))
:extrafuns ((S_432_25 Int))
:extrafuns ((raises_pre_31_32_35 Int))
:extrafuns ((raises_31_32_35 Int))
:extrafuns ((dims_pre_67_45_31 Int))
:extrafuns ((dims_67_45_31 Int))
:extrafuns ((syntax_pre_6_28_29 Int))
:extrafuns ((syntax_6_28_29 Int))
:extrafuns ((loc_pre_127_29_13 Int))
:extrafuns ((loc_127_29_13 Int))
:extrafuns ((methods_pre_5_883_26 Int))
:extrafuns ((methods_5_883_26 Int))
:extrafuns ((op_pre_72_35_13 Int))
:extrafuns ((op_72_35_13 Int))
:extrafuns ((RSHIFT_pre_23_31_26 Int))
:extrafuns ((FORSTMT_pre_24_39_7 Int))
:extrafuns ((LONGTYPE_pre_22_29_26 Int))
:extrafuns ((expr_pre_74_15_28 Int))
:extrafuns ((expr_74_15_28 Int))
:extrafuns ((name_pre_18_18_28 Int))
:extrafuns ((name_18_18_28 Int))
:extrafuns ((SIMPLENAME_pre_24_66_7 Int))
:extrafuns ((loc_pre_69_21_13 Int))
:extrafuns ((loc_69_21_13 Int))
:extrafuns ((stmts_pre_36_19_31 Int))
:extrafuns ((stmts_36_19_31 Int))
:extrafuns ((init_pre_28_20_17 Int))
:extrafuns ((init_28_20_17 Int))
:extrafuns ((PARSED_pre_5_772_28 Int))
:extrafuns ((locSuper_pre_82_20_13 Int))
:extrafuns ((locSuper_82_20_13 Int))
:extrafuns ((thn_pre_52_17_28 Int))
:extrafuns ((thn_52_17_28 Int))
:extrafuns ((LSHIFT_pre_23_30_26 Int))
:extrafuns ((IFSTMT_pre_24_38_7 Int))
:extrafuns ((INTTYPE_pre_22_28_26 Int))
:extrafuns ((loc_pre_47_20_13 Int))
:extrafuns ((loc_47_20_13 Int))
:extrafuns ((body_pre_59_19_33 Int))
:extrafuns ((body_59_19_33 Int))
:extrafuns ((locOpenParen_pre_60_48_13 Int))
:extrafuns ((locOpenParen_60_48_13 Int))
:extrafuns ((ARRAYTYPE_pre_24_65_7 Int))
:extrafuns ((args_pre_31_30_41 Int))
:extrafuns ((args_31_30_41 Int))
:extrafuns ((POSTFIXDEC_pre_23_63_26 Int))
:extrafuns ((CU_pre_5_71_30 Int))
:extrafuns ((CU_5_71_30 Int))
:extrafuns ((locType_pre_34_21_13 Int))
:extrafuns ((locType_34_21_13 Int))
:extrafuns ((locId_pre_51_20_13 Int))
:extrafuns ((locId_51_20_13 Int))
:extrafuns ((count_pre_95_67_33 Int))
:extrafuns ((count_95_67_33 Int))
:extrafuns ((LT_pre_23_29_26 Int))
:extrafuns ((LABELSTMT_pre_24_37_7 Int))
:extrafuns ((locId_pre_78_25_13 Int))
:extrafuns ((locId_78_25_13 Int))
:extrafuns ((enclosingInstance_pre_66_25_14 Int))
:extrafuns ((enclosingInstance_66_25_14 Int))
:extrafuns ((noTokens_pre_21_212_27 Int))
:extrafuns ((BOOLEANTYPE_pre_22_27_26 Int))
:extrafuns ((superClass_pre_25_15_18 Int))
:extrafuns ((superClass_25_15_18 Int))
:extrafuns ((index_pre_65_17_28 Int))
:extrafuns ((index_65_17_28 Int))
:extrafuns ((TYPENAME_pre_24_64_7 Int))
:extrafuns ((POSTFIXINC_pre_23_62_26 Int))
:extrafuns ((count_pre_64_67_33 Int))
:extrafuns ((count_64_67_33 Int))
:extrafuns ((expr_pre_52_15_28 Int))
:extrafuns ((expr_52_15_28 Int))
:extrafuns ((LE_pre_23_28_26 Int))
:extrafuns ((CONTINUESTMT_pre_24_36_7 Int))
:extrafuns ((locGuardOpenParen_pre_45_23_13 Int))
:extrafuns ((locGuardOpenParen_45_23_13 Int))
:extrafuns ((punctuationCodes_pre_21_164_19 Int))
:extrafuns ((IDENT_pre_22_25_26 Int))
:extrafuns ((loc_pre_149_20_13 Int))
:extrafuns ((loc_149_20_13 Int))
:extrafuns ((SUPEROBJECTDESIGNATOR_pre_24_63_7 Int))
:extrafuns ((lengthFieldDecl_pre_26_917_40 Int))
:extrafuns ((lengthFieldDecl_26_917_40 Int))
:extrafuns ((DEC_pre_23_59_26 Int))
:extrafuns ((locOpenBracket_pre_148_21_13 Int))
:extrafuns ((locOpenBracket_148_21_13 Int))
:extrafuns ((punctuationStrings_pre_21_134_22 Int))
:extrafuns ((ids_pre_150_19_37 Int))
:extrafuns ((ids_150_19_37 Int))
:extrafuns ((type_pre_69_18_28 Int))
:extrafuns ((type_69_18_28 Int))
:extrafuns ((GT_pre_23_27_26 Int))
:extrafuns ((BREAKSTMT_pre_24_35_7 Int))
:extrafuns ((elements_pre_94_61_38 Int))
:extrafuns ((elements_94_61_38 Int))
:extrafuns ((stmt_pre_47_17_33 Int))
:extrafuns ((stmt_47_17_33 Int))
:extrafuns ((count_pre_54_67_33 Int))
:extrafuns ((count_54_67_33 Int))
:extrafuns ((array_pre_65_15_28 Int))
:extrafuns ((array_65_15_28 Int))
:extrafuns ((locKeyword_pre_60_45_13 Int))
:extrafuns ((locKeyword_60_45_13 Int))
:extrafuns ((TYPEOBJECTDESIGNATOR_pre_24_62_7 Int))
:extrafuns ((loc_pre_145_18_13 Int))
:extrafuns ((loc_145_18_13 Int))
:extrafuns ((INC_pre_23_58_26 Int))
:extrafuns ((decl_pre_76_28_19 Int))
:extrafuns ((decl_76_28_19 Int))
:extrafuns ((count_pre_58_67_33 Int))
:extrafuns ((count_58_67_33 Int))
:extrafuns ((keywordStrings_pre_21_181_30 Int))
:extrafuns ((stmt_pre_51_17_28 Int))
:extrafuns ((stmt_51_17_28 Int))
:extrafuns ((GE_pre_23_26_26 Int))
:extrafuns ((fields_pre_5_875_27 Int))
:extrafuns ((fields_5_875_27 Int))
:extrafuns ((THROWSTMT_pre_24_34_7 Int))
:extrafuns ((loc_pre_50_18_13 Int))
:extrafuns ((loc_50_18_13 Int))
:extrafuns ((init_pre_67_35_19 Int))
:extrafuns ((init_67_35_19 Int))
:extrafuns ((EXPROBJECTDESIGNATOR_pre_24_61_7 Int))
:extrafuns ((BITNOT_pre_23_57_26 Int))
:extrafuns ((locCloseBrace_pre_14_54_13 Int))
:extrafuns ((locCloseBrace_14_54_13 Int))
:extrafuns ((count_pre_27_67_33 Int))
:extrafuns ((count_27_67_33 Int))
:extrafuns ((count_pre_32_67_33 Int))
:extrafuns ((count_32_67_33 Int))
:extrafuns ((id_pre_78_20_34 Int))
:extrafuns ((id_78_20_34 Int))
:extrafuns ((EQ_pre_23_25_26 Int))
:extrafuns ((RETURNSTMT_pre_24_33_7 Int))
:extrafuns ((expr_pre_47_15_28 Int))
:extrafuns ((expr_47_15_28 Int))
:extrafuns ((loc_pre_49_18_13 Int))
:extrafuns ((loc_49_18_13 Int))
:extrafuns ((CLASSLITERAL_pre_24_60_7 Int))
:extrafuns ((NOT_pre_23_56_26 Int))
:extrafuns ((returnType_pre_34_18_28 Int))
:extrafuns ((returnType_34_18_28 Int))
:extrafuns ((args_pre_77_32_31 Int))
:extrafuns ((args_77_32_31 Int))
:extrafuns ((myTypeDecl_pre_5_63_40 Int))
:extrafuns ((myTypeDecl_5_63_40 Int))
:extrafuns ((init_pre_43_19_17 Int))
:extrafuns ((init_43_19_17 Int))
:extrafuns ((NE_pre_23_24_26 Int))
:extrafuns ((EVALSTMT_pre_24_32_7 Int))
:extrafuns ((METHODINVOCATION_pre_24_59_7 Int))
:extrafuns ((UNARYSUB_pre_23_55_26 Int))
:extrafuns ((expr_pre_69_15_28 Int))
:extrafuns ((expr_69_15_28 Int))
:extrafuns ((locDot_pre_60_41_13 Int))
:extrafuns ((locDot_60_41_13 Int))
:extrafuns ((od_pre_78_18_40 Int))
:extrafuns ((od_78_18_40 Int))
:extrafuns ((loc_pre_45_20_13 Int))
:extrafuns ((loc_45_20_13 Int))
:extrafuns ((elemType_pre_148_18_28 Int))
:extrafuns ((elemType_148_18_28 Int))
:extrafuns ((LAST_KEYWORD_pre_21_103_26 Int))
:extrafuns ((BITAND_pre_23_23_26 Int))
:extrafuns ((SYNCHRONIZESTMT_pre_24_31_7 Int))
:extrafuns ((locId_pre_76_24_13 Int))
:extrafuns ((locId_76_24_13 Int))
:extrafuns ((expr_pre_50_15_28 Int))
:extrafuns ((expr_50_15_28 Int))
:extrafuns ((locDots_pre_150_31_29 Int))
:extrafuns ((locDots_150_31_29 Int))
:extrafuns ((AMBIGUOUSMETHODINVOCATION_pre_24_58_7 Int))
:extrafuns ((loc_pre_39_18_13 Int))
:extrafuns ((loc_39_18_13 Int))
:extrafuns ((decl_pre_42_15_36 Int))
:extrafuns ((decl_42_15_36 Int))
:extrafuns ((UNARYADD_pre_23_54_26 Int))
:extrafuns ((elements_pre_152_61_36 Int))
:extrafuns ((elements_152_61_36 Int))
:extrafuns ((locOpenParen_pre_77_30_13 Int))
:extrafuns ((locOpenParen_77_30_13 Int))
:extrafuns ((otherCodes_pre_21_202_27 Int))
:extrafuns ((locOpenBrace_pre_14_51_13 Int))
:extrafuns ((locOpenBrace_14_51_13 Int))
:extrafuns ((type_pre_81_27_28 Int))
:extrafuns ((type_81_27_28 Int))
:extrafuns ((NULL_pre_21_82_26 Int))
:extrafuns ((BITXOR_pre_23_22_26 Int))
:extrafuns ((loc_pre_86_30_13 Int))
:extrafuns ((loc_86_30_13 Int))
:extrafuns ((DOSTMT_pre_24_30_7 Int))
:extrafuns ((locDot_pre_71_23_13 Int))
:extrafuns ((locDot_71_23_13 Int))
:extrafuns ((expr_pre_49_15_14 Int))
:extrafuns ((expr_49_15_14 Int))
:extrafuns ((loc_pre_99_35_13 Int))
:extrafuns ((loc_99_35_13 Int))
:extrafuns ((FIELDACCESS_pre_24_57_7 Int))
:extrafuns ((decl_pre_75_26_38 Int))
:extrafuns ((decl_75_26_38 Int))
:extrafuns ((ASGBITXOR_pre_23_51_26 Int))
:extrafuns ((locCloseParen_pre_70_24_13 Int))
:extrafuns ((locCloseParen_70_24_13 Int))
:extrafuns ((BITOR_pre_23_21_26 Int))
:extrafuns ((WHILESTMT_pre_24_29_7 Int))
:extrafuns ((NULL_pre_97_60_26 Int))
:extrafuns ((elements_pre_133_61_39 Int))
:extrafuns ((elements_133_61_39 Int))
:extrafuns ((count_pre_16_67_33 Int))
:extrafuns ((count_16_67_33 Int))
:extrafuns ((type_pre_67_24_28 Int))
:extrafuns ((type_67_24_28 Int))
:extrafuns ((VARIABLEACCESS_pre_24_56_7 Int))
:extrafuns ((ASGBITOR_pre_23_50_26 Int))
:extrafuns ((id_pre_34_15_34 Int))
:extrafuns ((id_34_15_34 Int))
:extrafuns ((stmt_pre_45_17_28 Int))
:extrafuns ((stmt_45_17_28 Int))
:extrafuns ((CLASSDECLSTMT_pre_24_28_7 Int))
:extrafuns ((id_pre_76_21_34 Int))
:extrafuns ((id_76_21_34 Int))
:extrafuns ((AMBIGUOUSVARIABLEACCESS_pre_24_55_7 Int))
:extrafuns ((ASGBITAND_pre_23_49_26 Int))
:extrafuns ((expr_pre_39_15_28 Int))
:extrafuns ((expr_39_15_28 Int))
:extrafuns ((loc_pre_57_23_13 Int))
:extrafuns ((loc_57_23_13 Int))
:extrafuns ((expr_pre_80_22_28 Int))
:extrafuns ((expr_80_22_28 Int))
:extrafuns ((enclosingInstance_pre_60_37_14 Int))
:extrafuns ((enclosingInstance_60_37_14 Int))
:extrafuns ((VARDECLSTMT_pre_24_27_7 Int))
:extrafuns ((count_pre_41_67_33 Int))
:extrafuns ((count_41_67_33 Int))
:extrafuns ((locOpenBrackets_pre_67_65_29 Int))
:extrafuns ((locOpenBrackets_67_65_29 Int))
:extrafuns ((AND_pre_23_20_26 Int))
:extrafuns ((PARENEXPR_pre_24_54_7 Int))
:extrafuns ((ASGURSHIFT_pre_23_48_26 Int))
:extrafuns ((locId_pre_14_48_13 Int))
:extrafuns ((locId_14_48_13 Int))
:extrafuns ((NULLLIT_pre_22_45_26 Int))
:extrafuns ((tag_pre_99_30_13 Int))
:extrafuns ((tag_99_30_13 Int))
:extrafuns ((lenId_pre_26_914_30 Int))
:extrafuns ((lenId_26_914_30 Int))
:extrafuns ((loc_pre_46_20_13 Int))
:extrafuns ((loc_46_20_13 Int))
:extrafuns ((locOpenParen_pre_70_21_13 Int))
:extrafuns ((locOpenParen_70_21_13 Int))
:extrafuns ((expr_pre_45_15_28 Int))
:extrafuns ((expr_45_15_28 Int))
:extrafuns ((locFirstSemi_pre_53_36_13 Int))
:extrafuns ((locFirstSemi_53_36_13 Int))
:extrafuns ((locOpenParen_pre_66_52_13 Int))
:extrafuns ((locOpenParen_66_52_13 Int))
:extrafuns ((SWITCHSTMT_pre_24_26_7 Int))
:extrafuns ((od_pre_76_19_40 Int))
:extrafuns ((od_76_19_40 Int))
:extrafuns ((OR_pre_23_19_26 Int))
:extrafuns ((CASTEXPR_pre_24_53_7 Int))
:extrafuns ((ASGRSHIFT_pre_23_47_26 Int))
:extrafuns ((elements_pre_95_61_39 Int))
:extrafuns ((elements_95_61_39 Int))
:extrafuns ((STRINGLIT_pre_22_44_26 Int))
:extrafuns ((type_pre_71_20_28 Int))
:extrafuns ((type_71_20_28 Int))
:extrafuns ((loc_pre_75_22_13 Int))
:extrafuns ((loc_75_22_13 Int))
:extrafuns ((BLOCKSTMT_pre_24_25_7 Int))
:extrafuns ((elements_pre_64_61_36 Int))
:extrafuns ((elements_64_61_36 Int))
:extrafuns ((INSTANCEOFEXPR_pre_24_52_7 Int))
:extrafuns ((ASGLSHIFT_pre_23_46_26 Int))
:extrafuns ((DOUBLELIT_pre_22_43_26 Int))
:extrafuns ((locId_pre_29_38_13 Int))
:extrafuns ((locId_29_38_13 Int))
:extrafuns ((locColon_pre_68_25_13 Int))
:extrafuns ((locColon_68_25_13 Int))
:extrafuns ((FORMALPARADECL_pre_24_24_7 Int))
:extrafuns ((CONDEXPR_pre_24_51_7 Int))
:extrafuns ((ASGSUB_pre_23_45_26 Int))
:extrafuns ((otherStrings_pre_21_193_30 Int))
:extrafuns ((FLOATLIT_pre_22_42_26 Int))
:extrafuns ((TYPEMODIFIERPRAGMA_pre_21_28_26 Int))
:extrafuns ((stmt_pre_46_17_28 Int))
:extrafuns ((stmt_46_17_28 Int))
:extrafuns ((elements_pre_54_61_33 Int))
:extrafuns ((elements_54_61_33 Int))
:extrafuns ((loc_pre_14_45_13 Int))
:extrafuns ((loc_14_45_13 Int))
:extrafuns ((locCloseBrace_pre_63_24_13 Int))
:extrafuns ((locCloseBrace_63_24_13 Int))
:extrafuns ((type_pre_70_18_28 Int))
:extrafuns ((type_70_18_28 Int))
:extrafuns ((FIELDDECL_pre_24_23_7 Int))
:extrafuns ((loc_pre_66_49_13 Int))
:extrafuns ((loc_66_49_13 Int))
:extrafuns ((elements_pre_58_61_40 Int))
:extrafuns ((elements_58_61_40 Int))
:extrafuns ((length_pre_125_50_25 Int))
:extrafuns ((length_125_50_25 Int))
:extrafuns ((locFinally_pre_56_25_13 Int))
:extrafuns ((locFinally_56_25_13 Int))
:extrafuns ((tag_pre_98_32_13 Int))
:extrafuns ((tag_98_32_13 Int))
:extrafuns ((loc_pre_53_33_13 Int))
:extrafuns ((loc_53_33_13 Int))
:extrafuns ((ASGADD_pre_23_44_26 Int))
:extrafuns ((NEWARRAYEXPR_pre_24_50_7 Int))
:extrafuns ((locId_pre_31_43_13 Int))
:extrafuns ((locId_31_43_13 Int))
:extrafuns ((CHARLIT_pre_22_41_26 Int))
:extrafuns ((id_pre_75_19_34 Int))
:extrafuns ((id_75_19_34 Int))
:extrafuns ((catchClauses_pre_57_20_38 Int))
:extrafuns ((catchClauses_57_20_38 Int))
:extrafuns ((TYPEDECLELEMPRAGMA_pre_21_27_26 Int))
:extrafuns ((LOCALVARDECL_pre_24_22_7 Int))
:extrafuns ((elements_pre_27_61_41 Int))
:extrafuns ((elements_27_61_41 Int))
:extrafuns ((decl_pre_44_15_33 Int))
:extrafuns ((decl_44_15_33 Int))
:extrafuns ((elements_pre_32_61_43 Int))
:extrafuns ((elements_32_61_43 Int))
:extrafuns ((loc_pre_98_50_13 Int))
:extrafuns ((loc_98_50_13 Int))
:extrafuns ((ASGREM_pre_23_43_26 Int))
:extrafuns ((NEWINSTANCEEXPR_pre_24_49_7 Int))
:extrafuns ((LONGLIT_pre_22_40_26 Int))
:extrafuns ((enclosingEnv_pre_5_52_36 Int))
:extrafuns ((enclosingEnv_5_52_36 Int))
:extrafuns ((expr_pre_48_15_28 Int))
:extrafuns ((expr_48_15_28 Int))
:extrafuns ((expr_pre_46_15_28 Int))
:extrafuns ((expr_46_15_28 Int))
:extrafuns ((type_pre_29_35_28 Int))
:extrafuns ((type_29_35_28 Int))
:extrafuns ((loc_pre_141_18_13 Int))
:extrafuns ((loc_141_18_13 Int))
:extrafuns ((INITBLOCK_pre_24_21_7 Int))
:extrafuns ((locOp_pre_73_32_13 Int))
:extrafuns ((locOp_73_32_13 Int))
:extrafuns ((locQuestion_pre_68_22_13 Int))
:extrafuns ((locQuestion_68_22_13 Int))
:extrafuns ((STMTPRAGMA_pre_21_26_26 Int))
:extrafuns ((ASGDIV_pre_23_42_26 Int))
:extrafuns ((ARRAYREFEXPR_pre_24_48_7 Int))
:extrafuns ((INTLIT_pre_22_39_26 Int))
:extrafuns ((elems_pre_14_41_39 Int))
:extrafuns ((elems_14_41_39 Int))
:extrafuns ((locOpenBrace_pre_63_21_13 Int))
:extrafuns ((locOpenBrace_63_21_13 Int))
:extrafuns ((METHODDECL_pre_24_20_7 Int))
:extrafuns ((owner_pre_4_35_28 Int))
:extrafuns ((owner_4_35_28 Int))
:extrafuns ((anonDecl_pre_66_45_19 Int))
:extrafuns ((anonDecl_66_45_19 Int))
:extrafuns ((tryClause_pre_57_18_28 Int))
:extrafuns ((tryClause_57_18_28 Int))
:extrafuns ((body_pre_53_30_28 Int))
:extrafuns ((body_53_30_28 Int))
:extrafuns ((superCall_pre_60_24_17 Int))
:extrafuns ((superCall_60_24_17 Int))
:extrafuns ((ASGMUL_pre_23_41_26 Int))
:extrafuns ((THISEXPR_pre_24_47_7 Int))
:extrafuns ((MODIFIERPRAGMA_pre_21_25_26 Int))
:extrafuns ((BOOLEANLIT_pre_22_38_26 Int))
:extrafuns ((loc_pre_31_40_13 Int))
:extrafuns ((loc_31_40_13 Int))
:extrafuns ((locIds_pre_150_25_29 Int))
:extrafuns ((locIds_150_25_29 Int))
:extrafuns ((expr_pre_70_15_28 Int))
:extrafuns ((expr_70_15_28 Int))
:extrafuns ((count_pre_94_67_33 Int))
:extrafuns ((count_94_67_33 Int))
:extrafuns ((loc_pre_56_22_13 Int))
:extrafuns ((loc_56_22_13 Int))
:extrafuns ((locCloseParen_pre_74_21_13 Int))
:extrafuns ((locCloseParen_74_21_13 Int))
:extrafuns ((CONSTRUCTORDECL_pre_24_19_7 Int))
:extrafuns ((loc_pre_147_16_13 Int))
:extrafuns ((loc_147_16_13 Int))
:extrafuns ((locOp_pre_72_43_13 Int))
:extrafuns ((locOp_72_43_13 Int))
:extrafuns ((ASSIGN_pre_23_40_26 Int))
:extrafuns ((value_pre_98_45_16 Int))
:extrafuns ((value_98_45_16 Int))
:extrafuns ((ARRAYINIT_pre_24_46_7 Int))
:extrafuns ((SHORTTYPE_pre_22_36_26 Int))
:extrafuns ((TYPESIG_pre_20_6_28 Int))
:extrafuns ((FIRST_KEYWORD_pre_21_51_26 Int))
:extrafuns ((decl_pre_78_34_20 Int))
:extrafuns ((decl_78_34_20 Int))
:extrafuns ((INTERFACEDECL_pre_24_18_7 Int))
:extrafuns ((expr_pre_73_29_28 Int))
:extrafuns ((expr_73_29_28 Int))
:extrafuns ((LEXICALPRAGMA_pre_21_24_26 Int))
:extrafuns ((els_pre_68_19_28 Int))
:extrafuns ((els_68_19_28 Int))
:extrafuns ((forUpdate_pre_53_28_31 Int))
:extrafuns ((forUpdate_53_28_31 Int))
:extrafuns ((STAR_pre_23_37_26 Int))
:extrafuns ((CATCHCLAUSE_pre_24_45_7 Int))
:extrafuns ((BYTETYPE_pre_22_35_26 Int))
:extrafuns ((member_pre_5_44_39 Int))
:extrafuns ((member_5_44_39 Int))
:extrafuns ((args_pre_66_34_31 Int))
:extrafuns ((args_66_34_31 Int))
:extrafuns ((id_pre_29_32_34 Int))
:extrafuns ((id_29_32_34 Int))
:extrafuns ((locCloseBrace_pre_36_25_13 Int))
:extrafuns ((locCloseBrace_36_25_13 Int))
:extrafuns ((elements_pre_16_61_37 Int))
:extrafuns ((elements_16_61_37 Int))
:extrafuns ((elems_pre_63_18_34 Int))
:extrafuns ((elems_63_18_34 Int))
:extrafuns ((superInterfaces_pre_14_34_35 Int))
:extrafuns ((superInterfaces_14_34_35 Int))
:extrafuns ((CLASSDECL_pre_24_17_7 Int))
:extrafuns ((state_pre_5_787_15 Int))
:extrafuns ((state_5_787_15 Int))
:extrafuns ((MOD_pre_23_36_26 Int))
:extrafuns ((CONSTRUCTORINVOCATION_pre_24_44_7 Int))
:extrafuns ((NULLTYPE_pre_22_34_26 Int))
:extrafuns ((locCloseBracket_pre_65_23_13 Int))
:extrafuns ((locCloseBracket_65_23_13 Int))
:extrafuns ((loc_pre_55_29_13 Int))
:extrafuns ((loc_55_29_13 Int))
:extrafuns ((finallyClause_pre_56_19_28 Int))
:extrafuns ((finallyClause_56_19_28 Int))
:extrafuns ((ONDEMANDIMPORTDECL_pre_24_16_7 Int))
:extrafuns ((op_pre_73_26_13 Int))
:extrafuns ((op_73_26_13 Int))
:extrafuns ((thn_pre_68_17_28 Int))
:extrafuns ((thn_68_17_28 Int))
:extrafuns ((loc_pre_52_22_13 Int))
:extrafuns ((loc_52_22_13 Int))
:extrafuns ((DIV_pre_23_35_26 Int))
:extrafuns ((right_pre_72_40_28 Int))
:extrafuns ((right_72_40_28 Int))
:extrafuns ((TRYCATCHSTMT_pre_24_43_7 Int))
:extrafuns ((test_pre_53_26_28 Int))
:extrafuns ((test_53_26_28 Int))
:extrafuns ((VOIDTYPE_pre_22_33_26 Int))
:extrafuns ((elements_pre_41_61_33 Int))
:extrafuns ((elements_41_61_33 Int))
:extrafuns ((type_pre_66_32_32 Int))
:extrafuns ((type_66_32_32 Int))
:extrafuns ((loc_pre_67_49_13 Int))
:extrafuns ((loc_67_49_13 Int))
:extrafuns ((SINGLETYPEIMPORTDECL_pre_24_15_7 Int))
:extrafuns ((locOpenParen_pre_47_23_13 Int))
:extrafuns ((locOpenParen_47_23_13 Int))
:extrafuns ((count_pre_152_67_33 Int))
:extrafuns ((count_152_67_33 Int))
:extrafuns ((SUB_pre_23_34_26 Int))
:extrafuns ((TRYFINALLYSTMT_pre_24_42_7 Int))
:extrafuns ((args_pre_78_30_31 Int))
:extrafuns ((args_78_30_31 Int))
:extrafuns ((locDot_pre_79_21_13 Int))
:extrafuns ((locDot_79_21_13 Int))
:extrafuns ((locOpenParen_pre_74_18_13 Int))
:extrafuns ((locOpenParen_74_18_13 Int))
:extrafuns ((DOUBLETYPE_pre_22_32_26 Int))
:extrafuns ((block_pre_38_28_33 Int))
:extrafuns ((block_38_28_33 Int))
:extrafuns ((tryClause_pre_56_17_28 Int))
:extrafuns ((tryClause_56_17_28 Int))
:extrafuns ((locOpenBrace_pre_36_22_13 Int))
:extrafuns ((locOpenBrace_36_22_13 Int))
:extrafuns ((COMPILATIONUNIT_pre_24_14_7 Int))
:extrafuns ((simpleName_pre_5_37_38 Int))
:extrafuns ((simpleName_5_37_38 Int))
:extrafuns ((test_pre_68_15_28 Int))
:extrafuns ((test_68_15_28 Int))
:extrafuns ((CHECKED_pre_5_776_28 Int))
:extrafuns ((left_pre_72_38_28 Int))
:extrafuns ((left_72_38_28 Int))
:extrafuns ((ADD_pre_23_33_26 Int))
:extrafuns ((SWITCHLABEL_pre_24_41_7 Int))
:extrafuns ((forInit_pre_53_24_31 Int))
:extrafuns ((forInit_53_24_31 Int))
:extrafuns ((FLOATTYPE_pre_22_31_26 Int))
:extrafuns ((loc_pre_59_22_13 Int))
:extrafuns ((loc_59_22_13 Int))
:extrafuns ((locDot_pre_66_29_13 Int))
:extrafuns ((locDot_66_29_13 Int))
:extrafuns ((locOpenBrace_pre_31_36_13 Int))
:extrafuns ((locOpenBrace_31_36_13 Int))
:extrafuns ((PREPPED_pre_5_775_28 Int))
:extrafuns ((expr_pre_55_26_14 Int))
:extrafuns ((expr_55_26_14 Int))
:extrafuns ((tokenType_pre_96_90_8 Int))
:extrafuns ((tokenType_96_90_8 Int))
:extrafuns ((count_pre_133_67_33 Int))
:extrafuns ((count_133_67_33 Int))
:extrafuns ((decl_pre_60_54_25 Int))
:extrafuns ((decl_60_54_25 Int))
:extrafuns ((body_pre_31_34_19 Int))
:extrafuns ((body_31_34_19 Int))
:extrafuns ((els_pre_52_19_28 Int))
:extrafuns ((els_52_19_28 Int))
:extrafuns ((URSHIFT_pre_23_32_26 Int))
:extrafuns ((SKIPSTMT_pre_24_40_7 Int))
:extrafuns ((locOpenParen_pre_78_28_13 Int))
:extrafuns ((locOpenParen_78_28_13 Int))
:extrafuns ((LINKSRESOLVED_pre_5_774_28 Int))
:extrafuns ((CHARTYPE_pre_22_30_26 Int))
:extrafuns ((locOpenBracket_pre_65_20_13 Int))
:extrafuns ((locOpenBracket_65_20_13 Int))
:extrafuns ((enclosingType_pre_5_32_39 Int))
:extrafuns ((enclosingType_5_32_39 Int))
:extrafuns ((args_pre_60_51_31 Int))
:extrafuns ((args_60_51_31 Int))
:extrafuns ((COMPOUNDNAME_pre_24_67_7 Int))
:extrafuns ((elems_pre Int))
:extrafuns ((elems Int))
:extrafuns ((LS Int))
:extrafuns ((alloc_pre Int))
:extrafuns ((sig_263_39 Int))
:extrafuns ((expr_263_52 Int))
:extrafuns ((i_270_23_270_23_62_1881_40 Int))
:extrafuns ((RES_270_23_270_23 Int))
:extrafuns ((EC_270_23_270_23 Int))
:extrafuns ((RES Int))
:extrafuns ((EC Int))
:extrafuns ((RES_1_ Int))
:extrafuns ((EC_1_ Int))
:extrafuns ((RES_2_ Int))
:extrafuns ((EC_2_ Int))
:extrafuns ((RES_273_17_273_17 Int))
:extrafuns ((EC_273_17_273_17 Int))
:extrafuns ((ai_276_1 Int))
:extrafuns ((EC_loopold Int))
:extrafuns ((i_loopold_277_9 Int))
:extrafuns ((this_277_29_277_1_0_277_29 Int))
:extrafuns ((RES_277_1_0_277_29_277_29 Int))
:extrafuns ((EC_277_1_0_277_29_277_29 Int))
:extrafuns ((tmp3_elems_277_1_0_278_18 Int))
:extrafuns ((RES_277_1_0_278_27_278_27 Int))
:extrafuns ((EC_277_1_0_278_27_278_27 Int))
:extrafuns ((EC_277_1_0_278_3_278_3 Int))
:extrafuns ((i_277_1_0_277_37 Int))
:extrafuns ((r_293_8 Int))
:extrafuns ((expr_294_1_294_1_263_52 Int))
:extrafuns ((EC_294_1_294_1 Int))
:extrafuns ((expr_295_1_295_1_263_52 Int))
:extrafuns ((ne_301_8 Int))
:extrafuns ((expr_303_5_303_5_263_52 Int))
:extrafuns ((EC_303_5_303_5 Int))
:extrafuns ((RES_3_ Int))
:extrafuns ((RES_303_5_303_5 Int))
:extrafuns ((EC_3_ Int))
:extrafuns ((tmp8_type_304_11 Int))
:extrafuns ((resolved_304_1_304_1_97_47 Int))
:extrafuns ((EC_304_1_304_1 Int))
:extrafuns ((i_loopold_305_9 Int))
:extrafuns ((EC_loopold_1_ Int))
:extrafuns ((this_305_28_305_1_0_305_28 Int))
:extrafuns ((RES_305_1_0_305_28_305_28 Int))
:extrafuns ((EC_305_1_0_305_28_305_28 Int))
:extrafuns ((tmp11_args_305_1_0_306_18 Int))
:extrafuns ((RES_305_1_0_306_26_306_26 Int))
:extrafuns ((EC_305_1_0_306_26_306_26 Int))
:extrafuns ((EC_305_1_0_306_3_306_3 Int))
:extrafuns ((i_305_1_0_305_36 Int))
:extrafuns ((RES_4_ Int))
:extrafuns ((this_305_28_305_1_1_305_28 Int))
:extrafuns ((RES_305_1_1_305_28_305_28 Int))
:extrafuns ((EC_305_1_1_305_28_305_28 Int))
:extrafuns ((RES_5_ Int))
:extrafuns ((EC_4_ Int))
:extrafuns ((tmp13_cand_308_5 Int))
:extrafuns ((tmp13_cand_308_23 Int))
:extrafuns ((d_309_32_309_32_5_115_56 Int))
:extrafuns ((RES_309_32_309_32 Int))
:extrafuns ((EC_309_32_309_32 Int))
:extrafuns ((na_319_8 Int))
:extrafuns ((tmp14_type_320_11 Int))
:extrafuns ((resolved_320_1_320_1_97_47 Int))
:extrafuns ((EC_320_1_320_1 Int))
:extrafuns ((EC_loopold_2_ Int))
:extrafuns ((i_loopold_321_9 Int))
:extrafuns ((this_321_28_321_1_0_321_28 Int))
:extrafuns ((RES_321_1_0_321_28_321_28 Int))
:extrafuns ((EC_321_1_0_321_28_321_28 Int))
:extrafuns ((tmp17_dims_321_1_0_322_18 Int))
:extrafuns ((RES_321_1_0_322_26_322_26 Int))
:extrafuns ((EC_321_1_0_322_26_322_26 Int))
:extrafuns ((EC_321_1_0_322_3_322_3 Int))
:extrafuns ((i_321_1_0_321_36 Int))
:extrafuns ((ce_328_8 Int))
:extrafuns ((expr_329_1_329_1_263_52 Int))
:extrafuns ((EC_329_1_329_1 Int))
:extrafuns ((expr_330_1_330_1_263_52 Int))
:extrafuns ((EC_330_1_330_1 Int))
:extrafuns ((expr_331_1_331_1_263_52 Int))
:extrafuns ((ie_337_8 Int))
:extrafuns ((expr_338_1_338_1_263_52 Int))
:extrafuns ((EC_338_1_338_1 Int))
:extrafuns ((tmp23_type_339_11 Int))
:extrafuns ((resolved_339_1_339_1_97_47 Int))
:extrafuns ((ce_345_8 Int))
:extrafuns ((expr_346_1_346_1_263_52 Int))
:extrafuns ((EC_346_1_346_1 Int))
:extrafuns ((tmp25_type_347_11 Int))
:extrafuns ((resolved_347_1_347_1_97_47 Int))
:extrafuns ((cl_353_8 Int))
:extrafuns ((tmp26_type_354_11 Int))
:extrafuns ((resolved_354_1_354_1_97_47 Int))
:extrafuns ((be_375_8 Int))
:extrafuns ((expr_376_1_376_1_263_52 Int))
:extrafuns ((EC_376_1_376_1 Int))
:extrafuns ((expr_377_1_377_1_263_52 Int))
:extrafuns ((expr_385_6_385_6_263_52 Int))
:extrafuns ((expr_389_6_389_6_263_52 Int))
:extrafuns ((b_397_13_397_13_17_20_40 Int))
:extrafuns ((EC_397_13_397_13 Int))
:extrafuns ((xp_403_1 Int))
:extrafuns ((od_404_1_404_1_438_73 Int))
:extrafuns ((EC_404_1_404_1 Int))
:extrafuns ((tmp33_cand_406_6 Int))
:extrafuns ((tmp33_cand_406_34 Int))
:extrafuns ((b_413_8_413_8_17_20_40 Int))
:extrafuns ((EC_413_8_413_8 Int))
:extrafuns ((ami_414_1 Int))
:extrafuns ((i_loopold_415_9 Int))
:extrafuns ((EC_loopold_3_ Int))
:extrafuns ((this_415_29_415_1_0_415_29 Int))
:extrafuns ((RES_415_1_0_415_29_415_29 Int))
:extrafuns ((EC_415_1_0_415_29_415_29 Int))
:extrafuns ((tmp36_args_415_1_0_416_18 Int))
:extrafuns ((RES_415_1_0_416_27_416_27 Int))
:extrafuns ((EC_415_1_0_416_27_416_27 Int))
:extrafuns ((EC_415_1_0_416_3_416_3 Int))
:extrafuns ((i_415_1_0_415_37 Int))
:extrafuns ((mi_422_1 Int))
:extrafuns ((od_423_1_423_1_438_73 Int))
:extrafuns ((EC_423_1_423_1 Int))
:extrafuns ((i_loopold_424_9 Int))
:extrafuns ((EC_loopold_4_ Int))
:extrafuns ((this_424_28_424_1_0_424_28 Int))
:extrafuns ((RES_424_1_0_424_28_424_28 Int))
:extrafuns ((EC_424_1_0_424_28_424_28 Int))
:extrafuns ((tmp41_args_424_1_0_425_18 Int))
:extrafuns ((RES_424_1_0_425_26_425_26 Int))
:extrafuns ((EC_424_1_0_425_26_425_26 Int))
:extrafuns ((EC_424_1_0_425_3_425_3 Int))
:extrafuns ((i_424_1_0_424_36 Int))
:extrafuns ((RES_6_ Int))
:extrafuns ((this_424_28_424_1_1_424_28 Int))
:extrafuns ((RES_424_1_1_424_28_424_28 Int))
:extrafuns ((EC_424_1_1_424_28_424_28 Int))
:extrafuns ((RES_7_ Int))
:extrafuns ((EC_5_ Int))
:extrafuns ((tmp44_cand_426_18 Int))
:extrafuns ((tmp44_cand_427_3 Int))
:extrafuns ((RES_432_48_432_48 Int))
:extrafuns ((EC_432_48_432_48 Int))
:extrafuns ((msg_432_20_432_20_17_15_35 Int))
:extrafuns ((EC_432_20_432_20 Int))
:extrafuns ((EC_6_ Int))
:extrafuns ((RES_8_ Int))
:extrafuns ((this_277_29_277_1_1_277_29 Int))
:extrafuns ((RES_277_1_1_277_29_277_29 Int))
:extrafuns ((EC_277_1_1_277_29_277_29 Int))
:extrafuns ((RES_276_16 Int))
:extrafuns ((EC_276_16 Int))
:extrafuns ((RES_9_ Int))
:extrafuns ((EC_7_ Int))
:extrafuns ((RES_10_ Int))
:extrafuns ((EC_8_ Int))
:extrafuns ((RES_11_ Int))
:extrafuns ((EC_9_ Int))
:extrafuns ((EC_295_1_295_1 Int))
:extrafuns ((RES_295_1_295_1 Int))
:extrafuns ((RES_12_ Int))
:extrafuns ((EC_10_ Int))
:extrafuns ((RES_301_29 Int))
:extrafuns ((EC_301_29 Int))
:extrafuns ((EC_309_5_309_5 Int))
:extrafuns ((RES_13_ Int))
:extrafuns ((RES_309_5_309_5 Int))
:extrafuns ((EC_11_ Int))
:extrafuns ((RES_14_ Int))
:extrafuns ((EC_12_ Int))
:extrafuns ((RES_15_ Int))
:extrafuns ((this_321_28_321_1_1_321_28 Int))
:extrafuns ((RES_321_1_1_321_28_321_28 Int))
:extrafuns ((EC_321_1_1_321_28_321_28 Int))
:extrafuns ((RES_319_26 Int))
:extrafuns ((EC_319_26 Int))
:extrafuns ((RES_16_ Int))
:extrafuns ((EC_13_ Int))
:extrafuns ((RES_17_ Int))
:extrafuns ((EC_14_ Int))
:extrafuns ((EC_331_1_331_1 Int))
:extrafuns ((RES_331_1_331_1 Int))
:extrafuns ((RES_18_ Int))
:extrafuns ((EC_15_ Int))
:extrafuns ((EC_339_1_339_1 Int))
:extrafuns ((RES_339_1_339_1 Int))
:extrafuns ((RES_19_ Int))
:extrafuns ((EC_16_ Int))
:extrafuns ((EC_347_1_347_1 Int))
:extrafuns ((RES_347_1_347_1 Int))
:extrafuns ((RES_20_ Int))
:extrafuns ((EC_17_ Int))
:extrafuns ((EC_354_1_354_1 Int))
:extrafuns ((RES_354_1_354_1 Int))
:extrafuns ((RES_21_ Int))
:extrafuns ((EC_18_ Int))
:extrafuns ((EC_377_1_377_1 Int))
:extrafuns ((RES_377_1_377_1 Int))
:extrafuns ((RES_22_ Int))
:extrafuns ((EC_19_ Int))
:extrafuns ((EC_385_6_385_6 Int))
:extrafuns ((RES_385_6_385_6 Int))
:extrafuns ((RES_23_ Int))
:extrafuns ((EC_20_ Int))
:extrafuns ((EC_389_6_389_6 Int))
:extrafuns ((RES_389_6_389_6 Int))
:extrafuns ((RES_24_ Int))
:extrafuns ((EC_21_ Int))
:extrafuns ((b_393_13_393_13_17_20_40 Int))
:extrafuns ((EC_393_13_393_13 Int))
:extrafuns ((RES_393_13_393_13 Int))
:extrafuns ((RES_25_ Int))
:extrafuns ((EC_22_ Int))
:extrafuns ((obj_398_13_398_13_17_30_38 Int))
:extrafuns ((EC_398_13_398_13 Int))
:extrafuns ((RES_398_13_398_13 Int))
:extrafuns ((RES_26_ Int))
:extrafuns ((EC_23_ Int))
:extrafuns ((tmp32_cor_407_3 Int))
:extrafuns ((tmp32_cor_406_5 Int))
:extrafuns ((EC_405_8_405_8 Int))
:extrafuns ((RES_405_8_405_8 Int))
:extrafuns ((RES_27_ Int))
:extrafuns ((EC_24_ Int))
:extrafuns ((RES_28_ Int))
:extrafuns ((this_415_29_415_1_1_415_29 Int))
:extrafuns ((RES_415_1_1_415_29_415_29 Int))
:extrafuns ((EC_415_1_1_415_29_415_29 Int))
:extrafuns ((RES_413_20 Int))
:extrafuns ((EC_413_20 Int))
:extrafuns ((RES_29_ Int))
:extrafuns ((EC_25_ Int))
:extrafuns ((RES_30_ Int))
:extrafuns ((EC_26_ Int))
:extrafuns ((RES_422_23 Int))
:extrafuns ((EC_422_23 Int))
:extrafuns ((tmp43_cor_428_3 Int))
:extrafuns ((tmp43_cor_426_17 Int))
:extrafuns ((EC_426_8_426_8 Int))
:extrafuns ((RES_426_8_426_8 Int))
:extrafuns ((EC_267_11 Int))
:formula (not (implies (and (distinct L_273_4 L_305_1 ecReturn L_321_1 L_424_1 L_277_1 L_415_1) (not (= S_432_25 null)) (= (typeof S_432_25) T_java_lang_String)) (implies (and (= raises_pre_31_32_35 raises_31_32_35) (= raises_31_32_35 (asField raises_31_32_35 T_javafe_ast_TypeNameVec)) (< (fClosedTime raises_31_32_35) alloc) (forall (?s Int) (implies (not (= ?s null)) (not (= (S_select raises_31_32_35 ?s) null)))) (= dims_pre_67_45_31 dims_67_45_31) (= dims_67_45_31 (asField dims_67_45_31 T_javafe_ast_ExprVec)) (< (fClosedTime dims_67_45_31) alloc) (forall (?s_1_ Int) (implies (not (= ?s_1_ null)) (not (= (S_select dims_67_45_31 ?s_1_) null)))) (= syntax_pre_6_28_29 syntax_6_28_29) (= syntax_6_28_29 (asField syntax_6_28_29 T_boolean)) (= loc_pre_127_29_13 loc_127_29_13) (= loc_127_29_13 (asField loc_127_29_13 T_int)) (= methods_pre_5_883_26 methods_5_883_26) (= methods_5_883_26 (asField methods_5_883_26 T_javafe_tc_MethodDeclVec)) (< (fClosedTime methods_5_883_26) alloc) (= op_pre_72_35_13 op_72_35_13) (= op_72_35_13 (asField op_72_35_13 T_int)) (= RSHIFT_pre_23_31_26 RSHIFT_23_31_26) (= true_term (is RSHIFT_23_31_26 T_int)) (= FORSTMT_pre_24_39_7 FORSTMT_24_39_7) (= true_term (is FORSTMT_24_39_7 T_int)) (= LONGTYPE_pre_22_29_26 LONGTYPE_22_29_26) (= true_term (is LONGTYPE_22_29_26 T_int)) (= expr_pre_74_15_28 expr_74_15_28) (= expr_74_15_28 (asField expr_74_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_74_15_28) alloc) (forall (?s_2_ Int) (implies (not (= ?s_2_ null)) (not (= (S_select expr_74_15_28 ?s_2_) null)))) (= name_pre_18_18_28 name_18_18_28) (= name_18_18_28 (asField name_18_18_28 T_javafe_ast_Name)) (< (fClosedTime name_18_18_28) alloc) (forall (?s_3_ Int) (implies (not (= ?s_3_ null)) (not (= (S_select name_18_18_28 ?s_3_) null)))) (= SIMPLENAME_pre_24_66_7 SIMPLENAME_24_66_7) (= true_term (is SIMPLENAME_24_66_7 T_int)) (= loc_pre_69_21_13 loc_69_21_13) (= loc_69_21_13 (asField loc_69_21_13 T_int)) (= stmts_pre_36_19_31 stmts_36_19_31) (= stmts_36_19_31 (asField stmts_36_19_31 T_javafe_ast_StmtVec)) (< (fClosedTime stmts_36_19_31) alloc) (forall (?s_4_ Int) (implies (not (= ?s_4_ null)) (not (= (S_select stmts_36_19_31 ?s_4_) null)))) (= init_pre_28_20_17 init_28_20_17) (= init_28_20_17 (asField init_28_20_17 T_javafe_ast_VarInit)) (< (fClosedTime init_28_20_17) alloc) (= PARSED_pre_5_772_28 PARSED_5_772_28) (= true_term (is PARSED_5_772_28 T_int)) (= locSuper_pre_82_20_13 locSuper_82_20_13) (= locSuper_82_20_13 (asField locSuper_82_20_13 T_int)) (= thn_pre_52_17_28 thn_52_17_28) (= thn_52_17_28 (asField thn_52_17_28 T_javafe_ast_Stmt)) (< (fClosedTime thn_52_17_28) alloc) (forall (?s_5_ Int) (implies (not (= ?s_5_ null)) (not (= (S_select thn_52_17_28 ?s_5_) null)))) (= LSHIFT_pre_23_30_26 LSHIFT_23_30_26) (= true_term (is LSHIFT_23_30_26 T_int)) (= IFSTMT_pre_24_38_7 IFSTMT_24_38_7) (= true_term (is IFSTMT_24_38_7 T_int)) (= INTTYPE_pre_22_28_26 INTTYPE_22_28_26) (= true_term (is INTTYPE_22_28_26 T_int)) (= loc_pre_47_20_13 loc_47_20_13) (= loc_47_20_13 (asField loc_47_20_13 T_int)) (= body_pre_59_19_33 body_59_19_33) (= body_59_19_33 (asField body_59_19_33 T_javafe_ast_BlockStmt)) (< (fClosedTime body_59_19_33) alloc) (forall (?s_6_ Int) (implies (not (= ?s_6_ null)) (not (= (S_select body_59_19_33 ?s_6_) null)))) (= locOpenParen_pre_60_48_13 locOpenParen_60_48_13) (= locOpenParen_60_48_13 (asField locOpenParen_60_48_13 T_int)) (= ARRAYTYPE_pre_24_65_7 ARRAYTYPE_24_65_7) (= true_term (is ARRAYTYPE_24_65_7 T_int)) (= args_pre_31_30_41 args_31_30_41) (= args_31_30_41 (asField args_31_30_41 T_javafe_ast_FormalParaDeclVec)) (< (fClosedTime args_31_30_41) alloc) (forall (?s_7_ Int) (implies (not (= ?s_7_ null)) (not (= (S_select args_31_30_41 ?s_7_) null)))) (= POSTFIXDEC_pre_23_63_26 POSTFIXDEC_23_63_26) (= true_term (is POSTFIXDEC_23_63_26 T_int)) (= CU_pre_5_71_30 CU_5_71_30) (= CU_5_71_30 (asField CU_5_71_30 T_javafe_ast_CompilationUnit)) (< (fClosedTime CU_5_71_30) alloc) (= locType_pre_34_21_13 locType_34_21_13) (= locType_34_21_13 (asField locType_34_21_13 T_int)) (= locId_pre_51_20_13 locId_51_20_13) (= locId_51_20_13 (asField locId_51_20_13 T_int)) (= count_pre_95_67_33 count_95_67_33) (= count_95_67_33 (asField count_95_67_33 T_int)) (= LT_pre_23_29_26 LT_23_29_26) (= true_term (is LT_23_29_26 T_int)) (= LABELSTMT_pre_24_37_7 LABELSTMT_24_37_7) (= true_term (is LABELSTMT_24_37_7 T_int)) (= locId_pre_78_25_13 locId_78_25_13) (= locId_78_25_13 (asField locId_78_25_13 T_int)) (= enclosingInstance_pre_66_25_14 enclosingInstance_66_25_14) (= enclosingInstance_66_25_14 (asField enclosingInstance_66_25_14 T_javafe_ast_Expr)) (< (fClosedTime enclosingInstance_66_25_14) alloc) (= noTokens_pre_21_212_27 noTokens_21_212_27) (= true_term (is noTokens_21_212_27 T_int)) (= BOOLEANTYPE_pre_22_27_26 BOOLEANTYPE_22_27_26) (= true_term (is BOOLEANTYPE_22_27_26 T_int)) (= superClass_pre_25_15_18 superClass_25_15_18) (= superClass_25_15_18 (asField superClass_25_15_18 T_javafe_ast_TypeName)) (< (fClosedTime superClass_25_15_18) alloc) (= index_pre_65_17_28 index_65_17_28) (= index_65_17_28 (asField index_65_17_28 T_javafe_ast_Expr)) (< (fClosedTime index_65_17_28) alloc) (forall (?s_8_ Int) (implies (not (= ?s_8_ null)) (not (= (S_select index_65_17_28 ?s_8_) null)))) (= TYPENAME_pre_24_64_7 TYPENAME_24_64_7) (= true_term (is TYPENAME_24_64_7 T_int)) (= POSTFIXINC_pre_23_62_26 POSTFIXINC_23_62_26) (= true_term (is POSTFIXINC_23_62_26 T_int)) (= count_pre_64_67_33 count_64_67_33) (= count_64_67_33 (asField count_64_67_33 T_int)) (= expr_pre_52_15_28 expr_52_15_28) (= expr_52_15_28 (asField expr_52_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_52_15_28) alloc) (forall (?s_9_ Int) (implies (not (= ?s_9_ null)) (not (= (S_select expr_52_15_28 ?s_9_) null)))) (= LE_pre_23_28_26 LE_23_28_26) (= true_term (is LE_23_28_26 T_int)) (= CONTINUESTMT_pre_24_36_7 CONTINUESTMT_24_36_7) (= true_term (is CONTINUESTMT_24_36_7 T_int)) (= locGuardOpenParen_pre_45_23_13 locGuardOpenParen_45_23_13) (= locGuardOpenParen_45_23_13 (asField locGuardOpenParen_45_23_13 T_int)) (= punctuationCodes_pre_21_164_19 punctuationCodes_21_164_19) (= true_term (is punctuationCodes_21_164_19 (array T_int))) (= true_term (isAllocated punctuationCodes_21_164_19 alloc)) (= IDENT_pre_22_25_26 IDENT_22_25_26) (= true_term (is IDENT_22_25_26 T_int)) (= loc_pre_149_20_13 loc_149_20_13) (= loc_149_20_13 (asField loc_149_20_13 T_int)) (= SUPEROBJECTDESIGNATOR_pre_24_63_7 SUPEROBJECTDESIGNATOR_24_63_7) (= true_term (is SUPEROBJECTDESIGNATOR_24_63_7 T_int)) (= lengthFieldDecl_pre_26_917_40 lengthFieldDecl_26_917_40) (= true_term (is lengthFieldDecl_26_917_40 T_javafe_ast_FieldDecl)) (= true_term (isAllocated lengthFieldDecl_26_917_40 alloc)) (not (= lengthFieldDecl_26_917_40 null)) (= DEC_pre_23_59_26 DEC_23_59_26) (= true_term (is DEC_23_59_26 T_int)) (= locOpenBracket_pre_148_21_13 locOpenBracket_148_21_13) (= locOpenBracket_148_21_13 (asField locOpenBracket_148_21_13 T_int)) (= punctuationStrings_pre_21_134_22 punctuationStrings_21_134_22) (= true_term (is punctuationStrings_21_134_22 (array T_java_lang_String))) (= true_term (isAllocated punctuationStrings_21_134_22 alloc)) (= ids_pre_150_19_37 ids_150_19_37) (= ids_150_19_37 (asField ids_150_19_37 T_javafe_ast_IdentifierVec)) (< (fClosedTime ids_150_19_37) alloc) (forall (?s_10_ Int) (implies (not (= ?s_10_ null)) (not (= (S_select ids_150_19_37 ?s_10_) null)))) (= type_pre_69_18_28 type_69_18_28) (= type_69_18_28 (asField type_69_18_28 T_javafe_ast_Type)) (< (fClosedTime type_69_18_28) alloc) (forall (?s_11_ Int) (implies (not (= ?s_11_ null)) (not (= (S_select type_69_18_28 ?s_11_) null)))) (= GT_pre_23_27_26 GT_23_27_26) (= true_term (is GT_23_27_26 T_int)) (= BREAKSTMT_pre_24_35_7 BREAKSTMT_24_35_7) (= true_term (is BREAKSTMT_24_35_7 T_int)) (= elements_pre_94_61_38 elements_94_61_38) (= elements_94_61_38 (asField elements_94_61_38 (array T_javafe_ast_FieldDecl))) (< (fClosedTime elements_94_61_38) alloc) (forall (?s_12_ Int) (implies (not (= ?s_12_ null)) (not (= (S_select elements_94_61_38 ?s_12_) null)))) (= stmt_pre_47_17_33 stmt_47_17_33) (= stmt_47_17_33 (asField stmt_47_17_33 T_javafe_ast_BlockStmt)) (< (fClosedTime stmt_47_17_33) alloc) (forall (?s_13_ Int) (implies (not (= ?s_13_ null)) (not (= (S_select stmt_47_17_33 ?s_13_) null)))) (= count_pre_54_67_33 count_54_67_33) (= count_54_67_33 (asField count_54_67_33 T_int)) (= array_pre_65_15_28 array_65_15_28) (= array_65_15_28 (asField array_65_15_28 T_javafe_ast_Expr)) (< (fClosedTime array_65_15_28) alloc) (forall (?s_14_ Int) (implies (not (= ?s_14_ null)) (not (= (S_select array_65_15_28 ?s_14_) null)))) (= locKeyword_pre_60_45_13 locKeyword_60_45_13) (= locKeyword_60_45_13 (asField locKeyword_60_45_13 T_int)) (= TYPEOBJECTDESIGNATOR_pre_24_62_7 TYPEOBJECTDESIGNATOR_24_62_7) (= true_term (is TYPEOBJECTDESIGNATOR_24_62_7 T_int)) (= loc_pre_145_18_13 loc_145_18_13) (= loc_145_18_13 (asField loc_145_18_13 T_int)) (= INC_pre_23_58_26 INC_23_58_26) (= true_term (is INC_23_58_26 T_int)) (= decl_pre_76_28_19 decl_76_28_19) (= decl_76_28_19 (asField decl_76_28_19 T_javafe_ast_FieldDecl)) (< (fClosedTime decl_76_28_19) alloc) (= count_pre_58_67_33 count_58_67_33) (= count_58_67_33 (asField count_58_67_33 T_int)) (= keywordStrings_pre_21_181_30 keywordStrings_21_181_30) (= true_term (is keywordStrings_21_181_30 (array T_java_lang_String))) (= true_term (isAllocated keywordStrings_21_181_30 alloc)) (= stmt_pre_51_17_28 stmt_51_17_28) (= stmt_51_17_28 (asField stmt_51_17_28 T_javafe_ast_Stmt)) (< (fClosedTime stmt_51_17_28) alloc) (forall (?s_15_ Int) (implies (not (= ?s_15_ null)) (not (= (S_select stmt_51_17_28 ?s_15_) null)))) (= GE_pre_23_26_26 GE_23_26_26) (= true_term (is GE_23_26_26 T_int)) (= fields_pre_5_875_27 fields_5_875_27) (= fields_5_875_27 (asField fields_5_875_27 T_javafe_tc_FieldDeclVec)) (< (fClosedTime fields_5_875_27) alloc) (= THROWSTMT_pre_24_34_7 THROWSTMT_24_34_7) (= true_term (is THROWSTMT_24_34_7 T_int)) (= loc_pre_50_18_13 loc_50_18_13) (= loc_50_18_13 (asField loc_50_18_13 T_int)) (= init_pre_67_35_19 init_67_35_19) (= init_67_35_19 (asField init_67_35_19 T_javafe_ast_ArrayInit)) (< (fClosedTime init_67_35_19) alloc) (= EXPROBJECTDESIGNATOR_pre_24_61_7 EXPROBJECTDESIGNATOR_24_61_7) (= true_term (is EXPROBJECTDESIGNATOR_24_61_7 T_int)) (= BITNOT_pre_23_57_26 BITNOT_23_57_26) (= true_term (is BITNOT_23_57_26 T_int)) (= locCloseBrace_pre_14_54_13 locCloseBrace_14_54_13) (= locCloseBrace_14_54_13 (asField locCloseBrace_14_54_13 T_int)) (= count_pre_27_67_33 count_27_67_33) (= count_27_67_33 (asField count_27_67_33 T_int)) (= count_pre_32_67_33 count_32_67_33) (= count_32_67_33 (asField count_32_67_33 T_int)) (= id_pre_78_20_34 id_78_20_34) (= id_78_20_34 (asField id_78_20_34 T_javafe_ast_Identifier)) (< (fClosedTime id_78_20_34) alloc) (forall (?s_16_ Int) (implies (not (= ?s_16_ null)) (not (= (S_select id_78_20_34 ?s_16_) null)))) (= EQ_pre_23_25_26 EQ_23_25_26) (= true_term (is EQ_23_25_26 T_int)) (= RETURNSTMT_pre_24_33_7 RETURNSTMT_24_33_7) (= true_term (is RETURNSTMT_24_33_7 T_int)) (= expr_pre_47_15_28 expr_47_15_28) (= expr_47_15_28 (asField expr_47_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_47_15_28) alloc) (forall (?s_17_ Int) (implies (not (= ?s_17_ null)) (not (= (S_select expr_47_15_28 ?s_17_) null)))) (= loc_pre_49_18_13 loc_49_18_13) (= loc_49_18_13 (asField loc_49_18_13 T_int)) (= CLASSLITERAL_pre_24_60_7 CLASSLITERAL_24_60_7) (= true_term (is CLASSLITERAL_24_60_7 T_int)) (= NOT_pre_23_56_26 NOT_23_56_26) (= true_term (is NOT_23_56_26 T_int)) (= returnType_pre_34_18_28 returnType_34_18_28) (= returnType_34_18_28 (asField returnType_34_18_28 T_javafe_ast_Type)) (< (fClosedTime returnType_34_18_28) alloc) (forall (?s_18_ Int) (implies (not (= ?s_18_ null)) (not (= (S_select returnType_34_18_28 ?s_18_) null)))) (= args_pre_77_32_31 args_77_32_31) (= args_77_32_31 (asField args_77_32_31 T_javafe_ast_ExprVec)) (< (fClosedTime args_77_32_31) alloc) (forall (?s_19_ Int) (implies (not (= ?s_19_ null)) (not (= (S_select args_77_32_31 ?s_19_) null)))) (= myTypeDecl_pre_5_63_40 myTypeDecl_5_63_40) (= myTypeDecl_5_63_40 (asField myTypeDecl_5_63_40 T_javafe_ast_TypeDecl)) (< (fClosedTime myTypeDecl_5_63_40) alloc) (= init_pre_43_19_17 init_43_19_17) (= init_43_19_17 (asField init_43_19_17 T_javafe_ast_VarInit)) (< (fClosedTime init_43_19_17) alloc) (= NE_pre_23_24_26 NE_23_24_26) (= true_term (is NE_23_24_26 T_int)) (= EVALSTMT_pre_24_32_7 EVALSTMT_24_32_7) (= true_term (is EVALSTMT_24_32_7 T_int)) (= METHODINVOCATION_pre_24_59_7 METHODINVOCATION_24_59_7) (= true_term (is METHODINVOCATION_24_59_7 T_int)) (= UNARYSUB_pre_23_55_26 UNARYSUB_23_55_26) (= true_term (is UNARYSUB_23_55_26 T_int)) (= expr_pre_69_15_28 expr_69_15_28) (= expr_69_15_28 (asField expr_69_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_69_15_28) alloc) (forall (?s_20_ Int) (implies (not (= ?s_20_ null)) (not (= (S_select expr_69_15_28 ?s_20_) null)))) (= locDot_pre_60_41_13 locDot_60_41_13) (= locDot_60_41_13 (asField locDot_60_41_13 T_int)) (= od_pre_78_18_40 od_78_18_40) (= od_78_18_40 (asField od_78_18_40 T_javafe_ast_ObjectDesignator)) (< (fClosedTime od_78_18_40) alloc) (forall (?s_21_ Int) (implies (not (= ?s_21_ null)) (not (= (S_select od_78_18_40 ?s_21_) null)))) (= loc_pre_45_20_13 loc_45_20_13) (= loc_45_20_13 (asField loc_45_20_13 T_int)) (= elemType_pre_148_18_28 elemType_148_18_28) (= elemType_148_18_28 (asField elemType_148_18_28 T_javafe_ast_Type)) (< (fClosedTime elemType_148_18_28) alloc) (forall (?s_22_ Int) (implies (not (= ?s_22_ null)) (not (= (S_select elemType_148_18_28 ?s_22_) null)))) (= LAST_KEYWORD_pre_21_103_26 LAST_KEYWORD_21_103_26) (= true_term (is LAST_KEYWORD_21_103_26 T_int)) (= BITAND_pre_23_23_26 BITAND_23_23_26) (= true_term (is BITAND_23_23_26 T_int)) (= SYNCHRONIZESTMT_pre_24_31_7 SYNCHRONIZESTMT_24_31_7) (= true_term (is SYNCHRONIZESTMT_24_31_7 T_int)) (= locId_pre_76_24_13 locId_76_24_13) (= locId_76_24_13 (asField locId_76_24_13 T_int)) (= expr_pre_50_15_28 expr_50_15_28) (= expr_50_15_28 (asField expr_50_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_50_15_28) alloc) (forall (?s_23_ Int) (implies (not (= ?s_23_ null)) (not (= (S_select expr_50_15_28 ?s_23_) null)))) (= locDots_pre_150_31_29 locDots_150_31_29) (= locDots_150_31_29 (asField locDots_150_31_29 (array T_int))) (< (fClosedTime locDots_150_31_29) alloc) (forall (?s_24_ Int) (implies (not (= ?s_24_ null)) (not (= (S_select locDots_150_31_29 ?s_24_) null)))) (= AMBIGUOUSMETHODINVOCATION_pre_24_58_7 AMBIGUOUSMETHODINVOCATION_24_58_7) (= true_term (is AMBIGUOUSMETHODINVOCATION_24_58_7 T_int)) (= loc_pre_39_18_13 loc_39_18_13) (= loc_39_18_13 (asField loc_39_18_13 T_int)) (= decl_pre_42_15_36 decl_42_15_36) (= decl_42_15_36 (asField decl_42_15_36 T_javafe_ast_LocalVarDecl)) (< (fClosedTime decl_42_15_36) alloc) (forall (?s_25_ Int) (implies (not (= ?s_25_ null)) (not (= (S_select decl_42_15_36 ?s_25_) null)))) (= UNARYADD_pre_23_54_26 UNARYADD_23_54_26) (= true_term (is UNARYADD_23_54_26 T_int)) (= elements_pre_152_61_36 elements_152_61_36) (= elements_152_61_36 (asField elements_152_61_36 (array T_javafe_tc_TypeSig))) (< (fClosedTime elements_152_61_36) alloc) (forall (?s_26_ Int) (implies (not (= ?s_26_ null)) (not (= (S_select elements_152_61_36 ?s_26_) null)))) (= locOpenParen_pre_77_30_13 locOpenParen_77_30_13) (= locOpenParen_77_30_13 (asField locOpenParen_77_30_13 T_int)) (= otherCodes_pre_21_202_27 otherCodes_21_202_27) (= true_term (is otherCodes_21_202_27 (array T_int))) (= true_term (isAllocated otherCodes_21_202_27 alloc)) (= locOpenBrace_pre_14_51_13 locOpenBrace_14_51_13) (= locOpenBrace_14_51_13 (asField locOpenBrace_14_51_13 T_int)) (= type_pre_81_27_28 type_81_27_28) (= type_81_27_28 (asField type_81_27_28 T_javafe_ast_Type)) (< (fClosedTime type_81_27_28) alloc) (forall (?s_27_ Int) (implies (not (= ?s_27_ null)) (not (= (S_select type_81_27_28 ?s_27_) null)))) (= NULL_pre_21_82_26 NULL_21_82_26) (= true_term (is NULL_21_82_26 T_int)) (= BITXOR_pre_23_22_26 BITXOR_23_22_26) (= true_term (is BITXOR_23_22_26 T_int)) (= loc_pre_86_30_13 loc_86_30_13) (= loc_86_30_13 (asField loc_86_30_13 T_int)) (= DOSTMT_pre_24_30_7 DOSTMT_24_30_7) (= true_term (is DOSTMT_24_30_7 T_int)) (= locDot_pre_71_23_13 locDot_71_23_13) (= locDot_71_23_13 (asField locDot_71_23_13 T_int)) (= expr_pre_49_15_14 expr_49_15_14) (= expr_49_15_14 (asField expr_49_15_14 T_javafe_ast_Expr)) (< (fClosedTime expr_49_15_14) alloc) (= loc_pre_99_35_13 loc_99_35_13) (= loc_99_35_13 (asField loc_99_35_13 T_int)) (= FIELDACCESS_pre_24_57_7 FIELDACCESS_24_57_7) (= true_term (is FIELDACCESS_24_57_7 T_int)) (= decl_pre_75_26_38 decl_75_26_38) (= decl_75_26_38 (asField decl_75_26_38 T_javafe_ast_GenericVarDecl)) (< (fClosedTime decl_75_26_38) alloc) (forall (?s_28_ Int) (implies (not (= ?s_28_ null)) (not (= (S_select decl_75_26_38 ?s_28_) null)))) (= ASGBITXOR_pre_23_51_26 ASGBITXOR_23_51_26) (= true_term (is ASGBITXOR_23_51_26 T_int)) (= locCloseParen_pre_70_24_13 locCloseParen_70_24_13) (= locCloseParen_70_24_13 (asField locCloseParen_70_24_13 T_int)) (= BITOR_pre_23_21_26 BITOR_23_21_26) (= true_term (is BITOR_23_21_26 T_int)) (= WHILESTMT_pre_24_29_7 WHILESTMT_24_29_7) (= true_term (is WHILESTMT_24_29_7 T_int)) (= NULL_pre_97_60_26 NULL_97_60_26) (= true_term (is NULL_97_60_26 T_int)) (= elements_pre_133_61_39 elements_133_61_39) (= elements_133_61_39 (asField elements_133_61_39 (array T_javafe_ast_Identifier))) (< (fClosedTime elements_133_61_39) alloc) (forall (?s_29_ Int) (implies (not (= ?s_29_ null)) (not (= (S_select elements_133_61_39 ?s_29_) null)))) (= count_pre_16_67_33 count_16_67_33) (= count_16_67_33 (asField count_16_67_33 T_int)) (= type_pre_67_24_28 type_67_24_28) (= type_67_24_28 (asField type_67_24_28 T_javafe_ast_Type)) (< (fClosedTime type_67_24_28) alloc) (forall (?s_30_ Int) (implies (not (= ?s_30_ null)) (not (= (S_select type_67_24_28 ?s_30_) null)))) (= VARIABLEACCESS_pre_24_56_7 VARIABLEACCESS_24_56_7) (= true_term (is VARIABLEACCESS_24_56_7 T_int)) (= ASGBITOR_pre_23_50_26 ASGBITOR_23_50_26) (= true_term (is ASGBITOR_23_50_26 T_int)) (= id_pre_34_15_34 id_34_15_34) (= id_34_15_34 (asField id_34_15_34 T_javafe_ast_Identifier)) (< (fClosedTime id_34_15_34) alloc) (forall (?s_31_ Int) (implies (not (= ?s_31_ null)) (not (= (S_select id_34_15_34 ?s_31_) null)))) (= stmt_pre_45_17_28 stmt_45_17_28) (= stmt_45_17_28 (asField stmt_45_17_28 T_javafe_ast_Stmt)) (< (fClosedTime stmt_45_17_28) alloc) (forall (?s_32_ Int) (implies (not (= ?s_32_ null)) (not (= (S_select stmt_45_17_28 ?s_32_) null)))) (= CLASSDECLSTMT_pre_24_28_7 CLASSDECLSTMT_24_28_7) (= true_term (is CLASSDECLSTMT_24_28_7 T_int)) (= id_pre_76_21_34 id_76_21_34) (= id_76_21_34 (asField id_76_21_34 T_javafe_ast_Identifier)) (< (fClosedTime id_76_21_34) alloc) (forall (?s_33_ Int) (implies (not (= ?s_33_ null)) (not (= (S_select id_76_21_34 ?s_33_) null)))) (= AMBIGUOUSVARIABLEACCESS_pre_24_55_7 AMBIGUOUSVARIABLEACCESS_24_55_7) (= true_term (is AMBIGUOUSVARIABLEACCESS_24_55_7 T_int)) (= ASGBITAND_pre_23_49_26 ASGBITAND_23_49_26) (= true_term (is ASGBITAND_23_49_26 T_int)) (= expr_pre_39_15_28 expr_39_15_28) (= expr_39_15_28 (asField expr_39_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_39_15_28) alloc) (forall (?s_34_ Int) (implies (not (= ?s_34_ null)) (not (= (S_select expr_39_15_28 ?s_34_) null)))) (= loc_pre_57_23_13 loc_57_23_13) (= loc_57_23_13 (asField loc_57_23_13 T_int)) (= expr_pre_80_22_28 expr_80_22_28) (= expr_80_22_28 (asField expr_80_22_28 T_javafe_ast_Expr)) (< (fClosedTime expr_80_22_28) alloc) (forall (?s_35_ Int) (implies (not (= ?s_35_ null)) (not (= (S_select expr_80_22_28 ?s_35_) null)))) (= enclosingInstance_pre_60_37_14 enclosingInstance_60_37_14) (= enclosingInstance_60_37_14 (asField enclosingInstance_60_37_14 T_javafe_ast_Expr)) (< (fClosedTime enclosingInstance_60_37_14) alloc) (= VARDECLSTMT_pre_24_27_7 VARDECLSTMT_24_27_7) (= true_term (is VARDECLSTMT_24_27_7 T_int)) (= count_pre_41_67_33 count_41_67_33) (= count_41_67_33 (asField count_41_67_33 T_int)) (= locOpenBrackets_pre_67_65_29 locOpenBrackets_67_65_29) (= locOpenBrackets_67_65_29 (asField locOpenBrackets_67_65_29 (array T_int))) (< (fClosedTime locOpenBrackets_67_65_29) alloc) (forall (?s_36_ Int) (implies (not (= ?s_36_ null)) (not (= (S_select locOpenBrackets_67_65_29 ?s_36_) null)))) (= AND_pre_23_20_26 AND_23_20_26) (= true_term (is AND_23_20_26 T_int)) (= PARENEXPR_pre_24_54_7 PARENEXPR_24_54_7) (= true_term (is PARENEXPR_24_54_7 T_int)) (= ASGURSHIFT_pre_23_48_26 ASGURSHIFT_23_48_26) (= true_term (is ASGURSHIFT_23_48_26 T_int)) (= locId_pre_14_48_13 locId_14_48_13) (= locId_14_48_13 (asField locId_14_48_13 T_int)) (= NULLLIT_pre_22_45_26 NULLLIT_22_45_26) (= true_term (is NULLLIT_22_45_26 T_int)) (= tag_pre_99_30_13 tag_99_30_13) (= tag_99_30_13 (asField tag_99_30_13 T_int)) (= lenId_pre_26_914_30 lenId_26_914_30) (= true_term (is lenId_26_914_30 T_javafe_ast_Identifier)) (= true_term (isAllocated lenId_26_914_30 alloc)) (= loc_pre_46_20_13 loc_46_20_13) (= loc_46_20_13 (asField loc_46_20_13 T_int)) (= locOpenParen_pre_70_21_13 locOpenParen_70_21_13) (= locOpenParen_70_21_13 (asField locOpenParen_70_21_13 T_int)) (= expr_pre_45_15_28 expr_45_15_28) (= expr_45_15_28 (asField expr_45_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_45_15_28) alloc) (forall (?s_37_ Int) (implies (not (= ?s_37_ null)) (not (= (S_select expr_45_15_28 ?s_37_) null)))) (= locFirstSemi_pre_53_36_13 locFirstSemi_53_36_13) (= locFirstSemi_53_36_13 (asField locFirstSemi_53_36_13 T_int)) (= locOpenParen_pre_66_52_13 locOpenParen_66_52_13) (= locOpenParen_66_52_13 (asField locOpenParen_66_52_13 T_int)) (= SWITCHSTMT_pre_24_26_7 SWITCHSTMT_24_26_7) (= true_term (is SWITCHSTMT_24_26_7 T_int)) (= od_pre_76_19_40 od_76_19_40) (= od_76_19_40 (asField od_76_19_40 T_javafe_ast_ObjectDesignator)) (< (fClosedTime od_76_19_40) alloc) (forall (?s_38_ Int) (implies (not (= ?s_38_ null)) (not (= (S_select od_76_19_40 ?s_38_) null)))) (= OR_pre_23_19_26 OR_23_19_26) (= true_term (is OR_23_19_26 T_int)) (= CASTEXPR_pre_24_53_7 CASTEXPR_24_53_7) (= true_term (is CASTEXPR_24_53_7 T_int)) (= ASGRSHIFT_pre_23_47_26 ASGRSHIFT_23_47_26) (= true_term (is ASGRSHIFT_23_47_26 T_int)) (= elements_pre_95_61_39 elements_95_61_39) (= elements_95_61_39 (asField elements_95_61_39 (array T_javafe_ast_MethodDecl))) (< (fClosedTime elements_95_61_39) alloc) (forall (?s_39_ Int) (implies (not (= ?s_39_ null)) (not (= (S_select elements_95_61_39 ?s_39_) null)))) (= STRINGLIT_pre_22_44_26 STRINGLIT_22_44_26) (= true_term (is STRINGLIT_22_44_26 T_int)) (= type_pre_71_20_28 type_71_20_28) (= type_71_20_28 (asField type_71_20_28 T_javafe_ast_Type)) (< (fClosedTime type_71_20_28) alloc) (forall (?s_40_ Int) (implies (not (= ?s_40_ null)) (not (= (S_select type_71_20_28 ?s_40_) null)))) (= loc_pre_75_22_13 loc_75_22_13) (= loc_75_22_13 (asField loc_75_22_13 T_int)) (= BLOCKSTMT_pre_24_25_7 BLOCKSTMT_24_25_7) (= true_term (is BLOCKSTMT_24_25_7 T_int)) (= elements_pre_64_61_36 elements_64_61_36) (= elements_64_61_36 (asField elements_64_61_36 (array T_javafe_ast_VarInit))) (< (fClosedTime elements_64_61_36) alloc) (forall (?s_41_ Int) (implies (not (= ?s_41_ null)) (not (= (S_select elements_64_61_36 ?s_41_) null)))) (= INSTANCEOFEXPR_pre_24_52_7 INSTANCEOFEXPR_24_52_7) (= true_term (is INSTANCEOFEXPR_24_52_7 T_int)) (= ASGLSHIFT_pre_23_46_26 ASGLSHIFT_23_46_26) (= true_term (is ASGLSHIFT_23_46_26 T_int)) (= DOUBLELIT_pre_22_43_26 DOUBLELIT_22_43_26) (= true_term (is DOUBLELIT_22_43_26 T_int)) (= locId_pre_29_38_13 locId_29_38_13) (= locId_29_38_13 (asField locId_29_38_13 T_int)) (= locColon_pre_68_25_13 locColon_68_25_13) (= locColon_68_25_13 (asField locColon_68_25_13 T_int)) (= FORMALPARADECL_pre_24_24_7 FORMALPARADECL_24_24_7) (= true_term (is FORMALPARADECL_24_24_7 T_int)) (= CONDEXPR_pre_24_51_7 CONDEXPR_24_51_7) (= true_term (is CONDEXPR_24_51_7 T_int)) (= ASGSUB_pre_23_45_26 ASGSUB_23_45_26) (= true_term (is ASGSUB_23_45_26 T_int)) (= otherStrings_pre_21_193_30 otherStrings_21_193_30) (= true_term (is otherStrings_21_193_30 (array T_java_lang_String))) (= true_term (isAllocated otherStrings_21_193_30 alloc)) (= FLOATLIT_pre_22_42_26 FLOATLIT_22_42_26) (= true_term (is FLOATLIT_22_42_26 T_int)) (= TYPEMODIFIERPRAGMA_pre_21_28_26 TYPEMODIFIERPRAGMA_21_28_26) (= true_term (is TYPEMODIFIERPRAGMA_21_28_26 T_int)) (= stmt_pre_46_17_28 stmt_46_17_28) (= stmt_46_17_28 (asField stmt_46_17_28 T_javafe_ast_Stmt)) (< (fClosedTime stmt_46_17_28) alloc) (forall (?s_42_ Int) (implies (not (= ?s_42_ null)) (not (= (S_select stmt_46_17_28 ?s_42_) null)))) (= elements_pre_54_61_33 elements_54_61_33) (= elements_54_61_33 (asField elements_54_61_33 (array T_javafe_ast_Expr))) (< (fClosedTime elements_54_61_33) alloc) (forall (?s_43_ Int) (implies (not (= ?s_43_ null)) (not (= (S_select elements_54_61_33 ?s_43_) null)))) (= loc_pre_14_45_13 loc_14_45_13) (= loc_14_45_13 (asField loc_14_45_13 T_int)) (= locCloseBrace_pre_63_24_13 locCloseBrace_63_24_13) (= locCloseBrace_63_24_13 (asField locCloseBrace_63_24_13 T_int)) (= type_pre_70_18_28 type_70_18_28) (= type_70_18_28 (asField type_70_18_28 T_javafe_ast_Type)) (< (fClosedTime type_70_18_28) alloc) (forall (?s_44_ Int) (implies (not (= ?s_44_ null)) (not (= (S_select type_70_18_28 ?s_44_) null)))) (= FIELDDECL_pre_24_23_7 FIELDDECL_24_23_7) (= true_term (is FIELDDECL_24_23_7 T_int)) (= loc_pre_66_49_13 loc_66_49_13) (= loc_66_49_13 (asField loc_66_49_13 T_int)) (= elements_pre_58_61_40 elements_58_61_40) (= elements_58_61_40 (asField elements_58_61_40 (array T_javafe_ast_CatchClause))) (< (fClosedTime elements_58_61_40) alloc) (forall (?s_45_ Int) (implies (not (= ?s_45_ null)) (not (= (S_select elements_58_61_40 ?s_45_) null)))) (= length_pre_125_50_25 length_125_50_25) (= length_125_50_25 (asField length_125_50_25 T_int)) (= locFinally_pre_56_25_13 locFinally_56_25_13) (= locFinally_56_25_13 (asField locFinally_56_25_13 T_int)) (= tag_pre_98_32_13 tag_98_32_13) (= tag_98_32_13 (asField tag_98_32_13 T_int)) (= loc_pre_53_33_13 loc_53_33_13) (= loc_53_33_13 (asField loc_53_33_13 T_int)) (= ASGADD_pre_23_44_26 ASGADD_23_44_26) (= true_term (is ASGADD_23_44_26 T_int)) (= NEWARRAYEXPR_pre_24_50_7 NEWARRAYEXPR_24_50_7) (= true_term (is NEWARRAYEXPR_24_50_7 T_int)) (= locId_pre_31_43_13 locId_31_43_13) (= locId_31_43_13 (asField locId_31_43_13 T_int)) (= CHARLIT_pre_22_41_26 CHARLIT_22_41_26) (= true_term (is CHARLIT_22_41_26 T_int)) (= id_pre_75_19_34 id_75_19_34) (= id_75_19_34 (asField id_75_19_34 T_javafe_ast_Identifier)) (< (fClosedTime id_75_19_34) alloc) (forall (?s_46_ Int) (implies (not (= ?s_46_ null)) (not (= (S_select id_75_19_34 ?s_46_) null)))) (= catchClauses_pre_57_20_38 catchClauses_57_20_38) (= catchClauses_57_20_38 (asField catchClauses_57_20_38 T_javafe_ast_CatchClauseVec)) (< (fClosedTime catchClauses_57_20_38) alloc) (forall (?s_47_ Int) (implies (not (= ?s_47_ null)) (not (= (S_select catchClauses_57_20_38 ?s_47_) null)))) (= TYPEDECLELEMPRAGMA_pre_21_27_26 TYPEDECLELEMPRAGMA_21_27_26) (= true_term (is TYPEDECLELEMPRAGMA_21_27_26 T_int)) (= LOCALVARDECL_pre_24_22_7 LOCALVARDECL_24_22_7) (= true_term (is LOCALVARDECL_24_22_7 T_int)) (= elements_pre_27_61_41 elements_27_61_41) (= elements_27_61_41 (asField elements_27_61_41 (array T_javafe_ast_TypeDeclElem))) (< (fClosedTime elements_27_61_41) alloc) (forall (?s_48_ Int) (implies (not (= ?s_48_ null)) (not (= (S_select elements_27_61_41 ?s_48_) null)))) (= decl_pre_44_15_33 decl_44_15_33) (= decl_44_15_33 (asField decl_44_15_33 T_javafe_ast_ClassDecl)) (< (fClosedTime decl_44_15_33) alloc) (forall (?s_49_ Int) (implies (not (= ?s_49_ null)) (not (= (S_select decl_44_15_33 ?s_49_) null)))) (= elements_pre_32_61_43 elements_32_61_43) (= elements_32_61_43 (asField elements_32_61_43 (array T_javafe_ast_FormalParaDecl))) (< (fClosedTime elements_32_61_43) alloc) (forall (?s_50_ Int) (implies (not (= ?s_50_ null)) (not (= (S_select elements_32_61_43 ?s_50_) null)))) (= loc_pre_98_50_13 loc_98_50_13) (= loc_98_50_13 (asField loc_98_50_13 T_int)) (= ASGREM_pre_23_43_26 ASGREM_23_43_26) (= true_term (is ASGREM_23_43_26 T_int)) (= NEWINSTANCEEXPR_pre_24_49_7 NEWINSTANCEEXPR_24_49_7) (= true_term (is NEWINSTANCEEXPR_24_49_7 T_int)) (= LONGLIT_pre_22_40_26 LONGLIT_22_40_26) (= true_term (is LONGLIT_22_40_26 T_int)) (= enclosingEnv_pre_5_52_36 enclosingEnv_5_52_36) (= enclosingEnv_5_52_36 (asField enclosingEnv_5_52_36 T_javafe_tc_Env)) (< (fClosedTime enclosingEnv_5_52_36) alloc) (= expr_pre_48_15_28 expr_48_15_28) (= expr_48_15_28 (asField expr_48_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_48_15_28) alloc) (forall (?s_51_ Int) (implies (not (= ?s_51_ null)) (not (= (S_select expr_48_15_28 ?s_51_) null)))) (= expr_pre_46_15_28 expr_46_15_28) (= expr_46_15_28 (asField expr_46_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_46_15_28) alloc) (forall (?s_52_ Int) (implies (not (= ?s_52_ null)) (not (= (S_select expr_46_15_28 ?s_52_) null)))) (= type_pre_29_35_28 type_29_35_28) (= type_29_35_28 (asField type_29_35_28 T_javafe_ast_Type)) (< (fClosedTime type_29_35_28) alloc) (forall (?s_53_ Int) (implies (not (= ?s_53_ null)) (not (= (S_select type_29_35_28 ?s_53_) null)))) (= loc_pre_141_18_13 loc_141_18_13) (= loc_141_18_13 (asField loc_141_18_13 T_int)) (= INITBLOCK_pre_24_21_7 INITBLOCK_24_21_7) (= true_term (is INITBLOCK_24_21_7 T_int)) (= locOp_pre_73_32_13 locOp_73_32_13) (= locOp_73_32_13 (asField locOp_73_32_13 T_int)) (= locQuestion_pre_68_22_13 locQuestion_68_22_13) (= locQuestion_68_22_13 (asField locQuestion_68_22_13 T_int)) (= STMTPRAGMA_pre_21_26_26 STMTPRAGMA_21_26_26) (= true_term (is STMTPRAGMA_21_26_26 T_int)) (= ASGDIV_pre_23_42_26 ASGDIV_23_42_26) (= true_term (is ASGDIV_23_42_26 T_int)) (= ARRAYREFEXPR_pre_24_48_7 ARRAYREFEXPR_24_48_7) (= true_term (is ARRAYREFEXPR_24_48_7 T_int)) (= INTLIT_pre_22_39_26 INTLIT_22_39_26) (= true_term (is INTLIT_22_39_26 T_int)) (= elems_pre_14_41_39 elems_14_41_39) (= elems_14_41_39 (asField elems_14_41_39 T_javafe_ast_TypeDeclElemVec)) (< (fClosedTime elems_14_41_39) alloc) (forall (?s_54_ Int) (implies (not (= ?s_54_ null)) (not (= (S_select elems_14_41_39 ?s_54_) null)))) (= locOpenBrace_pre_63_21_13 locOpenBrace_63_21_13) (= locOpenBrace_63_21_13 (asField locOpenBrace_63_21_13 T_int)) (= METHODDECL_pre_24_20_7 METHODDECL_24_20_7) (= true_term (is METHODDECL_24_20_7 T_int)) (= owner_pre_4_35_28 owner_4_35_28) (= owner_4_35_28 (asField owner_4_35_28 T_java_lang_Object)) (< (fClosedTime owner_4_35_28) alloc) (= anonDecl_pre_66_45_19 anonDecl_66_45_19) (= anonDecl_66_45_19 (asField anonDecl_66_45_19 T_javafe_ast_ClassDecl)) (< (fClosedTime anonDecl_66_45_19) alloc) (= tryClause_pre_57_18_28 tryClause_57_18_28) (= tryClause_57_18_28 (asField tryClause_57_18_28 T_javafe_ast_Stmt)) (< (fClosedTime tryClause_57_18_28) alloc) (forall (?s_55_ Int) (implies (not (= ?s_55_ null)) (not (= (S_select tryClause_57_18_28 ?s_55_) null)))) (= body_pre_53_30_28 body_53_30_28) (= body_53_30_28 (asField body_53_30_28 T_javafe_ast_Stmt)) (< (fClosedTime body_53_30_28) alloc) (forall (?s_56_ Int) (implies (not (= ?s_56_ null)) (not (= (S_select body_53_30_28 ?s_56_) null)))) (= superCall_pre_60_24_17 superCall_60_24_17) (= superCall_60_24_17 (asField superCall_60_24_17 T_boolean)) (= ASGMUL_pre_23_41_26 ASGMUL_23_41_26) (= true_term (is ASGMUL_23_41_26 T_int)) (= THISEXPR_pre_24_47_7 THISEXPR_24_47_7) (= true_term (is THISEXPR_24_47_7 T_int)) (= MODIFIERPRAGMA_pre_21_25_26 MODIFIERPRAGMA_21_25_26) (= true_term (is MODIFIERPRAGMA_21_25_26 T_int)) (= BOOLEANLIT_pre_22_38_26 BOOLEANLIT_22_38_26) (= true_term (is BOOLEANLIT_22_38_26 T_int)) (= loc_pre_31_40_13 loc_31_40_13) (= loc_31_40_13 (asField loc_31_40_13 T_int)) (= locIds_pre_150_25_29 locIds_150_25_29) (= locIds_150_25_29 (asField locIds_150_25_29 (array T_int))) (< (fClosedTime locIds_150_25_29) alloc) (forall (?s_57_ Int) (implies (not (= ?s_57_ null)) (not (= (S_select locIds_150_25_29 ?s_57_) null)))) (= expr_pre_70_15_28 expr_70_15_28) (= expr_70_15_28 (asField expr_70_15_28 T_javafe_ast_Expr)) (< (fClosedTime expr_70_15_28) alloc) (forall (?s_58_ Int) (implies (not (= ?s_58_ null)) (not (= (S_select expr_70_15_28 ?s_58_) null)))) (= count_pre_94_67_33 count_94_67_33) (= count_94_67_33 (asField count_94_67_33 T_int)) (= loc_pre_56_22_13 loc_56_22_13) (= loc_56_22_13 (asField loc_56_22_13 T_int)) (= locCloseParen_pre_74_21_13 locCloseParen_74_21_13) (= locCloseParen_74_21_13 (asField locCloseParen_74_21_13 T_int)) (= CONSTRUCTORDECL_pre_24_19_7 CONSTRUCTORDECL_24_19_7) (= true_term (is CONSTRUCTORDECL_24_19_7 T_int)) (= loc_pre_147_16_13 loc_147_16_13) (= loc_147_16_13 (asField loc_147_16_13 T_int)) (= locOp_pre_72_43_13 locOp_72_43_13) (= locOp_72_43_13 (asField locOp_72_43_13 T_int)) (= ASSIGN_pre_23_40_26 ASSIGN_23_40_26) (= true_term (is ASSIGN_23_40_26 T_int)) (= value_pre_98_45_16 value_98_45_16) (= value_98_45_16 (asField value_98_45_16 T_java_lang_Object)) (< (fClosedTime value_98_45_16) alloc) (= ARRAYINIT_pre_24_46_7 ARRAYINIT_24_46_7) (= true_term (is ARRAYINIT_24_46_7 T_int)) (= SHORTTYPE_pre_22_36_26 SHORTTYPE_22_36_26) (= true_term (is SHORTTYPE_22_36_26 T_int)) (= TYPESIG_pre_20_6_28 TYPESIG_20_6_28) (= true_term (is TYPESIG_20_6_28 T_int)) (= FIRST_KEYWORD_pre_21_51_26 FIRST_KEYWORD_21_51_26) (= true_term (is FIRST_KEYWORD_21_51_26 T_int)) (= decl_pre_78_34_20 decl_78_34_20) (= decl_78_34_20 (asField decl_78_34_20 T_javafe_ast_MethodDecl)) (< (fClosedTime decl_78_34_20) alloc) (= INTERFACEDECL_pre_24_18_7 INTERFACEDECL_24_18_7) (= true_term (is INTERFACEDECL_24_18_7 T_int)) (= expr_pre_73_29_28 expr_73_29_28) (= expr_73_29_28 (asField expr_73_29_28 T_javafe_ast_Expr)) (< (fClosedTime expr_73_29_28) alloc) (forall (?s_59_ Int) (implies (not (= ?s_59_ null)) (not (= (S_select expr_73_29_28 ?s_59_) null)))) (= LEXICALPRAGMA_pre_21_24_26 LEXICALPRAGMA_21_24_26) (= true_term (is LEXICALPRAGMA_21_24_26 T_int)) (= els_pre_68_19_28 els_68_19_28) (= els_68_19_28 (asField els_68_19_28 T_javafe_ast_Expr)) (< (fClosedTime els_68_19_28) alloc) (forall (?s_60_ Int) (implies (not (= ?s_60_ null)) (not (= (S_select els_68_19_28 ?s_60_) null)))) (= forUpdate_pre_53_28_31 forUpdate_53_28_31) (= forUpdate_53_28_31 (asField forUpdate_53_28_31 T_javafe_ast_ExprVec)) (< (fClosedTime forUpdate_53_28_31) alloc) (forall (?s_61_ Int) (implies (not (= ?s_61_ null)) (not (= (S_select forUpdate_53_28_31 ?s_61_) null)))) (= STAR_pre_23_37_26 STAR_23_37_26) (= true_term (is STAR_23_37_26 T_int)) (= CATCHCLAUSE_pre_24_45_7 CATCHCLAUSE_24_45_7) (= true_term (is CATCHCLAUSE_24_45_7 T_int)) (= BYTETYPE_pre_22_35_26 BYTETYPE_22_35_26) (= true_term (is BYTETYPE_22_35_26 T_int)) (= member_pre_5_44_39 member_5_44_39) (= member_5_44_39 (asField member_5_44_39 T_boolean)) (= args_pre_66_34_31 args_66_34_31) (= args_66_34_31 (asField args_66_34_31 T_javafe_ast_ExprVec)) (< (fClosedTime args_66_34_31) alloc) (forall (?s_62_ Int) (implies (not (= ?s_62_ null)) (not (= (S_select args_66_34_31 ?s_62_) null)))) (= id_pre_29_32_34 id_29_32_34) (= id_29_32_34 (asField id_29_32_34 T_javafe_ast_Identifier)) (< (fClosedTime id_29_32_34) alloc) (forall (?s_63_ Int) (implies (not (= ?s_63_ null)) (not (= (S_select id_29_32_34 ?s_63_) null)))) (= locCloseBrace_pre_36_25_13 locCloseBrace_36_25_13) (= locCloseBrace_36_25_13 (asField locCloseBrace_36_25_13 T_int)) (= elements_pre_16_61_37 elements_16_61_37) (= elements_16_61_37 (asField elements_16_61_37 (array T_javafe_ast_TypeName))) (< (fClosedTime elements_16_61_37) alloc) (forall (?s_64_ Int) (implies (not (= ?s_64_ null)) (not (= (S_select elements_16_61_37 ?s_64_) null)))) (= elems_pre_63_18_34 elems_63_18_34) (= elems_63_18_34 (asField elems_63_18_34 T_javafe_ast_VarInitVec)) (< (fClosedTime elems_63_18_34) alloc) (forall (?s_65_ Int) (implies (not (= ?s_65_ null)) (not (= (S_select elems_63_18_34 ?s_65_) null)))) (= superInterfaces_pre_14_34_35 superInterfaces_14_34_35) (= superInterfaces_14_34_35 (asField superInterfaces_14_34_35 T_javafe_ast_TypeNameVec)) (< (fClosedTime superInterfaces_14_34_35) alloc) (forall (?s_66_ Int) (implies (not (= ?s_66_ null)) (not (= (S_select superInterfaces_14_34_35 ?s_66_) null)))) (= CLASSDECL_pre_24_17_7 CLASSDECL_24_17_7) (= true_term (is CLASSDECL_24_17_7 T_int)) (= state_pre_5_787_15 state_5_787_15) (= state_5_787_15 (asField state_5_787_15 T_int)) (= MOD_pre_23_36_26 MOD_23_36_26) (= true_term (is MOD_23_36_26 T_int)) (= CONSTRUCTORINVOCATION_pre_24_44_7 CONSTRUCTORINVOCATION_24_44_7) (= true_term (is CONSTRUCTORINVOCATION_24_44_7 T_int)) (= NULLTYPE_pre_22_34_26 NULLTYPE_22_34_26) (= true_term (is NULLTYPE_22_34_26 T_int)) (= locCloseBracket_pre_65_23_13 locCloseBracket_65_23_13) (= locCloseBracket_65_23_13 (asField locCloseBracket_65_23_13 T_int)) (= loc_pre_55_29_13 loc_55_29_13) (= loc_55_29_13 (asField loc_55_29_13 T_int)) (= finallyClause_pre_56_19_28 finallyClause_56_19_28) (= finallyClause_56_19_28 (asField finallyClause_56_19_28 T_javafe_ast_Stmt)) (< (fClosedTime finallyClause_56_19_28) alloc) (forall (?s_67_ Int) (implies (not (= ?s_67_ null)) (not (= (S_select finallyClause_56_19_28 ?s_67_) null)))) (= ONDEMANDIMPORTDECL_pre_24_16_7 ONDEMANDIMPORTDECL_24_16_7) (= true_term (is ONDEMANDIMPORTDECL_24_16_7 T_int)) (= op_pre_73_26_13 op_73_26_13) (= op_73_26_13 (asField op_73_26_13 T_int)) (= thn_pre_68_17_28 thn_68_17_28) (= thn_68_17_28 (asField thn_68_17_28 T_javafe_ast_Expr)) (< (fClosedTime thn_68_17_28) alloc) (forall (?s_68_ Int) (implies (not (= ?s_68_ null)) (not (= (S_select thn_68_17_28 ?s_68_) null)))) (= loc_pre_52_22_13 loc_52_22_13) (= loc_52_22_13 (asField loc_52_22_13 T_int)) (= DIV_pre_23_35_26 DIV_23_35_26) (= true_term (is DIV_23_35_26 T_int)) (= right_pre_72_40_28 right_72_40_28) (= right_72_40_28 (asField right_72_40_28 T_javafe_ast_Expr)) (< (fClosedTime right_72_40_28) alloc) (forall (?s_69_ Int) (implies (not (= ?s_69_ null)) (not (= (S_select right_72_40_28 ?s_69_) null)))) (= TRYCATCHSTMT_pre_24_43_7 TRYCATCHSTMT_24_43_7) (= true_term (is TRYCATCHSTMT_24_43_7 T_int)) (= test_pre_53_26_28 test_53_26_28) (= test_53_26_28 (asField test_53_26_28 T_javafe_ast_Expr)) (< (fClosedTime test_53_26_28) alloc) (forall (?s_70_ Int) (implies (not (= ?s_70_ null)) (not (= (S_select test_53_26_28 ?s_70_) null)))) (= VOIDTYPE_pre_22_33_26 VOIDTYPE_22_33_26) (= true_term (is VOIDTYPE_22_33_26 T_int)) (= elements_pre_41_61_33 elements_41_61_33) (= elements_41_61_33 (asField elements_41_61_33 (array T_javafe_ast_Stmt))) (< (fClosedTime elements_41_61_33) alloc) (forall (?s_71_ Int) (implies (not (= ?s_71_ null)) (not (= (S_select elements_41_61_33 ?s_71_) null)))) (= type_pre_66_32_32 type_66_32_32) (= type_66_32_32 (asField type_66_32_32 T_javafe_ast_TypeName)) (< (fClosedTime type_66_32_32) alloc) (forall (?s_72_ Int) (implies (not (= ?s_72_ null)) (not (= (S_select type_66_32_32 ?s_72_) null)))) (= loc_pre_67_49_13 loc_67_49_13) (= loc_67_49_13 (asField loc_67_49_13 T_int)) (= SINGLETYPEIMPORTDECL_pre_24_15_7 SINGLETYPEIMPORTDECL_24_15_7) (= true_term (is SINGLETYPEIMPORTDECL_24_15_7 T_int)) (= locOpenParen_pre_47_23_13 locOpenParen_47_23_13) (= locOpenParen_47_23_13 (asField locOpenParen_47_23_13 T_int)) (= count_pre_152_67_33 count_152_67_33) (= count_152_67_33 (asField count_152_67_33 T_int)) (= SUB_pre_23_34_26 SUB_23_34_26) (= true_term (is SUB_23_34_26 T_int)) (= TRYFINALLYSTMT_pre_24_42_7 TRYFINALLYSTMT_24_42_7) (= true_term (is TRYFINALLYSTMT_24_42_7 T_int)) (= args_pre_78_30_31 args_78_30_31) (= args_78_30_31 (asField args_78_30_31 T_javafe_ast_ExprVec)) (< (fClosedTime args_78_30_31) alloc) (forall (?s_73_ Int) (implies (not (= ?s_73_ null)) (not (= (S_select args_78_30_31 ?s_73_) null)))) (= locDot_pre_79_21_13 locDot_79_21_13) (= locDot_79_21_13 (asField locDot_79_21_13 T_int)) (= locOpenParen_pre_74_18_13 locOpenParen_74_18_13) (= locOpenParen_74_18_13 (asField locOpenParen_74_18_13 T_int)) (= DOUBLETYPE_pre_22_32_26 DOUBLETYPE_22_32_26) (= true_term (is DOUBLETYPE_22_32_26 T_int)) (= block_pre_38_28_33 block_38_28_33) (= block_38_28_33 (asField block_38_28_33 T_javafe_ast_BlockStmt)) (< (fClosedTime block_38_28_33) alloc) (forall (?s_74_ Int) (implies (not (= ?s_74_ null)) (not (= (S_select block_38_28_33 ?s_74_) null)))) (= tryClause_pre_56_17_28 tryClause_56_17_28) (= tryClause_56_17_28 (asField tryClause_56_17_28 T_javafe_ast_Stmt)) (< (fClosedTime tryClause_56_17_28) alloc) (forall (?s_75_ Int) (implies (not (= ?s_75_ null)) (not (= (S_select tryClause_56_17_28 ?s_75_) null)))) (= locOpenBrace_pre_36_22_13 locOpenBrace_36_22_13) (= locOpenBrace_36_22_13 (asField locOpenBrace_36_22_13 T_int)) (= COMPILATIONUNIT_pre_24_14_7 COMPILATIONUNIT_24_14_7) (= true_term (is COMPILATIONUNIT_24_14_7 T_int)) (= simpleName_pre_5_37_38 simpleName_5_37_38) (= simpleName_5_37_38 (asField simpleName_5_37_38 T_java_lang_String)) (< (fClosedTime simpleName_5_37_38) alloc) (= test_pre_68_15_28 test_68_15_28) (= test_68_15_28 (asField test_68_15_28 T_javafe_ast_Expr)) (< (fClosedTime test_68_15_28) alloc) (forall (?s_76_ Int) (implies (not (= ?s_76_ null)) (not (= (S_select test_68_15_28 ?s_76_) null)))) (= CHECKED_pre_5_776_28 CHECKED_5_776_28) (= true_term (is CHECKED_5_776_28 T_int)) (= left_pre_72_38_28 left_72_38_28) (= left_72_38_28 (asField left_72_38_28 T_javafe_ast_Expr)) (< (fClosedTime left_72_38_28) alloc) (forall (?s_77_ Int) (implies (not (= ?s_77_ null)) (not (= (S_select left_72_38_28 ?s_77_) null)))) (= ADD_pre_23_33_26 ADD_23_33_26) (= true_term (is ADD_23_33_26 T_int)) (= SWITCHLABEL_pre_24_41_7 SWITCHLABEL_24_41_7) (= true_term (is SWITCHLABEL_24_41_7 T_int)) (= forInit_pre_53_24_31 forInit_53_24_31) (= forInit_53_24_31 (asField forInit_53_24_31 T_javafe_ast_StmtVec)) (< (fClosedTime forInit_53_24_31) alloc) (forall (?s_78_ Int) (implies (not (= ?s_78_ null)) (not (= (S_select forInit_53_24_31 ?s_78_) null)))) (= FLOATTYPE_pre_22_31_26 FLOATTYPE_22_31_26) (= true_term (is FLOATTYPE_22_31_26 T_int)) (= loc_pre_59_22_13 loc_59_22_13) (= loc_59_22_13 (asField loc_59_22_13 T_int)) (= locDot_pre_66_29_13 locDot_66_29_13) (= locDot_66_29_13 (asField locDot_66_29_13 T_int)) (= locOpenBrace_pre_31_36_13 locOpenBrace_31_36_13) (= locOpenBrace_31_36_13 (asField locOpenBrace_31_36_13 T_int)) (= PREPPED_pre_5_775_28 PREPPED_5_775_28) (= true_term (is PREPPED_5_775_28 T_int)) (= expr_pre_55_26_14 expr_55_26_14) (= expr_55_26_14 (asField expr_55_26_14 T_javafe_ast_Expr)) (< (fClosedTime expr_55_26_14) alloc) (= tokenType_pre_96_90_8 tokenType_96_90_8) (= tokenType_96_90_8 (asField tokenType_96_90_8 T_int)) (= count_pre_133_67_33 count_133_67_33) (= count_133_67_33 (asField count_133_67_33 T_int)) (= decl_pre_60_54_25 decl_60_54_25) (= decl_60_54_25 (asField decl_60_54_25 T_javafe_ast_ConstructorDecl)) (< (fClosedTime decl_60_54_25) alloc) (= body_pre_31_34_19 body_31_34_19) (= body_31_34_19 (asField body_31_34_19 T_javafe_ast_BlockStmt)) (< (fClosedTime body_31_34_19) alloc) (= els_pre_52_19_28 els_52_19_28) (= els_52_19_28 (asField els_52_19_28 T_javafe_ast_Stmt)) (< (fClosedTime els_52_19_28) alloc) (forall (?s_79_ Int) (implies (not (= ?s_79_ null)) (not (= (S_select els_52_19_28 ?s_79_) null)))) (= URSHIFT_pre_23_32_26 URSHIFT_23_32_26) (= true_term (is URSHIFT_23_32_26 T_int)) (= SKIPSTMT_pre_24_40_7 SKIPSTMT_24_40_7) (= true_term (is SKIPSTMT_24_40_7 T_int)) (= locOpenParen_pre_78_28_13 locOpenParen_78_28_13) (= locOpenParen_78_28_13 (asField locOpenParen_78_28_13 T_int)) (= LINKSRESOLVED_pre_5_774_28 LINKSRESOLVED_5_774_28) (= true_term (is LINKSRESOLVED_5_774_28 T_int)) (= CHARTYPE_pre_22_30_26 CHARTYPE_22_30_26) (= true_term (is CHARTYPE_22_30_26 T_int)) (= locOpenBracket_pre_65_20_13 locOpenBracket_65_20_13) (= locOpenBracket_65_20_13 (asField locOpenBracket_65_20_13 T_int)) (= enclosingType_pre_5_32_39 enclosingType_5_32_39) (= enclosingType_5_32_39 (asField enclosingType_5_32_39 T_javafe_tc_TypeSig)) (< (fClosedTime enclosingType_5_32_39) alloc) (= args_pre_60_51_31 args_60_51_31) (= args_60_51_31 (asField args_60_51_31 T_javafe_ast_ExprVec)) (< (fClosedTime args_60_51_31) alloc) (forall (?s_80_ Int) (implies (not (= ?s_80_ null)) (not (= (S_select args_60_51_31 ?s_80_) null)))) (= COMPOUNDNAME_pre_24_67_7 COMPOUNDNAME_24_67_7) (= true_term (is COMPOUNDNAME_24_67_7 T_int)) (= elems_pre elems) (= elems (asElems elems)) (< (eClosedTime elems) alloc) (= LS (asLockSet LS)) (= alloc_pre alloc)) (not (and (= true_term (is sig_263_39 T_javafe_tc_TypeSig)) (= true_term (isAllocated sig_263_39 alloc)) (= true_term (is expr_263_52 T_javafe_ast_VarInit)) (= true_term (isAllocated expr_263_52 alloc)) (not (= sig_263_39 null)) (not (= expr_263_52 null)) (forall (?brokenObj Int) (implies (and (= true_term (is ?brokenObj T_javafe_ast_MethodInvocation)) (not (= ?brokenObj null))) (not (= (S_select locOpenParen_78_28_13 ?brokenObj) NULL_97_60_26)))) (forall (?brokenObj_1_ Int) (implies (and (= true_term (is ?brokenObj_1_ T_javafe_ast_ArrayType)) (not (= ?brokenObj_1_ null))) (not (= (S_select locOpenBracket_148_21_13 ?brokenObj_1_) NULL_97_60_26)))) (forall (?brokenObj_2_ Int) (implies (and (= true_term (is ?brokenObj_2_ T_javafe_ast_ExprVec)) (not (= ?brokenObj_2_ null))) (<= 0 (S_select count_54_67_33 ?brokenObj_2_)))) (forall (?brokenObj_3_ Int) (implies (and (= true_term (is ?brokenObj_3_ T_javafe_ast_PrimitiveType)) (not (= ?brokenObj_3_ null)) (= true_term (S_select syntax_6_28_29 ?brokenObj_3_))) (not (= (S_select loc_99_35_13 ?brokenObj_3_) NULL_97_60_26)))) (forall (?brokenObj_4_ Int) (implies (and (= true_term (is ?brokenObj_4_ T_javafe_ast_SuperObjectDesignator)) (not (= ?brokenObj_4_ null))) (not (= (S_select locSuper_82_20_13 ?brokenObj_4_) NULL_97_60_26)))) (forall (?brokenObj_5_ Int) (implies (and (= true_term (is ?brokenObj_5_ T_javafe_ast_MethodDecl)) (not (= ?brokenObj_5_ null))) (= true_term (S_select syntax_6_28_29 (S_select returnType_34_18_28 ?brokenObj_5_))))) (forall (?brokenObj_6_ Int) (implies (and (= true_term (is ?brokenObj_6_ T_javafe_ast_ParenExpr)) (not (= ?brokenObj_6_ null))) (not (= (S_select locOpenParen_74_18_13 ?brokenObj_6_) NULL_97_60_26)))) (forall (?brokenObj_7_ Int) (implies (and (= true_term (is ?brokenObj_7_ T_javafe_ast_ArrayRefExpr)) (not (= ?brokenObj_7_ null))) (not (= (S_select locOpenBracket_65_20_13 ?brokenObj_7_) NULL_97_60_26)))) (forall (?brokenObj_8_ Int) (implies (and (= true_term (is ?brokenObj_8_ T_javafe_tc_FieldDeclVec)) (not (= ?brokenObj_8_ null))) (= (S_select owner_4_35_28 (S_select elements_94_61_38 ?brokenObj_8_)) ?brokenObj_8_))) (forall (?brokenObj_9_ Int) (implies (and (= true_term (is ?brokenObj_9_ T_javafe_ast_IdentifierVec)) (not (= ?brokenObj_9_ null))) (= (S_select owner_4_35_28 (S_select elements_133_61_39 ?brokenObj_9_)) ?brokenObj_9_))) (forall (?brokenObj_10_ Int) (implies (and (= true_term (is ?brokenObj_10_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_10_ null)) (>= (S_select state_5_787_15 ?brokenObj_10_) PREPPED_5_775_28)) (not (= (S_select methods_5_883_26 ?brokenObj_10_) null)))) (forall (?brokenObj_11_ Int) (implies (and (= true_term (is ?brokenObj_11_ T_javafe_ast_TypeDecl)) (not (= ?brokenObj_11_ null))) (not (= (S_select locOpenBrace_14_51_13 ?brokenObj_11_) NULL_97_60_26)))) (forall (?brokenObj_12_ Int) (implies (and (= true_term (is ?brokenObj_12_ T_javafe_ast_CompoundName)) (not (= ?brokenObj_12_ null))) (= (S_select count_133_67_33 (S_select ids_150_19_37 ?brokenObj_12_)) (S_select length_125_50_25 ?brokenObj_12_)))) (forall (?brokenObj_13_ Int) (implies (and (= true_term (is ?brokenObj_13_ T_javafe_ast_CondExpr)) (not (= ?brokenObj_13_ null))) (not (= (S_select locColon_68_25_13 ?brokenObj_13_) NULL_97_60_26)))) (= true_term (is (S_select owner_4_35_28 punctuationCodes_21_164_19) T_javafe_parser_TagConstants)) (not (= (S_select owner_4_35_28 punctuationCodes_21_164_19) null)) (forall (?brokenObj_14_ Int) (implies (and (= true_term (is ?brokenObj_14_ T_javafe_ast_DoStmt)) (not (= ?brokenObj_14_ null))) (not (= (S_select loc_46_20_13 ?brokenObj_14_) NULL_97_60_26)))) (forall (?brokenObj_15_ Int) (implies (and (= true_term (is ?brokenObj_15_ T_javafe_tc_MethodDeclVec)) (not (= ?brokenObj_15_ null))) (forall (?i_95_62_31 Int) (implies (and (<= 0 ?i_95_62_31) (< ?i_95_62_31 (S_select count_95_67_33 ?brokenObj_15_))) (not (= (S_select (S_select elems (S_select elements_95_61_39 ?brokenObj_15_)) ?i_95_62_31) null)))))) (forall (?brokenObj_16_ Int) (implies (and (= true_term (is ?brokenObj_16_ T_javafe_ast_NewArrayExpr)) (not (= ?brokenObj_16_ null))) (>= (S_select count_54_67_33 (S_select dims_67_45_31 ?brokenObj_16_)) 1))) (forall (?brokenObj_17_ Int) (implies (and (= true_term (is ?brokenObj_17_ T_javafe_ast_ForStmt)) (not (= ?brokenObj_17_ null))) (not (= (S_select loc_53_33_13 ?brokenObj_17_) NULL_97_60_26)))) (forall (?brokenObj_18_ Int) (implies (and (= true_term (is ?brokenObj_18_ T_javafe_ast_LabelStmt)) (not (= ?brokenObj_18_ null))) (not (= (S_select locId_51_20_13 ?brokenObj_18_) NULL_97_60_26)))) (forall (?brokenObj_19_ Int) (implies (and (= true_term (is ?brokenObj_19_ T_javafe_ast_RoutineDecl)) (not (= ?brokenObj_19_ null)) (not (= (S_select body_31_34_19 ?brokenObj_19_) null))) (not (= (S_select locOpenBrace_31_36_13 ?brokenObj_19_) NULL_97_60_26)))) (forall (?brokenObj_20_ Int) (implies (and (= true_term (is ?brokenObj_20_ T_javafe_ast_VarInitVec)) (not (= ?brokenObj_20_ null))) (<= (S_select count_64_67_33 ?brokenObj_20_) (arrayLength (S_select elements_64_61_36 ?brokenObj_20_))))) (forall (?brokenObj_21_ Int) (implies (and (= true_term (is ?brokenObj_21_ T_javafe_ast_CastExpr)) (not (= ?brokenObj_21_ null))) (= true_term (S_select syntax_6_28_29 (S_select type_70_18_28 ?brokenObj_21_))))) (forall (?brokenObj_22_ Int) (implies (and (= true_term (is ?brokenObj_22_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_22_ null)) (not (= true_term (S_select member_5_44_39 ?brokenObj_22_)))) (not (= (S_select enclosingEnv_5_52_36 ?brokenObj_22_) null)))) (forall (?brokenObj_23_ Int) (implies (and (= true_term (is ?brokenObj_23_ T_javafe_tc_TypeSigVec)) (not (= ?brokenObj_23_ null))) (= (S_select owner_4_35_28 (S_select elements_152_61_36 ?brokenObj_23_)) ?brokenObj_23_))) (forall (?brokenObj_24_ Int) (implies (and (= true_term (is ?brokenObj_24_ T_javafe_ast_SynchronizeStmt)) (not (= ?brokenObj_24_ null))) (not (= (S_select loc_47_20_13 ?brokenObj_24_) NULL_97_60_26)))) (forall (?brokenObj_25_ Int) (implies (and (= true_term (is ?brokenObj_25_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_25_ null))) (not (= true_term (S_select syntax_6_28_29 ?brokenObj_25_))))) (forall (?brokenObj_26_ Int) (implies (and (= true_term (is ?brokenObj_26_ T_javafe_ast_VariableAccess)) (not (= ?brokenObj_26_ null))) (not (= (S_select loc_75_22_13 ?brokenObj_26_) NULL_97_60_26)))) (forall (?brokenObj_27_ Int) (implies (and (= true_term (is ?brokenObj_27_ T_javafe_tc_FieldDeclVec)) (not (= ?brokenObj_27_ null))) (= (typeof (S_select elements_94_61_38 ?brokenObj_27_)) (array T_javafe_ast_FieldDecl)))) (forall (?brokenObj_28_ Int) (implies (and (= true_term (is ?brokenObj_28_ T_javafe_ast_IdentifierVec)) (not (= ?brokenObj_28_ null))) (= (typeof (S_select elements_133_61_39 ?brokenObj_28_)) (array T_javafe_ast_Identifier)))) (forall (?brokenObj_29_ Int) (implies (and (= true_term (is ?brokenObj_29_ T_javafe_ast_GenericBlockStmt)) (not (= ?brokenObj_29_ null))) (not (= (S_select locOpenBrace_36_22_13 ?brokenObj_29_) NULL_97_60_26)))) (forall (?brokenObj_30_ Int) (implies (and (= true_term (is ?brokenObj_30_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_30_ null))) (iff (= (S_select myTypeDecl_5_63_40 ?brokenObj_30_) null) (= (S_select CU_5_71_30 ?brokenObj_30_) null)))) (forall (?brokenObj_31_ Int) (implies (and (= true_term (is ?brokenObj_31_ T_javafe_ast_CompoundName)) (not (= ?brokenObj_31_ null))) (not (= (S_select ids_150_19_37 ?brokenObj_31_) null)))) (forall (?brokenObj_32_ Int) (implies (and (= true_term (is ?brokenObj_32_ T_javafe_ast_NewInstanceExpr)) (not (= ?brokenObj_32_ null))) (not (= (S_select loc_66_49_13 ?brokenObj_32_) NULL_97_60_26)))) (forall (?brokenObj_33_ Int) (implies (and (= true_term (is ?brokenObj_33_ T_javafe_ast_MethodInvocation)) (not (= ?brokenObj_33_ null))) (not (= (S_select locId_78_25_13 ?brokenObj_33_) NULL_97_60_26)))) (forall (?brokenObj_34_ Int) (implies (and (= true_term (is ?brokenObj_34_ T_javafe_ast_ConstructorInvocation)) (not (= ?brokenObj_34_ null)) (not (= (S_select enclosingInstance_60_37_14 ?brokenObj_34_) null)) (= true_term (S_select superCall_60_24_17 ?brokenObj_34_))) (not (= (S_select locDot_60_41_13 ?brokenObj_34_) NULL_97_60_26)))) (forall (?brokenObj_35_ Int) (implies (and (= true_term (is ?brokenObj_35_ T_javafe_tc_MethodDeclVec)) (not (= ?brokenObj_35_ null))) (<= (S_select count_95_67_33 ?brokenObj_35_) (arrayLength (S_select elements_95_61_39 ?brokenObj_35_))))) (= true_term (nonnullelements otherStrings_21_193_30 elems)) (forall (?brokenObj_36_ Int) (implies (and (= true_term (is ?brokenObj_36_ T_javafe_ast_CompoundName)) (not (= ?brokenObj_36_ null))) (forall (?i_150_23_29 Int) (implies (and (<= 0 ?i_150_23_29) (< ?i_150_23_29 (arrayLength (S_select locIds_150_25_29 ?brokenObj_36_)))) (not (= (S_select (S_select elems (S_select locIds_150_25_29 ?brokenObj_36_)) ?i_150_23_29) NULL_97_60_26)))))) (forall (?i_21_149_29 Int) (implies (and (<= 0 ?i_21_149_29) (<= ?i_21_149_29 (arrayLength punctuationCodes_21_164_19))) (and (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) IDENT_22_25_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) BOOLEANLIT_22_38_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) INTLIT_22_39_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) LONGLIT_22_40_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) FLOATLIT_22_42_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) DOUBLELIT_22_43_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) STRINGLIT_22_44_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) CHARLIT_22_41_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) LEXICALPRAGMA_21_24_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) MODIFIERPRAGMA_21_25_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) STMTPRAGMA_21_26_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) TYPEDECLELEMPRAGMA_21_27_26)) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_149_29) TYPEMODIFIERPRAGMA_21_28_26))))) (forall (?brokenObj_37_ Int) (implies (and (= true_term (is ?brokenObj_37_ T_javafe_ast_PrimitiveType)) (not (= ?brokenObj_37_ null))) (or (= (S_select tag_99_30_13 ?brokenObj_37_) BOOLEANTYPE_22_27_26) (= (S_select tag_99_30_13 ?brokenObj_37_) INTTYPE_22_28_26) (= (S_select tag_99_30_13 ?brokenObj_37_) LONGTYPE_22_29_26) (= (S_select tag_99_30_13 ?brokenObj_37_) CHARTYPE_22_30_26) (= (S_select tag_99_30_13 ?brokenObj_37_) FLOATTYPE_22_31_26) (= (S_select tag_99_30_13 ?brokenObj_37_) DOUBLETYPE_22_32_26) (= (S_select tag_99_30_13 ?brokenObj_37_) VOIDTYPE_22_33_26) (= (S_select tag_99_30_13 ?brokenObj_37_) NULLTYPE_22_34_26) (= (S_select tag_99_30_13 ?brokenObj_37_) BYTETYPE_22_35_26) (= (S_select tag_99_30_13 ?brokenObj_37_) SHORTTYPE_22_36_26)))) (forall (?brokenObj_38_ Int) (implies (and (= true_term (is ?brokenObj_38_ T_javafe_ast_TryFinallyStmt)) (not (= ?brokenObj_38_ null))) (not (= (S_select loc_56_22_13 ?brokenObj_38_) NULL_97_60_26)))) (forall (?brokenObj_39_ Int) (implies (and (= true_term (is ?brokenObj_39_ T_javafe_ast_StmtVec)) (not (= ?brokenObj_39_ null))) (= (S_select owner_4_35_28 (S_select elements_41_61_33 ?brokenObj_39_)) ?brokenObj_39_))) (forall (?brokenObj_40_ Int) (implies (and (= true_term (is ?brokenObj_40_ T_javafe_ast_ExprVec)) (not (= ?brokenObj_40_ null))) (= (S_select owner_4_35_28 (S_select elements_54_61_33 ?brokenObj_40_)) ?brokenObj_40_))) (forall (?brokenObj_41_ Int) (implies (and (= true_term (is ?brokenObj_41_ T_javafe_ast_CondExpr)) (not (= ?brokenObj_41_ null))) (not (= (S_select locQuestion_68_22_13 ?brokenObj_41_) NULL_97_60_26)))) (forall (?brokenObj_42_ Int) (implies (and (= true_term (is ?brokenObj_42_ T_javafe_ast_InstanceOfExpr)) (not (= ?brokenObj_42_ null))) (= true_term (S_select syntax_6_28_29 (S_select type_69_18_28 ?brokenObj_42_))))) (forall (?brokenObj_43_ Int) (implies (and (= true_term (is ?brokenObj_43_ T_javafe_ast_TypeDecl)) (not (= ?brokenObj_43_ null))) (not (= (S_select locId_14_48_13 ?brokenObj_43_) NULL_97_60_26)))) (forall (?brokenObj_44_ Int) (implies (and (= true_term (is ?brokenObj_44_ T_javafe_ast_VarInitVec)) (not (= ?brokenObj_44_ null))) (<= 0 (S_select count_64_67_33 ?brokenObj_44_)))) (forall (?brokenObj_45_ Int) (implies (and (= true_term (is ?brokenObj_45_ T_javafe_tc_TypeSigVec)) (not (= ?brokenObj_45_ null))) (= (typeof (S_select elements_152_61_36 ?brokenObj_45_)) (array T_javafe_tc_TypeSig)))) (forall (?brokenObj_46_ Int) (implies (and (= true_term (is ?brokenObj_46_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_46_ null)) (= (S_select simpleName_5_37_38 ?brokenObj_46_) null)) (not (= true_term (S_select member_5_44_39 ?brokenObj_46_))))) (forall (?brokenObj_47_ Int) (implies (and (= true_term (is ?brokenObj_47_ T_javafe_ast_Identifier)) (not (= ?brokenObj_47_ null))) (and (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) BOOLEANLIT_22_38_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) INTLIT_22_39_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) LONGLIT_22_40_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) FLOATLIT_22_42_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) DOUBLELIT_22_43_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) STRINGLIT_22_44_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) CHARLIT_22_41_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) LEXICALPRAGMA_21_24_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) MODIFIERPRAGMA_21_25_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) STMTPRAGMA_21_26_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) TYPEDECLELEMPRAGMA_21_27_26)) (not (= (S_select tokenType_96_90_8 ?brokenObj_47_) TYPEMODIFIERPRAGMA_21_28_26))))) (forall (?brokenObj_48_ Int) (implies (and (= true_term (is ?brokenObj_48_ T_javafe_ast_CompilationUnit)) (not (= ?brokenObj_48_ null))) (not (= (S_select loc_86_30_13 ?brokenObj_48_) NULL_97_60_26)))) (forall (?brokenObj_49_ Int) (implies (and (= true_term (is ?brokenObj_49_ T_javafe_ast_CompoundName)) (not (= ?brokenObj_49_ null))) (> (S_select length_125_50_25 ?brokenObj_49_) 1))) (forall (?brokenObj_50_ Int) (implies (and (= true_term (is ?brokenObj_50_ T_javafe_ast_WhileStmt)) (not (= ?brokenObj_50_ null))) (not (= (S_select locGuardOpenParen_45_23_13 ?brokenObj_50_) NULL_97_60_26)))) (forall (?brokenObj_51_ Int) (implies (and (= true_term (is ?brokenObj_51_ T_javafe_ast_CompoundName)) (not (= ?brokenObj_51_ null))) (forall (?i_150_29_29 Int) (implies (and (<= 0 ?i_150_29_29) (< ?i_150_29_29 (arrayLength (S_select locDots_150_31_29 ?brokenObj_51_)))) (not (= (S_select (S_select elems (S_select locDots_150_31_29 ?brokenObj_51_)) ?i_150_29_29) NULL_97_60_26)))))) (forall (?brokenObj_52_ Int) (implies (and (= true_term (is ?brokenObj_52_ T_javafe_ast_ThrowStmt)) (not (= ?brokenObj_52_ null))) (not (= (S_select loc_50_18_13 ?brokenObj_52_) NULL_97_60_26)))) (forall (?brokenObj_53_ Int) (implies (and (= true_term (is ?brokenObj_53_ T_javafe_ast_NewArrayExpr)) (not (= ?brokenObj_53_ null))) (>= (arrayLength (S_select locOpenBrackets_67_65_29 ?brokenObj_53_)) (S_select count_54_67_33 (S_select dims_67_45_31 ?brokenObj_53_))))) (= noTokens_21_212_27 (+ (+ (arrayLength keywordStrings_21_181_30) (arrayLength punctuationStrings_21_134_22)) (arrayLength otherStrings_21_193_30))) (forall (?brokenObj_54_ Int) (implies (and (= true_term (is ?brokenObj_54_ T_javafe_ast_NewArrayExpr)) (not (= ?brokenObj_54_ null)) (not (= (S_select init_67_35_19 ?brokenObj_54_) null))) (= (S_select count_54_67_33 (S_select dims_67_45_31 ?brokenObj_54_)) 1))) (forall (?brokenObj_55_ Int) (implies (and (= true_term (is ?brokenObj_55_ T_javafe_ast_ThisExpr)) (not (= ?brokenObj_55_ null))) (not (= (S_select loc_127_29_13 ?brokenObj_55_) NULL_97_60_26)))) (forall (?brokenObj_56_ Int) (implies (and (= true_term (is ?brokenObj_56_ T_javafe_tc_MethodDeclVec)) (not (= ?brokenObj_56_ null))) (<= 0 (S_select count_95_67_33 ?brokenObj_56_)))) (forall (?brokenObj_57_ Int) (implies (and (= true_term (is ?brokenObj_57_ T_javafe_tc_FieldDeclVec)) (not (= ?brokenObj_57_ null))) (forall (?i_94_62_31 Int) (implies (and (<= 0 ?i_94_62_31) (< ?i_94_62_31 (S_select count_94_67_33 ?brokenObj_57_))) (not (= (S_select (S_select elems (S_select elements_94_61_38 ?brokenObj_57_)) ?i_94_62_31) null)))))) (forall (?brokenObj_58_ Int) (implies (and (= true_term (is ?brokenObj_58_ T_javafe_ast_TypeName)) (not (= ?brokenObj_58_ null))) (= true_term (S_select syntax_6_28_29 ?brokenObj_58_)))) (forall (?brokenObj_59_ Int) (implies (and (= true_term (is ?brokenObj_59_ T_javafe_ast_IdentifierVec)) (not (= ?brokenObj_59_ null))) (forall (?i_133_62_31 Int) (implies (and (<= 0 ?i_133_62_31) (< ?i_133_62_31 (S_select count_133_67_33 ?brokenObj_59_))) (not (= (S_select (S_select elems (S_select elements_133_61_39 ?brokenObj_59_)) ?i_133_62_31) null)))))) (forall (?brokenObj_60_ Int) (implies (and (= true_term (is ?brokenObj_60_ T_javafe_ast_BinaryExpr)) (not (= ?brokenObj_60_ null))) (or (= (S_select op_72_35_13 ?brokenObj_60_) OR_23_19_26) (= (S_select op_72_35_13 ?brokenObj_60_) AND_23_20_26) (= (S_select op_72_35_13 ?brokenObj_60_) BITOR_23_21_26) (= (S_select op_72_35_13 ?brokenObj_60_) BITXOR_23_22_26) (= (S_select op_72_35_13 ?brokenObj_60_) BITAND_23_23_26) (= (S_select op_72_35_13 ?brokenObj_60_) NE_23_24_26) (= (S_select op_72_35_13 ?brokenObj_60_) EQ_23_25_26) (= (S_select op_72_35_13 ?brokenObj_60_) GE_23_26_26) (= (S_select op_72_35_13 ?brokenObj_60_) GT_23_27_26) (= (S_select op_72_35_13 ?brokenObj_60_) LE_23_28_26) (= (S_select op_72_35_13 ?brokenObj_60_) LT_23_29_26) (= (S_select op_72_35_13 ?brokenObj_60_) LSHIFT_23_30_26) (= (S_select op_72_35_13 ?brokenObj_60_) RSHIFT_23_31_26) (= (S_select op_72_35_13 ?brokenObj_60_) URSHIFT_23_32_26) (= (S_select op_72_35_13 ?brokenObj_60_) ADD_23_33_26) (= (S_select op_72_35_13 ?brokenObj_60_) SUB_23_34_26) (= (S_select op_72_35_13 ?brokenObj_60_) DIV_23_35_26) (= (S_select op_72_35_13 ?brokenObj_60_) MOD_23_36_26) (= (S_select op_72_35_13 ?brokenObj_60_) STAR_23_37_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASSIGN_23_40_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGMUL_23_41_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGDIV_23_42_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGREM_23_43_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGADD_23_44_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGSUB_23_45_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGLSHIFT_23_46_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGRSHIFT_23_47_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGURSHIFT_23_48_26) (= (S_select op_72_35_13 ?brokenObj_60_) ASGBITAND_23_49_26)))) (forall (?brokenObj_61_ Int) (implies (and (= true_term (is ?brokenObj_61_ T_javafe_ast_StmtVec)) (not (= ?brokenObj_61_ null))) (= (typeof (S_select elements_41_61_33 ?brokenObj_61_)) (array T_javafe_ast_Stmt)))) (forall (?brokenObj_62_ Int) (implies (and (= true_term (is ?brokenObj_62_ T_javafe_ast_ArrayType)) (not (= ?brokenObj_62_ null))) (iff (= true_term (S_select syntax_6_28_29 (S_select elemType_148_18_28 ?brokenObj_62_))) (= true_term (S_select syntax_6_28_29 ?brokenObj_62_))))) (forall (?i_21_147_29 Int) (implies (and (<= 0 ?i_21_147_29) (<= ?i_21_147_29 (arrayLength punctuationCodes_21_164_19))) (not (= (S_select (S_select elems punctuationCodes_21_164_19) ?i_21_147_29) NULL_21_82_26)))) (forall (?brokenObj_63_ Int) (implies (and (= true_term (is ?brokenObj_63_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_63_ null)) (>= (S_select state_5_787_15 ?brokenObj_63_) PREPPED_5_775_28)) (not (= (S_select fields_5_875_27 ?brokenObj_63_) null)))) (forall (?brokenObj_64_ Int) (implies (and (= true_term (is ?brokenObj_64_ T_javafe_ast_BranchStmt)) (not (= ?brokenObj_64_ null))) (not (= (S_select loc_145_18_13 ?brokenObj_64_) NULL_97_60_26)))) (forall (?brokenObj_65_ Int) (implies (and (= true_term (is ?brokenObj_65_ T_javafe_ast_ExprVec)) (not (= ?brokenObj_65_ null))) (= (typeof (S_select elements_54_61_33 ?brokenObj_65_)) (array T_javafe_ast_Expr)))) (forall (?brokenObj_66_ Int) (implies (and (= true_term (is ?brokenObj_66_ T_javafe_ast_FieldAccess)) (not (= ?brokenObj_66_ null))) (or (= (S_select decl_76_28_19 ?brokenObj_66_) null) (= (S_select id_29_32_34 (S_select decl_76_28_19 ?brokenObj_66_)) (S_select id_76_21_34 ?brokenObj_66_))))) (forall (?brokenObj_67_ Int) (implies (and (= true_term (is ?brokenObj_67_ T_javafe_ast_ArrayInit)) (not (= ?brokenObj_67_ null))) (not (= (S_select locCloseBrace_63_24_13 ?brokenObj_67_) NULL_97_60_26)))) (forall (?brokenObj_68_ Int) (implies (and (= true_term (is ?brokenObj_68_ T_javafe_ast_ReturnStmt)) (not (= ?brokenObj_68_ null))) (not (= (S_select loc_49_18_13 ?brokenObj_68_) NULL_97_60_26)))) (forall (?brokenObj_69_ Int) (implies (and (= true_term (is ?brokenObj_69_ T_javafe_ast_SwitchLabel)) (not (= ?brokenObj_69_ null))) (not (= (S_select loc_55_29_13 ?brokenObj_69_) NULL_97_60_26)))) (forall (?brokenObj_70_ Int) (implies (and (= true_term (is ?brokenObj_70_ T_javafe_ast_ClassLiteral)) (not (= ?brokenObj_70_ null))) (not (= (S_select locDot_71_23_13 ?brokenObj_70_) NULL_97_60_26)))) (forall (?brokenObj_71_ Int) (implies (and (= true_term (is ?brokenObj_71_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_71_ null)) (= (S_select enclosingType_5_32_39 ?brokenObj_71_) null)) (= true_term (S_select member_5_44_39 ?brokenObj_71_)))) (forall (?brokenObj_72_ Int) (implies (and (= true_term (is ?brokenObj_72_ T_javafe_ast_LiteralExpr)) (not (= ?brokenObj_72_ null))) (or (= (S_select tag_98_32_13 ?brokenObj_72_) BOOLEANLIT_22_38_26) (= (S_select tag_98_32_13 ?brokenObj_72_) INTLIT_22_39_26) (= (S_select tag_98_32_13 ?brokenObj_72_) LONGLIT_22_40_26) (= (S_select tag_98_32_13 ?brokenObj_72_) FLOATLIT_22_42_26) (= (S_select tag_98_32_13 ?brokenObj_72_) DOUBLELIT_22_43_26) (= (S_select tag_98_32_13 ?brokenObj_72_) STRINGLIT_22_44_26) (= (S_select tag_98_32_13 ?brokenObj_72_) NULLLIT_22_45_26) (= (S_select tag_98_32_13 ?brokenObj_72_) CHARLIT_22_41_26)))) (forall (?brokenObj_73_ Int) (implies (and (= true_term (is ?brokenObj_73_ T_javafe_ast_SkipStmt)) (not (= ?brokenObj_73_ null))) (not (= (S_select loc_147_16_13 ?brokenObj_73_) NULL_97_60_26)))) (forall (?brokenObj_74_ Int) (implies (and (= true_term (is ?brokenObj_74_ T_javafe_tc_TypeSigVec)) (not (= ?brokenObj_74_ null))) (forall (?i_152_62_31 Int) (implies (and (<= 0 ?i_152_62_31) (< ?i_152_62_31 (S_select count_152_67_33 ?brokenObj_74_))) (not (= (S_select (S_select elems (S_select elements_152_61_36 ?brokenObj_74_)) ?i_152_62_31) null)))))) (forall (?brokenObj_75_ Int) (implies (and (= true_term (is ?brokenObj_75_ T_javafe_ast_MethodDecl)) (not (= ?brokenObj_75_ null))) (not (= (S_select locType_34_21_13 ?brokenObj_75_) NULL_97_60_26)))) (forall (?brokenObj_76_ Int) (implies (and (= true_term (is ?brokenObj_76_ T_javafe_ast_TypeDecl)) (not (= ?brokenObj_76_ null))) (not (= (S_select loc_14_45_13 ?brokenObj_76_) NULL_97_60_26)))) (forall (?brokenObj_77_ Int) (implies (and (= true_term (is ?brokenObj_77_ T_javafe_tc_FieldDeclVec)) (not (= ?brokenObj_77_ null))) (<= (S_select count_94_67_33 ?brokenObj_77_) (arrayLength (S_select elements_94_61_38 ?brokenObj_77_))))) (forall (?brokenObj_78_ Int) (implies (and (= true_term (is ?brokenObj_78_ T_javafe_ast_CatchClause)) (not (= ?brokenObj_78_ null))) (not (= (S_select loc_59_22_13 ?brokenObj_78_) NULL_97_60_26)))) (forall (?brokenObj_79_ Int) (implies (and (= true_term (is ?brokenObj_79_ T_javafe_ast_IdentifierVec)) (not (= ?brokenObj_79_ null))) (<= (S_select count_133_67_33 ?brokenObj_79_) (arrayLength (S_select elements_133_61_39 ?brokenObj_79_))))) (forall (?brokenObj_80_ Int) (implies (and (= true_term (is ?brokenObj_80_ T_javafe_ast_UnaryExpr)) (not (= ?brokenObj_80_ null))) (not (= (S_select locOp_73_32_13 ?brokenObj_80_) NULL_97_60_26)))) (forall (?brokenObj_81_ Int) (implies (and (= true_term (is ?brokenObj_81_ T_javafe_ast_CastExpr)) (not (= ?brokenObj_81_ null))) (not (= (S_select locCloseParen_70_24_13 ?brokenObj_81_) NULL_97_60_26)))) (forall (?brokenObj_82_ Int) (implies (and (= true_term (is ?brokenObj_82_ T_javafe_ast_VarInitVec)) (not (= ?brokenObj_82_ null))) (= (S_select owner_4_35_28 (S_select elements_64_61_36 ?brokenObj_82_)) ?brokenObj_82_))) (forall (?brokenObj_83_ Int) (implies (and (= true_term (is ?brokenObj_83_ T_javafe_ast_MethodInvocation)) (not (= ?brokenObj_83_ null))) (or (= (S_select decl_78_34_20 ?brokenObj_83_) null) (= (S_select id_34_15_34 (S_select decl_78_34_20 ?brokenObj_83_)) (S_select id_78_20_34 ?brokenObj_83_))))) (forall (?brokenObj_84_ Int) (implies (and (= true_term (is ?brokenObj_84_ T_javafe_ast_TryCatchStmt)) (not (= ?brokenObj_84_ null))) (not (= (S_select loc_57_23_13 ?brokenObj_84_) NULL_97_60_26)))) (forall (?brokenObj_85_ Int) (implies (and (= true_term (is ?brokenObj_85_ T_javafe_ast_GenericVarDecl)) (not (= ?brokenObj_85_ null))) (not (= (S_select locId_29_38_13 ?brokenObj_85_) NULL_97_60_26)))) (forall (?brokenObj_86_ Int) (implies (and (= true_term (is ?brokenObj_86_ T_javafe_ast_CompoundName)) (not (= ?brokenObj_86_ null))) (= (arrayLength (S_select locIds_150_25_29 ?brokenObj_86_)) (S_select length_125_50_25 ?brokenObj_86_)))) (forall (?brokenObj_87_ Int) (implies (and (= true_term (is ?brokenObj_87_ T_javafe_ast_LiteralExpr)) (not (= ?brokenObj_87_ null))) (not (= (S_select loc_98_50_13 ?brokenObj_87_) NULL_97_60_26)))) (forall (?brokenObj_88_ Int) (implies (and (= true_term (is ?brokenObj_88_ T_javafe_ast_ImportDecl)) (not (= ?brokenObj_88_ null))) (not (= (S_select loc_141_18_13 ?brokenObj_88_) NULL_97_60_26)))) (forall (?brokenObj_89_ Int) (implies (and (= true_term (is ?brokenObj_89_ T_javafe_ast_StmtVec)) (not (= ?brokenObj_89_ null))) (forall (?i_41_62_31 Int) (implies (and (<= 0 ?i_41_62_31) (< ?i_41_62_31 (S_select count_41_67_33 ?brokenObj_89_))) (not (= (S_select (S_select elems (S_select elements_41_61_33 ?brokenObj_89_)) ?i_41_62_31) null)))))) (forall (?brokenObj_90_ Int) (implies (and (= true_term (is ?brokenObj_90_ T_javafe_ast_IfStmt)) (not (= ?brokenObj_90_ null))) (not (= (S_select loc_52_22_13 ?brokenObj_90_) NULL_97_60_26)))) (forall (?brokenObj_91_ Int) (implies (and (= true_term (is ?brokenObj_91_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_91_ null)) (< (S_select state_5_787_15 ?brokenObj_91_) PARSED_5_772_28)) (= (S_select myTypeDecl_5_63_40 ?brokenObj_91_) null))) (forall (?brokenObj_92_ Int) (implies (and (= true_term (is ?brokenObj_92_ T_javafe_ast_ExprVec)) (not (= ?brokenObj_92_ null))) (forall (?i_54_62_31 Int) (implies (and (<= 0 ?i_54_62_31) (< ?i_54_62_31 (S_select count_54_67_33 ?brokenObj_92_))) (not (= (S_select (S_select elems (S_select elements_54_61_33 ?brokenObj_92_)) ?i_54_62_31) null)))))) (forall (?brokenObj_93_ Int) (implies (and (= true_term (is ?brokenObj_93_ T_javafe_ast_ParenExpr)) (not (= ?brokenObj_93_ null))) (not (= (S_select locCloseParen_74_21_13 ?brokenObj_93_) NULL_97_60_26)))) (forall (?brokenObj_94_ Int) (implies (and (= true_term (is ?brokenObj_94_ T_javafe_tc_MethodDeclVec)) (not (= ?brokenObj_94_ null))) (= (S_select owner_4_35_28 (S_select elements_95_61_39 ?brokenObj_94_)) ?brokenObj_94_))) (forall (?brokenObj_95_ Int) (implies (and (= true_term (is ?brokenObj_95_ T_javafe_tc_TypeSigVec)) (not (= ?brokenObj_95_ null))) (<= (S_select count_152_67_33 ?brokenObj_95_) (arrayLength (S_select elements_152_61_36 ?brokenObj_95_))))) (forall (?brokenObj_96_ Int) (implies (and (= true_term (is ?brokenObj_96_ T_javafe_ast_RoutineDecl)) (not (= ?brokenObj_96_ null))) (not (= (S_select locId_31_43_13 ?brokenObj_96_) NULL_97_60_26)))) (= true_term (nonnullelements punctuationStrings_21_134_22 elems)) (forall (?brokenObj_97_ Int) (implies (and (= true_term (is ?brokenObj_97_ T_javafe_ast_ArrayInit)) (not (= ?brokenObj_97_ null))) (not (= (S_select locOpenBrace_63_21_13 ?brokenObj_97_) NULL_97_60_26)))) (forall (?brokenObj_98_ Int) (implies (and (= true_term (is ?brokenObj_98_ T_javafe_ast_WhileStmt)) (not (= ?brokenObj_98_ null))) (not (= (S_select loc_45_20_13 ?brokenObj_98_) NULL_97_60_26)))) (forall (?brokenObj_99_ Int) (implies (and (= true_term (is ?brokenObj_99_ T_javafe_ast_AmbiguousMethodInvocation)) (not (= ?brokenObj_99_ null))) (not (= (S_select locOpenParen_77_30_13 ?brokenObj_99_) NULL_97_60_26)))) (forall (?brokenObj_100_ Int) (implies (and (= true_term (is ?brokenObj_100_ T_javafe_ast_FieldAccess)) (not (= ?brokenObj_100_ null))) (not (= (S_select locId_76_24_13 ?brokenObj_100_) NULL_97_60_26)))) (forall (?brokenObj_101_ Int) (implies (and (= true_term (is ?brokenObj_101_ T_javafe_tc_FieldDeclVec)) (not (= ?brokenObj_101_ null))) (<= 0 (S_select count_94_67_33 ?brokenObj_101_)))) (forall (?brokenObj_102_ Int) (implies (and (= true_term (is ?brokenObj_102_ T_javafe_ast_ArrayRefExpr)) (not (= ?brokenObj_102_ null))) (not (= (S_select locCloseBracket_65_23_13 ?brokenObj_102_) NULL_97_60_26)))) (forall (?brokenObj_103_ Int) (implies (and (= true_term (is ?brokenObj_103_ T_javafe_ast_IdentifierVec)) (not (= ?brokenObj_103_ null))) (<= 0 (S_select count_133_67_33 ?brokenObj_103_)))) (forall (?brokenObj_104_ Int) (implies (and (= true_term (is ?brokenObj_104_ T_javafe_ast_Name)) (not (= ?brokenObj_104_ null))) (>= (S_select length_125_50_25 ?brokenObj_104_) 1))) (forall (?brokenObj_105_ Int) (implies (and (= true_term (is ?brokenObj_105_ T_javafe_ast_NewArrayExpr)) (not (= ?brokenObj_105_ null))) (not (= (S_select loc_67_49_13 ?brokenObj_105_) NULL_97_60_26)))) (forall (?brokenObj_106_ Int) (implies (and (= true_term (is ?brokenObj_106_ T_javafe_ast_ConstructorInvocation)) (not (= ?brokenObj_106_ null))) (not (= (S_select locOpenParen_60_48_13 ?brokenObj_106_) NULL_97_60_26)))) (forall (?brokenObj_107_ Int) (implies (and (= true_term (is ?brokenObj_107_ T_javafe_ast_VarInitVec)) (not (= ?brokenObj_107_ null))) (= (typeof (S_select elements_64_61_36 ?brokenObj_107_)) (array T_javafe_ast_VarInit)))) (forall (?brokenObj_108_ Int) (implies (and (= true_term (is ?brokenObj_108_ T_javafe_ast_SimpleName)) (not (= ?brokenObj_108_ null))) (= (S_select length_125_50_25 ?brokenObj_108_) 1))) (forall (?brokenObj_109_ Int) (implies (and (= true_term (is ?brokenObj_109_ T_javafe_ast_TypeDecl)) (not (= ?brokenObj_109_ null))) (not (= (S_select locCloseBrace_14_54_13 ?brokenObj_109_) NULL_97_60_26)))) (= true_term (nonnullelements keywordStrings_21_181_30 elems)) (forall (?brokenObj_110_ Int) (implies (and (= true_term (is ?brokenObj_110_ T_javafe_ast_StmtVec)) (not (= ?brokenObj_110_ null))) (<= (S_select count_41_67_33 ?brokenObj_110_) (arrayLength (S_select elements_41_61_33 ?brokenObj_110_))))) (forall (?brokenObj_111_ Int) (implies (and (= true_term (is ?brokenObj_111_ T_javafe_ast_ExprVec)) (not (= ?brokenObj_111_ null))) (<= (S_select count_54_67_33 ?brokenObj_111_) (arrayLength (S_select elements_54_61_33 ?brokenObj_111_))))) (forall (?brokenObj_112_ Int) (implies (and (= true_term (is ?brokenObj_112_ T_javafe_ast_ObjectDesignator)) (not (= ?brokenObj_112_ null))) (not (= (S_select locDot_79_21_13 ?brokenObj_112_) NULL_97_60_26)))) (forall (?brokenObj_113_ Int) (implies (and (= true_term (is ?brokenObj_113_ T_javafe_ast_CastExpr)) (not (= ?brokenObj_113_ null))) (not (= (S_select locOpenParen_70_21_13 ?brokenObj_113_) NULL_97_60_26)))) (= (arrayLength punctuationCodes_21_164_19) (arrayLength punctuationStrings_21_134_22)) (forall (?brokenObj_114_ Int) (implies (and (= true_term (is ?brokenObj_114_ T_javafe_ast_ForStmt)) (not (= ?brokenObj_114_ null))) (not (= (S_select locFirstSemi_53_36_13 ?brokenObj_114_) NULL_97_60_26)))) (forall (?brokenObj_115_ Int) (implies (and (= true_term (is ?brokenObj_115_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_115_ null)) (>= (S_select state_5_787_15 ?brokenObj_115_) PARSED_5_772_28)) (not (= (S_select myTypeDecl_5_63_40 ?brokenObj_115_) null)))) (forall (?brokenObj_116_ Int) (implies (and (= true_term (is ?brokenObj_116_ T_javafe_ast_LiteralExpr)) (not (= ?brokenObj_116_ null))) (and (implies (= (S_select tag_98_32_13 ?brokenObj_116_) BOOLEANLIT_22_38_26) (and (= true_term (is (S_select value_98_45_16 ?brokenObj_116_) T_java_lang_Boolean)) (not (= (S_select value_98_45_16 ?brokenObj_116_) null)))) (implies (= (S_select tag_98_32_13 ?brokenObj_116_) NULLLIT_22_45_26) (= (S_select value_98_45_16 ?brokenObj_116_) null)) (implies (= (S_select tag_98_32_13 ?brokenObj_116_) INTLIT_22_39_26) (and (= true_term (is (S_select value_98_45_16 ?brokenObj_116_) T_java_lang_Integer)) (not (= (S_select value_98_45_16 ?brokenObj_116_) null)))) (implies (= (S_select tag_98_32_13 ?brokenObj_116_) LONGLIT_22_40_26) (and (= true_term (is (S_select value_98_45_16 ?brokenObj_116_) T_java_lang_Long)) (not (= (S_select value_98_45_16 ?brokenObj_116_) null)))) (implies (= (S_select tag_98_32_13 ?brokenObj_116_) FLOATLIT_22_42_26) (and (= true_term (is (S_select value_98_45_16 ?brokenObj_116_) T_java_lang_Float)) (not (= (S_select value_98_45_16 ?brokenObj_116_) null)))) (implies (= (S_select tag_98_32_13 ?brokenObj_116_) DOUBLELIT_22_43_26) (and (= true_term (is (S_select value_98_45_16 ?brokenObj_116_) T_java_lang_Double)) (not (= (S_select value_98_45_16 ?brokenObj_116_) null)))) (implies (= (S_select tag_98_32_13 ?brokenObj_116_) STRINGLIT_22_44_26) (and (= true_term (is (S_select value_98_45_16 ?brokenObj_116_) T_java_lang_String)) (not (= (S_select value_98_45_16 ?brokenObj_116_) null)))) (implies (= (S_select tag_98_32_13 ?brokenObj_116_) CHARLIT_22_41_26) (and (= true_term (is (S_select value_98_45_16 ?brokenObj_116_) T_java_lang_Integer)) (not (= (S_select value_98_45_16 ?brokenObj_116_) null))))))) (forall (?brokenObj_117_ Int) (implies (and (= true_term (is ?brokenObj_117_ T_javafe_tc_MethodDeclVec)) (not (= ?brokenObj_117_ null))) (= (typeof (S_select elements_95_61_39 ?brokenObj_117_)) (array T_javafe_ast_MethodDecl)))) (forall (?brokenObj_118_ Int) (implies (and (= true_term (is ?brokenObj_118_ T_javafe_ast_SynchronizeStmt)) (not (= ?brokenObj_118_ null))) (not (= (S_select locOpenParen_47_23_13 ?brokenObj_118_) NULL_97_60_26)))) (forall (?brokenObj_119_ Int) (implies (and (= true_term (is ?brokenObj_119_ T_javafe_ast_NewArrayExpr)) (not (= ?brokenObj_119_ null))) (= true_term (S_select syntax_6_28_29 (S_select type_67_24_28 ?brokenObj_119_))))) (forall (?brokenObj_120_ Int) (implies (and (= true_term (is ?brokenObj_120_ T_javafe_tc_TypeSigVec)) (not (= ?brokenObj_120_ null))) (<= 0 (S_select count_152_67_33 ?brokenObj_120_)))) (forall (?brokenObj_121_ Int) (implies (and (= true_term (is ?brokenObj_121_ T_javafe_ast_CompoundName)) (not (= ?brokenObj_121_ null))) (= (arrayLength (S_select locDots_150_31_29 ?brokenObj_121_)) (- (S_select length_125_50_25 ?brokenObj_121_) 1)))) (forall (?brokenObj_122_ Int) (implies (and (= true_term (is ?brokenObj_122_ T_javafe_ast_BinaryExpr)) (not (= ?brokenObj_122_ null))) (not (= (S_select locOp_72_43_13 ?brokenObj_122_) NULL_97_60_26)))) (forall (?brokenObj_123_ Int) (implies (and (= true_term (is ?brokenObj_123_ T_javafe_ast_NewInstanceExpr)) (not (= ?brokenObj_123_ null))) (iff (= (S_select enclosingInstance_66_25_14 ?brokenObj_123_) null) (= (S_select locDot_66_29_13 ?brokenObj_123_) NULL_97_60_26)))) (forall (?brokenObj_124_ Int) (implies (and (= true_term (is ?brokenObj_124_ T_javafe_ast_SwitchStmt)) (not (= ?brokenObj_124_ null))) (not (= (S_select loc_39_18_13 ?brokenObj_124_) NULL_97_60_26)))) (forall (?brokenObj_125_ Int) (implies (and (= true_term (is ?brokenObj_125_ T_javafe_ast_RoutineDecl)) (not (= ?brokenObj_125_ null))) (not (= (S_select loc_31_40_13 ?brokenObj_125_) NULL_97_60_26)))) (forall (?brokenObj_126_ Int) (implies (and (= true_term (is ?brokenObj_126_ T_javafe_ast_UnaryExpr)) (not (= ?brokenObj_126_ null))) (or (= (S_select op_73_26_13 ?brokenObj_126_) UNARYADD_23_54_26) (= (S_select op_73_26_13 ?brokenObj_126_) UNARYSUB_23_55_26) (= (S_select op_73_26_13 ?brokenObj_126_) NOT_23_56_26) (= (S_select op_73_26_13 ?brokenObj_126_) BITNOT_23_57_26) (= (S_select op_73_26_13 ?brokenObj_126_) INC_23_58_26) (= (S_select op_73_26_13 ?brokenObj_126_) DEC_23_59_26) (= (S_select op_73_26_13 ?brokenObj_126_) POSTFIXINC_23_62_26) (= (S_select op_73_26_13 ?brokenObj_126_) POSTFIXDEC_23_63_26)))) (forall (?brokenObj_127_ Int) (implies (and (= true_term (is ?brokenObj_127_ T_javafe_ast_SimpleName)) (not (= ?brokenObj_127_ null))) (not (= (S_select loc_149_20_13 ?brokenObj_127_) NULL_97_60_26)))) (forall (?brokenObj_128_ Int) (implies (and (= true_term (is ?brokenObj_128_ T_javafe_ast_GenericVarDecl)) (not (= ?brokenObj_128_ null))) (= true_term (S_select syntax_6_28_29 (S_select type_29_35_28 ?brokenObj_128_))))) (forall (?brokenObj_129_ Int) (implies (and (= true_term (is ?brokenObj_129_ T_javafe_ast_ClassLiteral)) (not (= ?brokenObj_129_ null))) (= true_term (S_select syntax_6_28_29 (S_select type_71_20_28 ?brokenObj_129_))))) (= (arrayLength keywordStrings_21_181_30) (- (+ 1 LAST_KEYWORD_21_103_26) FIRST_KEYWORD_21_51_26)) (forall (?brokenObj_130_ Int) (implies (and (= true_term (is ?brokenObj_130_ T_javafe_tc_TypeSig)) (not (= ?brokenObj_130_ null)) (not (= (S_select enclosingType_5_32_39 ?brokenObj_130_) null))) (not (= (S_select myTypeDecl_5_63_40 ?brokenObj_130_) null)))) (forall (?brokenObj_131_ Int) (implies (and (= true_term (is ?brokenObj_131_ T_javafe_ast_VarInitVec)) (not (= ?brokenObj_131_ null))) (forall (?i_64_62_31 Int) (implies (and (<= 0 ?i_64_62_31) (< ?i_64_62_31 (S_select count_64_67_33 ?brokenObj_131_))) (not (= (S_select (S_select elems (S_select elements_64_61_36 ?brokenObj_131_)) ?i_64_62_31) null)))))) (forall (?brokenObj_132_ Int) (implies (and (= true_term (is ?brokenObj_132_ T_javafe_ast_InstanceOfExpr)) (not (= ?brokenObj_132_ null))) (not (= (S_select loc_69_21_13 ?brokenObj_132_) NULL_97_60_26)))) (= (arrayLength otherCodes_21_202_27) (arrayLength otherStrings_21_193_30)) (forall (?brokenObj_133_ Int) (implies (and (= true_term (is ?brokenObj_133_ T_javafe_ast_VariableAccess)) (not (= ?brokenObj_133_ null))) (= (S_select id_29_32_34 (S_select decl_75_26_38 ?brokenObj_133_)) (S_select id_75_19_34 ?brokenObj_133_)))) (forall (?brokenObj_134_ Int) (implies (and (= true_term (is ?brokenObj_134_ T_javafe_ast_StmtVec)) (not (= ?brokenObj_134_ null))) (<= 0 (S_select count_41_67_33 ?brokenObj_134_)))) (forall (?brokenObj_135_ Int) (implies (and (= true_term (is ?brokenObj_135_ T_javafe_ast_ConstructorInvocation)) (not (= ?brokenObj_135_ null))) (not (= (S_select locKeyword_60_45_13 ?brokenObj_135_) NULL_97_60_26)))) (forall (?brokenObj_136_ Int) (implies (and (= true_term (is ?brokenObj_136_ T_javafe_ast_GenericBlockStmt)) (not (= ?brokenObj_136_ null))) (not (= (S_select locCloseBrace_36_25_13 ?brokenObj_136_) NULL_97_60_26)))) (forall (?brokenObj_137_ Int) (implies (and (= true_term (is ?brokenObj_137_ T_javafe_ast_TryFinallyStmt)) (not (= ?brokenObj_137_ null))) (not (= (S_select locFinally_56_25_13 ?brokenObj_137_) NULL_97_60_26)))) (forall (?brokenObj_138_ Int) (implies (and (= true_term (is ?brokenObj_138_ T_javafe_ast_NewInstanceExpr)) (not (= ?brokenObj_138_ null))) (not (= (S_select locOpenParen_66_52_13 ?brokenObj_138_) NULL_97_60_26)))) (forall (?brokenObj_139_ Int) (implies (and (= true_term (is ?brokenObj_139_ T_javafe_ast_NewArrayExpr)) (not (= ?brokenObj_139_ null))) (forall (?i_67_63_29 Int) (implies (and (<= 0 ?i_67_63_29) (< ?i_67_63_29 (S_select count_54_67_33 (S_select dims_67_45_31 ?brokenObj_139_)))) (not (= (S_select (S_select elems (S_select locOpenBrackets_67_65_29 ?brokenObj_139_)) ?i_67_63_29) NULL_97_60_26)))))) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (or (and (>= (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (= true_term true_term) (= true_term (is expr_263_52 T_javafe_ast_Expr)) (not (= expr_263_52 null)) (= true_term true_term) (or (not (= true_term (is expr_263_52 T_javafe_ast_Expr))) (and (= true_term (is expr_263_52 T_javafe_ast_Expr)) (= i_270_23_270_23_62_1881_40 (cast expr_263_52 T_javafe_ast_Expr)) (not (not (= i_270_23_270_23_62_1881_40 null)))))) (and (or (and (>= (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (= true_term true_term) (or (and (= true_term (is expr_263_52 T_javafe_ast_Expr)) (not (= expr_263_52 null)) (= true_term true_term) (= true_term (is expr_263_52 T_javafe_ast_Expr)) (= i_270_23_270_23_62_1881_40 (cast expr_263_52 T_javafe_ast_Expr)) (not (= i_270_23_270_23_62_1881_40 null)) (= true_term (is RES_270_23_270_23 T_javafe_ast_Type)) (= true_term (isAllocated RES_270_23_270_23 alloc)) (= EC_270_23_270_23 ecReturn) (implies (= EC_270_23_270_23 ecReturn) (not (= RES_270_23_270_23 null))) (= RES RES_270_23_270_23) (= EC EC_270_23_270_23)) (and (not (and (= true_term (is expr_263_52 T_javafe_ast_Expr)) (not (= expr_263_52 null)))) (= true_term true_term) (= RES RES_1_) (= EC EC_1_))) (= RES_2_ RES) (= EC_2_ EC)) (and (not (>= (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= RES_2_ RES_1_) (= EC_2_ EC_1_))) (or (not (not (= expr_263_52 null))) (and (not (= expr_263_52 null)) (= true_term (is RES_273_17_273_17 T_int)) (= EC_273_17_273_17 ecReturn) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_LiteralExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select tag_98_32_13 (cast expr_263_52 T_javafe_ast_LiteralExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_BinaryExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select op_72_35_13 (cast expr_263_52 T_javafe_ast_BinaryExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_UnaryExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select op_73_26_13 (cast expr_263_52 T_javafe_ast_UnaryExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_PrimitiveType)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select tag_99_30_13 (cast expr_263_52 T_javafe_ast_PrimitiveType)))) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPESIG_20_6_28)) (= (PO_LT (typeof expr_263_52) T_javafe_tc_TypeSig) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 COMPILATIONUNIT_24_14_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CompilationUnit) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SINGLETYPEIMPORTDECL_24_15_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SingleTypeImportDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ONDEMANDIMPORTDECL_24_16_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_OnDemandImportDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSDECL_24_17_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTERFACEDECL_24_18_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InterfaceDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONSTRUCTORDECL_24_19_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ConstructorDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 METHODDECL_24_20_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_MethodDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INITBLOCK_24_21_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InitBlock) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LOCALVARDECL_24_22_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LocalVarDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FIELDDECL_24_23_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FieldDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FORMALPARADECL_24_24_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FormalParaDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BLOCKSTMT_24_25_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BlockStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SWITCHSTMT_24_26_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SwitchStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VARDECLSTMT_24_27_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_VarDeclStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSDECLSTMT_24_28_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassDeclStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 WHILESTMT_24_29_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_WhileStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOSTMT_24_30_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_DoStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SYNCHRONIZESTMT_24_31_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SynchronizeStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EVALSTMT_24_32_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_EvalStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 RETURNSTMT_24_33_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ReturnStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 THROWSTMT_24_34_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ThrowStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BREAKSTMT_24_35_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BreakStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONTINUESTMT_24_36_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ContinueStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LABELSTMT_24_37_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LabelStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 IFSTMT_24_38_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_IfStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FORSTMT_24_39_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ForStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SKIPSTMT_24_40_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SkipStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SWITCHLABEL_24_41_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SwitchLabel) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TRYFINALLYSTMT_24_42_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TryFinallyStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TRYCATCHSTMT_24_43_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TryCatchStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONSTRUCTORINVOCATION_24_44_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ConstructorInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CATCHCLAUSE_24_45_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CatchClause) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYINIT_24_46_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayInit) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 THISEXPR_24_47_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ThisExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYREFEXPR_24_48_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayRefExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NEWINSTANCEEXPR_24_49_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_NewInstanceExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NEWARRAYEXPR_24_50_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_NewArrayExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONDEXPR_24_51_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CondExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INSTANCEOFEXPR_24_52_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InstanceOfExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CASTEXPR_24_53_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CastExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 PARENEXPR_24_54_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ParenExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AMBIGUOUSVARIABLEACCESS_24_55_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_AmbiguousVariableAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VARIABLEACCESS_24_56_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_VariableAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FIELDACCESS_24_57_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FieldAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AMBIGUOUSMETHODINVOCATION_24_58_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_AmbiguousMethodInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 METHODINVOCATION_24_59_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_MethodInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSLITERAL_24_60_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassLiteral) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EXPROBJECTDESIGNATOR_24_61_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ExprObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPEOBJECTDESIGNATOR_24_62_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TypeObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SUPEROBJECTDESIGNATOR_24_63_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SuperObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPENAME_24_64_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TypeName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYTYPE_24_65_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SIMPLENAME_24_66_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SimpleName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 COMPOUNDNAME_24_67_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CompoundName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 OR_23_19_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AND_23_20_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITOR_23_21_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITXOR_23_22_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITAND_23_23_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NE_23_24_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EQ_23_25_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 GE_23_26_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 GT_23_27_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LE_23_28_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LT_23_29_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LSHIFT_23_30_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 RSHIFT_23_31_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 URSHIFT_23_32_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ADD_23_33_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SUB_23_34_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DIV_23_35_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 MOD_23_36_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 STAR_23_37_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASSIGN_23_40_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGMUL_23_41_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGDIV_23_42_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGREM_23_43_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGADD_23_44_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGSUB_23_45_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGLSHIFT_23_46_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGRSHIFT_23_47_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGURSHIFT_23_48_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITAND_23_49_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITOR_23_50_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITXOR_23_51_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 UNARYADD_23_54_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 UNARYSUB_23_55_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NOT_23_56_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITNOT_23_57_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INC_23_58_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DEC_23_59_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 POSTFIXINC_23_62_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 POSTFIXDEC_23_63_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BOOLEANTYPE_22_27_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTTYPE_22_28_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LONGTYPE_22_29_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CHARTYPE_22_30_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FLOATTYPE_22_31_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOUBLETYPE_22_32_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VOIDTYPE_22_33_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NULLTYPE_22_34_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BYTETYPE_22_35_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SHORTTYPE_22_36_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BOOLEANLIT_22_38_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTLIT_22_39_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LONGLIT_22_40_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CHARLIT_22_41_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FLOATLIT_22_42_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOUBLELIT_22_43_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 STRINGLIT_22_44_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NULLLIT_22_45_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (or (and (= true_term true_term) (= RES_273_17_273_17 ARRAYINIT_24_46_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_ArrayInit))) (and (= true_term (is expr_263_52 T_javafe_ast_ArrayInit)) (= ai_276_1 (cast expr_263_52 T_javafe_ast_ArrayInit)) (= EC_273_17_273_17 EC_loopold) (= 0 i_loopold_277_9) (or (and (= true_term true_term) (or (not (not (= ai_276_1 null))) (and (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (< 0 RES_277_1_0_277_29_277_29) (or (not (not (= ai_276_1 null))) (and (not (= ai_276_1 null)) (= tmp3_elems_277_1_0_278_18 (S_select elems_63_18_34 ai_276_1)) (or (not (and (<= 0 0) (< 0 (S_select count_64_67_33 tmp3_elems_277_1_0_278_18)))) (and (= true_term (is RES_277_1_0_278_27_278_27 T_javafe_ast_VarInit)) (= true_term (isAllocated RES_277_1_0_278_27_278_27 alloc)) (= EC_277_1_0_278_27_278_27 ecReturn) (implies (= EC_277_1_0_278_27_278_27 ecReturn) (not (= RES_277_1_0_278_27_278_27 null))) (not (and (not (= sig_263_39 null)) (not (= RES_277_1_0_278_27_278_27 null))))))))))) (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (< 0 RES_277_1_0_277_29_277_29) (not (= ai_276_1 null)) (= tmp3_elems_277_1_0_278_18 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_278_27_278_27 T_javafe_ast_VarInit)) (= true_term (isAllocated RES_277_1_0_278_27_278_27 alloc)) (= EC_277_1_0_278_27_278_27 ecReturn) (implies (= EC_277_1_0_278_27_278_27 ecReturn) (not (= RES_277_1_0_278_27_278_27 null))) (= EC_277_1_0_278_3_278_3 ecReturn) (= i_277_1_0_277_37 (+ 0 1)) (= true_term true_term) (not (not (= ai_276_1 null)))))))) (and (= true_term true_term) (= RES_273_17_273_17 ARRAYREFEXPR_24_48_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_ArrayRefExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_ArrayRefExpr)) (= r_293_8 (cast expr_263_52 T_javafe_ast_ArrayRefExpr)) (or (not (not (= r_293_8 null))) (and (not (= r_293_8 null)) (or (and (= expr_294_1_294_1_263_52 (S_select array_65_15_28 r_293_8)) (not (and (not (= sig_263_39 null)) (not (= expr_294_1_294_1_263_52 null))))) (and (= expr_294_1_294_1_263_52 (S_select array_65_15_28 r_293_8)) (= EC_294_1_294_1 ecReturn) (or (not (not (= r_293_8 null))) (and (not (= r_293_8 null)) (= expr_295_1_295_1_263_52 (S_select index_65_17_28 r_293_8)) (not (and (not (= sig_263_39 null)) (not (= expr_295_1_295_1_263_52 null))))))))))))) (and (= true_term true_term) (= RES_273_17_273_17 NEWINSTANCEEXPR_24_49_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_NewInstanceExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_NewInstanceExpr)) (= ne_301_8 (cast expr_263_52 T_javafe_ast_NewInstanceExpr)) (or (not (not (= ne_301_8 null))) (and (not (= ne_301_8 null)) (or (and (not (= (S_select enclosingInstance_66_25_14 ne_301_8) null)) (= true_term true_term) (or (not (not (= ne_301_8 null))) (and (not (= ne_301_8 null)) (= expr_303_5_303_5_263_52 (S_select enclosingInstance_66_25_14 ne_301_8)) (not (and (not (= sig_263_39 null)) (not (= expr_303_5_303_5_263_52 null))))))) (and (or (and (not (= (S_select enclosingInstance_66_25_14 ne_301_8) null)) (= true_term true_term) (not (= ne_301_8 null)) (= expr_303_5_303_5_263_52 (S_select enclosingInstance_66_25_14 ne_301_8)) (= EC_303_5_303_5 ecReturn) (= RES_3_ RES_303_5_303_5) (= EC_3_ EC_303_5_303_5)) (and (not (not (= (S_select enclosingInstance_66_25_14 ne_301_8) null))) (= true_term true_term) (= RES_3_ RES_273_17_273_17) (= EC_3_ EC_273_17_273_17))) (or (not (not (= ne_301_8 null))) (and (not (= ne_301_8 null)) (= tmp8_type_304_11 (S_select type_66_32_32 ne_301_8)) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (or (and (= resolved_304_1_304_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (not (= tmp8_type_304_11 null)))) (and (= resolved_304_1_304_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp8_type_304_11 null)) (= EC_304_1_304_1 ecReturn) (or (and (= 0 i_loopold_305_9) (= EC_304_1_304_1 EC_loopold_1_) (or (and (= true_term true_term) (or (not (not (= ne_301_8 null))) (and (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (< 0 RES_305_1_0_305_28_305_28) (or (not (not (= ne_301_8 null))) (and (not (= ne_301_8 null)) (= tmp11_args_305_1_0_306_18 (S_select args_66_34_31 ne_301_8)) (or (not (and (<= 0 0) (< 0 (S_select count_54_67_33 tmp11_args_305_1_0_306_18)))) (and (= true_term (is RES_305_1_0_306_26_306_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_305_1_0_306_26_306_26 alloc)) (= EC_305_1_0_306_26_306_26 ecReturn) (implies (= EC_305_1_0_306_26_306_26 ecReturn) (not (= RES_305_1_0_306_26_306_26 null))) (not (and (not (= sig_263_39 null)) (not (= RES_305_1_0_306_26_306_26 null))))))))))) (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (< 0 RES_305_1_0_305_28_305_28) (not (= ne_301_8 null)) (= tmp11_args_305_1_0_306_18 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_306_26_306_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_305_1_0_306_26_306_26 alloc)) (= EC_305_1_0_306_26_306_26 ecReturn) (implies (= EC_305_1_0_306_26_306_26 ecReturn) (not (= RES_305_1_0_306_26_306_26 null))) (= EC_305_1_0_306_3_306_3 ecReturn) (= i_305_1_0_305_36 (+ 0 1)) (= true_term true_term) (not (not (= ne_301_8 null)))))) (and (= 0 i_loopold_305_9) (= EC_304_1_304_1 EC_loopold_1_) (or (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (not (< 0 RES_305_1_0_305_28_305_28)) (= RES_4_ RES_305_1_0_305_28_305_28)) (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (< 0 RES_305_1_0_305_28_305_28) (not (= ne_301_8 null)) (= tmp11_args_305_1_0_306_18 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_306_26_306_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_305_1_0_306_26_306_26 alloc)) (= EC_305_1_0_306_26_306_26 ecReturn) (implies (= EC_305_1_0_306_26_306_26 ecReturn) (not (= RES_305_1_0_306_26_306_26 null))) (= EC_305_1_0_306_3_306_3 ecReturn) (= i_305_1_0_305_36 (+ 0 1)) (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_1_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_1_305_28_305_28 T_int)) (= EC_305_1_1_305_28_305_28 ecReturn) (implies (= EC_305_1_1_305_28_305_28 ecReturn) (= RES_305_1_1_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_1_305_28))) (not (< i_305_1_0_305_36 RES_305_1_1_305_28_305_28)) (= RES_4_ RES_305_1_1_305_28_305_28))) (= L_305_1 L_305_1) (= RES_5_ RES_4_) (= EC_4_ L_305_1) (or (not (not (= ne_301_8 null))) (and (not (= ne_301_8 null)) (or (and (not (= (S_select anonDecl_66_45_19 ne_301_8) null)) (not (not (= sig_263_39 null)))) (and (or (and (not (= (S_select anonDecl_66_45_19 ne_301_8) null)) (not (= sig_263_39 null)) (= tmp13_cand_308_5 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= tmp13_cand_308_23 tmp13_cand_308_5)) (and (not (not (= (S_select anonDecl_66_45_19 ne_301_8) null))) (= true_term true_term) (= tmp13_cand_308_23 false_term))) (= true_term tmp13_cand_308_23) (= true_term true_term) (or (not (not (= ne_301_8 null))) (and (not (= ne_301_8 null)) (or (not (not (= (S_select anonDecl_66_45_19 ne_301_8) null))) (and (not (= (S_select anonDecl_66_45_19 ne_301_8) null)) (= d_309_32_309_32_5_115_56 (S_select anonDecl_66_45_19 ne_301_8)) (= true_term (is RES_309_32_309_32 T_javafe_tc_TypeSig)) (= true_term (isAllocated RES_309_32_309_32 alloc)) (= EC_309_32_309_32 ecReturn) (implies (= EC_309_32_309_32 ecReturn) (not (= RES_309_32_309_32 null))) (not (not (= RES_309_32_309_32 null)))))))))))))))))))))))))) (and (= true_term true_term) (= RES_273_17_273_17 NEWARRAYEXPR_24_50_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_NewArrayExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_NewArrayExpr)) (= na_319_8 (cast expr_263_52 T_javafe_ast_NewArrayExpr)) (or (not (not (= na_319_8 null))) (and (not (= na_319_8 null)) (= tmp14_type_320_11 (S_select type_67_24_28 na_319_8)) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (or (and (= resolved_320_1_320_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (not (= tmp14_type_320_11 null)))) (and (= resolved_320_1_320_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp14_type_320_11 null)) (= EC_320_1_320_1 ecReturn) (= EC_320_1_320_1 EC_loopold_2_) (= 0 i_loopold_321_9) (or (and (= true_term true_term) (or (not (not (= na_319_8 null))) (and (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (< 0 RES_321_1_0_321_28_321_28) (or (not (not (= na_319_8 null))) (and (not (= na_319_8 null)) (= tmp17_dims_321_1_0_322_18 (S_select dims_67_45_31 na_319_8)) (or (not (and (<= 0 0) (< 0 (S_select count_54_67_33 tmp17_dims_321_1_0_322_18)))) (and (= true_term (is RES_321_1_0_322_26_322_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_321_1_0_322_26_322_26 alloc)) (= EC_321_1_0_322_26_322_26 ecReturn) (implies (= EC_321_1_0_322_26_322_26 ecReturn) (not (= RES_321_1_0_322_26_322_26 null))) (not (and (not (= sig_263_39 null)) (not (= RES_321_1_0_322_26_322_26 null))))))))))) (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (< 0 RES_321_1_0_321_28_321_28) (not (= na_319_8 null)) (= tmp17_dims_321_1_0_322_18 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_322_26_322_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_321_1_0_322_26_322_26 alloc)) (= EC_321_1_0_322_26_322_26 ecReturn) (implies (= EC_321_1_0_322_26_322_26 ecReturn) (not (= RES_321_1_0_322_26_322_26 null))) (= EC_321_1_0_322_3_322_3 ecReturn) (= i_321_1_0_321_36 (+ 0 1)) (= true_term true_term) (not (not (= na_319_8 null)))))))))))))) (and (= true_term true_term) (= RES_273_17_273_17 CONDEXPR_24_51_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_CondExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_CondExpr)) (= ce_328_8 (cast expr_263_52 T_javafe_ast_CondExpr)) (or (not (not (= ce_328_8 null))) (and (not (= ce_328_8 null)) (or (and (= expr_329_1_329_1_263_52 (S_select test_68_15_28 ce_328_8)) (not (and (not (= sig_263_39 null)) (not (= expr_329_1_329_1_263_52 null))))) (and (= expr_329_1_329_1_263_52 (S_select test_68_15_28 ce_328_8)) (= EC_329_1_329_1 ecReturn) (or (not (not (= ce_328_8 null))) (and (not (= ce_328_8 null)) (or (and (= expr_330_1_330_1_263_52 (S_select thn_68_17_28 ce_328_8)) (not (and (not (= sig_263_39 null)) (not (= expr_330_1_330_1_263_52 null))))) (and (= expr_330_1_330_1_263_52 (S_select thn_68_17_28 ce_328_8)) (= EC_330_1_330_1 ecReturn) (or (not (not (= ce_328_8 null))) (and (not (= ce_328_8 null)) (= expr_331_1_331_1_263_52 (S_select els_68_19_28 ce_328_8)) (not (and (not (= sig_263_39 null)) (not (= expr_331_1_331_1_263_52 null))))))))))))))))) (and (= true_term true_term) (= RES_273_17_273_17 INSTANCEOFEXPR_24_52_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_InstanceOfExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_InstanceOfExpr)) (= ie_337_8 (cast expr_263_52 T_javafe_ast_InstanceOfExpr)) (or (not (not (= ie_337_8 null))) (and (not (= ie_337_8 null)) (or (and (= expr_338_1_338_1_263_52 (S_select expr_69_15_28 ie_337_8)) (not (and (not (= sig_263_39 null)) (not (= expr_338_1_338_1_263_52 null))))) (and (= expr_338_1_338_1_263_52 (S_select expr_69_15_28 ie_337_8)) (= EC_338_1_338_1 ecReturn) (or (not (not (= ie_337_8 null))) (and (not (= ie_337_8 null)) (= tmp23_type_339_11 (S_select type_69_18_28 ie_337_8)) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (= resolved_339_1_339_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (not (= tmp23_type_339_11 null)))))))))))))) (and (= true_term true_term) (= RES_273_17_273_17 CASTEXPR_24_53_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_CastExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_CastExpr)) (= ce_345_8 (cast expr_263_52 T_javafe_ast_CastExpr)) (or (not (not (= ce_345_8 null))) (and (not (= ce_345_8 null)) (or (and (= expr_346_1_346_1_263_52 (S_select expr_70_15_28 ce_345_8)) (not (and (not (= sig_263_39 null)) (not (= expr_346_1_346_1_263_52 null))))) (and (= expr_346_1_346_1_263_52 (S_select expr_70_15_28 ce_345_8)) (= EC_346_1_346_1 ecReturn) (or (not (not (= ce_345_8 null))) (and (not (= ce_345_8 null)) (= tmp25_type_347_11 (S_select type_70_18_28 ce_345_8)) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (= resolved_347_1_347_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (not (= tmp25_type_347_11 null)))))))))))))) (and (= true_term true_term) (= RES_273_17_273_17 CLASSLITERAL_24_60_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_ClassLiteral))) (and (= true_term (is expr_263_52 T_javafe_ast_ClassLiteral)) (= cl_353_8 (cast expr_263_52 T_javafe_ast_ClassLiteral)) (or (not (not (= cl_353_8 null))) (and (not (= cl_353_8 null)) (= tmp26_type_354_11 (S_select type_71_20_28 cl_353_8)) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (= resolved_354_1_354_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (not (= tmp26_type_354_11 null)))))))))) (and (or (and (= true_term true_term) (= RES_273_17_273_17 OR_23_19_26)) (and (= true_term true_term) (= RES_273_17_273_17 AND_23_20_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITOR_23_21_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITXOR_23_22_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITAND_23_23_26)) (and (= true_term true_term) (= RES_273_17_273_17 NE_23_24_26)) (and (= true_term true_term) (= RES_273_17_273_17 EQ_23_25_26)) (and (= true_term true_term) (= RES_273_17_273_17 GE_23_26_26)) (and (= true_term true_term) (= RES_273_17_273_17 GT_23_27_26)) (and (= true_term true_term) (= RES_273_17_273_17 LE_23_28_26)) (and (= true_term true_term) (= RES_273_17_273_17 LT_23_29_26)) (and (= true_term true_term) (= RES_273_17_273_17 LSHIFT_23_30_26)) (and (= true_term true_term) (= RES_273_17_273_17 RSHIFT_23_31_26)) (and (= true_term true_term) (= RES_273_17_273_17 URSHIFT_23_32_26)) (and (= true_term true_term) (= RES_273_17_273_17 ADD_23_33_26)) (and (= true_term true_term) (= RES_273_17_273_17 SUB_23_34_26)) (and (= true_term true_term) (= RES_273_17_273_17 DIV_23_35_26)) (and (= true_term true_term) (= RES_273_17_273_17 MOD_23_36_26)) (and (= true_term true_term) (= RES_273_17_273_17 STAR_23_37_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASSIGN_23_40_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGMUL_23_41_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGDIV_23_42_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGREM_23_43_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGADD_23_44_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGSUB_23_45_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGLSHIFT_23_46_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGRSHIFT_23_47_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGURSHIFT_23_48_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITAND_23_49_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITOR_23_50_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITXOR_23_51_26))) (or (not (= true_term (is expr_263_52 T_javafe_ast_BinaryExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_BinaryExpr)) (= be_375_8 (cast expr_263_52 T_javafe_ast_BinaryExpr)) (or (not (not (= be_375_8 null))) (and (not (= be_375_8 null)) (or (and (= expr_376_1_376_1_263_52 (S_select left_72_38_28 be_375_8)) (not (and (not (= sig_263_39 null)) (not (= expr_376_1_376_1_263_52 null))))) (and (= expr_376_1_376_1_263_52 (S_select left_72_38_28 be_375_8)) (= EC_376_1_376_1 ecReturn) (or (not (not (= be_375_8 null))) (and (not (= be_375_8 null)) (= expr_377_1_377_1_263_52 (S_select right_72_40_28 be_375_8)) (not (and (not (= sig_263_39 null)) (not (= expr_377_1_377_1_263_52 null))))))))))))) (and (or (and (= true_term true_term) (= RES_273_17_273_17 UNARYSUB_23_55_26)) (and (= true_term true_term) (= RES_273_17_273_17 UNARYADD_23_54_26)) (and (= true_term true_term) (= RES_273_17_273_17 NOT_23_56_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITNOT_23_57_26)) (and (= true_term true_term) (= RES_273_17_273_17 INC_23_58_26)) (and (= true_term true_term) (= RES_273_17_273_17 DEC_23_59_26)) (and (= true_term true_term) (= RES_273_17_273_17 POSTFIXINC_23_62_26)) (and (= true_term true_term) (= RES_273_17_273_17 POSTFIXDEC_23_63_26))) (or (not (= true_term (is expr_263_52 T_javafe_ast_UnaryExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_UnaryExpr)) (or (not (not (= (cast expr_263_52 T_javafe_ast_UnaryExpr) null))) (and (not (= (cast expr_263_52 T_javafe_ast_UnaryExpr) null)) (= expr_385_6_385_6_263_52 (S_select expr_73_29_28 (cast expr_263_52 T_javafe_ast_UnaryExpr))) (not (and (not (= sig_263_39 null)) (not (= expr_385_6_385_6_263_52 null))))))))) (and (= true_term true_term) (= RES_273_17_273_17 PARENEXPR_24_54_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_ParenExpr))) (and (= true_term (is expr_263_52 T_javafe_ast_ParenExpr)) (or (not (not (= (cast expr_263_52 T_javafe_ast_ParenExpr) null))) (and (not (= (cast expr_263_52 T_javafe_ast_ParenExpr) null)) (= expr_389_6_389_6_263_52 (S_select expr_74_15_28 (cast expr_263_52 T_javafe_ast_ParenExpr))) (not (and (not (= sig_263_39 null)) (not (= expr_389_6_389_6_263_52 null))))))))) (and (= true_term true_term) (= RES_273_17_273_17 AMBIGUOUSVARIABLEACCESS_24_55_7) (not (not (= sig_263_39 null)))) (and (= true_term true_term) (= RES_273_17_273_17 VARIABLEACCESS_24_56_7) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (= b_397_13_397_13_17_20_40 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term b_397_13_397_13_17_20_40) (= EC_397_13_397_13 ecReturn) (or (not (= true_term (is expr_263_52 T_javafe_ast_VariableAccess))) (and (= true_term (is expr_263_52 T_javafe_ast_VariableAccess)) (not (not (= (cast expr_263_52 T_javafe_ast_VariableAccess) null)))))))) (and (= true_term true_term) (= RES_273_17_273_17 FIELDACCESS_24_57_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_FieldAccess))) (and (= true_term (is expr_263_52 T_javafe_ast_FieldAccess)) (= xp_403_1 (cast expr_263_52 T_javafe_ast_FieldAccess)) (or (not (not (= xp_403_1 null))) (and (not (= xp_403_1 null)) (or (and (= od_404_1_404_1_438_73 (S_select od_76_19_40 xp_403_1)) (not (and (not (= sig_263_39 null)) (not (= od_404_1_404_1_438_73 null))))) (and (= od_404_1_404_1_438_73 (S_select od_76_19_40 xp_403_1)) (= EC_404_1_404_1 ecReturn) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (or (and (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (not (not (= xp_403_1 null)))) (and (or (and (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (not (= xp_403_1 null)) (= tmp33_cand_406_6 (refEQ (S_select decl_76_28_19 xp_403_1) null)) (= tmp33_cand_406_34 tmp33_cand_406_6)) (and (not (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= tmp33_cand_406_34 false_term))) (not (= true_term tmp33_cand_406_34)) (not (not (= xp_403_1 null)))))))))))))) (and (= true_term true_term) (= RES_273_17_273_17 AMBIGUOUSMETHODINVOCATION_24_58_7) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (= b_413_8_413_8_17_20_40 (integralLT (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term b_413_8_413_8_17_20_40) (= EC_413_8_413_8 ecReturn) (or (not (= true_term (is expr_263_52 T_javafe_ast_AmbiguousMethodInvocation))) (and (= true_term (is expr_263_52 T_javafe_ast_AmbiguousMethodInvocation)) (= ami_414_1 (cast expr_263_52 T_javafe_ast_AmbiguousMethodInvocation)) (= 0 i_loopold_415_9) (= EC_413_8_413_8 EC_loopold_3_) (or (and (= true_term true_term) (or (not (not (= ami_414_1 null))) (and (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (< 0 RES_415_1_0_415_29_415_29) (or (not (not (= ami_414_1 null))) (and (not (= ami_414_1 null)) (= tmp36_args_415_1_0_416_18 (S_select args_77_32_31 ami_414_1)) (or (not (and (<= 0 0) (< 0 (S_select count_54_67_33 tmp36_args_415_1_0_416_18)))) (and (= true_term (is RES_415_1_0_416_27_416_27 T_javafe_ast_Expr)) (= true_term (isAllocated RES_415_1_0_416_27_416_27 alloc)) (= EC_415_1_0_416_27_416_27 ecReturn) (implies (= EC_415_1_0_416_27_416_27 ecReturn) (not (= RES_415_1_0_416_27_416_27 null))) (not (and (not (= sig_263_39 null)) (not (= RES_415_1_0_416_27_416_27 null))))))))))) (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (< 0 RES_415_1_0_415_29_415_29) (not (= ami_414_1 null)) (= tmp36_args_415_1_0_416_18 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_416_27_416_27 T_javafe_ast_Expr)) (= true_term (isAllocated RES_415_1_0_416_27_416_27 alloc)) (= EC_415_1_0_416_27_416_27 ecReturn) (implies (= EC_415_1_0_416_27_416_27 ecReturn) (not (= RES_415_1_0_416_27_416_27 null))) (= EC_415_1_0_416_3_416_3 ecReturn) (= i_415_1_0_415_37 (+ 0 1)) (= true_term true_term) (not (not (= ami_414_1 null)))))))))) (and (= true_term true_term) (= RES_273_17_273_17 METHODINVOCATION_24_59_7) (or (not (= true_term (is expr_263_52 T_javafe_ast_MethodInvocation))) (and (= true_term (is expr_263_52 T_javafe_ast_MethodInvocation)) (= mi_422_1 (cast expr_263_52 T_javafe_ast_MethodInvocation)) (or (not (not (= mi_422_1 null))) (and (not (= mi_422_1 null)) (or (and (= od_423_1_423_1_438_73 (S_select od_78_18_40 mi_422_1)) (not (and (not (= sig_263_39 null)) (not (= od_423_1_423_1_438_73 null))))) (and (= od_423_1_423_1_438_73 (S_select od_78_18_40 mi_422_1)) (= EC_423_1_423_1 ecReturn) (or (and (= 0 i_loopold_424_9) (= EC_423_1_423_1 EC_loopold_4_) (or (and (= true_term true_term) (or (not (not (= mi_422_1 null))) (and (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (< 0 RES_424_1_0_424_28_424_28) (or (not (not (= mi_422_1 null))) (and (not (= mi_422_1 null)) (= tmp41_args_424_1_0_425_18 (S_select args_78_30_31 mi_422_1)) (or (not (and (<= 0 0) (< 0 (S_select count_54_67_33 tmp41_args_424_1_0_425_18)))) (and (= true_term (is RES_424_1_0_425_26_425_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_424_1_0_425_26_425_26 alloc)) (= EC_424_1_0_425_26_425_26 ecReturn) (implies (= EC_424_1_0_425_26_425_26 ecReturn) (not (= RES_424_1_0_425_26_425_26 null))) (not (and (not (= sig_263_39 null)) (not (= RES_424_1_0_425_26_425_26 null))))))))))) (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (< 0 RES_424_1_0_424_28_424_28) (not (= mi_422_1 null)) (= tmp41_args_424_1_0_425_18 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_425_26_425_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_424_1_0_425_26_425_26 alloc)) (= EC_424_1_0_425_26_425_26 ecReturn) (implies (= EC_424_1_0_425_26_425_26 ecReturn) (not (= RES_424_1_0_425_26_425_26 null))) (= EC_424_1_0_425_3_425_3 ecReturn) (= i_424_1_0_424_36 (+ 0 1)) (= true_term true_term) (not (not (= mi_422_1 null)))))) (and (= 0 i_loopold_424_9) (= EC_423_1_423_1 EC_loopold_4_) (or (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (not (< 0 RES_424_1_0_424_28_424_28)) (= RES_6_ RES_424_1_0_424_28_424_28)) (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (< 0 RES_424_1_0_424_28_424_28) (not (= mi_422_1 null)) (= tmp41_args_424_1_0_425_18 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_425_26_425_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_424_1_0_425_26_425_26 alloc)) (= EC_424_1_0_425_26_425_26 ecReturn) (implies (= EC_424_1_0_425_26_425_26 ecReturn) (not (= RES_424_1_0_425_26_425_26 null))) (= EC_424_1_0_425_3_425_3 ecReturn) (= i_424_1_0_424_36 (+ 0 1)) (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_1_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_1_424_28_424_28 T_int)) (= EC_424_1_1_424_28_424_28 ecReturn) (implies (= EC_424_1_1_424_28_424_28 ecReturn) (= RES_424_1_1_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_1_424_28))) (not (< i_424_1_0_424_36 RES_424_1_1_424_28_424_28)) (= RES_6_ RES_424_1_1_424_28_424_28))) (= L_424_1 L_424_1) (= RES_7_ RES_6_) (= EC_5_ L_424_1) (or (not (not (= sig_263_39 null))) (and (not (= sig_263_39 null)) (or (and (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (not (not (= mi_422_1 null)))) (and (or (and (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (not (= mi_422_1 null)) (= tmp44_cand_426_18 (refEQ (S_select decl_78_34_20 mi_422_1) null)) (= tmp44_cand_427_3 tmp44_cand_426_18)) (and (not (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= tmp44_cand_427_3 false_term))) (not (= true_term tmp44_cand_427_3)) (not (not (= mi_422_1 null)))))))))))))))) (and (= true_term true_term) (not (= RES_273_17_273_17 ARRAYINIT_24_46_7)) (not (= RES_273_17_273_17 THISEXPR_24_47_7)) (not (= RES_273_17_273_17 STRINGLIT_22_44_26)) (not (= RES_273_17_273_17 CHARLIT_22_41_26)) (not (= RES_273_17_273_17 BOOLEANLIT_22_38_26)) (not (= RES_273_17_273_17 FLOATLIT_22_42_26)) (not (= RES_273_17_273_17 DOUBLELIT_22_43_26)) (not (= RES_273_17_273_17 INTLIT_22_39_26)) (not (= RES_273_17_273_17 LONGLIT_22_40_26)) (not (= RES_273_17_273_17 NULLLIT_22_45_26)) (not (= RES_273_17_273_17 ARRAYREFEXPR_24_48_7)) (not (= RES_273_17_273_17 NEWINSTANCEEXPR_24_49_7)) (not (= RES_273_17_273_17 NEWARRAYEXPR_24_50_7)) (not (= RES_273_17_273_17 CONDEXPR_24_51_7)) (not (= RES_273_17_273_17 INSTANCEOFEXPR_24_52_7)) (not (= RES_273_17_273_17 CASTEXPR_24_53_7)) (not (= RES_273_17_273_17 CLASSLITERAL_24_60_7)) (not (= RES_273_17_273_17 OR_23_19_26)) (not (= RES_273_17_273_17 AND_23_20_26)) (not (= RES_273_17_273_17 BITOR_23_21_26)) (not (= RES_273_17_273_17 BITXOR_23_22_26)) (not (= RES_273_17_273_17 BITAND_23_23_26)) (not (= RES_273_17_273_17 NE_23_24_26)) (not (= RES_273_17_273_17 EQ_23_25_26)) (not (= RES_273_17_273_17 GE_23_26_26)) (not (= RES_273_17_273_17 GT_23_27_26)) (not (= RES_273_17_273_17 LE_23_28_26)) (not (= RES_273_17_273_17 LT_23_29_26)) (not (= RES_273_17_273_17 LSHIFT_23_30_26)) (not (= RES_273_17_273_17 RSHIFT_23_31_26)) (not (= RES_273_17_273_17 URSHIFT_23_32_26)) (not (= RES_273_17_273_17 ADD_23_33_26)) (not (= RES_273_17_273_17 SUB_23_34_26)) (not (= RES_273_17_273_17 DIV_23_35_26)) (not (= RES_273_17_273_17 MOD_23_36_26)) (not (= RES_273_17_273_17 STAR_23_37_26)) (not (= RES_273_17_273_17 ASSIGN_23_40_26)) (not (= RES_273_17_273_17 ASGMUL_23_41_26)) (not (= RES_273_17_273_17 ASGDIV_23_42_26)) (not (= RES_273_17_273_17 ASGREM_23_43_26)) (not (= RES_273_17_273_17 ASGADD_23_44_26)) (not (= RES_273_17_273_17 ASGSUB_23_45_26)) (not (= RES_273_17_273_17 ASGLSHIFT_23_46_26)) (not (= RES_273_17_273_17 ASGRSHIFT_23_47_26)) (not (= RES_273_17_273_17 ASGURSHIFT_23_48_26)) (not (= RES_273_17_273_17 ASGBITAND_23_49_26)) (not (= RES_273_17_273_17 ASGBITOR_23_50_26)) (not (= RES_273_17_273_17 ASGBITXOR_23_51_26)) (not (= RES_273_17_273_17 UNARYSUB_23_55_26)) (not (= RES_273_17_273_17 UNARYADD_23_54_26)) (not (= RES_273_17_273_17 NOT_23_56_26)) (not (= RES_273_17_273_17 BITNOT_23_57_26)) (not (= RES_273_17_273_17 INC_23_58_26)) (not (= RES_273_17_273_17 DEC_23_59_26)) (not (= RES_273_17_273_17 POSTFIXINC_23_62_26)) (not (= RES_273_17_273_17 POSTFIXDEC_23_63_26)) (not (= RES_273_17_273_17 PARENEXPR_24_54_7)) (not (= RES_273_17_273_17 AMBIGUOUSVARIABLEACCESS_24_55_7)) (not (= RES_273_17_273_17 VARIABLEACCESS_24_56_7)) (not (= RES_273_17_273_17 FIELDACCESS_24_57_7)) (not (= RES_273_17_273_17 AMBIGUOUSMETHODINVOCATION_24_58_7)) (not (= RES_273_17_273_17 METHODINVOCATION_24_59_7)) (not (not (= expr_263_52 null)))))))))) (and (or (and (not (= sig_263_39 null)) (or (and (>= (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (= true_term true_term) (or (and (= true_term (is expr_263_52 T_javafe_ast_Expr)) (not (= expr_263_52 null)) (= true_term true_term) (= true_term (is expr_263_52 T_javafe_ast_Expr)) (= i_270_23_270_23_62_1881_40 (cast expr_263_52 T_javafe_ast_Expr)) (not (= i_270_23_270_23_62_1881_40 null)) (= true_term (is RES_270_23_270_23 T_javafe_ast_Type)) (= true_term (isAllocated RES_270_23_270_23 alloc)) (= EC_270_23_270_23 ecReturn) (implies (= EC_270_23_270_23 ecReturn) (not (= RES_270_23_270_23 null))) (= RES RES_270_23_270_23) (= EC EC_270_23_270_23)) (and (not (and (= true_term (is expr_263_52 T_javafe_ast_Expr)) (not (= expr_263_52 null)))) (= true_term true_term) (= RES RES_1_) (= EC EC_1_))) (= RES_2_ RES) (= EC_2_ EC)) (and (not (>= (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= RES_2_ RES_1_) (= EC_2_ EC_1_))) (not (= expr_263_52 null)) (= true_term (is RES_273_17_273_17 T_int)) (= EC_273_17_273_17 ecReturn) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_LiteralExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select tag_98_32_13 (cast expr_263_52 T_javafe_ast_LiteralExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_BinaryExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select op_72_35_13 (cast expr_263_52 T_javafe_ast_BinaryExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_UnaryExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select op_73_26_13 (cast expr_263_52 T_javafe_ast_UnaryExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_PrimitiveType)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select tag_99_30_13 (cast expr_263_52 T_javafe_ast_PrimitiveType)))) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPESIG_20_6_28)) (= (PO_LT (typeof expr_263_52) T_javafe_tc_TypeSig) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 COMPILATIONUNIT_24_14_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CompilationUnit) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SINGLETYPEIMPORTDECL_24_15_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SingleTypeImportDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ONDEMANDIMPORTDECL_24_16_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_OnDemandImportDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSDECL_24_17_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTERFACEDECL_24_18_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InterfaceDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONSTRUCTORDECL_24_19_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ConstructorDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 METHODDECL_24_20_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_MethodDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INITBLOCK_24_21_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InitBlock) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LOCALVARDECL_24_22_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LocalVarDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FIELDDECL_24_23_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FieldDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FORMALPARADECL_24_24_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FormalParaDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BLOCKSTMT_24_25_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BlockStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SWITCHSTMT_24_26_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SwitchStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VARDECLSTMT_24_27_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_VarDeclStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSDECLSTMT_24_28_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassDeclStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 WHILESTMT_24_29_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_WhileStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOSTMT_24_30_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_DoStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SYNCHRONIZESTMT_24_31_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SynchronizeStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EVALSTMT_24_32_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_EvalStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 RETURNSTMT_24_33_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ReturnStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 THROWSTMT_24_34_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ThrowStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BREAKSTMT_24_35_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BreakStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONTINUESTMT_24_36_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ContinueStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LABELSTMT_24_37_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LabelStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 IFSTMT_24_38_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_IfStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FORSTMT_24_39_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ForStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SKIPSTMT_24_40_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SkipStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SWITCHLABEL_24_41_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SwitchLabel) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TRYFINALLYSTMT_24_42_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TryFinallyStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TRYCATCHSTMT_24_43_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TryCatchStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONSTRUCTORINVOCATION_24_44_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ConstructorInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CATCHCLAUSE_24_45_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CatchClause) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYINIT_24_46_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayInit) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 THISEXPR_24_47_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ThisExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYREFEXPR_24_48_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayRefExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NEWINSTANCEEXPR_24_49_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_NewInstanceExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NEWARRAYEXPR_24_50_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_NewArrayExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONDEXPR_24_51_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CondExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INSTANCEOFEXPR_24_52_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InstanceOfExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CASTEXPR_24_53_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CastExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 PARENEXPR_24_54_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ParenExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AMBIGUOUSVARIABLEACCESS_24_55_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_AmbiguousVariableAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VARIABLEACCESS_24_56_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_VariableAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FIELDACCESS_24_57_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FieldAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AMBIGUOUSMETHODINVOCATION_24_58_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_AmbiguousMethodInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 METHODINVOCATION_24_59_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_MethodInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSLITERAL_24_60_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassLiteral) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EXPROBJECTDESIGNATOR_24_61_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ExprObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPEOBJECTDESIGNATOR_24_62_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TypeObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SUPEROBJECTDESIGNATOR_24_63_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SuperObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPENAME_24_64_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TypeName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYTYPE_24_65_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SIMPLENAME_24_66_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SimpleName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 COMPOUNDNAME_24_67_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CompoundName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 OR_23_19_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AND_23_20_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITOR_23_21_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITXOR_23_22_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITAND_23_23_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NE_23_24_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EQ_23_25_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 GE_23_26_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 GT_23_27_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LE_23_28_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LT_23_29_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LSHIFT_23_30_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 RSHIFT_23_31_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 URSHIFT_23_32_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ADD_23_33_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SUB_23_34_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DIV_23_35_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 MOD_23_36_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 STAR_23_37_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASSIGN_23_40_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGMUL_23_41_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGDIV_23_42_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGREM_23_43_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGADD_23_44_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGSUB_23_45_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGLSHIFT_23_46_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGRSHIFT_23_47_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGURSHIFT_23_48_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITAND_23_49_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITOR_23_50_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITXOR_23_51_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 UNARYADD_23_54_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 UNARYSUB_23_55_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NOT_23_56_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITNOT_23_57_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INC_23_58_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DEC_23_59_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 POSTFIXINC_23_62_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 POSTFIXDEC_23_63_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BOOLEANTYPE_22_27_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTTYPE_22_28_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LONGTYPE_22_29_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CHARTYPE_22_30_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FLOATTYPE_22_31_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOUBLETYPE_22_32_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VOIDTYPE_22_33_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NULLTYPE_22_34_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BYTETYPE_22_35_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SHORTTYPE_22_36_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BOOLEANLIT_22_38_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTLIT_22_39_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LONGLIT_22_40_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CHARLIT_22_41_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FLOATLIT_22_42_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOUBLELIT_22_43_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 STRINGLIT_22_44_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NULLLIT_22_45_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (or (and (= true_term true_term) (not (= RES_273_17_273_17 ARRAYINIT_24_46_7)) (not (= RES_273_17_273_17 THISEXPR_24_47_7)) (not (= RES_273_17_273_17 STRINGLIT_22_44_26)) (not (= RES_273_17_273_17 CHARLIT_22_41_26)) (not (= RES_273_17_273_17 BOOLEANLIT_22_38_26)) (not (= RES_273_17_273_17 FLOATLIT_22_42_26)) (not (= RES_273_17_273_17 DOUBLELIT_22_43_26)) (not (= RES_273_17_273_17 INTLIT_22_39_26)) (not (= RES_273_17_273_17 LONGLIT_22_40_26)) (not (= RES_273_17_273_17 NULLLIT_22_45_26)) (not (= RES_273_17_273_17 ARRAYREFEXPR_24_48_7)) (not (= RES_273_17_273_17 NEWINSTANCEEXPR_24_49_7)) (not (= RES_273_17_273_17 NEWARRAYEXPR_24_50_7)) (not (= RES_273_17_273_17 CONDEXPR_24_51_7)) (not (= RES_273_17_273_17 INSTANCEOFEXPR_24_52_7)) (not (= RES_273_17_273_17 CASTEXPR_24_53_7)) (not (= RES_273_17_273_17 CLASSLITERAL_24_60_7)) (not (= RES_273_17_273_17 OR_23_19_26)) (not (= RES_273_17_273_17 AND_23_20_26)) (not (= RES_273_17_273_17 BITOR_23_21_26)) (not (= RES_273_17_273_17 BITXOR_23_22_26)) (not (= RES_273_17_273_17 BITAND_23_23_26)) (not (= RES_273_17_273_17 NE_23_24_26)) (not (= RES_273_17_273_17 EQ_23_25_26)) (not (= RES_273_17_273_17 GE_23_26_26)) (not (= RES_273_17_273_17 GT_23_27_26)) (not (= RES_273_17_273_17 LE_23_28_26)) (not (= RES_273_17_273_17 LT_23_29_26)) (not (= RES_273_17_273_17 LSHIFT_23_30_26)) (not (= RES_273_17_273_17 RSHIFT_23_31_26)) (not (= RES_273_17_273_17 URSHIFT_23_32_26)) (not (= RES_273_17_273_17 ADD_23_33_26)) (not (= RES_273_17_273_17 SUB_23_34_26)) (not (= RES_273_17_273_17 DIV_23_35_26)) (not (= RES_273_17_273_17 MOD_23_36_26)) (not (= RES_273_17_273_17 STAR_23_37_26)) (not (= RES_273_17_273_17 ASSIGN_23_40_26)) (not (= RES_273_17_273_17 ASGMUL_23_41_26)) (not (= RES_273_17_273_17 ASGDIV_23_42_26)) (not (= RES_273_17_273_17 ASGREM_23_43_26)) (not (= RES_273_17_273_17 ASGADD_23_44_26)) (not (= RES_273_17_273_17 ASGSUB_23_45_26)) (not (= RES_273_17_273_17 ASGLSHIFT_23_46_26)) (not (= RES_273_17_273_17 ASGRSHIFT_23_47_26)) (not (= RES_273_17_273_17 ASGURSHIFT_23_48_26)) (not (= RES_273_17_273_17 ASGBITAND_23_49_26)) (not (= RES_273_17_273_17 ASGBITOR_23_50_26)) (not (= RES_273_17_273_17 ASGBITXOR_23_51_26)) (not (= RES_273_17_273_17 UNARYSUB_23_55_26)) (not (= RES_273_17_273_17 UNARYADD_23_54_26)) (not (= RES_273_17_273_17 NOT_23_56_26)) (not (= RES_273_17_273_17 BITNOT_23_57_26)) (not (= RES_273_17_273_17 INC_23_58_26)) (not (= RES_273_17_273_17 DEC_23_59_26)) (not (= RES_273_17_273_17 POSTFIXINC_23_62_26)) (not (= RES_273_17_273_17 POSTFIXDEC_23_63_26)) (not (= RES_273_17_273_17 PARENEXPR_24_54_7)) (not (= RES_273_17_273_17 AMBIGUOUSVARIABLEACCESS_24_55_7)) (not (= RES_273_17_273_17 VARIABLEACCESS_24_56_7)) (not (= RES_273_17_273_17 FIELDACCESS_24_57_7)) (not (= RES_273_17_273_17 AMBIGUOUSMETHODINVOCATION_24_58_7)) (not (= RES_273_17_273_17 METHODINVOCATION_24_59_7)) (not (= expr_263_52 null)) (= true_term (is RES_432_48_432_48 T_int)) (= EC_432_48_432_48 ecReturn) (implies (and (= EC_432_48_432_48 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_LiteralExpr)) (not (= expr_263_52 null))) (= RES_432_48_432_48 (S_select tag_98_32_13 (cast expr_263_52 T_javafe_ast_LiteralExpr)))) (implies (and (= EC_432_48_432_48 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_BinaryExpr)) (not (= expr_263_52 null))) (= RES_432_48_432_48 (S_select op_72_35_13 (cast expr_263_52 T_javafe_ast_BinaryExpr)))) (implies (and (= EC_432_48_432_48 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_UnaryExpr)) (not (= expr_263_52 null))) (= RES_432_48_432_48 (S_select op_73_26_13 (cast expr_263_52 T_javafe_ast_UnaryExpr)))) (implies (and (= EC_432_48_432_48 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_PrimitiveType)) (not (= expr_263_52 null))) (= RES_432_48_432_48 (S_select tag_99_30_13 (cast expr_263_52 T_javafe_ast_PrimitiveType)))) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 TYPESIG_20_6_28)) (= (PO_LT (typeof expr_263_52) T_javafe_tc_TypeSig) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 COMPILATIONUNIT_24_14_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CompilationUnit) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SINGLETYPEIMPORTDECL_24_15_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SingleTypeImportDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ONDEMANDIMPORTDECL_24_16_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_OnDemandImportDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CLASSDECL_24_17_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 INTERFACEDECL_24_18_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InterfaceDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CONSTRUCTORDECL_24_19_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ConstructorDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 METHODDECL_24_20_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_MethodDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 INITBLOCK_24_21_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InitBlock) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 LOCALVARDECL_24_22_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LocalVarDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 FIELDDECL_24_23_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FieldDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 FORMALPARADECL_24_24_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FormalParaDecl) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BLOCKSTMT_24_25_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BlockStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SWITCHSTMT_24_26_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SwitchStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 VARDECLSTMT_24_27_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_VarDeclStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CLASSDECLSTMT_24_28_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassDeclStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 WHILESTMT_24_29_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_WhileStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 DOSTMT_24_30_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_DoStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SYNCHRONIZESTMT_24_31_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SynchronizeStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 EVALSTMT_24_32_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_EvalStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 RETURNSTMT_24_33_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ReturnStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 THROWSTMT_24_34_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ThrowStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BREAKSTMT_24_35_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BreakStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CONTINUESTMT_24_36_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ContinueStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 LABELSTMT_24_37_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LabelStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 IFSTMT_24_38_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_IfStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 FORSTMT_24_39_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ForStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SKIPSTMT_24_40_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SkipStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SWITCHLABEL_24_41_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SwitchLabel) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 TRYFINALLYSTMT_24_42_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TryFinallyStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 TRYCATCHSTMT_24_43_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TryCatchStmt) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CONSTRUCTORINVOCATION_24_44_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ConstructorInvocation) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CATCHCLAUSE_24_45_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CatchClause) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ARRAYINIT_24_46_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayInit) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 THISEXPR_24_47_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ThisExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ARRAYREFEXPR_24_48_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayRefExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 NEWINSTANCEEXPR_24_49_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_NewInstanceExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 NEWARRAYEXPR_24_50_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_NewArrayExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CONDEXPR_24_51_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CondExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 INSTANCEOFEXPR_24_52_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InstanceOfExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CASTEXPR_24_53_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CastExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 PARENEXPR_24_54_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ParenExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 AMBIGUOUSVARIABLEACCESS_24_55_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_AmbiguousVariableAccess) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 VARIABLEACCESS_24_56_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_VariableAccess) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 FIELDACCESS_24_57_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FieldAccess) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 AMBIGUOUSMETHODINVOCATION_24_58_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_AmbiguousMethodInvocation) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 METHODINVOCATION_24_59_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_MethodInvocation) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CLASSLITERAL_24_60_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassLiteral) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 EXPROBJECTDESIGNATOR_24_61_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ExprObjectDesignator) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 TYPEOBJECTDESIGNATOR_24_62_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TypeObjectDesignator) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SUPEROBJECTDESIGNATOR_24_63_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SuperObjectDesignator) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 TYPENAME_24_64_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TypeName) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ARRAYTYPE_24_65_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SIMPLENAME_24_66_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SimpleName) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 COMPOUNDNAME_24_67_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CompoundName) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 OR_23_19_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 AND_23_20_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BITOR_23_21_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BITXOR_23_22_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BITAND_23_23_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 NE_23_24_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 EQ_23_25_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 GE_23_26_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 GT_23_27_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 LE_23_28_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 LT_23_29_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 LSHIFT_23_30_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 RSHIFT_23_31_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 URSHIFT_23_32_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ADD_23_33_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SUB_23_34_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 DIV_23_35_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 MOD_23_36_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 STAR_23_37_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASSIGN_23_40_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGMUL_23_41_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGDIV_23_42_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGREM_23_43_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGADD_23_44_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGSUB_23_45_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGLSHIFT_23_46_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGRSHIFT_23_47_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGURSHIFT_23_48_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGBITAND_23_49_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGBITOR_23_50_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 ASGBITXOR_23_51_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 UNARYADD_23_54_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 UNARYSUB_23_55_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 NOT_23_56_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BITNOT_23_57_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 INC_23_58_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 DEC_23_59_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 POSTFIXINC_23_62_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 POSTFIXDEC_23_63_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BOOLEANTYPE_22_27_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 INTTYPE_22_28_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 LONGTYPE_22_29_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CHARTYPE_22_30_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 FLOATTYPE_22_31_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 DOUBLETYPE_22_32_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 VOIDTYPE_22_33_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 NULLTYPE_22_34_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BYTETYPE_22_35_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 SHORTTYPE_22_36_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 BOOLEANLIT_22_38_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 INTLIT_22_39_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 LONGLIT_22_40_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 CHARLIT_22_41_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 FLOATLIT_22_42_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 DOUBLELIT_22_43_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 STRINGLIT_22_44_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_432_48_432_48 ecReturn) (= RES_432_48_432_48 NULLLIT_22_45_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (= msg_432_20_432_20_17_15_35 (stringCat S_432_25 RES_432_48_432_48)) (= EC_432_20_432_20 ecReturn) (not (= EC_432_20_432_20 ecReturn)) (= EC_6_ EC_432_20_432_20)) (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (= true_term true_term) (= RES_273_17_273_17 ARRAYINIT_24_46_7) (= true_term (is expr_263_52 T_javafe_ast_ArrayInit)) (= ai_276_1 (cast expr_263_52 T_javafe_ast_ArrayInit)) (or (and (= EC_273_17_273_17 EC_loopold) (= 0 i_loopold_277_9) (or (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (not (< 0 RES_277_1_0_277_29_277_29)) (= RES_8_ RES_277_1_0_277_29_277_29)) (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (< 0 RES_277_1_0_277_29_277_29) (not (= ai_276_1 null)) (= tmp3_elems_277_1_0_278_18 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_278_27_278_27 T_javafe_ast_VarInit)) (= true_term (isAllocated RES_277_1_0_278_27_278_27 alloc)) (= EC_277_1_0_278_27_278_27 ecReturn) (implies (= EC_277_1_0_278_27_278_27 ecReturn) (not (= RES_277_1_0_278_27_278_27 null))) (= EC_277_1_0_278_3_278_3 ecReturn) (= i_277_1_0_277_37 (+ 0 1)) (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_1_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_1_277_29_277_29 T_int)) (= EC_277_1_1_277_29_277_29 ecReturn) (implies (= EC_277_1_1_277_29_277_29 ecReturn) (= RES_277_1_1_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_1_277_29))) (not (< i_277_1_0_277_37 RES_277_1_1_277_29_277_29)) (= RES_8_ RES_277_1_1_277_29_277_29))) (not (= L_277_1 L_277_1)) (= RES_276_16 RES_8_) (= EC_276_16 L_277_1)) (and (= EC_273_17_273_17 EC_loopold) (= 0 i_loopold_277_9) (or (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (not (< 0 RES_277_1_0_277_29_277_29)) (= RES_8_ RES_277_1_0_277_29_277_29)) (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (< 0 RES_277_1_0_277_29_277_29) (not (= ai_276_1 null)) (= tmp3_elems_277_1_0_278_18 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_278_27_278_27 T_javafe_ast_VarInit)) (= true_term (isAllocated RES_277_1_0_278_27_278_27 alloc)) (= EC_277_1_0_278_27_278_27 ecReturn) (implies (= EC_277_1_0_278_27_278_27 ecReturn) (not (= RES_277_1_0_278_27_278_27 null))) (= EC_277_1_0_278_3_278_3 ecReturn) (= i_277_1_0_277_37 (+ 0 1)) (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_1_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_1_277_29_277_29 T_int)) (= EC_277_1_1_277_29_277_29 ecReturn) (implies (= EC_277_1_1_277_29_277_29 ecReturn) (= RES_277_1_1_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_1_277_29))) (not (< i_277_1_0_277_37 RES_277_1_1_277_29_277_29)) (= RES_8_ RES_277_1_1_277_29_277_29))) (= L_277_1 L_277_1) (= RES_9_ RES_8_) (= EC_7_ L_277_1) (= true_term true_term) (= RES_276_16 RES_9_) (= EC_276_16 ecReturn))) (= RES_10_ RES_276_16) (= EC_8_ EC_276_16)) (and (or (and (= true_term true_term) (= RES_273_17_273_17 THISEXPR_24_47_7)) (and (= true_term true_term) (= RES_273_17_273_17 STRINGLIT_22_44_26)) (and (= true_term true_term) (= RES_273_17_273_17 CHARLIT_22_41_26)) (and (= true_term true_term) (= RES_273_17_273_17 BOOLEANLIT_22_38_26)) (and (= true_term true_term) (= RES_273_17_273_17 FLOATLIT_22_42_26)) (and (= true_term true_term) (= RES_273_17_273_17 DOUBLELIT_22_43_26)) (and (= true_term true_term) (= RES_273_17_273_17 INTLIT_22_39_26)) (and (= true_term true_term) (= RES_273_17_273_17 LONGLIT_22_40_26)) (and (= true_term true_term) (= RES_273_17_273_17 NULLLIT_22_45_26))) (= true_term true_term) (= RES_10_ RES_273_17_273_17) (= EC_8_ ecReturn))) (= RES_11_ RES_10_) (= EC_9_ EC_8_)) (and (= true_term true_term) (= RES_273_17_273_17 ARRAYREFEXPR_24_48_7) (= true_term (is expr_263_52 T_javafe_ast_ArrayRefExpr)) (= r_293_8 (cast expr_263_52 T_javafe_ast_ArrayRefExpr)) (not (= r_293_8 null)) (= expr_294_1_294_1_263_52 (S_select array_65_15_28 r_293_8)) (= EC_294_1_294_1 ecReturn) (not (= r_293_8 null)) (= expr_295_1_295_1_263_52 (S_select index_65_17_28 r_293_8)) (= EC_295_1_295_1 ecReturn) (= true_term true_term) (= RES_11_ RES_295_1_295_1) (= EC_9_ ecReturn))) (= RES_12_ RES_11_) (= EC_10_ EC_9_)) (and (= true_term true_term) (= RES_273_17_273_17 NEWINSTANCEEXPR_24_49_7) (= true_term (is expr_263_52 T_javafe_ast_NewInstanceExpr)) (= ne_301_8 (cast expr_263_52 T_javafe_ast_NewInstanceExpr)) (not (= ne_301_8 null)) (or (and (not (= (S_select enclosingInstance_66_25_14 ne_301_8) null)) (= true_term true_term) (not (= ne_301_8 null)) (= expr_303_5_303_5_263_52 (S_select enclosingInstance_66_25_14 ne_301_8)) (= EC_303_5_303_5 ecReturn) (= RES_3_ RES_303_5_303_5) (= EC_3_ EC_303_5_303_5)) (and (not (not (= (S_select enclosingInstance_66_25_14 ne_301_8) null))) (= true_term true_term) (= RES_3_ RES_273_17_273_17) (= EC_3_ EC_273_17_273_17))) (not (= ne_301_8 null)) (= tmp8_type_304_11 (S_select type_66_32_32 ne_301_8)) (not (= sig_263_39 null)) (= resolved_304_1_304_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp8_type_304_11 null)) (= EC_304_1_304_1 ecReturn) (or (and (= 0 i_loopold_305_9) (= EC_304_1_304_1 EC_loopold_1_) (or (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (not (< 0 RES_305_1_0_305_28_305_28)) (= RES_4_ RES_305_1_0_305_28_305_28)) (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (< 0 RES_305_1_0_305_28_305_28) (not (= ne_301_8 null)) (= tmp11_args_305_1_0_306_18 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_306_26_306_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_305_1_0_306_26_306_26 alloc)) (= EC_305_1_0_306_26_306_26 ecReturn) (implies (= EC_305_1_0_306_26_306_26 ecReturn) (not (= RES_305_1_0_306_26_306_26 null))) (= EC_305_1_0_306_3_306_3 ecReturn) (= i_305_1_0_305_36 (+ 0 1)) (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_1_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_1_305_28_305_28 T_int)) (= EC_305_1_1_305_28_305_28 ecReturn) (implies (= EC_305_1_1_305_28_305_28 ecReturn) (= RES_305_1_1_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_1_305_28))) (not (< i_305_1_0_305_36 RES_305_1_1_305_28_305_28)) (= RES_4_ RES_305_1_1_305_28_305_28))) (not (= L_305_1 L_305_1)) (= RES_301_29 RES_4_) (= EC_301_29 L_305_1)) (and (= 0 i_loopold_305_9) (= EC_304_1_304_1 EC_loopold_1_) (or (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (not (< 0 RES_305_1_0_305_28_305_28)) (= RES_4_ RES_305_1_0_305_28_305_28)) (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (< 0 RES_305_1_0_305_28_305_28) (not (= ne_301_8 null)) (= tmp11_args_305_1_0_306_18 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_306_26_306_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_305_1_0_306_26_306_26 alloc)) (= EC_305_1_0_306_26_306_26 ecReturn) (implies (= EC_305_1_0_306_26_306_26 ecReturn) (not (= RES_305_1_0_306_26_306_26 null))) (= EC_305_1_0_306_3_306_3 ecReturn) (= i_305_1_0_305_36 (+ 0 1)) (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_1_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_1_305_28_305_28 T_int)) (= EC_305_1_1_305_28_305_28 ecReturn) (implies (= EC_305_1_1_305_28_305_28 ecReturn) (= RES_305_1_1_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_1_305_28))) (not (< i_305_1_0_305_36 RES_305_1_1_305_28_305_28)) (= RES_4_ RES_305_1_1_305_28_305_28))) (= L_305_1 L_305_1) (= RES_5_ RES_4_) (= EC_4_ L_305_1) (not (= ne_301_8 null)) (or (and (not (= (S_select anonDecl_66_45_19 ne_301_8) null)) (not (= sig_263_39 null)) (= tmp13_cand_308_5 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= tmp13_cand_308_23 tmp13_cand_308_5)) (and (not (not (= (S_select anonDecl_66_45_19 ne_301_8) null))) (= true_term true_term) (= tmp13_cand_308_23 false_term))) (or (and (= true_term tmp13_cand_308_23) (= true_term true_term) (not (= ne_301_8 null)) (not (= (S_select anonDecl_66_45_19 ne_301_8) null)) (= d_309_32_309_32_5_115_56 (S_select anonDecl_66_45_19 ne_301_8)) (= true_term (is RES_309_32_309_32 T_javafe_tc_TypeSig)) (= true_term (isAllocated RES_309_32_309_32 alloc)) (= EC_309_32_309_32 ecReturn) (implies (= EC_309_32_309_32 ecReturn) (not (= RES_309_32_309_32 null))) (not (= RES_309_32_309_32 null)) (= EC_309_5_309_5 ecReturn) (= RES_13_ RES_309_5_309_5) (= EC_11_ EC_309_5_309_5)) (and (not (= true_term tmp13_cand_308_23)) (= true_term true_term) (= RES_13_ RES_5_) (= EC_11_ EC_4_))) (= true_term true_term) (= RES_301_29 RES_13_) (= EC_301_29 ecReturn))) (= RES_12_ RES_301_29) (= EC_10_ EC_301_29))) (= RES_14_ RES_12_) (= EC_12_ EC_10_)) (and (= true_term true_term) (= RES_273_17_273_17 NEWARRAYEXPR_24_50_7) (= true_term (is expr_263_52 T_javafe_ast_NewArrayExpr)) (= na_319_8 (cast expr_263_52 T_javafe_ast_NewArrayExpr)) (not (= na_319_8 null)) (= tmp14_type_320_11 (S_select type_67_24_28 na_319_8)) (not (= sig_263_39 null)) (= resolved_320_1_320_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp14_type_320_11 null)) (= EC_320_1_320_1 ecReturn) (or (and (= EC_320_1_320_1 EC_loopold_2_) (= 0 i_loopold_321_9) (or (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (not (< 0 RES_321_1_0_321_28_321_28)) (= RES_15_ RES_321_1_0_321_28_321_28)) (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (< 0 RES_321_1_0_321_28_321_28) (not (= na_319_8 null)) (= tmp17_dims_321_1_0_322_18 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_322_26_322_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_321_1_0_322_26_322_26 alloc)) (= EC_321_1_0_322_26_322_26 ecReturn) (implies (= EC_321_1_0_322_26_322_26 ecReturn) (not (= RES_321_1_0_322_26_322_26 null))) (= EC_321_1_0_322_3_322_3 ecReturn) (= i_321_1_0_321_36 (+ 0 1)) (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_1_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_1_321_28_321_28 T_int)) (= EC_321_1_1_321_28_321_28 ecReturn) (implies (= EC_321_1_1_321_28_321_28 ecReturn) (= RES_321_1_1_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_1_321_28))) (not (< i_321_1_0_321_36 RES_321_1_1_321_28_321_28)) (= RES_15_ RES_321_1_1_321_28_321_28))) (not (= L_321_1 L_321_1)) (= RES_319_26 RES_15_) (= EC_319_26 L_321_1)) (and (= EC_320_1_320_1 EC_loopold_2_) (= 0 i_loopold_321_9) (or (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (not (< 0 RES_321_1_0_321_28_321_28)) (= RES_15_ RES_321_1_0_321_28_321_28)) (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (< 0 RES_321_1_0_321_28_321_28) (not (= na_319_8 null)) (= tmp17_dims_321_1_0_322_18 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_322_26_322_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_321_1_0_322_26_322_26 alloc)) (= EC_321_1_0_322_26_322_26 ecReturn) (implies (= EC_321_1_0_322_26_322_26 ecReturn) (not (= RES_321_1_0_322_26_322_26 null))) (= EC_321_1_0_322_3_322_3 ecReturn) (= i_321_1_0_321_36 (+ 0 1)) (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_1_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_1_321_28_321_28 T_int)) (= EC_321_1_1_321_28_321_28 ecReturn) (implies (= EC_321_1_1_321_28_321_28 ecReturn) (= RES_321_1_1_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_1_321_28))) (not (< i_321_1_0_321_36 RES_321_1_1_321_28_321_28)) (= RES_15_ RES_321_1_1_321_28_321_28))) (= L_321_1 L_321_1) (= RES_16_ RES_15_) (= EC_13_ L_321_1) (= true_term true_term) (= RES_319_26 RES_16_) (= EC_319_26 ecReturn))) (= RES_14_ RES_319_26) (= EC_12_ EC_319_26))) (= RES_17_ RES_14_) (= EC_14_ EC_12_)) (and (= true_term true_term) (= RES_273_17_273_17 CONDEXPR_24_51_7) (= true_term (is expr_263_52 T_javafe_ast_CondExpr)) (= ce_328_8 (cast expr_263_52 T_javafe_ast_CondExpr)) (not (= ce_328_8 null)) (= expr_329_1_329_1_263_52 (S_select test_68_15_28 ce_328_8)) (= EC_329_1_329_1 ecReturn) (not (= ce_328_8 null)) (= expr_330_1_330_1_263_52 (S_select thn_68_17_28 ce_328_8)) (= EC_330_1_330_1 ecReturn) (not (= ce_328_8 null)) (= expr_331_1_331_1_263_52 (S_select els_68_19_28 ce_328_8)) (= EC_331_1_331_1 ecReturn) (= true_term true_term) (= RES_17_ RES_331_1_331_1) (= EC_14_ ecReturn))) (= RES_18_ RES_17_) (= EC_15_ EC_14_)) (and (= true_term true_term) (= RES_273_17_273_17 INSTANCEOFEXPR_24_52_7) (= true_term (is expr_263_52 T_javafe_ast_InstanceOfExpr)) (= ie_337_8 (cast expr_263_52 T_javafe_ast_InstanceOfExpr)) (not (= ie_337_8 null)) (= expr_338_1_338_1_263_52 (S_select expr_69_15_28 ie_337_8)) (= EC_338_1_338_1 ecReturn) (not (= ie_337_8 null)) (= tmp23_type_339_11 (S_select type_69_18_28 ie_337_8)) (not (= sig_263_39 null)) (= resolved_339_1_339_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp23_type_339_11 null)) (= EC_339_1_339_1 ecReturn) (= true_term true_term) (= RES_18_ RES_339_1_339_1) (= EC_15_ ecReturn))) (= RES_19_ RES_18_) (= EC_16_ EC_15_)) (and (= true_term true_term) (= RES_273_17_273_17 CASTEXPR_24_53_7) (= true_term (is expr_263_52 T_javafe_ast_CastExpr)) (= ce_345_8 (cast expr_263_52 T_javafe_ast_CastExpr)) (not (= ce_345_8 null)) (= expr_346_1_346_1_263_52 (S_select expr_70_15_28 ce_345_8)) (= EC_346_1_346_1 ecReturn) (not (= ce_345_8 null)) (= tmp25_type_347_11 (S_select type_70_18_28 ce_345_8)) (not (= sig_263_39 null)) (= resolved_347_1_347_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp25_type_347_11 null)) (= EC_347_1_347_1 ecReturn) (= true_term true_term) (= RES_19_ RES_347_1_347_1) (= EC_16_ ecReturn))) (= RES_20_ RES_19_) (= EC_17_ EC_16_)) (and (= true_term true_term) (= RES_273_17_273_17 CLASSLITERAL_24_60_7) (= true_term (is expr_263_52 T_javafe_ast_ClassLiteral)) (= cl_353_8 (cast expr_263_52 T_javafe_ast_ClassLiteral)) (not (= cl_353_8 null)) (= tmp26_type_354_11 (S_select type_71_20_28 cl_353_8)) (not (= sig_263_39 null)) (= resolved_354_1_354_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp26_type_354_11 null)) (= EC_354_1_354_1 ecReturn) (= true_term true_term) (= RES_20_ RES_354_1_354_1) (= EC_17_ ecReturn))) (= RES_21_ RES_20_) (= EC_18_ EC_17_)) (and (or (and (= true_term true_term) (= RES_273_17_273_17 OR_23_19_26)) (and (= true_term true_term) (= RES_273_17_273_17 AND_23_20_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITOR_23_21_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITXOR_23_22_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITAND_23_23_26)) (and (= true_term true_term) (= RES_273_17_273_17 NE_23_24_26)) (and (= true_term true_term) (= RES_273_17_273_17 EQ_23_25_26)) (and (= true_term true_term) (= RES_273_17_273_17 GE_23_26_26)) (and (= true_term true_term) (= RES_273_17_273_17 GT_23_27_26)) (and (= true_term true_term) (= RES_273_17_273_17 LE_23_28_26)) (and (= true_term true_term) (= RES_273_17_273_17 LT_23_29_26)) (and (= true_term true_term) (= RES_273_17_273_17 LSHIFT_23_30_26)) (and (= true_term true_term) (= RES_273_17_273_17 RSHIFT_23_31_26)) (and (= true_term true_term) (= RES_273_17_273_17 URSHIFT_23_32_26)) (and (= true_term true_term) (= RES_273_17_273_17 ADD_23_33_26)) (and (= true_term true_term) (= RES_273_17_273_17 SUB_23_34_26)) (and (= true_term true_term) (= RES_273_17_273_17 DIV_23_35_26)) (and (= true_term true_term) (= RES_273_17_273_17 MOD_23_36_26)) (and (= true_term true_term) (= RES_273_17_273_17 STAR_23_37_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASSIGN_23_40_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGMUL_23_41_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGDIV_23_42_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGREM_23_43_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGADD_23_44_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGSUB_23_45_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGLSHIFT_23_46_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGRSHIFT_23_47_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGURSHIFT_23_48_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITAND_23_49_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITOR_23_50_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITXOR_23_51_26))) (= true_term (is expr_263_52 T_javafe_ast_BinaryExpr)) (= be_375_8 (cast expr_263_52 T_javafe_ast_BinaryExpr)) (not (= be_375_8 null)) (= expr_376_1_376_1_263_52 (S_select left_72_38_28 be_375_8)) (= EC_376_1_376_1 ecReturn) (not (= be_375_8 null)) (= expr_377_1_377_1_263_52 (S_select right_72_40_28 be_375_8)) (= EC_377_1_377_1 ecReturn) (= true_term true_term) (= RES_21_ RES_377_1_377_1) (= EC_18_ ecReturn))) (= RES_22_ RES_21_) (= EC_19_ EC_18_)) (and (or (and (= true_term true_term) (= RES_273_17_273_17 UNARYSUB_23_55_26)) (and (= true_term true_term) (= RES_273_17_273_17 UNARYADD_23_54_26)) (and (= true_term true_term) (= RES_273_17_273_17 NOT_23_56_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITNOT_23_57_26)) (and (= true_term true_term) (= RES_273_17_273_17 INC_23_58_26)) (and (= true_term true_term) (= RES_273_17_273_17 DEC_23_59_26)) (and (= true_term true_term) (= RES_273_17_273_17 POSTFIXINC_23_62_26)) (and (= true_term true_term) (= RES_273_17_273_17 POSTFIXDEC_23_63_26))) (= true_term (is expr_263_52 T_javafe_ast_UnaryExpr)) (not (= (cast expr_263_52 T_javafe_ast_UnaryExpr) null)) (= expr_385_6_385_6_263_52 (S_select expr_73_29_28 (cast expr_263_52 T_javafe_ast_UnaryExpr))) (= EC_385_6_385_6 ecReturn) (= true_term true_term) (= RES_22_ RES_385_6_385_6) (= EC_19_ ecReturn))) (= RES_23_ RES_22_) (= EC_20_ EC_19_)) (and (= true_term true_term) (= RES_273_17_273_17 PARENEXPR_24_54_7) (= true_term (is expr_263_52 T_javafe_ast_ParenExpr)) (not (= (cast expr_263_52 T_javafe_ast_ParenExpr) null)) (= expr_389_6_389_6_263_52 (S_select expr_74_15_28 (cast expr_263_52 T_javafe_ast_ParenExpr))) (= EC_389_6_389_6 ecReturn) (= true_term true_term) (= RES_23_ RES_389_6_389_6) (= EC_20_ ecReturn))) (= RES_24_ RES_23_) (= EC_21_ EC_20_)) (and (= true_term true_term) (= RES_273_17_273_17 AMBIGUOUSVARIABLEACCESS_24_55_7) (not (= sig_263_39 null)) (= b_393_13_393_13_17_20_40 (integralLT (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term b_393_13_393_13_17_20_40) (= EC_393_13_393_13 ecReturn) (= true_term true_term) (= RES_24_ RES_393_13_393_13) (= EC_21_ ecReturn))) (= RES_25_ RES_24_) (= EC_22_ EC_21_)) (and (= true_term true_term) (= RES_273_17_273_17 VARIABLEACCESS_24_56_7) (not (= sig_263_39 null)) (= b_397_13_397_13_17_20_40 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term b_397_13_397_13_17_20_40) (= EC_397_13_397_13 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_VariableAccess)) (not (= (cast expr_263_52 T_javafe_ast_VariableAccess) null)) (= obj_398_13_398_13_17_30_38 (S_select decl_75_26_38 (cast expr_263_52 T_javafe_ast_VariableAccess))) (not (= obj_398_13_398_13_17_30_38 null)) (= EC_398_13_398_13 ecReturn) (= true_term true_term) (= RES_25_ RES_398_13_398_13) (= EC_22_ ecReturn))) (= RES_26_ RES_25_) (= EC_23_ EC_22_)) (and (= true_term true_term) (= RES_273_17_273_17 FIELDACCESS_24_57_7) (= true_term (is expr_263_52 T_javafe_ast_FieldAccess)) (= xp_403_1 (cast expr_263_52 T_javafe_ast_FieldAccess)) (not (= xp_403_1 null)) (= od_404_1_404_1_438_73 (S_select od_76_19_40 xp_403_1)) (= EC_404_1_404_1 ecReturn) (not (= sig_263_39 null)) (or (and (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (not (= xp_403_1 null)) (= tmp33_cand_406_6 (refEQ (S_select decl_76_28_19 xp_403_1) null)) (= tmp33_cand_406_34 tmp33_cand_406_6)) (and (not (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= tmp33_cand_406_34 false_term))) (or (and (= true_term tmp33_cand_406_34) (= true_term true_term) (= tmp32_cor_407_3 true_term)) (and (not (= true_term tmp33_cand_406_34)) (not (= xp_403_1 null)) (= tmp32_cor_406_5 (refNE (S_select decl_76_28_19 xp_403_1) null)) (= tmp32_cor_407_3 tmp32_cor_406_5))) (= true_term tmp32_cor_407_3) (= EC_405_8_405_8 ecReturn) (= true_term true_term) (= RES_26_ RES_405_8_405_8) (= EC_23_ ecReturn))) (= RES_27_ RES_26_) (= EC_24_ EC_23_)) (and (= true_term true_term) (= RES_273_17_273_17 AMBIGUOUSMETHODINVOCATION_24_58_7) (not (= sig_263_39 null)) (= b_413_8_413_8_17_20_40 (integralLT (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term b_413_8_413_8_17_20_40) (= EC_413_8_413_8 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_AmbiguousMethodInvocation)) (= ami_414_1 (cast expr_263_52 T_javafe_ast_AmbiguousMethodInvocation)) (or (and (= 0 i_loopold_415_9) (= EC_413_8_413_8 EC_loopold_3_) (or (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (not (< 0 RES_415_1_0_415_29_415_29)) (= RES_28_ RES_415_1_0_415_29_415_29)) (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (< 0 RES_415_1_0_415_29_415_29) (not (= ami_414_1 null)) (= tmp36_args_415_1_0_416_18 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_416_27_416_27 T_javafe_ast_Expr)) (= true_term (isAllocated RES_415_1_0_416_27_416_27 alloc)) (= EC_415_1_0_416_27_416_27 ecReturn) (implies (= EC_415_1_0_416_27_416_27 ecReturn) (not (= RES_415_1_0_416_27_416_27 null))) (= EC_415_1_0_416_3_416_3 ecReturn) (= i_415_1_0_415_37 (+ 0 1)) (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_1_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_1_415_29_415_29 T_int)) (= EC_415_1_1_415_29_415_29 ecReturn) (implies (= EC_415_1_1_415_29_415_29 ecReturn) (= RES_415_1_1_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_1_415_29))) (not (< i_415_1_0_415_37 RES_415_1_1_415_29_415_29)) (= RES_28_ RES_415_1_1_415_29_415_29))) (not (= L_415_1 L_415_1)) (= RES_413_20 RES_28_) (= EC_413_20 L_415_1)) (and (= 0 i_loopold_415_9) (= EC_413_8_413_8 EC_loopold_3_) (or (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (not (< 0 RES_415_1_0_415_29_415_29)) (= RES_28_ RES_415_1_0_415_29_415_29)) (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (< 0 RES_415_1_0_415_29_415_29) (not (= ami_414_1 null)) (= tmp36_args_415_1_0_416_18 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_416_27_416_27 T_javafe_ast_Expr)) (= true_term (isAllocated RES_415_1_0_416_27_416_27 alloc)) (= EC_415_1_0_416_27_416_27 ecReturn) (implies (= EC_415_1_0_416_27_416_27 ecReturn) (not (= RES_415_1_0_416_27_416_27 null))) (= EC_415_1_0_416_3_416_3 ecReturn) (= i_415_1_0_415_37 (+ 0 1)) (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_1_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_1_415_29_415_29 T_int)) (= EC_415_1_1_415_29_415_29 ecReturn) (implies (= EC_415_1_1_415_29_415_29 ecReturn) (= RES_415_1_1_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_1_415_29))) (not (< i_415_1_0_415_37 RES_415_1_1_415_29_415_29)) (= RES_28_ RES_415_1_1_415_29_415_29))) (= L_415_1 L_415_1) (= RES_29_ RES_28_) (= EC_25_ L_415_1) (= true_term true_term) (= RES_413_20 RES_29_) (= EC_413_20 ecReturn))) (= RES_27_ RES_413_20) (= EC_24_ EC_413_20))) (= RES_30_ RES_27_) (= EC_26_ EC_24_)) (and (= true_term true_term) (= RES_273_17_273_17 METHODINVOCATION_24_59_7) (= true_term (is expr_263_52 T_javafe_ast_MethodInvocation)) (= mi_422_1 (cast expr_263_52 T_javafe_ast_MethodInvocation)) (not (= mi_422_1 null)) (= od_423_1_423_1_438_73 (S_select od_78_18_40 mi_422_1)) (= EC_423_1_423_1 ecReturn) (or (and (= 0 i_loopold_424_9) (= EC_423_1_423_1 EC_loopold_4_) (or (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (not (< 0 RES_424_1_0_424_28_424_28)) (= RES_6_ RES_424_1_0_424_28_424_28)) (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (< 0 RES_424_1_0_424_28_424_28) (not (= mi_422_1 null)) (= tmp41_args_424_1_0_425_18 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_425_26_425_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_424_1_0_425_26_425_26 alloc)) (= EC_424_1_0_425_26_425_26 ecReturn) (implies (= EC_424_1_0_425_26_425_26 ecReturn) (not (= RES_424_1_0_425_26_425_26 null))) (= EC_424_1_0_425_3_425_3 ecReturn) (= i_424_1_0_424_36 (+ 0 1)) (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_1_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_1_424_28_424_28 T_int)) (= EC_424_1_1_424_28_424_28 ecReturn) (implies (= EC_424_1_1_424_28_424_28 ecReturn) (= RES_424_1_1_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_1_424_28))) (not (< i_424_1_0_424_36 RES_424_1_1_424_28_424_28)) (= RES_6_ RES_424_1_1_424_28_424_28))) (not (= L_424_1 L_424_1)) (= RES_422_23 RES_6_) (= EC_422_23 L_424_1)) (and (= 0 i_loopold_424_9) (= EC_423_1_423_1 EC_loopold_4_) (or (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (not (< 0 RES_424_1_0_424_28_424_28)) (= RES_6_ RES_424_1_0_424_28_424_28)) (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (< 0 RES_424_1_0_424_28_424_28) (not (= mi_422_1 null)) (= tmp41_args_424_1_0_425_18 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_425_26_425_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_424_1_0_425_26_425_26 alloc)) (= EC_424_1_0_425_26_425_26 ecReturn) (implies (= EC_424_1_0_425_26_425_26 ecReturn) (not (= RES_424_1_0_425_26_425_26 null))) (= EC_424_1_0_425_3_425_3 ecReturn) (= i_424_1_0_424_36 (+ 0 1)) (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_1_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_1_424_28_424_28 T_int)) (= EC_424_1_1_424_28_424_28 ecReturn) (implies (= EC_424_1_1_424_28_424_28 ecReturn) (= RES_424_1_1_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_1_424_28))) (not (< i_424_1_0_424_36 RES_424_1_1_424_28_424_28)) (= RES_6_ RES_424_1_1_424_28_424_28))) (= L_424_1 L_424_1) (= RES_7_ RES_6_) (= EC_5_ L_424_1) (not (= sig_263_39 null)) (or (and (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (not (= mi_422_1 null)) (= tmp44_cand_426_18 (refEQ (S_select decl_78_34_20 mi_422_1) null)) (= tmp44_cand_427_3 tmp44_cand_426_18)) (and (not (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= tmp44_cand_427_3 false_term))) (or (and (= true_term tmp44_cand_427_3) (= true_term true_term) (= tmp43_cor_428_3 true_term)) (and (not (= true_term tmp44_cand_427_3)) (not (= mi_422_1 null)) (= tmp43_cor_426_17 (refNE (S_select decl_78_34_20 mi_422_1) null)) (= tmp43_cor_428_3 tmp43_cor_426_17))) (= true_term tmp43_cor_428_3) (= EC_426_8_426_8 ecReturn) (= true_term true_term) (= RES_422_23 RES_426_8_426_8) (= EC_422_23 ecReturn))) (= RES_30_ RES_422_23) (= EC_26_ EC_422_23))) (= EC_26_ L_273_4) (= EC_6_ EC_26_))) (= EC_267_11 ecReturn)) (and (not (= sig_263_39 null)) (or (and (>= (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (= true_term true_term) (or (and (= true_term (is expr_263_52 T_javafe_ast_Expr)) (not (= expr_263_52 null)) (= true_term true_term) (= true_term (is expr_263_52 T_javafe_ast_Expr)) (= i_270_23_270_23_62_1881_40 (cast expr_263_52 T_javafe_ast_Expr)) (not (= i_270_23_270_23_62_1881_40 null)) (= true_term (is RES_270_23_270_23 T_javafe_ast_Type)) (= true_term (isAllocated RES_270_23_270_23 alloc)) (= EC_270_23_270_23 ecReturn) (implies (= EC_270_23_270_23 ecReturn) (not (= RES_270_23_270_23 null))) (= RES RES_270_23_270_23) (= EC EC_270_23_270_23)) (and (not (and (= true_term (is expr_263_52 T_javafe_ast_Expr)) (not (= expr_263_52 null)))) (= true_term true_term) (= RES RES_1_) (= EC EC_1_))) (= RES_2_ RES) (= EC_2_ EC)) (and (not (>= (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= RES_2_ RES_1_) (= EC_2_ EC_1_))) (not (= expr_263_52 null)) (= true_term (is RES_273_17_273_17 T_int)) (= EC_273_17_273_17 ecReturn) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_LiteralExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select tag_98_32_13 (cast expr_263_52 T_javafe_ast_LiteralExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_BinaryExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select op_72_35_13 (cast expr_263_52 T_javafe_ast_BinaryExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_UnaryExpr)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select op_73_26_13 (cast expr_263_52 T_javafe_ast_UnaryExpr)))) (implies (and (= EC_273_17_273_17 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_PrimitiveType)) (not (= expr_263_52 null))) (= RES_273_17_273_17 (S_select tag_99_30_13 (cast expr_263_52 T_javafe_ast_PrimitiveType)))) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPESIG_20_6_28)) (= (PO_LT (typeof expr_263_52) T_javafe_tc_TypeSig) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 COMPILATIONUNIT_24_14_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CompilationUnit) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SINGLETYPEIMPORTDECL_24_15_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SingleTypeImportDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ONDEMANDIMPORTDECL_24_16_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_OnDemandImportDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSDECL_24_17_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTERFACEDECL_24_18_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InterfaceDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONSTRUCTORDECL_24_19_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ConstructorDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 METHODDECL_24_20_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_MethodDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INITBLOCK_24_21_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InitBlock) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LOCALVARDECL_24_22_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LocalVarDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FIELDDECL_24_23_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FieldDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FORMALPARADECL_24_24_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FormalParaDecl) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BLOCKSTMT_24_25_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BlockStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SWITCHSTMT_24_26_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SwitchStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VARDECLSTMT_24_27_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_VarDeclStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSDECLSTMT_24_28_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassDeclStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 WHILESTMT_24_29_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_WhileStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOSTMT_24_30_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_DoStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SYNCHRONIZESTMT_24_31_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SynchronizeStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EVALSTMT_24_32_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_EvalStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 RETURNSTMT_24_33_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ReturnStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 THROWSTMT_24_34_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ThrowStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BREAKSTMT_24_35_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BreakStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONTINUESTMT_24_36_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ContinueStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LABELSTMT_24_37_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LabelStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 IFSTMT_24_38_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_IfStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FORSTMT_24_39_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ForStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SKIPSTMT_24_40_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SkipStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SWITCHLABEL_24_41_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SwitchLabel) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TRYFINALLYSTMT_24_42_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TryFinallyStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TRYCATCHSTMT_24_43_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TryCatchStmt) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONSTRUCTORINVOCATION_24_44_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ConstructorInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CATCHCLAUSE_24_45_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CatchClause) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYINIT_24_46_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayInit) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 THISEXPR_24_47_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ThisExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYREFEXPR_24_48_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayRefExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NEWINSTANCEEXPR_24_49_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_NewInstanceExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NEWARRAYEXPR_24_50_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_NewArrayExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CONDEXPR_24_51_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CondExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INSTANCEOFEXPR_24_52_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_InstanceOfExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CASTEXPR_24_53_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CastExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 PARENEXPR_24_54_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ParenExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AMBIGUOUSVARIABLEACCESS_24_55_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_AmbiguousVariableAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VARIABLEACCESS_24_56_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_VariableAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FIELDACCESS_24_57_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_FieldAccess) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AMBIGUOUSMETHODINVOCATION_24_58_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_AmbiguousMethodInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 METHODINVOCATION_24_59_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_MethodInvocation) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CLASSLITERAL_24_60_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ClassLiteral) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EXPROBJECTDESIGNATOR_24_61_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ExprObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPEOBJECTDESIGNATOR_24_62_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TypeObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SUPEROBJECTDESIGNATOR_24_63_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SuperObjectDesignator) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 TYPENAME_24_64_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_TypeName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ARRAYTYPE_24_65_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_ArrayType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SIMPLENAME_24_66_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_SimpleName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 COMPOUNDNAME_24_67_7)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_CompoundName) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 OR_23_19_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 AND_23_20_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITOR_23_21_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITXOR_23_22_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITAND_23_23_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NE_23_24_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 EQ_23_25_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 GE_23_26_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 GT_23_27_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LE_23_28_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LT_23_29_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LSHIFT_23_30_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 RSHIFT_23_31_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 URSHIFT_23_32_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ADD_23_33_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SUB_23_34_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DIV_23_35_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 MOD_23_36_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 STAR_23_37_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASSIGN_23_40_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGMUL_23_41_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGDIV_23_42_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGREM_23_43_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGADD_23_44_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGSUB_23_45_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGLSHIFT_23_46_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGRSHIFT_23_47_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGURSHIFT_23_48_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITAND_23_49_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITOR_23_50_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 ASGBITXOR_23_51_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_BinaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 UNARYADD_23_54_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 UNARYSUB_23_55_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NOT_23_56_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BITNOT_23_57_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INC_23_58_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DEC_23_59_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 POSTFIXINC_23_62_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 POSTFIXDEC_23_63_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_UnaryExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BOOLEANTYPE_22_27_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTTYPE_22_28_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LONGTYPE_22_29_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CHARTYPE_22_30_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FLOATTYPE_22_31_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOUBLETYPE_22_32_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 VOIDTYPE_22_33_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NULLTYPE_22_34_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BYTETYPE_22_35_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 SHORTTYPE_22_36_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_PrimitiveType) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 BOOLEANLIT_22_38_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 INTLIT_22_39_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 LONGLIT_22_40_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 CHARLIT_22_41_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 FLOATLIT_22_42_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 DOUBLELIT_22_43_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 STRINGLIT_22_44_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (implies (and (= EC_273_17_273_17 ecReturn) (= RES_273_17_273_17 NULLLIT_22_45_26)) (= (PO_LT (typeof expr_263_52) T_javafe_ast_LiteralExpr) true_term)) (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (or (and (= true_term true_term) (= RES_273_17_273_17 ARRAYINIT_24_46_7) (= true_term (is expr_263_52 T_javafe_ast_ArrayInit)) (= ai_276_1 (cast expr_263_52 T_javafe_ast_ArrayInit)) (or (and (= EC_273_17_273_17 EC_loopold) (= 0 i_loopold_277_9) (or (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (not (< 0 RES_277_1_0_277_29_277_29)) (= RES_8_ RES_277_1_0_277_29_277_29)) (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (< 0 RES_277_1_0_277_29_277_29) (not (= ai_276_1 null)) (= tmp3_elems_277_1_0_278_18 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_278_27_278_27 T_javafe_ast_VarInit)) (= true_term (isAllocated RES_277_1_0_278_27_278_27 alloc)) (= EC_277_1_0_278_27_278_27 ecReturn) (implies (= EC_277_1_0_278_27_278_27 ecReturn) (not (= RES_277_1_0_278_27_278_27 null))) (= EC_277_1_0_278_3_278_3 ecReturn) (= i_277_1_0_277_37 (+ 0 1)) (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_1_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_1_277_29_277_29 T_int)) (= EC_277_1_1_277_29_277_29 ecReturn) (implies (= EC_277_1_1_277_29_277_29 ecReturn) (= RES_277_1_1_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_1_277_29))) (not (< i_277_1_0_277_37 RES_277_1_1_277_29_277_29)) (= RES_8_ RES_277_1_1_277_29_277_29))) (not (= L_277_1 L_277_1)) (= RES_276_16 RES_8_) (= EC_276_16 L_277_1)) (and (= EC_273_17_273_17 EC_loopold) (= 0 i_loopold_277_9) (or (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (not (< 0 RES_277_1_0_277_29_277_29)) (= RES_8_ RES_277_1_0_277_29_277_29)) (and (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_0_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_277_29_277_29 T_int)) (= EC_277_1_0_277_29_277_29 ecReturn) (implies (= EC_277_1_0_277_29_277_29 ecReturn) (= RES_277_1_0_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_0_277_29))) (< 0 RES_277_1_0_277_29_277_29) (not (= ai_276_1 null)) (= tmp3_elems_277_1_0_278_18 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_0_278_27_278_27 T_javafe_ast_VarInit)) (= true_term (isAllocated RES_277_1_0_278_27_278_27 alloc)) (= EC_277_1_0_278_27_278_27 ecReturn) (implies (= EC_277_1_0_278_27_278_27 ecReturn) (not (= RES_277_1_0_278_27_278_27 null))) (= EC_277_1_0_278_3_278_3 ecReturn) (= i_277_1_0_277_37 (+ 0 1)) (= true_term true_term) (not (= ai_276_1 null)) (= this_277_29_277_1_1_277_29 (S_select elems_63_18_34 ai_276_1)) (= true_term (is RES_277_1_1_277_29_277_29 T_int)) (= EC_277_1_1_277_29_277_29 ecReturn) (implies (= EC_277_1_1_277_29_277_29 ecReturn) (= RES_277_1_1_277_29_277_29 (S_select count_64_67_33 this_277_29_277_1_1_277_29))) (not (< i_277_1_0_277_37 RES_277_1_1_277_29_277_29)) (= RES_8_ RES_277_1_1_277_29_277_29))) (= L_277_1 L_277_1) (= RES_9_ RES_8_) (= EC_7_ L_277_1) (= true_term true_term) (= RES_276_16 RES_9_) (= EC_276_16 ecReturn))) (= RES_10_ RES_276_16) (= EC_8_ EC_276_16)) (and (or (and (= true_term true_term) (= RES_273_17_273_17 THISEXPR_24_47_7)) (and (= true_term true_term) (= RES_273_17_273_17 STRINGLIT_22_44_26)) (and (= true_term true_term) (= RES_273_17_273_17 CHARLIT_22_41_26)) (and (= true_term true_term) (= RES_273_17_273_17 BOOLEANLIT_22_38_26)) (and (= true_term true_term) (= RES_273_17_273_17 FLOATLIT_22_42_26)) (and (= true_term true_term) (= RES_273_17_273_17 DOUBLELIT_22_43_26)) (and (= true_term true_term) (= RES_273_17_273_17 INTLIT_22_39_26)) (and (= true_term true_term) (= RES_273_17_273_17 LONGLIT_22_40_26)) (and (= true_term true_term) (= RES_273_17_273_17 NULLLIT_22_45_26))) (= true_term true_term) (= RES_10_ RES_273_17_273_17) (= EC_8_ ecReturn))) (= RES_11_ RES_10_) (= EC_9_ EC_8_)) (and (= true_term true_term) (= RES_273_17_273_17 ARRAYREFEXPR_24_48_7) (= true_term (is expr_263_52 T_javafe_ast_ArrayRefExpr)) (= r_293_8 (cast expr_263_52 T_javafe_ast_ArrayRefExpr)) (not (= r_293_8 null)) (= expr_294_1_294_1_263_52 (S_select array_65_15_28 r_293_8)) (= EC_294_1_294_1 ecReturn) (not (= r_293_8 null)) (= expr_295_1_295_1_263_52 (S_select index_65_17_28 r_293_8)) (= EC_295_1_295_1 ecReturn) (= true_term true_term) (= RES_11_ RES_295_1_295_1) (= EC_9_ ecReturn))) (= RES_12_ RES_11_) (= EC_10_ EC_9_)) (and (= true_term true_term) (= RES_273_17_273_17 NEWINSTANCEEXPR_24_49_7) (= true_term (is expr_263_52 T_javafe_ast_NewInstanceExpr)) (= ne_301_8 (cast expr_263_52 T_javafe_ast_NewInstanceExpr)) (not (= ne_301_8 null)) (or (and (not (= (S_select enclosingInstance_66_25_14 ne_301_8) null)) (= true_term true_term) (not (= ne_301_8 null)) (= expr_303_5_303_5_263_52 (S_select enclosingInstance_66_25_14 ne_301_8)) (= EC_303_5_303_5 ecReturn) (= RES_3_ RES_303_5_303_5) (= EC_3_ EC_303_5_303_5)) (and (not (not (= (S_select enclosingInstance_66_25_14 ne_301_8) null))) (= true_term true_term) (= RES_3_ RES_273_17_273_17) (= EC_3_ EC_273_17_273_17))) (not (= ne_301_8 null)) (= tmp8_type_304_11 (S_select type_66_32_32 ne_301_8)) (not (= sig_263_39 null)) (= resolved_304_1_304_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp8_type_304_11 null)) (= EC_304_1_304_1 ecReturn) (or (and (= 0 i_loopold_305_9) (= EC_304_1_304_1 EC_loopold_1_) (or (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (not (< 0 RES_305_1_0_305_28_305_28)) (= RES_4_ RES_305_1_0_305_28_305_28)) (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (< 0 RES_305_1_0_305_28_305_28) (not (= ne_301_8 null)) (= tmp11_args_305_1_0_306_18 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_306_26_306_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_305_1_0_306_26_306_26 alloc)) (= EC_305_1_0_306_26_306_26 ecReturn) (implies (= EC_305_1_0_306_26_306_26 ecReturn) (not (= RES_305_1_0_306_26_306_26 null))) (= EC_305_1_0_306_3_306_3 ecReturn) (= i_305_1_0_305_36 (+ 0 1)) (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_1_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_1_305_28_305_28 T_int)) (= EC_305_1_1_305_28_305_28 ecReturn) (implies (= EC_305_1_1_305_28_305_28 ecReturn) (= RES_305_1_1_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_1_305_28))) (not (< i_305_1_0_305_36 RES_305_1_1_305_28_305_28)) (= RES_4_ RES_305_1_1_305_28_305_28))) (not (= L_305_1 L_305_1)) (= RES_301_29 RES_4_) (= EC_301_29 L_305_1)) (and (= 0 i_loopold_305_9) (= EC_304_1_304_1 EC_loopold_1_) (or (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (not (< 0 RES_305_1_0_305_28_305_28)) (= RES_4_ RES_305_1_0_305_28_305_28)) (and (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_0_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_305_28_305_28 T_int)) (= EC_305_1_0_305_28_305_28 ecReturn) (implies (= EC_305_1_0_305_28_305_28 ecReturn) (= RES_305_1_0_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_0_305_28))) (< 0 RES_305_1_0_305_28_305_28) (not (= ne_301_8 null)) (= tmp11_args_305_1_0_306_18 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_0_306_26_306_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_305_1_0_306_26_306_26 alloc)) (= EC_305_1_0_306_26_306_26 ecReturn) (implies (= EC_305_1_0_306_26_306_26 ecReturn) (not (= RES_305_1_0_306_26_306_26 null))) (= EC_305_1_0_306_3_306_3 ecReturn) (= i_305_1_0_305_36 (+ 0 1)) (= true_term true_term) (not (= ne_301_8 null)) (= this_305_28_305_1_1_305_28 (S_select args_66_34_31 ne_301_8)) (= true_term (is RES_305_1_1_305_28_305_28 T_int)) (= EC_305_1_1_305_28_305_28 ecReturn) (implies (= EC_305_1_1_305_28_305_28 ecReturn) (= RES_305_1_1_305_28_305_28 (S_select count_54_67_33 this_305_28_305_1_1_305_28))) (not (< i_305_1_0_305_36 RES_305_1_1_305_28_305_28)) (= RES_4_ RES_305_1_1_305_28_305_28))) (= L_305_1 L_305_1) (= RES_5_ RES_4_) (= EC_4_ L_305_1) (not (= ne_301_8 null)) (or (and (not (= (S_select anonDecl_66_45_19 ne_301_8) null)) (not (= sig_263_39 null)) (= tmp13_cand_308_5 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= tmp13_cand_308_23 tmp13_cand_308_5)) (and (not (not (= (S_select anonDecl_66_45_19 ne_301_8) null))) (= true_term true_term) (= tmp13_cand_308_23 false_term))) (or (and (= true_term tmp13_cand_308_23) (= true_term true_term) (not (= ne_301_8 null)) (not (= (S_select anonDecl_66_45_19 ne_301_8) null)) (= d_309_32_309_32_5_115_56 (S_select anonDecl_66_45_19 ne_301_8)) (= true_term (is RES_309_32_309_32 T_javafe_tc_TypeSig)) (= true_term (isAllocated RES_309_32_309_32 alloc)) (= EC_309_32_309_32 ecReturn) (implies (= EC_309_32_309_32 ecReturn) (not (= RES_309_32_309_32 null))) (not (= RES_309_32_309_32 null)) (= EC_309_5_309_5 ecReturn) (= RES_13_ RES_309_5_309_5) (= EC_11_ EC_309_5_309_5)) (and (not (= true_term tmp13_cand_308_23)) (= true_term true_term) (= RES_13_ RES_5_) (= EC_11_ EC_4_))) (= true_term true_term) (= RES_301_29 RES_13_) (= EC_301_29 ecReturn))) (= RES_12_ RES_301_29) (= EC_10_ EC_301_29))) (= RES_14_ RES_12_) (= EC_12_ EC_10_)) (and (= true_term true_term) (= RES_273_17_273_17 NEWARRAYEXPR_24_50_7) (= true_term (is expr_263_52 T_javafe_ast_NewArrayExpr)) (= na_319_8 (cast expr_263_52 T_javafe_ast_NewArrayExpr)) (not (= na_319_8 null)) (= tmp14_type_320_11 (S_select type_67_24_28 na_319_8)) (not (= sig_263_39 null)) (= resolved_320_1_320_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp14_type_320_11 null)) (= EC_320_1_320_1 ecReturn) (or (and (= EC_320_1_320_1 EC_loopold_2_) (= 0 i_loopold_321_9) (or (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (not (< 0 RES_321_1_0_321_28_321_28)) (= RES_15_ RES_321_1_0_321_28_321_28)) (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (< 0 RES_321_1_0_321_28_321_28) (not (= na_319_8 null)) (= tmp17_dims_321_1_0_322_18 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_322_26_322_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_321_1_0_322_26_322_26 alloc)) (= EC_321_1_0_322_26_322_26 ecReturn) (implies (= EC_321_1_0_322_26_322_26 ecReturn) (not (= RES_321_1_0_322_26_322_26 null))) (= EC_321_1_0_322_3_322_3 ecReturn) (= i_321_1_0_321_36 (+ 0 1)) (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_1_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_1_321_28_321_28 T_int)) (= EC_321_1_1_321_28_321_28 ecReturn) (implies (= EC_321_1_1_321_28_321_28 ecReturn) (= RES_321_1_1_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_1_321_28))) (not (< i_321_1_0_321_36 RES_321_1_1_321_28_321_28)) (= RES_15_ RES_321_1_1_321_28_321_28))) (not (= L_321_1 L_321_1)) (= RES_319_26 RES_15_) (= EC_319_26 L_321_1)) (and (= EC_320_1_320_1 EC_loopold_2_) (= 0 i_loopold_321_9) (or (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (not (< 0 RES_321_1_0_321_28_321_28)) (= RES_15_ RES_321_1_0_321_28_321_28)) (and (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_0_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_321_28_321_28 T_int)) (= EC_321_1_0_321_28_321_28 ecReturn) (implies (= EC_321_1_0_321_28_321_28 ecReturn) (= RES_321_1_0_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_0_321_28))) (< 0 RES_321_1_0_321_28_321_28) (not (= na_319_8 null)) (= tmp17_dims_321_1_0_322_18 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_0_322_26_322_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_321_1_0_322_26_322_26 alloc)) (= EC_321_1_0_322_26_322_26 ecReturn) (implies (= EC_321_1_0_322_26_322_26 ecReturn) (not (= RES_321_1_0_322_26_322_26 null))) (= EC_321_1_0_322_3_322_3 ecReturn) (= i_321_1_0_321_36 (+ 0 1)) (= true_term true_term) (not (= na_319_8 null)) (= this_321_28_321_1_1_321_28 (S_select dims_67_45_31 na_319_8)) (= true_term (is RES_321_1_1_321_28_321_28 T_int)) (= EC_321_1_1_321_28_321_28 ecReturn) (implies (= EC_321_1_1_321_28_321_28 ecReturn) (= RES_321_1_1_321_28_321_28 (S_select count_54_67_33 this_321_28_321_1_1_321_28))) (not (< i_321_1_0_321_36 RES_321_1_1_321_28_321_28)) (= RES_15_ RES_321_1_1_321_28_321_28))) (= L_321_1 L_321_1) (= RES_16_ RES_15_) (= EC_13_ L_321_1) (= true_term true_term) (= RES_319_26 RES_16_) (= EC_319_26 ecReturn))) (= RES_14_ RES_319_26) (= EC_12_ EC_319_26))) (= RES_17_ RES_14_) (= EC_14_ EC_12_)) (and (= true_term true_term) (= RES_273_17_273_17 CONDEXPR_24_51_7) (= true_term (is expr_263_52 T_javafe_ast_CondExpr)) (= ce_328_8 (cast expr_263_52 T_javafe_ast_CondExpr)) (not (= ce_328_8 null)) (= expr_329_1_329_1_263_52 (S_select test_68_15_28 ce_328_8)) (= EC_329_1_329_1 ecReturn) (not (= ce_328_8 null)) (= expr_330_1_330_1_263_52 (S_select thn_68_17_28 ce_328_8)) (= EC_330_1_330_1 ecReturn) (not (= ce_328_8 null)) (= expr_331_1_331_1_263_52 (S_select els_68_19_28 ce_328_8)) (= EC_331_1_331_1 ecReturn) (= true_term true_term) (= RES_17_ RES_331_1_331_1) (= EC_14_ ecReturn))) (= RES_18_ RES_17_) (= EC_15_ EC_14_)) (and (= true_term true_term) (= RES_273_17_273_17 INSTANCEOFEXPR_24_52_7) (= true_term (is expr_263_52 T_javafe_ast_InstanceOfExpr)) (= ie_337_8 (cast expr_263_52 T_javafe_ast_InstanceOfExpr)) (not (= ie_337_8 null)) (= expr_338_1_338_1_263_52 (S_select expr_69_15_28 ie_337_8)) (= EC_338_1_338_1 ecReturn) (not (= ie_337_8 null)) (= tmp23_type_339_11 (S_select type_69_18_28 ie_337_8)) (not (= sig_263_39 null)) (= resolved_339_1_339_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp23_type_339_11 null)) (= EC_339_1_339_1 ecReturn) (= true_term true_term) (= RES_18_ RES_339_1_339_1) (= EC_15_ ecReturn))) (= RES_19_ RES_18_) (= EC_16_ EC_15_)) (and (= true_term true_term) (= RES_273_17_273_17 CASTEXPR_24_53_7) (= true_term (is expr_263_52 T_javafe_ast_CastExpr)) (= ce_345_8 (cast expr_263_52 T_javafe_ast_CastExpr)) (not (= ce_345_8 null)) (= expr_346_1_346_1_263_52 (S_select expr_70_15_28 ce_345_8)) (= EC_346_1_346_1 ecReturn) (not (= ce_345_8 null)) (= tmp25_type_347_11 (S_select type_70_18_28 ce_345_8)) (not (= sig_263_39 null)) (= resolved_347_1_347_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp25_type_347_11 null)) (= EC_347_1_347_1 ecReturn) (= true_term true_term) (= RES_19_ RES_347_1_347_1) (= EC_16_ ecReturn))) (= RES_20_ RES_19_) (= EC_17_ EC_16_)) (and (= true_term true_term) (= RES_273_17_273_17 CLASSLITERAL_24_60_7) (= true_term (is expr_263_52 T_javafe_ast_ClassLiteral)) (= cl_353_8 (cast expr_263_52 T_javafe_ast_ClassLiteral)) (not (= cl_353_8 null)) (= tmp26_type_354_11 (S_select type_71_20_28 cl_353_8)) (not (= sig_263_39 null)) (= resolved_354_1_354_1_97_47 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (not (= tmp26_type_354_11 null)) (= EC_354_1_354_1 ecReturn) (= true_term true_term) (= RES_20_ RES_354_1_354_1) (= EC_17_ ecReturn))) (= RES_21_ RES_20_) (= EC_18_ EC_17_)) (and (or (and (= true_term true_term) (= RES_273_17_273_17 OR_23_19_26)) (and (= true_term true_term) (= RES_273_17_273_17 AND_23_20_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITOR_23_21_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITXOR_23_22_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITAND_23_23_26)) (and (= true_term true_term) (= RES_273_17_273_17 NE_23_24_26)) (and (= true_term true_term) (= RES_273_17_273_17 EQ_23_25_26)) (and (= true_term true_term) (= RES_273_17_273_17 GE_23_26_26)) (and (= true_term true_term) (= RES_273_17_273_17 GT_23_27_26)) (and (= true_term true_term) (= RES_273_17_273_17 LE_23_28_26)) (and (= true_term true_term) (= RES_273_17_273_17 LT_23_29_26)) (and (= true_term true_term) (= RES_273_17_273_17 LSHIFT_23_30_26)) (and (= true_term true_term) (= RES_273_17_273_17 RSHIFT_23_31_26)) (and (= true_term true_term) (= RES_273_17_273_17 URSHIFT_23_32_26)) (and (= true_term true_term) (= RES_273_17_273_17 ADD_23_33_26)) (and (= true_term true_term) (= RES_273_17_273_17 SUB_23_34_26)) (and (= true_term true_term) (= RES_273_17_273_17 DIV_23_35_26)) (and (= true_term true_term) (= RES_273_17_273_17 MOD_23_36_26)) (and (= true_term true_term) (= RES_273_17_273_17 STAR_23_37_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASSIGN_23_40_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGMUL_23_41_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGDIV_23_42_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGREM_23_43_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGADD_23_44_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGSUB_23_45_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGLSHIFT_23_46_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGRSHIFT_23_47_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGURSHIFT_23_48_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITAND_23_49_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITOR_23_50_26)) (and (= true_term true_term) (= RES_273_17_273_17 ASGBITXOR_23_51_26))) (= true_term (is expr_263_52 T_javafe_ast_BinaryExpr)) (= be_375_8 (cast expr_263_52 T_javafe_ast_BinaryExpr)) (not (= be_375_8 null)) (= expr_376_1_376_1_263_52 (S_select left_72_38_28 be_375_8)) (= EC_376_1_376_1 ecReturn) (not (= be_375_8 null)) (= expr_377_1_377_1_263_52 (S_select right_72_40_28 be_375_8)) (= EC_377_1_377_1 ecReturn) (= true_term true_term) (= RES_21_ RES_377_1_377_1) (= EC_18_ ecReturn))) (= RES_22_ RES_21_) (= EC_19_ EC_18_)) (and (or (and (= true_term true_term) (= RES_273_17_273_17 UNARYSUB_23_55_26)) (and (= true_term true_term) (= RES_273_17_273_17 UNARYADD_23_54_26)) (and (= true_term true_term) (= RES_273_17_273_17 NOT_23_56_26)) (and (= true_term true_term) (= RES_273_17_273_17 BITNOT_23_57_26)) (and (= true_term true_term) (= RES_273_17_273_17 INC_23_58_26)) (and (= true_term true_term) (= RES_273_17_273_17 DEC_23_59_26)) (and (= true_term true_term) (= RES_273_17_273_17 POSTFIXINC_23_62_26)) (and (= true_term true_term) (= RES_273_17_273_17 POSTFIXDEC_23_63_26))) (= true_term (is expr_263_52 T_javafe_ast_UnaryExpr)) (not (= (cast expr_263_52 T_javafe_ast_UnaryExpr) null)) (= expr_385_6_385_6_263_52 (S_select expr_73_29_28 (cast expr_263_52 T_javafe_ast_UnaryExpr))) (= EC_385_6_385_6 ecReturn) (= true_term true_term) (= RES_22_ RES_385_6_385_6) (= EC_19_ ecReturn))) (= RES_23_ RES_22_) (= EC_20_ EC_19_)) (and (= true_term true_term) (= RES_273_17_273_17 PARENEXPR_24_54_7) (= true_term (is expr_263_52 T_javafe_ast_ParenExpr)) (not (= (cast expr_263_52 T_javafe_ast_ParenExpr) null)) (= expr_389_6_389_6_263_52 (S_select expr_74_15_28 (cast expr_263_52 T_javafe_ast_ParenExpr))) (= EC_389_6_389_6 ecReturn) (= true_term true_term) (= RES_23_ RES_389_6_389_6) (= EC_20_ ecReturn))) (= RES_24_ RES_23_) (= EC_21_ EC_20_)) (and (= true_term true_term) (= RES_273_17_273_17 AMBIGUOUSVARIABLEACCESS_24_55_7) (not (= sig_263_39 null)) (= b_393_13_393_13_17_20_40 (integralLT (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term b_393_13_393_13_17_20_40) (= EC_393_13_393_13 ecReturn) (= true_term true_term) (= RES_24_ RES_393_13_393_13) (= EC_21_ ecReturn))) (= RES_25_ RES_24_) (= EC_22_ EC_21_)) (and (= true_term true_term) (= RES_273_17_273_17 VARIABLEACCESS_24_56_7) (not (= sig_263_39 null)) (= b_397_13_397_13_17_20_40 (integralGE (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term b_397_13_397_13_17_20_40) (= EC_397_13_397_13 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_VariableAccess)) (not (= (cast expr_263_52 T_javafe_ast_VariableAccess) null)) (= obj_398_13_398_13_17_30_38 (S_select decl_75_26_38 (cast expr_263_52 T_javafe_ast_VariableAccess))) (not (= obj_398_13_398_13_17_30_38 null)) (= EC_398_13_398_13 ecReturn) (= true_term true_term) (= RES_25_ RES_398_13_398_13) (= EC_22_ ecReturn))) (= RES_26_ RES_25_) (= EC_23_ EC_22_)) (and (= true_term true_term) (= RES_273_17_273_17 FIELDACCESS_24_57_7) (= true_term (is expr_263_52 T_javafe_ast_FieldAccess)) (= xp_403_1 (cast expr_263_52 T_javafe_ast_FieldAccess)) (not (= xp_403_1 null)) (= od_404_1_404_1_438_73 (S_select od_76_19_40 xp_403_1)) (= EC_404_1_404_1 ecReturn) (not (= sig_263_39 null)) (or (and (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (not (= xp_403_1 null)) (= tmp33_cand_406_6 (refEQ (S_select decl_76_28_19 xp_403_1) null)) (= tmp33_cand_406_34 tmp33_cand_406_6)) (and (not (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= tmp33_cand_406_34 false_term))) (or (and (= true_term tmp33_cand_406_34) (= true_term true_term) (= tmp32_cor_407_3 true_term)) (and (not (= true_term tmp33_cand_406_34)) (not (= xp_403_1 null)) (= tmp32_cor_406_5 (refNE (S_select decl_76_28_19 xp_403_1) null)) (= tmp32_cor_407_3 tmp32_cor_406_5))) (= true_term tmp32_cor_407_3) (= EC_405_8_405_8 ecReturn) (= true_term true_term) (= RES_26_ RES_405_8_405_8) (= EC_23_ ecReturn))) (= RES_27_ RES_26_) (= EC_24_ EC_23_)) (and (= true_term true_term) (= RES_273_17_273_17 AMBIGUOUSMETHODINVOCATION_24_58_7) (not (= sig_263_39 null)) (= b_413_8_413_8_17_20_40 (integralLT (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term b_413_8_413_8_17_20_40) (= EC_413_8_413_8 ecReturn) (= true_term (is expr_263_52 T_javafe_ast_AmbiguousMethodInvocation)) (= ami_414_1 (cast expr_263_52 T_javafe_ast_AmbiguousMethodInvocation)) (or (and (= 0 i_loopold_415_9) (= EC_413_8_413_8 EC_loopold_3_) (or (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (not (< 0 RES_415_1_0_415_29_415_29)) (= RES_28_ RES_415_1_0_415_29_415_29)) (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (< 0 RES_415_1_0_415_29_415_29) (not (= ami_414_1 null)) (= tmp36_args_415_1_0_416_18 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_416_27_416_27 T_javafe_ast_Expr)) (= true_term (isAllocated RES_415_1_0_416_27_416_27 alloc)) (= EC_415_1_0_416_27_416_27 ecReturn) (implies (= EC_415_1_0_416_27_416_27 ecReturn) (not (= RES_415_1_0_416_27_416_27 null))) (= EC_415_1_0_416_3_416_3 ecReturn) (= i_415_1_0_415_37 (+ 0 1)) (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_1_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_1_415_29_415_29 T_int)) (= EC_415_1_1_415_29_415_29 ecReturn) (implies (= EC_415_1_1_415_29_415_29 ecReturn) (= RES_415_1_1_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_1_415_29))) (not (< i_415_1_0_415_37 RES_415_1_1_415_29_415_29)) (= RES_28_ RES_415_1_1_415_29_415_29))) (not (= L_415_1 L_415_1)) (= RES_413_20 RES_28_) (= EC_413_20 L_415_1)) (and (= 0 i_loopold_415_9) (= EC_413_8_413_8 EC_loopold_3_) (or (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (not (< 0 RES_415_1_0_415_29_415_29)) (= RES_28_ RES_415_1_0_415_29_415_29)) (and (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_0_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_415_29_415_29 T_int)) (= EC_415_1_0_415_29_415_29 ecReturn) (implies (= EC_415_1_0_415_29_415_29 ecReturn) (= RES_415_1_0_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_0_415_29))) (< 0 RES_415_1_0_415_29_415_29) (not (= ami_414_1 null)) (= tmp36_args_415_1_0_416_18 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_0_416_27_416_27 T_javafe_ast_Expr)) (= true_term (isAllocated RES_415_1_0_416_27_416_27 alloc)) (= EC_415_1_0_416_27_416_27 ecReturn) (implies (= EC_415_1_0_416_27_416_27 ecReturn) (not (= RES_415_1_0_416_27_416_27 null))) (= EC_415_1_0_416_3_416_3 ecReturn) (= i_415_1_0_415_37 (+ 0 1)) (= true_term true_term) (not (= ami_414_1 null)) (= this_415_29_415_1_1_415_29 (S_select args_77_32_31 ami_414_1)) (= true_term (is RES_415_1_1_415_29_415_29 T_int)) (= EC_415_1_1_415_29_415_29 ecReturn) (implies (= EC_415_1_1_415_29_415_29 ecReturn) (= RES_415_1_1_415_29_415_29 (S_select count_54_67_33 this_415_29_415_1_1_415_29))) (not (< i_415_1_0_415_37 RES_415_1_1_415_29_415_29)) (= RES_28_ RES_415_1_1_415_29_415_29))) (= L_415_1 L_415_1) (= RES_29_ RES_28_) (= EC_25_ L_415_1) (= true_term true_term) (= RES_413_20 RES_29_) (= EC_413_20 ecReturn))) (= RES_27_ RES_413_20) (= EC_24_ EC_413_20))) (= RES_30_ RES_27_) (= EC_26_ EC_24_)) (and (= true_term true_term) (= RES_273_17_273_17 METHODINVOCATION_24_59_7) (= true_term (is expr_263_52 T_javafe_ast_MethodInvocation)) (= mi_422_1 (cast expr_263_52 T_javafe_ast_MethodInvocation)) (not (= mi_422_1 null)) (= od_423_1_423_1_438_73 (S_select od_78_18_40 mi_422_1)) (= EC_423_1_423_1 ecReturn) (or (and (= 0 i_loopold_424_9) (= EC_423_1_423_1 EC_loopold_4_) (or (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (not (< 0 RES_424_1_0_424_28_424_28)) (= RES_6_ RES_424_1_0_424_28_424_28)) (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (< 0 RES_424_1_0_424_28_424_28) (not (= mi_422_1 null)) (= tmp41_args_424_1_0_425_18 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_425_26_425_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_424_1_0_425_26_425_26 alloc)) (= EC_424_1_0_425_26_425_26 ecReturn) (implies (= EC_424_1_0_425_26_425_26 ecReturn) (not (= RES_424_1_0_425_26_425_26 null))) (= EC_424_1_0_425_3_425_3 ecReturn) (= i_424_1_0_424_36 (+ 0 1)) (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_1_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_1_424_28_424_28 T_int)) (= EC_424_1_1_424_28_424_28 ecReturn) (implies (= EC_424_1_1_424_28_424_28 ecReturn) (= RES_424_1_1_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_1_424_28))) (not (< i_424_1_0_424_36 RES_424_1_1_424_28_424_28)) (= RES_6_ RES_424_1_1_424_28_424_28))) (not (= L_424_1 L_424_1)) (= RES_422_23 RES_6_) (= EC_422_23 L_424_1)) (and (= 0 i_loopold_424_9) (= EC_423_1_423_1 EC_loopold_4_) (or (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (not (< 0 RES_424_1_0_424_28_424_28)) (= RES_6_ RES_424_1_0_424_28_424_28)) (and (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_0_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_424_28_424_28 T_int)) (= EC_424_1_0_424_28_424_28 ecReturn) (implies (= EC_424_1_0_424_28_424_28 ecReturn) (= RES_424_1_0_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_0_424_28))) (< 0 RES_424_1_0_424_28_424_28) (not (= mi_422_1 null)) (= tmp41_args_424_1_0_425_18 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_0_425_26_425_26 T_javafe_ast_Expr)) (= true_term (isAllocated RES_424_1_0_425_26_425_26 alloc)) (= EC_424_1_0_425_26_425_26 ecReturn) (implies (= EC_424_1_0_425_26_425_26 ecReturn) (not (= RES_424_1_0_425_26_425_26 null))) (= EC_424_1_0_425_3_425_3 ecReturn) (= i_424_1_0_424_36 (+ 0 1)) (= true_term true_term) (not (= mi_422_1 null)) (= this_424_28_424_1_1_424_28 (S_select args_78_30_31 mi_422_1)) (= true_term (is RES_424_1_1_424_28_424_28 T_int)) (= EC_424_1_1_424_28_424_28 ecReturn) (implies (= EC_424_1_1_424_28_424_28 ecReturn) (= RES_424_1_1_424_28_424_28 (S_select count_54_67_33 this_424_28_424_1_1_424_28))) (not (< i_424_1_0_424_36 RES_424_1_1_424_28_424_28)) (= RES_6_ RES_424_1_1_424_28_424_28))) (= L_424_1 L_424_1) (= RES_7_ RES_6_) (= EC_5_ L_424_1) (not (= sig_263_39 null)) (or (and (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28) (not (= mi_422_1 null)) (= tmp44_cand_426_18 (refEQ (S_select decl_78_34_20 mi_422_1) null)) (= tmp44_cand_427_3 tmp44_cand_426_18)) (and (not (< (S_select state_5_787_15 sig_263_39) CHECKED_5_776_28)) (= true_term true_term) (= tmp44_cand_427_3 false_term))) (or (and (= true_term tmp44_cand_427_3) (= true_term true_term) (= tmp43_cor_428_3 true_term)) (and (not (= true_term tmp44_cand_427_3)) (not (= mi_422_1 null)) (= tmp43_cor_426_17 (refNE (S_select decl_78_34_20 mi_422_1) null)) (= tmp43_cor_428_3 tmp43_cor_426_17))) (= true_term tmp43_cor_428_3) (= EC_426_8_426_8 ecReturn) (= true_term true_term) (= RES_422_23 RES_426_8_426_8) (= EC_422_23 ecReturn))) (= RES_30_ RES_422_23) (= EC_26_ EC_422_23))) (not (= EC_26_ L_273_4)) (= EC_267_11 EC_26_))) (not (= EC_267_11 ecReturn))))))))))
