/*
 * file: Image2D.java
 *	-- image version of Panel2D.java
 *	-- second program in Java2D
 * @author Chee Yap
 * @date July 24, 2001
 *
 ************************************************************/

// This example is an extension of graphics/MyPanel.java.
//	Read and understand that example first.
//	ACTUALLY, there is absolutely nothing new in this
//	example -- we just recast Graphics to Graphics2D.
//	Externally, there is no visible difference!
//	

import java.awt.Graphics2D;  // strictly redundant...
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// Text panel

class TextPanel extends JPanel {

  private String fn;
  private BufferedImage buff;

  // constructor
  TextPanel(String n) {
	fn = n;
	// buff = new BufferedImage(300, 200, BufferedImage.TYPE_INT_ARGB);
		// pg.29 of book, transparent image
	MediaTracker = tracker = new MediaTracker(this);
	Image defaultLoadImage = Toolkit.getDefaultToolkit().getImage(fn);
	try{
	  tracker.waitForAll();
	}catch(InterruptedException e){
	  throw new Error("could not load");
	}
  }

  // override the paintComponent method
  public void paintComponent(Graphics g) {
    Graphics2D g2 = (Graphics2D)g;
    super.paintComponent(g);
    // g.drawString("Hello Panel!", 75, 100);
    

  } //paintComponent
} //class TextPanel

class MyFrame extends JFrame {
  public MyFrame(String ti, String fn) {
	// Frame Parameters
	setTitle(ti);
	setSize(WIDTH,HEIGHT); // default size is 0,0
	setLocation(10,200); // default is 0,0 (top left corner)

	// Window Listeners
	addWindowListener(new WindowAdapter() {
	  public void windowClosing(WindowEvent e) {
		System.exit(0);
	  } //windowClosing
	}); //addWindowLister

	// Add Panels
	Container contentPane = getContentPane();
	contentPane.add(new TextPanel());
  } //constructor MyFrame
} //class MyFrame

public class Image2D {
  public static void main(String[] args) {
    String title="Image2D Demo: ";
    String imageFile="";

    if (args.length > 0) {
	imageFile = args[0];
	title += imageFile;
    }	

    JFrame f = new MyFrame(title, imageFile);
    f.show();
  } //main
} //class Panel2D


