// EmptyFrame1.java

/**
 * In EmptyFrame.java, the JFrame did not
 *	terminate, merely hides it when you choose "close" using
 *	the file menu.  You have to press "CNTL-C" in your command
 *	window to kill it.  We need to introduce a class "Terminator"
 *	to implement the "WindowListener".  Then when we close
 *	the window, an instance of this class will catch the
 *	"close" message!  However, it is tedious to implement
 *	WindowListeners as it has 7 methods to implement.  Instead
 *	Java provides the class WindowAdaptor which implements
 *	WindowListener with all 7 methods defaulted to the null
 *	implementation.  You just need to extend WindowAdaptor
 *	to implement any of the 7 methods that is relevant to you.
 *	In the present example, we only implement the windowClosing
 *	method! In the following example, we further simplify this
 *	by implementing an anonymous extension of WindowAdaptor().
 **/

import java.awt.event.*;
import javax.swing.*;

class MyFrame extends JFrame {
  public MyFrame() {
	setTitle("My Closeable Frame");
	setSize(300,200); // default size is 0,0
	setLocation(10,200); // default is 0,0 (top left corner)

	// Window Listeners
	addWindowListener(new WindowAdapter() {
	  public void windowClosing(WindowEvent e) {
		System.exit(0);
	  } //windowClosing
	}); //addWindowLister
  } //class MyFrame
}

public class EmptyFrame1 {
  public static void main(String[] args) {
    JFrame f = new MyFrame();
    f.show();
  } //main
} //class EmptyFrame


/* NOTES:
	WindowAdapter() is class that implements WindowListers
	with null methods for all the 7 methods of WindowListeners!
	It is found in java.awt.event.*.
 */
