public class Stack<T> {
  private AtomicInteger top;
  private T[] items;
  private Rooms rooms;
  private final int POP = 0;
  private final int PUSH = 1;

  public Stack(int capacity) {
    top = new AtomicInteger(0);
    items = new T[capacity];
    rooms = new Rooms(2);
  }

  public void push(T x) throws FullException {
    rooms.enter(PUSH);
    try {
      int i = top.getAndIncrement();
      if (i >= items.length) {
        top.getAndDecrement();
        throw new FullException();
      }
      items[i] = x;
    } finally {
      rooms.exit();
    }
  }

  public T pop() throws EmptyException {
    rooms.enter(POP);
    try {
      int i = top.getAndDecrement() - 1;
      if (i < 0) {
        top.getAndIncrement();
        throw new EmptyException();
      }
      return items[i];
    } finally { 
      rooms.exit();
    }
  }
}