
import java.awt.*;
import simpleGamePlatform.*;

/*
   This is not really a game, so much as a
   simple demonstration of the game platform.

   This example shows:
   -- how to create pieces,
   -- how to play an audio clip,
   -- how to detect collisions.
*/

public class game1 extends GamePlatform
{
   double X[] = { 100, 200, 100 };
   double Y[] = { 100, 100, 200 };

   public void setup() {
      int w = getWidth(), h = getHeight();

      Piece piece1 = new RectPiece();
      piece1.setBounds(400, 100, 100, 50);
      piece1.setColor(Color.red);
      setCollisionTracked(piece1);
      addPiece(piece1);

      Piece piece2 = new DiskPiece();
      piece2.setBounds(150, 200, 100, 50);
      piece2.setColor(Color.blue);
      addPiece(piece2);

      Piece piece3 = new Piece();
      piece3.setShape(X, Y, 3);
      piece3.setColor(Color.green);
      addPiece(piece3);
   }

   public void startCollision(Piece one, Piece two) {
      System.err.println("start collision " + one.getId() + " " + two.getId());
      playClip("audioclips/click.wav");
   }

   public void endCollision(Piece one, Piece two) {
      System.err.println("end collision " + one.getId() + " " + two.getId());
   }

   public void update() {
   }

   public void overlay(Graphics g) {
   }
}

