
import render.*;
import java.awt.*;

/*
   THIS IS A SIMPLE MODEL/ANIMATION OF AN ARM.
   IT WAVES WHEN THE USER CLICKS ON THE UPPER ARM.
   WE IMPLEMENTED THIS IN CLASS ON OCTOBER 24.
*/

public class test3 extends RenderApplet
{
   Material shirtColor, skinColor;
   Geometry body, shoulder, elbow, wrist;
   Geometry torso, upperArm, lowerArm, hand;
   boolean isCapturedClick = false;
   double point[] = new double[3];
   Matrix m;

   double time = 0, waveTime = -10000;

   public boolean mouseDown(Event e, int x, int y) {
      isCapturedClick = false;
      Geometry g = queryCursor(point);

      // IF CLICKING ON ARM, START WAVE ANIMATION, AND
      // CAPTURE MOUSE INPUT FOCUS UNTIL MOUSE LIFTS.

      if (g == upperArm) {
	 waveTime = time;
	 isCapturedClick = true;
	 return true;
      }

      // OTHERWISE, LET RENDER LIBRARY DO ITS USUAL VIEW ROTATION.

      return false;
   }

   public boolean mouseDrag(Event e, int x, int y) {
      if (isCapturedClick)
         return true;
      return false;
   }

   public boolean mouseUp(Event e, int x, int y) {
      if (isCapturedClick) {
         isCapturedClick = false;
         return true;
      }
      return false;
   }

   public void initialize() {
      setBgColor(.4, .5, .8);
      addLight( 1, 1, 1, .8, .85, 1);
      addLight(-1,-1,-1, 1, 1, 1);
      addLight(-1, 1, 1, .8, .85, 1);
      addLight(-1, 1,-1, .5, .5, .5);

      // "SHIRT" IS SHINY BLUE.

      shirtColor = new Material();
      shirtColor.setAmbient(0.0, 0.0, 0.2);
      shirtColor.setDiffuse(0.0, 0.0, 0.8);
      shirtColor.setSpecular(1, 1, 1, 20);

      // SKIN IS NON-SHINY PINK.

      skinColor = new Material();
      skinColor.setAmbient(0.2, 0.1, 0.1);
      skinColor.setDiffuse(0.8, 0.4, 0.4);

      // THE JOINT ANIMATION HIERARCHY, FROM BODY TO WRIST.

      body = getWorld().add();
      shoulder = body.add();
      elbow = shoulder.add();
      wrist = elbow.add();

      // VISIBLE GEOMETRY ATTACHED TO THE VARIOUS JOINTS.

      torso = body.add().sphere(16);
      torso.setMaterial(shirtColor);

      upperArm = shoulder.add().sphere(16);
      upperArm.setMaterial(skinColor);

      lowerArm = elbow.add().sphere(16);
      lowerArm.setMaterial(skinColor);

      hand = wrist.add().sphere(16);
      hand.setMaterial(skinColor);
   }

   double waveDuration = 2.0; // DURATION OF ONE WAVE ANIMATION

   public void animate(double time) {
      this.time = time;

      // THIS WAS THE FIRST THING WE TRIED.

      // double wave = Math.sin(3 * time);

      // DURING WAVE INTERVAL, wave RISES FROM -1 TO +1 AND THEN BACK DOWN AGAIN.

      double wave = -1;
      if (time >= waveTime && time <= waveTime + waveDuration)
         wave = -Math.cos((time - waveTime) / waveDuration * 2 * Math.PI);

      m = body.getMatrix();
      m.identity();

      // ANIMATE THE JOINTS

      m = shoulder.getMatrix();
      m.identity();
      m.translate(0.5, 0, 0);
      m.rotateZ(wave);

      m = elbow.getMatrix();
      m.identity();
      m.translate(1, 0, 0);
      m.rotateZ(0.5 + 0.5 * wave);

      m = wrist.getMatrix();
      m.identity();
      m.translate(1, 0, 0);
      m.rotateZ(0.5 + 0.5 * wave);

      // PLACE/SCALE THE BODY PARTS WITH RESPECT TO THEIR JOINTS.
      // NOTE HOW translate IS BEFORE scale.  ORDER IS IMPORTANT.

      m = torso.getMatrix();
      m.identity();
      m.translate(0, -0.5, 0);
      m.scale(0.7, 1, 0.3);

      // THE UPPER ARM MUSCLE BULGES WHEN THE ARM BENDS.

      double muscleBulge = 0.2 + 0.1 * (0.5 + 0.5 * wave);

      m = upperArm.getMatrix();
      m.identity();
      m.translate(0.5, 0, 0);
      m.scale(0.5, muscleBulge, muscleBulge);

      m = lowerArm.getMatrix();
      m.identity();
      m.translate(0.5, 0, 0);
      m.scale(0.5, 0.2, 0.2);

      m = hand.getMatrix();
      m.identity();
      m.translate(0.3, 0, 0);
      m.scale(0.3, 0.2, 0.2);
   }
}

