
import java.awt.*;

public class Graph
{
   int nNodes = 0, nEdges = 0;
   int nodes[][] = new int[1000][2]; // Each node has an x,y coordinate
   int edges[][] = new int[1000][2]; // Each edge indexes two nodes
   boolean nodeExists[] = new boolean[1000];
   int radius = 20;

   // ALLOW THE USER TO SET A CUSTOM RADIUS FOR THE GRAPH NODES

   public void setRadius(int r) {
     radius = r;
   }

   // ADD A NODE, GIVEN A PIXEL LOCATION

   public void addNode(int x, int y) {
      nodes[nNodes][0] = x;
      nodes[nNodes][1] = y;
      nodeExists[nNodes] = true;
      nNodes++;
   }

   // DELETE A NODE

   public void deleteNode(int n) {
      nodeExists[n] = false;
   }

   // ADD AN EDGE, GIVEN TWO NODE INDICES

   public void addEdge(int n1, int n2) {
      edges[nEdges][0] = n1;
      edges[nEdges][1] = n2;
      nEdges++;
   }

   // FIND WHICH NODE, IF ANY, CONTAINS THIS PIXEL
   // IF NO NODE CONTAINS THE PIXEL, RETURN -1

   public int nodeContaining(int x, int y) {
      for (int n = nNodes - 1 ; n >= 0 ; n--)
         if (nodeContains(n, x, y))
	    return n;
      return -1;
   }

   // DRAW THE ENTIRE GRAPH

   public void draw(Graphics g) {

      // FIRST DRAW THE EDGES

      g.setColor(Color.black);
      for (int n = 0 ; n < nEdges ; n++) {
         int n1 = edges[n][0];
         int n2 = edges[n][1];
	 for (int i = -1 ; i <= 1 ; i++)
	 for (int j = -1 ; j <= 1 ; j++)
	    g.drawLine(nodes[n1][0] + i, nodes[n1][1] + j, nodes[n2][0] + i, nodes[n2][1] + j);
      }

      // THEN DRAW THE NODES

      for (int n = 0 ; n < nNodes ; n++) {
         if (nodeExists[n]) {
            g.setColor(Color.cyan);
	    g.fillOval(nodes[n][0] - radius, nodes[n][1] - radius, 2 * radius, 2 * radius);
            g.setColor(Color.blue);
	    g.drawOval(nodes[n][0] - radius, nodes[n][1] - radius, 2 * radius, 2 * radius);
         }
      }
   }

   // DOES THIS NODE CONTAIN THIS PIXEL?

   boolean nodeContains(int n, int x, int y) {
      if (nodeExists[n]) {
         int dx = x - nodes[n][0];
         int dy = y - nodes[n][1];
         return dx * dx + dy * dy <= radius * radius;
      }
      else
         return false;
   }
}


