
/*
   This is the beginnings of a class to handle
   user gestures on the graph.  When you implement
   your own exceptions, this is the class where
   you will put code to throw those exceptions.
*/

public class GraphGesture
{
   Graph graph;

   public GraphGesture(Graph graph) {
      this.graph = graph;
   }

   public void doGesture(int x1, int y1, int x2, int y2) {
      int n1 = graph.nodeContaining(x1, y1);
      int n2 = graph.nodeContaining(x2, y2);

      if (x1 == x2 && y1 == y2) {
         if (n1 == -1)
	    graph.addNode(x1, y1);
         else
	    graph.deleteNode(n1);
      }
      else {
         if (n1 != -1 && n2 != -1) {
	    if (n1 == n2) {
	       // WE WILL NEED TO DO SOMETHING HERE
	    }
	    else {
	       graph.addEdge(n1, n2);
	    }
	 }
      }
   }
}

