
import java.awt.*;

public class Piece {
   public final static int PAWN = 0;
   public final static int PERSON = 1;
   public final static int H_WALL = 2;
   public final static int V_WALL = 3;
   public final static int GREMLIN = 4;

   public Piece(int type, Color color, Board board, int row, int col) {
      this.type = type;
      this.color = color;
      setBoard(board);
      setPosition(row, col);
      board.setPiece(row, col, this);
   }

   Color color = Color.red;
   Color faceColor = new Color(200, 255, 255);
   int row = -1, col = -1, heading = 0;
   int type = PAWN;
   Board board;
   double prevTime = 0;
   double rate = 1.0;

   public int getType() {
      return type;
   }

   public void setType(int type) {
      this.type = type;
   }

   public double getRate() {
      return rate;
   }

   public void setRate(double rate) {
      this.rate = rate;
   }

   public void setColor(Color color) {
      this.color = color;
   }

   public void setBoard(Board board) {
      this.board = board;
   }

   public boolean setPosition(int row, int col) {
      if (board.isValid(row, col) && board.getPiece(row, col) == null) {
         board.setPiece(this.row, this.col, null);
         this.row = row;
         this.col = col;
         board.setPiece(row, col, this);
	 return true;
      }
      return false;
   }

   public void update(Graphics g, double time) {
      int s = board.getSquareWidth();
      int x = s * col;
      int y = s * row;

      // BEHAVIOR

      switch (type) {
      case GREMLIN:
         if ((int)(rate * time) > (int)(rate * prevTime)) {
	    for (int i = 0 ; i < 4 ; i++) {
	       int dRow = heading == 0 ? 1 : heading == 2 ? -1 : 0;
	       int dCol = heading == 1 ? 1 : heading == 3 ? -1 : 0;
	       if (setPosition(row + dRow, col + dCol))
	          break;
               heading = (heading + 1) % 4;
	    }
	 }
         break;
      }

      // DRAWING

      g.setColor(color);

      switch (type) {
      case H_WALL:
         g.setColor(color);
         g.fill3DRect(x+1, y + s / 4, s - 2, s / 2, true);
         break;

      case V_WALL:
         g.setColor(color);
         g.fill3DRect(x + s / 4, y + 1, s / 2, s - 2, true);
         break;

      case PAWN:
         X[0] = x + s / 2;
         Y[0] = y + s / 3;

         X[1] = x + s / 4;
         Y[1] = y + s * 7 / 8;

         X[2] = x + s * 3 / 4;
         Y[2] = y + s * 7 / 8;

         g.fillPolygon(X, Y, 3);

         g.fillOval(x + s / 3, y + s / 3, s / 3, s / 3);
         break;

      case PERSON:
         X[0] = x + s / 2;
         Y[0] = y + s / 3;

         X[1] = x + s / 4;
         Y[1] = y + s * 7 / 8;

         X[2] = x + s * 3 / 4;
         Y[2] = y + s * 7 / 8;

         g.fillPolygon(X, Y, 3);

         g.fillOval(x + s / 5, y + s / 5, s * 3 / 5, s * 3 / 5);
         g.setColor(faceColor);
         g.fillOval(x + s / 4, y + s / 4, s * 2 / 4 - 2, s * 2 / 4 - 2);
         break;

      case GREMLIN:
         g.setColor(color);
         g.fillRect(x + s / 4, y + s / 4, s / 2, s / 2);
         break;
      }

      prevTime = time;
   }

   int X[] = new int[3];
   int Y[] = new int[3];
}

