
import java.awt.*;

public class Game2 extends BufferedApplet
{
   int w = 0, h = 0, downRow = -1, downCol = -1;
   Color bgColor = new Color(0, 128, 0);
   Board board = new Board(10);
   double startTime = 0, time = 0;

   public void render(Graphics g) {

      // INITIALIZE THINGS THE FIRST TIME THROUGH

      if (w == 0) {
         w = getWidth();
         h = getHeight();
	 startTime = System.currentTimeMillis() / 1000.0;

	 board.setWidth(h);
	 int nRows = board.getNRows();

         for (int n = 0 ; n < nRows ; n++)
	    new Piece(Piece.PERSON, Color.blue, board, 0, n);

         for (int n = nRows ; n < 2 * nRows ; n++)
	    new Piece(Piece.PAWN, Color.blue, board, n / nRows, n % nRows);

         for (int n = 2 * nRows ; n < 3 * nRows ; n++)
	    new Piece(Piece.H_WALL, Color.red, board, 1 + n / nRows, n % nRows);

         Piece gremlin = new Piece(Piece.GREMLIN, Color.black, board, 7, 7);
	 gremlin.setRate(3.0);
      }

      time = System.currentTimeMillis() / 1000.0 - startTime;
      respondToMouse();

      g.setColor(bgColor);
      g.fillRect(0, 0, w, h);
      board.update(g, time);
      animating = true;
   }

   void respondToMouse() {

      int nRows = board.getNRows();
      int s = board.getSquareWidth();
      int mCol = mouseX / s;
      int mRow = mouseY / s;

      // MOUSE PRESSED

      if (! wasMouseDown && mouseDown) {
         downRow = mRow;
         downCol = mCol;
	 board.select(mRow, mCol);
      }

      // MOUSE DRAGGED

      if (wasMouseDown && mouseDown)
	 board.select(mRow, mCol);

      // MOUSE RELEASED

      if (wasMouseDown && ! mouseDown) {
         if (mRow == downRow && mCol == downCol) {
	    Piece piece = board.getPiece(mRow, mCol);
	    if (piece != null)

               // CLICKING ON A WALL FLIPS ITS ORIENTATION.
               // THIS LOGIC SHOULD REALLY MOVE INTO THE OBJECT ITSELF.

	       switch (piece.getType()) {
	       case Piece.H_WALL:
	           piece.setType(Piece.V_WALL);
	           break;
	       case Piece.V_WALL:
	           piece.setType(Piece.H_WALL);
	           break;
	       }
         }
	 else {
            // DRAG A PIECE TO MOVE IT

	    Piece piece = board.getPiece(downRow, downCol);
	    if (piece != null)
	       piece.setPosition(mRow, mCol);
         }

         downCol = -1;
         downRow = -1;
	 board.unselect();
      }
   }
}

