
import java.awt.*;

public class Game1 extends BufferedApplet
{
   int NROWS = 10;
   int w = 0, h = 0, s = 0;
   Color bgColor = new Color(0, 128, 0);
   Color fgColor1 = Color.cyan;
   Color fgColor2 = new Color(128, 255, 255);
   Piece[] pieces;
   int selectedCol = -1, selectedRow = -1;
   int downCol = -1, downRow = -1;
   Piece downPiece = null;

   class Piece {
      public final static int PAWN = 0;
      public final static int PERSON = 1;
      public final static int H_WALL = 2;
      public final static int V_WALL = 3;

      Piece(int type) {
         this.type = type;
      }

      Color color = Color.red;
      Color faceColor = new Color(200, 255, 255);
      int row = -1, col = -1;
      int type = PAWN;

      public void setType(int type) {
         this.type = type;
      }

      public void setColor(Color color) {
         this.color = color;
      }

      public void setPosition(int row, int col) {
         this.row = row;
         this.col = col;
      }

      public void draw(Graphics g) {
         g.setColor(color);
	 int x = s * col;
	 int y = s * row;

	 switch (type) {
         case H_WALL:
	    g.setColor(color);
	    g.fill3DRect(x+1, y + s / 4, s - 2, s / 2, true);
	    break;

         case V_WALL:
	    g.setColor(color);
	    g.fill3DRect(x + s / 4, y + 1, s / 2, s - 2, true);
	    break;

         case PAWN:
	    X[0] = x + s / 2;
	    Y[0] = y + s / 3;

	    X[1] = x + s / 4;
	    Y[1] = y + s * 7 / 8;

	    X[2] = x + s * 3 / 4;
	    Y[2] = y + s * 7 / 8;

	    g.fillPolygon(X, Y, 3);

	    g.fillOval(x + s / 3, y + s / 3, s / 3, s / 3);
	    break;

         case PERSON:
	    X[0] = x + s / 2;
	    Y[0] = y + s / 3;

	    X[1] = x + s / 4;
	    Y[1] = y + s * 7 / 8;

	    X[2] = x + s * 3 / 4;
	    Y[2] = y + s * 7 / 8;

	    g.fillPolygon(X, Y, 3);

	    g.fillOval(x + s / 5, y + s / 5, s * 3 / 5, s * 3 / 5);
	    g.setColor(faceColor);
	    g.fillOval(x + s / 4, y + s / 4, s * 2 / 4 - 2, s * 2 / 4 - 2);
	    break;
         }
      }

      int X[] = new int[3];
      int Y[] = new int[3];
   }

   public void render(Graphics g) {

      // INITIALIZE THINGS THE FIRST TIME THROUGH

      if (w == 0) {
         w = getWidth();
         h = getHeight();
	 s = h / NROWS;

         pieces = new Piece[3 * NROWS + 1];

         for (int n = 0 ; n < NROWS ; n++) {
            pieces[n] = new Piece(Piece.PERSON);
            pieces[n].setPosition(0, n);
         }

         for (int n = NROWS ; n < 2 * NROWS ; n++) {
            pieces[n] = new Piece(Piece.PAWN);
            pieces[n].setPosition(n / NROWS, n % NROWS);
         }

         for (int n = 2 * NROWS ; n < 3 * NROWS ; n++) {
            pieces[n] = new Piece(Piece.H_WALL);
            pieces[n].setPosition(1 + n / NROWS, n % NROWS);
         }

	 pieces[pieces.length - 1] = new Piece(Piece.V_WALL);
	 pieces[pieces.length - 1].setPosition(7, 7);
	 pieces[pieces.length - 1].setColor(Color.blue);
      }

      // GET USER EVENT INFO

      int mCol = mouseX / s;
      int mRow = mouseY / s;

      // MOUSE PRESSED

      if (! wasMouseDown && mouseDown) {
         downCol = mCol;
         downRow = mRow;

	 downPiece = null;
	 for (int n = 0 ; n < pieces.length ; n++)
	    if (mCol == pieces[n].col && mRow == pieces[n].row) {
	       downPiece = pieces[n];
	       break;
	    }

         selectedCol = mCol;
         selectedRow = mRow;
      }

      // MOUSE DRAGGED

      if (wasMouseDown && mouseDown) {
         selectedCol = mCol;
         selectedRow = mRow;
      }

      // MOUSE RELEASED

      if (wasMouseDown && ! mouseDown) {
         if (mRow >= 0 && mRow < NROWS && mCol >= 0 && mCol < NROWS) {
	    for (int n = 0 ; n < pieces.length ; n++)
	       if (pieces[n].row == mRow && pieces[n].col == mCol) {
	          switch (pieces[n].type) {
		  case Piece.H_WALL:
	             pieces[n].setType(Piece.V_WALL);
		     break;
		  case Piece.V_WALL:
	             pieces[n].setType(Piece.H_WALL);
		     break;
		  }
	       }
         }
	 if (downPiece != null) {
	    downPiece.row = mRow;
	    downPiece.col = mCol;
	 }

         selectedCol = downCol = -1;
         selectedRow = downRow = -1;
      }

      // RENDER EVERYTHING

      g.setColor(bgColor);
      g.fillRect(0, 0, w, h);
      for (int row = 0 ; row < NROWS ; row++)
      for (int col = 0 ; col < NROWS ; col++) {
         g.setColor((row + col) % 2 == 0 ? fgColor1 : fgColor2);
	 int x = s * col;
	 int y = s * row;
         g.fill3DRect(x, y, s, s, ! (row == selectedRow && col == selectedCol));

	 if (row == downRow && col == downCol) {
	    g.setColor(Color.red);
            g.drawRect(x, y, s - 1, s - 1);
	 }
      }

      for (int n = 0 ; n < pieces.length ; n++)
         pieces[n].draw(g);
   }
}

