
import java.awt.*;

public class Board
{
   int nRows = 10;
   int selectedRow = -1, selectedCol = -1;
   int w, s = 0;
   Color boardColor1 = Color.cyan;
   Color boardColor2 = new Color(128, 255, 255);
   Piece[][] pieces;

   public Board() {
      this(10);
   }

   public Board(int nRows) {
      this.nRows = nRows;  
      pieces = new Piece[nRows][nRows];
   }

   public void setWidth(int w) {
      this.w = w;
      s = w / nRows;
   }

   public int getSquareWidth() {
      return s;
   }

   public int getNRows() {
      return nRows;
   }

   public boolean isValid(int row, int col) {
      return row >= 0 && row < nRows && col >= 0 && col < nRows;
   }

   public Piece getPiece(int row, int col) {
      if (isValid(row, col))
         return pieces[row][col];
      return null;
   }

   public boolean setPiece(int row, int col, Piece piece) {
      if (isValid(row, col)) {
         pieces[row][col] = piece;
	 return true;
      }
      return false;
   }

   public void unselect() {
      selectedRow = -1;
   }

   public void select(int row, int col) {
      selectedRow = row;
      selectedCol = col;
   }

   public void update(Graphics g, double time) {
      for (int row = 0 ; row < nRows ; row++)
      for (int col = 0 ; col < nRows ; col++) {
         g.setColor((row + col) % 2 == 0 ? boardColor1 : boardColor2);
	 int x = s * col;
	 int y = s * row;
         g.fill3DRect(x, y, s, s, row != selectedRow || col != selectedCol);
	 if (pieces[row][col] != null)
            pieces[row][col].update(g, time);
      }
   }
}

