/*
   Here we have added different kinds of
   exception handling.
*/

public class arith2
{
   public static void main(String[] args) {
      doIt(args);
   }

   static void doIt(String[] args) {
      int i = 0, j = 0;

      try {
         i = Integer.parseInt(args[0]);
         j = Integer.parseInt(args[1]);
      }
      catch (ArrayIndexOutOfBoundsException e) {
         System.err.println("usage: java arith2 A B");
	 return;
      }
      catch (NumberFormatException e) {
         System.err.println("arith2: one or more arguments is not numerical");
	 return;
      }

      try {
         System.err.println(i + " / " + j + " = " + (i / j));
      }
      catch (ArithmeticException e) {
         System.err.println("Warning: " + i + " / " + j + " is undefined.");
      }

      System.err.println(i + " * " + j + " = " + (i * j));
      System.err.println(i + " + " + j + " = " + (i + j));
      System.err.println(i + " - " + j + " = " + (i - j));
   }
}

