(* iteratorPartialUnboundedTrace.ml, Jacobi iteration with execution trace *)
open Interval
open Invariant
let lfp leq a f = 
  let rec iterate x =
	(match x with
     | (y1,y2,y3,y4) ->
        match y2 with
        | EMPTY -> pprint x
        | INT (a,b) -> (if (b<4) then pprint x;
                        if (b=4) then (print_string " ...";print_newline ());
                        if (b>(max_int-3)) then pprint x));
    let y = f x in
      if leq y x then (print_string " converged to fixpoint.";
                       print_newline (); x)
      else iterate y
  in iterate a;;
