function M = poly2quad(pvec,iv,v)
%M = poly2quad(p,iv,v) : given iv == x0 y0 ... denoting initial values
%   and v == x y ... denoting final values of variables in a loop body, 
%   returns the matrix M such that 
%      p(k) = (x0 y0 ... x y ... 1)M(:,:,k)(x0 y0 ... x y ... 1)'

% Author Patrick.Cousot@ens.fr, Sun Sep 12 18:46:54 CEST 2004,
% Revised 16-Nov-2004 (confusion of ranks of variables in names & [iv,v])
if (size(iv,2) ~= size(v,2))
	error('Differents sizes for variables.');
end
ivv=cell(namesofvars([iv,v])');
% disp(ivv);
n = size(v,2);
M(:,:,:) = zeros(2*n+1,2*n+1,size(pvec,1));
for pi = 1:size(pvec,1)
	% compute M(:,:,pi) of size (2n+1)^2
	for pj = 1:size(pvec,2)
		p = pvec(pi,pj);
%		disp(printpoly(p));
		if isa(p,'double')
			M(2*n+1,2*n+1,pj) = p;
%        disp(sprintf('** M(%i,%i,%i) = %g',2*n+1,2*n+1,pj,p))
		else
			LinearVariables = depends(p);
			MatrixVariables = recover(LinearVariables);
			exponent_p = full(exponents(p,MatrixVariables));
			% liste des noms de variables du polynome
			names = namesofvars(MatrixVariables)';
%			disp(names);
%        disp(exponent_p);
			if all(exponent_p(1,:)==0)
				M(2*n+1,2*n+1,pj) = full(getbasematrix(p,0));
				exponent_p = exponent_p(2:end,:);
			end
			for i = 1:size(exponent_p,1)
				if (sum(exponent_p(i,:), 2) > 2)
					error('Not a quadratic form.');
				end
				coeff = full(getbasematrixwithoutcheck(p,i));
				if (sum(exponent_p(i,:), 2) == 1)
					for j = 1:length(exponent_p(i,:))
						if (exponent_p(i,j) == 1)
							% j est le rank de la variable dans names
							lj=rankofvar(names(1,j), iv, v);
							% lj est le rank de la variable dans [iv,v]
							M(lj,2*n+1,pj) = coeff;
%							disp(sprintf('*%i* M(%i,%i,%i) = %g',j,lj,2*n+1,pj,coeff))
							break;
                	end
					end
 				elseif (sum(exponent_p(i,:), 2) == 2)
					if (ismember(2,exponent_p(i,:)))
						for j = 1:length(exponent_p(i,:))
                			if (exponent_p(i,j) == 2)
                				% j est le rank de la variable dans names
                 		      l1=rankofvar(names(1,j), iv, v);
                		      % l1 est le rank de la variable dans [iv,v]
               				M(l1,l1,pj) = coeff;
%                		      disp(sprintf('** M(%i,%i,%i) = %g',l1,l1,pj,coeff))
               				break;
                		   end
                		end
                	else
                		j=1;
                		while (j<=length(exponent_p(i,:)))&(exponent_p(i,j) == 0)
                			j = j + 1;
                		end;
                		jj = j;
                		% jj = j est le rank de la premiere variable dans names
                		l1=rankofvar(names(1,j), iv, v);
                		% l1 est le rank de la premiere variable dans [iv,v]
                		j=j+1;
                		while (j<=length(exponent_p(i,:)))&(exponent_p(i,j) == 0)
                			j = j + 1;
                		end;
                		% j est le rank de la deuxieme variable dans names
               		l2=rankofvar(names(1,j), iv, v);
                		% l2 est le rank de la deuxieme variable dans [iv,v]
                		M(l1,l2,pj) = coeff;
%                		disp(sprintf('*%i*%i* M(%i,%i,%i) = %g',jj,j,l1,l2,pj,coeff))
                	end
                end
            end
		end
		M(:,:,pj) = (M(:,:,pj)+M(:,:,pj)')/2;
	end
end

   
%******************************************************************************
% Copyright 2004  Patrick.Cousot@ens.fr
%******************************************************************************
% Permission to use, copy, modify, and distribute this software and its
% documentation for any purpose and without fee is hereby granted,
% provided that the above copyright notice appear in all copies and that
% both that the copyright notice and warranty disclaimer appear in
% supporting documentation.
% 
% P. Cousot disclaims all warranties with regard to this software,
% including all implied warranties of merchantability and fitness.  In
% no event shall P. Cousot be liable for any special, indirect or
% consequential damages or any damages whatsoever resulting from loss of
% use, data or profits, whether in an action of contract, negligence or
% other tortuous action, arising out of or in connection with the use or
% performance of this software.
%******************************************************************************
