function [diagnostic, R] = mtermination(iv, v, P, fi, lq, radius, solver, d)
% [diagnostic,R] = mtermination(x0, x, P[, fi, lq, radius, solver, d]) 
%   checks termination of loop with operational semantics
%   [B;C](x0,x)=\/i=1..K (/\k=1..P(i).N (x0 x 1) P(i).Mk(:,:,k) (x0 x 1)' >= 0 
%   /\ /\k=P(i).N+1,...,P(i).N+M (x0 x 1) P(i).Mk(:,:,k) (x0 x 1)' = 0), 
%   with optional input  arguments fi = 'float' ['int'], lq = 'quadratic' 
%   ['linear' 'linear-positive' 'quadratic-positive'] ranking function  
%   (possibly positive), rigid feasibility radius [inf=none], solver = 
%   'lmilab' ['csdp', 'sdpt3', 'sedumi', 'sdplr', ...] and minimal rank 
%   decrement d (1 by default, can also be d = sdpvar(1,1)).
%       Returns the matrix R of the ranking function r(x) = xRx' with a   
%   feasibility diagnostic on the termination proof.
if nargin < 2, error('missing arguments.'); end;
if nargin < 3, error('missing argument.'); end;
% display arguments, numerically
K = size(P,2); % number of cases i = 1,...,K
% format rational; 
format short e; 
% format long e; 
for i = 1:1:K
   % P(i).N is the number of inequality constraints in case i
	disp(sprintf('P(%i).N = %i',i,P(i).N));
	disp(sprintf('P(%i).Mk = ',i));
	disp(P(i).Mk);
end;
% and symbolically
for i = 1:1:K
	disp(sprintf('Case %i:',i)); display_Mk(P(i).Mk,P(i).N,iv,v);
end;
% optional input arguments
if nargin < 4, fi = 'float'; end; % real ranking function
if nargin < 5, lq = 'quadratic'; end;
if nargin < 6, radius = -1; end;  % no rigid feasibility radius
if nargin < 7, solver = 'lmilab'; end; % default solver
if nargin < 8, d = 1; end; % default rank decrement
n = (size(P(1).Mk,1)-1)/2; % number of program variables
if fi(1:3) == 'int'
   X = intvar(n+1,n+1); % Unkown integer ranking matrix R;
else
   X = sdpvar(n+1,n+1); % Unkown real ranking matrix R;
end;
if lq(1:3) == 'lin' % enforce linear ranking function
	X(1:n,1:n)=0;
end;
M0 = [X(1:n,1:n) zeros(n,n) X(1:n,n+1);
      zeros(n,n) zeros(n,n) zeros(n,1);
      X(n+1,1:n) zeros(1,n) X(n+1,n+1)];
M_0 = [zeros(n,n) zeros(n,n+1);
       zeros(n+1,n) X];
delta = [zeros(2*n,2*n) zeros(2*n,1);
         zeros(1,2*n) d];
F=set([]);
for i=1:1:K
  M = size(P(i).Mk,3) - P(i).N; % nb of in equality constraints
  l0(i).v = sdpvar(P(i).N+M,1); % Lagrange multipliers for r(x) >= 0;
  L0 = set([]);  % Nonnegativity of unknown Lagrange multipliers
  for k = 1:1:P(i).N % for inequality constraints;
    L0 = L0+set(sprintf('l0(%i).v(%i,1)>0',i,k));
  end;
  CP = 'M0'; % Lagrangian for constraint r(x) >= 0;
  for k = 1:1:P(i).N+M
    CP = strcat(CP,sprintf('-l0(%i).v(%i,1)*P(%i).Mk(:,:,%i)',i,k,i,k));
  end;
  CP = strcat(CP,'>0'); P_ = set(CP);
  l(i).v = sdpvar(P(i).N+M,1); % multipliers for r(x) - r(x') >= 1;
  L=set([]);        % Nonnegativity of unknown Lagrange multipliers
  for k = 1:1:P(i).N % for inequality constraints;
    L = L+set(sprintf('l(%i).v(%i,1)>0',i,k));
  end;
  CD = 'M0-M_0-delta'; % Lagrangian for constraint r(x) - r(x') >= 1
  for k = 1:1:P(i).N+M
    CD = strcat(CD,sprintf('-l(%i).v(%i,1)*P(%i).Mk(:,:,%i)',i,k,i,k));
  end;
  CD = strcat(CD,'>0'); D = set(CD);
  F = F + (P_+D+L0+L); % Gather all constraints;
 end;
llq = size(lq,2);
if ((llq >= 8) & (lq(llq-7:llq) == 'positive'))
  F = F + set('X>=0');
end
[diagnostic,R] = solveconstraints(F, X, fi, radius, solver);
disp(' '); disp(diagnostic);
R
if fi(1:3) == 'int';
   intrank (R, v)
else
   fltrank (R, v) 
end
for i=1:1:K
   M = size(P(i).Mk,3) - P(i).N; % nb of in equality constraints
   disp(sprintf('Case %i:',i));
   disp('   Lagrange multipliers for constraint r(x0) >= 0:');
   for k = 1:1:P(i).N+M % constraints; 
      disp(sprintf('      l0(%i).v(%i,1) = %+e', i, k, double(l0(i).v(k,1))));
   end;
   disp(strcat('   Lagrange multipliers for constraint r(x0) - r(x) >=',sprintf(' %d',double(d)),':'));
   for k = 1:1:P(i).N+M % constraints; 
      disp(sprintf('      l(%i).v(%i,1) = %+e', i, k, double(l(i).v(k,1))));
    end;
end

   
%******************************************************************************
% Copyright 2004  Patrick.Cousot@ens.fr
%******************************************************************************
% Permission to use, copy, modify, and distribute this software and its
% documentation for any purpose and without fee is hereby granted,
% provided that the above copyright notice appear in all copies and that
% both that the copyright notice and warranty disclaimer appear in
% supporting documentation.
% 
% P. Cousot disclaims all warranties with regard to this software,
% including all implied warranties of merchantability and fitness.  In
% no event shall P. Cousot be liable for any special, indirect or
% consequential damages or any damages whatsoever resulting from loss of
% use, data or profits, whether in an action of contract, negligence or
% other tortuous action, arising out of or in connection with the use or
% performance of this software.
%******************************************************************************
