function [nbconstraints, Mk] =  linToMk (A, A_, b) 
% [m Mk] = linToMk(A, A_, b) creates the (2n+1 x 2n+1 x m) matrix 
%   Mk such that  (x x_ 1)Mk(:,:,k)(x x_ 1)' >=/= 0 represents the 
%   [in]equality constraints (A(k,:) A_(k,:)) (x x_)' + b(k) >=/= 0,
%   k=1,...,m.
nbprogvars = size(A,2);% number of program variables.
nbconstraints = size(A,1); % number of constraints.
for k = 1:1:nbconstraints
    Mk(1:2*nbprogvars+1,1:2*nbprogvars+1,k)=[zeros(nbprogvars,2*nbprogvars) A(k,:)'/2;
                                             zeros(nbprogvars,2*nbprogvars) A_(k,:)'/2;
                                             A(k,:)/2 A_(k,:)/2 b(k)];
end;
                          
