function [] = display_Mk (Mk, N, iv, v) 
% display_Mk (Mk, N, x0, x) 
%   displays the matrix inequalities (x0 x 1) Mk (x0 x 1)' >= 0
%   for k = 1, ..., N and matrix equalities (x0 x 1) Mk (x0 x 1)' = 0
%   for k = N+1, ... where x0 and x are the list of variables before
%   and after the transformation.
if nargin < 4, error('missing argument.'); end;
n = (size(Mk,2) - 1) / 2; % number of program variables.
% N = number of linear inequalities.
iV=namesofvars(iv);
V=namesofvars(v);
M = size(Mk,3) - N; % number of linear equalities.
if size(V,1) ~= n
	error('Incorrect number of variables (%i)',n);
end;
% display inequalities (x x_ 1) Mk (x x_ 1)' >= 0
for k = 1:1:N
	I = '';
   for i = 1:1:2*n+1
   	for j = i:1:2*n+1
   		if i == 2*n+1 & j == 2*n+1 & Mk(2*n+1,2*n+1,k) ~= 0
            I = strcat(I,sprintf(' %+2i',Mk(2*n+1,2*n+1,k)));
         elseif i <= n & j == 2*n+1 & (Mk(i,2*n+1,k)+Mk(2*n+1,i,k)) ~= 0
               I = strcat(I,sprintf(' %+2i.%s',Mk(i,2*n+1,k)+Mk(2*n+1,i,k),char(iV{i})));
         elseif i > n & j == 2*n+1 & (Mk(i,2*n+1,k)+Mk(2*n+1,i,k)) ~= 0
              I = strcat(I,sprintf(' %+2i.%s',Mk(i,2*n+1,k)+Mk(2*n+1,i,k),char(V{i-n})));
  	  	   elseif i == j & i <= n & Mk(i,i,k) ~= 0
   			   I = strcat(I,sprintf(' %+2i.%s^2',pref,Mk(i,i,k),char(iV{i})));
         elseif i == j & i > n & Mk(i,i,k) ~= 0
               I = strcat(I,sprintf(' %+2i.%s^2',Mk(i,i,k),char(V{i-n})));
         elseif i <= n & j <= n & (Mk(i,j,k)+Mk(j,i,k)) ~= 0
   		      I = strcat(I,sprintf(' %+2i.%s.%s',Mk(i,j,k)+Mk(j,i,k),char(iV{i}),char(iV{j})));
   		elseif i > n & j <= n & (Mk(i,j,k)+Mk(j,i,k)) ~= 0
               I = strcat(I,sprintf(' %+2i.%s.%s',Mk(i,j,k)+Mk(j,i,k),char(V{i-n}),char(iV{j})));
         elseif i <= n & j > n & (Mk(i,j,k)+Mk(j,i,k)) ~= 0
               I = strcat(I,sprintf(' %+2i.%s.%s',Mk(i,j,k)+Mk(j,i,k),char(iV{i}),char(V{j-n})));
         elseif i > n & j > n & Mk(i,j,k)+Mk(j,i,k) ~= 0
               I = strcat(I,sprintf(' %+2i.%s.%s',Mk(i,j,k)+Mk(j,i,k),char(V{i-n}),char(V{j-n})));
         elseif Mk(j,i,k) == 0
         else	error('report bug')
   		end
      end
   end
   I = strcat(I,' >= 0');
   disp(I);
 end;
 % display equalities (x x_ 1) Mk (x x_ 1)' = 0
 for k = N+1:1:N+M
    I = '';
    for i = 1:1:2*n+1
       for j = i:1:2*n+1
   		if i == 2*n+1 & j == 2*n+1 & Mk(2*n+1,2*n+1,k) ~= 0
            I = strcat(I,sprintf(' %+2i',Mk(2*n+1,2*n+1,k)));
         elseif i <= n & j == 2*n+1 & (Mk(i,2*n+1,k)+Mk(2*n+1,i,k)) ~= 0
               I = strcat(I,sprintf(' %+2i.%s',Mk(i,2*n+1,k)+Mk(2*n+1,i,k),char(iV{i})));
         elseif i > n & j == 2*n+1 & (Mk(i,2*n+1,k)+Mk(2*n+1,i,k)) ~= 0
              I = strcat(I,sprintf(' %+2i.%s',Mk(i,2*n+1,k)+Mk(2*n+1,i,k),char(V{i-n})));
  	  	   elseif i == j & i <= n & Mk(i,i,k) ~= 0
   			   I = strcat(I,sprintf(' %+2i.%s^2',pref,Mk(i,i,k),char(iV{i})));
         elseif i == j & i > n & Mk(i,i,k) ~= 0
               I = strcat(I,sprintf(' %+2i.%s^2',Mk(i,i,k),char(V{i-n})));
         elseif i <= n & j <= n & (Mk(i,j,k)+Mk(j,i,k)) ~= 0
   		      I = strcat(I,sprintf(' %+2i.%s.%s',Mk(i,j,k)+Mk(j,i,k),char(iV{i}),char(iV{j})));
   		elseif i > n & j <= n & (Mk(i,j,k)+Mk(j,i,k)) ~= 0
               I = strcat(I,sprintf(' %+2i.%s.%s',Mk(i,j,k)+Mk(j,i,k),char(V{i-n}),char(iV{j})));
         elseif i <= n & j > n & (Mk(i,j,k)+Mk(j,i,k)) ~= 0
               I = strcat(I,sprintf(' %+2i.%s.%s',Mk(i,j,k)+Mk(j,i,k),char(iV{i}),char(V{j-n})));
         elseif i > n & j > n & Mk(i,j,k)+Mk(j,i,k) ~= 0
               I = strcat(I,sprintf(' %+2i.%s.%s',Mk(i,j,k)+Mk(j,i,k),char(V{i-n}),char(V{j-n})));
         elseif Mk(j,i,k) == 0
         else	error('report bug')
   		end
       end
    end
    I = strcat(I,' = 0');
    disp(I);
   end
   
%******************************************************************************
% Copyright 2004  Patrick.Cousot@ens.fr
%******************************************************************************
% Permission to use, copy, modify, and distribute this software and its
% documentation for any purpose and without fee is hereby granted,
% provided that the above copyright notice appear in all copies and that
% both that the copyright notice and warranty disclaimer appear in
% supporting documentation.
% 
% P. Cousot disclaims all warranties with regard to this software,
% including all implied warranties of merchantability and fitness.  In
% no event shall P. Cousot be liable for any special, indirect or
% consequential damages or any damages whatsoever resulting from loss of
% use, data or profits, whether in an action of contract, negligence or
% other tortuous action, arising out of or in connection with the use or
% performance of this software.
%******************************************************************************
