% {i+1=j,i+1=i0,N=n0,N=N0,N=n,N>=i+1,i>=0}
clear all
% variables
[iv,v] = variables('N', 'n', 'i', 'j');
% inequality constraints (Ai0 Ai)(x x') + bi >= 0.
%      N0 n0 i0 j0
Ai0 = [ 0  0  0  0;  % N>=i+1
        0  0  0  0]; % i>=0
%       N  n  i  j
Ai  = [ 1  0 -1  0;  % N>=i+1
        0  0  1  0]; % i>=0
bi  = [ -1; 0];
[Ni Mk(:,:,:)]=linToMk(Ai0, Ai, bi);
% equality constraints (Ae0 Ae)(x x') + bi = 0.
%      N0 n0 i0 j0
Ae0 = [ 0  0  0  0;  % i+1=j
        0  0 -1  0;  % i+1=i0
        0 -1  0  0;  % N=n0
       -1  0  0  0;  % N=N0
        0  0  0  0]; % N=n
%       N  n  i  j
Ae  = [ 0  0  1 -1;  % i+1=j
        0  0  1  0;  % i+1=i0
        1  0  0  0;  % N=n0
        1  0  0  0;  % N=N0
        1 -1  0  0]; % N=n
be  = [1; 1; 0; 0; 0];
[M Mk(:,:,Ni+1:Ni+M)]=linToMk(Ae0, Ae, be);
%display_Mk(Mk, Ni, iv, v);
termination(iv, v, Mk, Ni, 'integer', 'linear');
