clear all
% variables
[iv,v]=variables('i','j','n');
% {n=n0,i<=i0,j+i+1<=n+i0,i+1<=i0+j0,i+1>=i0,j+2i+1>=2i0+j0,i0>=1,n>=i0}
% linear inequalities
%      i0 j0 n0
Ai0 = [ 1  0  0; % i<=i0
        1  0  0; % j+i+1<=n+i0
        1  1  0; % i+1<=i0+j0
       -1  0  0; % i+1>=i0
       -2 -1  0; % j+2i+1>=2i0+j0
        1  0  0; % i0>=1
       -1  0  0; % n>=i0
      ];
%       i  j  n
Ai  = [-1  0  0; % i<=i0
       -1 -1  1; % j+i+1<=n+i0
       -1  0  0; % i+1<=i0+j0
        1  0  0; % i+1>=i0
        2  1  0; % j+2i+1>=2i0+j0
        0  0  0; % i0>=1
        0  0  1; % n>=i0
      ];
bi = [0; -1; -1; 1; 1; -1; 0];
% linear nequalities
%      i0 j0 n0
Ae0 = [ 0  0 -1]; % n=n0
%       i  j  n
Ae  = [ 0  0  1]; % n=n0
be = [0];
[N Mk(:,:,:)]=linToMk(Ai0, Ai, bi);
[M Mk(:,:,N+1:N+M)]=linToMk(Ae0, Ae, be);
display_Mk(Mk,N,iv,v);
termination(iv, v, Mk, N, 'integer', 'quadratic');
