clear all
% variables
[iv,v]=variables('x','y','q','r');
% linear inequalities
%      x0 y0 q0 r0
Ai0 = [ 0  0  0  0;
        0  0  0  0;
        0  0  0  0];
%       x  y  q  r
Ai  = [ 0  1  0  0;  % y - 1 >= 0
        0  0  1  0;  % q - 1 >= 0
        0  0  0  1]; % r >= 0
bi = [-1; -1; 0];
% linear equalities
%      x0  y0 q0 r0
Ae0 = [ 0  0 -1  0;  % -q0 + q -1 = 0
       -1  0  0  0;  % -x0 + x = 0
        0 -1  0  0;  % -y0 + y = 0
        0  0  0 -1]; % -r0 + y + r = 0
%       x  y  q  r
Ae  = [ 0  0  1  0;
        1  0  0  0;
        0  1  0  0;
        0  1  0  1];
be = [-1; 0; 0; 0];
[N Mk(:,:,:)]=linToMk(Ai0, Ai, bi);
[M Mk(:,:,N+1:N+M)]=linToMk(Ae0, Ae, be);
display_Mk(Mk,N,iv,v);
termination(iv, v, Mk, N, 'integer', 'linear');
