package review_fileIO;

import java.io.File;
/**
 * This class demonstrates how to use File and Scanner classes to read text
 * data from an input file.
 * 
 * @author Joanna Klukowska
 *
 */
import java.util.Scanner;

public class ReadData {
	// If the file cannot be opened the Scanner constructor throws
	// an exception. The program either has to catch it and handle it, or
	// re-throw it (as it is done in this main()).
	public static void main(String[] args) throws Exception {
		
		//create a File object (this can be done even if the file 
		//does not exist on disk)
		File file = new File("scores.txt");
		
		if (!file.exists()){
			System.err.println("No such file");
			System.exit(1);
		}

		//create a Scanner object for the file (this fails if the input
		//file does not exist on disk) 
		Scanner input = new Scanner(file);

		//read data from the input file (same methods as we used for reading
		//from the user) 
		while (input.hasNext()) {
			String firstName = input.next();
			String mi = input.next();
			String lastName = input.next();
			int score = input.nextInt();
			System.out.printf("%-10s\t%10s %1s\t%3d\n", 
					lastName,  firstName , mi,  score);
		}

		// Close the file
		input.close();
	}
}
