package review_fileIO;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;

/**
 * This program reads in a collection of names of countries and their capitals. 
 * For each country name that the user enters, it prints its capital. 
 * 
 * @author Joanna Klukowska
 *
 */
public class GuessCapitals {

	public static void main(String[] args) throws FileNotFoundException {
		
		//check if all command line arguments are there 
		if ( args.length < 2 ) {
			System.err.printf("ERROR: incorrect usage.\n\n");
			System.err.printf("Usage: java GuessCapitals inputFile outputFile\n\n" );
			System.exit(1);
		}
		
		////////////////////////////////////////////////////////
		////// PART 1: open files for input and output /////////
		////////////////////////////////////////////////////////
		
		//create a File object using the first argument (input file) 
		File fileCapitals = new File (args[0]);
		//check if the file exists on disk and is readable
		if (!fileCapitals.exists() || !fileCapitals.canRead() ) {
			System.err.printf("ERROR: cannot read file %s.\n\n", args[0]);
			System.exit(1);
		}
		//otherwise, open the file for reading using the Scanner object
		Scanner inCapitals = new Scanner ( fileCapitals );
		
		//create a File object using the second argument (output file )
		File outputCapitals = new File (args[1]);
		//check if the file exists, but cannot be written to
		if (outputCapitals.exists() && !fileCapitals.canWrite() ) {
			System.err.printf("ERROR: cannot write to file %s.\n\n", args[1]);
			System.exit(1);
		}
		//otherwise, open the file for writing using the PrintWriter object
		PrintWriter wrongGuesses = new PrintWriter(outputCapitals);
		
		

		////////////////////////////////////////////////////////
		////// PART 2: read in data from input file    /////////
		////////////////////////////////////////////////////////
		 
		//create two ArrayLists of String objects that contain names of countries 
		// and their capitals at the corresponding locations
		
		ArrayList<String> countries = new ArrayList<String> ();
		ArrayList<String> capitals = new ArrayList<String> ();
		
		while ( inCapitals.hasNext() ) {
			//the input file contains the data one per line
			//and the name of the country and its capital are separated by "-" and
			//arbitrary number of white space characters 
			
			//read the next line from file
			String line = inCapitals.nextLine();
			//split the line at "-"
			String [] names  = line.split("-");
			//if the line contains more than one dash, ignore it
			if (names.length != 2 ) continue;
			//trim the extra white space around the names of
			//the country and its capital
			names[0] = names[0].trim();
			names[1] = names[1].trim();
			//add the pair to the arrays
			countries.add( names[0] );
			capitals.add( names[1]);
		}
		//close the input file
		inCapitals.close();
		
		////////////////////////////////////////////////////////
		////// PART 3: play the guess game and write        ////
		//////         incorrect guesses to the output file ////
		////////////////////////////////////////////////////////

		String guess = "";
		
		System.out.println("For each country, guess the name of its capital.\n");
		System.out.println("Enter \"quit\" to stop the game.\n\n");
		
		Random rand = new Random();
		Scanner userInput = new Scanner (System.in);
		
		int nextCountry = 0;
		while (0 != guess.compareToIgnoreCase("quit")) {
			//randomly select country name
			nextCountry = rand.nextInt( countries.size() );
			System.out.printf("Country: %15s\n", countries.get(nextCountry));
			//get the guess from user
			System.out.printf("Cpital:  ");
			guess = userInput.next();
			
			//if guess indicates termination of the game, just
			//print a short message
			if (guess.trim().compareToIgnoreCase("quit") == 0 ) {
				System.out.printf("\nThanks for playing!\n");
			}
			//if guess is incorrect, print an error message
			//and write the pair to the output file
			else if (guess.trim().compareToIgnoreCase(capitals.get(nextCountry)) != 0 ) {
				wrongGuesses.printf("%s  -  %s\n", countries.get(nextCountry),
						         capitals.get(nextCountry));
				System.out.printf("Wrong guess. The capital is %s\n\n", capitals.get(nextCountry));
				
			}
			//otherwise, print confirmation of correctness
			else {
				System.out.printf("Good guess. \n\n");
			}
		}
		//close the output file
		wrongGuesses.close();
		//close the std input stream
		userInput.close();
	}

}
