package review_fileIO;

/**
 * This class demonstrates how to use File class to get information 
 * about files on disk.
 * 
 * @author Joanna Klukowska
 *
 */
public class TestFileClass {
  public static void main(String[] args) {
	//create a file object   
	  if (args.length == 0) {
		  System.err.println("Missing name of file");
		  System.exit(-1);
	  }
    java.io.File file = new java.io.File(args[0]);
    
    //print information about the file
    System.out.println("Does it exist? " + file.exists());
    System.out.println("The file has " + file.length() + " bytes");
    System.out.println("Can it be read? " + file.canRead());
    System.out.println("Can it be written? " + file.canWrite());
    System.out.println("Is it a directory? " + file.isDirectory());
    System.out.println("Is it a file? " + file.isFile());
    System.out.println("Is it absolute? " + file.isAbsolute());
    System.out.println("Is it hidden? " + file.isHidden());
    System.out.println("Absolute path is " + file.getAbsolutePath());
    System.out.println("Last modified on " + new java.util.Date(file.lastModified()));
  
  }
}
