/**
 * 
 */
package lecture03;

/**
 * 
 * @author Joanna Klukowska
 * @version Jan 16, 2014 
 *
 */
public interface StringList {
	
	/**
	 * Adds item to the list.  
	 * @param item
	 *    Item to be added to the list.
	 */
	void insert ( String item );
	
	/**
	 * Removes item from the list if it exists, otherwise the list
	 * remains unchanged.
	 * @param item
	 *    Item to be removed from the list.
	 */
	void remove ( String item );
	
	/**
	 * Empties the list.
	 */
	void clear ( );
	
	/**
	 * Checks if the item is on the list. 
	 * @param item
	 *    Item to be found on the list.
	 * @return
	 *    True if the item is on the list, false if it is not.
	 */
	boolean contains ( String item );
	
	/**
	 * Finds index (location) of the item on the list and returns it. 
	 * If the item is not found, -1 is returned. 
	 * @param item
	 *    Item to be found on the list.
	 * @return
	 *    Index (location) at which the item is located, 
	 *    or -1 if the item is not found.
	 */
	int indexOf ( String item );
	
	/**
	 * Returns the item at index specified. 
	 * @param index
	 *    Index of the item to return.
	 * @precondition
	 *    0 <= index <= size of list
	 * @return
	 *    The item on the list at index specified. 
	 */
	String get ( int index );
	
	/**
	 * Returns the number of items in the list.
	 * @return
	 *    Number of items in the list.
	 */
	int size ( );
	
	/**
	 * Produces a string representation of the list. Each item should be represented
	 * by a string inside double quotes and consecutive items should be separated 
	 * by commas. The list should be surrounded by square brackets. For example:
	 * ["item1", "item2", ..., "itemN"]
	 * An empty list should be printed as an empty set of square brackets: [].
	 * @return
	 *    String representation of the list.
	 */   
	String toString ();
	

}
