
package lecture03;

import java.util.Random;

/**
 * This program simulates a very fast printer (you can slow
 * it down to make it a bit more realistic if you wish). 
 * Every second a PrintJob arrives with a probability of 
 * PROBABILITY_OF_ARRIVING. 
 * PrintJobs always have between 1 and MAX_PAGES pages.
 * Each page takes TIME_TO_PRINT_PAGE second(s) to print. 
 * There is no delay between completion of one job and start 
 * of the next one (unrealistic - could be changed).
 *   
 * @author Joanna Klukowska
 * @version Feb 10, 2014 
 *
 */
public class PrintJobQueueTest {

	final static double PROBABILITY_OF_ARRIVING = 0.1;
	final static int MAX_PAGES = 15; 
	final static double TIME_TO_PRINT_PAGE = 1.0;
	
	/**
	 * @param args ignored
	 */
	public static void main(String[] args) {
		
		Random rand = new Random ();
		//characters to be used in the randomly generated user names
		String characters = "abcdefghijklmnopqrstuvwxyz";
		
		PrintJob tmp = null, current = null;
		PrintJobQueue printQueue = new PrintJobQueueArray(4);

		while ( true ) {
			//after every step wait some number of milliseconds 
			//(1000 milliseconds  = 1 second)
			try{Thread.sleep(2000);}
			catch(InterruptedException e){}
			
			//Print the contents of the queue
			System.out.printf("PrintQueue %n%s%n%n", printQueue );
			
			//create a new print job with probability of PROBABILITY_OF_ARRIVING
			if (Math.random() < PROBABILITY_OF_ARRIVING ) {
				tmp = new PrintJob ( rand.nextInt(MAX_PAGES-1)+1, 
						             generateRandomString( rand, characters, 7));
				printQueue.enqueue(tmp);
			}
			
			//check if the job at the front of the queue is finished, if not
			//the next page gets printed
			current = printQueue.peek();
			if( current!=null && !current.isCompleted())
				current.printPage();
			else if (current != null) { 
				printQueue.dequeue();
				System.out.printf("Job completed in %10d seconds%n", current.getTimeUsed() / 1000 + 1);
			}
			
		}
	}
	
	/**
	 * Generate a random String object of a specific length using
	 * predetermined character set. 
	 * @param rand
	 *   an object of class Random (the method does not allocate its own)
	 * @param characters
	 * 	 String containing set of characters that should be used 
	 *   in the randomly generated string that is returned.
	 * @param length
	 *   Length of the string to be returned.
	 * @return
	 *   String object of specified length that contains a random
	 *   sequence of characters from the set of predetermined characters.
	 */
	public static String generateRandomString(Random rand, 
			                                  String characters, 
			                                  int length)
	{
	    char[] text = new char[length];
	    for (int i = 0; i < length; i++)
	    {
	        text[i] = characters.charAt(rand.nextInt(characters.length()));
	    }
	    return new String(text);
	}

}
