
package lecture03;

/**
 * An interface for PrintJobQueue (the kind of queue that has to be 
 * maintained by a print server managing the print requests arriving
 * at a printer).
 * 
 * @author Joanna Klukowska
 * @version Feb 10, 2014 
 *
 */
public interface PrintJobQueue {
	/**
	 * Add a PrintJob object to the queue.
	 * @param item
	 *   PrintJob object to be added to the queue
	 */
	public void enqueue ( PrintJob item ) ;
	
	/**
	 * Remove and return the PrintJob object
	 * from the front of the queue
	 * @return
	 *   The PrintJob object from the front of the queue.
	 */
	public PrintJob dequeue () ;
	
	/**
	 * Return the PrintJob object
	 * from the front of the queue 
	 * (nothing is removed from the queue)
	 * @return
	 *   The PrintJob object from the front of the queue.
	 */
	public PrintJob peek () ;
	
	/**
	 * Compute a string representation of the queue. 
	 * @return
	 *    String object representing the queue. The string
	 *    should contain the current list of PrintJobs on the
	 *    queue. Each job should be on a separate line
	 *    listing the username of the user who submitted the job,
	 *    the number of pages remaining and total 
	 *    and time that the job was submitted.
	 */
	public String toString () ;
}
